/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.presigner;

import java.net.URI;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.presigner.SdkPresigner;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.internal.presigner.DefaultS3Presigner;
import software.amazon.awssdk.services.s3.presigner.model.GetObjectPresignRequest;
import software.amazon.awssdk.services.s3.presigner.model.PresignedGetObjectRequest;
import software.amazon.awssdk.services.s3.presigner.model.PresignedPutObjectRequest;
import software.amazon.awssdk.services.s3.presigner.model.PutObjectPresignRequest;

@SdkPublicApi
@Immutable
@ThreadSafe
public interface S3Presigner
extends SdkPresigner {
    public static S3Presigner create() {
        return S3Presigner.builder().build();
    }

    public static Builder builder() {
        return DefaultS3Presigner.builder();
    }

    public PresignedGetObjectRequest presignGetObject(GetObjectPresignRequest var1);

    default public PresignedGetObjectRequest presignGetObject(Consumer<GetObjectPresignRequest.Builder> request) {
        GetObjectPresignRequest.Builder builder = GetObjectPresignRequest.builder();
        request.accept(builder);
        return this.presignGetObject(builder.build());
    }

    public PresignedPutObjectRequest presignPutObject(PutObjectPresignRequest var1);

    default public PresignedPutObjectRequest presignPutObject(Consumer<PutObjectPresignRequest.Builder> request) {
        PutObjectPresignRequest.Builder builder = PutObjectPresignRequest.builder();
        request.accept(builder);
        return this.presignPutObject(builder.build());
    }

    @SdkPublicApi
    @NotThreadSafe
    public static interface Builder
    extends SdkPresigner.Builder {
        public Builder region(Region var1);

        public Builder credentialsProvider(AwsCredentialsProvider var1);

        public Builder endpointOverride(URI var1);

        public S3Presigner build();
    }
}

