/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.document.spi;

import coldfusion.document.spi.core.URLConnectionSettings;
import coldfusion.runtime.RuntimeServiceImpl;
import coldfusion.server.RuntimeService;
import coldfusion.server.ServiceFactory;
import coldfusion.wddx.Base64Encoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class HttpURLConnection
extends java.net.HttpURLConnection {
    private static final String DEFLATE_Q_0 = "deflate;q=0";
    private static final String CLOSE = "close";
    private static final String USER_AGENT = "User-Agent";
    private static final String AUTHORIZATION = "Authorization";
    private static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    private static final String TE = "TE";
    private static final String ACCEPT_ENCODING = "Accept-Encoding";
    private static final String CONNECTION = "Connection";
    private CloseableHttpClient dhConn = null;
    private HttpClientBuilder clientBuilder;
    private RequestConfig.Builder requestBuilder;
    public static ThreadLocal<URLConnectionSettings> urlConnSetting = new ThreadLocal();
    private static int defaultTimeOut = 180;
    private HttpResponse resp = null;
    private Hashtable<String, String> header_data = null;
    private URL url = null;
    private HttpContext localContext = null;

    @Override
    public boolean usingProxy() {
        URLConnectionSettings setting = urlConnSetting.get();
        if (setting == null) {
            return false;
        }
        return setting.getProxyHost() != null;
    }

    @Override
    public void disconnect() {
        try {
            this.dhConn.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void connect() throws IOException {
        HttpGet x = new HttpGet(this.url.toString());
        Enumeration<String> e = this.header_data.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            String valueaAtKey = this.header_data.get(key);
            x.addHeader(key, valueaAtKey);
        }
        URLConnectionSettings setting = urlConnSetting.get();
        if (setting != null && setting.getProxyHost() != null) {
            HttpHost proxy = new HttpHost(setting.getProxyHost(), setting.getProxyPort());
            x.setConfig(RequestConfig.custom().setProxy(proxy).build());
        }
        this.resp = this.dhConn.execute((HttpUriRequest)x, this.localContext);
    }

    public static void setCurrentConnectionSettings(URLConnectionSettings settings) {
        urlConnSetting.set(settings);
    }

    public HttpURLConnection(URL url) {
        super(url);
        this.setURL(url);
        this.clientBuilder = HttpClientBuilder.create();
        this.requestBuilder = RequestConfig.custom();
        this.localContext = new BasicHttpContext();
        this.header_data = new Hashtable();
        this.setupConnectionProperties();
        this.setupAuthorization();
        this.dhConn = this.clientBuilder.setDefaultRequestConfig(this.requestBuilder.build()).build();
    }

    private void setupConnectionProperties() {
        this.setInstanceFollowRedirects(true);
        this.setRequestProperty(CONNECTION, CLOSE);
        this.header_data.put(CONNECTION, CLOSE);
        this.setRequestProperty(ACCEPT_ENCODING, DEFLATE_Q_0);
        this.header_data.put(ACCEPT_ENCODING, DEFLATE_Q_0);
        this.setRequestProperty(TE, DEFLATE_Q_0);
        this.header_data.put(TE, DEFLATE_Q_0);
        int timeout = defaultTimeOut;
        try {
            RuntimeService runtimeService = ServiceFactory.getRuntimeService();
            if (runtimeService.timeoutRequests()) {
                timeout = (int)runtimeService.getRequestTimeoutLimit();
                timeout = timeout > 0 ? timeout : defaultTimeOut;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.requestBuilder.setSocketTimeout(timeout *= 1000);
    }

    private void setupAuthorization() {
        URLConnectionSettings setting = urlConnSetting.get();
        if (setting == null) {
            return;
        }
        String charset = RuntimeServiceImpl.getDefaultCharset();
        String proxyUser = setting.getProxyUser();
        if (proxyUser != null) {
            String proxyPassword = setting.getProxyPassword();
            String auth = proxyPassword == null ? proxyUser : proxyUser + ":" + proxyPassword;
            try {
                this.setRequestProperty(PROXY_AUTHORIZATION, "Basic " + Base64Encoder.encode((byte[])auth.getBytes(charset)));
                this.header_data.put(PROXY_AUTHORIZATION, "Basic " + Base64Encoder.encode((byte[])auth.getBytes(charset)));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        String userName = setting.getAuthUserName();
        String password = setting.getAuthPassword();
        try {
            if (userName != null && password != null) {
                this.setRequestProperty(AUTHORIZATION, "Basic " + Base64Encoder.encode((byte[])(userName + ":" + password).getBytes(charset)));
                this.header_data.put(AUTHORIZATION, "Basic " + Base64Encoder.encode((byte[])(userName + ":" + password).getBytes(charset)));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String userAgent = setting.getUserAgent();
        if (userAgent != null) {
            this.setRequestProperty(USER_AGENT, userAgent);
            this.header_data.put(USER_AGENT, userAgent);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.resp.getEntity() != null) {
            return this.resp.getEntity().getContent();
        }
        return null;
    }

    @Override
    public int getContentLength() {
        if (this.resp.getEntity() != null) {
            return (int)this.resp.getEntity().getContentLength();
        }
        return -1;
    }

    public void setURL(URL u) {
        this.url = u;
    }
}

