/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.document;

import coldfusion.document.SlideData;
import coldfusion.util.XmlUtils;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BreezeSearchXmlBuilder {
    private Document document;
    private Element root;
    private static final String DOCUMENT_METADATA = "document-metadata";
    private static final String DOCUMENT_INFO = "document-info";
    private static final String SECTION = "section";
    private int count = 0;
    private File file;

    public BreezeSearchXmlBuilder(File file) throws ParserConfigurationException {
        this.file = file;
        this.document = XmlUtils.createNewDocument();
        this.root = this.document.createElement(DOCUMENT_METADATA);
        this.document.appendChild(this.root);
        this.root.setAttribute("version", "1.0");
    }

    public void setDocumentInfo(String title, String summary, String keywords) {
        Element docInfo = XmlUtils.addNode((Element)this.root, (String)DOCUMENT_INFO);
        XmlUtils.addTextNode((Element)docInfo, (String)"title", (String)title);
        summary = summary == null ? "" : summary;
        XmlUtils.addTextNode((Element)docInfo, (String)"summary", (String)summary);
        keywords = keywords == null ? "" : keywords;
        XmlUtils.addTextNode((Element)docInfo, (String)"keywords", (String)keywords);
        Element vLink = XmlUtils.addNode((Element)docInfo, (String)"view-link");
        vLink.setAttribute("href", "/Viewer.swf?slide={position}");
    }

    public void addSlide(SlideData slideData) {
        Element section = XmlUtils.addNode((Element)this.root, (String)SECTION);
        section.setAttribute("type", "slide");
        section.setAttribute("position", "" + ++this.count);
        XmlUtils.addTextNode((Element)section, (String)"title", (String)slideData.getTitle());
        XmlUtils.addTextNode((Element)section, (String)"content", (String)slideData.getTextContent());
        XmlUtils.addTextNode((Element)section, (String)"related-content", (String)slideData.getNotes());
    }

    public void save() throws IOException {
        XmlUtils.saveDocument((Document)this.document, (File)this.file);
    }
}

