/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.pdf;

import coldfusion.pdf.PDFDocOperation;
import coldfusion.pdf.core.PDFException;
import coldfusion.util.CFDumpable;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import java.util.Map;

public class PDFDocWrapper
implements CFDumpable {
    private PDFDocument mDoc;
    private String mPassword;
    private PDFDocOperation pdfOperation;
    private Map argsPortfolio = null;
    private String calledSource = null;
    private String filePath = null;

    public PDFDocWrapper(PDFDocument doc, String password, PDFDocOperation operation) {
        this.mDoc = doc;
        this.mPassword = password;
        this.pdfOperation = operation;
    }

    public PDFDocWrapper(Object doc, String password, PDFDocOperation operation, Map args, String calledStr) {
        if (doc instanceof PDFDocument) {
            this.mDoc = (PDFDocument)doc;
        } else {
            this.filePath = (String)doc;
        }
        this.mPassword = password;
        this.pdfOperation = operation;
        this.argsPortfolio = args;
        this.calledSource = calledStr;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public Map getArgsPortfolio() {
        return this.argsPortfolio;
    }

    public String getCalledSource() {
        return this.calledSource;
    }

    public PDFDocument getDoc() {
        return this.mDoc;
    }

    public void setDoc(PDFDocument mDoc) {
        this.mDoc = mDoc;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public void setPassword(String mPassword) {
        this.mPassword = mPassword;
    }

    public String getLabel() {
        return "PDFDocument";
    }

    public Object getMetadata() {
        return this.pdfOperation.getInfo(this.mDoc, this.mPassword, true);
    }

    public static PDFDocWrapper deepCopy(PDFDocWrapper source, String passwd) {
        PDFDocWrapper newDocWrap;
        if (passwd == null) {
            passwd = source.getPassword();
        }
        try {
            byte[] newByte = (byte[])source.pdfOperation.getSourceAsByte(source, passwd);
            PDFDocument newDoc = source.pdfOperation.getPdfDocHandler().readInternal(passwd, (Object)newByte, false, false);
            newDocWrap = new PDFDocWrapper(newDoc, passwd, source.pdfOperation);
            source.setDoc(source.pdfOperation.getPdfDocHandler().readInternal(source.getPassword(), (Object)newByte, false, false));
        }
        catch (Exception ex) {
            throw new PDFException.PDFInvalidSourceException(ex.getLocalizedMessage());
        }
        return newDocWrap;
    }

    public static byte[] deepCopyByte(PDFDocWrapper source, String passwd) {
        byte[] newByte;
        if (passwd == null) {
            passwd = source.getPassword();
        }
        try {
            newByte = (byte[])source.pdfOperation.getSourceAsByte(source, passwd);
            source.setDoc(source.pdfOperation.getPdfDocHandler().readInternal(source.getPassword(), (Object)newByte, false, false));
        }
        catch (Exception ex) {
            throw new PDFException.PDFInvalidSourceException(ex.getLocalizedMessage());
        }
        return newByte;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PDFDocWrapper)) {
            return false;
        }
        PDFDocument objPDFDoc = ((PDFDocWrapper)obj).getDoc();
        if (objPDFDoc == null || this.mDoc == null) {
            return false;
        }
        return this == obj || objPDFDoc.equals(this.mDoc);
    }

    public int hashCode() {
        if (this.mDoc != null) {
            return this.mDoc.hashCode();
        }
        return super.hashCode();
    }
}

