/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.inmemory.module;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.active.ActiveRequestMonitor;
import coldfusion.monitor.active.TemplateCacheMonitor;
import coldfusion.monitor.error.RequestErrorMonitor;
import coldfusion.monitor.es.ElasticSearchClient;
import coldfusion.monitor.inmemory.TimingRequestMonitor;
import coldfusion.monitor.memory.MemoryMonitor;
import coldfusion.monitor.memory.MemoryTrackerProxy;
import coldfusion.monitor.sql.JDBCPoolMonitor;
import coldfusion.monitor.sql.QueryMonitor;
import coldfusion.monitor.throttle.RequestThrottleMonitor;
import coldfusion.monitor.util.CFthreadDictionary;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.InMemoryMonitoringServiceException;
import coldfusion.runtime.Scope;
import coldfusion.runtime.SessionKeyObject;
import coldfusion.runtime.SessionScope;
import coldfusion.runtime.SessionTracker;
import coldfusion.runtime.Struct;
import coldfusion.server.InMemoryMonitoringService;
import coldfusion.server.SchedulerService;
import coldfusion.server.ServiceBase;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.util.SoftCache;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class InMemoryMonitoringServiceImpl
extends ServiceBase
implements InMemoryMonitoringService {
    private boolean isEnabled = false;
    private boolean isStarted = false;
    private boolean isMemoryMonitoringEnabled = false;
    private boolean isProfilingEnabled = false;
    private String serverIPAddress;
    private Date serverStartedAt = new Date();
    private Date stateChangedAt = new Date();
    private String localeString = Locale.getDefault().getLanguage();
    private SchedulerService ss = ServiceFactory.getSchedulerService();
    private HashMap scheduledTasks = new HashMap();
    private Logger logger = CFLogs.SERVER_LOG;

    public InMemoryMonitoringServiceImpl() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            this.serverIPAddress = localHost.getHostAddress();
        }
        catch (UnknownHostException e) {
            this.logger.warn((Object)"Monitoring Service: Unable to determine server IP address.", (Throwable)e);
            this.serverIPAddress = "";
        }
    }

    public void setInterval(long interval) {
        TimingRequestMonitor.INSTANCE.setInterval(interval);
    }

    public void start() throws ServiceException {
        super.start();
    }

    public void stop() throws ServiceException {
        super.stop();
        this.stopMonitoring();
        TimingRequestMonitor.INSTANCE.load((InMemoryMonitoringService)this, false);
    }

    public Map getMonitorStatus() {
        Struct status = new Struct();
        status.put((Object)"SERVERIPADDRESS", (Object)this.serverIPAddress);
        status.put((Object)"SERVERSTARTTIME", (Object)this.serverStartedAt);
        status.put((Object)"ISENABLED", (Object)this.isEnabled);
        status.put((Object)"ISMEMORYMONITORINGENABLED", (Object)this.isMemoryMonitoringEnabled());
        status.put((Object)"ISPROFILINGENABLED", (Object)this.isProfilingEnabled());
        status.put((Object)"STATECHANGEDAT", (Object)this.stateChangedAt);
        status.put((Object)"CURRENTSERVERTIME", (Object)new Date());
        status.put((Object)"SERVERLOCALE", (Object)this.localeString);
        return status;
    }

    public void startMonitoring() throws InMemoryMonitoringServiceException {
        if (this.isEnabled) {
            return;
        }
        if (ElasticSearchClient.INSTANCE.isInitialized()) {
            CFLogs.SERVER_LOG.error((Object)"Performance Monitoring Toolset is already configured and is running in this ColdFusion instance. Therefore, ColdFusion is unable to start In-Memory monitoring service.");
            throw new InMemoryMonitoringServiceException("Performance Monitoring Toolset is already configured and is running in this ColdFusion instance. Therefore, ColdFusion is unable to start In-Memory monitoring service.");
        }
        SoftCache.setStatsEnabled((boolean)true);
        this.setMonitoringEnabled(true);
        if (!this.isStarted) {
            TimingRequestMonitor.INSTANCE.load((InMemoryMonitoringService)this, true);
            this.isStarted = true;
        }
    }

    public void stopMonitoring() {
        if (!this.isEnabled) {
            return;
        }
        SoftCache.setStatsEnabled((boolean)false);
        this.setMonitoringEnabled(false);
        this.disableMemoryMonitoring();
        this.disableProfiling();
    }

    public boolean isMonitoringEnabled() {
        return this.isEnabled;
    }

    private void setMonitoringEnabled(boolean enable) {
        this.isEnabled = enable;
        this.stateChangedAt = new Date();
    }

    public boolean isMemoryMonitoringEnabled() {
        return this.isMemoryMonitoringEnabled;
    }

    public void enableMemoryMonitoring() {
        this.isMemoryMonitoringEnabled = true;
        MemoryMonitor.getInstance();
        MemoryMonitor.setEnabled((boolean)true);
        this.onMonitoringEnabled();
    }

    public void disableMemoryMonitoring() {
        this.isMemoryMonitoringEnabled = false;
        MemoryMonitor.getInstance();
        MemoryMonitor.setEnabled((boolean)false);
        this.onMonitoringDisabled();
    }

    public boolean isProfilingEnabled() {
        return this.isProfilingEnabled;
    }

    public void enableProfiling() {
        this.isProfilingEnabled = true;
    }

    public void disableProfiling() {
        this.isProfilingEnabled = false;
    }

    public List getDbPoolStats() {
        return JDBCPoolMonitor.getInstance().getInMemoryDbPoolStats();
    }

    public Map getHitCountStats() {
        return TimingRequestMonitor.INSTANCE.getHitCountStats();
    }

    public Map getHeartBeat() {
        Struct quickSnapShot = new Struct();
        Map allStats = ActiveRequestMonitor.INSTANCE.getRequestQueueStats();
        quickSnapShot.put("req_queued", allStats.get("req_queued"));
        quickSnapShot.put("req_running", allStats.get("req_running"));
        quickSnapShot.put("req_timeout", new Long(RequestErrorMonitor.INSTANCE.getTimedOutRequestsCount()));
        quickSnapShot.put("REQPERSEC", new Double(TimingRequestMonitor.INSTANCE.getRequestLoad()));
        quickSnapShot.put("AVGTIME", new Double(TimingRequestMonitor.INSTANCE.getAverageResponseTime()));
        quickSnapShot.put("ALLREQERRORCOUNT", new Double(RequestErrorMonitor.INSTANCE.getRequestErrorsCount()));
        quickSnapShot.put("SERVERUPTIME", new Long(new Date().getTime() - this.serverStartedAt.getTime()));
        Map map = this.getJVMMemoryStats();
        quickSnapShot.put("FREEMEMORY", map.get("FREEMEMORY"));
        quickSnapShot.put("USEDMEMORY", map.get("USEDMEMORY"));
        return quickSnapShot;
    }

    public Map getCFThreadQueueStats() {
        return ActiveRequestMonitor.getInstance().getCFThreadQueueStats();
    }

    public Map getCurrentThrottleStats() {
        return RequestThrottleMonitor.getInstance().getCurrentThrottleStats();
    }

    public Map getQueryCacheStats() {
        return QueryMonitor.getInstance().getQueryCacheStats();
    }

    public Map getTemplateCacheStats() {
        return TemplateCacheMonitor.getTemplateCacheStats();
    }

    public Map getMemoryUtilizationSummary() {
        return MemoryMonitor.getInstance().getMemoryUtilizationSummary();
    }

    public Map getJVMMemoryStats() {
        Struct map = new Struct();
        Runtime runtime = Runtime.getRuntime();
        long freeMemory = runtime.freeMemory();
        map.put("USEDMEMORY", new Long(runtime.totalMemory() - freeMemory));
        map.put("FREEMEMORY", new Long(freeMemory));
        return map;
    }

    public Map getRequestQueueStats() {
        return ActiveRequestMonitor.INSTANCE.getRequestQueueStats();
    }

    public double getRequestLoad() {
        return TimingRequestMonitor.INSTANCE.getRequestLoad();
    }

    public double getAverageResponseTime() {
        return TimingRequestMonitor.INSTANCE.getAverageResponseTime();
    }

    public int getLoggedInUserCount() {
        return ActiveRequestMonitor.getInstance().getLoggedInUserCount();
    }

    public int getActiveSessionCount(String cfApplicationName) {
        return ActiveRequestMonitor.getInstance().getActiveSessionCount(cfApplicationName);
    }

    public List getAllActiveSessions() {
        return ActiveRequestMonitor.getInstance().getAllActiveSessions(null);
    }

    public int getActiveThreadCount() {
        return CFthreadDictionary.getInstance().getActiveThreadCount();
    }

    public void resetDbPoolStats() {
        JDBCPoolMonitor.getInstance().reset();
    }

    public void resetStats() {
        JDBCPoolMonitor.getInstance().reset();
        TimingRequestMonitor.INSTANCE.reset();
        RequestErrorMonitor.INSTANCE.reset();
    }

    public void scheduleTask(Runnable task, long interval) {
        this.cancelTask(task);
        RunnableWrapper r = new RunnableWrapper(task, interval);
        this.scheduledTasks.put(task, r);
        r.schedule();
    }

    public void cancelTask(Runnable task) {
        RunnableWrapper r = (RunnableWrapper)this.scheduledTasks.get(task);
        if (r != null) {
            r.cancel();
            this.scheduledTasks.remove(task);
        }
    }

    private void onMonitoringEnabled() {
        Scope serverScope = ServiceFactory.getRuntimeService().getServerScope();
        serverScope.setupMemoryTracking();
        serverScope.getMemoryTrackerProxy().reload();
        Enumeration appNames = ApplicationScopeTracker.getApplicationKeys();
        while (appNames.hasMoreElements()) {
            String appName = (String)appNames.nextElement();
            ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope((String)appName);
            appScope.setupMemoryTracking();
            appScope.getMemoryTrackerProxy().reload();
        }
        Iterator sessionKeyObjects = SessionTracker.getSessionKeyObjects();
        while (sessionKeyObjects != null && sessionKeyObjects.hasNext()) {
            SessionKeyObject sessionKeyObj = (SessionKeyObject)sessionKeyObjects.next();
            SessionScope sessionScope = SessionTracker.getSession((String)sessionKeyObj.getAppName(), (String)sessionKeyObj.getSessionId());
            if (sessionScope == null || sessionScope.expired()) continue;
            sessionScope.setupMemoryTracking();
            sessionScope.getMemoryTrackerProxy().reload();
        }
    }

    private void onMonitoringDisabled() {
        Scope serverScope = ServiceFactory.getRuntimeService().getServerScope();
        MemoryTrackerProxy serverScopeMTP = serverScope.getMemoryTrackerProxy();
        if (serverScopeMTP != null) {
            serverScopeMTP.disable();
        }
        Enumeration appNames = ApplicationScopeTracker.getApplicationKeys();
        while (appNames.hasMoreElements()) {
            String appName = (String)appNames.nextElement();
            ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope((String)appName);
            MemoryTrackerProxy appScopeMTP = appScope.getMemoryTrackerProxy();
            if (appScopeMTP == null) continue;
            appScopeMTP.disable();
        }
        Iterator sessionKeyObjects = SessionTracker.getSessionKeyObjects();
        while (sessionKeyObjects != null && sessionKeyObjects.hasNext()) {
            MemoryTrackerProxy sessionScopeMTP;
            SessionKeyObject sessionKeyObj = (SessionKeyObject)sessionKeyObjects.next();
            SessionScope sessionScope = SessionTracker.getSession((String)sessionKeyObj.getAppName(), (String)sessionKeyObj.getSessionId());
            if (sessionScope == null || sessionScope.expired() || (sessionScopeMTP = sessionScope.getMemoryTrackerProxy()) == null) continue;
            sessionScopeMTP.disable();
        }
    }

    private class RunnableWrapper
    implements Runnable {
        private Runnable runnable;
        private long interval;
        private boolean cancelled = false;

        public RunnableWrapper(Runnable runnable, long interval) {
            this.runnable = runnable;
            this.interval = interval;
        }

        public void schedule() {
            if (this.cancelled) {
                return;
            }
            InMemoryMonitoringServiceImpl.this.ss.schedule((Runnable)this, System.currentTimeMillis() + this.interval);
        }

        @Override
        public void run() {
            if (this.cancelled) {
                return;
            }
            this.runnable.run();
            this.schedule();
        }

        public void cancel() {
            this.cancelled = true;
        }
    }
}

