/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.net;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import macromedia.sequelink.net.NetworkException;
import macromedia.sequelink.net.SPDU;
import macromedia.sequelink.net.SPDUFormat;

public class SPDUDecoder
extends SPDUFormat {
    protected DataInputStream dis;
    private SPDU spdu;

    public SPDUDecoder(InputStream inputStream) throws NetworkException {
        this.dis = new DataInputStream(inputStream);
        byte[] byArray = this.decodeSessionKey();
        int n2 = this.decodeSpduType();
        this.spdu = new SPDU(n2, byArray);
    }

    public SPDUDecoder(SPDU sPDU, InputStream inputStream) {
        this.dis = new DataInputStream(inputStream);
        this.spdu = sPDU;
    }

    public SPDU getSpdu() {
        return this.spdu;
    }

    private byte[] decodeSessionKey() throws NetworkException {
        byte[] byArray;
        try {
            byte by2 = this.dis.readByte();
            byArray = new byte[by2];
            if (by2 > 0) {
                this.dis.readFully(byArray);
            }
        }
        catch (IOException iOException) {
            throw SPDU.getException(7578, iOException.getMessage());
        }
        return byArray;
    }

    private int decodeSpduType() throws NetworkException {
        byte by2;
        try {
            by2 = this.dis.readByte();
        }
        catch (IOException iOException) {
            throw SPDU.getException(7578, iOException.getMessage());
        }
        return SPDUDecoder.getSpduType(by2);
    }

    protected int decodeTag(int n2) throws NetworkException {
        try {
            byte by2 = this.dis.readByte();
            if (n2 != by2) {
                throw SPDU.getException(7574);
            }
            byte by3 = this.dis.readByte();
            switch (by3) {
                case 1: {
                    return this.dis.readByte();
                }
                case 2: {
                    return this.dis.readShort();
                }
                case 4: {
                    return this.dis.readInt();
                }
            }
            throw SPDU.getException(7575);
        }
        catch (IOException iOException) {
            throw SPDU.getException(7578, iOException.getMessage());
        }
    }
}

