/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.slbase;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import macromedia.jdbc.slbase.BaseBatchUpdateException;
import macromedia.jdbc.slbase.BaseBlob;
import macromedia.jdbc.slbase.BaseCharacterStreamWrapper;
import macromedia.jdbc.slbase.BaseClob;
import macromedia.jdbc.slbase.BaseConnection;
import macromedia.jdbc.slbase.BaseData;
import macromedia.jdbc.slbase.BaseInputStreamWrapper;
import macromedia.jdbc.slbase.BaseParameter;
import macromedia.jdbc.slbase.BaseParameterInfo;
import macromedia.jdbc.slbase.BaseParameterMetaDataFactory;
import macromedia.jdbc.slbase.BaseParameters;
import macromedia.jdbc.slbase.BasePreparedStatementPoolable;
import macromedia.jdbc.slbase.BaseResultSetMetaData;
import macromedia.jdbc.slbase.BaseSQL;
import macromedia.jdbc.slbase.BaseStatement;
import macromedia.jdbc.slbase.BaseTimestamp;
import macromedia.slutil.UtilVectorUnsynced;

public class BasePreparedStatement
extends BaseStatement
implements PreparedStatement {
    private UtilVectorUnsynced parameterSets;
    private int numParameterSets = 0;
    private UtilVectorUnsynced implParameterSets;
    BaseParameters currentParameters;
    boolean parametersDescribed = false;
    private boolean doingBatch = false;
    private boolean internalAddBatchForNonBatchExecution = false;
    BasePreparedStatementPoolable poolWrapper;
    int requestedResultSetType = -1;
    int requestedResultSetConcurrency = -1;
    public boolean preparable = true;
    private static final int EPMDS_START = 0;
    private static final int EPMDS_ERROR = 1;
    private static final int EPMDS_END = 2;
    private static final int EPMDS_INSERT = 3;
    private static final int EPMDS_INSERT_COLUMNS = 4;
    private static final int EPMDS_UPDATE = 5;
    private static final int EPMDS_INTO = 6;
    private static final int EPMDS_SET = 7;
    private static final int EPMDS_VALUES = 8;
    private static final int EPMDS_WHERE = 9;
    private static final int EPMDS_LEFT_PAREN = 10;
    private static final int EPMDS_RIGHT_PAREN = 11;
    private static final int EPMDS_TABLE = 12;

    public BasePreparedStatement(BaseConnection baseConnection, String string, int n2, int n3, boolean bl2) throws SQLException {
        super(baseConnection, n2, n3);
        this.implStatement.pstmt = this;
        this.requestedResultSetType = n2;
        this.requestedResultSetConcurrency = n3;
        this.implStatement.prepareExecuteMode = baseConnection.prepareExecuteMode;
        this.commonValidateSQL(string);
        this.setAutoGeneratedKeysRequested(bl2);
        this.preProcessSQL(string);
        this.parameterSets = new UtilVectorUnsynced();
        this.resultSetConcurrency = this.concurrencyStrategy == 1 ? 1007 : 1008;
        this.resultSetScrollType = this.scrollingStrategy == 1 ? 1003 : (this.scrollingStrategy == 3 || this.scrollingStrategy == 2 ? 1004 : 1005);
    }

    final void prepareSQL(BaseSQL baseSQL, boolean bl2) throws SQLException {
        this.commonTransitionToUnpreparedState(false);
        this.implStatement.setAutoGeneratedKeysRequested(this.autoGeneratedKeysRequested);
        this.implStatement.setSQL(baseSQL);
        if (this.currentParameters == null) {
            this.currentParameters = new BaseParameters(this.implStatement.sql.getParameterCount(), this.exceptions, this.connection);
        }
        this.implStatement.prepare(this.currentParameters);
        this.commonTransitionToState(2);
    }

    final PreparedStatement getExternalReference() {
        if (this.poolWrapper != null) {
            return this.poolWrapper;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state != 4) {
                this.clearParameters();
            }
            super.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ResultSet executeQuery() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.commonTransitionToState(2);
            return super.executeQueryInternal();
        }
    }

    void preImplExecute() throws SQLException {
        if (!this.doingBatch && this.numParameterSets != 1) {
            this.internalAddBatchForNonBatchExecution = true;
            this.addBatch();
            this.internalAddBatchForNonBatchExecution = false;
        }
        this.validateParameters();
        if (this.implParameterSets == null) {
            this.implParameterSets = new UtilVectorUnsynced(this.numParameterSets);
        } else {
            this.implParameterSets.clear();
        }
        for (int i2 = 0; i2 < this.numParameterSets; ++i2) {
            this.implParameterSets.addElement(this.parameterSets.elementAt(i2));
        }
        this.implStatement.setParameters(this.implParameterSets);
        super.preImplExecute();
    }

    final void postImplExecute(boolean bl2) throws SQLException {
        super.postImplExecute(bl2);
        this.clearBatchInternal();
    }

    public final ResultSet executeQuery(String string) throws SQLException {
        String[] stringArray = new String[]{"executeQuery(String sql)"};
        throw this.exceptions.getException(6011, stringArray);
    }

    private void validateParameters() throws SQLException {
        for (int i2 = 0; i2 < this.numParameterSets; ++i2) {
            BaseParameters baseParameters = (BaseParameters)this.parameterSets.elementAt(i2);
            this.validateParameters(baseParameters);
        }
    }

    private void validateParameters(BaseParameters baseParameters) throws SQLException {
        if (baseParameters == null || !baseParameters.haveMinimalBindings()) {
            throw this.exceptions.getException(6010, "07009");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int executeUpdate() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.commonTransitionToState(2);
            return super.executeUpdateInternal();
        }
    }

    public final int executeUpdate(String string) throws SQLException {
        String[] stringArray = new String[]{"executeUpdate(String sql)"};
        throw this.exceptions.getException(6011, stringArray);
    }

    public final int executeUpdate(String string, int n2) throws SQLException {
        String[] stringArray = new String[]{"executeUpdate(String sql, int autoGeneratedKeys)"};
        throw this.exceptions.getException(6011, stringArray);
    }

    final void validateSqlType(int n2) throws SQLException {
        switch (n2) {
            case 0: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2006: {
                throw this.exceptions.getException(6022, "HY004");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        int[] nArray = null;
        Object object = this.synchronizer;
        synchronized (object) {
            block15: {
                if (this.state == 4 || this.connection.implConnection == null) {
                    throw this.exceptions.getException(6009);
                }
                if (this.numParameterSets == 0) {
                    return new int[0];
                }
                try {
                    this.doingBatch = true;
                    if (this.implStatement.supportsBatchParameters() && !this.overrideNativeBatchSupport()) {
                        this.commonTransitionToState(1);
                        this.nativeBatchExecute = true;
                        try {
                            this.commonExecute();
                        }
                        catch (SQLException sQLException) {
                            this.postProcessExceptionFromCommonExecute(sQLException);
                            throw sQLException;
                        }
                        nArray = this.implStatement.getBatchRowsAffectedCount();
                        break block15;
                    }
                    nArray = this.executeBatchEmulation(this.parameterSets);
                }
                catch (SQLException sQLException) {
                    if (sQLException instanceof BatchUpdateException) {
                        throw sQLException;
                    }
                    throw new BaseBatchUpdateException(sQLException, new int[0]);
                }
                finally {
                    this.clearBatchInternal();
                    this.doingBatch = false;
                    this.nativeBatchExecute = false;
                }
            }
        }
        if (nArray == null) {
            throw new BaseBatchUpdateException(this.exceptions.getException(6090), new int[0]);
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int[] executeAllStatementsAtOnce() throws SQLException {
        Object object;
        BaseParameters baseParameters = this.currentParameters;
        String string = this.implStatement.sql.getOriginal();
        BaseParameters baseParameters2 = null;
        int n2 = this.implStatement.sql.getParameterCount();
        int n3 = this.numParameterSets * n2;
        BaseParameters baseParameters3 = new BaseParameters(n3, this.exceptions, this.connection);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.numParameterSets; ++i2) {
            baseParameters2 = (BaseParameters)this.parameterSets.elementAt(i2);
            object = null;
            for (int i3 = 1; i3 <= baseParameters2.count(); ++i3) {
                object = baseParameters2.get(i3, 1);
                if (object == null) {
                    throw this.exceptions.getException(6010, "07009");
                }
                baseParameters3.set(i2 * baseParameters2.count() + i3, 1, (BaseParameter)object);
            }
            if (i2 != 0) {
                stringBuffer.append(this.implStatement.getStatementSeparator());
            }
            stringBuffer.append(this.implStatement.sql.getOriginal());
        }
        try {
            UtilVectorUnsynced utilVectorUnsynced = new UtilVectorUnsynced();
            utilVectorUnsynced.addElement(baseParameters3);
            this.commonTransitionToState(1);
            this.implStatement.setParameters(utilVectorUnsynced);
            object = stringBuffer.toString();
            BaseSQL baseSQL = new BaseSQL((String)object, this.implStatement.getRequiredSQLProcessing((String)object), this.connection.implConnection.quotingChar, this.connection.implConnection.intoIsOptional, this.connection.getEscapeTranslator(), this.exceptions);
            this.implStatement.setSQL(baseSQL);
            try {
                super.preImplExecute();
                this.implStatement.execute();
                super.postImplExecute(true);
            }
            catch (SQLException sQLException) {
                this.postProcessExceptionFromCommonExecute(sQLException);
                throw sQLException;
            }
            int[] nArray = this.constructUpdateCountArray(this.numParameterSets);
            return nArray;
        }
        finally {
            this.preProcessSQL(string);
            this.commonTransitionToState(1);
            this.currentParameters = baseParameters;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected final int[] executeOneStatementAtATime() throws SQLException {
        var1_1 = new int[this.numParameterSets];
        var2_2 = this.parameterSets;
        this.parameterSets = new UtilVectorUnsynced();
        var3_3 = this.currentParameters;
        var4_4 = this.numParameterSets;
        block13: for (var5_5 = 0; var5_5 < var4_4; ++var5_5) {
            try {
                this.currentParameters = (BaseParameters)var2_2.elementAt(var5_5);
                this.internalAddBatchForNonBatchExecution = true;
                this.addBatch();
                this.internalAddBatchForNonBatchExecution = false;
                this.commonTransitionToState(1);
                try {
                    this.commonExecute();
                }
                catch (SQLException var6_6) {
                    this.postProcessExceptionFromCommonExecute(var6_6);
                    throw var6_6;
                }
                switch (this.currentResultType) {
                    case 3: {
                        var1_1[var5_5] = this.implStatement.getNextRowsAffectedCount();
                        ** break;
lbl24:
                        // 1 sources

                        continue block13;
                    }
                    case 0: {
                        var1_1[var5_5] = -2;
                        ** break;
lbl28:
                        // 1 sources

                        continue block13;
                    }
                    case 1: {
                        var1_1[var5_5] = 0;
                        ** break;
lbl32:
                        // 1 sources

                        continue block13;
                    }
                    case 2: {
                        throw this.exceptions.getException(6053);
                    }
                    ** default:
lbl36:
                    // 1 sources

                    continue block13;
                }
            }
            catch (SQLException var6_7) {
                var7_8 = null;
                var7_8 = new int[var5_5];
                for (var8_9 = 0; var8_9 < var5_5; ++var8_9) {
                    var7_8[var8_9] = var1_1[var8_9];
                }
                this.parameterSets = var2_2;
                throw new BaseBatchUpdateException(var6_7, var7_8);
            }
            finally {
                this.currentParameters = var3_3;
            }
        }
        this.parameterSets = var2_2;
        return var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setNull(int n2, int n3) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.setObjectInternal(n2, null, BaseData.mapJDBCTypeToJavaObjectType(n3), n3, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setBoolean(int n2, boolean bl2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.currentParameters.getParameter(n2);
            if (baseParameter.sqlType != -7) {
                this.currentParameters.newParameterBindings = true;
            }
            baseParameter.setBoolean(bl2);
            baseParameter.sqlType = -7;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setByte(int n2, byte by2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.currentParameters.getParameter(n2);
            if (baseParameter.sqlType != -6) {
                this.currentParameters.newParameterBindings = true;
            }
            baseParameter.setByte(by2);
            baseParameter.sqlType = -6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setShort(int n2, short s2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.currentParameters.getParameter(n2);
            if (baseParameter.sqlType != 5) {
                this.currentParameters.newParameterBindings = true;
            }
            baseParameter.setShort(s2);
            baseParameter.sqlType = 5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setInt(int n2, int n3) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.currentParameters.getParameter(n2);
            if (baseParameter.sqlType != 4) {
                this.currentParameters.newParameterBindings = true;
            }
            baseParameter.setInteger(n3);
            baseParameter.sqlType = 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLong(int n2, long l2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.currentParameters.getParameter(n2);
            if (baseParameter.sqlType != -5) {
                this.currentParameters.newParameterBindings = true;
            }
            baseParameter.setLong(l2);
            baseParameter.sqlType = -5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setFloat(int n2, float f2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.currentParameters.getParameter(n2);
            if (baseParameter.sqlType != 7) {
                this.currentParameters.newParameterBindings = true;
            }
            baseParameter.setFloat(f2);
            baseParameter.sqlType = 7;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDouble(int n2, double d2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.currentParameters.getParameter(n2);
            if (baseParameter.sqlType != 8) {
                this.currentParameters.newParameterBindings = true;
            }
            baseParameter.setDouble(d2);
            baseParameter.sqlType = 8;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.setObjectInternal(n2, bigDecimal, 8, 2, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setString(int n2, String string) throws SQLException {
        if (this.state == 4 || this.connection.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        Object object = this.synchronizer;
        synchronized (object) {
            BaseParameter baseParameter = this.currentParameters.getParameter(n2);
            if (baseParameter.sqlType != 12) {
                baseParameter.sqlType = 12;
                this.currentParameters.newParameterBindings = true;
            }
            baseParameter.setData(10, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setBytes(int n2, byte[] byArray) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.setObjectInternal(n2, byArray, 2, -3, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDate(int n2, Date date) throws SQLException {
        if (date != null) {
            date = (Date)date.clone();
        }
        Object object = this.synchronizer;
        synchronized (object) {
            this.setObjectInternal(n2, date, 11, 91, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setTime(int n2, Time time) throws SQLException {
        if (time != null) {
            time = (Time)time.clone();
        }
        Object object = this.synchronizer;
        synchronized (object) {
            this.setObjectInternal(n2, time, 12, 92, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (timestamp == null) {
                this.setObjectInternal(n2, null, 13, 93, -1);
            } else {
                this.setObjectInternal(n2, new BaseTimestamp(timestamp, null), 13, 93, -1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (inputStream != null) {
                BaseInputStreamWrapper baseInputStreamWrapper = new BaseInputStreamWrapper(inputStream, n3, this.connection, this.exceptions);
                baseInputStreamWrapper.setIsInputStream();
                this.setObjectInternal(n2, baseInputStreamWrapper, 15, -1, -1);
            } else {
                this.setObjectInternal(n2, null, 15, -1, -1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setUnicodeStream(int n2, InputStream inputStream, int n3) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (!this.connection.implConnection.shouldExposeGetSetUnicodeStream()) {
                String[] stringArray = new String[]{"PreparedStatement.setUnicodeStream"};
                throw this.connection.exceptions.getException(6003, stringArray);
            }
            if (inputStream != null) {
                BaseInputStreamWrapper baseInputStreamWrapper = new BaseInputStreamWrapper(inputStream, n3, this.connection, this.exceptions);
                baseInputStreamWrapper.setIsInputStream();
                this.setObjectInternal(n2, baseInputStreamWrapper, 17, -1, -1);
            } else {
                this.setObjectInternal(n2, null, 17, -1, -1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (inputStream != null) {
                BaseInputStreamWrapper baseInputStreamWrapper = new BaseInputStreamWrapper(inputStream, n3, this.connection, this.exceptions);
                baseInputStreamWrapper.setIsInputStream();
                this.setObjectInternal(n2, baseInputStreamWrapper, 14, -4, -1);
            } else {
                this.setObjectInternal(n2, null, 14, -4, -1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearParameters() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.currentParameters.clearInput();
        }
    }

    private final void setObjectInternal(int n2, Object object, int n3, int n4, int n5) throws SQLException {
        BaseData baseData;
        if (this.state == 4 || this.connection.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        this.validateSqlType(n4);
        if (n5 != -1 && (n4 == 3 || n4 == 2)) {
            baseData = new BaseData(n3, object, this.connection);
            object = baseData.getBigDecimal(n5, this.exceptions);
            n3 = 8;
            n5 = -1;
        }
        baseData = this.currentParameters.getParameter(n2);
        if (((BaseParameter)baseData).sqlType != n4) {
            ((BaseParameter)baseData).sqlType = n4;
            this.currentParameters.newParameterBindings = true;
        }
        baseData.setData(n3, object);
        ((BaseParameter)baseData).scale = n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setObject(int n2, Object object, int n3, int n4) throws SQLException {
        Object object2 = this.synchronizer;
        synchronized (object2) {
            int n5 = BaseData.getJavaObjectType(object, n3);
            if (n5 == 0) {
                throw this.exceptions.getException(6069);
            }
            if (!(n5 != 20 || object instanceof BaseClob && ((BaseClob)object).connection == this.connection)) {
                this.setCharacterStream(n2, ((Clob)object).getCharacterStream(), (int)((Clob)object).length());
            } else if (!(n5 != 19 || object instanceof BaseBlob && ((BaseBlob)object).connection == this.connection)) {
                this.setBinaryStream(n2, ((Blob)object).getBinaryStream(), (int)((Blob)object).length());
            } else {
                if (n5 == 13) {
                    if (object != null) {
                        object = new BaseTimestamp((Timestamp)object, null);
                    }
                } else {
                    object = this.wrapStreamFromSetObject(object);
                }
                this.setObjectInternal(n2, object, n5, n3, n4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setObject(int n2, Object object, int n3) throws SQLException {
        Object object2 = this.synchronizer;
        synchronized (object2) {
            int n4 = BaseData.getJavaObjectType(object, n3);
            if (n4 == 0) {
                throw this.exceptions.getException(6033);
            }
            if (!(n4 != 20 || object instanceof BaseClob && ((BaseClob)object).connection == this.connection)) {
                this.setCharacterStream(n2, ((Clob)object).getCharacterStream(), (int)((Clob)object).length());
            } else if (!(n4 != 19 || object instanceof BaseBlob && ((BaseBlob)object).connection == this.connection)) {
                this.setBinaryStream(n2, ((Blob)object).getBinaryStream(), (int)((Blob)object).length());
            } else {
                if (n4 == 13) {
                    if (object != null) {
                        object = new BaseTimestamp((Timestamp)object, null);
                    }
                } else {
                    object = this.wrapStreamFromSetObject(object);
                }
                this.setObjectInternal(n2, object, n4, n3, -1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setObject(int n2, Object object) throws SQLException {
        Object object2 = this.synchronizer;
        synchronized (object2) {
            int n3 = BaseData.getJavaObjectType(object, 0);
            if (n3 == 0) {
                throw this.exceptions.getException(6033);
            }
            if (!(n3 != 20 || object instanceof BaseClob && ((BaseClob)object).connection == this.connection)) {
                this.setCharacterStream(n2, ((Clob)object).getCharacterStream(), (int)((Clob)object).length());
            } else if (!(n3 != 19 || object instanceof BaseBlob && ((BaseBlob)object).connection == this.connection)) {
                this.setBinaryStream(n2, ((Blob)object).getBinaryStream(), (int)((Blob)object).length());
            } else {
                object = n3 == 13 ? new BaseTimestamp((Timestamp)object, null) : this.wrapStreamFromSetObject(object);
                this.setObjectInternal(n2, object, n3, this.implStatement.implConnection.mapJavaTypeToSQLType(n3), -1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean execute() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.commonTransitionToState(2);
            return super.executeInternal();
        }
    }

    public final boolean execute(String string) throws SQLException {
        String[] stringArray = new String[]{"execute(String sql)"};
        throw this.exceptions.getException(6011, stringArray);
    }

    public final boolean execute(String string, int n2) throws SQLException {
        String[] stringArray = new String[]{"execute(String sql, int autoGeneratedKeys)"};
        throw this.exceptions.getException(6011, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addBatch() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.internalAddBatchForNonBatchExecution) {
                if (this.parameterSets.size() == 0) {
                    this.parameterSets.add(this.currentParameters);
                } else {
                    this.parameterSets.setElementAt(this.currentParameters, 0);
                }
                this.numParameterSets = 1;
            } else {
                BaseParameters baseParameters;
                if (this.parameterSets.size() <= this.numParameterSets) {
                    this.parameterSets.add(this.currentParameters);
                    baseParameters = new BaseParameters(this.currentParameters, this.exceptions, this.connection);
                } else {
                    baseParameters = (BaseParameters)this.parameterSets.get(this.numParameterSets);
                    if (baseParameters == this.currentParameters) {
                        baseParameters = new BaseParameters(this.currentParameters, this.exceptions, this.connection);
                    } else {
                        baseParameters.copy(this.currentParameters, this.exceptions, this.connection);
                    }
                    this.parameterSets.setElementAt(this.currentParameters, this.numParameterSets);
                }
                this.currentParameters = baseParameters;
                ++this.numParameterSets;
            }
        }
    }

    public final void addBatch(String string) throws SQLException {
        String[] stringArray = new String[]{"addBatch(String sql)"};
        throw this.exceptions.getException(6011, stringArray);
    }

    void clearBatchInternal() throws SQLException {
        this.numParameterSets = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (reader != null) {
                BaseCharacterStreamWrapper baseCharacterStreamWrapper = new BaseCharacterStreamWrapper(reader, n3, this.connection, this.exceptions);
                baseCharacterStreamWrapper.setIsInputStream();
                this.setObjectInternal(n2, baseCharacterStreamWrapper, 18, -1, -1);
            } else {
                this.setObjectInternal(n2, null, 18, -1, -1);
            }
        }
    }

    public final void setRef(int n2, Ref ref) throws SQLException {
        String[] stringArray = new String[]{"PreparedStatement.setRef"};
        throw this.exceptions.getException(6003, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setBlob(int n2, Blob blob) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (!(blob == null || blob instanceof BaseBlob && ((BaseBlob)blob).connection == this.connection)) {
                this.setBinaryStream(n2, blob.getBinaryStream(), (int)blob.length());
            } else {
                this.setObjectInternal(n2, blob, 19, 2004, -1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setClob(int n2, Clob clob) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (!(clob == null || clob instanceof BaseClob && ((BaseClob)clob).connection == this.connection)) {
                this.setCharacterStream(n2, clob.getCharacterStream(), (int)clob.length());
            } else {
                this.setObjectInternal(n2, clob, 20, 2005, -1);
            }
        }
    }

    public final void setArray(int n2, Array array) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            String[] stringArray = new String[]{"PreparedStatement.setArray"};
            throw this.exceptions.getException(6003, stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ResultSetMetaData getMetaData() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.describeColumns();
            if (this.currentColumns == null) {
                return null;
            }
            return new BaseResultSetMetaData(this, this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDate(int n2, Date date, Calendar calendar) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (calendar == null) {
                calendar = Calendar.getInstance();
            }
            this.setObjectInternal(n2, BaseData.applyCalender(date, calendar, true), 11, 91, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setTime(int n2, Time time, Calendar calendar) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.setObjectInternal(n2, BaseData.applyCalender(time, calendar, true), 12, 92, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (timestamp == null) {
                this.setObjectInternal(n2, null, 13, 93, -1);
            } else {
                this.setObjectInternal(n2, new BaseTimestamp(timestamp, calendar), 13, 93, -1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setNull(int n2, int n3, String string) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.setNull(n2, n3);
        }
    }

    final Object wrapStreamFromSetObject(Object object) {
        if (object instanceof InputStream) {
            BaseInputStreamWrapper baseInputStreamWrapper = new BaseInputStreamWrapper((InputStream)object, -1L, this.connection, this.exceptions);
            baseInputStreamWrapper.setIsInputStream();
            object = baseInputStreamWrapper;
        } else if (object instanceof Reader) {
            BaseCharacterStreamWrapper baseCharacterStreamWrapper = new BaseCharacterStreamWrapper((Reader)object, -1L, this.connection, this.exceptions);
            baseCharacterStreamWrapper.setIsInputStream();
            object = baseCharacterStreamWrapper;
        }
        return object;
    }

    public final void setURL(int n2, URL uRL) throws SQLException {
        String[] stringArray = new String[]{"PreparedStatement.setURL"};
        throw this.exceptions.getException(6003, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ParameterMetaData getParameterMetaData() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.determineParameterMetaData();
            return BaseParameterMetaDataFactory.getMetaData(this.currentParameters);
        }
    }

    public final void determineParameterMetaData() throws SQLException {
        if (!this.parametersDescribed && this.currentParameters.count() > 0) {
            this.implStatement.describeParameters(this.currentParameters);
            if (this.currentParameters.parameterMetaData == null) {
                if (this.implStatement.sql.getType() == 1) {
                    this.discoverSelectParamMetaData(this.currentParameters);
                } else {
                    this.discoverNonSelectParamMetaData(this.currentParameters);
                }
            }
            this.parametersDescribed = true;
        }
        if (this.numParameterSets > 0 && ((BaseParameters)this.parameterSets.elementAt((int)0)).parameterMetaData == null) {
            for (int i2 = 0; i2 < this.numParameterSets; ++i2) {
                ((BaseParameters)this.parameterSets.elementAt((int)i2)).parameterMetaData = this.currentParameters.parameterMetaData;
            }
        }
    }

    private void discoverNonSelectParamMetaData(BaseParameters baseParameters) {
        BaseEPMDTokenizer baseEPMDTokenizer = new BaseEPMDTokenizer(this.implStatement.sql.getOriginal());
        int n2 = 0;
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = 0;
        while (n2 != 2 && n2 != 1) {
            int n4 = baseEPMDTokenizer.nextToken();
            block1 : switch (n2) {
                case 0: {
                    switch (n4) {
                        case 0: {
                            n2 = 3;
                            break block1;
                        }
                        case 1: {
                            n2 = 5;
                            break block1;
                        }
                    }
                    n2 = 1;
                    break;
                }
                case 3: {
                    switch (n4) {
                        case 4: {
                            n2 = 6;
                            break block1;
                        }
                    }
                    n2 = 1;
                    break;
                }
                case 5: 
                case 6: {
                    switch (n4) {
                        case 14: {
                            string = baseEPMDTokenizer.getTokenValue();
                            n2 = 12;
                            break block1;
                        }
                    }
                    n2 = 1;
                    break;
                }
                case 12: {
                    switch (n4) {
                        case 5: {
                            n2 = 8;
                            break block1;
                        }
                        case 8: {
                            n2 = 4;
                            break block1;
                        }
                        case 3: {
                            n2 = 7;
                            break block1;
                        }
                    }
                    n2 = 1;
                    break;
                }
                case 4: {
                    switch (n4) {
                        case 14: {
                            arrayList.add(baseEPMDTokenizer.getTokenValue());
                            break block1;
                        }
                        case 10: {
                            break block1;
                        }
                        case 9: {
                            n2 = 12;
                            break block1;
                        }
                    }
                    n2 = 1;
                    break;
                }
                case 8: {
                    switch (n4) {
                        case 9: {
                            n2 = 2;
                            break block1;
                        }
                        case 11: {
                            ++n3;
                            break block1;
                        }
                        case 8: 
                        case 10: {
                            break block1;
                        }
                    }
                    n2 = 1;
                    break;
                }
                case 7: {
                    switch (n4) {
                        case 14: {
                            arrayList.add(baseEPMDTokenizer.getTokenValue());
                            break block1;
                        }
                        case 2: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: {
                            break block1;
                        }
                        case -1: {
                            n2 = 2;
                            break block1;
                        }
                    }
                    n2 = 1;
                }
            }
        }
        if (n2 != 1) {
            StringBuffer stringBuffer = new StringBuffer("SELECT ");
            int n5 = arrayList.size();
            if (n5 > 0) {
                for (int i2 = 0; i2 < n5; ++i2) {
                    if (i2 != 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append((String)arrayList.get(i2));
                }
            } else {
                stringBuffer.append("* ");
            }
            stringBuffer.append(" FROM ");
            stringBuffer.append(string);
            stringBuffer.append(" WHERE 0=1");
            try {
                BaseStatement baseStatement = new BaseStatement(this.connection, 1003, 1007);
                ResultSet resultSet = baseStatement.executeQuery(stringBuffer.toString());
                BaseResultSetMetaData baseResultSetMetaData = (BaseResultSetMetaData)resultSet.getMetaData();
                int n6 = baseResultSetMetaData.getColumnCount();
                if (n6 != baseParameters.count()) {
                    return;
                }
                for (int i3 = 1; i3 <= n6; ++i3) {
                    BaseParameterInfo baseParameterInfo = new BaseParameterInfo();
                    baseParameterInfo.nativeTypeName = baseResultSetMetaData.getColumnTypeName(i3);
                    baseParameterInfo.setType(baseResultSetMetaData.getColumnType(i3));
                    baseParameterInfo.mode = 0;
                    baseParameterInfo.nullable = baseResultSetMetaData.isNullable(i3);
                    baseParameterInfo.precision = baseResultSetMetaData.getPrecision(i3);
                    baseParameterInfo.scale = baseResultSetMetaData.getScale(i3);
                    baseParameterInfo.typeClassName = baseResultSetMetaData.getColumnClassName(i3);
                    baseParameterInfo.signed = baseResultSetMetaData.isSigned(i3);
                    baseParameterInfo.transliterator = baseResultSetMetaData.getColumnTransliterator(i3);
                    baseParameters.setParameterInfo(i3 - 1, baseParameterInfo);
                }
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    private void discoverSelectParamMetaData(BaseParameters baseParameters) {
        block11: {
            try {
                int n2;
                BaseSQL baseSQL = new BaseSQL(this.implStatement.sql, 12);
                UtilVectorUnsynced utilVectorUnsynced = baseSQL.getPredicateParamColumnDefinitions();
                if (utilVectorUnsynced == null || (n2 = utilVectorUnsynced.size()) != baseSQL.getParameterCount()) break block11;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Object object;
                    Object object2;
                    UtilVectorUnsynced utilVectorUnsynced2 = (UtilVectorUnsynced)utilVectorUnsynced.elementAt(i2);
                    int n3 = utilVectorUnsynced2.size();
                    boolean bl2 = false;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    for (int i3 = 0; i3 < n3; ++i3) {
                        object2 = (String)utilVectorUnsynced2.get(i3);
                        if (((String)object2).equals("charish")) {
                            bl3 = true;
                            continue;
                        }
                        PreparedStatement preparedStatement = null;
                        try {
                            preparedStatement = this.connection.prepareStatement((String)object2);
                        }
                        catch (Exception exception) {
                            continue;
                        }
                        object = preparedStatement.getMetaData();
                        if (object == null || object.getColumnCount() != 1) continue;
                        BaseParameterInfo baseParameterInfo = new BaseParameterInfo();
                        baseParameterInfo.nativeTypeName = object.getColumnTypeName(1);
                        baseParameterInfo.setType(object.getColumnType(1));
                        baseParameterInfo.mode = 0;
                        baseParameterInfo.nullable = object.isNullable(1);
                        baseParameterInfo.precision = object.getPrecision(1);
                        baseParameterInfo.scale = object.getScale(1);
                        baseParameterInfo.typeClassName = object.getColumnClassName(1);
                        baseParameterInfo.signed = object.isSigned(1);
                        baseParameters.setParameterInfo(i2, baseParameterInfo);
                        if (baseParameterInfo.sqlType == 12 || baseParameterInfo.sqlType == -9 || baseParameterInfo.sqlType == 1 || baseParameterInfo.sqlType == -8) {
                            bl4 = true;
                        }
                        preparedStatement.close();
                        bl2 = true;
                        break;
                    }
                    if (bl3 && !bl4) {
                        ResultSet resultSet = this.connection.getMetaData().getTypeInfo();
                        object2 = null;
                        int n4 = 0;
                        while (resultSet.next()) {
                            int n5;
                            object = resultSet.getString(1);
                            if (resultSet.getInt(2) != 12 || (n5 = resultSet.getInt(3)) <= n4) continue;
                            n4 = n5;
                            if (object2 == null) {
                                object2 = new BaseParameterInfo();
                            }
                            ((BaseParameterInfo)object2).nativeTypeName = object;
                            ((BaseParameterInfo)object2).setType(12);
                            ((BaseParameterInfo)object2).mode = 0;
                            ((BaseParameterInfo)object2).precision = n5;
                            ((BaseParameterInfo)object2).nullable = resultSet.getInt(7);
                            ((BaseParameterInfo)object2).scale = resultSet.getInt(15);
                            ((BaseParameterInfo)object2).typeClassName = "java.lang.String";
                        }
                        baseParameters.setParameterInfo(i2, (BaseParameterInfo)object2);
                        bl2 = true;
                    }
                    if (bl2) continue;
                    return;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    class BaseEPMDTokenizer {
        static final int TYPE_NONE = -2;
        static final int TYPE_END = -1;
        static final int TYPE_INSERT = 0;
        static final int TYPE_UPDATE = 1;
        static final int TYPE_WHERE = 2;
        static final int TYPE_SET = 3;
        static final int TYPE_INTO = 4;
        static final int TYPE_VALUES = 5;
        static final int TYPE_AND = 6;
        static final int TYPE_OR = 7;
        static final int TYPE_LEFT_PAREN = 8;
        static final int TYPE_RIGHT_PAREN = 9;
        static final int TYPE_COMMA = 10;
        static final int TYPE_QUESTION_MARK = 11;
        static final int TYPE_OP = 12;
        static final int TYPE_AND_OR = 13;
        static final int TYPE_UNKNOWN = 14;
        private static final int STATE_START = 0;
        private static final int STATE_BUILDING_MULTI_CHAR_TOKEN = 1;
        private static final int STATE_END = 2;
        private String sql;
        private int pos = 0;
        private StringBuffer valueBuffer = new StringBuffer();
        private String value;
        private int type = -2;

        BaseEPMDTokenizer(String string) {
            this.sql = string;
        }

        int nextToken() {
            this.value = null;
            this.valueBuffer.setLength(0);
            this.type = -2;
            int n2 = 0;
            boolean bl2 = false;
            char c2 = '\u0000';
            do {
                if (this.pos == this.sql.length()) {
                    bl2 = true;
                } else {
                    c2 = this.sql.charAt(this.pos++);
                }
                switch (n2) {
                    case 0: {
                        if (bl2) {
                            n2 = 2;
                            this.type = -1;
                            break;
                        }
                        if (this.whiteSpace(c2)) break;
                        if (c2 == '(') {
                            n2 = 2;
                            this.type = 8;
                            break;
                        }
                        if (c2 == ')') {
                            n2 = 2;
                            this.type = 9;
                            break;
                        }
                        if (c2 == ',') {
                            n2 = 2;
                            this.type = 10;
                            break;
                        }
                        if (c2 == '?') {
                            n2 = 2;
                            this.type = 11;
                            break;
                        }
                        if (c2 == '=' || c2 == '<' || c2 == '>') {
                            n2 = 2;
                            this.type = 12;
                            break;
                        }
                        this.valueBuffer.append(c2);
                        n2 = 1;
                        break;
                    }
                    case 1: {
                        if (bl2 || this.whiteSpace(c2) || c2 == '(' || c2 == ')' || c2 == ',' || c2 == '?' || c2 == '=' || c2 == '<' || c2 == '>') {
                            n2 = 2;
                            if (!bl2) {
                                --this.pos;
                            }
                            this.value = this.valueBuffer.toString();
                            if (this.value.equalsIgnoreCase("insert")) {
                                this.type = 0;
                                break;
                            }
                            if (this.value.equalsIgnoreCase("update")) {
                                this.type = 1;
                                break;
                            }
                            if (this.value.equalsIgnoreCase("where")) {
                                this.type = 2;
                                break;
                            }
                            if (this.value.equalsIgnoreCase("set")) {
                                this.type = 3;
                                break;
                            }
                            if (this.value.equalsIgnoreCase("into")) {
                                this.type = 4;
                                break;
                            }
                            if (this.value.equalsIgnoreCase("values")) {
                                this.type = 5;
                                break;
                            }
                            if (this.value.equalsIgnoreCase("and")) {
                                this.type = 13;
                                break;
                            }
                            if (this.value.equalsIgnoreCase("or")) {
                                this.type = 13;
                                break;
                            }
                            this.type = 14;
                            break;
                        }
                        this.valueBuffer.append(c2);
                    }
                }
            } while (n2 != 2);
            return this.type;
        }

        String getTokenValue() {
            return this.value;
        }

        int getTokenType() {
            return this.type;
        }

        private boolean whiteSpace(char c2) {
            return c2 <= ' ' && c2 != '\u0000';
        }
    }
}

