/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sequelink;

import java.io.IOException;
import java.sql.SQLException;
import macromedia.jdbc.sequelink.SequeLinkImplConnection;
import macromedia.jdbc.slbase.BaseImplClob;
import macromedia.sequelink.ssp.DiagnosticList;
import macromedia.sequelink.ssp.Message;
import macromedia.sequelink.ssp.SspInputStream;
import macromedia.sequelink.ssp.SspLob;
import macromedia.sequelink.ssp.SspOutputStream;
import macromedia.slutil.UtilException;
import macromedia.slutil.UtilTransliterator;
import macromedia.slutil.UtilTransliteratorForUCS2;

public class SequeLinkImplClob
extends BaseImplClob
implements SspLob {
    private SequeLinkImplConnection implCon;
    private byte[] locator;
    private long lobLength;
    private boolean moreToCome;
    private int lobOptions;
    private String encoding;
    private UtilTransliterator ut;
    private UtilTransliteratorForUCS2 ucs2;

    public SequeLinkImplClob(SequeLinkImplConnection sequeLinkImplConnection, byte[] byArray, String string, UtilTransliterator utilTransliterator) {
        super(sequeLinkImplConnection.exceptions);
        this.implCon = sequeLinkImplConnection;
        this.locator = byArray;
        this.lobLength = -1L;
        try {
            this.lobOptions = sequeLinkImplConnection.conCtxt.supportsLobs(DiagnosticList.GetADummyList());
        }
        catch (SQLException sQLException) {
            throw new InternalError("SequeLinkImplClob ctor " + sQLException.toString());
        }
        this.ut = utilTransliterator;
        this.encoding = string;
        this.ucs2 = new UtilTransliteratorForUCS2();
    }

    public int getCharacterEncoding() {
        return 2;
    }

    public long getMaxChunkSize() {
        return 30000L;
    }

    public int readData(byte[] byArray, int n2, long l2, int n3) throws SQLException {
        if ((this.lobOptions & 1) == 0) {
            String[] stringArray = new String[]{"Clob.readData"};
            throw this.exceptions.getException(6003, stringArray);
        }
        return this.implCon.getLobData(this, byArray, n2, l2 - 1L, n3);
    }

    public int writeData(long l2, byte[] byArray, int n2, int n3) throws SQLException {
        byte[] byArray2;
        if ((this.lobOptions & 4) == 0) {
            String[] stringArray = new String[]{"Clob.writeData"};
            throw this.exceptions.getException(6003, stringArray);
        }
        try {
            String string = this.ucs2.decode(byArray, n2, n3 * 2);
            byArray2 = this.ut.encode(string);
        }
        catch (UtilException utilException) {
            SQLException sQLException = Message.Gen.getSqlException(7452);
            Message.Gen.addMessageToSQLException(sQLException, utilException.getMessage());
            throw sQLException;
        }
        int n4 = this.implCon.setLobData(this, byArray2, 0, l2 - 1L, byArray2.length);
        int n5 = n3;
        if (this.lobLength != -1L) {
            this.lobLength = Math.max(this.lobLength, l2 - 1L + (long)n5);
        }
        return n5;
    }

    public long getLength() throws SQLException {
        if (this.lobLength != -1L) {
            return this.lobLength;
        }
        this.implCon.getLobLength(this);
        return this.lobLength;
    }

    public boolean supportsSearch() {
        return true;
    }

    public long find(String string, long l2) throws SQLException {
        byte[] byArray;
        try {
            byArray = this.ut.encode(string);
        }
        catch (UtilException utilException) {
            SQLException sQLException = Message.Gen.getSqlException(7452);
            Message.Gen.addMessageToSQLException(sQLException, utilException.getMessage());
            throw sQLException;
        }
        return this.implCon.getLobPosition(this, byArray, l2);
    }

    public void truncate(long l2) throws SQLException {
        if ((this.lobOptions & 4) == 0) {
            String[] stringArray = new String[]{"Clob.truncate"};
            throw this.exceptions.getException(6003, stringArray);
        }
        if (this.lobLength != -1L && l2 >= this.lobLength) {
            return;
        }
        this.implCon.lobTruncate(this, l2);
        if (this.lobLength != -1L) {
            this.lobLength = l2;
        }
    }

    public void close() throws SQLException {
        this.implCon = null;
    }

    public void setLocator(byte[] byArray) {
        this.locator = byArray;
    }

    public byte[] getLocator() {
        return this.locator;
    }

    public int getLobType() {
        return 2;
    }

    public void setLobLength(long l2) {
        this.lobLength = l2;
    }

    public void setMoreToCome(boolean bl2) {
        this.moreToCome = bl2;
    }

    public String getEncoding() {
        return this.encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readLobData(SspInputStream sspInputStream, byte[] byArray, int n2, int n3) throws IOException, UtilException {
        String string;
        UtilTransliterator utilTransliterator = sspInputStream.getTransliterator();
        if (utilTransliterator == this.ut) {
            string = sspInputStream.readSSPString();
        } else {
            try {
                sspInputStream.setTransliterator(this.ut);
                string = sspInputStream.readSSPString();
            }
            finally {
                sspInputStream.setTransliterator(utilTransliterator);
            }
        }
        byte[] byArray2 = this.ucs2.encode(string);
        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
        return byArray2.length;
    }

    public int writeLobData(SspOutputStream sspOutputStream, byte[] byArray, int n2, int n3) throws IOException, UtilException {
        sspOutputStream.writeSSPLongVarChar(byArray, n2, n3);
        return n3;
    }
}

