/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.util;

import java.util.ArrayList;
import java.util.HashMap;

public abstract class StringTrieBuilder {
    private State state = State.ADDING;
    @Deprecated
    protected StringBuilder strings = new StringBuilder();
    private Node root;
    private HashMap<Node, Node> nodes = new HashMap();
    private ValueNode lookupFinalValueNode = new ValueNode();

    @Deprecated
    protected StringTrieBuilder() {
    }

    @Deprecated
    protected void addImpl(CharSequence charSequence, int n2) {
        if (this.state != State.ADDING) {
            throw new IllegalStateException("Cannot add (string, value) pairs after build().");
        }
        if (charSequence.length() > 65535) {
            throw new IndexOutOfBoundsException("The maximum string length is 0xffff.");
        }
        this.root = this.root == null ? this.createSuffixNode(charSequence, 0, n2) : this.root.add(this, charSequence, 0, n2);
    }

    @Deprecated
    protected final void buildImpl(Option option) {
        switch (this.state) {
            case ADDING: {
                if (this.root == null) {
                    throw new IndexOutOfBoundsException("No (string, value) pairs were added.");
                }
                if (option == Option.FAST) {
                    this.state = State.BUILDING_FAST;
                    break;
                }
                this.state = State.BUILDING_SMALL;
                break;
            }
            case BUILDING_FAST: 
            case BUILDING_SMALL: {
                throw new IllegalStateException("Builder failed and must be clear()ed.");
            }
            case BUILT: {
                return;
            }
        }
        this.root = this.root.register(this);
        this.root.markRightEdgesFirst(-1);
        this.root.write(this);
        this.state = State.BUILT;
    }

    @Deprecated
    protected void clearImpl() {
        this.strings.setLength(0);
        this.nodes.clear();
        this.root = null;
        this.state = State.ADDING;
    }

    private final Node registerNode(Node node) {
        if (this.state == State.BUILDING_FAST) {
            return node;
        }
        Node node2 = this.nodes.get(node);
        if (node2 != null) {
            return node2;
        }
        node2 = this.nodes.put(node, node);
        assert (node2 == null);
        return node;
    }

    private final ValueNode registerFinalValue(int n2) {
        this.lookupFinalValueNode.setFinalValue(n2);
        Node node = this.nodes.get(this.lookupFinalValueNode);
        if (node != null) {
            return (ValueNode)node;
        }
        ValueNode valueNode = new ValueNode(n2);
        node = this.nodes.put(valueNode, valueNode);
        assert (node == null);
        return valueNode;
    }

    private ValueNode createSuffixNode(CharSequence charSequence, int n2, int n3) {
        ValueNode valueNode = this.registerFinalValue(n3);
        if (n2 < charSequence.length()) {
            int n4 = this.strings.length();
            this.strings.append(charSequence, n2, charSequence.length());
            valueNode = new LinearMatchNode(this.strings, n4, charSequence.length() - n2, valueNode);
        }
        return valueNode;
    }

    @Deprecated
    protected abstract boolean matchNodesCanHaveValues();

    @Deprecated
    protected abstract int getMaxBranchLinearSubNodeLength();

    @Deprecated
    protected abstract int getMinLinearMatch();

    @Deprecated
    protected abstract int getMaxLinearMatchLength();

    @Deprecated
    protected abstract int write(int var1);

    @Deprecated
    protected abstract int write(int var1, int var2);

    @Deprecated
    protected abstract int writeValueAndFinal(int var1, boolean var2);

    @Deprecated
    protected abstract int writeValueAndType(boolean var1, int var2, int var3);

    @Deprecated
    protected abstract int writeDeltaTo(int var1);

    private static enum State {
        ADDING,
        BUILDING_FAST,
        BUILDING_SMALL,
        BUILT;

    }

    private static final class BranchHeadNode
    extends ValueNode {
        private int length;
        private Node next;

        public BranchHeadNode(int n2, Node node) {
            this.length = n2;
            this.next = node;
        }

        @Override
        public int hashCode() {
            return (0xECCCCBE + this.length) * 37 + this.next.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!super.equals(object)) {
                return false;
            }
            BranchHeadNode branchHeadNode = (BranchHeadNode)object;
            return this.length == branchHeadNode.length && this.next == branchHeadNode.next;
        }

        @Override
        public int markRightEdgesFirst(int n2) {
            if (this.offset == 0) {
                this.offset = n2 = this.next.markRightEdgesFirst(n2);
            }
            return n2;
        }

        @Override
        public void write(StringTrieBuilder stringTrieBuilder) {
            this.next.write(stringTrieBuilder);
            if (this.length <= stringTrieBuilder.getMinLinearMatch()) {
                this.offset = stringTrieBuilder.writeValueAndType(this.hasValue, this.value, this.length - 1);
            } else {
                stringTrieBuilder.write(this.length - 1);
                this.offset = stringTrieBuilder.writeValueAndType(this.hasValue, this.value, 0);
            }
        }
    }

    private static final class SplitBranchNode
    extends BranchNode {
        private char unit;
        private Node lessThan;
        private Node greaterOrEqual;

        public SplitBranchNode(char c2, Node node, Node node2) {
            this.hash = ((206918985 + c2) * 37 + node.hashCode()) * 37 + node2.hashCode();
            this.unit = c2;
            this.lessThan = node;
            this.greaterOrEqual = node2;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!super.equals(object)) {
                return false;
            }
            SplitBranchNode splitBranchNode = (SplitBranchNode)object;
            return this.unit == splitBranchNode.unit && this.lessThan == splitBranchNode.lessThan && this.greaterOrEqual == splitBranchNode.greaterOrEqual;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public int markRightEdgesFirst(int n2) {
            if (this.offset == 0) {
                this.firstEdgeNumber = n2;
                n2 = this.greaterOrEqual.markRightEdgesFirst(n2);
                this.offset = n2 = this.lessThan.markRightEdgesFirst(n2 - 1);
            }
            return n2;
        }

        @Override
        public void write(StringTrieBuilder stringTrieBuilder) {
            this.lessThan.writeUnlessInsideRightEdge(this.firstEdgeNumber, this.greaterOrEqual.getOffset(), stringTrieBuilder);
            this.greaterOrEqual.write(stringTrieBuilder);
            assert (this.lessThan.getOffset() > 0);
            stringTrieBuilder.writeDeltaTo(this.lessThan.getOffset());
            this.offset = stringTrieBuilder.write(this.unit);
        }
    }

    private static final class ListBranchNode
    extends BranchNode {
        private Node[] equal;
        private int length;
        private int[] values;
        private char[] units;

        public ListBranchNode(int n2) {
            this.hash = 0x9DDDDD4 + n2;
            this.equal = new Node[n2];
            this.values = new int[n2];
            this.units = new char[n2];
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!super.equals(object)) {
                return false;
            }
            ListBranchNode listBranchNode = (ListBranchNode)object;
            for (int i2 = 0; i2 < this.length; ++i2) {
                if (this.units[i2] == listBranchNode.units[i2] && this.values[i2] == listBranchNode.values[i2] && this.equal[i2] == listBranchNode.equal[i2]) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public int markRightEdgesFirst(int n2) {
            if (this.offset == 0) {
                this.firstEdgeNumber = n2;
                int n3 = 0;
                int n4 = this.length;
                do {
                    Node node;
                    if ((node = this.equal[--n4]) != null) {
                        n2 = node.markRightEdgesFirst(n2 - n3);
                    }
                    n3 = 1;
                } while (n4 > 0);
                this.offset = n2;
            }
            return n2;
        }

        @Override
        public void write(StringTrieBuilder stringTrieBuilder) {
            int n2;
            int n3 = this.length - 1;
            Node node = this.equal[n3];
            int n4 = n2 = node == null ? this.firstEdgeNumber : node.getOffset();
            do {
                if (this.equal[--n3] == null) continue;
                this.equal[n3].writeUnlessInsideRightEdge(this.firstEdgeNumber, n2, stringTrieBuilder);
            } while (n3 > 0);
            n3 = this.length - 1;
            if (node == null) {
                stringTrieBuilder.writeValueAndFinal(this.values[n3], true);
            } else {
                node.write(stringTrieBuilder);
            }
            this.offset = stringTrieBuilder.write(this.units[n3]);
            while (--n3 >= 0) {
                boolean bl2;
                int n5;
                if (this.equal[n3] == null) {
                    n5 = this.values[n3];
                    bl2 = true;
                } else {
                    assert (this.equal[n3].getOffset() > 0);
                    n5 = this.offset - this.equal[n3].getOffset();
                    bl2 = false;
                }
                stringTrieBuilder.writeValueAndFinal(n5, bl2);
                this.offset = stringTrieBuilder.write(this.units[n3]);
            }
        }

        public void add(int n2, int n3) {
            this.units[this.length] = (char)n2;
            this.equal[this.length] = null;
            this.values[this.length] = n3;
            ++this.length;
            this.hash = (this.hash * 37 + n2) * 37 + n3;
        }

        public void add(int n2, Node node) {
            this.units[this.length] = (char)n2;
            this.equal[this.length] = node;
            this.values[this.length] = 0;
            ++this.length;
            this.hash = (this.hash * 37 + n2) * 37 + node.hashCode();
        }
    }

    private static abstract class BranchNode
    extends Node {
        protected int hash;
        protected int firstEdgeNumber;

        @Override
        public int hashCode() {
            return this.hash;
        }
    }

    private static final class DynamicBranchNode
    extends ValueNode {
        private StringBuilder chars = new StringBuilder();
        private ArrayList<Node> equal = new ArrayList();

        public void add(char c2, Node node) {
            int n2 = this.find(c2);
            this.chars.insert(n2, c2);
            this.equal.add(n2, node);
        }

        @Override
        public Node add(StringTrieBuilder stringTrieBuilder, CharSequence charSequence, int n2, int n3) {
            char c2;
            int n4;
            if (n2 == charSequence.length()) {
                if (this.hasValue) {
                    throw new IllegalArgumentException("Duplicate string.");
                }
                this.setValue(n3);
                return this;
            }
            if ((n4 = this.find(c2 = charSequence.charAt(n2++))) < this.chars.length() && c2 == this.chars.charAt(n4)) {
                this.equal.set(n4, this.equal.get(n4).add(stringTrieBuilder, charSequence, n2, n3));
            } else {
                this.chars.insert(n4, c2);
                this.equal.add(n4, stringTrieBuilder.createSuffixNode(charSequence, n2, n3));
            }
            return this;
        }

        @Override
        public Node register(StringTrieBuilder stringTrieBuilder) {
            BranchHeadNode branchHeadNode;
            Node node = this.register(stringTrieBuilder, 0, this.chars.length());
            ValueNode valueNode = branchHeadNode = new BranchHeadNode(this.chars.length(), node);
            if (this.hasValue) {
                if (stringTrieBuilder.matchNodesCanHaveValues()) {
                    branchHeadNode.setValue(this.value);
                } else {
                    valueNode = new IntermediateValueNode(this.value, stringTrieBuilder.registerNode(branchHeadNode));
                }
            }
            return stringTrieBuilder.registerNode(valueNode);
        }

        private Node register(StringTrieBuilder stringTrieBuilder, int n2, int n3) {
            int n4 = n3 - n2;
            if (n4 > stringTrieBuilder.getMaxBranchLinearSubNodeLength()) {
                int n5 = n2 + n4 / 2;
                return stringTrieBuilder.registerNode(new SplitBranchNode(this.chars.charAt(n5), this.register(stringTrieBuilder, n2, n5), this.register(stringTrieBuilder, n5, n3)));
            }
            ListBranchNode listBranchNode = new ListBranchNode(n4);
            do {
                char c2 = this.chars.charAt(n2);
                Node node = this.equal.get(n2);
                if (node.getClass() == ValueNode.class) {
                    listBranchNode.add((int)c2, ((ValueNode)node).value);
                    continue;
                }
                listBranchNode.add((int)c2, node.register(stringTrieBuilder));
            } while (++n2 < n3);
            return stringTrieBuilder.registerNode(listBranchNode);
        }

        private int find(char c2) {
            int n2 = 0;
            int n3 = this.chars.length();
            while (n2 < n3) {
                int n4 = (n2 + n3) / 2;
                char c3 = this.chars.charAt(n4);
                if (c2 < c3) {
                    n3 = n4;
                    continue;
                }
                if (c2 == c3) {
                    return n4;
                }
                n2 = n4 + 1;
            }
            return n2;
        }
    }

    private static final class LinearMatchNode
    extends ValueNode {
        private CharSequence strings;
        private int stringOffset;
        private int length;
        private Node next;
        private int hash;

        public LinearMatchNode(CharSequence charSequence, int n2, int n3, Node node) {
            this.strings = charSequence;
            this.stringOffset = n2;
            this.length = n3;
            this.next = node;
        }

        @Override
        public int hashCode() {
            return this.hash;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!super.equals(object)) {
                return false;
            }
            LinearMatchNode linearMatchNode = (LinearMatchNode)object;
            if (this.length != linearMatchNode.length || this.next != linearMatchNode.next) {
                return false;
            }
            int n2 = this.stringOffset;
            int n3 = linearMatchNode.stringOffset;
            int n4 = this.stringOffset + this.length;
            while (n2 < n4) {
                if (this.strings.charAt(n2) != this.strings.charAt(n3)) {
                    return false;
                }
                ++n2;
                ++n3;
            }
            return true;
        }

        @Override
        public Node add(StringTrieBuilder stringTrieBuilder, CharSequence charSequence, int n2, int n3) {
            if (n2 == charSequence.length()) {
                if (this.hasValue) {
                    throw new IllegalArgumentException("Duplicate string.");
                }
                this.setValue(n3);
                return this;
            }
            int n4 = this.stringOffset + this.length;
            int n5 = this.stringOffset;
            while (n5 < n4) {
                char c2;
                char c3;
                if (n2 == charSequence.length()) {
                    c3 = n5 - this.stringOffset;
                    LinearMatchNode linearMatchNode = new LinearMatchNode(this.strings, n5, this.length - c3, this.next);
                    linearMatchNode.setValue(n3);
                    this.length = c3;
                    this.next = linearMatchNode;
                    return this;
                }
                c3 = this.strings.charAt(n5);
                if (c3 != (c2 = charSequence.charAt(n2))) {
                    ValueNode valueNode;
                    Node node;
                    DynamicBranchNode dynamicBranchNode = new DynamicBranchNode();
                    if (n5 == this.stringOffset) {
                        if (this.hasValue) {
                            dynamicBranchNode.setValue(this.value);
                            this.value = 0;
                            this.hasValue = false;
                        }
                        ++this.stringOffset;
                        --this.length;
                        node = this.length > 0 ? this : this.next;
                        valueNode = dynamicBranchNode;
                    } else if (n5 == n4 - 1) {
                        --this.length;
                        node = this.next;
                        this.next = dynamicBranchNode;
                        valueNode = this;
                    } else {
                        int n6 = n5 - this.stringOffset;
                        node = new LinearMatchNode(this.strings, ++n5, this.length - (n6 + 1), this.next);
                        this.length = n6;
                        this.next = dynamicBranchNode;
                        valueNode = this;
                    }
                    ValueNode valueNode2 = stringTrieBuilder.createSuffixNode(charSequence, n2 + 1, n3);
                    dynamicBranchNode.add(c3, node);
                    dynamicBranchNode.add(c2, valueNode2);
                    return valueNode;
                }
                ++n5;
                ++n2;
            }
            this.next = this.next.add(stringTrieBuilder, charSequence, n2, n3);
            return this;
        }

        @Override
        public Node register(StringTrieBuilder stringTrieBuilder) {
            ValueNode valueNode;
            this.next = this.next.register(stringTrieBuilder);
            int n2 = stringTrieBuilder.getMaxLinearMatchLength();
            while (this.length > n2) {
                int n3 = this.stringOffset + this.length - n2;
                this.length -= n2;
                LinearMatchNode linearMatchNode = new LinearMatchNode(this.strings, n3, n2, this.next);
                linearMatchNode.setHashCode();
                this.next = stringTrieBuilder.registerNode(linearMatchNode);
            }
            if (this.hasValue && !stringTrieBuilder.matchNodesCanHaveValues()) {
                int n4 = this.value;
                this.value = 0;
                this.hasValue = false;
                this.setHashCode();
                valueNode = new IntermediateValueNode(n4, stringTrieBuilder.registerNode(this));
            } else {
                this.setHashCode();
                valueNode = this;
            }
            return stringTrieBuilder.registerNode(valueNode);
        }

        @Override
        public int markRightEdgesFirst(int n2) {
            if (this.offset == 0) {
                this.offset = n2 = this.next.markRightEdgesFirst(n2);
            }
            return n2;
        }

        @Override
        public void write(StringTrieBuilder stringTrieBuilder) {
            this.next.write(stringTrieBuilder);
            stringTrieBuilder.write(this.stringOffset, this.length);
            this.offset = stringTrieBuilder.writeValueAndType(this.hasValue, this.value, stringTrieBuilder.getMinLinearMatch() + this.length - 1);
        }

        private void setHashCode() {
            this.hash = (124151391 + this.length) * 37 + this.next.hashCode();
            if (this.hasValue) {
                this.hash = this.hash * 37 + this.value;
            }
            int n2 = this.stringOffset + this.length;
            for (int i2 = this.stringOffset; i2 < n2; ++i2) {
                this.hash = this.hash * 37 + this.strings.charAt(i2);
            }
        }
    }

    private static final class IntermediateValueNode
    extends ValueNode {
        private Node next;

        public IntermediateValueNode(int n2, Node node) {
            this.next = node;
            this.setValue(n2);
        }

        @Override
        public int hashCode() {
            return (0x4EEEEEA + this.value) * 37 + this.next.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!super.equals(object)) {
                return false;
            }
            IntermediateValueNode intermediateValueNode = (IntermediateValueNode)object;
            return this.next == intermediateValueNode.next;
        }

        @Override
        public int markRightEdgesFirst(int n2) {
            if (this.offset == 0) {
                this.offset = n2 = this.next.markRightEdgesFirst(n2);
            }
            return n2;
        }

        @Override
        public void write(StringTrieBuilder stringTrieBuilder) {
            this.next.write(stringTrieBuilder);
            this.offset = stringTrieBuilder.writeValueAndFinal(this.value, false);
        }
    }

    private static class ValueNode
    extends Node {
        protected boolean hasValue;
        protected int value;

        public ValueNode() {
        }

        public ValueNode(int n2) {
            this.hasValue = true;
            this.value = n2;
        }

        public final void setValue(int n2) {
            assert (!this.hasValue);
            this.hasValue = true;
            this.value = n2;
        }

        private void setFinalValue(int n2) {
            this.hasValue = true;
            this.value = n2;
        }

        @Override
        public int hashCode() {
            int n2 = 0x111111;
            if (this.hasValue) {
                n2 = n2 * 37 + this.value;
            }
            return n2;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!super.equals(object)) {
                return false;
            }
            ValueNode valueNode = (ValueNode)object;
            return this.hasValue == valueNode.hasValue && (!this.hasValue || this.value == valueNode.value);
        }

        @Override
        public Node add(StringTrieBuilder stringTrieBuilder, CharSequence charSequence, int n2, int n3) {
            if (n2 == charSequence.length()) {
                throw new IllegalArgumentException("Duplicate string.");
            }
            ValueNode valueNode = stringTrieBuilder.createSuffixNode(charSequence, n2, n3);
            valueNode.setValue(this.value);
            return valueNode;
        }

        @Override
        public void write(StringTrieBuilder stringTrieBuilder) {
            this.offset = stringTrieBuilder.writeValueAndFinal(this.value, true);
        }
    }

    private static abstract class Node {
        protected int offset = 0;

        public abstract int hashCode();

        public boolean equals(Object object) {
            return this == object || this.getClass() == object.getClass();
        }

        public Node add(StringTrieBuilder stringTrieBuilder, CharSequence charSequence, int n2, int n3) {
            return this;
        }

        public Node register(StringTrieBuilder stringTrieBuilder) {
            return this;
        }

        public int markRightEdgesFirst(int n2) {
            if (this.offset == 0) {
                this.offset = n2;
            }
            return n2;
        }

        public abstract void write(StringTrieBuilder var1);

        public final void writeUnlessInsideRightEdge(int n2, int n3, StringTrieBuilder stringTrieBuilder) {
            if (this.offset < 0 && (this.offset < n3 || n2 < this.offset)) {
                this.write(stringTrieBuilder);
            }
        }

        public final int getOffset() {
            return this.offset;
        }
    }

    public static enum Option {
        FAST,
        SMALL;

    }
}

