/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Date;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Grego;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.AnnualTimeZoneRule;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.BasicTimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.DateTimeRule;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.GregorianCalendar;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.InitialTimeZoneRule;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.STZInfo;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeZoneRule;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeZoneTransition;

public class SimpleTimeZone
extends BasicTimeZone {
    private static final long serialVersionUID = -7034676239311322769L;
    public static final int WALL_TIME = 0;
    public static final int STANDARD_TIME = 1;
    public static final int UTC_TIME = 2;
    private static final byte[] staticMonthLength = new byte[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int DOM_MODE = 1;
    private static final int DOW_IN_MONTH_MODE = 2;
    private static final int DOW_GE_DOM_MODE = 3;
    private static final int DOW_LE_DOM_MODE = 4;
    private int raw;
    private int dst = 3600000;
    private STZInfo xinfo = null;
    private int startMonth;
    private int startDay;
    private int startDayOfWeek;
    private int startTime;
    private int startTimeMode;
    private int endTimeMode;
    private int endMonth;
    private int endDay;
    private int endDayOfWeek;
    private int endTime;
    private int startYear;
    private boolean useDaylight;
    private int startMode;
    private int endMode;
    private transient boolean transitionRulesInitialized;
    private transient InitialTimeZoneRule initialRule;
    private transient TimeZoneTransition firstTransition;
    private transient AnnualTimeZoneRule stdRule;
    private transient AnnualTimeZoneRule dstRule;
    private volatile transient boolean isFrozen = false;

    public SimpleTimeZone(int n2, String string) {
        super(string);
        this.construct(n2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3600000);
    }

    public SimpleTimeZone(int n2, String string, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        super(string);
        this.construct(n2, n3, n4, n5, n6, 0, n7, n8, n9, n10, 0, 3600000);
    }

    public SimpleTimeZone(int n2, String string, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        super(string);
        this.construct(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13);
    }

    public SimpleTimeZone(int n2, String string, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        super(string);
        this.construct(n2, n3, n4, n5, n6, 0, n7, n8, n9, n10, 0, n11);
    }

    @Override
    public void setID(String string) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify a frozen SimpleTimeZone instance.");
        }
        super.setID(string);
        this.transitionRulesInitialized = false;
    }

    @Override
    public void setRawOffset(int n2) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify a frozen SimpleTimeZone instance.");
        }
        this.raw = n2;
        this.transitionRulesInitialized = false;
    }

    @Override
    public int getRawOffset() {
        return this.raw;
    }

    public void setStartYear(int n2) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify a frozen SimpleTimeZone instance.");
        }
        this.getSTZInfo().sy = n2;
        this.startYear = n2;
        this.transitionRulesInitialized = false;
    }

    public void setStartRule(int n2, int n3, int n4, int n5) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify a frozen SimpleTimeZone instance.");
        }
        this.getSTZInfo().setStart(n2, n3, n4, n5, -1, false);
        this.setStartRule(n2, n3, n4, n5, 0);
    }

    private void setStartRule(int n2, int n3, int n4, int n5, int n6) {
        assert (!this.isFrozen());
        this.startMonth = n2;
        this.startDay = n3;
        this.startDayOfWeek = n4;
        this.startTime = n5;
        this.startTimeMode = n6;
        this.decodeStartRule();
        this.transitionRulesInitialized = false;
    }

    public void setStartRule(int n2, int n3, int n4) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify a frozen SimpleTimeZone instance.");
        }
        this.getSTZInfo().setStart(n2, -1, -1, n4, n3, false);
        this.setStartRule(n2, n3, 0, n4, 0);
    }

    public void setStartRule(int n2, int n3, int n4, int n5, boolean bl2) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify a frozen SimpleTimeZone instance.");
        }
        this.getSTZInfo().setStart(n2, -1, n4, n5, n3, bl2);
        this.setStartRule(n2, bl2 ? n3 : -n3, -n4, n5, 0);
    }

    public void setEndRule(int n2, int n3, int n4, int n5) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify a frozen SimpleTimeZone instance.");
        }
        this.getSTZInfo().setEnd(n2, n3, n4, n5, -1, false);
        this.setEndRule(n2, n3, n4, n5, 0);
    }

    public void setEndRule(int n2, int n3, int n4) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify a frozen SimpleTimeZone instance.");
        }
        this.getSTZInfo().setEnd(n2, -1, -1, n4, n3, false);
        this.setEndRule(n2, n3, 0, n4);
    }

    public void setEndRule(int n2, int n3, int n4, int n5, boolean bl2) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify a frozen SimpleTimeZone instance.");
        }
        this.getSTZInfo().setEnd(n2, -1, n4, n5, n3, bl2);
        this.setEndRule(n2, n3, n4, n5, 0, bl2);
    }

    private void setEndRule(int n2, int n3, int n4, int n5, int n6, boolean bl2) {
        assert (!this.isFrozen());
        this.setEndRule(n2, bl2 ? n3 : -n3, -n4, n5, n6);
    }

    private void setEndRule(int n2, int n3, int n4, int n5, int n6) {
        assert (!this.isFrozen());
        this.endMonth = n2;
        this.endDay = n3;
        this.endDayOfWeek = n4;
        this.endTime = n5;
        this.endTimeMode = n6;
        this.decodeEndRule();
        this.transitionRulesInitialized = false;
    }

    public void setDSTSavings(int n2) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify a frozen SimpleTimeZone instance.");
        }
        if (n2 == 0) {
            throw new IllegalArgumentException();
        }
        this.dst = n2;
        this.transitionRulesInitialized = false;
    }

    @Override
    public int getDSTSavings() {
        return this.dst;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.xinfo != null) {
            this.xinfo.applyTo(this);
        }
    }

    public String toString() {
        return "SimpleTimeZone: " + this.getID();
    }

    private STZInfo getSTZInfo() {
        if (this.xinfo == null) {
            this.xinfo = new STZInfo();
        }
        return this.xinfo;
    }

    @Override
    public int getOffset(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n4 < 0 || n4 > 11) {
            throw new IllegalArgumentException();
        }
        return this.getOffset(n2, n3, n4, n5, n6, n7, Grego.monthLength(n3, n4));
    }

    @Deprecated
    public int getOffset(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (n4 < 0 || n4 > 11) {
            throw new IllegalArgumentException();
        }
        return this.getOffset(n2, n3, n4, n5, n6, n7, Grego.monthLength(n3, n4), Grego.previousMonthLength(n3, n4));
    }

    private int getOffset(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (n2 != 1 && n2 != 0 || n4 < 0 || n4 > 11 || n5 < 1 || n5 > n8 || n6 < 1 || n6 > 7 || n7 < 0 || n7 >= 86400000 || n8 < 28 || n8 > 31 || n9 < 28 || n9 > 31) {
            throw new IllegalArgumentException();
        }
        int n10 = this.raw;
        if (!this.useDaylight || n3 < this.startYear || n2 != 1) {
            return n10;
        }
        boolean bl2 = this.startMonth > this.endMonth;
        int n11 = this.compareToRule(n4, n8, n9, n5, n6, n7, this.startTimeMode == 2 ? -this.raw : 0, this.startMode, this.startMonth, this.startDayOfWeek, this.startDay, this.startTime);
        int n12 = 0;
        if (bl2 != n11 >= 0) {
            n12 = this.compareToRule(n4, n8, n9, n5, n6, n7, this.endTimeMode == 0 ? this.dst : (this.endTimeMode == 2 ? -this.raw : 0), this.endMode, this.endMonth, this.endDayOfWeek, this.endDay, this.endTime);
        }
        if (!bl2 && n11 >= 0 && n12 < 0 || bl2 && (n11 >= 0 || n12 < 0)) {
            n10 += this.dst;
        }
        return n10;
    }

    @Override
    public void getOffsetFromLocal(long l2, BasicTimeZone.LocalOption localOption, BasicTimeZone.LocalOption localOption2, int[] nArray) {
        int n2 = SimpleTimeZone.getLocalOptionValue(localOption);
        int n3 = SimpleTimeZone.getLocalOptionValue(localOption2);
        nArray[0] = this.getRawOffset();
        int[] nArray2 = new int[6];
        Grego.timeToFields(l2, nArray2);
        nArray[1] = this.getOffset(1, nArray2[0], nArray2[1], nArray2[2], nArray2[3], nArray2[5]) - nArray[0];
        boolean bl2 = false;
        if (nArray[1] > 0) {
            if ((n2 & 3) == 1 || (n2 & 3) != 3 && (n2 & 0xC) != 12) {
                l2 -= (long)this.getDSTSavings();
                bl2 = true;
            }
        } else if ((n3 & 3) == 3 || (n3 & 3) != 1 && (n3 & 0xC) == 4) {
            l2 -= (long)this.getDSTSavings();
            bl2 = true;
        }
        if (bl2) {
            Grego.timeToFields(l2, nArray2);
            nArray[1] = this.getOffset(1, nArray2[0], nArray2[1], nArray2[2], nArray2[3], nArray2[5]) - nArray[0];
        }
    }

    private int compareToRule(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        n7 += n8;
        while (n7 >= 86400000) {
            n7 -= 86400000;
            n6 = 1 + n6 % 7;
            if (++n5 <= n3) continue;
            n5 = 1;
            ++n2;
        }
        while (n7 < 0) {
            n6 = 1 + (n6 + 5) % 7;
            if (--n5 < 1) {
                n5 = n4;
                --n2;
            }
            n7 += 86400000;
        }
        if (n2 < n10) {
            return -1;
        }
        if (n2 > n10) {
            return 1;
        }
        int n14 = 0;
        if (n12 > n3) {
            n12 = n3;
        }
        switch (n9) {
            case 1: {
                n14 = n12;
                break;
            }
            case 2: {
                if (n12 > 0) {
                    n14 = 1 + (n12 - 1) * 7 + (7 + n11 - (n6 - n5 + 1)) % 7;
                    break;
                }
                n14 = n3 + (n12 + 1) * 7 - (7 + (n6 + n3 - n5) - n11) % 7;
                break;
            }
            case 3: {
                n14 = n12 + (49 + n11 - n12 - n6 + n5) % 7;
                break;
            }
            case 4: {
                n14 = n12 - (49 - n11 + n12 + n6 - n5) % 7;
            }
        }
        if (n5 < n14) {
            return -1;
        }
        if (n5 > n14) {
            return 1;
        }
        if (n7 < n13) {
            return -1;
        }
        if (n7 > n13) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean useDaylightTime() {
        return this.useDaylight;
    }

    @Override
    public boolean observesDaylightTime() {
        return this.useDaylight;
    }

    @Override
    public boolean inDaylightTime(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this);
        gregorianCalendar.setTime(date);
        return gregorianCalendar.inDaylightTime();
    }

    private void construct(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        this.raw = n2;
        this.startMonth = n3;
        this.startDay = n4;
        this.startDayOfWeek = n5;
        this.startTime = n6;
        this.startTimeMode = n7;
        this.endMonth = n8;
        this.endDay = n9;
        this.endDayOfWeek = n10;
        this.endTime = n11;
        this.endTimeMode = n12;
        this.dst = n13;
        this.startYear = 0;
        this.startMode = 1;
        this.endMode = 1;
        this.decodeRules();
        if (n13 == 0) {
            throw new IllegalArgumentException();
        }
    }

    private void decodeRules() {
        this.decodeStartRule();
        this.decodeEndRule();
    }

    private void decodeStartRule() {
        boolean bl2 = this.useDaylight = this.startDay != 0 && this.endDay != 0;
        if (this.useDaylight && this.dst == 0) {
            this.dst = 86400000;
        }
        if (this.startDay != 0) {
            if (this.startMonth < 0 || this.startMonth > 11) {
                throw new IllegalArgumentException();
            }
            if (this.startTime < 0 || this.startTime > 86400000 || this.startTimeMode < 0 || this.startTimeMode > 2) {
                throw new IllegalArgumentException();
            }
            if (this.startDayOfWeek == 0) {
                this.startMode = 1;
            } else {
                if (this.startDayOfWeek > 0) {
                    this.startMode = 2;
                } else {
                    this.startDayOfWeek = -this.startDayOfWeek;
                    if (this.startDay > 0) {
                        this.startMode = 3;
                    } else {
                        this.startDay = -this.startDay;
                        this.startMode = 4;
                    }
                }
                if (this.startDayOfWeek > 7) {
                    throw new IllegalArgumentException();
                }
            }
            if (this.startMode == 2 ? this.startDay < -5 || this.startDay > 5 : this.startDay < 1 || this.startDay > staticMonthLength[this.startMonth]) {
                throw new IllegalArgumentException();
            }
        }
    }

    private void decodeEndRule() {
        boolean bl2 = this.useDaylight = this.startDay != 0 && this.endDay != 0;
        if (this.useDaylight && this.dst == 0) {
            this.dst = 86400000;
        }
        if (this.endDay != 0) {
            if (this.endMonth < 0 || this.endMonth > 11) {
                throw new IllegalArgumentException();
            }
            if (this.endTime < 0 || this.endTime > 86400000 || this.endTimeMode < 0 || this.endTimeMode > 2) {
                throw new IllegalArgumentException();
            }
            if (this.endDayOfWeek == 0) {
                this.endMode = 1;
            } else {
                if (this.endDayOfWeek > 0) {
                    this.endMode = 2;
                } else {
                    this.endDayOfWeek = -this.endDayOfWeek;
                    if (this.endDay > 0) {
                        this.endMode = 3;
                    } else {
                        this.endDay = -this.endDay;
                        this.endMode = 4;
                    }
                }
                if (this.endDayOfWeek > 7) {
                    throw new IllegalArgumentException();
                }
            }
            if (this.endMode == 2 ? this.endDay < -5 || this.endDay > 5 : this.endDay < 1 || this.endDay > staticMonthLength[this.endMonth]) {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SimpleTimeZone simpleTimeZone = (SimpleTimeZone)object;
        return this.raw == simpleTimeZone.raw && this.useDaylight == simpleTimeZone.useDaylight && this.idEquals(this.getID(), simpleTimeZone.getID()) && (!this.useDaylight || this.dst == simpleTimeZone.dst && this.startMode == simpleTimeZone.startMode && this.startMonth == simpleTimeZone.startMonth && this.startDay == simpleTimeZone.startDay && this.startDayOfWeek == simpleTimeZone.startDayOfWeek && this.startTime == simpleTimeZone.startTime && this.startTimeMode == simpleTimeZone.startTimeMode && this.endMode == simpleTimeZone.endMode && this.endMonth == simpleTimeZone.endMonth && this.endDay == simpleTimeZone.endDay && this.endDayOfWeek == simpleTimeZone.endDayOfWeek && this.endTime == simpleTimeZone.endTime && this.endTimeMode == simpleTimeZone.endTimeMode && this.startYear == simpleTimeZone.startYear);
    }

    private boolean idEquals(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string != null && string2 != null) {
            return string.equals(string2);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode() + this.raw ^ (this.raw >>> 8) + (this.useDaylight ? 0 : 1);
        if (!this.useDaylight) {
            n2 += this.dst ^ (this.dst >>> 10) + this.startMode ^ (this.startMode >>> 11) + this.startMonth ^ (this.startMonth >>> 12) + this.startDay ^ (this.startDay >>> 13) + this.startDayOfWeek ^ (this.startDayOfWeek >>> 14) + this.startTime ^ (this.startTime >>> 15) + this.startTimeMode ^ (this.startTimeMode >>> 16) + this.endMode ^ (this.endMode >>> 17) + this.endMonth ^ (this.endMonth >>> 18) + this.endDay ^ (this.endDay >>> 19) + this.endDayOfWeek ^ (this.endDayOfWeek >>> 20) + this.endTime ^ (this.endTime >>> 21) + this.endTimeMode ^ (this.endTimeMode >>> 22) + this.startYear ^ this.startYear >>> 23;
        }
        return n2;
    }

    @Override
    public Object clone() {
        if (this.isFrozen()) {
            return this;
        }
        return this.cloneAsThawed();
    }

    @Override
    public boolean hasSameRules(TimeZone timeZone) {
        if (this == timeZone) {
            return true;
        }
        if (!(timeZone instanceof SimpleTimeZone)) {
            return false;
        }
        SimpleTimeZone simpleTimeZone = (SimpleTimeZone)timeZone;
        return simpleTimeZone != null && this.raw == simpleTimeZone.raw && this.useDaylight == simpleTimeZone.useDaylight && (!this.useDaylight || this.dst == simpleTimeZone.dst && this.startMode == simpleTimeZone.startMode && this.startMonth == simpleTimeZone.startMonth && this.startDay == simpleTimeZone.startDay && this.startDayOfWeek == simpleTimeZone.startDayOfWeek && this.startTime == simpleTimeZone.startTime && this.startTimeMode == simpleTimeZone.startTimeMode && this.endMode == simpleTimeZone.endMode && this.endMonth == simpleTimeZone.endMonth && this.endDay == simpleTimeZone.endDay && this.endDayOfWeek == simpleTimeZone.endDayOfWeek && this.endTime == simpleTimeZone.endTime && this.endTimeMode == simpleTimeZone.endTimeMode && this.startYear == simpleTimeZone.startYear);
    }

    @Override
    public TimeZoneTransition getNextTransition(long l2, boolean bl2) {
        if (!this.useDaylight) {
            return null;
        }
        this.initTransitionRules();
        long l3 = this.firstTransition.getTime();
        if (l2 < l3 || bl2 && l2 == l3) {
            return this.firstTransition;
        }
        Date date = this.stdRule.getNextStart(l2, this.dstRule.getRawOffset(), this.dstRule.getDSTSavings(), bl2);
        Date date2 = this.dstRule.getNextStart(l2, this.stdRule.getRawOffset(), this.stdRule.getDSTSavings(), bl2);
        if (date != null && (date2 == null || date.before(date2))) {
            return new TimeZoneTransition(date.getTime(), this.dstRule, this.stdRule);
        }
        if (date2 != null && (date == null || date2.before(date))) {
            return new TimeZoneTransition(date2.getTime(), this.stdRule, this.dstRule);
        }
        return null;
    }

    @Override
    public TimeZoneTransition getPreviousTransition(long l2, boolean bl2) {
        if (!this.useDaylight) {
            return null;
        }
        this.initTransitionRules();
        long l3 = this.firstTransition.getTime();
        if (l2 < l3 || !bl2 && l2 == l3) {
            return null;
        }
        Date date = this.stdRule.getPreviousStart(l2, this.dstRule.getRawOffset(), this.dstRule.getDSTSavings(), bl2);
        Date date2 = this.dstRule.getPreviousStart(l2, this.stdRule.getRawOffset(), this.stdRule.getDSTSavings(), bl2);
        if (date != null && (date2 == null || date.after(date2))) {
            return new TimeZoneTransition(date.getTime(), this.dstRule, this.stdRule);
        }
        if (date2 != null && (date == null || date2.after(date))) {
            return new TimeZoneTransition(date2.getTime(), this.stdRule, this.dstRule);
        }
        return null;
    }

    @Override
    public TimeZoneRule[] getTimeZoneRules() {
        this.initTransitionRules();
        int n2 = this.useDaylight ? 3 : 1;
        TimeZoneRule[] timeZoneRuleArray = new TimeZoneRule[n2];
        timeZoneRuleArray[0] = this.initialRule;
        if (this.useDaylight) {
            timeZoneRuleArray[1] = this.stdRule;
            timeZoneRuleArray[2] = this.dstRule;
        }
        return timeZoneRuleArray;
    }

    private synchronized void initTransitionRules() {
        if (this.transitionRulesInitialized) {
            return;
        }
        if (this.useDaylight) {
            DateTimeRule dateTimeRule = null;
            int n2 = this.startTimeMode == 1 ? 1 : (this.startTimeMode == 2 ? 2 : 0);
            switch (this.startMode) {
                case 1: {
                    dateTimeRule = new DateTimeRule(this.startMonth, this.startDay, this.startTime, n2);
                    break;
                }
                case 2: {
                    dateTimeRule = new DateTimeRule(this.startMonth, this.startDay, this.startDayOfWeek, this.startTime, n2);
                    break;
                }
                case 3: {
                    dateTimeRule = new DateTimeRule(this.startMonth, this.startDay, this.startDayOfWeek, true, this.startTime, n2);
                    break;
                }
                case 4: {
                    dateTimeRule = new DateTimeRule(this.startMonth, this.startDay, this.startDayOfWeek, false, this.startTime, n2);
                }
            }
            this.dstRule = new AnnualTimeZoneRule(this.getID() + "(DST)", this.getRawOffset(), this.getDSTSavings(), dateTimeRule, this.startYear, Integer.MAX_VALUE);
            long l2 = this.dstRule.getFirstStart(this.getRawOffset(), 0).getTime();
            n2 = this.endTimeMode == 1 ? 1 : (this.endTimeMode == 2 ? 2 : 0);
            switch (this.endMode) {
                case 1: {
                    dateTimeRule = new DateTimeRule(this.endMonth, this.endDay, this.endTime, n2);
                    break;
                }
                case 2: {
                    dateTimeRule = new DateTimeRule(this.endMonth, this.endDay, this.endDayOfWeek, this.endTime, n2);
                    break;
                }
                case 3: {
                    dateTimeRule = new DateTimeRule(this.endMonth, this.endDay, this.endDayOfWeek, true, this.endTime, n2);
                    break;
                }
                case 4: {
                    dateTimeRule = new DateTimeRule(this.endMonth, this.endDay, this.endDayOfWeek, false, this.endTime, n2);
                }
            }
            this.stdRule = new AnnualTimeZoneRule(this.getID() + "(STD)", this.getRawOffset(), 0, dateTimeRule, this.startYear, Integer.MAX_VALUE);
            long l3 = this.stdRule.getFirstStart(this.getRawOffset(), this.dstRule.getDSTSavings()).getTime();
            if (l3 < l2) {
                this.initialRule = new InitialTimeZoneRule(this.getID() + "(DST)", this.getRawOffset(), this.dstRule.getDSTSavings());
                this.firstTransition = new TimeZoneTransition(l3, this.initialRule, this.stdRule);
            } else {
                this.initialRule = new InitialTimeZoneRule(this.getID() + "(STD)", this.getRawOffset(), 0);
                this.firstTransition = new TimeZoneTransition(l2, this.initialRule, this.dstRule);
            }
        } else {
            this.initialRule = new InitialTimeZoneRule(this.getID(), this.getRawOffset(), 0);
        }
        this.transitionRulesInitialized = true;
    }

    @Override
    public boolean isFrozen() {
        return this.isFrozen;
    }

    @Override
    public TimeZone freeze() {
        this.isFrozen = true;
        return this;
    }

    @Override
    public TimeZone cloneAsThawed() {
        SimpleTimeZone simpleTimeZone = (SimpleTimeZone)super.cloneAsThawed();
        simpleTimeZone.isFrozen = false;
        return simpleTimeZone;
    }
}

