/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.util;

import java.util.Date;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Calendar;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.DateRule;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.GregorianCalendar;

public class SimpleDateRule
implements DateRule {
    private Calendar calendar = new GregorianCalendar();
    private int month;
    private int dayOfMonth;
    private int dayOfWeek;

    public SimpleDateRule(int n2, int n3) {
        this.month = n2;
        this.dayOfMonth = n3;
        this.dayOfWeek = 0;
    }

    SimpleDateRule(int n2, int n3, Calendar calendar) {
        this.month = n2;
        this.dayOfMonth = n3;
        this.dayOfWeek = 0;
        this.calendar = calendar;
    }

    public SimpleDateRule(int n2, int n3, int n4, boolean bl2) {
        this.month = n2;
        this.dayOfMonth = n3;
        this.dayOfWeek = bl2 ? n4 : -n4;
    }

    @Override
    public Date firstAfter(Date date) {
        return this.doFirstBetween(date, null);
    }

    @Override
    public Date firstBetween(Date date, Date date2) {
        return this.doFirstBetween(date, date2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOn(Date date) {
        Calendar calendar;
        Calendar calendar2 = calendar = this.calendar;
        synchronized (calendar2) {
            calendar.setTime(date);
            int n2 = calendar.get(6);
            calendar.setTime(this.computeInYear(calendar.get(1), calendar));
            return calendar.get(6) == n2;
        }
    }

    @Override
    public boolean isBetween(Date date, Date date2) {
        return this.firstBetween(date, date2) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date doFirstBetween(Date date, Date date2) {
        Calendar calendar;
        Calendar calendar2 = calendar = this.calendar;
        synchronized (calendar2) {
            calendar.setTime(date);
            int n2 = calendar.get(1);
            int n3 = calendar.get(2);
            if (n3 > this.month) {
                ++n2;
            }
            Date date3 = this.computeInYear(n2, calendar);
            if (n3 == this.month && date3.before(date)) {
                date3 = this.computeInYear(n2 + 1, calendar);
            }
            if (date2 != null && date3.after(date2)) {
                return null;
            }
            return date3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date computeInYear(int n2, Calendar calendar) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            calendar.clear();
            calendar.set(0, calendar.getMaximum(0));
            calendar.set(1, n2);
            calendar.set(2, this.month);
            calendar.set(5, this.dayOfMonth);
            if (this.dayOfWeek != 0) {
                calendar.setTime(calendar.getTime());
                int n3 = calendar.get(7);
                int n4 = 0;
                n4 = this.dayOfWeek > 0 ? (this.dayOfWeek - n3 + 7) % 7 : -((this.dayOfWeek + n3 + 7) % 7);
                calendar.add(5, n4);
            }
            return calendar.getTime();
        }
    }
}

