/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.List;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Grego;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.AnnualTimeZoneRule;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.BasicTimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.InitialTimeZoneRule;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeZoneRule;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeZoneTransition;

public class RuleBasedTimeZone
extends BasicTimeZone {
    private static final long serialVersionUID = 7580833058949327935L;
    private final InitialTimeZoneRule initialRule;
    private List<TimeZoneRule> historicRules;
    private AnnualTimeZoneRule[] finalRules;
    private transient List<TimeZoneTransition> historicTransitions;
    private transient boolean upToDate;
    private volatile transient boolean isFrozen = false;

    public RuleBasedTimeZone(String string, InitialTimeZoneRule initialTimeZoneRule) {
        super(string);
        this.initialRule = initialTimeZoneRule;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addTransitionRule(TimeZoneRule timeZoneRule) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify a frozen RuleBasedTimeZone instance.");
        }
        if (!timeZoneRule.isTransitionRule()) {
            throw new IllegalArgumentException("Rule must be a transition rule");
        }
        if (timeZoneRule instanceof AnnualTimeZoneRule && ((AnnualTimeZoneRule)timeZoneRule).getEndYear() == Integer.MAX_VALUE) {
            if (this.finalRules == null) {
                this.finalRules = new AnnualTimeZoneRule[2];
                this.finalRules[0] = (AnnualTimeZoneRule)timeZoneRule;
            } else {
                if (this.finalRules[1] != null) throw new IllegalStateException("Too many final rules");
                this.finalRules[1] = (AnnualTimeZoneRule)timeZoneRule;
            }
        } else {
            if (this.historicRules == null) {
                this.historicRules = new ArrayList<TimeZoneRule>();
            }
            this.historicRules.add(timeZoneRule);
        }
        this.upToDate = false;
    }

    @Override
    public int getOffset(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n2 == 0) {
            n3 = 1 - n3;
        }
        long l2 = Grego.fieldsToDay(n3, n4, n5) * 86400000L + (long)n7;
        int[] nArray = new int[2];
        this.getOffset(l2, true, 3, 1, nArray);
        return nArray[0] + nArray[1];
    }

    @Override
    public void getOffset(long l2, boolean bl2, int[] nArray) {
        this.getOffset(l2, bl2, 4, 12, nArray);
    }

    @Override
    public void getOffsetFromLocal(long l2, BasicTimeZone.LocalOption localOption, BasicTimeZone.LocalOption localOption2, int[] nArray) {
        int n2 = RuleBasedTimeZone.getLocalOptionValue(localOption);
        int n3 = RuleBasedTimeZone.getLocalOptionValue(localOption2);
        this.getOffset(l2, true, n2, n3, nArray);
    }

    @Override
    public int getRawOffset() {
        long l2 = System.currentTimeMillis();
        int[] nArray = new int[2];
        this.getOffset(l2, false, nArray);
        return nArray[0];
    }

    @Override
    public boolean inDaylightTime(Date date) {
        int[] nArray = new int[2];
        this.getOffset(date.getTime(), false, nArray);
        return nArray[1] != 0;
    }

    @Override
    public void setRawOffset(int n2) {
        throw new UnsupportedOperationException("setRawOffset in RuleBasedTimeZone is not supported.");
    }

    @Override
    public boolean useDaylightTime() {
        long l2 = System.currentTimeMillis();
        int[] nArray = new int[2];
        this.getOffset(l2, false, nArray);
        if (nArray[1] != 0) {
            return true;
        }
        TimeZoneTransition timeZoneTransition = this.getNextTransition(l2, false);
        return timeZoneTransition != null && timeZoneTransition.getTo().getDSTSavings() != 0;
    }

    @Override
    public boolean observesDaylightTime() {
        TimeZoneTransition timeZoneTransition;
        BitSet bitSet;
        long l2 = System.currentTimeMillis();
        int[] nArray = new int[2];
        this.getOffset(l2, false, nArray);
        if (nArray[1] != 0) {
            return true;
        }
        BitSet bitSet2 = bitSet = this.finalRules == null ? null : new BitSet(this.finalRules.length);
        while ((timeZoneTransition = this.getNextTransition(l2, false)) != null) {
            TimeZoneRule timeZoneRule = timeZoneTransition.getTo();
            if (timeZoneRule.getDSTSavings() != 0) {
                return true;
            }
            if (bitSet != null) {
                for (int i2 = 0; i2 < this.finalRules.length; ++i2) {
                    if (!this.finalRules[i2].equals(timeZoneRule)) continue;
                    bitSet.set(i2);
                }
                if (bitSet.cardinality() == this.finalRules.length) break;
            }
            l2 = timeZoneTransition.getTime();
        }
        return false;
    }

    @Override
    public boolean hasSameRules(TimeZone timeZone) {
        if (this == timeZone) {
            return true;
        }
        if (!(timeZone instanceof RuleBasedTimeZone)) {
            return false;
        }
        RuleBasedTimeZone ruleBasedTimeZone = (RuleBasedTimeZone)timeZone;
        if (!this.initialRule.isEquivalentTo(ruleBasedTimeZone.initialRule)) {
            return false;
        }
        if (this.finalRules != null && ruleBasedTimeZone.finalRules != null) {
            for (int i2 = 0; i2 < this.finalRules.length; ++i2) {
                if (this.finalRules[i2] == null && ruleBasedTimeZone.finalRules[i2] == null || this.finalRules[i2] != null && ruleBasedTimeZone.finalRules[i2] != null && this.finalRules[i2].isEquivalentTo(ruleBasedTimeZone.finalRules[i2])) continue;
                return false;
            }
        } else if (this.finalRules != null || ruleBasedTimeZone.finalRules != null) {
            return false;
        }
        if (this.historicRules != null && ruleBasedTimeZone.historicRules != null) {
            if (this.historicRules.size() != ruleBasedTimeZone.historicRules.size()) {
                return false;
            }
            for (TimeZoneRule timeZoneRule : this.historicRules) {
                boolean bl2 = false;
                for (TimeZoneRule timeZoneRule2 : ruleBasedTimeZone.historicRules) {
                    if (!timeZoneRule.isEquivalentTo(timeZoneRule2)) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                return false;
            }
        } else if (this.historicRules != null || ruleBasedTimeZone.historicRules != null) {
            return false;
        }
        return true;
    }

    @Override
    public TimeZoneRule[] getTimeZoneRules() {
        int n2 = 1;
        if (this.historicRules != null) {
            n2 += this.historicRules.size();
        }
        if (this.finalRules != null) {
            n2 = this.finalRules[1] != null ? (n2 += 2) : ++n2;
        }
        TimeZoneRule[] timeZoneRuleArray = new TimeZoneRule[n2];
        timeZoneRuleArray[0] = this.initialRule;
        if (this.historicRules != null) {
            for (int i2 = 1; i2 < this.historicRules.size() + 1; ++i2) {
                timeZoneRuleArray[i2] = this.historicRules.get(i2 - 1);
            }
        }
        if (this.finalRules != null) {
            timeZoneRuleArray[i2++] = this.finalRules[0];
            if (this.finalRules[1] != null) {
                timeZoneRuleArray[i2] = this.finalRules[1];
            }
        }
        return timeZoneRuleArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TimeZoneTransition getNextTransition(long l2, boolean bl2) {
        Object object;
        Object object2;
        this.complete();
        if (this.historicTransitions == null) {
            return null;
        }
        boolean bl3 = false;
        TimeZoneTransition timeZoneTransition = this.historicTransitions.get(0);
        long l3 = timeZoneTransition.getTime();
        if (l3 > l2 || bl2 && l3 == l2) {
            object2 = timeZoneTransition;
        } else {
            int n2 = this.historicTransitions.size() - 1;
            timeZoneTransition = this.historicTransitions.get(n2);
            l3 = timeZoneTransition.getTime();
            if (bl2 && l3 == l2) {
                object2 = timeZoneTransition;
            } else if (l3 <= l2) {
                if (this.finalRules == null) return null;
                object = this.finalRules[0].getNextStart(l2, this.finalRules[1].getRawOffset(), this.finalRules[1].getDSTSavings(), bl2);
                Date date = this.finalRules[1].getNextStart(l2, this.finalRules[0].getRawOffset(), this.finalRules[0].getDSTSavings(), bl2);
                timeZoneTransition = date.after((Date)object) ? new TimeZoneTransition(((Date)object).getTime(), this.finalRules[1], this.finalRules[0]) : new TimeZoneTransition(date.getTime(), this.finalRules[0], this.finalRules[1]);
                object2 = timeZoneTransition;
                bl3 = true;
            } else {
                --n2;
                object = timeZoneTransition;
                while (n2 > 0 && (l3 = (timeZoneTransition = this.historicTransitions.get(n2)).getTime()) >= l2 && (bl2 || l3 != l2)) {
                    --n2;
                    object = timeZoneTransition;
                }
                object2 = object;
            }
        }
        TimeZoneRule timeZoneRule = ((TimeZoneTransition)object2).getFrom();
        object = ((TimeZoneTransition)object2).getTo();
        if (timeZoneRule.getRawOffset() != ((TimeZoneRule)object).getRawOffset()) return object2;
        if (timeZoneRule.getDSTSavings() != ((TimeZoneRule)object).getDSTSavings()) return object2;
        if (!bl3) return this.getNextTransition(((TimeZoneTransition)object2).getTime(), false);
        return null;
    }

    @Override
    public TimeZoneTransition getPreviousTransition(long l2, boolean bl2) {
        Serializable serializable;
        TimeZoneTransition timeZoneTransition;
        this.complete();
        if (this.historicTransitions == null) {
            return null;
        }
        TimeZoneTransition timeZoneTransition2 = this.historicTransitions.get(0);
        long l3 = timeZoneTransition2.getTime();
        if (bl2 && l3 == l2) {
            timeZoneTransition = timeZoneTransition2;
        } else {
            if (l3 >= l2) {
                return null;
            }
            int n2 = this.historicTransitions.size() - 1;
            timeZoneTransition2 = this.historicTransitions.get(n2);
            l3 = timeZoneTransition2.getTime();
            if (bl2 && l3 == l2) {
                timeZoneTransition = timeZoneTransition2;
            } else if (l3 < l2) {
                if (this.finalRules != null) {
                    serializable = this.finalRules[0].getPreviousStart(l2, this.finalRules[1].getRawOffset(), this.finalRules[1].getDSTSavings(), bl2);
                    Date date = this.finalRules[1].getPreviousStart(l2, this.finalRules[0].getRawOffset(), this.finalRules[0].getDSTSavings(), bl2);
                    timeZoneTransition2 = date.before((Date)serializable) ? new TimeZoneTransition(((Date)serializable).getTime(), this.finalRules[1], this.finalRules[0]) : new TimeZoneTransition(date.getTime(), this.finalRules[0], this.finalRules[1]);
                }
                timeZoneTransition = timeZoneTransition2;
            } else {
                --n2;
                while (!(n2 < 0 || (l3 = (timeZoneTransition2 = this.historicTransitions.get(n2)).getTime()) < l2 || bl2 && l3 == l2)) {
                    --n2;
                }
                timeZoneTransition = timeZoneTransition2;
            }
        }
        TimeZoneRule timeZoneRule = timeZoneTransition.getFrom();
        serializable = timeZoneTransition.getTo();
        if (timeZoneRule.getRawOffset() == ((TimeZoneRule)serializable).getRawOffset() && timeZoneRule.getDSTSavings() == ((TimeZoneRule)serializable).getDSTSavings()) {
            timeZoneTransition = this.getPreviousTransition(timeZoneTransition.getTime(), false);
        }
        return timeZoneTransition;
    }

    @Override
    public Object clone() {
        if (this.isFrozen()) {
            return this;
        }
        return this.cloneAsThawed();
    }

    private void complete() {
        if (this.upToDate) {
            return;
        }
        if (this.finalRules != null && this.finalRules[1] == null) {
            throw new IllegalStateException("Incomplete final rules");
        }
        if (this.historicRules != null || this.finalRules != null) {
            Cloneable cloneable;
            InitialTimeZoneRule initialTimeZoneRule = this.initialRule;
            long l2 = -184303902528000000L;
            if (this.historicRules != null) {
                cloneable = new BitSet(this.historicRules.size());
                while (true) {
                    long l3;
                    Date date;
                    int n2;
                    int n3 = initialTimeZoneRule.getRawOffset();
                    int n4 = initialTimeZoneRule.getDSTSavings();
                    long l4 = 183882168921600000L;
                    TimeZoneRule timeZoneRule = null;
                    for (n2 = 0; n2 < this.historicRules.size(); ++n2) {
                        if (((BitSet)cloneable).get(n2)) continue;
                        TimeZoneRule timeZoneRule2 = this.historicRules.get(n2);
                        date = timeZoneRule2.getNextStart(l2, n3, n4, false);
                        if (date == null) {
                            ((BitSet)cloneable).set(n2);
                            continue;
                        }
                        if (timeZoneRule2 == initialTimeZoneRule || timeZoneRule2.getName().equals(initialTimeZoneRule.getName()) && timeZoneRule2.getRawOffset() == initialTimeZoneRule.getRawOffset() && timeZoneRule2.getDSTSavings() == initialTimeZoneRule.getDSTSavings() || (l3 = date.getTime()) >= l4) continue;
                        l4 = l3;
                        timeZoneRule = timeZoneRule2;
                    }
                    if (timeZoneRule == null) {
                        n2 = 1;
                        for (int i2 = 0; i2 < this.historicRules.size(); ++i2) {
                            if (((BitSet)cloneable).get(i2)) continue;
                            n2 = 0;
                            break;
                        }
                        if (n2 != 0) break;
                    }
                    if (this.finalRules != null) {
                        for (n2 = 0; n2 < 2; ++n2) {
                            if (this.finalRules[n2] == initialTimeZoneRule || (date = this.finalRules[n2].getNextStart(l2, n3, n4, false)) == null || (l3 = date.getTime()) >= l4) continue;
                            l4 = l3;
                            timeZoneRule = this.finalRules[n2];
                        }
                    }
                    if (timeZoneRule == null) break;
                    if (this.historicTransitions == null) {
                        this.historicTransitions = new ArrayList<TimeZoneTransition>();
                    }
                    this.historicTransitions.add(new TimeZoneTransition(l4, initialTimeZoneRule, timeZoneRule));
                    l2 = l4;
                    initialTimeZoneRule = timeZoneRule;
                }
            }
            if (this.finalRules != null) {
                if (this.historicTransitions == null) {
                    this.historicTransitions = new ArrayList<TimeZoneTransition>();
                }
                cloneable = this.finalRules[0].getNextStart(l2, initialTimeZoneRule.getRawOffset(), initialTimeZoneRule.getDSTSavings(), false);
                Date date = this.finalRules[1].getNextStart(l2, initialTimeZoneRule.getRawOffset(), initialTimeZoneRule.getDSTSavings(), false);
                if (date.after((Date)cloneable)) {
                    this.historicTransitions.add(new TimeZoneTransition(((Date)cloneable).getTime(), initialTimeZoneRule, this.finalRules[0]));
                    date = this.finalRules[1].getNextStart(((Date)cloneable).getTime(), this.finalRules[0].getRawOffset(), this.finalRules[0].getDSTSavings(), false);
                    this.historicTransitions.add(new TimeZoneTransition(date.getTime(), this.finalRules[0], this.finalRules[1]));
                } else {
                    this.historicTransitions.add(new TimeZoneTransition(date.getTime(), initialTimeZoneRule, this.finalRules[1]));
                    cloneable = this.finalRules[0].getNextStart(date.getTime(), this.finalRules[1].getRawOffset(), this.finalRules[1].getDSTSavings(), false);
                    this.historicTransitions.add(new TimeZoneTransition(((Date)cloneable).getTime(), this.finalRules[1], this.finalRules[0]));
                }
            }
        }
        this.upToDate = true;
    }

    private void getOffset(long l2, boolean bl2, int n2, int n3, int[] nArray) {
        this.complete();
        TimeZoneRule timeZoneRule = null;
        if (this.historicTransitions == null) {
            timeZoneRule = this.initialRule;
        } else {
            long l3 = RuleBasedTimeZone.getTransitionTime(this.historicTransitions.get(0), bl2, n2, n3);
            if (l2 < l3) {
                timeZoneRule = this.initialRule;
            } else {
                int n4 = this.historicTransitions.size() - 1;
                long l4 = RuleBasedTimeZone.getTransitionTime(this.historicTransitions.get(n4), bl2, n2, n3);
                if (l2 > l4) {
                    if (this.finalRules != null) {
                        timeZoneRule = this.findRuleInFinal(l2, bl2, n2, n3);
                    }
                    if (timeZoneRule == null) {
                        timeZoneRule = this.historicTransitions.get(n4).getTo();
                    }
                } else {
                    while (n4 >= 0 && l2 < RuleBasedTimeZone.getTransitionTime(this.historicTransitions.get(n4), bl2, n2, n3)) {
                        --n4;
                    }
                    timeZoneRule = this.historicTransitions.get(n4).getTo();
                }
            }
        }
        nArray[0] = timeZoneRule.getRawOffset();
        nArray[1] = timeZoneRule.getDSTSavings();
    }

    private TimeZoneRule findRuleInFinal(long l2, boolean bl2, int n2, int n3) {
        int n4;
        if (this.finalRules == null || this.finalRules.length != 2 || this.finalRules[0] == null || this.finalRules[1] == null) {
            return null;
        }
        long l3 = l2;
        if (bl2) {
            n4 = RuleBasedTimeZone.getLocalDelta(this.finalRules[1].getRawOffset(), this.finalRules[1].getDSTSavings(), this.finalRules[0].getRawOffset(), this.finalRules[0].getDSTSavings(), n2, n3);
            l3 -= (long)n4;
        }
        Date date = this.finalRules[0].getPreviousStart(l3, this.finalRules[1].getRawOffset(), this.finalRules[1].getDSTSavings(), true);
        l3 = l2;
        if (bl2) {
            n4 = RuleBasedTimeZone.getLocalDelta(this.finalRules[0].getRawOffset(), this.finalRules[0].getDSTSavings(), this.finalRules[1].getRawOffset(), this.finalRules[1].getDSTSavings(), n2, n3);
            l3 -= (long)n4;
        }
        Date date2 = this.finalRules[1].getPreviousStart(l3, this.finalRules[0].getRawOffset(), this.finalRules[0].getDSTSavings(), true);
        if (date == null || date2 == null) {
            if (date != null) {
                return this.finalRules[0];
            }
            if (date2 != null) {
                return this.finalRules[1];
            }
            return null;
        }
        return date.after(date2) ? this.finalRules[0] : this.finalRules[1];
    }

    private static long getTransitionTime(TimeZoneTransition timeZoneTransition, boolean bl2, int n2, int n3) {
        long l2 = timeZoneTransition.getTime();
        if (bl2) {
            l2 += (long)RuleBasedTimeZone.getLocalDelta(timeZoneTransition.getFrom().getRawOffset(), timeZoneTransition.getFrom().getDSTSavings(), timeZoneTransition.getTo().getRawOffset(), timeZoneTransition.getTo().getDSTSavings(), n2, n3);
        }
        return l2;
    }

    private static int getLocalDelta(int n2, int n3, int n4, int n5, int n6, int n7) {
        boolean bl2;
        int n8 = 0;
        int n9 = n2 + n3;
        int n10 = n4 + n5;
        boolean bl3 = n3 != 0 && n5 == 0;
        boolean bl4 = bl2 = n3 == 0 && n5 != 0;
        n8 = n10 - n9 >= 0 ? ((n6 & 3) == 1 && bl3 || (n6 & 3) == 3 && bl2 ? n9 : ((n6 & 3) == 1 && bl2 || (n6 & 3) == 3 && bl3 ? n10 : ((n6 & 0xC) == 12 ? n9 : n10))) : ((n7 & 3) == 1 && bl3 || (n7 & 3) == 3 && bl2 ? n10 : ((n7 & 3) == 1 && bl2 || (n7 & 3) == 3 && bl3 ? n9 : ((n7 & 0xC) == 4 ? n9 : n10)));
        return n8;
    }

    @Override
    public boolean isFrozen() {
        return this.isFrozen;
    }

    @Override
    public TimeZone freeze() {
        this.complete();
        this.isFrozen = true;
        return this;
    }

    @Override
    public TimeZone cloneAsThawed() {
        RuleBasedTimeZone ruleBasedTimeZone = (RuleBasedTimeZone)super.cloneAsThawed();
        if (this.historicRules != null) {
            ruleBasedTimeZone.historicRules = new ArrayList<TimeZoneRule>(this.historicRules);
        }
        if (this.finalRules != null) {
            ruleBasedTimeZone.finalRules = (AnnualTimeZoneRule[])this.finalRules.clone();
        }
        ruleBasedTimeZone.isFrozen = false;
        return ruleBasedTimeZone;
    }
}

