/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.util;

import java.util.Arrays;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.CodePointMap;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.CodePointTrie;

public final class MutableCodePointTrie
extends CodePointMap
implements Cloneable {
    private static final int MAX_UNICODE = 0x10FFFF;
    private static final int UNICODE_LIMIT = 0x110000;
    private static final int BMP_LIMIT = 65536;
    private static final int ASCII_LIMIT = 128;
    private static final int I_LIMIT = 69632;
    private static final int BMP_I_LIMIT = 4096;
    private static final int ASCII_I_LIMIT = 8;
    private static final int SMALL_DATA_BLOCKS_PER_BMP_BLOCK = 4;
    private static final byte ALL_SAME = 0;
    private static final byte MIXED = 1;
    private static final byte SAME_AS = 2;
    private static final int INITIAL_DATA_LENGTH = 16384;
    private static final int MEDIUM_DATA_LENGTH = 131072;
    private static final int MAX_DATA_LENGTH = 0x110000;
    private static final byte I3_NULL = 0;
    private static final byte I3_BMP = 1;
    private static final byte I3_16 = 2;
    private static final byte I3_18 = 3;
    private static final int INDEX_3_18BIT_BLOCK_LENGTH = 36;
    private int[] index;
    private int index3NullOffset = -1;
    private int[] data;
    private int dataLength;
    private int dataNullOffset = -1;
    private int origInitialValue;
    private int initialValue;
    private int errorValue;
    private int highStart;
    private int highValue;
    private char[] index16;
    private byte[] flags = new byte[69632];

    public MutableCodePointTrie(int n2, int n3) {
        this.index = new int[4096];
        this.data = new int[16384];
        this.origInitialValue = n2;
        this.initialValue = n2;
        this.errorValue = n3;
        this.highValue = n2;
    }

    public MutableCodePointTrie clone() {
        try {
            MutableCodePointTrie mutableCodePointTrie = (MutableCodePointTrie)super.clone();
            int n2 = this.highStart <= 65536 ? 4096 : 69632;
            mutableCodePointTrie.index = new int[n2];
            mutableCodePointTrie.flags = new byte[69632];
            int n3 = this.highStart >> 4;
            for (int i2 = 0; i2 < n3; ++i2) {
                mutableCodePointTrie.index[i2] = this.index[i2];
                mutableCodePointTrie.flags[i2] = this.flags[i2];
            }
            mutableCodePointTrie.index3NullOffset = this.index3NullOffset;
            mutableCodePointTrie.data = (int[])this.data.clone();
            mutableCodePointTrie.dataLength = this.dataLength;
            mutableCodePointTrie.dataNullOffset = this.dataNullOffset;
            mutableCodePointTrie.origInitialValue = this.origInitialValue;
            mutableCodePointTrie.initialValue = this.initialValue;
            mutableCodePointTrie.errorValue = this.errorValue;
            mutableCodePointTrie.highStart = this.highStart;
            mutableCodePointTrie.highValue = this.highValue;
            assert (this.index16 == null);
            return mutableCodePointTrie;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public static MutableCodePointTrie fromCodePointMap(CodePointMap codePointMap) {
        int n2 = codePointMap.get(-1);
        int n3 = codePointMap.get(0x10FFFF);
        MutableCodePointTrie mutableCodePointTrie = new MutableCodePointTrie(n3, n2);
        CodePointMap.Range range = new CodePointMap.Range();
        int n4 = 0;
        while (codePointMap.getRange(n4, null, range)) {
            int n5 = range.getEnd();
            int n6 = range.getValue();
            if (n6 != n3) {
                if (n4 == n5) {
                    mutableCodePointTrie.set(n4, n6);
                } else {
                    mutableCodePointTrie.setRange(n4, n5, n6);
                }
            }
            n4 = n5 + 1;
        }
        return mutableCodePointTrie;
    }

    private void clear() {
        this.dataNullOffset = -1;
        this.index3NullOffset = -1;
        this.dataLength = 0;
        this.highValue = this.initialValue = this.origInitialValue;
        this.highStart = 0;
        this.index16 = null;
    }

    @Override
    public int get(int n2) {
        if (n2 < 0 || 0x10FFFF < n2) {
            return this.errorValue;
        }
        if (n2 >= this.highStart) {
            return this.highValue;
        }
        int n3 = n2 >> 4;
        if (this.flags[n3] == 0) {
            return this.index[n3];
        }
        return this.data[this.index[n3] + (n2 & 0xF)];
    }

    private static final int maybeFilterValue(int n2, int n3, int n4, CodePointMap.ValueFilter valueFilter) {
        if (n2 == n3) {
            n2 = n4;
        } else if (valueFilter != null) {
            n2 = valueFilter.apply(n2);
        }
        return n2;
    }

    @Override
    public boolean getRange(int n2, CodePointMap.ValueFilter valueFilter, CodePointMap.Range range) {
        if (n2 < 0 || 0x10FFFF < n2) {
            return false;
        }
        if (n2 >= this.highStart) {
            int n3 = this.highValue;
            if (valueFilter != null) {
                n3 = valueFilter.apply(n3);
            }
            range.set(n2, 0x10FFFF, n3);
            return true;
        }
        int n4 = this.initialValue;
        if (valueFilter != null) {
            n4 = valueFilter.apply(n4);
        }
        int n5 = n2;
        int n6 = 0;
        int n7 = 0;
        boolean bl2 = false;
        int n8 = n5 >> 4;
        do {
            int n9;
            if (this.flags[n8] == 0) {
                n9 = this.index[n8];
                if (bl2) {
                    if (n9 != n6) {
                        if (valueFilter == null || MutableCodePointTrie.maybeFilterValue(n9, this.initialValue, n4, valueFilter) != n7) {
                            range.set(n2, n5 - 1, n7);
                            return true;
                        }
                        n6 = n9;
                    }
                } else {
                    n6 = n9;
                    n7 = MutableCodePointTrie.maybeFilterValue(n9, this.initialValue, n4, valueFilter);
                    bl2 = true;
                }
                n5 = n5 + 16 & 0xFFFFFFF0;
            } else {
                n9 = this.index[n8] + (n5 & 0xF);
                int n10 = this.data[n9];
                if (bl2) {
                    if (n10 != n6) {
                        if (valueFilter == null || MutableCodePointTrie.maybeFilterValue(n10, this.initialValue, n4, valueFilter) != n7) {
                            range.set(n2, n5 - 1, n7);
                            return true;
                        }
                        n6 = n10;
                    }
                } else {
                    n6 = n10;
                    n7 = MutableCodePointTrie.maybeFilterValue(n10, this.initialValue, n4, valueFilter);
                    bl2 = true;
                }
                while ((++n5 & 0xF) != 0) {
                    if ((n10 = this.data[++n9]) == n6) continue;
                    if (valueFilter == null || MutableCodePointTrie.maybeFilterValue(n10, this.initialValue, n4, valueFilter) != n7) {
                        range.set(n2, n5 - 1, n7);
                        return true;
                    }
                    n6 = n10;
                }
            }
            ++n8;
        } while (n5 < this.highStart);
        assert (bl2);
        if (MutableCodePointTrie.maybeFilterValue(this.highValue, this.initialValue, n4, valueFilter) != n7) {
            range.set(n2, n5 - 1, n7);
        } else {
            range.set(n2, 0x10FFFF, n7);
        }
        return true;
    }

    private void writeBlock(int n2, int n3) {
        int n4 = n2 + 16;
        Arrays.fill(this.data, n2, n4, n3);
    }

    public void set(int n2, int n3) {
        if (n2 < 0 || 0x10FFFF < n2) {
            throw new IllegalArgumentException("invalid code point");
        }
        this.ensureHighStart(n2);
        int n4 = this.getDataBlock(n2 >> 4);
        this.data[n4 + (n2 & 0xF)] = n3;
    }

    private void fillBlock(int n2, int n3, int n4, int n5) {
        Arrays.fill(this.data, n2 + n3, n2 + n4, n5);
    }

    public void setRange(int n2, int n3, int n4) {
        int n5;
        int n6;
        if (n2 < 0 || 0x10FFFF < n2 || n3 < 0 || 0x10FFFF < n3 || n2 > n3) {
            throw new IllegalArgumentException("invalid code point range");
        }
        this.ensureHighStart(n3);
        int n7 = n3 + 1;
        if ((n2 & 0xF) != 0) {
            n6 = this.getDataBlock(n2 >> 4);
            n5 = n2 + 15 & 0xFFFFFFF0;
            if (n5 <= n7) {
                this.fillBlock(n6, n2 & 0xF, 16, n4);
                n2 = n5;
            } else {
                this.fillBlock(n6, n2 & 0xF, n7 & 0xF, n4);
                return;
            }
        }
        n6 = n7 & 0xF;
        n7 &= 0xFFFFFFF0;
        while (n2 < n7) {
            n5 = n2 >> 4;
            if (this.flags[n5] == 0) {
                this.index[n5] = n4;
            } else {
                this.fillBlock(this.index[n5], 0, 16, n4);
            }
            n2 += 16;
        }
        if (n6 > 0) {
            n5 = this.getDataBlock(n2 >> 4);
            this.fillBlock(n5, 0, n6, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodePointTrie buildImmutable(CodePointTrie.Type type, CodePointTrie.ValueWidth valueWidth) {
        if (type == null || valueWidth == null) {
            throw new IllegalArgumentException("The type and valueWidth must be specified.");
        }
        try {
            CodePointTrie codePointTrie = this.build(type, valueWidth);
            return codePointTrie;
        }
        finally {
            this.clear();
        }
    }

    private void ensureHighStart(int n2) {
        if (n2 >= this.highStart) {
            n2 = n2 + 512 & 0xFFFFFE00;
            int n3 = this.highStart >> 4;
            int n4 = n2 >> 4;
            if (n4 > this.index.length) {
                int[] nArray = new int[69632];
                for (int i2 = 0; i2 < n3; ++i2) {
                    nArray[i2] = this.index[i2];
                }
                this.index = nArray;
            }
            do {
                this.flags[n3] = 0;
                this.index[n3] = this.initialValue;
            } while (++n3 < n4);
            this.highStart = n2;
        }
    }

    private int allocDataBlock(int n2) {
        int n3 = this.dataLength;
        int n4 = n3 + n2;
        if (n4 > this.data.length) {
            int n5;
            if (this.data.length < 131072) {
                n5 = 131072;
            } else if (this.data.length < 0x110000) {
                n5 = 0x110000;
            } else {
                throw new AssertionError();
            }
            int[] nArray = new int[n5];
            for (int i2 = 0; i2 < this.dataLength; ++i2) {
                nArray[i2] = this.data[i2];
            }
            this.data = nArray;
        }
        this.dataLength = n4;
        return n3;
    }

    private int getDataBlock(int n2) {
        if (this.flags[n2] == 1) {
            return this.index[n2];
        }
        if (n2 < 4096) {
            int n3 = this.allocDataBlock(64);
            int n4 = n2 & 0xFFFFFFFC;
            int n5 = n4 + 4;
            do {
                assert (this.flags[n4] == 0);
                this.writeBlock(n3, this.index[n4]);
                this.flags[n4] = 1;
                this.index[n4++] = n3;
                n3 += 16;
            } while (n4 < n5);
            return this.index[n2];
        }
        int n6 = this.allocDataBlock(16);
        if (n6 < 0) {
            return n6;
        }
        this.writeBlock(n6, this.index[n2]);
        this.flags[n2] = 1;
        this.index[n2] = n6;
        return n6;
    }

    private void maskValues(int n2) {
        int n3;
        this.initialValue &= n2;
        this.errorValue &= n2;
        this.highValue &= n2;
        int n4 = this.highStart >> 4;
        for (n3 = 0; n3 < n4; ++n3) {
            if (this.flags[n3] != 0) continue;
            int n5 = n3;
            this.index[n5] = this.index[n5] & n2;
        }
        n3 = 0;
        while (n3 < this.dataLength) {
            int n6 = n3++;
            this.data[n6] = this.data[n6] & n2;
        }
    }

    private static boolean equalBlocks(int[] nArray, int n2, int[] nArray2, int n3, int n4) {
        while (n4 > 0 && nArray[n2] == nArray2[n3]) {
            ++n2;
            ++n3;
            --n4;
        }
        return n4 == 0;
    }

    private static boolean equalBlocks(char[] cArray, int n2, int[] nArray, int n3, int n4) {
        while (n4 > 0 && cArray[n2] == nArray[n3]) {
            ++n2;
            ++n3;
            --n4;
        }
        return n4 == 0;
    }

    private static boolean equalBlocks(char[] cArray, int n2, char[] cArray2, int n3, int n4) {
        while (n4 > 0 && cArray[n2] == cArray2[n3]) {
            ++n2;
            ++n3;
            --n4;
        }
        return n4 == 0;
    }

    private static boolean allValuesSameAs(int[] nArray, int n2, int n3, int n4) {
        int n5 = n2 + n3;
        while (n2 < n5 && nArray[n2] == n4) {
            ++n2;
        }
        return n2 == n5;
    }

    private static int findSameBlock(char[] cArray, int n2, int n3, char[] cArray2, int n4, int n5) {
        n3 -= n5;
        while (n2 <= n3) {
            if (MutableCodePointTrie.equalBlocks(cArray, n2, cArray2, n4, n5)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private static int findAllSameBlock(int[] nArray, int n2, int n3, int n4, int n5) {
        n3 -= n5;
        block0: for (int i2 = n2; i2 <= n3; ++i2) {
            if (nArray[i2] != n4) continue;
            int n6 = 1;
            while (n6 != n5) {
                if (nArray[i2 + n6] != n4) {
                    i2 += n6;
                    continue block0;
                }
                ++n6;
            }
            return i2;
        }
        return -1;
    }

    private static int getOverlap(int[] nArray, int n2, int[] nArray2, int n3, int n4) {
        int n5;
        assert (n5 <= n2);
        for (n5 = n4 - 1; n5 > 0 && !MutableCodePointTrie.equalBlocks(nArray, n2 - n5, nArray2, n3, n5); --n5) {
        }
        return n5;
    }

    private static int getOverlap(char[] cArray, int n2, int[] nArray, int n3, int n4) {
        int n5;
        assert (n5 <= n2);
        for (n5 = n4 - 1; n5 > 0 && !MutableCodePointTrie.equalBlocks(cArray, n2 - n5, nArray, n3, n5); --n5) {
        }
        return n5;
    }

    private static int getOverlap(char[] cArray, int n2, char[] cArray2, int n3, int n4) {
        int n5;
        assert (n5 <= n2);
        for (n5 = n4 - 1; n5 > 0 && !MutableCodePointTrie.equalBlocks(cArray, n2 - n5, cArray2, n3, n5); --n5) {
        }
        return n5;
    }

    private static int getAllSameOverlap(int[] nArray, int n2, int n3, int n4) {
        int n5;
        int n6 = n2 - (n4 - 1);
        for (n5 = n2; n6 < n5 && nArray[n5 - 1] == n3; --n5) {
        }
        return n2 - n5;
    }

    private static boolean isStartOfSomeFastBlock(int n2, int[] nArray, int n3) {
        for (int i2 = 0; i2 < n3; i2 += 4) {
            if (nArray[i2] != n2) continue;
            return true;
        }
        return false;
    }

    private int findHighStart() {
        int n2 = this.highStart >> 4;
        while (n2 > 0) {
            boolean bl2;
            if (this.flags[--n2] == 0) {
                bl2 = this.index[n2] == this.highValue;
            } else {
                int n3 = this.index[n2];
                int n4 = 0;
                while (true) {
                    if (n4 == 16) {
                        bl2 = true;
                        break;
                    }
                    if (this.data[n3 + n4] != this.highValue) {
                        bl2 = false;
                        break;
                    }
                    ++n4;
                }
            }
            if (bl2) continue;
            return n2 + 1 << 4;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private int compactWholeDataBlocks(int var1_1, AllSameBlocks var2_2) {
        var3_3 = 128;
        var3_3 += 16;
        var3_3 += 4;
        var4_4 = this.highStart >> 4;
        var5_5 = 64;
        var6_6 = 4;
        for (var7_7 = 0; var7_7 < var4_4; var7_7 += var6_6) {
            if (var7_7 == var1_1) {
                var5_5 = 16;
                var6_6 = 1;
            }
            var8_8 = this.index[var7_7];
            if (this.flags[var7_7] != 1) ** GOTO lbl20
            var9_9 = var8_8;
            if (MutableCodePointTrie.allValuesSameAs(this.data, var9_9 + 1, var5_5 - 1, var8_8 = this.data[var9_9])) {
                this.flags[var7_7] = 0;
                this.index[var7_7] = var8_8;
            } else {
                var3_3 += var5_5;
                continue;
lbl20:
                // 1 sources

                if (!MutableCodePointTrie.$assertionsDisabled && this.flags[var7_7] != 0) {
                    throw new AssertionError();
                }
                if (var6_6 > 1) {
                    var9_9 = 1;
                    var10_10 = var7_7 + var6_6;
                    for (var11_11 = var7_7 + 1; var11_11 < var10_10; ++var11_11) {
                        if (!MutableCodePointTrie.$assertionsDisabled && this.flags[var11_11] != 0) {
                            throw new AssertionError();
                        }
                        if (this.index[var11_11] == var8_8) continue;
                        var9_9 = 0;
                        break;
                    }
                    if (var9_9 == 0) {
                        if (this.getDataBlock(var7_7) < 0) {
                            return -1;
                        }
                        var3_3 += var5_5;
                        continue;
                    }
                }
            }
            if ((var9_9 = var2_2.findOrAdd(var7_7, var6_6, var8_8)) == -2) {
                var10_10 = 4;
                var11_11 = 0;
                while (true) {
                    if (var11_11 == var7_7) {
                        var2_2.add(var7_7, var6_6, var8_8);
                        break;
                    }
                    if (var11_11 == var1_1) {
                        var10_10 = 1;
                    }
                    if (this.flags[var11_11] == 0 && this.index[var11_11] == var8_8) {
                        var2_2.add(var11_11, var10_10 + var6_6, var8_8);
                        var9_9 = var11_11;
                        break;
                    }
                    var11_11 += var10_10;
                }
            }
            if (var9_9 >= 0) {
                this.flags[var7_7] = 2;
                this.index[var7_7] = var9_9;
                continue;
            }
            var3_3 += var5_5;
        }
        return var3_3;
    }

    private int compactData(int n2, int[] nArray, int n3, MixedBlocks mixedBlocks) {
        int n4 = 0;
        int n5 = 0;
        while (n4 < 128) {
            this.index[n5] = n4;
            n4 += 64;
            n5 += 4;
        }
        n5 = 64;
        mixedBlocks.init(nArray.length, n5);
        mixedBlocks.extend(nArray, 0, 0, n4);
        int n6 = this.highStart >> 4;
        int n7 = 4;
        int n8 = 0;
        for (int i2 = 8; i2 < n6; i2 += n7) {
            int n9;
            int n10;
            int n11;
            if (i2 == n2) {
                n5 = 16;
                n7 = 1;
                n8 = n4;
                mixedBlocks.init(nArray.length, n5);
                mixedBlocks.extend(nArray, 0, 0, n4);
            }
            if (this.flags[i2] == 0) {
                n11 = this.index[i2];
                n10 = mixedBlocks.findAllSameBlock(nArray, n11);
                while (n10 >= 0 && i2 == n3 && i2 >= n2 && n10 < n8 && MutableCodePointTrie.isStartOfSomeFastBlock(n10, this.index, n2)) {
                    n10 = MutableCodePointTrie.findAllSameBlock(nArray, n10 + 1, n4, n11, n5);
                }
                if (n10 >= 0) {
                    this.index[i2] = n10;
                    continue;
                }
                this.index[i2] = n4 - n10;
                n9 = n4;
                for (n10 = MutableCodePointTrie.getAllSameOverlap(nArray, n4, n11, n5); n10 < n5; ++n10) {
                    nArray[n4++] = n11;
                }
                mixedBlocks.extend(nArray, 0, n9, n4);
                continue;
            }
            if (this.flags[i2] == 1) {
                n11 = this.index[i2];
                n10 = mixedBlocks.findBlock(nArray, this.data, n11);
                if (n10 >= 0) {
                    this.index[i2] = n10;
                    continue;
                }
                n10 = MutableCodePointTrie.getOverlap(nArray, n4, this.data, n11, n5);
                this.index[i2] = n4 - n10;
                n9 = n4;
                while (n10 < n5) {
                    nArray[n4++] = this.data[n11 + n10++];
                }
                mixedBlocks.extend(nArray, 0, n9, n4);
                continue;
            }
            n11 = this.index[i2];
            this.index[i2] = this.index[n11];
        }
        return n4;
    }

    private int compactIndex(int n2, MixedBlocks mixedBlocks) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15 = n2 >> 2;
        if (this.highStart >> 6 <= n15) {
            this.index3NullOffset = Short.MAX_VALUE;
            return n15;
        }
        char[] cArray = new char[n15];
        int n16 = -1;
        int n17 = 0;
        int n18 = 0;
        while (n17 < n2) {
            n14 = this.index[n17];
            cArray[n18] = (char)n14;
            if (n14 == this.dataNullOffset) {
                if (n16 < 0) {
                    n16 = n18;
                } else if (this.index3NullOffset < 0 && n18 - n16 + 1 == 32) {
                    this.index3NullOffset = n16;
                }
            } else {
                n16 = -1;
            }
            n13 = n17 + 4;
            while (++n17 < n13) {
                this.index[n17] = n14 += 16;
            }
            ++n18;
        }
        mixedBlocks.init(n15, 32);
        mixedBlocks.extend(cArray, 0, 0, n15);
        n17 = 0;
        n16 = this.index3NullOffset;
        n18 = 0;
        n14 = n2 < 4096 ? 0 : 4096;
        n13 = this.highStart >> 4;
        int n19 = n14;
        while (n19 < n13) {
            n12 = n19;
            n11 = n19 + 32;
            int n20 = 0;
            boolean bl2 = true;
            do {
                n10 = this.index[n12];
                n20 |= n10;
                if (n10 == this.dataNullOffset) continue;
                bl2 = false;
            } while (++n12 < n11);
            if (bl2) {
                this.flags[n19] = 0;
                if (n16 < 0) {
                    if (n20 <= 65535) {
                        n17 += 32;
                    } else {
                        n17 += 36;
                        n18 = 1;
                    }
                    n16 = 0;
                }
            } else if (n20 <= 65535) {
                n10 = mixedBlocks.findBlock(cArray, this.index, n19);
                if (n10 >= 0) {
                    this.flags[n19] = 1;
                    this.index[n19] = n10;
                } else {
                    this.flags[n19] = 2;
                    n17 += 32;
                }
            } else {
                this.flags[n19] = 3;
                n17 += 36;
                n18 = 1;
            }
            n19 = n12;
        }
        n19 = n13 - n14 >> 5;
        n12 = n19 + 31 >> 5;
        n11 = n15 + n12 + n17 + n19 + 1;
        this.index16 = Arrays.copyOf(cArray, n11);
        mixedBlocks.init(n11, 32);
        MixedBlocks mixedBlocks2 = null;
        if (n18 != 0) {
            mixedBlocks2 = new MixedBlocks();
            mixedBlocks2.init(n11, 36);
        }
        char[] cArray2 = new char[n19];
        n10 = 0;
        n16 = this.index3NullOffset;
        int n21 = n9 = n15 + n12;
        for (n8 = n14; n8 < n13; n8 += 32) {
            n7 = this.flags[n8];
            if (n7 == 0 && n16 < 0) {
                n7 = this.dataNullOffset <= 65535 ? 2 : 3;
                n16 = 0;
            }
            if (n7 == 0) {
                n6 = this.index3NullOffset;
            } else if (n7 == 1) {
                n6 = this.index[n8];
            } else if (n7 == 2) {
                n5 = mixedBlocks.findBlock(this.index16, this.index, n8);
                if (n5 >= 0) {
                    n6 = n5;
                } else {
                    n5 = n21 == n9 ? 0 : MutableCodePointTrie.getOverlap(this.index16, n21, this.index, n8, 32);
                    n6 = n21 - n5;
                    n4 = n21;
                    while (n5 < 32) {
                        this.index16[n21++] = (char)this.index[n8 + n5++];
                    }
                    mixedBlocks.extend(this.index16, n9, n4, n21);
                    if (n18 != 0) {
                        mixedBlocks2.extend(this.index16, n9, n4, n21);
                    }
                }
            } else {
                int n22;
                int n23;
                assert (n7 == 3);
                assert (n18 != 0);
                n5 = n8;
                n4 = n8 + 32;
                n3 = n21;
                do {
                    n23 = this.index[n5++];
                    n22 = (n23 & 0x30000) >> 2;
                    int n24 = ++n3;
                    this.index16[n24] = (char)n23;
                    n23 = this.index[n5++];
                    n22 |= (n23 & 0x30000) >> 4;
                    int n25 = ++n3;
                    this.index16[n25] = (char)n23;
                    n23 = this.index[n5++];
                    n22 |= (n23 & 0x30000) >> 6;
                    int n26 = ++n3;
                    this.index16[n26] = (char)n23;
                    n23 = this.index[n5++];
                    n22 |= (n23 & 0x30000) >> 8;
                    int n27 = ++n3;
                    this.index16[n27] = (char)n23;
                    n23 = this.index[n5++];
                    n22 |= (n23 & 0x30000) >> 10;
                    int n28 = ++n3;
                    this.index16[n28] = (char)n23;
                    n23 = this.index[n5++];
                    n22 |= (n23 & 0x30000) >> 12;
                    int n29 = ++n3;
                    this.index16[n29] = (char)n23;
                    n23 = this.index[n5++];
                    n22 |= (n23 & 0x30000) >> 14;
                    int n30 = ++n3;
                    this.index16[n30] = (char)n23;
                    n23 = this.index[n5++];
                    int n31 = ++n3;
                    this.index16[n31] = (char)n23;
                    this.index16[++n3 - 9] = (char)(n22 |= (n23 & 0x30000) >> 16);
                } while (n5 < n4);
                n23 = mixedBlocks2.findBlock(this.index16, this.index16, n21);
                if (n23 >= 0) {
                    n6 = n23 | 0x8000;
                } else {
                    n23 = n21 == n9 ? 0 : MutableCodePointTrie.getOverlap(this.index16, n21, this.index16, n21, 36);
                    n6 = n21 - n23 | 0x8000;
                    n22 = n21;
                    if (n23 > 0) {
                        int n32 = n21;
                        while (n23 < 36) {
                            this.index16[n21++] = this.index16[n32 + n23++];
                        }
                    } else {
                        n21 += 36;
                    }
                    mixedBlocks.extend(this.index16, n9, n22, n21);
                    if (n18 != 0) {
                        mixedBlocks2.extend(this.index16, n9, n22, n21);
                    }
                }
            }
            if (this.index3NullOffset < 0 && n16 >= 0) {
                this.index3NullOffset = n6;
            }
            cArray2[n10++] = (char)n6;
        }
        assert (n10 == n19);
        assert (n21 <= n9 + n17);
        if (this.index3NullOffset < 0) {
            this.index3NullOffset = Short.MAX_VALUE;
        }
        if (n21 >= 32799) {
            throw new IndexOutOfBoundsException("The trie data exceeds limitations of the data structure.");
        }
        n8 = 32;
        n6 = n15;
        for (n7 = 0; n7 < n10; n7 += n8) {
            if (n10 - n7 >= n8) {
                assert (n8 == 32);
                n5 = mixedBlocks.findBlock(this.index16, cArray2, n7);
            } else {
                n8 = n10 - n7;
                n5 = MutableCodePointTrie.findSameBlock(this.index16, n9, n21, cArray2, n7, n8);
            }
            if (n5 >= 0) {
                n4 = n5;
            } else {
                n5 = n21 == n9 ? 0 : MutableCodePointTrie.getOverlap(this.index16, n21, cArray2, n7, n8);
                n4 = n21 - n5;
                n3 = n21;
                while (n5 < n8) {
                    this.index16[n21++] = cArray2[n7 + n5++];
                }
                mixedBlocks.extend(this.index16, n9, n3, n21);
            }
            this.index16[n6++] = (char)n4;
        }
        assert (n6 == n9);
        assert (n21 <= n11);
        return n21;
    }

    private int compactTrie(int n2) {
        int n3;
        assert ((this.highStart & 0x1FF) == 0);
        this.highValue = this.get(0x10FFFF);
        int n4 = this.findHighStart();
        if ((n4 = n4 + 511 & 0xFFFFFE00) == 0x110000) {
            this.highValue = this.initialValue;
        }
        if (n4 < (n3 = n2 << 4)) {
            for (int i2 = n4 >> 4; i2 < n2; ++i2) {
                this.flags[i2] = 0;
                this.index[i2] = this.highValue;
            }
            this.highStart = n3;
        } else {
            this.highStart = n4;
        }
        int[] nArray = new int[128];
        for (int i3 = 0; i3 < 128; ++i3) {
            nArray[i3] = this.get(i3);
        }
        AllSameBlocks allSameBlocks = new AllSameBlocks();
        int n5 = this.compactWholeDataBlocks(n2, allSameBlocks);
        int[] nArray2 = Arrays.copyOf(nArray, n5);
        int n6 = allSameBlocks.findMostUsed();
        MixedBlocks mixedBlocks = new MixedBlocks();
        int n7 = this.compactData(n2, nArray2, n6, mixedBlocks);
        assert (n7 <= n5);
        this.data = nArray2;
        this.dataLength = n7;
        if (this.dataLength > 262159) {
            throw new IndexOutOfBoundsException("The trie data exceeds limitations of the data structure.");
        }
        if (n6 >= 0) {
            this.dataNullOffset = this.index[n6];
            this.initialValue = this.data[this.dataNullOffset];
        } else {
            this.dataNullOffset = 1048575;
        }
        int n8 = this.compactIndex(n2, mixedBlocks);
        this.highStart = n4;
        return n8;
    }

    private CodePointTrie build(CodePointTrie.Type type, CodePointTrie.ValueWidth valueWidth) {
        int n2;
        char[] cArray;
        switch (valueWidth) {
            case BITS_32: {
                break;
            }
            case BITS_16: {
                this.maskValues(65535);
                break;
            }
            case BITS_8: {
                this.maskValues(255);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int n3 = type == CodePointTrie.Type.FAST ? 65536 : 4096;
        int n4 = this.compactTrie(n3 >> 4);
        if (valueWidth == CodePointTrie.ValueWidth.BITS_32 && (n4 & 1) != 0) {
            this.index16[n4++] = 65518;
        }
        int n5 = n4 * 2;
        if (valueWidth == CodePointTrie.ValueWidth.BITS_16) {
            if (((n4 ^ this.dataLength) & 1) != 0) {
                this.data[this.dataLength++] = this.errorValue;
            }
            if (this.data[this.dataLength - 1] != this.errorValue || this.data[this.dataLength - 2] != this.highValue) {
                this.data[this.dataLength++] = this.highValue;
                this.data[this.dataLength++] = this.errorValue;
            }
            n5 += this.dataLength * 2;
        } else if (valueWidth == CodePointTrie.ValueWidth.BITS_32) {
            if (this.data[this.dataLength - 1] != this.errorValue || this.data[this.dataLength - 2] != this.highValue) {
                if (this.data[this.dataLength - 1] != this.highValue) {
                    this.data[this.dataLength++] = this.highValue;
                }
                this.data[this.dataLength++] = this.errorValue;
            }
            n5 += this.dataLength * 4;
        } else {
            int n6 = n5 + this.dataLength & 3;
            if (n6 != 0 || this.data[this.dataLength - 1] != this.errorValue || this.data[this.dataLength - 2] != this.highValue) {
                if (n6 == 3 && this.data[this.dataLength - 1] == this.highValue) {
                    this.data[this.dataLength++] = this.errorValue;
                } else {
                    while (n6 != 2) {
                        this.data[this.dataLength++] = this.highValue;
                        n6 = n6 + 1 & 3;
                    }
                    this.data[this.dataLength++] = this.highValue;
                    this.data[this.dataLength++] = this.errorValue;
                }
            }
            n5 += this.dataLength;
        }
        assert ((n5 & 3) == 0);
        if (this.highStart <= n3) {
            cArray = new char[n4];
            int n7 = 0;
            for (n2 = 0; n2 < n4; ++n2) {
                cArray[n2] = (char)this.index[n7];
                n7 += 4;
            }
        } else if (n4 == this.index16.length) {
            cArray = this.index16;
            this.index16 = null;
        } else {
            cArray = Arrays.copyOf(this.index16, n4);
        }
        switch (valueWidth) {
            case BITS_16: {
                char[] cArray2 = new char[this.dataLength];
                for (n2 = 0; n2 < this.dataLength; ++n2) {
                    cArray2[n2] = (char)this.data[n2];
                }
                return type == CodePointTrie.Type.FAST ? new CodePointTrie.Fast16(cArray, cArray2, this.highStart, this.index3NullOffset, this.dataNullOffset) : new CodePointTrie.Small16(cArray, cArray2, this.highStart, this.index3NullOffset, this.dataNullOffset);
            }
            case BITS_32: {
                int[] nArray = Arrays.copyOf(this.data, this.dataLength);
                return type == CodePointTrie.Type.FAST ? new CodePointTrie.Fast32(cArray, nArray, this.highStart, this.index3NullOffset, this.dataNullOffset) : new CodePointTrie.Small32(cArray, nArray, this.highStart, this.index3NullOffset, this.dataNullOffset);
            }
            case BITS_8: {
                byte[] byArray = new byte[this.dataLength];
                for (n2 = 0; n2 < this.dataLength; ++n2) {
                    byArray[n2] = (byte)this.data[n2];
                }
                return type == CodePointTrie.Type.FAST ? new CodePointTrie.Fast8(cArray, byArray, this.highStart, this.index3NullOffset, this.dataNullOffset) : new CodePointTrie.Small8(cArray, byArray, this.highStart, this.index3NullOffset, this.dataNullOffset);
            }
        }
        throw new IllegalArgumentException();
    }

    private static final class MixedBlocks {
        private int[] table;
        private int length;
        private int shift;
        private int mask;
        private int blockLength;

        private MixedBlocks() {
        }

        void init(int n2, int n3) {
            int n4;
            int n5 = n2 - n3 + 1;
            if (n5 <= 4095) {
                n4 = 6007;
                this.shift = 12;
                this.mask = 4095;
            } else if (n5 <= Short.MAX_VALUE) {
                n4 = 50021;
                this.shift = 15;
                this.mask = Short.MAX_VALUE;
            } else if (n5 <= 131071) {
                n4 = 200003;
                this.shift = 17;
                this.mask = 131071;
            } else {
                n4 = 1500007;
                this.shift = 21;
                this.mask = 0x1FFFFF;
            }
            if (this.table == null || n4 > this.table.length) {
                this.table = new int[n4];
            } else {
                Arrays.fill(this.table, 0, n4, 0);
            }
            this.length = n4;
            this.blockLength = n3;
        }

        void extend(int[] nArray, int n2, int n3, int n4) {
            int n5 = n3 - this.blockLength;
            n5 = n5 >= n2 ? ++n5 : n2;
            int n6 = n4 - this.blockLength;
            while (n5 <= n6) {
                int n7 = this.makeHashCode(nArray, n5);
                this.addEntry(nArray, null, n5, n7, n5);
                ++n5;
            }
        }

        void extend(char[] cArray, int n2, int n3, int n4) {
            int n5 = n3 - this.blockLength;
            n5 = n5 >= n2 ? ++n5 : n2;
            int n6 = n4 - this.blockLength;
            while (n5 <= n6) {
                int n7 = this.makeHashCode(cArray, n5);
                this.addEntry(null, cArray, n5, n7, n5);
                ++n5;
            }
        }

        int findBlock(int[] nArray, int[] nArray2, int n2) {
            int n3 = this.makeHashCode(nArray2, n2);
            int n4 = this.findEntry(nArray, null, nArray2, null, n2, n3);
            if (n4 >= 0) {
                return (this.table[n4] & this.mask) - 1;
            }
            return -1;
        }

        int findBlock(char[] cArray, int[] nArray, int n2) {
            int n3 = this.makeHashCode(nArray, n2);
            int n4 = this.findEntry(null, cArray, nArray, null, n2, n3);
            if (n4 >= 0) {
                return (this.table[n4] & this.mask) - 1;
            }
            return -1;
        }

        int findBlock(char[] cArray, char[] cArray2, int n2) {
            int n3 = this.makeHashCode(cArray2, n2);
            int n4 = this.findEntry(null, cArray, null, cArray2, n2, n3);
            if (n4 >= 0) {
                return (this.table[n4] & this.mask) - 1;
            }
            return -1;
        }

        int findAllSameBlock(int[] nArray, int n2) {
            int n3 = this.makeHashCode(n2);
            int n4 = this.findEntry(nArray, n2, n3);
            if (n4 >= 0) {
                return (this.table[n4] & this.mask) - 1;
            }
            return -1;
        }

        private int makeHashCode(int[] nArray, int n2) {
            int n3 = n2 + this.blockLength;
            int n4 = nArray[n2++];
            do {
                n4 = 37 * n4 + nArray[n2++];
            } while (n2 < n3);
            return n4;
        }

        private int makeHashCode(char[] cArray, int n2) {
            int n3 = n2 + this.blockLength;
            int n4 = cArray[n2++];
            do {
                n4 = 37 * n4 + cArray[n2++];
            } while (n2 < n3);
            return n4;
        }

        private int makeHashCode(int n2) {
            int n3 = n2;
            for (int i2 = 1; i2 < this.blockLength; ++i2) {
                n3 = 37 * n3 + n2;
            }
            return n3;
        }

        private void addEntry(int[] nArray, char[] cArray, int n2, int n3, int n4) {
            assert (0 <= n4 && n4 < this.mask);
            int n5 = this.findEntry(nArray, cArray, nArray, cArray, n2, n3);
            if (n5 < 0) {
                this.table[n5 ^ 0xFFFFFFFF] = n3 << this.shift | n4 + 1;
            }
        }

        private int findEntry(int[] nArray, char[] cArray, int[] nArray2, char[] cArray2, int n2, int n3) {
            int n4;
            int n5 = n3 << this.shift;
            int n6 = n4 = this.modulo(n3, this.length - 1) + 1;
            int n7;
            while ((n7 = this.table[n6]) != 0) {
                if ((n7 & ~this.mask) == n5) {
                    int n8 = (n7 & this.mask) - 1;
                    if (nArray != null ? MutableCodePointTrie.equalBlocks(nArray, n8, nArray2, n2, this.blockLength) : (nArray2 != null ? MutableCodePointTrie.equalBlocks(cArray, n8, nArray2, n2, this.blockLength) : MutableCodePointTrie.equalBlocks(cArray, n8, cArray2, n2, this.blockLength))) {
                        return n6;
                    }
                }
                n6 = this.nextIndex(n4, n6);
            }
            return ~n6;
        }

        private int findEntry(int[] nArray, int n2, int n3) {
            int n4;
            int n5 = n3 << this.shift;
            int n6 = n4 = this.modulo(n3, this.length - 1) + 1;
            int n7;
            while ((n7 = this.table[n6]) != 0) {
                int n8;
                if ((n7 & ~this.mask) == n5 && MutableCodePointTrie.allValuesSameAs(nArray, n8 = (n7 & this.mask) - 1, this.blockLength, n2)) {
                    return n6;
                }
                n6 = this.nextIndex(n4, n6);
            }
            return ~n6;
        }

        private int nextIndex(int n2, int n3) {
            return (n3 + n2) % this.length;
        }

        private int modulo(int n2, int n3) {
            int n4 = n2 % n3;
            if (n4 < 0) {
                n4 += n3;
            }
            return n4;
        }
    }

    private static final class AllSameBlocks {
        static final int NEW_UNIQUE = -1;
        static final int OVERFLOW = -2;
        private static final int CAPACITY = 32;
        private int length;
        private int mostRecent = -1;
        private int[] indexes = new int[32];
        private int[] values = new int[32];
        private int[] refCounts = new int[32];

        AllSameBlocks() {
        }

        int findOrAdd(int n2, int n3, int n4) {
            if (this.mostRecent >= 0 && this.values[this.mostRecent] == n4) {
                int n5 = this.mostRecent;
                this.refCounts[n5] = this.refCounts[n5] + n3;
                return this.indexes[this.mostRecent];
            }
            for (int i2 = 0; i2 < this.length; ++i2) {
                if (this.values[i2] != n4) continue;
                this.mostRecent = i2;
                int n6 = i2;
                this.refCounts[n6] = this.refCounts[n6] + n3;
                return this.indexes[i2];
            }
            if (this.length == 32) {
                return -2;
            }
            this.mostRecent = this.length;
            this.indexes[this.length] = n2;
            this.values[this.length] = n4;
            this.refCounts[this.length++] = n3;
            return -1;
        }

        void add(int n2, int n3, int n4) {
            assert (this.length == 32);
            int n5 = -1;
            int n6 = 69632;
            for (int i2 = 0; i2 < this.length; ++i2) {
                assert (this.values[i2] != n4);
                if (this.refCounts[i2] >= n6) continue;
                n5 = i2;
                n6 = this.refCounts[i2];
            }
            assert (n5 >= 0);
            this.mostRecent = n5;
            this.indexes[n5] = n2;
            this.values[n5] = n4;
            this.refCounts[n5] = n3;
        }

        int findMostUsed() {
            if (this.length == 0) {
                return -1;
            }
            int n2 = -1;
            int n3 = 0;
            for (int i2 = 0; i2 < this.length; ++i2) {
                if (this.refCounts[i2] <= n3) continue;
                n2 = i2;
                n3 = this.refCounts[i2];
            }
            return this.indexes[n2];
        }
    }
}

