/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.locale.LSR;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.locale.LikelySubtags;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.locale.LocaleDistance;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.LocalePriorityList;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public final class LocaleMatcher {
    private static final LSR UND_LSR = new LSR("und", "", "", 7);
    private static final ULocale UND_ULOCALE = new ULocale("und");
    private static final Locale UND_LOCALE = new Locale("und");
    private static final Locale EMPTY_LOCALE = new Locale("");
    private static final boolean TRACE_MATCHER = false;
    private final int thresholdDistance;
    private final int demotionPerDesiredLocale;
    private final FavorSubtag favorSubtag;
    private final Direction direction;
    private final ULocale[] supportedULocales;
    private final Locale[] supportedLocales;
    private final Map<LSR, Integer> supportedLsrToIndex;
    private final LSR[] supportedLSRs;
    private final int[] supportedIndexes;
    private final int supportedLSRsLength;
    private final ULocale defaultULocale;
    private final Locale defaultLocale;

    public static Builder builder() {
        return new Builder();
    }

    public LocaleMatcher(LocalePriorityList localePriorityList) {
        this(LocaleMatcher.builder().setSupportedULocales(localePriorityList.getULocales()));
    }

    public LocaleMatcher(String string) {
        this(LocaleMatcher.builder().setSupportedLocales(string));
    }

    private LocaleMatcher(Builder builder) {
        int n2;
        Object object2;
        ULocale uLocale = builder.defaultLocale;
        Locale locale = null;
        LSR lSR = null;
        if (uLocale != null) {
            locale = uLocale.toLocale();
            lSR = LocaleMatcher.getMaximalLsrOrUnd(uLocale);
        }
        int n3 = builder.supportedLocales != null ? builder.supportedLocales.size() : 0;
        this.supportedULocales = new ULocale[n3];
        this.supportedLocales = new Locale[n3];
        LSR[] lSRArray = new LSR[n3];
        int n4 = 0;
        if (n3 > 0) {
            for (Object object2 : builder.supportedLocales) {
                this.supportedULocales[n4] = object2;
                this.supportedLocales[n4] = ((ULocale)object2).toLocale();
                lSRArray[n4] = LocaleMatcher.getMaximalLsrOrUnd((ULocale)object2);
                ++n4;
            }
        }
        this.supportedLsrToIndex = new HashMap<LSR, Integer>(n3);
        this.supportedLSRs = new LSR[n3];
        this.supportedIndexes = new int[n3];
        int n5 = 0;
        object2 = new byte[n3];
        int n6 = 0;
        n4 = 0;
        for (ULocale uLocale2 : this.supportedULocales) {
            LSR lSR2 = lSRArray[n4];
            if (lSR == null && builder.withDefault) {
                assert (n4 == 0);
                uLocale = uLocale2;
                locale = this.supportedLocales[0];
                lSR = lSR2;
                n5 = this.putIfAbsent(lSR2, 0, n5);
            } else if (lSR != null && lSR2.isEquivalentTo(lSR)) {
                n5 = this.putIfAbsent(lSR2, n4, n5);
            } else if (LocaleDistance.INSTANCE.isParadigmLSR(lSR2)) {
                object2[n4] = 2;
                ++n6;
            } else {
                object2[n4] = 3;
            }
            ++n4;
        }
        int n7 = n5 + n6;
        for (n4 = 0; n4 < n3 && n5 < n7; ++n4) {
            if (object2[n4] != 2) continue;
            n5 = this.putIfAbsent(lSRArray[n4], n4, n5);
        }
        for (n4 = 0; n4 < n3; ++n4) {
            if (object2[n4] != 3) continue;
            n5 = this.putIfAbsent(lSRArray[n4], n4, n5);
        }
        this.supportedLSRsLength = n5;
        this.defaultULocale = uLocale;
        this.defaultLocale = locale;
        this.demotionPerDesiredLocale = builder.demotion == Demotion.NONE ? 0 : LocaleDistance.INSTANCE.getDefaultDemotionPerDesiredLocale();
        this.favorSubtag = builder.favor;
        this.direction = builder.direction;
        if (builder.thresholdDistance >= 0) {
            n2 = builder.thresholdDistance;
        } else if (builder.maxDistanceDesired != null) {
            int n8 = LocaleDistance.INSTANCE.getBestIndexAndDistance(LocaleMatcher.getMaximalLsrOrUnd(builder.maxDistanceDesired), new LSR[]{LocaleMatcher.getMaximalLsrOrUnd(builder.maxDistanceSupported)}, 1, LocaleDistance.shiftDistance(100), this.favorSubtag, this.direction);
            n2 = LocaleDistance.getDistanceFloor(n8) + 1;
        } else {
            n2 = LocaleDistance.INSTANCE.getDefaultScriptDistance();
        }
        this.thresholdDistance = n2;
    }

    private final int putIfAbsent(LSR lSR, int n2, int n3) {
        if (!this.supportedLsrToIndex.containsKey(lSR)) {
            this.supportedLsrToIndex.put(lSR, n2);
            this.supportedLSRs[n3] = lSR;
            this.supportedIndexes[n3++] = n2;
        }
        return n3;
    }

    private static final LSR getMaximalLsrOrUnd(ULocale uLocale) {
        if (uLocale.equals(UND_ULOCALE)) {
            return UND_LSR;
        }
        return LikelySubtags.INSTANCE.makeMaximizedLsrFrom(uLocale, false);
    }

    private static final LSR getMaximalLsrOrUnd(Locale locale) {
        if (locale.equals(UND_LOCALE) || locale.equals(EMPTY_LOCALE)) {
            return UND_LSR;
        }
        return LikelySubtags.INSTANCE.makeMaximizedLsrFrom(locale);
    }

    public ULocale getBestMatch(ULocale uLocale) {
        LSR lSR = LocaleMatcher.getMaximalLsrOrUnd(uLocale);
        int n2 = this.getBestSuppIndex(lSR, null);
        return n2 >= 0 ? this.supportedULocales[n2] : this.defaultULocale;
    }

    public ULocale getBestMatch(Iterable<ULocale> iterable) {
        Iterator<ULocale> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return this.defaultULocale;
        }
        ULocaleLsrIterator uLocaleLsrIterator = new ULocaleLsrIterator(iterator);
        LSR lSR = uLocaleLsrIterator.next();
        int n2 = this.getBestSuppIndex(lSR, uLocaleLsrIterator);
        return n2 >= 0 ? this.supportedULocales[n2] : this.defaultULocale;
    }

    public ULocale getBestMatch(String string) {
        return this.getBestMatch(LocalePriorityList.add(string).build());
    }

    public Locale getBestLocale(Locale locale) {
        LSR lSR = LocaleMatcher.getMaximalLsrOrUnd(locale);
        int n2 = this.getBestSuppIndex(lSR, null);
        return n2 >= 0 ? this.supportedLocales[n2] : this.defaultLocale;
    }

    public Locale getBestLocale(Iterable<Locale> iterable) {
        Iterator<Locale> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return this.defaultLocale;
        }
        LocaleLsrIterator localeLsrIterator = new LocaleLsrIterator(iterator);
        LSR lSR = localeLsrIterator.next();
        int n2 = this.getBestSuppIndex(lSR, localeLsrIterator);
        return n2 >= 0 ? this.supportedLocales[n2] : this.defaultLocale;
    }

    private Result defaultResult() {
        return new Result(null, this.defaultULocale, null, this.defaultLocale, -1, -1);
    }

    private Result makeResult(ULocale uLocale, ULocaleLsrIterator uLocaleLsrIterator, int n2) {
        if (n2 < 0) {
            return this.defaultResult();
        }
        if (uLocale != null) {
            return new Result(uLocale, this.supportedULocales[n2], null, this.supportedLocales[n2], 0, n2);
        }
        return new Result(uLocaleLsrIterator.remembered, this.supportedULocales[n2], null, this.supportedLocales[n2], uLocaleLsrIterator.bestDesiredIndex, n2);
    }

    private Result makeResult(Locale locale, LocaleLsrIterator localeLsrIterator, int n2) {
        if (n2 < 0) {
            return this.defaultResult();
        }
        if (locale != null) {
            return new Result(null, this.supportedULocales[n2], locale, this.supportedLocales[n2], 0, n2);
        }
        return new Result(null, this.supportedULocales[n2], localeLsrIterator.remembered, this.supportedLocales[n2], localeLsrIterator.bestDesiredIndex, n2);
    }

    public Result getBestMatchResult(ULocale uLocale) {
        LSR lSR = LocaleMatcher.getMaximalLsrOrUnd(uLocale);
        int n2 = this.getBestSuppIndex(lSR, null);
        return this.makeResult(uLocale, null, n2);
    }

    public Result getBestMatchResult(Iterable<ULocale> iterable) {
        Iterator<ULocale> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return this.defaultResult();
        }
        ULocaleLsrIterator uLocaleLsrIterator = new ULocaleLsrIterator(iterator);
        LSR lSR = uLocaleLsrIterator.next();
        int n2 = this.getBestSuppIndex(lSR, uLocaleLsrIterator);
        return this.makeResult(null, uLocaleLsrIterator, n2);
    }

    public Result getBestLocaleResult(Locale locale) {
        LSR lSR = LocaleMatcher.getMaximalLsrOrUnd(locale);
        int n2 = this.getBestSuppIndex(lSR, null);
        return this.makeResult(locale, null, n2);
    }

    public Result getBestLocaleResult(Iterable<Locale> iterable) {
        Iterator<Locale> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return this.defaultResult();
        }
        LocaleLsrIterator localeLsrIterator = new LocaleLsrIterator(iterator);
        LSR lSR = localeLsrIterator.next();
        int n2 = this.getBestSuppIndex(lSR, localeLsrIterator);
        return this.makeResult(null, localeLsrIterator, n2);
    }

    private int getBestSuppIndex(LSR lSR, LsrIterator lsrIterator) {
        int n2 = 0;
        int n3 = -1;
        Object var5_5 = null;
        int n4 = LocaleDistance.shiftDistance(this.thresholdDistance);
        while (true) {
            int n5;
            Integer n6;
            if ((n6 = this.supportedLsrToIndex.get(lSR)) != null) {
                n5 = n6;
                if (lsrIterator != null) {
                    lsrIterator.rememberCurrent(n2);
                }
                return n5;
            }
            n5 = LocaleDistance.INSTANCE.getBestIndexAndDistance(lSR, this.supportedLSRs, this.supportedLSRsLength, n4, this.favorSubtag, this.direction);
            if (n5 >= 0) {
                n4 = LocaleDistance.getShiftedDistance(n5);
                if (lsrIterator != null) {
                    lsrIterator.rememberCurrent(n2);
                }
                n3 = LocaleDistance.getIndex(n5);
            }
            if ((n4 -= LocaleDistance.shiftDistance(this.demotionPerDesiredLocale)) <= 0 || lsrIterator == null || !lsrIterator.hasNext()) break;
            lSR = (LSR)lsrIterator.next();
            ++n2;
        }
        if (n3 < 0) {
            return -1;
        }
        n4 = this.supportedIndexes[n3];
        return n4;
    }

    public boolean isMatch(Locale locale, Locale locale2) {
        int n2 = LocaleDistance.INSTANCE.getBestIndexAndDistance(LocaleMatcher.getMaximalLsrOrUnd(locale), new LSR[]{LocaleMatcher.getMaximalLsrOrUnd(locale2)}, 1, LocaleDistance.shiftDistance(this.thresholdDistance), this.favorSubtag, this.direction);
        return n2 >= 0;
    }

    public boolean isMatch(ULocale uLocale, ULocale uLocale2) {
        int n2 = LocaleDistance.INSTANCE.getBestIndexAndDistance(LocaleMatcher.getMaximalLsrOrUnd(uLocale), new LSR[]{LocaleMatcher.getMaximalLsrOrUnd(uLocale2)}, 1, LocaleDistance.shiftDistance(this.thresholdDistance), this.favorSubtag, this.direction);
        return n2 >= 0;
    }

    @Deprecated
    public double match(ULocale uLocale, ULocale uLocale2, ULocale uLocale3, ULocale uLocale4) {
        int n2 = LocaleDistance.INSTANCE.getBestIndexAndDistance(LocaleMatcher.getMaximalLsrOrUnd(uLocale), new LSR[]{LocaleMatcher.getMaximalLsrOrUnd(uLocale3)}, 1, LocaleDistance.shiftDistance(this.thresholdDistance), this.favorSubtag, this.direction);
        double d2 = LocaleDistance.getDistanceDouble(n2);
        return (100.0 - d2) / 100.0;
    }

    public ULocale canonicalize(ULocale uLocale) {
        return LikelySubtags.INSTANCE.canonicalize(uLocale);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("{LocaleMatcher");
        if (this.supportedLSRsLength > 0) {
            stringBuilder.append(" supportedLSRs={").append(this.supportedLSRs[0]);
            for (int i2 = 1; i2 < this.supportedLSRsLength; ++i2) {
                stringBuilder.append(", ").append(this.supportedLSRs[i2]);
            }
            stringBuilder.append('}');
        }
        stringBuilder.append(" default=").append(this.defaultULocale);
        if (this.favorSubtag != null) {
            stringBuilder.append(" favor=").append((Object)this.favorSubtag);
        }
        if (this.direction != null) {
            stringBuilder.append(" direction=").append((Object)this.direction);
        }
        if (this.thresholdDistance >= 0) {
            stringBuilder.append(String.format(" threshold=%d", this.thresholdDistance));
        }
        stringBuilder.append(String.format(" demotion=%d", this.demotionPerDesiredLocale));
        return stringBuilder.append('}').toString();
    }

    private static final class LocaleLsrIterator
    extends LsrIterator {
        private Iterator<Locale> locales;
        private Locale current;
        private Locale remembered;

        LocaleLsrIterator(Iterator<Locale> iterator) {
            this.locales = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.locales.hasNext();
        }

        @Override
        public LSR next() {
            this.current = this.locales.next();
            return LocaleMatcher.getMaximalLsrOrUnd(this.current);
        }

        @Override
        public void rememberCurrent(int n2) {
            this.bestDesiredIndex = n2;
            this.remembered = this.current;
        }
    }

    private static final class ULocaleLsrIterator
    extends LsrIterator {
        private Iterator<ULocale> locales;
        private ULocale current;
        private ULocale remembered;

        ULocaleLsrIterator(Iterator<ULocale> iterator) {
            this.locales = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.locales.hasNext();
        }

        @Override
        public LSR next() {
            this.current = this.locales.next();
            return LocaleMatcher.getMaximalLsrOrUnd(this.current);
        }

        @Override
        public void rememberCurrent(int n2) {
            this.bestDesiredIndex = n2;
            this.remembered = this.current;
        }
    }

    public static final class Builder {
        private List<ULocale> supportedLocales;
        private int thresholdDistance = -1;
        private Demotion demotion;
        private ULocale defaultLocale;
        private boolean withDefault = true;
        private FavorSubtag favor;
        private Direction direction;
        private ULocale maxDistanceDesired;
        private ULocale maxDistanceSupported;

        private Builder() {
        }

        public Builder setSupportedLocales(String string) {
            return this.setSupportedULocales(LocalePriorityList.add(string).build().getULocales());
        }

        public Builder setSupportedULocales(Collection<ULocale> collection) {
            this.supportedLocales = new ArrayList<ULocale>(collection);
            return this;
        }

        public Builder setSupportedLocales(Collection<Locale> collection) {
            this.supportedLocales = new ArrayList<ULocale>(collection.size());
            for (Locale locale : collection) {
                this.supportedLocales.add(ULocale.forLocale(locale));
            }
            return this;
        }

        public Builder addSupportedULocale(ULocale uLocale) {
            if (this.supportedLocales == null) {
                this.supportedLocales = new ArrayList<ULocale>();
            }
            this.supportedLocales.add(uLocale);
            return this;
        }

        public Builder addSupportedLocale(Locale locale) {
            return this.addSupportedULocale(ULocale.forLocale(locale));
        }

        public Builder setNoDefaultLocale() {
            this.defaultLocale = null;
            this.withDefault = false;
            return this;
        }

        public Builder setDefaultULocale(ULocale uLocale) {
            this.defaultLocale = uLocale;
            this.withDefault = true;
            return this;
        }

        public Builder setDefaultLocale(Locale locale) {
            this.defaultLocale = ULocale.forLocale(locale);
            this.withDefault = true;
            return this;
        }

        public Builder setFavorSubtag(FavorSubtag favorSubtag) {
            this.favor = favorSubtag;
            return this;
        }

        public Builder setDemotionPerDesiredLocale(Demotion demotion) {
            this.demotion = demotion;
            return this;
        }

        public Builder setDirection(Direction direction) {
            this.direction = direction;
            return this;
        }

        public Builder setMaxDistance(Locale locale, Locale locale2) {
            if (locale == null || locale2 == null) {
                throw new IllegalArgumentException("desired/supported locales must not be null");
            }
            return this.setMaxDistance(ULocale.forLocale(locale), ULocale.forLocale(locale2));
        }

        public Builder setMaxDistance(ULocale uLocale, ULocale uLocale2) {
            if (uLocale == null || uLocale2 == null) {
                throw new IllegalArgumentException("desired/supported locales must not be null");
            }
            this.maxDistanceDesired = uLocale;
            this.maxDistanceSupported = uLocale2;
            return this;
        }

        @Deprecated
        public Builder internalSetThresholdDistance(int n2) {
            if (n2 > 100) {
                n2 = 100;
            }
            this.thresholdDistance = n2;
            return this;
        }

        public LocaleMatcher build() {
            return new LocaleMatcher(this);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("{LocaleMatcher.Builder");
            if (this.supportedLocales != null && !this.supportedLocales.isEmpty()) {
                stringBuilder.append(" supported={").append(this.supportedLocales).append('}');
            }
            if (this.defaultLocale != null) {
                stringBuilder.append(" default=").append(this.defaultLocale);
            }
            if (this.favor != null) {
                stringBuilder.append(" distance=").append((Object)this.favor);
            }
            if (this.thresholdDistance >= 0) {
                stringBuilder.append(String.format(" threshold=%d", this.thresholdDistance));
            }
            if (this.demotion != null) {
                stringBuilder.append(" demotion=").append((Object)this.demotion);
            }
            return stringBuilder.append('}').toString();
        }
    }

    public static final class Result {
        private final ULocale desiredULocale;
        private final ULocale supportedULocale;
        private final Locale desiredLocale;
        private final Locale supportedLocale;
        private final int desiredIndex;
        private final int supportedIndex;

        private Result(ULocale uLocale, ULocale uLocale2, Locale locale, Locale locale2, int n2, int n3) {
            this.desiredULocale = uLocale;
            this.supportedULocale = uLocale2;
            this.desiredLocale = locale;
            this.supportedLocale = locale2;
            this.desiredIndex = n2;
            this.supportedIndex = n3;
        }

        public ULocale getDesiredULocale() {
            return this.desiredULocale == null && this.desiredLocale != null ? ULocale.forLocale(this.desiredLocale) : this.desiredULocale;
        }

        public Locale getDesiredLocale() {
            return this.desiredLocale == null && this.desiredULocale != null ? this.desiredULocale.toLocale() : this.desiredLocale;
        }

        public ULocale getSupportedULocale() {
            return this.supportedULocale;
        }

        public Locale getSupportedLocale() {
            return this.supportedLocale;
        }

        public int getDesiredIndex() {
            return this.desiredIndex;
        }

        public int getSupportedIndex() {
            return this.supportedIndex;
        }

        public ULocale makeResolvedULocale() {
            String string;
            ULocale uLocale = this.getDesiredULocale();
            if (this.supportedULocale == null || uLocale == null || this.supportedULocale.equals(uLocale)) {
                return this.supportedULocale;
            }
            ULocale.Builder builder = new ULocale.Builder().setLocale(this.supportedULocale);
            String string2 = uLocale.getCountry();
            if (!string2.isEmpty()) {
                builder.setRegion(string2);
            }
            if (!(string = uLocale.getVariant()).isEmpty()) {
                builder.setVariant(string);
            }
            for (char c2 : uLocale.getExtensionKeys()) {
                builder.setExtension(c2, uLocale.getExtension(c2));
            }
            return builder.build();
        }

        public Locale makeResolvedLocale() {
            ULocale uLocale = this.makeResolvedULocale();
            return uLocale != null ? uLocale.toLocale() : null;
        }
    }

    public static enum Direction {
        WITH_ONE_WAY,
        ONLY_TWO_WAY;

    }

    public static enum Demotion {
        NONE,
        REGION;

    }

    public static enum FavorSubtag {
        LANGUAGE,
        SCRIPT;

    }

    private static abstract class LsrIterator
    implements Iterator<LSR> {
        int bestDesiredIndex = -1;

        private LsrIterator() {
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public abstract void rememberCurrent(int var1);
    }
}

