/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Date;
import java.util.Locale;
import java.util.function.IntConsumer;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.CalendarAstronomer;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.CalendarCache;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.CalendarUtil;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Calendar;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public class IslamicCalendar
extends Calendar {
    private static final long serialVersionUID = -6253365474073869325L;
    public static final int MUHARRAM = 0;
    public static final int SAFAR = 1;
    public static final int RABI_1 = 2;
    public static final int RABI_2 = 3;
    public static final int JUMADA_1 = 4;
    public static final int JUMADA_2 = 5;
    public static final int RAJAB = 6;
    public static final int SHABAN = 7;
    public static final int RAMADAN = 8;
    public static final int SHAWWAL = 9;
    public static final int DHU_AL_QIDAH = 10;
    public static final int DHU_AL_HIJJAH = 11;
    private static final long HIJRA_MILLIS = -42521587200000L;
    private static final long CIVIL_EPOCH = 1948440L;
    private static final long ASTRONOMICAL_EPOCH = 1948439L;
    private static Algorithm ISLAMIC_ALGORITHM = new IslamicAlgorithm();
    private static Algorithm CIVIL_ALGORITHM = new CivilAlgorithm();
    private static Algorithm TBLA_ALGORITHM = new TBLAAlgorithm();
    private static Algorithm UMALQURA_ALGORITHM = new UmalquraAlgorithm();
    private static final int[][] LIMITS = new int[][]{{0, 0, 0, 0}, {1, 1, 5000000, 5000000}, {0, 0, 11, 11}, {1, 1, 50, 51}, new int[0], {1, 1, 29, 30}, {1, 1, 354, 355}, new int[0], {-1, -1, 5, 5}, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], {1, 1, 5000000, 5000000}, new int[0], {1, 1, 5000000, 5000000}, new int[0], new int[0], new int[0], {0, 0, 11, 11}};
    private static final int[] UMALQURA_MONTHLENGTH = new int[]{2730, 3412, 3785, 1748, 1770, 876, 2733, 1365, 1705, 1938, 2985, 1492, 2778, 1372, 3373, 1685, 1866, 2900, 2922, 1453, 1198, 2639, 1303, 1675, 1701, 2773, 726, 2395, 1181, 2637, 3366, 3477, 1452, 2486, 698, 2651, 1323, 2709, 1738, 2793, 756, 2422, 694, 2390, 2762, 2980, 3026, 1497, 732, 2413, 1357, 2725, 2898, 2981, 1460, 2486, 1367, 663, 1355, 1699, 1874, 2917, 1386, 2731, 1323, 3221, 3402, 3493, 1482, 2774, 2391, 1195, 2379, 2725, 2898, 2922, 1397, 630, 2231, 1115, 1365, 1449, 1460, 2522, 1245, 622, 2358, 2730, 3412, 3506, 1493, 730, 2395, 1195, 2645, 2889, 2916, 2929, 1460, 2741, 2645, 3365, 3730, 3785, 1748, 2793, 2411, 1195, 2707, 3401, 3492, 3506, 2745, 1210, 2651, 1323, 2709, 2858, 2901, 1372, 1213, 573, 2333, 2709, 2890, 2906, 1389, 694, 2363, 1179, 1621, 1705, 1876, 2922, 1388, 2733, 1365, 2857, 2962, 2985, 1492, 2778, 1370, 2731, 1429, 1865, 1892, 2986, 1461, 694, 2646, 3661, 2853, 2898, 2922, 1453, 686, 2351, 1175, 1611, 1701, 1708, 2774, 1373, 1181, 2637, 3350, 3477, 1450, 1461, 730, 2395, 1197, 1429, 1738, 1764, 2794, 1269, 694, 2390, 2730, 2900, 3026, 1497, 746, 2413, 1197, 2709, 2890, 2981, 1458, 2485, 1238, 2711, 1351, 1683, 1865, 2901, 1386, 2667, 1323, 2699, 3398, 3491, 1482, 2774, 1243, 619, 2379, 2725, 2898, 2921, 1397, 374, 2231, 603, 1323, 1381, 1460, 2522, 1261, 365, 2230, 2726, 3410, 3497, 1492, 2778, 2395, 1195, 1619, 1833, 1890, 2985, 1458, 2741, 1365, 2853, 3474, 3785, 1746, 2793, 1387, 1195, 2645, 3369, 3412, 3498, 2485, 1210, 2619, 1179, 2637, 2730, 2773, 730, 2397, 1118, 2606, 3226, 3413, 1714, 1721, 1210, 2653, 1325, 2709, 2898, 2984, 2996, 1465, 730, 2394, 2890, 3492, 3793, 1768, 2922, 1389, 1333, 1685, 3402, 3496, 3540, 1754, 1371, 669, 1579, 2837, 2890, 2965, 1450, 2734, 2350, 3215, 1319, 1685, 1706, 2774, 1373, 669};
    private static final int UMALQURA_YEAR_START = 1300;
    private static final int UMALQURA_YEAR_END = 1600;
    private static final byte[] UMALQURA_YEAR_START_ESTIMATE_FIX = new byte[]{0, 0, -1, 0, -1, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, -1, 0, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, -1, -1, 0, 0, 0, 1, 0, 0, -1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 1, 1, 0, 0, -1, 0, 1, 0, 1, 1, 0, 0, -1, 0, 1, 0, 0, 0, -1, 0, 1, 0, 1, 0, 0, 0, -1, 0, 0, 0, 0, -1, -1, 0, -1, 0, 1, 0, 0, 0, -1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, -1, -1, 0, 0, 0, 1, 0, 0, -1, -1, 0, -1, 0, 0, -1, -1, 0, -1, 0, -1, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, -1, 0, 1, 0, 1, 1, 0, 0, -1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, -1, 0, 1, 0, 0, -1, -1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, -1, 0, 0, 0, 1, 1, 0, 0, -1, 0, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, -1, 0, 0, 0, 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0, -1, 0, 1, 0, 0, 0, -1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, -1, 0, 0, 0, 0, 1, 0, 0, 0, -1, 0, 0, 0, 0, -1, -1, 0, -1, 0, 1, 0, 0, -1, -1, 0, 0, 1, 1, 0, 0, -1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1};
    private static CalendarCache cache = new CalendarCache();
    private boolean civil = true;
    private CalculationType cType = CalculationType.ISLAMIC_CIVIL;
    private transient Algorithm algorithm = CIVIL_ALGORITHM;

    public IslamicCalendar() {
        this(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
    }

    public IslamicCalendar(TimeZone timeZone) {
        this(timeZone, ULocale.getDefault(ULocale.Category.FORMAT));
    }

    public IslamicCalendar(Locale locale) {
        this(TimeZone.forLocaleOrDefault(locale), locale);
    }

    public IslamicCalendar(ULocale uLocale) {
        this(TimeZone.forULocaleOrDefault(uLocale), uLocale);
    }

    public IslamicCalendar(TimeZone timeZone, Locale locale) {
        this(timeZone, ULocale.forLocale(locale));
    }

    public IslamicCalendar(TimeZone timeZone, ULocale uLocale) {
        super(timeZone, uLocale);
        this.setCalcTypeForLocale(uLocale);
        this.setTimeInMillis(System.currentTimeMillis());
    }

    public IslamicCalendar(Date date) {
        super(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
        this.setTime(date);
    }

    public IslamicCalendar(int n2, int n3, int n4) {
        super(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
        this.set(1, n2);
        this.set(2, n3);
        this.set(5, n4);
    }

    public IslamicCalendar(int n2, int n3, int n4, int n5, int n6, int n7) {
        super(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
        this.set(1, n2);
        this.set(2, n3);
        this.set(5, n4);
        this.set(11, n5);
        this.set(12, n6);
        this.set(13, n7);
    }

    public void setCivil(boolean bl2) {
        if (bl2 && this.cType != CalculationType.ISLAMIC_CIVIL) {
            long l2 = this.getTimeInMillis();
            this.cType = CalculationType.ISLAMIC_CIVIL;
            this.algorithm = CIVIL_ALGORITHM;
            this.clear();
            this.setTimeInMillis(l2);
        } else if (!bl2 && this.cType != CalculationType.ISLAMIC) {
            long l3 = this.getTimeInMillis();
            this.cType = CalculationType.ISLAMIC;
            this.algorithm = ISLAMIC_ALGORITHM;
            this.clear();
            this.setTimeInMillis(l3);
        }
        this.civil = this.algorithm.isCivil();
    }

    public boolean isCivil() {
        return this.algorithm.isCivil();
    }

    @Override
    protected int handleGetLimit(int n2, int n3) {
        return LIMITS[n2][n3];
    }

    private static final boolean civilLeapYear(int n2) {
        return (14 + 11 * n2) % 30 < 11;
    }

    private long yearStart(int n2) {
        return this.algorithm.yearStart(n2);
    }

    private static final long trueMonthStart(long l2) {
        long l3 = cache.get(l2);
        if (l3 == CalendarCache.EMPTY) {
            long l4 = -42521587200000L + (long)Math.floor((double)l2 * 29.530588853) * 86400000L;
            double d2 = IslamicCalendar.moonAge(l4);
            if (IslamicCalendar.moonAge(l4) >= 0.0) {
                while ((d2 = IslamicCalendar.moonAge(l4 -= 86400000L)) >= 0.0) {
                }
            } else {
                while ((d2 = IslamicCalendar.moonAge(l4 += 86400000L)) < 0.0) {
                }
            }
            l3 = (l4 - -42521587200000L) / 86400000L + 1L;
            cache.put(l2, l3);
        }
        return l3;
    }

    static final double moonAge(long l2) {
        double d2 = new CalendarAstronomer(l2).getMoonAge();
        if ((d2 = d2 * 180.0 / Math.PI) > 180.0) {
            d2 -= 360.0;
        }
        return d2;
    }

    @Override
    protected int handleGetMonthLength(int n2, int n3) {
        return this.algorithm.monthLength(n2, n3);
    }

    @Override
    protected int handleGetYearLength(int n2) {
        return this.algorithm.yearLength(n2);
    }

    @Override
    protected int handleComputeMonthStart(int n2, int n3, boolean bl2) {
        return (int)(this.algorithm.monthStart(n2, n3) + this.algorithm.epoch() - 1L);
    }

    @Override
    protected int handleGetExtendedYear() {
        int n2 = this.newerField(19, 1) == 19 ? this.internalGet(19, 1) : this.internalGet(1, 1);
        return n2;
    }

    @Override
    protected void handleComputeFields(int n3) {
        this.algorithm.compute(n3, this.internalGetTimeInMillis(), n2 -> {
            this.internalSet(0, 0);
            this.internalSet(1, n2);
            this.internalSet(19, n2);
        }, n2 -> {
            this.internalSet(2, n2);
            this.internalSet(23, n2);
        }, n2 -> this.internalSet(5, n2), n2 -> this.internalSet(6, n2));
    }

    public void setCalculationType(CalculationType calculationType) {
        this.cType = calculationType;
        switch (this.cType) {
            case ISLAMIC_UMALQURA: {
                this.algorithm = UMALQURA_ALGORITHM;
                break;
            }
            case ISLAMIC: {
                this.algorithm = ISLAMIC_ALGORITHM;
                break;
            }
            case ISLAMIC_TBLA: {
                this.algorithm = TBLA_ALGORITHM;
                break;
            }
            default: {
                this.algorithm = CIVIL_ALGORITHM;
            }
        }
        this.civil = this.algorithm.isCivil();
    }

    public CalculationType getCalculationType() {
        return this.algorithm.getType();
    }

    private void setCalcTypeForLocale(ULocale uLocale) {
        String string = CalendarUtil.getCalendarType(uLocale);
        if ("islamic-civil".equals(string)) {
            this.setCalculationType(CalculationType.ISLAMIC_CIVIL);
        } else if ("islamic-umalqura".equals(string)) {
            this.setCalculationType(CalculationType.ISLAMIC_UMALQURA);
        } else if ("islamic-tbla".equals(string)) {
            this.setCalculationType(CalculationType.ISLAMIC_TBLA);
        } else if (string.startsWith("islamic")) {
            this.setCalculationType(CalculationType.ISLAMIC);
        } else {
            this.setCalculationType(CalculationType.ISLAMIC_CIVIL);
        }
    }

    @Override
    public String getType() {
        return this.algorithm.getType().bcpType();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.cType == null) {
            this.cType = this.civil ? CalculationType.ISLAMIC_CIVIL : CalculationType.ISLAMIC;
        }
        this.setCalculationType(this.cType);
    }

    @Override
    public boolean inTemporalLeapYear() {
        return this.getActualMaximum(6) == 355;
    }

    public static enum CalculationType {
        ISLAMIC("islamic"),
        ISLAMIC_CIVIL("islamic-civil"),
        ISLAMIC_UMALQURA("islamic-umalqura"),
        ISLAMIC_TBLA("islamic-tbla");

        private String bcpType;

        private CalculationType(String string2) {
            this.bcpType = string2;
        }

        String bcpType() {
            return this.bcpType;
        }
    }

    private static class UmalquraAlgorithm
    implements Algorithm {
        private UmalquraAlgorithm() {
        }

        @Override
        public boolean isCivil() {
            return false;
        }

        @Override
        public CalculationType getType() {
            return CalculationType.ISLAMIC_UMALQURA;
        }

        @Override
        public long epoch() {
            return 1948440L;
        }

        @Override
        public long yearStart(int n2) {
            if (n2 < 1300 || n2 > 1600) {
                return CIVIL_ALGORITHM.yearStart(n2);
            }
            int n3 = n2 - 1300;
            int n4 = (int)(354.3672 * (double)n3 + 460322.05 + 0.5);
            return n4 + UMALQURA_YEAR_START_ESTIMATE_FIX[n3];
        }

        @Override
        public long monthStart(int n2, int n3) {
            n2 += n3 / 12;
            n3 %= 12;
            if (n2 < 1300) {
                return CIVIL_ALGORITHM.monthStart(n2, n3);
            }
            long l2 = this.yearStart(n2);
            for (int i2 = 0; i2 < n3; ++i2) {
                l2 += (long)this.monthLength(n2, i2);
            }
            return l2;
        }

        @Override
        public int monthLength(int n2, int n3) {
            if (n2 < 1300 || n2 > 1600) {
                return CIVIL_ALGORITHM.monthLength(n2, n3);
            }
            int n4 = n2 - 1300;
            int n5 = 1 << 11 - n3;
            if ((UMALQURA_MONTHLENGTH[n4] & n5) != 0) {
                return 30;
            }
            return 29;
        }

        @Override
        public int yearLength(int n2) {
            if (n2 < 1300 || n2 > 1600) {
                return CIVIL_ALGORITHM.yearLength(n2);
            }
            int n3 = 0;
            for (int i2 = 0; i2 < 12; ++i2) {
                n3 += this.monthLength(n2, i2);
            }
            return n3;
        }

        @Override
        public void compute(long l2, long l3, IntConsumer intConsumer, IntConsumer intConsumer2, IntConsumer intConsumer3, IntConsumer intConsumer4) {
            long l4 = l2 - this.epoch();
            if (l4 < this.yearStart(1300)) {
                CIVIL_ALGORITHM.compute(l2, l3, intConsumer, intConsumer2, intConsumer3, intConsumer4);
                return;
            }
            int n2 = (int)(((double)l4 - 460322.55) / 354.3672) + 1300 - 1;
            int n3 = 0;
            long l5 = 1L;
            while (l5 > 0L) {
                int n4;
                if ((l5 = l4 - this.yearStart(++n2) + 1L) == (long)(n4 = this.yearLength(n2))) {
                    n3 = 11;
                    break;
                }
                if (l5 >= (long)n4) continue;
                int n5 = this.monthLength(n2, n3);
                n3 = 0;
                while (l5 > (long)n5) {
                    l5 -= (long)n5;
                    n5 = this.monthLength(n2, ++n3);
                }
                break block0;
            }
            intConsumer.accept(n2);
            intConsumer2.accept(n3);
            intConsumer3.accept((int)(l4 - this.monthStart(n2, n3)) + 1);
            intConsumer4.accept((int)(l4 - this.yearStart(n2) + 1L));
        }
    }

    private static class TBLAAlgorithm
    extends CivilAlgorithm {
        private TBLAAlgorithm() {
        }

        @Override
        public boolean isCivil() {
            return false;
        }

        @Override
        public CalculationType getType() {
            return CalculationType.ISLAMIC_TBLA;
        }

        @Override
        public long epoch() {
            return 1948439L;
        }
    }

    private static class CivilAlgorithm
    implements Algorithm {
        private CivilAlgorithm() {
        }

        @Override
        public boolean isCivil() {
            return true;
        }

        @Override
        public CalculationType getType() {
            return CalculationType.ISLAMIC_CIVIL;
        }

        @Override
        public long epoch() {
            return 1948440L;
        }

        @Override
        public long yearStart(int n2) {
            return (long)((n2 - 1) * 354) + (long)Math.floor((double)(3 + 11 * n2) / 30.0);
        }

        @Override
        public long monthStart(int n2, int n3) {
            return (long)Math.ceil(29.5 * (double)(n3 % 12)) + this.yearStart(n2 + n3 / 12);
        }

        @Override
        public int monthLength(int n2, int n3) {
            int n4 = 29;
            if (n3 % 2 == 0) {
                ++n4;
            }
            if (n3 == 11 && IslamicCalendar.civilLeapYear(n2)) {
                ++n4;
            }
            return n4;
        }

        @Override
        public int yearLength(int n2) {
            return 354 + (IslamicCalendar.civilLeapYear(n2) ? 1 : 0);
        }

        @Override
        public void compute(long l2, long l3, IntConsumer intConsumer, IntConsumer intConsumer2, IntConsumer intConsumer3, IntConsumer intConsumer4) {
            long l4 = l2 - this.epoch();
            int n2 = (int)Math.floor((double)(30L * l4 + 10646L) / 10631.0);
            int n3 = (int)Math.ceil((double)(l4 - 29L - this.yearStart(n2)) / 29.5);
            n3 = Math.min(n3, 11);
            intConsumer.accept(n2);
            intConsumer2.accept(n3);
            intConsumer3.accept((int)(l4 - this.monthStart(n2, n3)) + 1);
            intConsumer4.accept((int)(l4 - this.yearStart(n2) + 1L));
        }
    }

    private static class IslamicAlgorithm
    implements Algorithm {
        private IslamicAlgorithm() {
        }

        @Override
        public boolean isCivil() {
            return false;
        }

        @Override
        public CalculationType getType() {
            return CalculationType.ISLAMIC;
        }

        @Override
        public long epoch() {
            return 1948440L;
        }

        @Override
        public long yearStart(int n2) {
            return this.monthStart(n2, 0);
        }

        @Override
        public long monthStart(int n2, int n3) {
            return IslamicCalendar.trueMonthStart(12 * (n2 + n3 / 12 - 1) + n3 % 12);
        }

        @Override
        public int monthLength(int n2, int n3) {
            return (int)(IslamicCalendar.trueMonthStart((n3 += 12 * (n2 - 1)) + 1) - IslamicCalendar.trueMonthStart(n3));
        }

        @Override
        public int yearLength(int n2) {
            int n3 = 12 * (n2 - 1);
            return (int)(IslamicCalendar.trueMonthStart(n3 + 12) - IslamicCalendar.trueMonthStart(n3));
        }

        @Override
        public void compute(long l2, long l3, IntConsumer intConsumer, IntConsumer intConsumer2, IntConsumer intConsumer3, IntConsumer intConsumer4) {
            int n2;
            long l4;
            long l5 = l2 - this.epoch();
            if (l5 - (l4 = (long)Math.floor((double)(n2 = (int)Math.floor((double)l5 / 29.530588853)) * 29.530588853 - 1.0)) >= 25L && IslamicCalendar.moonAge(l3) > 0.0) {
                ++n2;
            }
            while ((l4 = IslamicCalendar.trueMonthStart(n2)) > l5) {
                --n2;
            }
            int n3 = n2 >= 0 ? n2 / 12 + 1 : (n2 + 1) / 12;
            n2 = (n2 % 12 + 12) % 12;
            intConsumer.accept(n3);
            intConsumer2.accept(n2);
            intConsumer3.accept((int)(l5 - this.monthStart(n3, n2)) + 1);
            intConsumer4.accept((int)(l5 - this.yearStart(n3) + 1L));
        }
    }

    private static interface Algorithm {
        public boolean isCivil();

        public CalculationType getType();

        public long epoch();

        public long yearStart(int var1);

        public long monthStart(int var1, int var2);

        public int monthLength(int var1, int var2);

        public int yearLength(int var1);

        public void compute(long var1, long var3, IntConsumer var5, IntConsumer var6, IntConsumer var7, IntConsumer var8);
    }
}

