/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.util;

import java.util.Date;
import java.util.Locale;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Calendar;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public class IndianCalendar
extends Calendar {
    private static final long serialVersionUID = 3617859668165014834L;
    public static final int CHAITRA = 0;
    public static final int VAISAKHA = 1;
    public static final int JYAISTHA = 2;
    public static final int ASADHA = 3;
    public static final int SRAVANA = 4;
    public static final int BHADRA = 5;
    public static final int ASVINA = 6;
    public static final int KARTIKA = 7;
    public static final int AGRAHAYANA = 8;
    public static final int PAUSA = 9;
    public static final int MAGHA = 10;
    public static final int PHALGUNA = 11;
    public static final int IE = 0;
    private static final int INDIAN_ERA_START = 78;
    private static final int INDIAN_YEAR_START = 80;
    private static final int[][] LIMITS = new int[][]{{0, 0, 0, 0}, {-5000000, -5000000, 5000000, 5000000}, {0, 0, 11, 11}, {1, 1, 52, 53}, new int[0], {1, 1, 30, 31}, {1, 1, 365, 366}, new int[0], {-1, -1, 5, 5}, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], {-5000000, -5000000, 5000000, 5000000}, new int[0], {-5000000, -5000000, 5000000, 5000000}, new int[0], new int[0], new int[0], {0, 0, 11, 11}};

    public IndianCalendar() {
        this(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
    }

    public IndianCalendar(TimeZone timeZone) {
        this(timeZone, ULocale.getDefault(ULocale.Category.FORMAT));
    }

    public IndianCalendar(Locale locale) {
        this(TimeZone.forLocaleOrDefault(locale), locale);
    }

    public IndianCalendar(ULocale uLocale) {
        this(TimeZone.forULocaleOrDefault(uLocale), uLocale);
    }

    public IndianCalendar(TimeZone timeZone, Locale locale) {
        super(timeZone, locale);
        this.setTimeInMillis(System.currentTimeMillis());
    }

    public IndianCalendar(TimeZone timeZone, ULocale uLocale) {
        super(timeZone, uLocale);
        this.setTimeInMillis(System.currentTimeMillis());
    }

    public IndianCalendar(Date date) {
        super(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
        this.setTime(date);
    }

    public IndianCalendar(int n2, int n3, int n4) {
        super(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
        this.set(1, n2);
        this.set(2, n3);
        this.set(5, n4);
    }

    public IndianCalendar(int n2, int n3, int n4, int n5, int n6, int n7) {
        super(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
        this.set(1, n2);
        this.set(2, n3);
        this.set(5, n4);
        this.set(11, n5);
        this.set(12, n6);
        this.set(13, n7);
    }

    @Override
    protected int handleGetExtendedYear() {
        int n2 = this.newerField(19, 1) == 19 ? this.internalGet(19, 1) : this.internalGet(1, 1);
        return n2;
    }

    @Override
    protected int handleGetYearLength(int n2) {
        return super.handleGetYearLength(n2);
    }

    @Override
    protected int handleGetMonthLength(int n2, int n3) {
        if (n3 < 0 || n3 > 11) {
            int[] nArray = new int[1];
            n2 += IndianCalendar.floorDivide(n3, 12, nArray);
            n3 = nArray[0];
        }
        if (IndianCalendar.isGregorianLeapYear(n2 + 78) && n3 == 0) {
            return 31;
        }
        if (n3 >= 1 && n3 <= 5) {
            return 31;
        }
        return 30;
    }

    @Override
    protected void handleComputeFields(int n2) {
        int n3;
        int n4;
        int n5;
        this.computeGregorianFields(n2);
        int n6 = this.getGregorianYear();
        int n7 = n6 - 78;
        double d2 = this.gregorianToJD(n6, 0, 1);
        int n8 = (int)((double)n2 - d2);
        if (n8 < 80) {
            --n7;
            n5 = IndianCalendar.isGregorianLeapYear(n6 - 1) ? 31 : 30;
            n8 += n5 + 155 + 90 + 10;
        } else {
            n5 = IndianCalendar.isGregorianLeapYear(n6) ? 31 : 30;
            n8 -= 80;
        }
        if (n8 < n5) {
            n4 = 0;
            n3 = n8 + 1;
        } else {
            int n9 = n8 - n5;
            if (n9 < 155) {
                n4 = n9 / 31 + 1;
                n3 = n9 % 31 + 1;
            } else {
                n4 = (n9 -= 155) / 30 + 6;
                n3 = n9 % 30 + 1;
            }
        }
        this.internalSet(0, 0);
        this.internalSet(19, n7);
        this.internalSet(1, n7);
        this.internalSet(2, n4);
        this.internalSet(23, n4);
        this.internalSet(5, n3);
        this.internalSet(6, n8 + 1);
    }

    @Override
    protected int handleGetLimit(int n2, int n3) {
        return LIMITS[n2][n3];
    }

    @Override
    protected int handleComputeMonthStart(int n2, int n3, boolean bl2) {
        if (n3 < 0 || n3 > 11) {
            n2 += n3 / 12;
            n3 %= 12;
        }
        int n4 = n3 + 1;
        double d2 = this.IndianToJD(n2, n4, 1);
        return (int)d2;
    }

    private double IndianToJD(int n2, int n3, int n4) {
        double d2;
        double d3;
        int n5;
        int n6 = n2 + 78;
        if (IndianCalendar.isGregorianLeapYear(n6)) {
            n5 = 31;
            d3 = this.gregorianToJD(n6, 2, 21);
        } else {
            n5 = 30;
            d3 = this.gregorianToJD(n6, 2, 22);
        }
        if (n3 == 1) {
            d2 = d3 + (double)(n4 - 1);
        } else {
            d2 = d3 + (double)n5;
            int n7 = n3 - 2;
            n7 = Math.min(n7, 5);
            d2 += (double)(n7 * 31);
            if (n3 >= 8) {
                n7 = n3 - 7;
                d2 += (double)(n7 * 30);
            }
            d2 += (double)(n4 - 1);
        }
        return d2;
    }

    private double gregorianToJD(int n2, int n3, int n4) {
        return (double)(this.computeGregorianMonthStart(n2, n3) + n4) - 0.5;
    }

    @Override
    public String getType() {
        return "indian";
    }
}

