/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.util;

import java.util.Date;
import java.util.Locale;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.CalendarCache;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Calendar;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public class HebrewCalendar
extends Calendar {
    private static final long serialVersionUID = -1952524560588825816L;
    public static final int TISHRI = 0;
    public static final int HESHVAN = 1;
    public static final int KISLEV = 2;
    public static final int TEVET = 3;
    public static final int SHEVAT = 4;
    public static final int ADAR_1 = 5;
    public static final int ADAR = 6;
    public static final int NISAN = 7;
    public static final int IYAR = 8;
    public static final int SIVAN = 9;
    public static final int TAMUZ = 10;
    public static final int AV = 11;
    public static final int ELUL = 12;
    private static final int[][] LIMITS = new int[][]{{0, 0, 0, 0}, {-5000000, -5000000, 5000000, 5000000}, {0, 0, 12, 12}, {1, 1, 51, 56}, new int[0], {1, 1, 29, 30}, {1, 1, 353, 385}, new int[0], {-1, -1, 5, 5}, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], {-5000000, -5000000, 5000000, 5000000}, new int[0], {-5000000, -5000000, 5000000, 5000000}, new int[0], new int[0], new int[0], {0, 0, 11, 12}};
    private static final int[][] MONTH_LENGTH = new int[][]{{30, 30, 30}, {29, 29, 30}, {29, 30, 30}, {29, 29, 29}, {30, 30, 30}, {30, 30, 30}, {29, 29, 29}, {30, 30, 30}, {29, 29, 29}, {30, 30, 30}, {29, 29, 29}, {30, 30, 30}, {29, 29, 29}};
    private static final int[][] MONTH_START = new int[][]{{0, 0, 0}, {30, 30, 30}, {59, 59, 60}, {88, 89, 90}, {117, 118, 119}, {147, 148, 149}, {147, 148, 149}, {176, 177, 178}, {206, 207, 208}, {235, 236, 237}, {265, 266, 267}, {294, 295, 296}, {324, 325, 326}, {353, 354, 355}};
    private static final int[][] LEAP_MONTH_START = new int[][]{{0, 0, 0}, {30, 30, 30}, {59, 59, 60}, {88, 89, 90}, {117, 118, 119}, {147, 148, 149}, {177, 178, 179}, {206, 207, 208}, {236, 237, 238}, {265, 266, 267}, {295, 296, 297}, {324, 325, 326}, {354, 355, 356}, {383, 384, 385}};
    private static final int MONTHS_IN_CYCLE = 235;
    private static final int YEARS_IN_CYCLE = 19;
    private static CalendarCache cache = new CalendarCache();
    private static final long HOUR_PARTS = 1080L;
    private static final long DAY_PARTS = 25920L;
    private static final int MONTH_DAYS = 29;
    private static final long MONTH_FRACT = 13753L;
    private static final long MONTH_PARTS = 765433L;
    private static final long BAHARAD = 12084L;
    private static String[] gTemporalMonthCodesForHebrew = new String[]{"M01", "M02", "M03", "M04", "M05", "M05L", "M06", "M07", "M08", "M09", "M10", "M11", "M12"};

    public HebrewCalendar() {
        this(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
    }

    public HebrewCalendar(TimeZone timeZone) {
        this(timeZone, ULocale.getDefault(ULocale.Category.FORMAT));
    }

    public HebrewCalendar(Locale locale) {
        this(TimeZone.forLocaleOrDefault(locale), locale);
    }

    public HebrewCalendar(ULocale uLocale) {
        this(TimeZone.forULocaleOrDefault(uLocale), uLocale);
    }

    public HebrewCalendar(TimeZone timeZone, Locale locale) {
        super(timeZone, locale);
        this.setTimeInMillis(System.currentTimeMillis());
    }

    public HebrewCalendar(TimeZone timeZone, ULocale uLocale) {
        super(timeZone, uLocale);
        this.setTimeInMillis(System.currentTimeMillis());
    }

    public HebrewCalendar(int n2, int n3, int n4) {
        super(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
        this.set(1, n2);
        this.set(2, n3);
        this.set(5, n4);
    }

    public HebrewCalendar(Date date) {
        super(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
        this.setTime(date);
    }

    public HebrewCalendar(int n2, int n3, int n4, int n5, int n6, int n7) {
        super(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
        this.set(1, n2);
        this.set(2, n3);
        this.set(5, n4);
        this.set(11, n5);
        this.set(12, n6);
        this.set(13, n7);
    }

    @Override
    public void add(int n2, int n3) {
        switch (n2) {
            case 2: 
            case 23: {
                int n4 = this.get(2);
                int n5 = this.get(1);
                if (n3 > 0) {
                    boolean bl2 = n4 < 5;
                    n4 += n3;
                    while (true) {
                        if (bl2 && n4 >= 5 && !HebrewCalendar.isLeapYear(n5)) {
                            ++n4;
                        }
                        if (n4 > 12) {
                            n4 -= 13;
                            ++n5;
                            bl2 = true;
                            continue;
                        }
                        break;
                    }
                } else {
                    boolean bl3 = n4 > 5;
                    n4 += n3;
                    while (true) {
                        if (bl3 && n4 <= 5 && !HebrewCalendar.isLeapYear(n5)) {
                            --n4;
                        }
                        if (n4 >= 0) break;
                        n4 += 13;
                        --n5;
                        bl3 = true;
                    }
                }
                this.set(2, n4);
                this.set(1, n5);
                this.pinField(5);
                break;
            }
            default: {
                super.add(n2, n3);
            }
        }
    }

    @Override
    public void roll(int n2, int n3) {
        switch (n2) {
            case 2: 
            case 23: {
                int n4 = this.get(2);
                int n5 = this.get(1);
                boolean bl2 = HebrewCalendar.isLeapYear(n5);
                int n6 = HebrewCalendar.monthsInYear(n5);
                int n7 = n4 + n3 % n6;
                if (!bl2) {
                    if (n3 > 0 && n4 < 5 && n7 >= 5) {
                        ++n7;
                    } else if (n3 < 0 && n4 > 5 && n7 <= 5) {
                        --n7;
                    }
                }
                this.set(2, (n7 + 13) % 13);
                this.pinField(5);
                return;
            }
        }
        super.roll(n2, n3);
    }

    private static long startOfYear(int n2) {
        long l2 = cache.get(n2);
        if (l2 == CalendarCache.EMPTY) {
            int n3 = (int)HebrewCalendar.floorDivide(235L * (long)n2 - 234L, 19L);
            long l3 = (long)n3 * 13753L + 12084L;
            l2 = (long)(n3 * 29) + l3 / 25920L;
            l3 %= 25920L;
            int n4 = (int)(l2 % 7L);
            if (n4 == 2 || n4 == 4 || n4 == 6) {
                n4 = (int)(++l2 % 7L);
            }
            if (n4 == 1 && l3 > 16404L && !HebrewCalendar.isLeapYear(n2)) {
                l2 += 2L;
            } else if (n4 == 0 && l3 > 23269L && HebrewCalendar.isLeapYear(n2 - 1)) {
                ++l2;
            }
            cache.put(n2, l2);
        }
        return l2;
    }

    private final int yearType(int n2) {
        int n3 = this.handleGetYearLength(n2);
        if (n3 > 380) {
            n3 -= 30;
        }
        int n4 = 0;
        switch (n3) {
            case 353: {
                n4 = 0;
                break;
            }
            case 354: {
                n4 = 1;
                break;
            }
            case 355: {
                n4 = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal year length " + n3 + " in year " + n2);
            }
        }
        return n4;
    }

    @Deprecated
    public static boolean isLeapYear(int n2) {
        int n3;
        return n3 >= ((n3 = (n2 * 12 + 17) % 19) < 0 ? -7 : 12);
    }

    private static int monthsInYear(int n2) {
        return HebrewCalendar.isLeapYear(n2) ? 13 : 12;
    }

    @Override
    protected int handleGetLimit(int n2, int n3) {
        return LIMITS[n2][n3];
    }

    @Override
    protected int handleGetMonthLength(int n2, int n3) {
        if (n3 <= -235 || 235 <= n3) {
            n2 += n3 / 235 * 19;
            n3 %= 235;
        }
        while (n3 < 0) {
            n3 += HebrewCalendar.monthsInYear(--n2);
        }
        while (n3 > 12) {
            n3 -= HebrewCalendar.monthsInYear(n2++);
        }
        switch (n3) {
            case 1: 
            case 2: {
                return MONTH_LENGTH[n3][this.yearType(n2)];
            }
        }
        return MONTH_LENGTH[n3][0];
    }

    @Override
    protected int handleGetYearLength(int n2) {
        return (int)(HebrewCalendar.startOfYear(n2 + 1) - HebrewCalendar.startOfYear(n2));
    }

    @Override
    @Deprecated
    protected void validateField(int n2) {
        if (!(n2 != 2 && n2 != 23 || HebrewCalendar.isLeapYear(this.handleGetExtendedYear()) || this.internalGetMonth() != 5)) {
            throw new IllegalArgumentException("MONTH cannot be ADAR_1(5) except leap years");
        }
        super.validateField(n2);
    }

    @Override
    protected void handleComputeFields(int n2) {
        long l2 = n2 - 347997;
        long l3 = HebrewCalendar.floorDivide(l2 * 25920L, 765433L);
        int n3 = (int)(HebrewCalendar.floorDivide(19L * l3 + 234L, 235L) + 1L);
        long l4 = HebrewCalendar.startOfYear(n3);
        int n4 = (int)(l2 - l4);
        while (n4 < 1) {
            l4 = HebrewCalendar.startOfYear(--n3);
            n4 = (int)(l2 - l4);
        }
        int n5 = this.yearType(n3);
        boolean bl2 = HebrewCalendar.isLeapYear(n3);
        int[][] nArray = bl2 ? LEAP_MONTH_START : MONTH_START;
        int n6 = 0;
        while (n4 > nArray[n6][n5]) {
            ++n6;
        }
        int n7 = n4 - nArray[--n6][n5];
        this.internalSet(0, 0);
        this.internalSet(1, n3);
        this.internalSet(19, n3);
        int n8 = n6;
        if (!bl2 && n8 > 5) {
            --n8;
        }
        this.internalSet(23, n8);
        this.internalSet(2, n6);
        this.internalSet(5, n7);
        this.internalSet(6, n4);
    }

    @Override
    protected int handleGetExtendedYear() {
        int n2 = this.newerField(19, 1) == 19 ? this.internalGet(19, 1) : this.internalGet(1, 1);
        return n2;
    }

    @Override
    protected int handleComputeMonthStart(int n2, int n3, boolean bl2) {
        if (n3 <= -235 || 235 <= n3) {
            n2 += n3 / 235 * 19;
            n3 %= 235;
        }
        while (n3 < 0) {
            n3 += HebrewCalendar.monthsInYear(--n2);
        }
        while (n3 > 12) {
            n3 -= HebrewCalendar.monthsInYear(n2++);
        }
        long l2 = HebrewCalendar.startOfYear(n2);
        if (n3 != 0) {
            l2 = HebrewCalendar.isLeapYear(n2) ? (l2 += (long)LEAP_MONTH_START[n3][this.yearType(n2)]) : (l2 += (long)MONTH_START[n3][this.yearType(n2)]);
        }
        return (int)(l2 + 347997L);
    }

    @Override
    public String getType() {
        return "hebrew";
    }

    @Override
    public boolean inTemporalLeapYear() {
        return HebrewCalendar.isLeapYear(this.get(19));
    }

    @Override
    public String getTemporalMonthCode() {
        return gTemporalMonthCodesForHebrew[this.get(2)];
    }

    @Override
    public void setTemporalMonthCode(String string) {
        if (string.length() == 3 || string.length() == 4) {
            for (int i2 = 0; i2 < gTemporalMonthCodesForHebrew.length; ++i2) {
                if (!string.equals(gTemporalMonthCodesForHebrew[i2])) continue;
                this.set(2, i2);
                return;
            }
        }
        throw new IllegalArgumentException("Incorrect temporal Month code: " + string);
    }

    @Override
    @Deprecated
    protected int internalGetMonth() {
        if (this.resolveFields(MONTH_PRECEDENCE) == 23) {
            int n2 = this.internalGet(23);
            int n3 = this.handleGetExtendedYear();
            return n2 + (!HebrewCalendar.isLeapYear(n3) && n2 > 5 ? 1 : 0);
        }
        return super.internalGetMonth();
    }
}

