/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.util;

import java.util.Date;
import java.util.Locale;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Calendar;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public class GregorianCalendar
extends Calendar {
    private static final long serialVersionUID = 9199388694351062137L;
    public static final int BC = 0;
    public static final int AD = 1;
    private static final int EPOCH_YEAR = 1970;
    private static final int[][] MONTH_COUNT = new int[][]{{31, 31, 0, 0}, {28, 29, 31, 31}, {31, 31, 59, 60}, {30, 30, 90, 91}, {31, 31, 120, 121}, {30, 30, 151, 152}, {31, 31, 181, 182}, {31, 31, 212, 213}, {30, 30, 243, 244}, {31, 31, 273, 274}, {30, 30, 304, 305}, {31, 31, 334, 335}};
    private static final int[][] LIMITS = new int[][]{{0, 0, 1, 1}, {1, 1, 5828963, 5838270}, {0, 0, 11, 11}, {1, 1, 52, 53}, new int[0], {1, 1, 28, 31}, {1, 1, 365, 366}, new int[0], {-1, -1, 4, 5}, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], {-5838270, -5838270, 5828964, 5838271}, new int[0], {-5838269, -5838269, 5828963, 5838270}, new int[0], new int[0], new int[0], {0, 0, 11, 11}};
    private long gregorianCutover = -12219292800000L;
    private transient int cutoverJulianDay = 2299161;
    private transient int gregorianCutoverYear = 1582;
    protected transient boolean isGregorian;
    protected transient boolean invertGregorian;

    @Override
    protected int handleGetLimit(int n2, int n3) {
        return LIMITS[n2][n3];
    }

    public GregorianCalendar() {
        this(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
    }

    public GregorianCalendar(TimeZone timeZone) {
        this(timeZone, ULocale.getDefault(ULocale.Category.FORMAT));
    }

    public GregorianCalendar(Locale locale) {
        this(TimeZone.forLocaleOrDefault(locale), locale);
    }

    public GregorianCalendar(ULocale uLocale) {
        this(TimeZone.forULocaleOrDefault(uLocale), uLocale);
    }

    public GregorianCalendar(TimeZone timeZone, Locale locale) {
        super(timeZone, locale);
        this.setTimeInMillis(System.currentTimeMillis());
    }

    public GregorianCalendar(TimeZone timeZone, ULocale uLocale) {
        super(timeZone, uLocale);
        this.setTimeInMillis(System.currentTimeMillis());
    }

    public GregorianCalendar(int n2, int n3, int n4) {
        super(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
        this.set(0, 1);
        this.set(1, n2);
        this.set(2, n3);
        this.set(5, n4);
    }

    public GregorianCalendar(int n2, int n3, int n4, int n5, int n6) {
        super(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
        this.set(0, 1);
        this.set(1, n2);
        this.set(2, n3);
        this.set(5, n4);
        this.set(11, n5);
        this.set(12, n6);
    }

    public GregorianCalendar(int n2, int n3, int n4, int n5, int n6, int n7) {
        super(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
        this.set(0, 1);
        this.set(1, n2);
        this.set(2, n3);
        this.set(5, n4);
        this.set(11, n5);
        this.set(12, n6);
        this.set(13, n7);
    }

    public void setGregorianChange(Date date) {
        this.gregorianCutover = date.getTime();
        if (this.gregorianCutover <= -184303902528000000L) {
            this.cutoverJulianDay = Integer.MIN_VALUE;
            this.gregorianCutoverYear = Integer.MIN_VALUE;
        } else if (this.gregorianCutover >= 183882168921600000L) {
            this.cutoverJulianDay = Integer.MAX_VALUE;
            this.gregorianCutoverYear = Integer.MAX_VALUE;
        } else {
            this.cutoverJulianDay = (int)GregorianCalendar.floorDivide(this.gregorianCutover, 86400000L);
            GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
            gregorianCalendar.setTime(date);
            this.gregorianCutoverYear = gregorianCalendar.get(19);
        }
    }

    public final Date getGregorianChange() {
        return new Date(this.gregorianCutover);
    }

    public boolean isLeapYear(int n2) {
        return n2 >= this.gregorianCutoverYear ? n2 % 4 == 0 && (n2 % 100 != 0 || n2 % 400 == 0) : n2 % 4 == 0;
    }

    @Override
    public boolean isEquivalentTo(Calendar calendar) {
        return super.isEquivalentTo(calendar) && this.gregorianCutover == ((GregorianCalendar)calendar).gregorianCutover;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ (int)this.gregorianCutover;
    }

    @Override
    public void roll(int n2, int n3) {
        switch (n2) {
            case 3: {
                int n4 = this.get(3);
                int n5 = this.get(17);
                int n6 = this.internalGet(6);
                if (this.internalGetMonth() == 0) {
                    if (n4 >= 52) {
                        n6 += this.handleGetYearLength(n5);
                    }
                } else if (n4 == 1) {
                    n6 -= this.handleGetYearLength(n5 - 1);
                }
                if ((n4 += n3) < 1 || n4 > 52) {
                    int n7 = this.handleGetYearLength(n5);
                    int n8 = (n7 - n6 + this.internalGet(7) - this.getFirstDayOfWeek()) % 7;
                    if (n8 < 0) {
                        n8 += 7;
                    }
                    if (6 - n8 >= this.getMinimalDaysInFirstWeek()) {
                        n7 -= 7;
                    }
                    int n9 = this.weekNumber(n7, n8 + 1);
                    n4 = (n4 + n9 - 1) % n9 + 1;
                }
                this.set(3, n4);
                this.set(1, n5);
                return;
            }
        }
        super.roll(n2, n3);
    }

    @Override
    public int getActualMinimum(int n2) {
        return this.getMinimum(n2);
    }

    @Override
    public int getActualMaximum(int n2) {
        switch (n2) {
            case 1: {
                Calendar calendar = (Calendar)this.clone();
                calendar.setLenient(true);
                int n3 = calendar.get(0);
                Date date = calendar.getTime();
                int n4 = LIMITS[1][1];
                int n5 = LIMITS[1][2] + 1;
                while (n4 + 1 < n5) {
                    int n6 = (n4 + n5) / 2;
                    calendar.set(1, n6);
                    if (calendar.get(1) == n6 && calendar.get(0) == n3) {
                        n4 = n6;
                        continue;
                    }
                    n5 = n6;
                    calendar.setTime(date);
                }
                return n4;
            }
        }
        return super.getActualMaximum(n2);
    }

    boolean inDaylightTime() {
        if (!this.getTimeZone().useDaylightTime()) {
            return false;
        }
        this.complete();
        return this.internalGet(16) != 0;
    }

    @Override
    protected int handleGetMonthLength(int n2, int n3) {
        if (n3 < 0 || n3 > 11) {
            int[] nArray = new int[1];
            n2 += GregorianCalendar.floorDivide(n3, 12, nArray);
            n3 = nArray[0];
        }
        return MONTH_COUNT[n3][this.isLeapYear(n2) ? 1 : 0];
    }

    @Override
    protected int handleGetYearLength(int n2) {
        return this.isLeapYear(n2) ? 366 : 365;
    }

    @Override
    protected void handleComputeFields(int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (n2 >= this.cutoverJulianDay) {
            n6 = this.getGregorianMonth();
            n5 = this.getGregorianDayOfMonth();
            n4 = this.getGregorianDayOfYear();
            n3 = this.getGregorianYear();
        } else {
            int n7;
            long l2 = n2 - 1721424;
            n3 = (int)GregorianCalendar.floorDivide(4L * l2 + 1464L, 1461L);
            long l3 = 365L * ((long)n3 - 1L) + GregorianCalendar.floorDivide((long)n3 - 1L, 4L);
            n4 = (int)(l2 - l3);
            boolean bl2 = (n3 & 3) == 0;
            int n8 = 0;
            int n9 = n7 = bl2 ? 60 : 59;
            if (n4 >= n7) {
                n8 = bl2 ? 1 : 2;
            }
            n6 = (12 * (n4 + n8) + 6) / 367;
            n5 = n4 - MONTH_COUNT[n6][bl2 ? 3 : 2] + 1;
            ++n4;
        }
        this.internalSet(2, n6);
        this.internalSet(23, n6);
        this.internalSet(5, n5);
        this.internalSet(6, n4);
        this.internalSet(19, n3);
        int n10 = 1;
        if (n3 < 1) {
            n10 = 0;
            n3 = 1 - n3;
        }
        this.internalSet(0, n10);
        this.internalSet(1, n3);
    }

    @Override
    protected int handleGetExtendedYear() {
        int n2;
        int n3 = this.newerField(19, 1) == 19 ? this.internalGet(19, 1970) : ((n2 = this.internalGet(0, 1)) == 0 ? 1 - this.internalGet(1, 1) : this.internalGet(1, 1970));
        return n3;
    }

    @Override
    protected int handleComputeJulianDay(int n2) {
        this.invertGregorian = false;
        int n3 = super.handleComputeJulianDay(n2);
        if (this.isGregorian != n3 >= this.cutoverJulianDay) {
            this.invertGregorian = true;
            n3 = super.handleComputeJulianDay(n2);
        }
        return n3;
    }

    @Override
    protected int handleComputeMonthStart(int n2, int n3, boolean bl2) {
        if (n3 < 0 || n3 > 11) {
            int[] nArray = new int[1];
            n2 += GregorianCalendar.floorDivide(n3, 12, nArray);
            n3 = nArray[0];
        }
        boolean bl3 = n2 % 4 == 0;
        int n4 = n2 - 1;
        int n5 = 365 * n4 + GregorianCalendar.floorDivide(n4, 4) + 1721423;
        boolean bl4 = this.isGregorian = n2 >= this.gregorianCutoverYear;
        if (this.invertGregorian) {
            boolean bl5 = this.isGregorian = !this.isGregorian;
        }
        if (this.isGregorian) {
            bl3 = bl3 && (n2 % 100 != 0 || n2 % 400 == 0);
            n5 += GregorianCalendar.floorDivide(n4, 400) - GregorianCalendar.floorDivide(n4, 100) + 2;
        }
        if (n3 != 0) {
            n5 += MONTH_COUNT[n3][bl3 ? 3 : 2];
        }
        return n5;
    }

    @Override
    public String getType() {
        return "gregorian";
    }

    @Override
    @Deprecated
    protected boolean isEra0CountingBackward() {
        return true;
    }
}

