/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.util;

import java.util.Date;
import java.util.Locale;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.CalendarUtil;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.CECalendar;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public final class EthiopicCalendar
extends CECalendar {
    private static final long serialVersionUID = -2438495771339315608L;
    public static final int MESKEREM = 0;
    public static final int TEKEMT = 1;
    public static final int HEDAR = 2;
    public static final int TAHSAS = 3;
    public static final int TER = 4;
    public static final int YEKATIT = 5;
    public static final int MEGABIT = 6;
    public static final int MIAZIA = 7;
    public static final int GENBOT = 8;
    public static final int SENE = 9;
    public static final int HAMLE = 10;
    public static final int NEHASSE = 11;
    public static final int PAGUMEN = 12;
    private static final int JD_EPOCH_OFFSET_AMETE_MIHRET = 1723856;
    private static final int AMETE_MIHRET_DELTA = 5500;
    private static final int AMETE_ALEM = 0;
    private static final int AMETE_MIHRET = 1;
    private static final int AMETE_MIHRET_ERA = 0;
    private static final int AMETE_ALEM_ERA = 1;
    private int eraType = 0;

    public EthiopicCalendar() {
        this(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
    }

    public EthiopicCalendar(TimeZone timeZone) {
        this(timeZone, ULocale.getDefault(ULocale.Category.FORMAT));
    }

    public EthiopicCalendar(Locale locale) {
        this(TimeZone.forLocaleOrDefault(locale), locale);
    }

    public EthiopicCalendar(ULocale uLocale) {
        this(TimeZone.forULocaleOrDefault(uLocale), uLocale);
    }

    public EthiopicCalendar(TimeZone timeZone, Locale locale) {
        this(timeZone, ULocale.forLocale(locale));
    }

    public EthiopicCalendar(TimeZone timeZone, ULocale uLocale) {
        super(timeZone, uLocale);
        this.setCalcTypeForLocale(uLocale);
    }

    public EthiopicCalendar(int n2, int n3, int n4) {
        super(n2, n3, n4);
    }

    public EthiopicCalendar(Date date) {
        super(date);
    }

    public EthiopicCalendar(int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n2, n3, n4, n5, n6, n7);
    }

    @Override
    public String getType() {
        if (this.isAmeteAlemEra()) {
            return "ethiopic-amete-alem";
        }
        return "ethiopic";
    }

    public void setAmeteAlemEra(boolean bl2) {
        this.eraType = bl2 ? 1 : 0;
    }

    public boolean isAmeteAlemEra() {
        return this.eraType == 1;
    }

    @Override
    @Deprecated
    protected int handleGetExtendedYear() {
        int n2;
        int n3 = this.newerField(19, 1) == 19 ? this.internalGet(19, 1) : (this.isAmeteAlemEra() ? this.internalGet(1, 5501) - 5500 : ((n2 = this.internalGet(0, 1)) == 1 ? this.internalGet(1, 1) : this.internalGet(1, 1) - 5500));
        return n3;
    }

    @Override
    @Deprecated
    protected void handleComputeFields(int n2) {
        int n3;
        int n4;
        int[] nArray = new int[3];
        EthiopicCalendar.jdToCE(n2, this.getJDEpochOffset(), nArray);
        if (this.isAmeteAlemEra()) {
            n4 = 0;
            n3 = nArray[0] + 5500;
        } else if (nArray[0] > 0) {
            n4 = 1;
            n3 = nArray[0];
        } else {
            n4 = 0;
            n3 = nArray[0] + 5500;
        }
        this.internalSet(19, nArray[0]);
        this.internalSet(0, n4);
        this.internalSet(1, n3);
        this.internalSet(2, nArray[1]);
        this.internalSet(23, nArray[1]);
        this.internalSet(5, nArray[2]);
        this.internalSet(6, 30 * nArray[1] + nArray[2]);
    }

    @Override
    @Deprecated
    protected int handleGetLimit(int n2, int n3) {
        if (this.isAmeteAlemEra() && n2 == 0) {
            return 0;
        }
        return super.handleGetLimit(n2, n3);
    }

    @Override
    @Deprecated
    protected int getJDEpochOffset() {
        return 1723856;
    }

    public static int EthiopicToJD(long l2, int n2, int n3) {
        return EthiopicCalendar.ceToJD(l2, n2, n3, 1723856);
    }

    private void setCalcTypeForLocale(ULocale uLocale) {
        String string = CalendarUtil.getCalendarType(uLocale);
        if ("ethiopic-amete-alem".equals(string)) {
            this.setAmeteAlemEra(true);
        } else {
            this.setAmeteAlemEra(false);
        }
    }
}

