/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.util;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUBinary;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Normalizer2Impl;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.CodePointMap;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUUncheckedIOException;

public abstract class CodePointTrie
extends CodePointMap {
    private static final int MAX_UNICODE = 0x10FFFF;
    private static final int ASCII_LIMIT = 128;
    static final int FAST_SHIFT = 6;
    static final int FAST_DATA_BLOCK_LENGTH = 64;
    private static final int FAST_DATA_MASK = 63;
    private static final int SMALL_MAX = 4095;
    private static final int ERROR_VALUE_NEG_DATA_OFFSET = 1;
    private static final int HIGH_VALUE_NEG_DATA_OFFSET = 2;
    private static final int BMP_INDEX_LENGTH = 1024;
    static final int SMALL_LIMIT = 4096;
    private static final int SMALL_INDEX_LENGTH = 64;
    static final int SHIFT_3 = 4;
    private static final int SHIFT_2 = 9;
    private static final int SHIFT_1 = 14;
    static final int SHIFT_2_3 = 5;
    static final int SHIFT_1_2 = 5;
    private static final int OMITTED_BMP_INDEX_1_LENGTH = 4;
    static final int INDEX_2_BLOCK_LENGTH = 32;
    static final int INDEX_2_MASK = 31;
    static final int CP_PER_INDEX_2_ENTRY = 512;
    static final int INDEX_3_BLOCK_LENGTH = 32;
    private static final int INDEX_3_MASK = 31;
    static final int SMALL_DATA_BLOCK_LENGTH = 16;
    static final int SMALL_DATA_MASK = 15;
    private static final int OPTIONS_DATA_LENGTH_MASK = 61440;
    private static final int OPTIONS_DATA_NULL_OFFSET_MASK = 3840;
    private static final int OPTIONS_RESERVED_MASK = 56;
    private static final int OPTIONS_VALUE_BITS_MASK = 7;
    static final int NO_INDEX3_NULL_OFFSET = Short.MAX_VALUE;
    static final int NO_DATA_NULL_OFFSET = 1048575;
    private final int[] ascii = new int[128];
    private final char[] index;
    @Deprecated
    protected final Data data;
    @Deprecated
    protected final int dataLength;
    @Deprecated
    protected final int highStart;
    private final int index3NullOffset;
    private final int dataNullOffset;
    private final int nullValue;

    private CodePointTrie(char[] cArray, Data data, int n2, int n3, int n4) {
        int n5;
        this.index = cArray;
        this.data = data;
        this.dataLength = data.getDataLength();
        this.highStart = n2;
        this.index3NullOffset = n3;
        this.dataNullOffset = n4;
        for (n5 = 0; n5 < 128; ++n5) {
            this.ascii[n5] = data.getFromIndex(n5);
        }
        n5 = n4;
        if (n5 >= this.dataLength) {
            n5 = this.dataLength - 2;
        }
        this.nullValue = data.getFromIndex(n5);
    }

    public static CodePointTrie fromBinary(Type type, ValueWidth valueWidth, ByteBuffer byteBuffer) {
        ByteOrder byteOrder = byteBuffer.order();
        try {
            ValueWidth valueWidth2;
            Type type2;
            char c2;
            if (byteBuffer.remaining() < 16) {
                throw new ICUUncheckedIOException("Buffer too short for a CodePointTrie header");
            }
            int n2 = byteBuffer.getInt();
            switch (n2) {
                case 1416784179: {
                    break;
                }
                case 862548564: {
                    c2 = byteOrder == ByteOrder.BIG_ENDIAN ? (char)'\u0001' : '\u0000';
                    byteBuffer.order(c2 != '\u0000' ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
                    n2 = 1416784179;
                    break;
                }
                default: {
                    throw new ICUUncheckedIOException("Buffer does not contain a serialized CodePointTrie");
                }
            }
            c2 = byteBuffer.getChar();
            char c3 = byteBuffer.getChar();
            int n3 = byteBuffer.getChar();
            char c4 = byteBuffer.getChar();
            int n4 = byteBuffer.getChar();
            char c5 = byteBuffer.getChar();
            int n5 = c2 >> 6 & 3;
            switch (n5) {
                case 0: {
                    type2 = Type.FAST;
                    break;
                }
                case 1: {
                    type2 = Type.SMALL;
                    break;
                }
                default: {
                    throw new ICUUncheckedIOException("CodePointTrie data header has an unsupported type");
                }
            }
            int n6 = c2 & 7;
            switch (n6) {
                case 0: {
                    valueWidth2 = ValueWidth.BITS_16;
                    break;
                }
                case 1: {
                    valueWidth2 = ValueWidth.BITS_32;
                    break;
                }
                case 2: {
                    valueWidth2 = ValueWidth.BITS_8;
                    break;
                }
                default: {
                    throw new ICUUncheckedIOException("CodePointTrie data header has an unsupported value width");
                }
            }
            if ((c2 & 0x38) != 0) {
                throw new ICUUncheckedIOException("CodePointTrie data header has unsupported options");
            }
            if (type == null) {
                type = type2;
            }
            if (valueWidth == null) {
                valueWidth = valueWidth2;
            }
            if (type != type2 || valueWidth != valueWidth2) {
                throw new ICUUncheckedIOException("CodePointTrie data header has a different type or value width than required");
            }
            n4 |= (c2 & 0xF00) << 8;
            int n7 = c5 << 9;
            int n8 = c3 * 2;
            n8 = valueWidth == ValueWidth.BITS_16 ? (n8 += n3 * 2) : (valueWidth == ValueWidth.BITS_32 ? (n8 += n3 * 4) : (n8 += (n3 |= (c2 & 0xF000) << 4)));
            if (byteBuffer.remaining() < n8) {
                throw new ICUUncheckedIOException("Buffer too short for the CodePointTrie data");
            }
            char[] cArray = ICUBinary.getChars(byteBuffer, c3, 0);
            switch (valueWidth) {
                case BITS_16: {
                    char[] cArray2 = ICUBinary.getChars(byteBuffer, n3, 0);
                    CodePointTrie codePointTrie = type == Type.FAST ? new Fast16(cArray, cArray2, n7, (int)c4, n4) : new Small16(cArray, cArray2, n7, (int)c4, n4);
                    return codePointTrie;
                }
                case BITS_32: {
                    int[] nArray = ICUBinary.getInts(byteBuffer, n3, 0);
                    CodePointTrie codePointTrie = type == Type.FAST ? new Fast32(cArray, nArray, n7, (int)c4, n4) : new Small32(cArray, nArray, n7, (int)c4, n4);
                    return codePointTrie;
                }
                case BITS_8: {
                    byte[] byArray = ICUBinary.getBytes(byteBuffer, n3, 0);
                    CodePointTrie codePointTrie = type == Type.FAST ? new Fast8(cArray, byArray, n7, (int)c4, n4) : new Small8(cArray, byArray, n7, (int)c4, n4);
                    return codePointTrie;
                }
            }
            throw new AssertionError((Object)"should be unreachable");
        }
        finally {
            byteBuffer.order(byteOrder);
        }
    }

    public abstract Type getType();

    public final ValueWidth getValueWidth() {
        return this.data.getValueWidth();
    }

    @Override
    public int get(int n2) {
        return this.data.getFromIndex(this.cpIndex(n2));
    }

    public final int asciiGet(int n2) {
        return this.ascii[n2];
    }

    private static final int maybeFilterValue(int n2, int n3, int n4, CodePointMap.ValueFilter valueFilter) {
        if (n2 == n3) {
            n2 = n4;
        } else if (valueFilter != null) {
            n2 = valueFilter.apply(n2);
        }
        return n2;
    }

    @Override
    public final boolean getRange(int n2, CodePointMap.ValueFilter valueFilter, CodePointMap.Range range) {
        int n3;
        int n4;
        if (n2 < 0 || 0x10FFFF < n2) {
            return false;
        }
        if (n2 >= this.highStart) {
            int n5 = this.dataLength - 2;
            int n6 = this.data.getFromIndex(n5);
            if (valueFilter != null) {
                n6 = valueFilter.apply(n6);
            }
            range.set(n2, 0x10FFFF, n6);
            return true;
        }
        int n7 = this.nullValue;
        if (valueFilter != null) {
            n7 = valueFilter.apply(n7);
        }
        Type type = this.getType();
        int n8 = -1;
        int n9 = -1;
        int n10 = n2;
        int n11 = 0;
        int n12 = 0;
        boolean bl2 = false;
        do {
            int n13;
            int n14;
            int n15;
            if (n10 <= 65535 && (type == Type.FAST || n10 <= 4095)) {
                n4 = 0;
                n3 = n10 >> 6;
                n15 = type == Type.FAST ? 1024 : 64;
                n14 = 64;
            } else {
                n13 = n10 >> 14;
                if (type == Type.FAST) {
                    assert (65535 < n10 && n10 < this.highStart);
                    n13 += 1020;
                } else {
                    assert (n10 < this.highStart && this.highStart > 4096);
                    n13 += 64;
                }
                n4 = this.index[this.index[n13] + (n10 >> 9 & 0x1F)];
                if (n4 == n8 && n10 - n2 >= 512) {
                    assert ((n10 & 0x1FF) == 0);
                    n10 += 512;
                    continue;
                }
                n8 = n4;
                if (n4 == this.index3NullOffset) {
                    if (bl2) {
                        if (n7 != n12) {
                            range.set(n2, n10 - 1, n12);
                            return true;
                        }
                    } else {
                        n11 = this.nullValue;
                        n12 = n7;
                        bl2 = true;
                    }
                    n9 = this.dataNullOffset;
                    n10 = n10 + 512 & 0xFFFFFE00;
                    continue;
                }
                n3 = n10 >> 4 & 0x1F;
                n15 = 32;
                n14 = 16;
            }
            do {
                int n16;
                int n17;
                if ((n4 & 0x8000) == 0) {
                    n13 = this.index[n4 + n3];
                } else {
                    n17 = (n4 & Short.MAX_VALUE) + (n3 & 0xFFFFFFF8) + (n3 >> 3);
                    n16 = n3 & 7;
                    n13 = this.index[n17++] << 2 + 2 * n16 & 0x30000;
                    n13 |= this.index[n17 + n16];
                }
                if (n13 == n9 && n10 - n2 >= n14) {
                    assert ((n10 & n14 - 1) == 0);
                    n10 += n14;
                    continue;
                }
                n17 = n14 - 1;
                n9 = n13;
                if (n13 == this.dataNullOffset) {
                    if (bl2) {
                        if (n7 != n12) {
                            range.set(n2, n10 - 1, n12);
                            return true;
                        }
                    } else {
                        n11 = this.nullValue;
                        n12 = n7;
                        bl2 = true;
                    }
                    n10 = n10 + n14 & ~n17;
                    continue;
                }
                n16 = n13 + (n10 & n17);
                int n18 = this.data.getFromIndex(n16);
                if (bl2) {
                    if (n18 != n11) {
                        if (valueFilter == null || CodePointTrie.maybeFilterValue(n18, this.nullValue, n7, valueFilter) != n12) {
                            range.set(n2, n10 - 1, n12);
                            return true;
                        }
                        n11 = n18;
                    }
                } else {
                    n11 = n18;
                    n12 = CodePointTrie.maybeFilterValue(n18, this.nullValue, n7, valueFilter);
                    bl2 = true;
                }
                while ((++n10 & n17) != 0) {
                    if ((n18 = this.data.getFromIndex(++n16)) == n11) continue;
                    if (valueFilter == null || CodePointTrie.maybeFilterValue(n18, this.nullValue, n7, valueFilter) != n12) {
                        range.set(n2, n10 - 1, n12);
                        return true;
                    }
                    n11 = n18;
                }
            } while (++n3 < n15);
        } while (n10 < this.highStart);
        assert (bl2);
        n4 = this.dataLength - 2;
        n3 = this.data.getFromIndex(n4);
        n10 = CodePointTrie.maybeFilterValue(n3, this.nullValue, n7, valueFilter) != n12 ? --n10 : 0x10FFFF;
        range.set(n2, n10, n12);
        return true;
    }

    public final int toBinary(OutputStream outputStream) {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.writeInt(1416784179);
            dataOutputStream.writeChar((this.dataLength & 0xF0000) >> 4 | (this.dataNullOffset & 0xF0000) >> 8 | this.getType().ordinal() << 6 | this.getValueWidth().ordinal());
            dataOutputStream.writeChar(this.index.length);
            dataOutputStream.writeChar(this.dataLength);
            dataOutputStream.writeChar(this.index3NullOffset);
            dataOutputStream.writeChar(this.dataNullOffset);
            dataOutputStream.writeChar(this.highStart >> 9);
            int n2 = 16;
            for (char c2 : this.index) {
                dataOutputStream.writeChar(c2);
            }
            n2 += this.index.length * 2;
            return n2 += this.data.write(dataOutputStream);
        }
        catch (IOException iOException) {
            throw new ICUUncheckedIOException(iOException);
        }
    }

    @Deprecated
    protected final int fastIndex(int n2) {
        return this.index[n2 >> 6] + (n2 & 0x3F);
    }

    @Deprecated
    protected final int smallIndex(Type type, int n2) {
        if (n2 >= this.highStart) {
            return this.dataLength - 2;
        }
        return this.internalSmallIndex(type, n2);
    }

    private final int internalSmallIndex(Type type, int n2) {
        int n3;
        int n4 = n2 >> 14;
        if (type == Type.FAST) {
            assert (65535 < n2 && n2 < this.highStart);
            n4 += 1020;
        } else {
            assert (0 <= n2 && n2 < this.highStart && this.highStart > 4096);
            n4 += 64;
        }
        int n5 = this.index[this.index[n4] + (n2 >> 9 & 0x1F)];
        int n6 = n2 >> 4 & 0x1F;
        if ((n5 & 0x8000) == 0) {
            n3 = this.index[n5 + n6];
        } else {
            n5 = (n5 & Short.MAX_VALUE) + (n6 & 0xFFFFFFF8) + (n6 >> 3);
            n3 = this.index[n5++] << 2 + 2 * (n6 &= 7) & 0x30000;
            n3 |= this.index[n5 + n6];
        }
        return n3 + (n2 & 0xF);
    }

    @Deprecated
    protected abstract int cpIndex(int var1);

    public static final class Small8
    extends Small {
        Small8(char[] cArray, byte[] byArray, int n2, int n3, int n4) {
            super(cArray, new Data8(byArray), n2, n3, n4);
        }

        public static Small8 fromBinary(ByteBuffer byteBuffer) {
            return (Small8)CodePointTrie.fromBinary(Type.SMALL, ValueWidth.BITS_8, byteBuffer);
        }
    }

    public static final class Small32
    extends Small {
        Small32(char[] cArray, int[] nArray, int n2, int n3, int n4) {
            super(cArray, new Data32(nArray), n2, n3, n4);
        }

        public static Small32 fromBinary(ByteBuffer byteBuffer) {
            return (Small32)CodePointTrie.fromBinary(Type.SMALL, ValueWidth.BITS_32, byteBuffer);
        }
    }

    public static final class Small16
    extends Small {
        Small16(char[] cArray, char[] cArray2, int n2, int n3, int n4) {
            super(cArray, new Data16(cArray2), n2, n3, n4);
        }

        public static Small16 fromBinary(ByteBuffer byteBuffer) {
            return (Small16)CodePointTrie.fromBinary(Type.SMALL, ValueWidth.BITS_16, byteBuffer);
        }
    }

    public static final class Fast8
    extends Fast {
        private final byte[] dataArray;

        Fast8(char[] cArray, byte[] byArray, int n2, int n3, int n4) {
            super(cArray, new Data8(byArray), n2, n3, n4);
            this.dataArray = byArray;
        }

        public static Fast8 fromBinary(ByteBuffer byteBuffer) {
            return (Fast8)CodePointTrie.fromBinary(Type.FAST, ValueWidth.BITS_8, byteBuffer);
        }

        @Override
        public final int get(int n2) {
            return this.dataArray[this.cpIndex(n2)] & 0xFF;
        }

        @Override
        public final int bmpGet(int n2) {
            assert (0 <= n2 && n2 <= 65535);
            return this.dataArray[this.fastIndex(n2)] & 0xFF;
        }

        @Override
        public final int suppGet(int n2) {
            assert (65536 <= n2 && n2 <= 0x10FFFF);
            return this.dataArray[this.smallIndex(Type.FAST, n2)] & 0xFF;
        }
    }

    public static final class Fast32
    extends Fast {
        private final int[] dataArray;

        Fast32(char[] cArray, int[] nArray, int n2, int n3, int n4) {
            super(cArray, new Data32(nArray), n2, n3, n4);
            this.dataArray = nArray;
        }

        public static Fast32 fromBinary(ByteBuffer byteBuffer) {
            return (Fast32)CodePointTrie.fromBinary(Type.FAST, ValueWidth.BITS_32, byteBuffer);
        }

        @Override
        public final int get(int n2) {
            return this.dataArray[this.cpIndex(n2)];
        }

        @Override
        public final int bmpGet(int n2) {
            assert (0 <= n2 && n2 <= 65535);
            return this.dataArray[this.fastIndex(n2)];
        }

        @Override
        public final int suppGet(int n2) {
            assert (65536 <= n2 && n2 <= 0x10FFFF);
            return this.dataArray[this.smallIndex(Type.FAST, n2)];
        }
    }

    public static final class Fast16
    extends Fast {
        private final char[] dataArray;

        Fast16(char[] cArray, char[] cArray2, int n2, int n3, int n4) {
            super(cArray, new Data16(cArray2), n2, n3, n4);
            this.dataArray = cArray2;
        }

        public static Fast16 fromBinary(ByteBuffer byteBuffer) {
            return (Fast16)CodePointTrie.fromBinary(Type.FAST, ValueWidth.BITS_16, byteBuffer);
        }

        @Override
        public final int get(int n2) {
            return this.dataArray[this.cpIndex(n2)];
        }

        @Override
        public final int bmpGet(int n2) {
            assert (0 <= n2 && n2 <= 65535);
            return this.dataArray[this.fastIndex(n2)];
        }

        @Override
        public final int suppGet(int n2) {
            assert (65536 <= n2 && n2 <= 0x10FFFF);
            return this.dataArray[this.smallIndex(Type.FAST, n2)];
        }
    }

    public static abstract class Small
    extends CodePointTrie {
        private Small(char[] cArray, Data data, int n2, int n3, int n4) {
            super(cArray, data, n2, n3, n4);
        }

        public static Small fromBinary(ValueWidth valueWidth, ByteBuffer byteBuffer) {
            return (Small)CodePointTrie.fromBinary(Type.SMALL, valueWidth, byteBuffer);
        }

        @Override
        public final Type getType() {
            return Type.SMALL;
        }

        @Override
        @Deprecated
        protected final int cpIndex(int n2) {
            if (n2 >= 0) {
                if (n2 <= 4095) {
                    return this.fastIndex(n2);
                }
                if (n2 <= 0x10FFFF) {
                    return this.smallIndex(Type.SMALL, n2);
                }
            }
            return this.dataLength - 1;
        }

        @Override
        public final CodePointMap.StringIterator stringIterator(CharSequence charSequence, int n2) {
            return new SmallStringIterator(charSequence, n2);
        }

        private final class SmallStringIterator
        extends CodePointMap.StringIterator {
            private SmallStringIterator(CharSequence charSequence, int n2) {
                super(charSequence, n2);
            }

            @Override
            public boolean next() {
                char c2;
                int n2;
                if (this.sIndex >= this.s.length()) {
                    return false;
                }
                char c3 = this.s.charAt(this.sIndex++);
                this.c = c3;
                if (!Character.isSurrogate(c3)) {
                    n2 = Small.this.cpIndex(this.c);
                } else if (Normalizer2Impl.UTF16Plus.isSurrogateLead(c3) && this.sIndex < this.s.length() && Character.isLowSurrogate(c2 = this.s.charAt(this.sIndex))) {
                    ++this.sIndex;
                    this.c = Character.toCodePoint(c3, c2);
                    n2 = Small.this.smallIndex(Type.SMALL, this.c);
                } else {
                    n2 = Small.this.dataLength - 1;
                }
                this.value = Small.this.data.getFromIndex(n2);
                return true;
            }

            @Override
            public boolean previous() {
                char c2;
                int n2;
                if (this.sIndex <= 0) {
                    return false;
                }
                char c3 = this.s.charAt(--this.sIndex);
                this.c = c3;
                if (!Character.isSurrogate(c3)) {
                    n2 = Small.this.cpIndex(this.c);
                } else if (!Normalizer2Impl.UTF16Plus.isSurrogateLead(c3) && this.sIndex > 0 && Character.isHighSurrogate(c2 = this.s.charAt(this.sIndex - 1))) {
                    --this.sIndex;
                    this.c = Character.toCodePoint(c2, c3);
                    n2 = Small.this.smallIndex(Type.SMALL, this.c);
                } else {
                    n2 = Small.this.dataLength - 1;
                }
                this.value = Small.this.data.getFromIndex(n2);
                return true;
            }
        }
    }

    public static abstract class Fast
    extends CodePointTrie {
        private Fast(char[] cArray, Data data, int n2, int n3, int n4) {
            super(cArray, data, n2, n3, n4);
        }

        public static Fast fromBinary(ValueWidth valueWidth, ByteBuffer byteBuffer) {
            return (Fast)CodePointTrie.fromBinary(Type.FAST, valueWidth, byteBuffer);
        }

        @Override
        public final Type getType() {
            return Type.FAST;
        }

        public abstract int bmpGet(int var1);

        public abstract int suppGet(int var1);

        @Override
        @Deprecated
        protected final int cpIndex(int n2) {
            if (n2 >= 0) {
                if (n2 <= 65535) {
                    return this.fastIndex(n2);
                }
                if (n2 <= 0x10FFFF) {
                    return this.smallIndex(Type.FAST, n2);
                }
            }
            return this.dataLength - 1;
        }

        @Override
        public final CodePointMap.StringIterator stringIterator(CharSequence charSequence, int n2) {
            return new FastStringIterator(charSequence, n2);
        }

        private final class FastStringIterator
        extends CodePointMap.StringIterator {
            private FastStringIterator(CharSequence charSequence, int n2) {
                super(charSequence, n2);
            }

            @Override
            public boolean next() {
                char c2;
                int n2;
                if (this.sIndex >= this.s.length()) {
                    return false;
                }
                char c3 = this.s.charAt(this.sIndex++);
                this.c = c3;
                if (!Character.isSurrogate(c3)) {
                    n2 = Fast.this.fastIndex(this.c);
                } else if (Normalizer2Impl.UTF16Plus.isSurrogateLead(c3) && this.sIndex < this.s.length() && Character.isLowSurrogate(c2 = this.s.charAt(this.sIndex))) {
                    ++this.sIndex;
                    this.c = Character.toCodePoint(c3, c2);
                    n2 = Fast.this.smallIndex(Type.FAST, this.c);
                } else {
                    n2 = Fast.this.dataLength - 1;
                }
                this.value = Fast.this.data.getFromIndex(n2);
                return true;
            }

            @Override
            public boolean previous() {
                char c2;
                int n2;
                if (this.sIndex <= 0) {
                    return false;
                }
                char c3 = this.s.charAt(--this.sIndex);
                this.c = c3;
                if (!Character.isSurrogate(c3)) {
                    n2 = Fast.this.fastIndex(this.c);
                } else if (!Normalizer2Impl.UTF16Plus.isSurrogateLead(c3) && this.sIndex > 0 && Character.isHighSurrogate(c2 = this.s.charAt(this.sIndex - 1))) {
                    --this.sIndex;
                    this.c = Character.toCodePoint(c2, c3);
                    n2 = Fast.this.smallIndex(Type.FAST, this.c);
                } else {
                    n2 = Fast.this.dataLength - 1;
                }
                this.value = Fast.this.data.getFromIndex(n2);
                return true;
            }
        }
    }

    private static final class Data8
    extends Data {
        byte[] array;

        Data8(byte[] byArray) {
            this.array = byArray;
        }

        @Override
        ValueWidth getValueWidth() {
            return ValueWidth.BITS_8;
        }

        @Override
        int getDataLength() {
            return this.array.length;
        }

        @Override
        int getFromIndex(int n2) {
            return this.array[n2] & 0xFF;
        }

        @Override
        int write(DataOutputStream dataOutputStream) throws IOException {
            for (byte by2 : this.array) {
                dataOutputStream.writeByte(by2);
            }
            return this.array.length;
        }
    }

    private static final class Data32
    extends Data {
        int[] array;

        Data32(int[] nArray) {
            this.array = nArray;
        }

        @Override
        ValueWidth getValueWidth() {
            return ValueWidth.BITS_32;
        }

        @Override
        int getDataLength() {
            return this.array.length;
        }

        @Override
        int getFromIndex(int n2) {
            return this.array[n2];
        }

        @Override
        int write(DataOutputStream dataOutputStream) throws IOException {
            for (int n2 : this.array) {
                dataOutputStream.writeInt(n2);
            }
            return this.array.length * 4;
        }
    }

    private static final class Data16
    extends Data {
        char[] array;

        Data16(char[] cArray) {
            this.array = cArray;
        }

        @Override
        ValueWidth getValueWidth() {
            return ValueWidth.BITS_16;
        }

        @Override
        int getDataLength() {
            return this.array.length;
        }

        @Override
        int getFromIndex(int n2) {
            return this.array[n2];
        }

        @Override
        int write(DataOutputStream dataOutputStream) throws IOException {
            for (char c2 : this.array) {
                dataOutputStream.writeChar(c2);
            }
            return this.array.length * 2;
        }
    }

    private static abstract class Data {
        private Data() {
        }

        abstract ValueWidth getValueWidth();

        abstract int getDataLength();

        abstract int getFromIndex(int var1);

        abstract int write(DataOutputStream var1) throws IOException;
    }

    public static enum ValueWidth {
        BITS_16,
        BITS_32,
        BITS_8;

    }

    public static enum Type {
        FAST,
        SMALL;

    }
}

