/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUUncheckedIOException;

public final class BytesTrie
implements Cloneable,
Iterable<Entry> {
    private static Result[] valueResults_ = new Result[]{Result.INTERMEDIATE_VALUE, Result.FINAL_VALUE};
    static final int kMaxBranchLinearSubNodeLength = 5;
    static final int kMinLinearMatch = 16;
    static final int kMaxLinearMatchLength = 16;
    static final int kMinValueLead = 32;
    private static final int kValueIsFinal = 1;
    static final int kMinOneByteValueLead = 16;
    static final int kMaxOneByteValue = 64;
    static final int kMinTwoByteValueLead = 81;
    static final int kMaxTwoByteValue = 6911;
    static final int kMinThreeByteValueLead = 108;
    static final int kFourByteValueLead = 126;
    static final int kMaxThreeByteValue = 0x11FFFF;
    static final int kFiveByteValueLead = 127;
    static final int kMaxOneByteDelta = 191;
    static final int kMinTwoByteDeltaLead = 192;
    static final int kMinThreeByteDeltaLead = 240;
    static final int kFourByteDeltaLead = 254;
    static final int kFiveByteDeltaLead = 255;
    static final int kMaxTwoByteDelta = 12287;
    static final int kMaxThreeByteDelta = 917503;
    private byte[] bytes_;
    private int root_;
    private int pos_;
    private int remainingMatchLength_;

    public BytesTrie(byte[] byArray, int n2) {
        this.bytes_ = byArray;
        this.pos_ = this.root_ = n2;
        this.remainingMatchLength_ = -1;
    }

    public BytesTrie(BytesTrie bytesTrie) {
        this.bytes_ = bytesTrie.bytes_;
        this.root_ = bytesTrie.root_;
        this.pos_ = bytesTrie.pos_;
        this.remainingMatchLength_ = bytesTrie.remainingMatchLength_;
    }

    public BytesTrie clone() throws CloneNotSupportedException {
        return (BytesTrie)super.clone();
    }

    public BytesTrie reset() {
        this.pos_ = this.root_;
        this.remainingMatchLength_ = -1;
        return this;
    }

    public long getState64() {
        return (long)this.remainingMatchLength_ << 32 | (long)this.pos_;
    }

    public BytesTrie resetToState64(long l2) {
        this.remainingMatchLength_ = (int)(l2 >> 32);
        this.pos_ = (int)l2;
        return this;
    }

    public BytesTrie saveState(State state) {
        State.access$002(state, this.bytes_);
        state.root = this.root_;
        state.pos = this.pos_;
        state.remainingMatchLength = this.remainingMatchLength_;
        return this;
    }

    public BytesTrie resetToState(State state) {
        if (this.bytes_ != state.bytes || this.bytes_ == null || this.root_ != state.root) {
            throw new IllegalArgumentException("incompatible trie state");
        }
        this.pos_ = state.pos;
        this.remainingMatchLength_ = state.remainingMatchLength;
        return this;
    }

    public Result current() {
        int n2;
        int n3 = this.pos_;
        if (n3 < 0) {
            return Result.NO_MATCH;
        }
        return this.remainingMatchLength_ < 0 && (n2 = this.bytes_[n3] & 0xFF) >= 32 ? valueResults_[n2 & 1] : Result.NO_VALUE;
    }

    public Result first(int n2) {
        this.remainingMatchLength_ = -1;
        if (n2 < 0) {
            n2 += 256;
        }
        return this.nextImpl(this.root_, n2);
    }

    public Result next(int n2) {
        int n3;
        int n4 = this.pos_;
        if (n4 < 0) {
            return Result.NO_MATCH;
        }
        if (n2 < 0) {
            n2 += 256;
        }
        if ((n3 = this.remainingMatchLength_) >= 0) {
            if (n2 == (this.bytes_[n4++] & 0xFF)) {
                int n5;
                this.remainingMatchLength_ = --n3;
                this.pos_ = n4;
                return n3 < 0 && (n5 = this.bytes_[n4] & 0xFF) >= 32 ? valueResults_[n5 & 1] : Result.NO_VALUE;
            }
            this.stop();
            return Result.NO_MATCH;
        }
        return this.nextImpl(n4, n2);
    }

    public Result next(byte[] byArray, int n2, int n3) {
        if (n2 >= n3) {
            return this.current();
        }
        int n4 = this.pos_;
        if (n4 < 0) {
            return Result.NO_MATCH;
        }
        int n5 = this.remainingMatchLength_;
        block0: while (true) {
            int n6;
            if (n2 == n3) {
                this.remainingMatchLength_ = n5;
                this.pos_ = n4;
                return n5 < 0 && (n6 = this.bytes_[n4] & 0xFF) >= 32 ? valueResults_[n6 & 1] : Result.NO_VALUE;
            }
            byte by2 = byArray[n2++];
            if (n5 >= 0) {
                if (by2 != this.bytes_[n4]) {
                    this.stop();
                    return Result.NO_MATCH;
                }
                ++n4;
                --n5;
                continue;
            }
            this.remainingMatchLength_ = n5;
            while (true) {
                if ((n6 = this.bytes_[n4++] & 0xFF) < 16) {
                    Result result = this.branchNext(n4, n6, by2 & 0xFF);
                    if (result == Result.NO_MATCH) {
                        return Result.NO_MATCH;
                    }
                    if (n2 == n3) {
                        return result;
                    }
                    if (result == Result.FINAL_VALUE) {
                        this.stop();
                        return Result.NO_MATCH;
                    }
                    by2 = byArray[n2++];
                    n4 = this.pos_;
                    continue;
                }
                if (n6 < 32) {
                    n5 = n6 - 16;
                    if (by2 != this.bytes_[n4]) {
                        this.stop();
                        return Result.NO_MATCH;
                    }
                    ++n4;
                    --n5;
                    continue block0;
                }
                if ((n6 & 1) != 0) {
                    this.stop();
                    return Result.NO_MATCH;
                }
                n4 = BytesTrie.skipValue(n4, n6);
                if (!$assertionsDisabled && (this.bytes_[n4] & 0xFF) >= 32) break block0;
            }
            break;
        }
        throw new AssertionError();
    }

    public int getValue() {
        int n2 = this.pos_;
        int n3 = this.bytes_[n2++] & 0xFF;
        assert (n3 >= 32);
        return BytesTrie.readValue(this.bytes_, n2, n3 >> 1);
    }

    public long getUniqueValue() {
        int n2 = this.pos_;
        if (n2 < 0) {
            return 0L;
        }
        long l2 = BytesTrie.findUniqueValue(this.bytes_, n2 + this.remainingMatchLength_ + 1, 0L);
        return l2 << 31 >> 31;
    }

    public int getNextBytes(Appendable appendable) {
        int n2;
        int n3 = this.pos_;
        if (n3 < 0) {
            return 0;
        }
        if (this.remainingMatchLength_ >= 0) {
            BytesTrie.append(appendable, this.bytes_[n3] & 0xFF);
            return 1;
        }
        if ((n2 = this.bytes_[n3++] & 0xFF) >= 32) {
            if ((n2 & 1) != 0) {
                return 0;
            }
            n3 = BytesTrie.skipValue(n3, n2);
            n2 = this.bytes_[n3++] & 0xFF;
            assert (n2 < 32);
        }
        if (n2 < 16) {
            if (n2 == 0) {
                n2 = this.bytes_[n3++] & 0xFF;
            }
            BytesTrie.getNextBranchBytes(this.bytes_, n3, ++n2, appendable);
            return n2;
        }
        BytesTrie.append(appendable, this.bytes_[n3] & 0xFF);
        return 1;
    }

    public Iterator iterator() {
        return new Iterator(this.bytes_, this.pos_, this.remainingMatchLength_, 0);
    }

    public Iterator iterator(int n2) {
        return new Iterator(this.bytes_, this.pos_, this.remainingMatchLength_, n2);
    }

    public static Iterator iterator(byte[] byArray, int n2, int n3) {
        return new Iterator(byArray, n2, -1, n3);
    }

    private void stop() {
        this.pos_ = -1;
    }

    private static int readValue(byte[] byArray, int n2, int n3) {
        int n4 = n3 < 81 ? n3 - 16 : (n3 < 108 ? n3 - 81 << 8 | byArray[n2] & 0xFF : (n3 < 126 ? n3 - 108 << 16 | (byArray[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF : (n3 == 126 ? (byArray[n2] & 0xFF) << 16 | (byArray[n2 + 1] & 0xFF) << 8 | byArray[n2 + 2] & 0xFF : byArray[n2] << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF)));
        return n4;
    }

    private static int skipValue(int n2, int n3) {
        assert (n3 >= 32);
        if (n3 >= 162) {
            n2 = n3 < 216 ? ++n2 : (n3 < 252 ? (n2 += 2) : (n2 += 3 + (n3 >> 1 & 1)));
        }
        return n2;
    }

    private static int skipValue(byte[] byArray, int n2) {
        int n3 = byArray[n2++] & 0xFF;
        return BytesTrie.skipValue(n2, n3);
    }

    @Deprecated
    public static int jumpByDelta(byte[] byArray, int n2) {
        int n3;
        if ((n3 = byArray[n2++] & 0xFF) >= 192) {
            if (n3 < 240) {
                n3 = n3 - 192 << 8 | byArray[n2++] & 0xFF;
            } else if (n3 < 254) {
                n3 = n3 - 240 << 16 | (byArray[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF;
                n2 += 2;
            } else if (n3 == 254) {
                n3 = (byArray[n2] & 0xFF) << 16 | (byArray[n2 + 1] & 0xFF) << 8 | byArray[n2 + 2] & 0xFF;
                n2 += 3;
            } else {
                n3 = byArray[n2] << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
                n2 += 4;
            }
        }
        return n2 + n3;
    }

    private static int skipDelta(byte[] byArray, int n2) {
        int n3;
        if ((n3 = byArray[n2++] & 0xFF) >= 192) {
            n2 = n3 < 240 ? ++n2 : (n3 < 254 ? (n2 += 2) : (n2 += 3 + (n3 & 1)));
        }
        return n2;
    }

    private Result branchNext(int n2, int n3, int n4) {
        if (n3 == 0) {
            n3 = this.bytes_[n2++] & 0xFF;
        }
        ++n3;
        while (n3 > 5) {
            if (n4 < (this.bytes_[n2++] & 0xFF)) {
                n3 >>= 1;
                n2 = BytesTrie.jumpByDelta(this.bytes_, n2);
                continue;
            }
            n3 -= n3 >> 1;
            n2 = BytesTrie.skipDelta(this.bytes_, n2);
        }
        do {
            if (n4 == (this.bytes_[n2++] & 0xFF)) {
                Result result;
                int n5 = this.bytes_[n2] & 0xFF;
                assert (n5 >= 32);
                if ((n5 & 1) != 0) {
                    result = Result.FINAL_VALUE;
                } else {
                    int n6;
                    ++n2;
                    if ((n5 >>= 1) < 81) {
                        n6 = n5 - 16;
                    } else if (n5 < 108) {
                        n6 = n5 - 81 << 8 | this.bytes_[n2++] & 0xFF;
                    } else if (n5 < 126) {
                        n6 = n5 - 108 << 16 | (this.bytes_[n2] & 0xFF) << 8 | this.bytes_[n2 + 1] & 0xFF;
                        n2 += 2;
                    } else if (n5 == 126) {
                        n6 = (this.bytes_[n2] & 0xFF) << 16 | (this.bytes_[n2 + 1] & 0xFF) << 8 | this.bytes_[n2 + 2] & 0xFF;
                        n2 += 3;
                    } else {
                        n6 = this.bytes_[n2] << 24 | (this.bytes_[n2 + 1] & 0xFF) << 16 | (this.bytes_[n2 + 2] & 0xFF) << 8 | this.bytes_[n2 + 3] & 0xFF;
                        n2 += 4;
                    }
                    n5 = this.bytes_[n2 += n6] & 0xFF;
                    result = n5 >= 32 ? valueResults_[n5 & 1] : Result.NO_VALUE;
                }
                this.pos_ = n2;
                return result;
            }
            n2 = BytesTrie.skipValue(this.bytes_, n2);
        } while (--n3 > 1);
        if (n4 == (this.bytes_[n2++] & 0xFF)) {
            this.pos_ = n2;
            int n7 = this.bytes_[n2] & 0xFF;
            return n7 >= 32 ? valueResults_[n7 & 1] : Result.NO_VALUE;
        }
        this.stop();
        return Result.NO_MATCH;
    }

    private Result nextImpl(int n2, int n3) {
        block4: {
            while (true) {
                int n4;
                if ((n4 = this.bytes_[n2++] & 0xFF) < 16) {
                    return this.branchNext(n2, n4, n3);
                }
                if (n4 < 32) {
                    int n5 = n4 - 16;
                    if (n3 == (this.bytes_[n2++] & 0xFF)) {
                        this.remainingMatchLength_ = --n5;
                        this.pos_ = n2;
                        return n5 < 0 && (n4 = this.bytes_[n2] & 0xFF) >= 32 ? valueResults_[n4 & 1] : Result.NO_VALUE;
                    }
                    break block4;
                }
                if ((n4 & 1) != 0) break block4;
                n2 = BytesTrie.skipValue(n2, n4);
                assert ((this.bytes_[n2] & 0xFF) < 32);
            }
        }
        this.stop();
        return Result.NO_MATCH;
    }

    private static long findUniqueValueFromBranch(byte[] byArray, int n2, int n3, long l2) {
        while (n3 > 5) {
            if ((l2 = BytesTrie.findUniqueValueFromBranch(byArray, BytesTrie.jumpByDelta(byArray, ++n2), n3 >> 1, l2)) == 0L) {
                return 0L;
            }
            n3 -= n3 >> 1;
            n2 = BytesTrie.skipDelta(byArray, n2);
        }
        do {
            int n4 = ++n2;
            int n5 = byArray[n4] & 0xFF;
            boolean bl2 = (n5 & 1) != 0;
            int n6 = BytesTrie.readValue(byArray, ++n2, n5 >> 1);
            n2 = BytesTrie.skipValue(n2, n5);
            if (bl2) {
                if (l2 != 0L) {
                    if (n6 == (int)(l2 >> 1)) continue;
                    return 0L;
                }
                l2 = (long)n6 << 1 | 1L;
                continue;
            }
            if ((l2 = BytesTrie.findUniqueValue(byArray, n2 + n6, l2)) != 0L) continue;
            return 0L;
        } while (--n3 > 1);
        return (long)(n2 + 1) << 33 | l2 & 0x1FFFFFFFFL;
    }

    private static long findUniqueValue(byte[] byArray, int n2, long l2) {
        while (true) {
            int n3;
            if ((n3 = byArray[n2++] & 0xFF) < 16) {
                if (n3 == 0) {
                    n3 = byArray[n2++] & 0xFF;
                }
                if ((l2 = BytesTrie.findUniqueValueFromBranch(byArray, n2, n3 + 1, l2)) == 0L) {
                    return 0L;
                }
                n2 = (int)(l2 >>> 33);
                continue;
            }
            if (n3 < 32) {
                n2 += n3 - 16 + 1;
                continue;
            }
            boolean bl2 = (n3 & 1) != 0;
            int n4 = BytesTrie.readValue(byArray, n2, n3 >> 1);
            if (l2 != 0L) {
                if (n4 != (int)(l2 >> 1)) {
                    return 0L;
                }
            } else {
                l2 = (long)n4 << 1 | 1L;
            }
            if (bl2) {
                return l2;
            }
            n2 = BytesTrie.skipValue(n2, n3);
        }
    }

    private static void getNextBranchBytes(byte[] byArray, int n2, int n3, Appendable appendable) {
        while (n3 > 5) {
            BytesTrie.getNextBranchBytes(byArray, BytesTrie.jumpByDelta(byArray, ++n2), n3 >> 1, appendable);
            n3 -= n3 >> 1;
            n2 = BytesTrie.skipDelta(byArray, n2);
        }
        do {
            BytesTrie.append(appendable, byArray[n2++] & 0xFF);
            n2 = BytesTrie.skipValue(byArray, n2);
        } while (--n3 > 1);
        BytesTrie.append(appendable, byArray[n2] & 0xFF);
    }

    private static void append(Appendable appendable, int n2) {
        try {
            appendable.append((char)n2);
        }
        catch (IOException iOException) {
            throw new ICUUncheckedIOException(iOException);
        }
    }

    public static final class Iterator
    implements java.util.Iterator<Entry> {
        private byte[] bytes_;
        private int pos_;
        private int initialPos_;
        private int remainingMatchLength_;
        private int initialRemainingMatchLength_;
        private int maxLength_;
        private Entry entry_;
        private ArrayList<Long> stack_ = new ArrayList();

        private Iterator(byte[] byArray, int n2, int n3, int n4) {
            this.bytes_ = byArray;
            this.pos_ = this.initialPos_ = n2;
            this.remainingMatchLength_ = this.initialRemainingMatchLength_ = n3;
            this.maxLength_ = n4;
            this.entry_ = new Entry(this.maxLength_ != 0 ? this.maxLength_ : 32);
            int n5 = this.remainingMatchLength_;
            if (n5 >= 0) {
                if (this.maxLength_ > 0 && ++n5 > this.maxLength_) {
                    n5 = this.maxLength_;
                }
                this.entry_.append(this.bytes_, this.pos_, n5);
                this.pos_ += n5;
                this.remainingMatchLength_ -= n5;
            }
        }

        public Iterator reset() {
            this.pos_ = this.initialPos_;
            this.remainingMatchLength_ = this.initialRemainingMatchLength_;
            int n2 = this.remainingMatchLength_ + 1;
            if (this.maxLength_ > 0 && n2 > this.maxLength_) {
                n2 = this.maxLength_;
            }
            this.entry_.truncateString(n2);
            this.pos_ += n2;
            this.remainingMatchLength_ -= n2;
            this.stack_.clear();
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.pos_ >= 0 || !this.stack_.isEmpty();
        }

        @Override
        public Entry next() {
            int n2 = this.pos_;
            if (n2 < 0) {
                if (this.stack_.isEmpty()) {
                    throw new NoSuchElementException();
                }
                long l2 = this.stack_.remove(this.stack_.size() - 1);
                int n3 = (int)l2;
                n2 = (int)(l2 >> 32);
                this.entry_.truncateString(n3 & 0xFFFF);
                if ((n3 >>>= 16) > 1) {
                    if ((n2 = this.branchNext(n2, n3)) < 0) {
                        return this.entry_;
                    }
                } else {
                    this.entry_.append(this.bytes_[n2++]);
                }
            }
            if (this.remainingMatchLength_ >= 0) {
                return this.truncateAndStop();
            }
            while (true) {
                int n4;
                int n5;
                if ((n5 = this.bytes_[n2++] & 0xFF) >= 32) {
                    n4 = (n5 & 1) != 0 ? 1 : 0;
                    this.entry_.value = BytesTrie.readValue(this.bytes_, n2, n5 >> 1);
                    this.pos_ = n4 != 0 || this.maxLength_ > 0 && this.entry_.length == this.maxLength_ ? -1 : BytesTrie.skipValue(n2, n5);
                    return this.entry_;
                }
                if (this.maxLength_ > 0 && this.entry_.length == this.maxLength_) {
                    return this.truncateAndStop();
                }
                if (n5 < 16) {
                    if (n5 == 0) {
                        n5 = this.bytes_[n2++] & 0xFF;
                    }
                    if ((n2 = this.branchNext(n2, n5 + 1)) >= 0) continue;
                    return this.entry_;
                }
                n4 = n5 - 16 + 1;
                if (this.maxLength_ > 0 && this.entry_.length + n4 > this.maxLength_) {
                    this.entry_.append(this.bytes_, n2, this.maxLength_ - this.entry_.length);
                    return this.truncateAndStop();
                }
                this.entry_.append(this.bytes_, n2, n4);
                n2 += n4;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Entry truncateAndStop() {
            this.pos_ = -1;
            this.entry_.value = -1;
            return this.entry_;
        }

        private int branchNext(int n2, int n3) {
            int n4;
            while (n3 > 5) {
                this.stack_.add((long)BytesTrie.skipDelta(this.bytes_, ++n2) << 32 | (long)(n3 - (n3 >> 1) << 16) | (long)this.entry_.length);
                n3 >>= 1;
                n2 = BytesTrie.jumpByDelta(this.bytes_, n2);
            }
            byte by2 = this.bytes_[n2++];
            boolean bl2 = ((n4 = this.bytes_[n2++] & 0xFF) & 1) != 0;
            int n5 = BytesTrie.readValue(this.bytes_, n2, n4 >> 1);
            n2 = BytesTrie.skipValue(n2, n4);
            this.stack_.add((long)n2 << 32 | (long)(n3 - 1 << 16) | (long)this.entry_.length);
            this.entry_.append(by2);
            if (bl2) {
                this.pos_ = -1;
                this.entry_.value = n5;
                return -1;
            }
            return n2 + n5;
        }
    }

    public static final class Entry {
        public int value;
        private byte[] bytes;
        private int length;

        private Entry(int n2) {
            this.bytes = new byte[n2];
        }

        public int bytesLength() {
            return this.length;
        }

        public byte byteAt(int n2) {
            return this.bytes[n2];
        }

        public void copyBytesTo(byte[] byArray, int n2) {
            System.arraycopy(this.bytes, 0, byArray, n2, this.length);
        }

        public ByteBuffer bytesAsByteBuffer() {
            return ByteBuffer.wrap(this.bytes, 0, this.length).asReadOnlyBuffer();
        }

        private void ensureCapacity(int n2) {
            if (this.bytes.length < n2) {
                byte[] byArray = new byte[Math.min(2 * this.bytes.length, 2 * n2)];
                System.arraycopy(this.bytes, 0, byArray, 0, this.length);
                this.bytes = byArray;
            }
        }

        private void append(byte by2) {
            this.ensureCapacity(this.length + 1);
            this.bytes[this.length++] = by2;
        }

        private void append(byte[] byArray, int n2, int n3) {
            this.ensureCapacity(this.length + n3);
            System.arraycopy(byArray, n2, this.bytes, this.length, n3);
            this.length += n3;
        }

        private void truncateString(int n2) {
            this.length = n2;
        }
    }

    public static enum Result {
        NO_MATCH,
        NO_VALUE,
        FINAL_VALUE,
        INTERMEDIATE_VALUE;


        public boolean matches() {
            return this != NO_MATCH;
        }

        public boolean hasValue() {
            return this.ordinal() >= 2;
        }

        public boolean hasNext() {
            return (this.ordinal() & 1) != 0;
        }
    }

    public static final class State {
        private byte[] bytes;
        private int root;
        private int pos;
        private int remainingMatchLength;

        static /* synthetic */ byte[] access$002(State state, byte[] byArray) {
            state.bytes = byArray;
            return byArray;
        }
    }
}

