/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.util.ArrayList;
import java.util.List;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Replaceable;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.TransliterationRule;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Transliterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

class TransliterationRuleSet {
    private List<TransliterationRule> ruleVector = new ArrayList<TransliterationRule>();
    private int maxContextLength = 0;
    private TransliterationRule[] rules;
    private int[] index;

    public int getMaximumContextLength() {
        return this.maxContextLength;
    }

    public void addRule(TransliterationRule transliterationRule) {
        this.ruleVector.add(transliterationRule);
        int n2 = transliterationRule.getAnteContextLength();
        if (n2 > this.maxContextLength) {
            this.maxContextLength = n2;
        }
        this.rules = null;
    }

    public void freeze() {
        int n2;
        int n3 = this.ruleVector.size();
        this.index = new int[257];
        ArrayList<TransliterationRule> arrayList = new ArrayList<TransliterationRule>(2 * n3);
        int[] nArray = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            TransliterationRule transliterationRule = this.ruleVector.get(n2);
            nArray[n2] = transliterationRule.getIndexValue();
        }
        for (n2 = 0; n2 < 256; ++n2) {
            this.index[n2] = arrayList.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                if (nArray[i2] >= 0) {
                    if (nArray[i2] != n2) continue;
                    arrayList.add(this.ruleVector.get(i2));
                    continue;
                }
                TransliterationRule transliterationRule = this.ruleVector.get(i2);
                if (!transliterationRule.matchesIndexValue(n2)) continue;
                arrayList.add(transliterationRule);
            }
        }
        this.index[256] = arrayList.size();
        this.rules = new TransliterationRule[arrayList.size()];
        arrayList.toArray(this.rules);
        StringBuilder stringBuilder = null;
        for (int i3 = 0; i3 < 256; ++i3) {
            for (int i4 = this.index[i3]; i4 < this.index[i3 + 1] - 1; ++i4) {
                TransliterationRule transliterationRule = this.rules[i4];
                for (int i5 = i4 + 1; i5 < this.index[i3 + 1]; ++i5) {
                    TransliterationRule transliterationRule2 = this.rules[i5];
                    if (!transliterationRule.masks(transliterationRule2)) continue;
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder();
                    } else {
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append("Rule " + transliterationRule + " masks " + transliterationRule2);
                }
            }
        }
        if (stringBuilder != null) {
            throw new IllegalArgumentException(stringBuilder.toString());
        }
    }

    public boolean transliterate(Replaceable replaceable, Transliterator.Position position, boolean bl2) {
        int n2 = replaceable.char32At(position.start) & 0xFF;
        for (int i2 = this.index[n2]; i2 < this.index[n2 + 1]; ++i2) {
            int n3 = this.rules[i2].matchAndReplace(replaceable, position, bl2);
            switch (n3) {
                case 2: {
                    return true;
                }
                case 1: {
                    return false;
                }
            }
        }
        position.start += UTF16.getCharCount(replaceable.char32At(position.start));
        return true;
    }

    String toRules(boolean bl2) {
        int n2 = this.ruleVector.size();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 != 0) {
                stringBuilder.append('\n');
            }
            TransliterationRule transliterationRule = this.ruleVector.get(i2);
            stringBuilder.append(transliterationRule.toRule(bl2));
        }
        return stringBuilder.toString();
    }

    void addSourceTargetSet(UnicodeSet unicodeSet, UnicodeSet unicodeSet2, UnicodeSet unicodeSet3) {
        UnicodeSet unicodeSet4 = new UnicodeSet(unicodeSet);
        UnicodeSet unicodeSet5 = new UnicodeSet();
        int n2 = this.ruleVector.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            TransliterationRule transliterationRule = this.ruleVector.get(i2);
            transliterationRule.addSourceTargetSet(unicodeSet4, unicodeSet2, unicodeSet3, unicodeSet5.clear());
            unicodeSet4.addAll(unicodeSet5);
        }
    }
}

