/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.UCaseProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Replaceable;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.ReplaceableContextIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.SourceTargetUtility;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Transform;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Transliterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

class TitlecaseTransliterator
extends Transliterator {
    static final String _ID = "Any-Title";
    private final ULocale locale;
    private final UCaseProps csp;
    private ReplaceableContextIterator iter;
    private StringBuilder result;
    private int caseLocale;
    SourceTargetUtility sourceTargetUtility = null;

    static void register() {
        Transliterator.registerFactory(_ID, new Transliterator.Factory(){

            @Override
            public Transliterator getInstance(String string) {
                return new TitlecaseTransliterator(ULocale.US);
            }
        });
        TitlecaseTransliterator.registerSpecialInverse("Title", "Lower", false);
    }

    public TitlecaseTransliterator(ULocale uLocale) {
        super(_ID, null);
        this.locale = uLocale;
        this.setMaximumContextLength(2);
        this.csp = UCaseProps.INSTANCE;
        this.iter = new ReplaceableContextIterator();
        this.result = new StringBuilder();
        this.caseLocale = UCaseProps.getCaseLocale(this.locale);
    }

    @Override
    protected synchronized void handleTransliterate(Replaceable replaceable, Transliterator.Position position, boolean bl2) {
        int n2;
        int n3;
        if (position.start >= position.limit) {
            return;
        }
        boolean bl3 = true;
        for (int i2 = position.start - 1; i2 >= position.contextStart; i2 -= UTF16.getCharCount(n3)) {
            n3 = replaceable.char32At(i2);
            n2 = this.csp.getTypeOrIgnorable(n3);
            if (n2 > 0) {
                bl3 = false;
                break;
            }
            if (n2 == 0) break;
        }
        this.iter.setText(replaceable);
        this.iter.setIndex(position.start);
        this.iter.setLimit(position.limit);
        this.iter.setContextLimits(position.contextStart, position.contextLimit);
        this.result.setLength(0);
        while ((n3 = this.iter.nextCaseMapCP()) >= 0) {
            int n4;
            n2 = this.csp.getTypeOrIgnorable(n3);
            if (n2 < 0) continue;
            n3 = bl3 ? this.csp.toFullTitle(n3, this.iter, this.result, this.caseLocale) : this.csp.toFullLower(n3, this.iter, this.result, this.caseLocale);
            boolean bl4 = bl3 = n2 == 0;
            if (this.iter.didReachLimit() && bl2) {
                position.start = this.iter.getCaseMapCPStart();
                return;
            }
            if (n3 < 0) continue;
            if (n3 <= 31) {
                n4 = this.iter.replace(this.result.toString());
                this.result.setLength(0);
            } else {
                n4 = this.iter.replace(UTF16.valueOf(n3));
            }
            if (n4 == 0) continue;
            position.limit += n4;
            position.contextLimit += n4;
        }
        position.start = position.limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSourceTargetSet(UnicodeSet unicodeSet, UnicodeSet unicodeSet2, UnicodeSet unicodeSet3) {
        TitlecaseTransliterator titlecaseTransliterator = this;
        synchronized (titlecaseTransliterator) {
            if (this.sourceTargetUtility == null) {
                this.sourceTargetUtility = new SourceTargetUtility(new Transform<String, String>(){

                    @Override
                    public String transform(String string) {
                        return UCharacter.toTitleCase(TitlecaseTransliterator.this.locale, string, null);
                    }
                });
            }
        }
        this.sourceTargetUtility.addSourceTargetSet(this, unicodeSet, unicodeSet2, unicodeSet3);
    }
}

