/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.PatternProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.SoftCache;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.TZDBTimeZoneNames;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.TextTrieMap;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.TimeZoneGenericNames;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.TimeZoneNamesImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ZoneMeta;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DateFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NumberingSystem;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.TimeZoneNames;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Calendar;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Freezable;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Output;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public class TimeZoneFormat
extends UFormat
implements Freezable<TimeZoneFormat>,
Serializable {
    private static final long serialVersionUID = 2281246852693575022L;
    private static final int ISO_Z_STYLE_FLAG = 128;
    private static final int ISO_LOCAL_STYLE_FLAG = 256;
    private ULocale _locale;
    private TimeZoneNames _tznames;
    private String _gmtPattern;
    private String[] _gmtOffsetPatterns;
    private String[] _gmtOffsetDigits;
    private String _gmtZeroFormat;
    private boolean _parseAllStyles;
    private boolean _parseTZDBNames;
    private volatile transient TimeZoneGenericNames _gnames;
    private transient String _gmtPatternPrefix;
    private transient String _gmtPatternSuffix;
    private transient Object[][] _gmtOffsetPatternItems;
    private transient boolean _abuttingOffsetHoursAndMinutes;
    private transient String _region;
    private volatile transient boolean _frozen;
    private volatile transient TimeZoneNames _tzdbNames;
    private static final String TZID_GMT = "Etc/GMT";
    private static final String[] ALT_GMT_STRINGS = new String[]{"GMT", "UTC", "UT"};
    private static final String DEFAULT_GMT_PATTERN = "GMT{0}";
    private static final String DEFAULT_GMT_ZERO = "GMT";
    private static final String[] DEFAULT_GMT_DIGITS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private static final char DEFAULT_GMT_OFFSET_SEP = ':';
    private static final String ASCII_DIGITS = "0123456789";
    private static final String ISO8601_UTC = "Z";
    private static final String UNKNOWN_ZONE_ID = "Etc/Unknown";
    private static final String UNKNOWN_SHORT_ZONE_ID = "unk";
    private static final String UNKNOWN_LOCATION = "Unknown";
    private static final GMTOffsetPatternType[] PARSE_GMT_OFFSET_TYPES = new GMTOffsetPatternType[]{GMTOffsetPatternType.POSITIVE_HMS, GMTOffsetPatternType.NEGATIVE_HMS, GMTOffsetPatternType.POSITIVE_HM, GMTOffsetPatternType.NEGATIVE_HM, GMTOffsetPatternType.POSITIVE_H, GMTOffsetPatternType.NEGATIVE_H};
    private static final int MILLIS_PER_HOUR = 3600000;
    private static final int MILLIS_PER_MINUTE = 60000;
    private static final int MILLIS_PER_SECOND = 1000;
    private static final int MAX_OFFSET = 86400000;
    private static final int MAX_OFFSET_HOUR = 23;
    private static final int MAX_OFFSET_MINUTE = 59;
    private static final int MAX_OFFSET_SECOND = 59;
    private static final int UNKNOWN_OFFSET = Integer.MAX_VALUE;
    private static TimeZoneFormatCache _tzfCache = new TimeZoneFormatCache();
    private static final EnumSet<TimeZoneNames.NameType> ALL_SIMPLE_NAME_TYPES = EnumSet.of(TimeZoneNames.NameType.LONG_STANDARD, TimeZoneNames.NameType.LONG_DAYLIGHT, TimeZoneNames.NameType.SHORT_STANDARD, TimeZoneNames.NameType.SHORT_DAYLIGHT, TimeZoneNames.NameType.EXEMPLAR_LOCATION);
    private static final EnumSet<TimeZoneGenericNames.GenericNameType> ALL_GENERIC_NAME_TYPES = EnumSet.of(TimeZoneGenericNames.GenericNameType.LOCATION, TimeZoneGenericNames.GenericNameType.LONG, TimeZoneGenericNames.GenericNameType.SHORT);
    private static volatile TextTrieMap<String> ZONE_ID_TRIE;
    private static volatile TextTrieMap<String> SHORT_ZONE_ID_TRIE;
    private static final ObjectStreamField[] serialPersistentFields;

    protected TimeZoneFormat(ULocale uLocale) {
        Object object;
        String[] stringArray;
        this._locale = uLocale;
        this._tznames = TimeZoneNames.getInstance(uLocale);
        String string = null;
        String string2 = null;
        this._gmtZeroFormat = DEFAULT_GMT_ZERO;
        try {
            stringArray = (String[])ICUResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b/zone", uLocale);
            try {
                string = stringArray.getStringWithFallback("zoneStrings/gmtFormat");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            try {
                string2 = stringArray.getStringWithFallback("zoneStrings/hourFormat");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            try {
                this._gmtZeroFormat = stringArray.getStringWithFallback("zoneStrings/gmtZeroFormat");
            }
            catch (MissingResourceException missingResourceException) {}
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (string == null) {
            string = DEFAULT_GMT_PATTERN;
        }
        this.initGMTPattern(string);
        stringArray = new String[GMTOffsetPatternType.values().length];
        if (string2 != null) {
            object = string2.split(";", 2);
            stringArray[GMTOffsetPatternType.POSITIVE_H.ordinal()] = TimeZoneFormat.truncateOffsetPattern((String)((Object)object[0]));
            stringArray[GMTOffsetPatternType.POSITIVE_HM.ordinal()] = object[0];
            stringArray[GMTOffsetPatternType.POSITIVE_HMS.ordinal()] = TimeZoneFormat.expandOffsetPattern((String)object[0]);
            stringArray[GMTOffsetPatternType.NEGATIVE_H.ordinal()] = TimeZoneFormat.truncateOffsetPattern((String)object[1]);
            stringArray[GMTOffsetPatternType.NEGATIVE_HM.ordinal()] = object[1];
            stringArray[GMTOffsetPatternType.NEGATIVE_HMS.ordinal()] = TimeZoneFormat.expandOffsetPattern((String)object[1]);
        } else {
            for (GMTOffsetPatternType gMTOffsetPatternType : GMTOffsetPatternType.values()) {
                stringArray[gMTOffsetPatternType.ordinal()] = gMTOffsetPatternType.defaultPattern();
            }
        }
        this.initGMTOffsetPatterns(stringArray);
        this._gmtOffsetDigits = DEFAULT_GMT_DIGITS;
        object = NumberingSystem.getInstance(uLocale);
        if (!((NumberingSystem)object).isAlgorithmic()) {
            this._gmtOffsetDigits = TimeZoneFormat.toCodePoints(((NumberingSystem)object).getDescription());
        }
    }

    public static TimeZoneFormat getInstance(ULocale uLocale) {
        if (uLocale == null) {
            throw new NullPointerException("locale is null");
        }
        return (TimeZoneFormat)_tzfCache.getInstance(uLocale, uLocale);
    }

    public static TimeZoneFormat getInstance(Locale locale) {
        return TimeZoneFormat.getInstance(ULocale.forLocale(locale));
    }

    public TimeZoneNames getTimeZoneNames() {
        return this._tznames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimeZoneGenericNames getTimeZoneGenericNames() {
        if (this._gnames == null) {
            TimeZoneFormat timeZoneFormat = this;
            synchronized (timeZoneFormat) {
                if (this._gnames == null) {
                    this._gnames = TimeZoneGenericNames.getInstance(this._locale);
                }
            }
        }
        return this._gnames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimeZoneNames getTZDBTimeZoneNames() {
        if (this._tzdbNames == null) {
            TimeZoneFormat timeZoneFormat = this;
            synchronized (timeZoneFormat) {
                if (this._tzdbNames == null) {
                    this._tzdbNames = new TZDBTimeZoneNames(this._locale);
                }
            }
        }
        return this._tzdbNames;
    }

    public TimeZoneFormat setTimeZoneNames(TimeZoneNames timeZoneNames) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify frozen object");
        }
        this._tznames = timeZoneNames;
        this._gnames = new TimeZoneGenericNames(this._locale, this._tznames);
        return this;
    }

    public String getGMTPattern() {
        return this._gmtPattern;
    }

    public TimeZoneFormat setGMTPattern(String string) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify frozen object");
        }
        this.initGMTPattern(string);
        return this;
    }

    public String getGMTOffsetPattern(GMTOffsetPatternType gMTOffsetPatternType) {
        return this._gmtOffsetPatterns[gMTOffsetPatternType.ordinal()];
    }

    public TimeZoneFormat setGMTOffsetPattern(GMTOffsetPatternType gMTOffsetPatternType, String string) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify frozen object");
        }
        if (string == null) {
            throw new NullPointerException("Null GMT offset pattern");
        }
        Object[] objectArray = TimeZoneFormat.parseOffsetPattern(string, gMTOffsetPatternType.required());
        this._gmtOffsetPatterns[gMTOffsetPatternType.ordinal()] = string;
        this._gmtOffsetPatternItems[gMTOffsetPatternType.ordinal()] = objectArray;
        this.checkAbuttingHoursAndMinutes();
        return this;
    }

    public String getGMTOffsetDigits() {
        StringBuilder stringBuilder = new StringBuilder(this._gmtOffsetDigits.length);
        for (String string : this._gmtOffsetDigits) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public TimeZoneFormat setGMTOffsetDigits(String string) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify frozen object");
        }
        if (string == null) {
            throw new NullPointerException("Null GMT offset digits");
        }
        String[] stringArray = TimeZoneFormat.toCodePoints(string);
        if (stringArray.length != 10) {
            throw new IllegalArgumentException("Length of digits must be 10");
        }
        this._gmtOffsetDigits = stringArray;
        return this;
    }

    public String getGMTZeroFormat() {
        return this._gmtZeroFormat;
    }

    public TimeZoneFormat setGMTZeroFormat(String string) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify frozen object");
        }
        if (string == null) {
            throw new NullPointerException("Null GMT zero format");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Empty GMT zero format");
        }
        this._gmtZeroFormat = string;
        return this;
    }

    public TimeZoneFormat setDefaultParseOptions(EnumSet<ParseOption> enumSet) {
        this._parseAllStyles = enumSet.contains((Object)ParseOption.ALL_STYLES);
        this._parseTZDBNames = enumSet.contains((Object)ParseOption.TZ_DATABASE_ABBREVIATIONS);
        return this;
    }

    public EnumSet<ParseOption> getDefaultParseOptions() {
        if (this._parseAllStyles && this._parseTZDBNames) {
            return EnumSet.of(ParseOption.ALL_STYLES, ParseOption.TZ_DATABASE_ABBREVIATIONS);
        }
        if (this._parseAllStyles) {
            return EnumSet.of(ParseOption.ALL_STYLES);
        }
        if (this._parseTZDBNames) {
            return EnumSet.of(ParseOption.TZ_DATABASE_ABBREVIATIONS);
        }
        return EnumSet.noneOf(ParseOption.class);
    }

    public final String formatOffsetISO8601Basic(int n2, boolean bl2, boolean bl3, boolean bl4) {
        return this.formatOffsetISO8601(n2, true, bl2, bl3, bl4);
    }

    public final String formatOffsetISO8601Extended(int n2, boolean bl2, boolean bl3, boolean bl4) {
        return this.formatOffsetISO8601(n2, false, bl2, bl3, bl4);
    }

    public String formatOffsetLocalizedGMT(int n2) {
        return this.formatOffsetLocalizedGMT(n2, false);
    }

    public String formatOffsetShortLocalizedGMT(int n2) {
        return this.formatOffsetLocalizedGMT(n2, true);
    }

    public final String format(Style style, TimeZone timeZone, long l2) {
        return this.format(style, timeZone, l2, null);
    }

    public String format(Style style, TimeZone timeZone, long l2, Output<TimeType> output) {
        String string = null;
        if (output != null) {
            output.value = TimeType.UNKNOWN;
        }
        boolean bl2 = false;
        switch (style) {
            case GENERIC_LOCATION: {
                string = this.getTimeZoneGenericNames().getGenericLocationName(ZoneMeta.getCanonicalCLDRID(timeZone));
                break;
            }
            case GENERIC_LONG: {
                string = this.getTimeZoneGenericNames().getDisplayName(timeZone, TimeZoneGenericNames.GenericNameType.LONG, l2);
                break;
            }
            case GENERIC_SHORT: {
                string = this.getTimeZoneGenericNames().getDisplayName(timeZone, TimeZoneGenericNames.GenericNameType.SHORT, l2);
                break;
            }
            case SPECIFIC_LONG: {
                string = this.formatSpecific(timeZone, TimeZoneNames.NameType.LONG_STANDARD, TimeZoneNames.NameType.LONG_DAYLIGHT, l2, output);
                break;
            }
            case SPECIFIC_SHORT: {
                string = this.formatSpecific(timeZone, TimeZoneNames.NameType.SHORT_STANDARD, TimeZoneNames.NameType.SHORT_DAYLIGHT, l2, output);
                break;
            }
            case ZONE_ID: {
                string = timeZone.getID();
                bl2 = true;
                break;
            }
            case ZONE_ID_SHORT: {
                string = ZoneMeta.getShortID(timeZone);
                if (string == null) {
                    string = UNKNOWN_SHORT_ZONE_ID;
                }
                bl2 = true;
                break;
            }
            case EXEMPLAR_LOCATION: {
                string = this.formatExemplarLocation(timeZone);
                bl2 = true;
                break;
            }
        }
        if (string == null && !bl2) {
            int[] nArray = new int[]{0, 0};
            timeZone.getOffset(l2, false, nArray);
            int n2 = nArray[0] + nArray[1];
            switch (style) {
                case GENERIC_LOCATION: 
                case GENERIC_LONG: 
                case SPECIFIC_LONG: 
                case LOCALIZED_GMT: {
                    string = this.formatOffsetLocalizedGMT(n2);
                    break;
                }
                case GENERIC_SHORT: 
                case SPECIFIC_SHORT: 
                case LOCALIZED_GMT_SHORT: {
                    string = this.formatOffsetShortLocalizedGMT(n2);
                    break;
                }
                case ISO_BASIC_SHORT: {
                    string = this.formatOffsetISO8601Basic(n2, true, true, true);
                    break;
                }
                case ISO_BASIC_LOCAL_SHORT: {
                    string = this.formatOffsetISO8601Basic(n2, false, true, true);
                    break;
                }
                case ISO_BASIC_FIXED: {
                    string = this.formatOffsetISO8601Basic(n2, true, false, true);
                    break;
                }
                case ISO_BASIC_LOCAL_FIXED: {
                    string = this.formatOffsetISO8601Basic(n2, false, false, true);
                    break;
                }
                case ISO_BASIC_FULL: {
                    string = this.formatOffsetISO8601Basic(n2, true, false, false);
                    break;
                }
                case ISO_BASIC_LOCAL_FULL: {
                    string = this.formatOffsetISO8601Basic(n2, false, false, false);
                    break;
                }
                case ISO_EXTENDED_FIXED: {
                    string = this.formatOffsetISO8601Extended(n2, true, false, true);
                    break;
                }
                case ISO_EXTENDED_LOCAL_FIXED: {
                    string = this.formatOffsetISO8601Extended(n2, false, false, true);
                    break;
                }
                case ISO_EXTENDED_FULL: {
                    string = this.formatOffsetISO8601Extended(n2, true, false, false);
                    break;
                }
                case ISO_EXTENDED_LOCAL_FULL: {
                    string = this.formatOffsetISO8601Extended(n2, false, false, false);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            if (output != null) {
                TimeType timeType = output.value = nArray[1] != 0 ? TimeType.DAYLIGHT : TimeType.STANDARD;
            }
        }
        assert (string != null);
        return string;
    }

    public final int parseOffsetISO8601(String string, ParsePosition parsePosition) {
        return TimeZoneFormat.parseOffsetISO8601(string, parsePosition, false, null);
    }

    public int parseOffsetLocalizedGMT(String string, ParsePosition parsePosition) {
        return this.parseOffsetLocalizedGMT(string, parsePosition, false, null);
    }

    public int parseOffsetShortLocalizedGMT(String string, ParsePosition parsePosition) {
        return this.parseOffsetLocalizedGMT(string, parsePosition, true, null);
    }

    public TimeZone parse(Style style, String string, ParsePosition parsePosition, EnumSet<ParseOption> enumSet, Output<TimeType> output) {
        boolean bl2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        int n2;
        if (output == null) {
            output = new Output<TimeType>(TimeType.UNKNOWN);
        } else {
            output.value = TimeType.UNKNOWN;
        }
        int n3 = parsePosition.getIndex();
        int n4 = string.length();
        boolean bl3 = style == Style.SPECIFIC_LONG || style == Style.GENERIC_LONG || style == Style.GENERIC_LOCATION;
        boolean bl4 = style == Style.SPECIFIC_SHORT || style == Style.GENERIC_SHORT;
        int n5 = 0;
        ParsePosition parsePosition2 = new ParsePosition(n3);
        int n6 = Integer.MAX_VALUE;
        int n7 = -1;
        if (bl3 || bl4) {
            Output<Boolean> output2 = new Output<Boolean>(false);
            n2 = this.parseOffsetLocalizedGMT(string, parsePosition2, bl4, output2);
            if (parsePosition2.getErrorIndex() == -1) {
                if (parsePosition2.getIndex() == n4 || ((Boolean)output2.value).booleanValue()) {
                    parsePosition.setIndex(parsePosition2.getIndex());
                    return this.getTimeZoneForOffset(n2);
                }
                n6 = n2;
                n7 = parsePosition2.getIndex();
            }
            n5 |= Style.LOCALIZED_GMT.flag | Style.LOCALIZED_GMT_SHORT.flag;
        }
        boolean bl5 = enumSet == null ? this.getDefaultParseOptions().contains((Object)ParseOption.TZ_DATABASE_ABBREVIATIONS) : enumSet.contains((Object)ParseOption.TZ_DATABASE_ABBREVIATIONS);
        switch (style) {
            case LOCALIZED_GMT: {
                parsePosition2.setIndex(n3);
                parsePosition2.setErrorIndex(-1);
                n2 = this.parseOffsetLocalizedGMT(string, parsePosition2);
                if (parsePosition2.getErrorIndex() == -1) {
                    parsePosition.setIndex(parsePosition2.getIndex());
                    return this.getTimeZoneForOffset(n2);
                }
                n5 |= Style.LOCALIZED_GMT_SHORT.flag;
                break;
            }
            case LOCALIZED_GMT_SHORT: {
                parsePosition2.setIndex(n3);
                parsePosition2.setErrorIndex(-1);
                n2 = this.parseOffsetShortLocalizedGMT(string, parsePosition2);
                if (parsePosition2.getErrorIndex() == -1) {
                    parsePosition.setIndex(parsePosition2.getIndex());
                    return this.getTimeZoneForOffset(n2);
                }
                n5 |= Style.LOCALIZED_GMT.flag;
                break;
            }
            case ISO_BASIC_SHORT: 
            case ISO_BASIC_FIXED: 
            case ISO_BASIC_FULL: 
            case ISO_EXTENDED_FIXED: 
            case ISO_EXTENDED_FULL: {
                parsePosition2.setIndex(n3);
                parsePosition2.setErrorIndex(-1);
                n2 = this.parseOffsetISO8601(string, parsePosition2);
                if (parsePosition2.getErrorIndex() != -1) break;
                parsePosition.setIndex(parsePosition2.getIndex());
                return this.getTimeZoneForOffset(n2);
            }
            case ISO_BASIC_LOCAL_SHORT: 
            case ISO_BASIC_LOCAL_FIXED: 
            case ISO_BASIC_LOCAL_FULL: 
            case ISO_EXTENDED_LOCAL_FIXED: 
            case ISO_EXTENDED_LOCAL_FULL: {
                parsePosition2.setIndex(n3);
                parsePosition2.setErrorIndex(-1);
                object5 = new Output<Boolean>(false);
                n2 = TimeZoneFormat.parseOffsetISO8601(string, parsePosition2, false, object5);
                if (parsePosition2.getErrorIndex() != -1 || !((Boolean)((Output)object5).value).booleanValue()) break;
                parsePosition.setIndex(parsePosition2.getIndex());
                return this.getTimeZoneForOffset(n2);
            }
            case SPECIFIC_LONG: 
            case SPECIFIC_SHORT: {
                object5 = null;
                if (style == Style.SPECIFIC_LONG) {
                    object5 = EnumSet.of(TimeZoneNames.NameType.LONG_STANDARD, TimeZoneNames.NameType.LONG_DAYLIGHT);
                } else {
                    assert (style == Style.SPECIFIC_SHORT);
                    object5 = EnumSet.of(TimeZoneNames.NameType.SHORT_STANDARD, TimeZoneNames.NameType.SHORT_DAYLIGHT);
                }
                object4 = this._tznames.find(string, n3, (EnumSet<TimeZoneNames.NameType>)object5);
                if (object4 != null) {
                    object3 = null;
                    object2 = object4.iterator();
                    while (object2.hasNext()) {
                        object = (TimeZoneNames.MatchInfo)object2.next();
                        if (n3 + ((TimeZoneNames.MatchInfo)object).matchLength() <= n7) continue;
                        object3 = object;
                        n7 = n3 + ((TimeZoneNames.MatchInfo)object).matchLength();
                    }
                    if (object3 != null) {
                        output.value = this.getTimeType(((TimeZoneNames.MatchInfo)object3).nameType());
                        parsePosition.setIndex(n7);
                        return TimeZone.getTimeZone(this.getTimeZoneID(((TimeZoneNames.MatchInfo)object3).tzID(), ((TimeZoneNames.MatchInfo)object3).mzID()));
                    }
                }
                if (!bl5 || style != Style.SPECIFIC_SHORT) break;
                assert (((AbstractCollection)object5).contains((Object)TimeZoneNames.NameType.SHORT_STANDARD));
                assert (((AbstractCollection)object5).contains((Object)TimeZoneNames.NameType.SHORT_DAYLIGHT));
                object3 = this.getTZDBTimeZoneNames().find(string, n3, (EnumSet<TimeZoneNames.NameType>)object5);
                if (object3 == null) break;
                object2 = null;
                object = object3.iterator();
                while (object.hasNext()) {
                    TimeZoneNames.MatchInfo matchInfo = (TimeZoneNames.MatchInfo)object.next();
                    if (n3 + matchInfo.matchLength() <= n7) continue;
                    object2 = matchInfo;
                    n7 = n3 + matchInfo.matchLength();
                }
                if (object2 == null) break;
                output.value = this.getTimeType(((TimeZoneNames.MatchInfo)object2).nameType());
                parsePosition.setIndex(n7);
                return TimeZone.getTimeZone(this.getTimeZoneID(((TimeZoneNames.MatchInfo)object2).tzID(), ((TimeZoneNames.MatchInfo)object2).mzID()));
            }
            case GENERIC_LOCATION: 
            case GENERIC_LONG: 
            case GENERIC_SHORT: {
                object5 = null;
                switch (style) {
                    case GENERIC_LOCATION: {
                        object5 = EnumSet.of(TimeZoneGenericNames.GenericNameType.LOCATION);
                        break;
                    }
                    case GENERIC_LONG: {
                        object5 = EnumSet.of(TimeZoneGenericNames.GenericNameType.LONG, TimeZoneGenericNames.GenericNameType.LOCATION);
                        break;
                    }
                    case GENERIC_SHORT: {
                        object5 = EnumSet.of(TimeZoneGenericNames.GenericNameType.SHORT, TimeZoneGenericNames.GenericNameType.LOCATION);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                object4 = this.getTimeZoneGenericNames().findBestMatch(string, n3, (EnumSet<TimeZoneGenericNames.GenericNameType>)object5);
                if (object4 == null || n3 + ((TimeZoneGenericNames.GenericMatchInfo)object4).matchLength() <= n7) break;
                output.value = ((TimeZoneGenericNames.GenericMatchInfo)object4).timeType();
                parsePosition.setIndex(n3 + ((TimeZoneGenericNames.GenericMatchInfo)object4).matchLength());
                return TimeZone.getTimeZone(((TimeZoneGenericNames.GenericMatchInfo)object4).tzID());
            }
            case ZONE_ID: {
                parsePosition2.setIndex(n3);
                parsePosition2.setErrorIndex(-1);
                object5 = TimeZoneFormat.parseZoneID(string, parsePosition2);
                if (parsePosition2.getErrorIndex() != -1) break;
                parsePosition.setIndex(parsePosition2.getIndex());
                return TimeZone.getTimeZone(object5);
            }
            case ZONE_ID_SHORT: {
                parsePosition2.setIndex(n3);
                parsePosition2.setErrorIndex(-1);
                object5 = TimeZoneFormat.parseShortZoneID(string, parsePosition2);
                if (parsePosition2.getErrorIndex() != -1) break;
                parsePosition.setIndex(parsePosition2.getIndex());
                return TimeZone.getTimeZone(object5);
            }
            case EXEMPLAR_LOCATION: {
                parsePosition2.setIndex(n3);
                parsePosition2.setErrorIndex(-1);
                object5 = this.parseExemplarLocation(string, parsePosition2);
                if (parsePosition2.getErrorIndex() != -1) break;
                parsePosition.setIndex(parsePosition2.getIndex());
                return TimeZone.getTimeZone(object5);
            }
        }
        n5 |= style.flag;
        if (n7 > n3) {
            assert (n6 != Integer.MAX_VALUE);
            parsePosition.setIndex(n7);
            return this.getTimeZoneForOffset(n6);
        }
        object5 = null;
        object4 = TimeType.UNKNOWN;
        assert (n7 < 0);
        assert (n6 == Integer.MAX_VALUE);
        if (n7 < n4 && ((n5 & 0x80) == 0 || (n5 & 0x100) == 0)) {
            parsePosition2.setIndex(n3);
            parsePosition2.setErrorIndex(-1);
            object3 = new Output<Boolean>(false);
            n2 = TimeZoneFormat.parseOffsetISO8601(string, parsePosition2, false, object3);
            if (parsePosition2.getErrorIndex() == -1) {
                if (parsePosition2.getIndex() == n4 || ((Boolean)((Output)object3).value).booleanValue()) {
                    parsePosition.setIndex(parsePosition2.getIndex());
                    return this.getTimeZoneForOffset(n2);
                }
                if (n7 < parsePosition2.getIndex()) {
                    n6 = n2;
                    object5 = null;
                    object4 = TimeType.UNKNOWN;
                    n7 = parsePosition2.getIndex();
                    assert (n7 == n3 + 1);
                }
            }
        }
        if (n7 < n4 && (n5 & Style.LOCALIZED_GMT.flag) == 0) {
            parsePosition2.setIndex(n3);
            parsePosition2.setErrorIndex(-1);
            object3 = new Output<Boolean>(false);
            n2 = this.parseOffsetLocalizedGMT(string, parsePosition2, false, (Output<Boolean>)object3);
            if (parsePosition2.getErrorIndex() == -1) {
                if (parsePosition2.getIndex() == n4 || ((Boolean)((Output)object3).value).booleanValue()) {
                    parsePosition.setIndex(parsePosition2.getIndex());
                    return this.getTimeZoneForOffset(n2);
                }
                if (n7 < parsePosition2.getIndex()) {
                    n6 = n2;
                    object5 = null;
                    object4 = TimeType.UNKNOWN;
                    n7 = parsePosition2.getIndex();
                }
            }
        }
        if (n7 < n4 && (n5 & Style.LOCALIZED_GMT_SHORT.flag) == 0) {
            parsePosition2.setIndex(n3);
            parsePosition2.setErrorIndex(-1);
            object3 = new Output<Boolean>(false);
            n2 = this.parseOffsetLocalizedGMT(string, parsePosition2, true, (Output<Boolean>)object3);
            if (parsePosition2.getErrorIndex() == -1) {
                if (parsePosition2.getIndex() == n4 || ((Boolean)((Output)object3).value).booleanValue()) {
                    parsePosition.setIndex(parsePosition2.getIndex());
                    return this.getTimeZoneForOffset(n2);
                }
                if (n7 < parsePosition2.getIndex()) {
                    n6 = n2;
                    object5 = null;
                    object4 = TimeType.UNKNOWN;
                    n7 = parsePosition2.getIndex();
                }
            }
        }
        boolean bl6 = bl2 = enumSet == null ? this.getDefaultParseOptions().contains((Object)ParseOption.ALL_STYLES) : enumSet.contains((Object)ParseOption.ALL_STYLES);
        if (bl2) {
            TimeZoneNames.MatchInfo matchInfo;
            Iterator iterator;
            if (n7 < n4) {
                object2 = this._tznames.find(string, n3, ALL_SIMPLE_NAME_TYPES);
                object = null;
                int n8 = -1;
                if (object2 != null) {
                    iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        matchInfo = (TimeZoneNames.MatchInfo)iterator.next();
                        if (n3 + matchInfo.matchLength() <= n8) continue;
                        object = matchInfo;
                        n8 = n3 + matchInfo.matchLength();
                    }
                }
                if (n7 < n8) {
                    n7 = n8;
                    object5 = this.getTimeZoneID(((TimeZoneNames.MatchInfo)object).tzID(), ((TimeZoneNames.MatchInfo)object).mzID());
                    object4 = this.getTimeType(((TimeZoneNames.MatchInfo)object).nameType());
                    n6 = Integer.MAX_VALUE;
                }
            }
            if (bl5 && n7 < n4 && (n5 & Style.SPECIFIC_SHORT.flag) == 0) {
                object2 = this.getTZDBTimeZoneNames().find(string, n3, ALL_SIMPLE_NAME_TYPES);
                object = null;
                int n9 = -1;
                if (object2 != null) {
                    iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        matchInfo = (TimeZoneNames.MatchInfo)iterator.next();
                        if (n3 + matchInfo.matchLength() <= n9) continue;
                        object = matchInfo;
                        n9 = n3 + matchInfo.matchLength();
                    }
                    if (n7 < n9) {
                        n7 = n9;
                        object5 = this.getTimeZoneID(((TimeZoneNames.MatchInfo)object).tzID(), ((TimeZoneNames.MatchInfo)object).mzID());
                        object4 = this.getTimeType(((TimeZoneNames.MatchInfo)object).nameType());
                        n6 = Integer.MAX_VALUE;
                    }
                }
            }
            if (n7 < n4 && (object2 = this.getTimeZoneGenericNames().findBestMatch(string, n3, ALL_GENERIC_NAME_TYPES)) != null && n7 < n3 + ((TimeZoneGenericNames.GenericMatchInfo)object2).matchLength()) {
                n7 = n3 + ((TimeZoneGenericNames.GenericMatchInfo)object2).matchLength();
                object5 = ((TimeZoneGenericNames.GenericMatchInfo)object2).tzID();
                object4 = ((TimeZoneGenericNames.GenericMatchInfo)object2).timeType();
                n6 = Integer.MAX_VALUE;
            }
            if (n7 < n4 && (n5 & Style.ZONE_ID.flag) == 0) {
                parsePosition2.setIndex(n3);
                parsePosition2.setErrorIndex(-1);
                object2 = TimeZoneFormat.parseZoneID(string, parsePosition2);
                if (parsePosition2.getErrorIndex() == -1 && n7 < parsePosition2.getIndex()) {
                    n7 = parsePosition2.getIndex();
                    object5 = object2;
                    object4 = TimeType.UNKNOWN;
                    n6 = Integer.MAX_VALUE;
                }
            }
            if (n7 < n4 && (n5 & Style.ZONE_ID_SHORT.flag) == 0) {
                parsePosition2.setIndex(n3);
                parsePosition2.setErrorIndex(-1);
                object2 = TimeZoneFormat.parseShortZoneID(string, parsePosition2);
                if (parsePosition2.getErrorIndex() == -1 && n7 < parsePosition2.getIndex()) {
                    n7 = parsePosition2.getIndex();
                    object5 = object2;
                    object4 = TimeType.UNKNOWN;
                    n6 = Integer.MAX_VALUE;
                }
            }
        }
        if (n7 > n3) {
            object2 = null;
            if (object5 != null) {
                object2 = TimeZone.getTimeZone(object5);
            } else {
                assert (n6 != Integer.MAX_VALUE);
                object2 = this.getTimeZoneForOffset(n6);
            }
            output.value = object4;
            parsePosition.setIndex(n7);
            return object2;
        }
        parsePosition.setErrorIndex(n3);
        return null;
    }

    public TimeZone parse(Style style, String string, ParsePosition parsePosition, Output<TimeType> output) {
        return this.parse(style, string, parsePosition, null, output);
    }

    public final TimeZone parse(String string, ParsePosition parsePosition) {
        return this.parse(Style.GENERIC_LOCATION, string, parsePosition, EnumSet.of(ParseOption.ALL_STYLES), null);
    }

    public final TimeZone parse(String string) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        TimeZone timeZone = this.parse(string, parsePosition);
        if (parsePosition.getErrorIndex() >= 0) {
            throw new ParseException("Unparseable time zone: \"" + string + "\"", 0);
        }
        assert (timeZone != null);
        return timeZone;
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        TimeZone timeZone = null;
        long l2 = System.currentTimeMillis();
        if (object instanceof TimeZone) {
            timeZone = (TimeZone)object;
        } else if (object instanceof Calendar) {
            timeZone = ((Calendar)object).getTimeZone();
            l2 = ((Calendar)object).getTimeInMillis();
        } else {
            throw new IllegalArgumentException("Cannot format given Object (" + object.getClass().getName() + ") as a time zone");
        }
        assert (timeZone != null);
        String string = this.formatOffsetLocalizedGMT(timeZone.getOffset(l2));
        stringBuffer.append(string);
        if (fieldPosition.getFieldAttribute() == DateFormat.Field.TIME_ZONE || fieldPosition.getField() == 17) {
            fieldPosition.setBeginIndex(0);
            fieldPosition.setEndIndex(string.length());
        }
        return stringBuffer;
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        FieldPosition fieldPosition = new FieldPosition(0);
        stringBuffer = this.format(object, stringBuffer, fieldPosition);
        AttributedString attributedString = new AttributedString(stringBuffer.toString());
        attributedString.addAttribute(DateFormat.Field.TIME_ZONE, DateFormat.Field.TIME_ZONE);
        return attributedString.getIterator();
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    private String formatOffsetLocalizedGMT(int n2, boolean bl2) {
        if (n2 == 0) {
            return this._gmtZeroFormat;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = true;
        if (n2 < 0) {
            n2 = -n2;
            bl3 = false;
        }
        int n3 = n2 / 3600000;
        int n4 = (n2 %= 3600000) / 60000;
        int n5 = (n2 %= 60000) / 1000;
        if (n3 > 23 || n4 > 59 || n5 > 59) {
            throw new IllegalArgumentException("Offset out of range :" + n2);
        }
        Object[] objectArray = bl3 ? (n5 != 0 ? this._gmtOffsetPatternItems[GMTOffsetPatternType.POSITIVE_HMS.ordinal()] : (n4 != 0 || !bl2 ? this._gmtOffsetPatternItems[GMTOffsetPatternType.POSITIVE_HM.ordinal()] : this._gmtOffsetPatternItems[GMTOffsetPatternType.POSITIVE_H.ordinal()])) : (n5 != 0 ? this._gmtOffsetPatternItems[GMTOffsetPatternType.NEGATIVE_HMS.ordinal()] : (n4 != 0 || !bl2 ? this._gmtOffsetPatternItems[GMTOffsetPatternType.NEGATIVE_HM.ordinal()] : this._gmtOffsetPatternItems[GMTOffsetPatternType.NEGATIVE_H.ordinal()]));
        stringBuilder.append(this._gmtPatternPrefix);
        block5: for (Object object : objectArray) {
            if (object instanceof String) {
                stringBuilder.append((String)object);
                continue;
            }
            if (!(object instanceof GMTOffsetField)) continue;
            GMTOffsetField gMTOffsetField = (GMTOffsetField)object;
            switch (gMTOffsetField.getType()) {
                case 'H': {
                    this.appendOffsetDigits(stringBuilder, n3, bl2 ? 1 : 2);
                    continue block5;
                }
                case 'm': {
                    this.appendOffsetDigits(stringBuilder, n4, 2);
                    continue block5;
                }
                case 's': {
                    this.appendOffsetDigits(stringBuilder, n5, 2);
                }
            }
        }
        stringBuilder.append(this._gmtPatternSuffix);
        return stringBuilder.toString();
    }

    private String formatOffsetISO8601(int n2, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        int n3;
        int n4;
        Character c2;
        int n5;
        int n6 = n5 = n2 < 0 ? -n2 : n2;
        if (bl3 && (n5 < 1000 || bl5 && n5 < 60000)) {
            return ISO8601_UTC;
        }
        OffsetFields offsetFields = bl4 ? OffsetFields.H : OffsetFields.HM;
        OffsetFields offsetFields2 = bl5 ? OffsetFields.HM : OffsetFields.HMS;
        Character c3 = c2 = bl2 ? null : Character.valueOf(':');
        if (n5 >= 86400000) {
            throw new IllegalArgumentException("Offset out of range :" + n2);
        }
        int[] nArray = new int[]{n5 / 3600000, (n5 %= 3600000) / 60000, (n5 %= 60000) / 1000};
        assert (nArray[0] >= 0 && nArray[0] <= 23);
        assert (nArray[1] >= 0 && nArray[1] <= 59);
        assert (nArray[2] >= 0 && nArray[2] <= 59);
        for (n4 = offsetFields2.ordinal(); n4 > offsetFields.ordinal() && nArray[n4] == 0; --n4) {
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n7 = 43;
        if (n2 < 0) {
            for (n3 = 0; n3 <= n4; ++n3) {
                if (nArray[n3] == 0) continue;
                n7 = 45;
                break;
            }
        }
        stringBuilder.append((char)n7);
        for (n3 = 0; n3 <= n4; ++n3) {
            if (c2 != null && n3 != 0) {
                stringBuilder.append(c2);
            }
            if (nArray[n3] < 10) {
                stringBuilder.append('0');
            }
            stringBuilder.append(nArray[n3]);
        }
        return stringBuilder.toString();
    }

    private String formatSpecific(TimeZone timeZone, TimeZoneNames.NameType nameType, TimeZoneNames.NameType nameType2, long l2, Output<TimeType> output) {
        String string;
        assert (nameType == TimeZoneNames.NameType.LONG_STANDARD || nameType == TimeZoneNames.NameType.SHORT_STANDARD);
        assert (nameType2 == TimeZoneNames.NameType.LONG_DAYLIGHT || nameType2 == TimeZoneNames.NameType.SHORT_DAYLIGHT);
        boolean bl2 = timeZone.inDaylightTime(new Date(l2));
        String string2 = string = bl2 ? this.getTimeZoneNames().getDisplayName(ZoneMeta.getCanonicalCLDRID(timeZone), nameType2, l2) : this.getTimeZoneNames().getDisplayName(ZoneMeta.getCanonicalCLDRID(timeZone), nameType, l2);
        if (string != null && output != null) {
            output.value = bl2 ? TimeType.DAYLIGHT : TimeType.STANDARD;
        }
        return string;
    }

    private String formatExemplarLocation(TimeZone timeZone) {
        String string = this.getTimeZoneNames().getExemplarLocationName(ZoneMeta.getCanonicalCLDRID(timeZone));
        if (string == null && (string = this.getTimeZoneNames().getExemplarLocationName(UNKNOWN_ZONE_ID)) == null) {
            string = UNKNOWN_LOCATION;
        }
        return string;
    }

    private String getTimeZoneID(String string, String string2) {
        String string3 = string;
        if (string3 == null) {
            assert (string2 != null);
            string3 = this._tznames.getReferenceZoneID(string2, this.getTargetRegion());
            if (string3 == null) {
                throw new IllegalArgumentException("Invalid mzID: " + string2);
            }
        }
        return string3;
    }

    private synchronized String getTargetRegion() {
        if (this._region == null) {
            this._region = this._locale.getCountry();
            if (this._region.length() == 0) {
                ULocale uLocale = ULocale.addLikelySubtags(this._locale);
                this._region = uLocale.getCountry();
                if (this._region.length() == 0) {
                    this._region = "001";
                }
            }
        }
        return this._region;
    }

    private TimeType getTimeType(TimeZoneNames.NameType nameType) {
        switch (nameType) {
            case LONG_STANDARD: 
            case SHORT_STANDARD: {
                return TimeType.STANDARD;
            }
            case LONG_DAYLIGHT: 
            case SHORT_DAYLIGHT: {
                return TimeType.DAYLIGHT;
            }
        }
        return TimeType.UNKNOWN;
    }

    private void initGMTPattern(String string) {
        int n2 = string.indexOf("{0}");
        if (n2 < 0) {
            throw new IllegalArgumentException("Bad localized GMT pattern: " + string);
        }
        this._gmtPattern = string;
        this._gmtPatternPrefix = TimeZoneFormat.unquote(string.substring(0, n2));
        this._gmtPatternSuffix = TimeZoneFormat.unquote(string.substring(n2 + 3));
    }

    private static String unquote(String string) {
        if (string.indexOf(39) < 0) {
            return string;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\'') {
                if (bl2) {
                    stringBuilder.append(c2);
                    bl2 = false;
                } else {
                    bl2 = true;
                }
                bl3 = !bl3;
                continue;
            }
            bl2 = false;
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    private void initGMTOffsetPatterns(String[] stringArray) {
        int n2 = GMTOffsetPatternType.values().length;
        if (stringArray.length < n2) {
            throw new IllegalArgumentException("Insufficient number of elements in gmtOffsetPatterns");
        }
        Object[][] objectArrayArray = new Object[n2][];
        for (GMTOffsetPatternType gMTOffsetPatternType : GMTOffsetPatternType.values()) {
            int n3 = gMTOffsetPatternType.ordinal();
            Object[] objectArray = TimeZoneFormat.parseOffsetPattern(stringArray[n3], gMTOffsetPatternType.required());
            objectArrayArray[n3] = objectArray;
        }
        this._gmtOffsetPatterns = new String[n2];
        System.arraycopy(stringArray, 0, this._gmtOffsetPatterns, 0, n2);
        this._gmtOffsetPatternItems = objectArrayArray;
        this.checkAbuttingHoursAndMinutes();
    }

    private void checkAbuttingHoursAndMinutes() {
        this._abuttingOffsetHoursAndMinutes = false;
        block0: for (Object[] objectArray : this._gmtOffsetPatternItems) {
            boolean bl2 = false;
            for (Object object : objectArray) {
                if (object instanceof GMTOffsetField) {
                    GMTOffsetField gMTOffsetField = (GMTOffsetField)object;
                    if (bl2) {
                        this._abuttingOffsetHoursAndMinutes = true;
                        continue;
                    }
                    if (gMTOffsetField.getType() != 'H') continue;
                    bl2 = true;
                    continue;
                }
                if (bl2) continue block0;
            }
        }
    }

    private static Object[] parseOffsetPattern(String string, String string2) {
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder stringBuilder = new StringBuilder();
        char c2 = '\u0000';
        int n2 = 1;
        boolean bl4 = false;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        BitSet bitSet = new BitSet(string2.length());
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c3 = string.charAt(i2);
            if (c3 == '\'') {
                if (bl2) {
                    stringBuilder.append('\'');
                    bl2 = false;
                } else {
                    bl2 = true;
                    if (c2 != '\u0000') {
                        if (!GMTOffsetField.isValid(c2, n2)) {
                            bl4 = true;
                            break;
                        }
                        arrayList.add(new GMTOffsetField(c2, n2));
                        c2 = '\u0000';
                    }
                }
                bl3 = !bl3;
                continue;
            }
            bl2 = false;
            if (bl3) {
                stringBuilder.append(c3);
                continue;
            }
            int n3 = string2.indexOf(c3);
            if (n3 >= 0) {
                if (c3 == c2) {
                    ++n2;
                    continue;
                }
                if (c2 == '\u0000') {
                    if (stringBuilder.length() > 0) {
                        arrayList.add(stringBuilder.toString());
                        stringBuilder.setLength(0);
                    }
                } else if (GMTOffsetField.isValid(c2, n2)) {
                    arrayList.add(new GMTOffsetField(c2, n2));
                } else {
                    bl4 = true;
                    break;
                }
                c2 = c3;
                n2 = 1;
                bitSet.set(n3);
                continue;
            }
            if (c2 != '\u0000') {
                if (!GMTOffsetField.isValid(c2, n2)) {
                    bl4 = true;
                    break;
                }
                arrayList.add(new GMTOffsetField(c2, n2));
                c2 = '\u0000';
            }
            stringBuilder.append(c3);
        }
        if (!bl4) {
            if (c2 == '\u0000') {
                if (stringBuilder.length() > 0) {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                }
            } else if (GMTOffsetField.isValid(c2, n2)) {
                arrayList.add(new GMTOffsetField(c2, n2));
            } else {
                bl4 = true;
            }
        }
        if (bl4 || bitSet.cardinality() != string2.length()) {
            throw new IllegalStateException("Bad localized GMT offset pattern: " + string);
        }
        return arrayList.toArray(new Object[arrayList.size()]);
    }

    private static String expandOffsetPattern(String string) {
        int n2 = string.indexOf("mm");
        if (n2 < 0) {
            throw new RuntimeException("Bad time zone hour pattern data");
        }
        String string2 = ":";
        int n3 = string.substring(0, n2).lastIndexOf("H");
        if (n3 >= 0) {
            string2 = string.substring(n3 + 1, n2);
        }
        return string.substring(0, n2 + 2) + string2 + "ss" + string.substring(n2 + 2);
    }

    private static String truncateOffsetPattern(String string) {
        int n2 = string.indexOf("mm");
        if (n2 < 0) {
            throw new RuntimeException("Bad time zone hour pattern data");
        }
        int n3 = string.substring(0, n2).lastIndexOf("HH");
        if (n3 >= 0) {
            return string.substring(0, n3 + 2);
        }
        int n4 = string.substring(0, n2).lastIndexOf("H");
        if (n4 >= 0) {
            return string.substring(0, n4 + 1);
        }
        throw new RuntimeException("Bad time zone hour pattern data");
    }

    private void appendOffsetDigits(StringBuilder stringBuilder, int n2, int n3) {
        assert (n2 >= 0 && n2 < 60);
        int n4 = n2 >= 10 ? 2 : 1;
        for (int i2 = 0; i2 < n3 - n4; ++i2) {
            stringBuilder.append(this._gmtOffsetDigits[0]);
        }
        if (n4 == 2) {
            stringBuilder.append(this._gmtOffsetDigits[n2 / 10]);
        }
        stringBuilder.append(this._gmtOffsetDigits[n2 % 10]);
    }

    private TimeZone getTimeZoneForOffset(int n2) {
        if (n2 == 0) {
            return TimeZone.getTimeZone(TZID_GMT);
        }
        return ZoneMeta.getCustomTimeZone(n2);
    }

    private int parseOffsetLocalizedGMT(String string, ParsePosition parsePosition, boolean bl2, Output<Boolean> output) {
        int n2 = parsePosition.getIndex();
        int n3 = 0;
        int[] nArray = new int[]{0};
        if (output != null) {
            output.value = false;
        }
        n3 = this.parseOffsetLocalizedGMTPattern(string, n2, bl2, nArray);
        if (nArray[0] > 0) {
            if (output != null) {
                output.value = true;
            }
            parsePosition.setIndex(n2 + nArray[0]);
            return n3;
        }
        n3 = this.parseOffsetDefaultLocalizedGMT(string, n2, nArray);
        if (nArray[0] > 0) {
            if (output != null) {
                output.value = true;
            }
            parsePosition.setIndex(n2 + nArray[0]);
            return n3;
        }
        if (string.regionMatches(true, n2, this._gmtZeroFormat, 0, this._gmtZeroFormat.length())) {
            parsePosition.setIndex(n2 + this._gmtZeroFormat.length());
            return 0;
        }
        for (String string2 : ALT_GMT_STRINGS) {
            if (!string.regionMatches(true, n2, string2, 0, string2.length())) continue;
            parsePosition.setIndex(n2 + string2.length());
            return 0;
        }
        parsePosition.setErrorIndex(n2);
        return 0;
    }

    private int parseOffsetLocalizedGMTPattern(String string, int n2, boolean bl2, int[] nArray) {
        int n3 = n2;
        int n4 = 0;
        boolean bl3 = false;
        int n5 = this._gmtPatternPrefix.length();
        if (n5 <= 0 || string.regionMatches(true, n3, this._gmtPatternPrefix, 0, n5)) {
            int[] nArray2 = new int[1];
            n4 = this.parseOffsetFields(string, n3 += n5, false, nArray2);
            if (nArray2[0] != 0 && ((n5 = this._gmtPatternSuffix.length()) <= 0 || string.regionMatches(true, n3 += nArray2[0], this._gmtPatternSuffix, 0, n5))) {
                n3 += n5;
                bl3 = true;
            }
        }
        nArray[0] = bl3 ? n3 - n2 : 0;
        return n4;
    }

    private int parseOffsetFields(String string, int n2, boolean bl2, int[] nArray) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        if (nArray != null && nArray.length >= 1) {
            nArray[0] = 0;
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int[] nArray2 = new int[]{0, 0, 0};
        for (GMTOffsetPatternType gMTOffsetPatternType : PARSE_GMT_OFFSET_TYPES) {
            Object[] objectArray = this._gmtOffsetPatternItems[gMTOffsetPatternType.ordinal()];
            assert (objectArray != null);
            n3 = this.parseOffsetFieldsWithPattern(string, n2, objectArray, false, nArray2);
            if (n3 <= 0) continue;
            n5 = gMTOffsetPatternType.isPositive() ? 1 : -1;
            n8 = nArray2[0];
            n7 = nArray2[1];
            n6 = nArray2[2];
            break;
        }
        if (n3 > 0 && this._abuttingOffsetHoursAndMinutes) {
            int n9 = 0;
            int n10 = 1;
            for (GMTOffsetPatternType gMTOffsetPatternType : PARSE_GMT_OFFSET_TYPES) {
                Object[] objectArray = this._gmtOffsetPatternItems[gMTOffsetPatternType.ordinal()];
                assert (objectArray != null);
                n9 = this.parseOffsetFieldsWithPattern(string, n2, objectArray, true, nArray2);
                if (n9 <= 0) continue;
                n10 = gMTOffsetPatternType.isPositive() ? 1 : -1;
                break;
            }
            if (n9 > n3) {
                n3 = n9;
                n5 = n10;
                n8 = nArray2[0];
                n7 = nArray2[1];
                n6 = nArray2[2];
            }
        }
        if (nArray != null && nArray.length >= 1) {
            nArray[0] = n3;
        }
        if (n3 > 0) {
            n4 = ((n8 * 60 + n7) * 60 + n6) * 1000 * n5;
        }
        return n4;
    }

    private int parseOffsetFieldsWithPattern(String string, int n2, Object[] objectArray, boolean bl2, int[] nArray) {
        assert (nArray != null && nArray.length >= 3);
        nArray[2] = 0;
        nArray[1] = 0;
        nArray[0] = 0;
        boolean bl3 = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = n2;
        int[] nArray2 = new int[]{0};
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            int n7;
            int n8;
            Object object;
            if (objectArray[i2] instanceof String) {
                object = (String)objectArray[i2];
                n8 = ((String)object).length();
                n7 = 0;
                if (i2 == 0 && n6 < string.length() && !PatternProps.isWhiteSpace(string.codePointAt(n6))) {
                    int n9;
                    while (n8 > 0 && PatternProps.isWhiteSpace(n9 = ((String)object).codePointAt(n7))) {
                        int n10 = Character.charCount(n9);
                        n8 -= n10;
                        n7 += n10;
                    }
                }
                if (!string.regionMatches(true, n6, (String)object, n7, n8)) {
                    bl3 = true;
                    break;
                }
                n6 += n8;
                continue;
            }
            assert (objectArray[i2] instanceof GMTOffsetField);
            object = (GMTOffsetField)objectArray[i2];
            n8 = ((GMTOffsetField)object).getType();
            if (n8 == 72) {
                n7 = bl2 ? 1 : 2;
                n5 = this.parseOffsetFieldWithLocalizedDigits(string, n6, 1, n7, 0, 23, nArray2);
            } else if (n8 == 109) {
                n4 = this.parseOffsetFieldWithLocalizedDigits(string, n6, 2, 2, 0, 59, nArray2);
            } else if (n8 == 115) {
                n3 = this.parseOffsetFieldWithLocalizedDigits(string, n6, 2, 2, 0, 59, nArray2);
            }
            if (nArray2[0] == 0) {
                bl3 = true;
                break;
            }
            n6 += nArray2[0];
        }
        if (bl3) {
            return 0;
        }
        nArray[0] = n5;
        nArray[1] = n4;
        nArray[2] = n3;
        return n6 - n2;
    }

    private int parseOffsetDefaultLocalizedGMT(String string, int n2, int[] nArray) {
        int n3;
        int n4;
        block8: {
            int n5;
            int n6;
            block10: {
                int n7;
                block9: {
                    n6 = n2;
                    n4 = 0;
                    n3 = 0;
                    int n8 = 0;
                    for (String string2 : ALT_GMT_STRINGS) {
                        int n9 = string2.length();
                        if (!string.regionMatches(true, n6, string2, 0, n9)) continue;
                        n8 = n9;
                        break;
                    }
                    if (n8 == 0 || (n6 += n8) + 1 >= string.length()) break block8;
                    n5 = 1;
                    n7 = string.charAt(n6);
                    if (n7 != 43) break block9;
                    n5 = 1;
                    break block10;
                }
                if (n7 != 45) break block8;
                n5 = -1;
            }
            int[] nArray2 = new int[]{0};
            int n10 = this.parseDefaultOffsetFields(string, ++n6, ':', nArray2);
            if (nArray2[0] == string.length() - n6) {
                n4 = n10 * n5;
                n6 += nArray2[0];
            } else {
                int[] nArray3 = new int[]{0};
                int n11 = this.parseAbuttingOffsetFields(string, n6, nArray3);
                if (nArray2[0] > nArray3[0]) {
                    n4 = n10 * n5;
                    n6 += nArray2[0];
                } else {
                    n4 = n11 * n5;
                    n6 += nArray3[0];
                }
            }
            n3 = n6 - n2;
        }
        nArray[0] = n3;
        return n4;
    }

    private int parseDefaultOffsetFields(String string, int n2, char c2, int[] nArray) {
        int n3 = string.length();
        int n4 = n2;
        int[] nArray2 = new int[]{0};
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        n5 = this.parseOffsetFieldWithLocalizedDigits(string, n4, 1, 2, 0, 23, nArray2);
        if (nArray2[0] != 0 && (n4 += nArray2[0]) + 1 < n3 && string.charAt(n4) == c2) {
            n6 = this.parseOffsetFieldWithLocalizedDigits(string, n4 + 1, 2, 2, 0, 59, nArray2);
            if (nArray2[0] != 0 && (n4 += 1 + nArray2[0]) + 1 < n3 && string.charAt(n4) == c2) {
                n7 = this.parseOffsetFieldWithLocalizedDigits(string, n4 + 1, 2, 2, 0, 59, nArray2);
                if (nArray2[0] != 0) {
                    n4 += 1 + nArray2[0];
                }
            }
        }
        if (n4 == n2) {
            nArray[0] = 0;
            return 0;
        }
        nArray[0] = n4 - n2;
        return n5 * 3600000 + n6 * 60000 + n7 * 1000;
    }

    private int parseAbuttingOffsetFields(String string, int n2, int[] nArray) {
        int n3;
        int n4 = 6;
        int[] nArray2 = new int[6];
        int[] nArray3 = new int[6];
        int n5 = n2;
        int[] nArray4 = new int[]{0};
        int n6 = 0;
        for (n3 = 0; n3 < 6; ++n3) {
            nArray2[n3] = this.parseSingleLocalizedDigit(string, n5, nArray4);
            if (nArray2[n3] < 0) break;
            nArray3[n3] = (n5 += nArray4[0]) - n2;
            ++n6;
        }
        if (n6 == 0) {
            nArray[0] = 0;
            return 0;
        }
        n3 = 0;
        while (n6 > 0) {
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            assert (n6 > 0 && n6 <= 6);
            switch (n6) {
                case 1: {
                    n7 = nArray2[0];
                    break;
                }
                case 2: {
                    n7 = nArray2[0] * 10 + nArray2[1];
                    break;
                }
                case 3: {
                    n7 = nArray2[0];
                    n8 = nArray2[1] * 10 + nArray2[2];
                    break;
                }
                case 4: {
                    n7 = nArray2[0] * 10 + nArray2[1];
                    n8 = nArray2[2] * 10 + nArray2[3];
                    break;
                }
                case 5: {
                    n7 = nArray2[0];
                    n8 = nArray2[1] * 10 + nArray2[2];
                    n9 = nArray2[3] * 10 + nArray2[4];
                    break;
                }
                case 6: {
                    n7 = nArray2[0] * 10 + nArray2[1];
                    n8 = nArray2[2] * 10 + nArray2[3];
                    n9 = nArray2[4] * 10 + nArray2[5];
                }
            }
            if (n7 <= 23 && n8 <= 59 && n9 <= 59) {
                n3 = n7 * 3600000 + n8 * 60000 + n9 * 1000;
                nArray[0] = nArray3[n6 - 1];
                break;
            }
            --n6;
        }
        return n3;
    }

    private int parseOffsetFieldWithLocalizedDigits(String string, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        int n7;
        int n8;
        int n9;
        nArray[0] = 0;
        int n10 = 0;
        int n11 = 0;
        int[] nArray2 = new int[]{0};
        for (n9 = n2; n9 < string.length() && n11 < n4 && (n8 = this.parseSingleLocalizedDigit(string, n9, nArray2)) >= 0 && (n7 = n10 * 10 + n8) <= n6; ++n11, n9 += nArray2[0]) {
            n10 = n7;
        }
        if (n11 < n3 || n10 < n5) {
            n10 = -1;
            n11 = 0;
        } else {
            nArray[0] = n9 - n2;
        }
        return n10;
    }

    private int parseSingleLocalizedDigit(String string, int n2, int[] nArray) {
        int n3 = -1;
        nArray[0] = 0;
        if (n2 < string.length()) {
            int n4 = Character.codePointAt(string, n2);
            for (int i2 = 0; i2 < this._gmtOffsetDigits.length; ++i2) {
                if (n4 != this._gmtOffsetDigits[i2].codePointAt(0)) continue;
                n3 = i2;
                break;
            }
            if (n3 < 0) {
                n3 = UCharacter.digit(n4);
            }
            if (n3 >= 0) {
                nArray[0] = Character.charCount(n4);
            }
        }
        return n3;
    }

    private static String[] toCodePoints(String string) {
        int n2 = string.codePointCount(0, string.length());
        String[] stringArray = new String[n2];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = string.codePointAt(n3);
            int n5 = Character.charCount(n4);
            stringArray[i2] = string.substring(n3, n3 + n5);
            n3 += n5;
        }
        return stringArray;
    }

    private static int parseOffsetISO8601(String string, ParsePosition parsePosition, boolean bl2, Output<Boolean> output) {
        int n2;
        int n3;
        if (output != null) {
            output.value = false;
        }
        if ((n3 = parsePosition.getIndex()) >= string.length()) {
            parsePosition.setErrorIndex(n3);
            return 0;
        }
        char c2 = string.charAt(n3);
        if (Character.toUpperCase(c2) == ISO8601_UTC.charAt(0)) {
            parsePosition.setIndex(n3 + 1);
            return 0;
        }
        if (c2 == '+') {
            n2 = 1;
        } else if (c2 == '-') {
            n2 = -1;
        } else {
            parsePosition.setErrorIndex(n3);
            return 0;
        }
        ParsePosition parsePosition2 = new ParsePosition(n3 + 1);
        int n4 = TimeZoneFormat.parseAsciiOffsetFields(string, parsePosition2, ':', OffsetFields.H, OffsetFields.HMS);
        if (parsePosition2.getErrorIndex() == -1 && !bl2 && parsePosition2.getIndex() - n3 <= 3) {
            ParsePosition parsePosition3 = new ParsePosition(n3 + 1);
            int n5 = TimeZoneFormat.parseAbuttingAsciiOffsetFields(string, parsePosition3, OffsetFields.H, OffsetFields.HMS, false);
            if (parsePosition3.getErrorIndex() == -1 && parsePosition3.getIndex() > parsePosition2.getIndex()) {
                n4 = n5;
                parsePosition2.setIndex(parsePosition3.getIndex());
            }
        }
        if (parsePosition2.getErrorIndex() != -1) {
            parsePosition.setErrorIndex(n3);
            return 0;
        }
        parsePosition.setIndex(parsePosition2.getIndex());
        if (output != null) {
            output.value = true;
        }
        return n2 * n4;
    }

    private static int parseAbuttingAsciiOffsetFields(String string, ParsePosition parsePosition, OffsetFields offsetFields, OffsetFields offsetFields2, boolean bl2) {
        int n2;
        int n3 = parsePosition.getIndex();
        int n4 = 2 * (offsetFields.ordinal() + 1) - (bl2 ? 0 : 1);
        int n5 = 2 * (offsetFields2.ordinal() + 1);
        int[] nArray = new int[n5];
        int n6 = 0;
        for (int i2 = n3; n6 < nArray.length && i2 < string.length() && (n2 = ASCII_DIGITS.indexOf(string.charAt(i2))) >= 0; ++n6, ++i2) {
            nArray[n6] = n2;
        }
        if (bl2 && (n6 & 1) != 0) {
            --n6;
        }
        if (n6 < n4) {
            parsePosition.setErrorIndex(n3);
            return 0;
        }
        n2 = 0;
        int n7 = 0;
        int n8 = 0;
        boolean bl3 = false;
        while (n6 >= n4) {
            switch (n6) {
                case 1: {
                    n2 = nArray[0];
                    break;
                }
                case 2: {
                    n2 = nArray[0] * 10 + nArray[1];
                    break;
                }
                case 3: {
                    n2 = nArray[0];
                    n7 = nArray[1] * 10 + nArray[2];
                    break;
                }
                case 4: {
                    n2 = nArray[0] * 10 + nArray[1];
                    n7 = nArray[2] * 10 + nArray[3];
                    break;
                }
                case 5: {
                    n2 = nArray[0];
                    n7 = nArray[1] * 10 + nArray[2];
                    n8 = nArray[3] * 10 + nArray[4];
                    break;
                }
                case 6: {
                    n2 = nArray[0] * 10 + nArray[1];
                    n7 = nArray[2] * 10 + nArray[3];
                    n8 = nArray[4] * 10 + nArray[5];
                }
            }
            if (n2 <= 23 && n7 <= 59 && n8 <= 59) {
                bl3 = true;
                break;
            }
            n6 -= bl2 ? 2 : 1;
            n8 = 0;
            n7 = 0;
            n2 = 0;
        }
        if (!bl3) {
            parsePosition.setErrorIndex(n3);
            return 0;
        }
        parsePosition.setIndex(n3 + n6);
        return ((n2 * 60 + n7) * 60 + n8) * 1000;
    }

    private static int parseAsciiOffsetFields(String string, ParsePosition parsePosition, char c2, OffsetFields offsetFields, OffsetFields offsetFields2) {
        int n2;
        int n3 = parsePosition.getIndex();
        int[] nArray = new int[]{0, 0, 0};
        int[] nArray2 = new int[]{0, -1, -1};
        int n4 = 0;
        for (n2 = n3; n2 < string.length() && n4 <= offsetFields2.ordinal(); ++n2) {
            int n5;
            char c3 = string.charAt(n2);
            if (c3 == c2) {
                if (n4 == 0) {
                    if (nArray2[0] == 0) break;
                    ++n4;
                    continue;
                }
                if (nArray2[n4] != -1) break;
                nArray2[n4] = 0;
                continue;
            }
            if (nArray2[n4] == -1 || (n5 = ASCII_DIGITS.indexOf(c3)) < 0) break;
            nArray[n4] = nArray[n4] * 10 + n5;
            int n6 = n4;
            nArray2[n6] = nArray2[n6] + 1;
            if (nArray2[n4] < 2) continue;
            ++n4;
        }
        n2 = 0;
        n4 = 0;
        Enum enum_ = null;
        if (nArray2[0] != 0) {
            if (nArray[0] > 23) {
                n2 = nArray[0] / 10 * 3600000;
                enum_ = OffsetFields.H;
                n4 = 1;
            } else {
                n2 = nArray[0] * 3600000;
                n4 = nArray2[0];
                enum_ = OffsetFields.H;
                if (nArray2[1] == 2 && nArray[1] <= 59) {
                    n2 += nArray[1] * 60000;
                    n4 += 1 + nArray2[1];
                    enum_ = OffsetFields.HM;
                    if (nArray2[2] == 2 && nArray[2] <= 59) {
                        n2 += nArray[2] * 1000;
                        n4 += 1 + nArray2[2];
                        enum_ = OffsetFields.HMS;
                    }
                }
            }
        }
        if (enum_ == null || enum_.ordinal() < offsetFields.ordinal()) {
            parsePosition.setErrorIndex(n3);
            return 0;
        }
        parsePosition.setIndex(n3 + n4);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static String parseZoneID(String string, ParsePosition parsePosition) {
        Iterator<String> iterator;
        Object object;
        String string2 = null;
        if (ZONE_ID_TRIE == null) {
            object = TimeZoneFormat.class;
            // MONITORENTER : macromedia.jdbc.db2.externals.com.ibm.icu.text.TimeZoneFormat.class
            if (ZONE_ID_TRIE == null) {
                String[] stringArray;
                iterator = new TextTrieMap(true);
                for (String string3 : stringArray = TimeZone.getAvailableIDs()) {
                    ((TextTrieMap)((Object)iterator)).put(string3, string3);
                }
                ZONE_ID_TRIE = iterator;
            }
            // MONITOREXIT : object
        }
        object = new TextTrieMap.Output();
        iterator = ZONE_ID_TRIE.get(string, parsePosition.getIndex(), (TextTrieMap.Output)object);
        if (iterator != null) {
            string2 = (String)iterator.next();
            parsePosition.setIndex(parsePosition.getIndex() + ((TextTrieMap.Output)object).matchLength);
            return string2;
        }
        parsePosition.setErrorIndex(parsePosition.getIndex());
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static String parseShortZoneID(String string, ParsePosition parsePosition) {
        Iterator<String> iterator;
        Object object;
        String string2 = null;
        if (SHORT_ZONE_ID_TRIE == null) {
            object = TimeZoneFormat.class;
            // MONITORENTER : macromedia.jdbc.db2.externals.com.ibm.icu.text.TimeZoneFormat.class
            if (SHORT_ZONE_ID_TRIE == null) {
                iterator = new TextTrieMap(true);
                Set<String> set = TimeZone.getAvailableIDs(TimeZone.SystemTimeZoneType.CANONICAL, null, null);
                for (String string3 : set) {
                    String string4 = ZoneMeta.getShortID(string3);
                    if (string4 == null) continue;
                    ((TextTrieMap)((Object)iterator)).put(string4, string3);
                }
                ((TextTrieMap)((Object)iterator)).put(UNKNOWN_SHORT_ZONE_ID, UNKNOWN_ZONE_ID);
                SHORT_ZONE_ID_TRIE = iterator;
            }
            // MONITOREXIT : object
        }
        object = new TextTrieMap.Output();
        iterator = SHORT_ZONE_ID_TRIE.get(string, parsePosition.getIndex(), (TextTrieMap.Output)object);
        if (iterator != null) {
            string2 = (String)iterator.next();
            parsePosition.setIndex(parsePosition.getIndex() + ((TextTrieMap.Output)object).matchLength);
            return string2;
        }
        parsePosition.setErrorIndex(parsePosition.getIndex());
        return string2;
    }

    private String parseExemplarLocation(String string, ParsePosition parsePosition) {
        int n2 = parsePosition.getIndex();
        int n3 = -1;
        String string2 = null;
        EnumSet<TimeZoneNames.NameType> enumSet = EnumSet.of(TimeZoneNames.NameType.EXEMPLAR_LOCATION);
        Collection<TimeZoneNames.MatchInfo> collection = this._tznames.find(string, n2, enumSet);
        if (collection != null) {
            TimeZoneNames.MatchInfo matchInfo = null;
            for (TimeZoneNames.MatchInfo matchInfo2 : collection) {
                if (n2 + matchInfo2.matchLength() <= n3) continue;
                matchInfo = matchInfo2;
                n3 = n2 + matchInfo2.matchLength();
            }
            if (matchInfo != null) {
                string2 = this.getTimeZoneID(matchInfo.tzID(), matchInfo.mzID());
                parsePosition.setIndex(n3);
            }
        }
        if (string2 == null) {
            parsePosition.setErrorIndex(n2);
        }
        return string2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("_locale", this._locale);
        putField.put("_tznames", this._tznames);
        putField.put("_gmtPattern", this._gmtPattern);
        putField.put("_gmtOffsetPatterns", this._gmtOffsetPatterns);
        putField.put("_gmtOffsetDigits", this._gmtOffsetDigits);
        putField.put("_gmtZeroFormat", this._gmtZeroFormat);
        putField.put("_parseAllStyles", this._parseAllStyles);
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this._locale = (ULocale)getField.get("_locale", null);
        if (this._locale == null) {
            throw new InvalidObjectException("Missing field: locale");
        }
        this._tznames = (TimeZoneNames)getField.get("_tznames", null);
        if (this._tznames == null) {
            throw new InvalidObjectException("Missing field: tznames");
        }
        this._gmtPattern = (String)getField.get("_gmtPattern", null);
        if (this._gmtPattern == null) {
            throw new InvalidObjectException("Missing field: gmtPattern");
        }
        String[] stringArray = (String[])getField.get("_gmtOffsetPatterns", null);
        if (stringArray == null) {
            throw new InvalidObjectException("Missing field: gmtOffsetPatterns");
        }
        if (stringArray.length < 4) {
            throw new InvalidObjectException("Incompatible field: gmtOffsetPatterns");
        }
        this._gmtOffsetPatterns = new String[6];
        if (stringArray.length == 4) {
            for (int i2 = 0; i2 < 4; ++i2) {
                this._gmtOffsetPatterns[i2] = stringArray[i2];
            }
            this._gmtOffsetPatterns[GMTOffsetPatternType.POSITIVE_H.ordinal()] = TimeZoneFormat.truncateOffsetPattern(this._gmtOffsetPatterns[GMTOffsetPatternType.POSITIVE_HM.ordinal()]);
            this._gmtOffsetPatterns[GMTOffsetPatternType.NEGATIVE_H.ordinal()] = TimeZoneFormat.truncateOffsetPattern(this._gmtOffsetPatterns[GMTOffsetPatternType.NEGATIVE_HM.ordinal()]);
        } else {
            this._gmtOffsetPatterns = stringArray;
        }
        this._gmtOffsetDigits = (String[])getField.get("_gmtOffsetDigits", null);
        if (this._gmtOffsetDigits == null) {
            throw new InvalidObjectException("Missing field: gmtOffsetDigits");
        }
        if (this._gmtOffsetDigits.length != 10) {
            throw new InvalidObjectException("Incompatible field: gmtOffsetDigits");
        }
        this._gmtZeroFormat = (String)getField.get("_gmtZeroFormat", null);
        if (this._gmtZeroFormat == null) {
            throw new InvalidObjectException("Missing field: gmtZeroFormat");
        }
        this._parseAllStyles = getField.get("_parseAllStyles", false);
        if (getField.defaulted("_parseAllStyles")) {
            throw new InvalidObjectException("Missing field: parseAllStyles");
        }
        if (this._tznames instanceof TimeZoneNamesImpl) {
            this._tznames = TimeZoneNames.getInstance(this._locale);
            this._gnames = null;
        } else {
            this._gnames = new TimeZoneGenericNames(this._locale, this._tznames);
        }
        this.initGMTPattern(this._gmtPattern);
        this.initGMTOffsetPatterns(this._gmtOffsetPatterns);
    }

    @Override
    public boolean isFrozen() {
        return this._frozen;
    }

    @Override
    public TimeZoneFormat freeze() {
        this._frozen = true;
        return this;
    }

    @Override
    public TimeZoneFormat cloneAsThawed() {
        TimeZoneFormat timeZoneFormat = (TimeZoneFormat)super.clone();
        timeZoneFormat._frozen = false;
        return timeZoneFormat;
    }

    static {
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("_locale", ULocale.class), new ObjectStreamField("_tznames", TimeZoneNames.class), new ObjectStreamField("_gmtPattern", String.class), new ObjectStreamField("_gmtOffsetPatterns", String[].class), new ObjectStreamField("_gmtOffsetDigits", String[].class), new ObjectStreamField("_gmtZeroFormat", String.class), new ObjectStreamField("_parseAllStyles", Boolean.TYPE)};
    }

    private static class TimeZoneFormatCache
    extends SoftCache<ULocale, TimeZoneFormat, ULocale> {
        private TimeZoneFormatCache() {
        }

        @Override
        protected TimeZoneFormat createInstance(ULocale uLocale, ULocale uLocale2) {
            TimeZoneFormat timeZoneFormat = new TimeZoneFormat(uLocale2);
            timeZoneFormat.freeze();
            return timeZoneFormat;
        }
    }

    private static class GMTOffsetField {
        final char _type;
        final int _width;

        GMTOffsetField(char c2, int n2) {
            this._type = c2;
            this._width = n2;
        }

        char getType() {
            return this._type;
        }

        int getWidth() {
            return this._width;
        }

        static boolean isValid(char c2, int n2) {
            return n2 == 1 || n2 == 2;
        }
    }

    private static enum OffsetFields {
        H,
        HM,
        HMS;

    }

    public static enum ParseOption {
        ALL_STYLES,
        TZ_DATABASE_ABBREVIATIONS;

    }

    public static enum TimeType {
        UNKNOWN,
        STANDARD,
        DAYLIGHT;

    }

    public static enum GMTOffsetPatternType {
        POSITIVE_HM("+H:mm", "Hm", true),
        POSITIVE_HMS("+H:mm:ss", "Hms", true),
        NEGATIVE_HM("-H:mm", "Hm", false),
        NEGATIVE_HMS("-H:mm:ss", "Hms", false),
        POSITIVE_H("+H", "H", true),
        NEGATIVE_H("-H", "H", false);

        private String _defaultPattern;
        private String _required;
        private boolean _isPositive;

        private GMTOffsetPatternType(String string2, String string3, boolean bl2) {
            this._defaultPattern = string2;
            this._required = string3;
            this._isPositive = bl2;
        }

        private String defaultPattern() {
            return this._defaultPattern;
        }

        private String required() {
            return this._required;
        }

        private boolean isPositive() {
            return this._isPositive;
        }
    }

    public static enum Style {
        GENERIC_LOCATION(1),
        GENERIC_LONG(2),
        GENERIC_SHORT(4),
        SPECIFIC_LONG(8),
        SPECIFIC_SHORT(16),
        LOCALIZED_GMT(32),
        LOCALIZED_GMT_SHORT(64),
        ISO_BASIC_SHORT(128),
        ISO_BASIC_LOCAL_SHORT(256),
        ISO_BASIC_FIXED(128),
        ISO_BASIC_LOCAL_FIXED(256),
        ISO_BASIC_FULL(128),
        ISO_BASIC_LOCAL_FULL(256),
        ISO_EXTENDED_FIXED(128),
        ISO_EXTENDED_LOCAL_FIXED(256),
        ISO_EXTENDED_FULL(128),
        ISO_EXTENDED_LOCAL_FULL(256),
        ZONE_ID(512),
        ZONE_ID_SHORT(1024),
        EXEMPLAR_LOCATION(2048);

        final int flag;

        private Style(int n3) {
            this.flag = n3;
        }
    }
}

