/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Locale;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.BreakIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.CollationElementIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Collator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Normalizer;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Normalizer2;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.RuleBasedCollator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.SearchIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUException;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public final class StringSearch
extends SearchIterator {
    private Pattern pattern_;
    private RuleBasedCollator collator_;
    private CollationElementIterator textIter_;
    private CollationPCE textProcessedIter_;
    private CollationElementIterator utilIter_;
    private Normalizer2 nfd_;
    private int strength_;
    int ceMask_;
    int variableTop_;
    private boolean toShift_;
    private static final int INITIAL_ARRAY_SIZE_ = 256;
    private static final int PRIMARYORDERMASK = -65536;
    private static final int SECONDARYORDERMASK = 65280;
    private static final int TERTIARYORDERMASK = 255;
    private static final int CE_MATCH = -1;
    private static final int CE_NO_MATCH = 0;
    private static final int CE_SKIP_TARG = 1;
    private static final int CE_SKIP_PATN = 2;
    private static int CE_LEVEL2_BASE = 5;
    private static int CE_LEVEL3_BASE = 327680;

    public StringSearch(String string, CharacterIterator characterIterator, RuleBasedCollator ruleBasedCollator, BreakIterator breakIterator) {
        super(characterIterator, breakIterator);
        if (ruleBasedCollator.getNumericCollation()) {
            throw new UnsupportedOperationException("Numeric collation is not supported by StringSearch");
        }
        this.collator_ = ruleBasedCollator;
        this.strength_ = ruleBasedCollator.getStrength();
        this.ceMask_ = StringSearch.getMask(this.strength_);
        this.toShift_ = ruleBasedCollator.isAlternateHandlingShifted();
        this.variableTop_ = ruleBasedCollator.getVariableTop();
        this.nfd_ = Normalizer2.getNFDInstance();
        this.pattern_ = new Pattern(string);
        this.search_.setMatchedLength(0);
        this.search_.matchedIndex_ = -1;
        this.utilIter_ = null;
        this.textIter_ = new CollationElementIterator(characterIterator, ruleBasedCollator);
        this.textProcessedIter_ = null;
        ULocale uLocale = ruleBasedCollator.getLocale(ULocale.VALID_LOCALE);
        this.search_.internalBreakIter_ = BreakIterator.getCharacterInstance(uLocale == null ? ULocale.ROOT : uLocale);
        this.search_.internalBreakIter_.setText((CharacterIterator)characterIterator.clone());
        this.initialize();
    }

    public StringSearch(String string, CharacterIterator characterIterator, RuleBasedCollator ruleBasedCollator) {
        this(string, characterIterator, ruleBasedCollator, null);
    }

    public StringSearch(String string, CharacterIterator characterIterator, Locale locale) {
        this(string, characterIterator, ULocale.forLocale(locale));
    }

    public StringSearch(String string, CharacterIterator characterIterator, ULocale uLocale) {
        this(string, characterIterator, (RuleBasedCollator)Collator.getInstance(uLocale), null);
    }

    public StringSearch(String string, String string2) {
        this(string, new StringCharacterIterator(string2), (RuleBasedCollator)Collator.getInstance(), null);
    }

    public RuleBasedCollator getCollator() {
        return this.collator_;
    }

    public void setCollator(RuleBasedCollator ruleBasedCollator) {
        if (ruleBasedCollator == null) {
            throw new IllegalArgumentException("Collator can not be null");
        }
        this.collator_ = ruleBasedCollator;
        this.ceMask_ = StringSearch.getMask(this.collator_.getStrength());
        ULocale uLocale = ruleBasedCollator.getLocale(ULocale.VALID_LOCALE);
        this.search_.internalBreakIter_ = BreakIterator.getCharacterInstance(uLocale == null ? ULocale.ROOT : uLocale);
        this.search_.internalBreakIter_.setText((CharacterIterator)this.search_.text().clone());
        this.toShift_ = ruleBasedCollator.isAlternateHandlingShifted();
        this.variableTop_ = ruleBasedCollator.getVariableTop();
        this.textIter_ = new CollationElementIterator(this.pattern_.text_, ruleBasedCollator);
        this.utilIter_ = new CollationElementIterator(this.pattern_.text_, ruleBasedCollator);
        this.initialize();
    }

    public String getPattern() {
        return this.pattern_.text_;
    }

    public void setPattern(String string) {
        if (string == null || string.length() <= 0) {
            throw new IllegalArgumentException("Pattern to search for can not be null or of length 0");
        }
        this.pattern_.text_ = string;
        this.initialize();
    }

    public boolean isCanonical() {
        return this.search_.isCanonicalMatch_;
    }

    public void setCanonical(boolean bl2) {
        this.search_.isCanonicalMatch_ = bl2;
    }

    @Override
    public void setTarget(CharacterIterator characterIterator) {
        super.setTarget(characterIterator);
        this.textIter_.setText(characterIterator);
    }

    @Override
    public int getIndex() {
        int n2 = this.textIter_.getOffset();
        if (StringSearch.isOutOfBounds(this.search_.beginIndex(), this.search_.endIndex(), n2)) {
            return -1;
        }
        return n2;
    }

    @Override
    public void setIndex(int n2) {
        super.setIndex(n2);
        this.textIter_.setOffset(n2);
    }

    @Override
    public void reset() {
        int n2;
        boolean bl2;
        boolean bl3 = true;
        int n3 = this.collator_.getStrength();
        if (this.strength_ < 3 && n3 >= 3 || this.strength_ >= 3 && n3 < 3) {
            bl3 = false;
        }
        this.strength_ = this.collator_.getStrength();
        int n4 = StringSearch.getMask(this.strength_);
        if (this.ceMask_ != n4) {
            this.ceMask_ = n4;
            bl3 = false;
        }
        if (this.toShift_ != (bl2 = this.collator_.isAlternateHandlingShifted())) {
            this.toShift_ = bl2;
            bl3 = false;
        }
        if (this.variableTop_ != (n2 = this.collator_.getVariableTop())) {
            this.variableTop_ = n2;
            bl3 = false;
        }
        if (!bl3) {
            this.initialize();
        }
        this.textIter_.setText(this.search_.text());
        this.search_.setMatchedLength(0);
        this.search_.matchedIndex_ = -1;
        this.search_.isOverlap_ = false;
        this.search_.isCanonicalMatch_ = false;
        this.search_.elementComparisonType_ = SearchIterator.ElementComparisonType.STANDARD_ELEMENT_COMPARISON;
        this.search_.isForwardSearching_ = true;
        this.search_.reset_ = true;
    }

    @Override
    protected int handleNext(int n2) {
        if (this.pattern_.CELength_ == 0) {
            this.search_.matchedIndex_ = this.search_.matchedIndex_ == -1 ? this.getIndex() : this.search_.matchedIndex_ + 1;
            this.search_.setMatchedLength(0);
            this.textIter_.setOffset(this.search_.matchedIndex_);
            if (this.search_.matchedIndex_ == this.search_.endIndex()) {
                this.search_.matchedIndex_ = -1;
            }
        } else {
            if (this.search_.matchedLength() <= 0) {
                this.search_.matchedIndex_ = n2 - 1;
            }
            this.textIter_.setOffset(n2);
            if (this.search_.isCanonicalMatch_) {
                this.handleNextCanonical();
            } else {
                this.handleNextExact();
            }
            if (this.search_.matchedIndex_ == -1) {
                this.textIter_.setOffset(this.search_.endIndex());
            } else {
                this.textIter_.setOffset(this.search_.matchedIndex_);
            }
            return this.search_.matchedIndex_;
        }
        return -1;
    }

    @Override
    protected int handlePrevious(int n2) {
        if (this.pattern_.CELength_ == 0) {
            int n3 = this.search_.matchedIndex_ = this.search_.matchedIndex_ == -1 ? this.getIndex() : this.search_.matchedIndex_;
            if (this.search_.matchedIndex_ == this.search_.beginIndex()) {
                this.setMatchNotFound();
            } else {
                --this.search_.matchedIndex_;
                this.textIter_.setOffset(this.search_.matchedIndex_);
                this.search_.setMatchedLength(0);
            }
        } else {
            this.textIter_.setOffset(n2);
            if (this.search_.isCanonicalMatch_) {
                this.handlePreviousCanonical();
            } else {
                this.handlePreviousExact();
            }
        }
        return this.search_.matchedIndex_;
    }

    private static int getMask(int n2) {
        switch (n2) {
            case 0: {
                return -65536;
            }
            case 1: {
                return -256;
            }
        }
        return -1;
    }

    private int getCE(int n2) {
        n2 &= this.ceMask_;
        if (this.toShift_) {
            if (this.variableTop_ > n2) {
                n2 = this.strength_ >= 3 ? (n2 &= 0xFFFF0000) : 0;
            }
        } else if (this.strength_ >= 3 && n2 == 0) {
            n2 = 65535;
        }
        return n2;
    }

    private static int[] addToIntArray(int[] nArray, int n2, int n3, int n4) {
        int n5 = nArray.length;
        if (n2 + 1 == n5) {
            int[] nArray2 = new int[n5 += n4];
            System.arraycopy(nArray, 0, nArray2, 0, n2);
            nArray = nArray2;
        }
        nArray[n2] = n3;
        return nArray;
    }

    private static long[] addToLongArray(long[] lArray, int n2, int n3, long l2, int n4) {
        int n5 = n3;
        if (n2 + 1 == n5) {
            long[] lArray2 = new long[n5 += n4];
            System.arraycopy(lArray, 0, lArray2, 0, n2);
            lArray = lArray2;
        }
        lArray[n2] = l2;
        return lArray;
    }

    private int initializePatternCETable() {
        int n2;
        int[] nArray = new int[256];
        int n3 = this.pattern_.text_.length();
        CollationElementIterator collationElementIterator = this.utilIter_;
        if (collationElementIterator == null) {
            this.utilIter_ = collationElementIterator = new CollationElementIterator(this.pattern_.text_, this.collator_);
        } else {
            collationElementIterator.setText(this.pattern_.text_);
        }
        int n4 = 0;
        int n5 = 0;
        while ((n2 = collationElementIterator.next()) != -1) {
            int n6 = this.getCE(n2);
            if (n6 != 0) {
                int[] nArray2 = StringSearch.addToIntArray(nArray, n4, n6, n3 - collationElementIterator.getOffset() + 1);
                ++n4;
                nArray = nArray2;
            }
            n5 += collationElementIterator.getMaxExpansion(n2) - 1;
        }
        nArray[n4] = 0;
        this.pattern_.CE_ = nArray;
        this.pattern_.CELength_ = n4;
        return n5;
    }

    private int initializePatternPCETable() {
        long l2;
        long[] lArray = new long[256];
        int n2 = lArray.length;
        int n3 = this.pattern_.text_.length();
        CollationElementIterator collationElementIterator = this.utilIter_;
        if (collationElementIterator == null) {
            this.utilIter_ = collationElementIterator = new CollationElementIterator(this.pattern_.text_, this.collator_);
        } else {
            collationElementIterator.setText(this.pattern_.text_);
        }
        int n4 = 0;
        int n5 = 0;
        CollationPCE collationPCE = new CollationPCE(collationElementIterator);
        while ((l2 = collationPCE.nextProcessed(null)) != -1L) {
            long[] lArray2 = StringSearch.addToLongArray(lArray, n4, n2, l2, n3 - collationElementIterator.getOffset() + 1);
            ++n4;
            lArray = lArray2;
        }
        lArray[n4] = 0L;
        this.pattern_.PCE_ = lArray;
        this.pattern_.PCELength_ = n4;
        return n5;
    }

    private int initializePattern() {
        this.pattern_.PCE_ = null;
        return this.initializePatternCETable();
    }

    private void initialize() {
        this.initializePattern();
    }

    @Override
    @Deprecated
    protected void setMatchNotFound() {
        super.setMatchNotFound();
        if (this.search_.isForwardSearching_) {
            this.textIter_.setOffset(this.search_.text().getEndIndex());
        } else {
            this.textIter_.setOffset(0);
        }
    }

    private static final boolean isOutOfBounds(int n2, int n3, int n4) {
        return n4 < n2 || n4 > n3;
    }

    private boolean checkIdentical(int n2, int n3) {
        String string;
        if (this.strength_ != 15) {
            return true;
        }
        String string2 = StringSearch.getString(this.targetText, n2, n3 - n2);
        if (Normalizer.quickCheck(string2, Normalizer.NFD, 0) == Normalizer.NO) {
            string2 = Normalizer.decompose(string2, false);
        }
        if (Normalizer.quickCheck(string = this.pattern_.text_, Normalizer.NFD, 0) == Normalizer.NO) {
            string = Normalizer.decompose(string, false);
        }
        return string2.equals(string);
    }

    private boolean initTextProcessedIter() {
        if (this.textProcessedIter_ == null) {
            this.textProcessedIter_ = new CollationPCE(this.textIter_);
        } else {
            this.textProcessedIter_.init(this.textIter_);
        }
        return true;
    }

    private int nextBoundaryAfter(int n2) {
        BreakIterator breakIterator = this.search_.breakIter();
        if (breakIterator == null) {
            breakIterator = this.search_.internalBreakIter_;
        }
        if (breakIterator != null) {
            return breakIterator.following(n2);
        }
        return n2;
    }

    private boolean isBreakBoundary(int n2) {
        BreakIterator breakIterator = this.search_.breakIter();
        if (breakIterator == null) {
            breakIterator = this.search_.internalBreakIter_;
        }
        return breakIterator != null && breakIterator.isBoundary(n2);
    }

    private static int compareCE64s(long l2, long l3, SearchIterator.ElementComparisonType elementComparisonType) {
        if (l2 == l3) {
            return -1;
        }
        if (elementComparisonType == SearchIterator.ElementComparisonType.STANDARD_ELEMENT_COMPARISON) {
            return 0;
        }
        long l4 = l2 >>> 32;
        long l5 = 0xFFFF0000L;
        int n2 = (int)(l4 & l5);
        long l6 = l3 >>> 32;
        int n3 = (int)(l6 & l5);
        if (n2 != n3) {
            if (n2 == 0) {
                return 1;
            }
            if (n3 == 0 && elementComparisonType == SearchIterator.ElementComparisonType.ANY_BASE_WEIGHT_IS_WILDCARD) {
                return 2;
            }
            return 0;
        }
        l5 = 65535L;
        int n4 = (int)(l4 & l5);
        int n5 = (int)(l6 & l5);
        if (n4 != n5) {
            if (n4 == 0) {
                return 1;
            }
            if (n5 == 0 && elementComparisonType == SearchIterator.ElementComparisonType.ANY_BASE_WEIGHT_IS_WILDCARD) {
                return 2;
            }
            return n5 == CE_LEVEL2_BASE || elementComparisonType == SearchIterator.ElementComparisonType.ANY_BASE_WEIGHT_IS_WILDCARD && n4 == CE_LEVEL2_BASE ? -1 : 0;
        }
        l5 = 0xFFFF0000L;
        int n6 = (int)(l2 & l5);
        int n7 = (int)(l3 & l5);
        if (n6 != n7) {
            return n7 == CE_LEVEL3_BASE || elementComparisonType == SearchIterator.ElementComparisonType.ANY_BASE_WEIGHT_IS_WILDCARD && n6 == CE_LEVEL3_BASE ? -1 : 0;
        }
        return -1;
    }

    private boolean search(int n2, Match match) {
        boolean bl2;
        if (this.pattern_.CELength_ == 0 || n2 < this.search_.beginIndex() || n2 > this.search_.endIndex()) {
            throw new IllegalArgumentException("search(" + n2 + ", m) - expected position to be between " + this.search_.beginIndex() + " and " + this.search_.endIndex());
        }
        if (this.pattern_.PCE_ == null) {
            this.initializePatternPCETable();
        }
        this.textIter_.setOffset(n2);
        CEBuffer cEBuffer = new CEBuffer(this);
        int n3 = 0;
        CEI cEI = null;
        int n4 = -1;
        int n5 = -1;
        n3 = 0;
        while (true) {
            bl2 = true;
            int n6 = 0;
            long l2 = 0L;
            CEI cEI2 = cEBuffer.get(n3);
            if (cEI2 == null) {
                throw new ICUException("CEBuffer.get(" + n3 + ") returned null.");
            }
            for (int i2 = 0; i2 < this.pattern_.PCELength_; ++i2) {
                l2 = this.pattern_.PCE_[i2];
                cEI = cEBuffer.get(n3 + i2 + n6);
                int n7 = StringSearch.compareCE64s(cEI.ce_, l2, this.search_.elementComparisonType_);
                if (n7 == 0) {
                    bl2 = false;
                    break;
                }
                if (n7 <= 0) continue;
                if (n7 == 1) {
                    --i2;
                    ++n6;
                    continue;
                }
                --n6;
            }
            n6 += this.pattern_.PCELength_;
            if (bl2 || cEI != null && cEI.ce_ == -1L) {
                int n8;
                int n9;
                if (!bl2) break;
                CEI cEI3 = cEBuffer.get(n3 + n6 - 1);
                n4 = cEI2.lowIndex_;
                int n10 = cEI3.lowIndex_;
                CEI cEI4 = null;
                if (this.search_.elementComparisonType_ == SearchIterator.ElementComparisonType.STANDARD_ELEMENT_COMPARISON) {
                    cEI4 = cEBuffer.get(n3 + n6);
                    n9 = cEI4.lowIndex_;
                    if (cEI4.lowIndex_ == cEI4.highIndex_ && cEI4.ce_ != -1L) {
                        bl2 = false;
                    }
                } else {
                    while (true) {
                        cEI4 = cEBuffer.get(n3 + n6);
                        n9 = cEI4.lowIndex_;
                        if (cEI4.ce_ == -1L) break;
                        if ((cEI4.ce_ >>> 32 & 0xFFFF0000L) == 0L) {
                            n8 = StringSearch.compareCE64s(cEI4.ce_, l2, this.search_.elementComparisonType_);
                            if (n8 == 0 || n8 == 2) {
                                bl2 = false;
                                break;
                            }
                        } else {
                            if (cEI4.lowIndex_ != cEI4.highIndex_) break;
                            bl2 = false;
                            break;
                        }
                        ++n6;
                    }
                }
                if (!this.isBreakBoundary(n4)) {
                    bl2 = false;
                }
                if (n4 == (n8 = cEI2.highIndex_)) {
                    bl2 = false;
                }
                boolean bl3 = this.breakIterator == null && (cEI4.ce_ >>> 32 & 0xFFFF0000L) != 0L && n9 >= cEI3.highIndex_ && cEI4.highIndex_ > n9 && (this.nfd_.hasBoundaryBefore(StringSearch.codePointAt(this.targetText, n9)) || this.nfd_.hasBoundaryAfter(StringSearch.codePointBefore(this.targetText, n9)));
                n5 = n9;
                if (n10 < n9) {
                    if (n10 == cEI3.highIndex_ && this.isBreakBoundary(n10)) {
                        n5 = n10;
                    } else {
                        int n11 = this.nextBoundaryAfter(n10);
                        if (!(n11 < cEI3.highIndex_ || bl3 && n11 >= n9)) {
                            n5 = n11;
                        }
                    }
                }
                if (!bl3) {
                    if (n5 > n9) {
                        bl2 = false;
                    }
                    if (!this.isBreakBoundary(n5)) {
                        bl2 = false;
                    }
                }
                if (!this.checkIdentical(n4, n5)) {
                    bl2 = false;
                }
                if (bl2) break;
            }
            ++n3;
        }
        if (!bl2) {
            n5 = -1;
            n4 = -1;
        }
        if (match != null) {
            match.start_ = n4;
            match.limit_ = n5;
        }
        return bl2;
    }

    private static int codePointAt(CharacterIterator characterIterator, int n2) {
        char c2;
        int n3;
        int n4 = characterIterator.getIndex();
        int n5 = n3 = characterIterator.setIndex(n2);
        if (Character.isHighSurrogate((char)n3) && Character.isLowSurrogate(c2 = characterIterator.next())) {
            n5 = Character.toCodePoint((char)n3, c2);
        }
        characterIterator.setIndex(n4);
        return n5;
    }

    private static int codePointBefore(CharacterIterator characterIterator, int n2) {
        char c2;
        int n3;
        int n4 = characterIterator.getIndex();
        characterIterator.setIndex(n2);
        int n5 = n3 = characterIterator.previous();
        if (Character.isLowSurrogate((char)n3) && Character.isHighSurrogate(c2 = characterIterator.previous())) {
            n5 = Character.toCodePoint(c2, (char)n3);
        }
        characterIterator.setIndex(n4);
        return n5;
    }

    private boolean searchBackwards(int n2, Match match) {
        boolean bl2;
        int n3;
        Object object;
        if (this.pattern_.CELength_ == 0 || n2 < this.search_.beginIndex() || n2 > this.search_.endIndex()) {
            throw new IllegalArgumentException("searchBackwards(" + n2 + ", m) - expected position to be between " + this.search_.beginIndex() + " and " + this.search_.endIndex());
        }
        if (this.pattern_.PCE_ == null) {
            this.initializePatternPCETable();
        }
        CEBuffer cEBuffer = new CEBuffer(this);
        int n4 = 0;
        if (n2 < this.search_.endIndex()) {
            object = this.search_.internalBreakIter_;
            n3 = ((BreakIterator)object).following(n2);
            this.textIter_.setOffset(n3);
            n4 = 0;
            while (cEBuffer.getPrevious((int)n4).lowIndex_ >= n2) {
                ++n4;
            }
        } else {
            this.textIter_.setOffset(n2);
        }
        object = null;
        int n5 = n4;
        int n6 = -1;
        int n7 = -1;
        n4 = n5;
        while (true) {
            int n8;
            bl2 = true;
            CEI cEI = cEBuffer.getPrevious(n4);
            if (cEI == null) {
                throw new ICUException("CEBuffer.getPrevious(" + n4 + ") returned null.");
            }
            int n9 = 0;
            for (n3 = this.pattern_.PCELength_ - 1; n3 >= 0; --n3) {
                long l2 = this.pattern_.PCE_[n3];
                object = cEBuffer.getPrevious(n4 + this.pattern_.PCELength_ - 1 - n3 + n9);
                n8 = StringSearch.compareCE64s(((CEI)object).ce_, l2, this.search_.elementComparisonType_);
                if (n8 == 0) {
                    bl2 = false;
                    break;
                }
                if (n8 <= 0) continue;
                if (n8 == 1) {
                    ++n3;
                    ++n9;
                    continue;
                }
                --n9;
            }
            if (bl2 || object != null && ((CEI)object).ce_ == -1L) {
                int n10;
                if (!bl2) break;
                CEI cEI2 = cEBuffer.getPrevious(n4 + this.pattern_.PCELength_ - 1 + n9);
                n6 = cEI2.lowIndex_;
                if (!this.isBreakBoundary(n6)) {
                    bl2 = false;
                }
                if (n6 == cEI2.highIndex_) {
                    bl2 = false;
                }
                int n11 = cEI.lowIndex_;
                if (n4 > 0) {
                    int n12;
                    CEI cEI3 = cEBuffer.getPrevious(n4 - 1);
                    if (cEI3.lowIndex_ == cEI3.highIndex_ && cEI3.ce_ != -1L) {
                        bl2 = false;
                    }
                    n7 = n10 = cEI3.lowIndex_;
                    int n13 = n8 = this.breakIterator == null && (cEI3.ce_ >>> 32 & 0xFFFF0000L) != 0L && n10 >= cEI.highIndex_ && cEI3.highIndex_ > n10 && (this.nfd_.hasBoundaryBefore(StringSearch.codePointAt(this.targetText, n10)) || this.nfd_.hasBoundaryAfter(StringSearch.codePointBefore(this.targetText, n10))) ? 1 : 0;
                    if (n11 < n10 && (n12 = this.nextBoundaryAfter(n11)) >= cEI.highIndex_ && (n8 == 0 || n12 < n10)) {
                        n7 = n12;
                    }
                    if (n8 == 0) {
                        if (n7 > n10) {
                            bl2 = false;
                        }
                        if (!this.isBreakBoundary(n7)) {
                            bl2 = false;
                        }
                    }
                } else {
                    int n14 = this.nextBoundaryAfter(n11);
                    n10 = n14 > 0 && n2 > n14 ? n14 : n2;
                    n7 = n10;
                }
                if (!this.checkIdentical(n6, n7)) {
                    bl2 = false;
                }
                if (bl2) break;
            }
            ++n4;
        }
        if (!bl2) {
            n7 = -1;
            n6 = -1;
        }
        if (match != null) {
            match.start_ = n6;
            match.limit_ = n7;
        }
        return bl2;
    }

    private boolean handleNextExact() {
        return this.handleNextCommonImpl();
    }

    private boolean handleNextCanonical() {
        return this.handleNextCommonImpl();
    }

    private boolean handleNextCommonImpl() {
        Match match;
        int n2 = this.textIter_.getOffset();
        if (this.search(n2, match = new Match())) {
            this.search_.matchedIndex_ = match.start_;
            this.search_.setMatchedLength(match.limit_ - match.start_);
            return true;
        }
        this.setMatchNotFound();
        return false;
    }

    private boolean handlePreviousExact() {
        return this.handlePreviousCommonImpl();
    }

    private boolean handlePreviousCanonical() {
        return this.handlePreviousCommonImpl();
    }

    private boolean handlePreviousCommonImpl() {
        int n2;
        if (this.search_.isOverlap_) {
            if (this.search_.matchedIndex_ != -1) {
                n2 = this.search_.matchedIndex_ + this.search_.matchedLength() - 1;
            } else {
                long l2;
                this.initializePatternPCETable();
                if (!this.initTextProcessedIter()) {
                    this.setMatchNotFound();
                    return false;
                }
                for (int i2 = 0; i2 < this.pattern_.PCELength_ - 1 && (l2 = this.textProcessedIter_.nextProcessed(null)) != -1L; ++i2) {
                }
                n2 = this.textIter_.getOffset();
            }
        } else {
            n2 = this.textIter_.getOffset();
        }
        Match match = new Match();
        if (this.searchBackwards(n2, match)) {
            this.search_.matchedIndex_ = match.start_;
            this.search_.setMatchedLength(match.limit_ - match.start_);
            return true;
        }
        this.setMatchNotFound();
        return false;
    }

    private static final String getString(CharacterIterator characterIterator, int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder(n3);
        int n4 = characterIterator.getIndex();
        characterIterator.setIndex(n2);
        for (int i2 = 0; i2 < n3; ++i2) {
            stringBuilder.append(characterIterator.current());
            characterIterator.next();
        }
        characterIterator.setIndex(n4);
        return stringBuilder.toString();
    }

    private static class CEBuffer {
        static final int CEBUFFER_EXTRA = 32;
        static final int MAX_TARGET_IGNORABLES_PER_PAT_JAMO_L = 8;
        static final int MAX_TARGET_IGNORABLES_PER_PAT_OTHER = 3;
        CEI[] buf_;
        int bufSize_;
        int firstIx_;
        int limitIx_;
        StringSearch strSearch_;

        CEBuffer(StringSearch stringSearch) {
            String string;
            this.strSearch_ = stringSearch;
            this.bufSize_ = ((StringSearch)stringSearch).pattern_.PCELength_ + 32;
            if (stringSearch.search_.elementComparisonType_ != SearchIterator.ElementComparisonType.STANDARD_ELEMENT_COMPARISON && (string = ((StringSearch)stringSearch).pattern_.text_) != null) {
                for (int i2 = 0; i2 < string.length(); ++i2) {
                    char c2 = string.charAt(i2);
                    if (CEBuffer.MIGHT_BE_JAMO_L(c2)) {
                        this.bufSize_ += 8;
                        continue;
                    }
                    this.bufSize_ += 3;
                }
            }
            this.firstIx_ = 0;
            this.limitIx_ = 0;
            if (!stringSearch.initTextProcessedIter()) {
                return;
            }
            this.buf_ = new CEI[this.bufSize_];
        }

        CEI get(int n2) {
            int n3 = n2 % this.bufSize_;
            if (n2 >= this.firstIx_ && n2 < this.limitIx_) {
                return this.buf_[n3];
            }
            if (n2 != this.limitIx_) {
                assert (false);
                return null;
            }
            ++this.limitIx_;
            if (this.limitIx_ - this.firstIx_ >= this.bufSize_) {
                ++this.firstIx_;
            }
            CollationPCE.Range range = new CollationPCE.Range();
            if (this.buf_[n3] == null) {
                this.buf_[n3] = new CEI();
            }
            this.buf_[n3].ce_ = this.strSearch_.textProcessedIter_.nextProcessed(range);
            this.buf_[n3].lowIndex_ = range.ixLow_;
            this.buf_[n3].highIndex_ = range.ixHigh_;
            return this.buf_[n3];
        }

        CEI getPrevious(int n2) {
            int n3 = n2 % this.bufSize_;
            if (n2 >= this.firstIx_ && n2 < this.limitIx_) {
                return this.buf_[n3];
            }
            if (n2 != this.limitIx_) {
                assert (false);
                return null;
            }
            ++this.limitIx_;
            if (this.limitIx_ - this.firstIx_ >= this.bufSize_) {
                ++this.firstIx_;
            }
            CollationPCE.Range range = new CollationPCE.Range();
            if (this.buf_[n3] == null) {
                this.buf_[n3] = new CEI();
            }
            this.buf_[n3].ce_ = this.strSearch_.textProcessedIter_.previousProcessed(range);
            this.buf_[n3].lowIndex_ = range.ixLow_;
            this.buf_[n3].highIndex_ = range.ixHigh_;
            return this.buf_[n3];
        }

        static boolean MIGHT_BE_JAMO_L(char c2) {
            return c2 >= '\u1100' && c2 <= '\u115e' || c2 >= '\u3131' && c2 <= '\u314e' || c2 >= '\u3165' && c2 <= '\u3186';
        }
    }

    private static class CEI {
        long ce_;
        int lowIndex_;
        int highIndex_;

        private CEI() {
        }
    }

    private static class CollationPCE {
        public static final long PROCESSED_NULLORDER = -1L;
        private static final int DEFAULT_BUFFER_SIZE = 16;
        private static final int BUFFER_GROW = 8;
        private static final int PRIMARYORDERMASK = -65536;
        private static final int CONTINUATION_MARKER = 192;
        private PCEBuffer pceBuffer_ = new PCEBuffer();
        private CollationElementIterator cei_;
        private int strength_;
        private boolean toShift_;
        private boolean isShifted_;
        private int variableTop_;

        public CollationPCE(CollationElementIterator collationElementIterator) {
            this.init(collationElementIterator);
        }

        public void init(CollationElementIterator collationElementIterator) {
            this.cei_ = collationElementIterator;
            this.init(collationElementIterator.getRuleBasedCollator());
        }

        private void init(RuleBasedCollator ruleBasedCollator) {
            this.strength_ = ruleBasedCollator.getStrength();
            this.toShift_ = ruleBasedCollator.isAlternateHandlingShifted();
            this.isShifted_ = false;
            this.variableTop_ = ruleBasedCollator.getVariableTop();
        }

        private long processCE(int n2) {
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            long l5 = 0L;
            switch (this.strength_) {
                default: {
                    l4 = CollationElementIterator.tertiaryOrder(n2);
                }
                case 1: {
                    l3 = CollationElementIterator.secondaryOrder(n2);
                }
                case 0: 
            }
            l2 = CollationElementIterator.primaryOrder(n2);
            if (this.toShift_ && this.variableTop_ > n2 && l2 != 0L || this.isShifted_ && l2 == 0L) {
                if (l2 == 0L) {
                    return 0L;
                }
                if (this.strength_ >= 3) {
                    l5 = l2;
                }
                l4 = 0L;
                l3 = 0L;
                l2 = 0L;
                this.isShifted_ = true;
            } else {
                if (this.strength_ >= 3) {
                    l5 = 65535L;
                }
                this.isShifted_ = false;
            }
            return l2 << 48 | l3 << 32 | l4 << 16 | l5;
        }

        public long nextProcessed(Range range) {
            int n2;
            long l2 = 0L;
            int n3 = 0;
            int n4 = 0;
            this.pceBuffer_.reset();
            do {
                n3 = this.cei_.getOffset();
                n2 = this.cei_.next();
                n4 = this.cei_.getOffset();
                if (n2 != -1) continue;
                l2 = -1L;
                break;
            } while ((l2 = this.processCE(n2)) == 0L);
            if (range != null) {
                range.ixLow_ = n3;
                range.ixHigh_ = n4;
            }
            return l2;
        }

        public long previousProcessed(Range range) {
            Object object;
            long l2 = 0L;
            int n2 = 0;
            int n3 = 0;
            while (this.pceBuffer_.empty()) {
                int n4;
                object = new RCEBuffer();
                boolean bl2 = false;
                do {
                    n3 = this.cei_.getOffset();
                    n4 = this.cei_.previous();
                    n2 = this.cei_.getOffset();
                    if (n4 == -1) {
                        if (!((RCEBuffer)object).empty()) break;
                        bl2 = true;
                        break;
                    }
                    ((RCEBuffer)object).put(n4, n2, n3);
                } while ((n4 & 0xFFFF0000) == 0 || CollationPCE.isContinuation(n4));
                if (bl2) break;
                while (!((RCEBuffer)object).empty()) {
                    RCEI rCEI = ((RCEBuffer)object).get();
                    l2 = this.processCE(rCEI.ce_);
                    if (l2 == 0L) continue;
                    this.pceBuffer_.put(l2, rCEI.low_, rCEI.high_);
                }
            }
            if (this.pceBuffer_.empty()) {
                if (range != null) {
                    range.ixLow_ = -1;
                    range.ixHigh_ = -1;
                }
                return -1L;
            }
            object = this.pceBuffer_.get();
            if (range != null) {
                range.ixLow_ = ((PCEI)object).low_;
                range.ixHigh_ = ((PCEI)object).high_;
            }
            return ((PCEI)object).ce_;
        }

        private static boolean isContinuation(int n2) {
            return (n2 & 0xC0) == 192;
        }

        private static final class RCEBuffer {
            private RCEI[] buffer_ = new RCEI[16];
            private int bufferIndex_ = 0;

            private RCEBuffer() {
            }

            boolean empty() {
                return this.bufferIndex_ <= 0;
            }

            void put(int n2, int n3, int n4) {
                if (this.bufferIndex_ >= this.buffer_.length) {
                    RCEI[] rCEIArray = new RCEI[this.buffer_.length + 8];
                    System.arraycopy(this.buffer_, 0, rCEIArray, 0, this.buffer_.length);
                    this.buffer_ = rCEIArray;
                }
                this.buffer_[this.bufferIndex_] = new RCEI();
                this.buffer_[this.bufferIndex_].ce_ = n2;
                this.buffer_[this.bufferIndex_].low_ = n3;
                this.buffer_[this.bufferIndex_].high_ = n4;
                ++this.bufferIndex_;
            }

            RCEI get() {
                if (this.bufferIndex_ > 0) {
                    return this.buffer_[--this.bufferIndex_];
                }
                return null;
            }
        }

        private static final class RCEI {
            int ce_;
            int low_;
            int high_;

            private RCEI() {
            }
        }

        private static final class PCEBuffer {
            private PCEI[] buffer_ = new PCEI[16];
            private int bufferIndex_ = 0;

            private PCEBuffer() {
            }

            void reset() {
                this.bufferIndex_ = 0;
            }

            boolean empty() {
                return this.bufferIndex_ <= 0;
            }

            void put(long l2, int n2, int n3) {
                if (this.bufferIndex_ >= this.buffer_.length) {
                    PCEI[] pCEIArray = new PCEI[this.buffer_.length + 8];
                    System.arraycopy(this.buffer_, 0, pCEIArray, 0, this.buffer_.length);
                    this.buffer_ = pCEIArray;
                }
                this.buffer_[this.bufferIndex_] = new PCEI();
                this.buffer_[this.bufferIndex_].ce_ = l2;
                this.buffer_[this.bufferIndex_].low_ = n2;
                this.buffer_[this.bufferIndex_].high_ = n3;
                ++this.bufferIndex_;
            }

            PCEI get() {
                if (this.bufferIndex_ > 0) {
                    return this.buffer_[--this.bufferIndex_];
                }
                return null;
            }
        }

        private static final class PCEI {
            long ce_;
            int low_;
            int high_;

            private PCEI() {
            }
        }

        public static final class Range {
            int ixLow_;
            int ixHigh_;
        }
    }

    private static final class Pattern {
        String text_;
        long[] PCE_;
        int PCELength_ = 0;
        int[] CE_;
        int CELength_ = 0;

        protected Pattern(String string) {
            this.text_ = string;
        }
    }

    private static class Match {
        int start_ = -1;
        int limit_ = -1;

        private Match() {
        }
    }
}

