/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUBinary;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Utility;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UScript;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Bidi;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Normalizer2;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public class SpoofChecker {
    public static final UnicodeSet INCLUSION = new UnicodeSet().applyIntPropertyValue(28673, UCharacter.IdentifierType.INCLUSION.ordinal()).freeze();
    public static final UnicodeSet RECOMMENDED = new UnicodeSet().applyIntPropertyValue(28673, UCharacter.IdentifierType.RECOMMENDED.ordinal()).freeze();
    public static final int SINGLE_SCRIPT_CONFUSABLE = 1;
    public static final int MIXED_SCRIPT_CONFUSABLE = 2;
    public static final int WHOLE_SCRIPT_CONFUSABLE = 4;
    public static final int CONFUSABLE = 7;
    @Deprecated
    public static final int ANY_CASE = 8;
    public static final int RESTRICTION_LEVEL = 16;
    @Deprecated
    public static final int SINGLE_SCRIPT = 16;
    public static final int INVISIBLE = 32;
    public static final int CHAR_LIMIT = 64;
    public static final int MIXED_NUMBERS = 128;
    public static final int HIDDEN_OVERLAY = 256;
    public static final int ALL_CHECKS = -1;
    static final UnicodeSet ASCII = new UnicodeSet(0, 127).freeze();
    private int fChecks;
    private SpoofData fSpoofData;
    private Set<ULocale> fAllowedLocales;
    private UnicodeSet fAllowedCharsSet;
    private RestrictionLevel fRestrictionLevel;
    private static Normalizer2 nfdNormalizer = Normalizer2.getNFDInstance();

    private SpoofChecker() {
    }

    @Deprecated
    public RestrictionLevel getRestrictionLevel() {
        return this.fRestrictionLevel;
    }

    public int getChecks() {
        return this.fChecks;
    }

    public Set<ULocale> getAllowedLocales() {
        return Collections.unmodifiableSet(this.fAllowedLocales);
    }

    public Set<Locale> getAllowedJavaLocales() {
        HashSet<Locale> hashSet = new HashSet<Locale>(this.fAllowedLocales.size());
        for (ULocale uLocale : this.fAllowedLocales) {
            hashSet.add(uLocale.toLocale());
        }
        return hashSet;
    }

    public UnicodeSet getAllowedChars() {
        return this.fAllowedCharsSet;
    }

    public boolean failsChecks(String string, CheckResult checkResult) {
        int n2;
        int n3;
        Object object;
        int n4 = string.length();
        int n5 = 0;
        if (checkResult != null) {
            checkResult.position = 0;
            checkResult.numerics = null;
            checkResult.restrictionLevel = null;
        }
        if (0 != (this.fChecks & 0x10)) {
            object = this.getRestrictionLevel(string);
            if (object.compareTo(this.fRestrictionLevel) > 0) {
                n5 |= 0x10;
            }
            if (checkResult != null) {
                checkResult.restrictionLevel = object;
            }
        }
        if (0 != (this.fChecks & 0x80)) {
            object = new UnicodeSet();
            this.getNumerics(string, (UnicodeSet)object);
            if (((UnicodeSet)object).size() > 1) {
                n5 |= 0x80;
            }
            if (checkResult != null) {
                checkResult.numerics = object;
            }
        }
        if (0 != (this.fChecks & 0x100) && (n3 = this.findHiddenOverlay(string)) != -1) {
            n5 |= 0x100;
        }
        if (0 != (this.fChecks & 0x40)) {
            int n6 = 0;
            while (n6 < n4) {
                n2 = Character.codePointAt(string, n6);
                n6 = Character.offsetByCodePoints(string, n6, 1);
                if (this.fAllowedCharsSet.contains(n2)) continue;
                n5 |= 0x40;
                break;
            }
        }
        if (0 != (this.fChecks & 0x20)) {
            String string2 = nfdNormalizer.normalize(string);
            int n7 = 0;
            boolean bl2 = false;
            UnicodeSet unicodeSet = new UnicodeSet();
            n2 = 0;
            while (n2 < n4) {
                int n8 = Character.codePointAt(string2, n2);
                n2 = Character.offsetByCodePoints(string2, n2, 1);
                if (Character.getType(n8) != 6) {
                    n7 = 0;
                    if (!bl2) continue;
                    unicodeSet.clear();
                    bl2 = false;
                    continue;
                }
                if (n7 == 0) {
                    n7 = n8;
                    continue;
                }
                if (!bl2) {
                    unicodeSet.add(n7);
                    bl2 = true;
                }
                if (unicodeSet.contains(n8)) {
                    n5 |= 0x20;
                    break;
                }
                unicodeSet.add(n8);
            }
        }
        if (checkResult != null) {
            checkResult.checks = n5;
        }
        return 0 != n5;
    }

    public boolean failsChecks(String string) {
        return this.failsChecks(string, null);
    }

    public int areConfusable(String string, String string2) {
        String string3;
        if ((this.fChecks & 7) == 0) {
            throw new IllegalArgumentException("No confusable checks are enabled.");
        }
        String string4 = this.getSkeleton(string);
        if (!string4.equals(string3 = this.getSkeleton(string2))) {
            return 0;
        }
        ScriptSet scriptSet = new ScriptSet();
        this.getResolvedScriptSet(string, scriptSet);
        ScriptSet scriptSet2 = new ScriptSet();
        this.getResolvedScriptSet(string2, scriptSet2);
        int n2 = 0;
        if (scriptSet.intersects(scriptSet2)) {
            n2 |= 1;
        } else {
            n2 |= 2;
            if (!scriptSet.isEmpty() && !scriptSet2.isEmpty()) {
                n2 |= 4;
            }
        }
        return n2 & this.fChecks;
    }

    public int areConfusable(int n2, CharSequence charSequence, CharSequence charSequence2) {
        String string;
        if ((this.fChecks & 7) == 0) {
            throw new IllegalArgumentException("No confusable checks are enabled.");
        }
        String string2 = this.getBidiSkeleton(n2, charSequence);
        if (!string2.equals(string = this.getBidiSkeleton(n2, charSequence2))) {
            return 0;
        }
        ScriptSet scriptSet = new ScriptSet();
        this.getResolvedScriptSet(charSequence, scriptSet);
        ScriptSet scriptSet2 = new ScriptSet();
        this.getResolvedScriptSet(charSequence2, scriptSet2);
        int n3 = 0;
        if (scriptSet.intersects(scriptSet2)) {
            n3 |= 1;
        } else {
            n3 |= 2;
            if (!scriptSet.isEmpty() && !scriptSet2.isEmpty()) {
                n3 |= 4;
            }
        }
        return n3 &= this.fChecks;
    }

    public String getBidiSkeleton(int n2, CharSequence charSequence) {
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("direction should be DIRECTION_LEFT_TO_RIGHT or DIRECTION_RIGHT_TO_LEFT");
        }
        Bidi bidi = new Bidi(charSequence.toString(), n2);
        return this.getSkeleton(bidi.writeReordered(3));
    }

    public String getSkeleton(CharSequence charSequence) {
        int n2;
        String string = nfdNormalizer.normalize(charSequence);
        int n3 = string.length();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < n3; i2 += Character.charCount(n2)) {
            n2 = Character.codePointAt(string, i2);
            if (UCharacter.hasBinaryProperty(n2, 5)) continue;
            this.fSpoofData.confusableLookup(n2, stringBuilder);
        }
        String string2 = stringBuilder.toString();
        string2 = nfdNormalizer.normalize(string2);
        return string2;
    }

    @Deprecated
    public String getSkeleton(int n2, String string) {
        return this.getSkeleton(string);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SpoofChecker)) {
            return false;
        }
        SpoofChecker spoofChecker = (SpoofChecker)object;
        if (this.fSpoofData != spoofChecker.fSpoofData && this.fSpoofData != null && !this.fSpoofData.equals(spoofChecker.fSpoofData)) {
            return false;
        }
        if (this.fChecks != spoofChecker.fChecks) {
            return false;
        }
        if (this.fAllowedLocales != spoofChecker.fAllowedLocales && this.fAllowedLocales != null && !this.fAllowedLocales.equals(spoofChecker.fAllowedLocales)) {
            return false;
        }
        if (this.fAllowedCharsSet != spoofChecker.fAllowedCharsSet && this.fAllowedCharsSet != null && !this.fAllowedCharsSet.equals(spoofChecker.fAllowedCharsSet)) {
            return false;
        }
        return this.fRestrictionLevel == spoofChecker.fRestrictionLevel;
    }

    public int hashCode() {
        return this.fChecks ^ this.fSpoofData.hashCode() ^ this.fAllowedLocales.hashCode() ^ this.fAllowedCharsSet.hashCode() ^ this.fRestrictionLevel.ordinal();
    }

    private static void getAugmentedScriptSet(int n2, ScriptSet scriptSet) {
        scriptSet.clear();
        UScript.getScriptExtensions(n2, scriptSet);
        if (scriptSet.get(17)) {
            scriptSet.set(172);
            scriptSet.set(105);
            scriptSet.set(119);
        }
        if (scriptSet.get(20)) {
            scriptSet.set(105);
        }
        if (scriptSet.get(22)) {
            scriptSet.set(105);
        }
        if (scriptSet.get(18)) {
            scriptSet.set(119);
        }
        if (scriptSet.get(5)) {
            scriptSet.set(172);
        }
        if (scriptSet.get(0) || scriptSet.get(1)) {
            scriptSet.setAll();
        }
    }

    private void getResolvedScriptSet(CharSequence charSequence, ScriptSet scriptSet) {
        this.getResolvedScriptSetWithout(charSequence, 201, scriptSet);
    }

    private void getResolvedScriptSetWithout(CharSequence charSequence, int n2, ScriptSet scriptSet) {
        int n3;
        scriptSet.setAll();
        ScriptSet scriptSet2 = new ScriptSet();
        for (int i2 = 0; i2 < charSequence.length(); i2 += Character.charCount(n3)) {
            n3 = Character.codePointAt(charSequence, i2);
            SpoofChecker.getAugmentedScriptSet(n3, scriptSet2);
            if (n2 != 201 && scriptSet2.get(n2)) continue;
            scriptSet.and(scriptSet2);
        }
    }

    private void getNumerics(String string, UnicodeSet unicodeSet) {
        int n2;
        unicodeSet.clear();
        for (int i2 = 0; i2 < string.length(); i2 += Character.charCount(n2)) {
            n2 = Character.codePointAt(string, i2);
            if (UCharacter.getType(n2) != 9) continue;
            unicodeSet.add(n2 - UCharacter.getNumericValue(n2));
        }
    }

    private RestrictionLevel getRestrictionLevel(String string) {
        if (!this.fAllowedCharsSet.containsAll(string)) {
            return RestrictionLevel.UNRESTRICTIVE;
        }
        if (ASCII.containsAll(string)) {
            return RestrictionLevel.ASCII;
        }
        ScriptSet scriptSet = new ScriptSet();
        this.getResolvedScriptSet(string, scriptSet);
        if (!scriptSet.isEmpty()) {
            return RestrictionLevel.SINGLE_SCRIPT_RESTRICTIVE;
        }
        ScriptSet scriptSet2 = new ScriptSet();
        this.getResolvedScriptSetWithout(string, 25, scriptSet2);
        if (scriptSet2.get(172) || scriptSet2.get(105) || scriptSet2.get(119)) {
            return RestrictionLevel.HIGHLY_RESTRICTIVE;
        }
        if (!(scriptSet2.isEmpty() || scriptSet2.get(8) || scriptSet2.get(14) || scriptSet2.get(6))) {
            return RestrictionLevel.MODERATELY_RESTRICTIVE;
        }
        return RestrictionLevel.MINIMALLY_RESTRICTIVE;
    }

    int findHiddenOverlay(String string) {
        int n2;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < string.length(); i2 += UCharacter.charCount(n2)) {
            n2 = string.codePointAt(i2);
            if (bl2 && n2 == 775) {
                return i2;
            }
            int n3 = UCharacter.getCombiningClass(n2);
            assert (UCharacter.getCombiningClass(775) == 230);
            if (n3 != 0 && n3 != 230) continue;
            bl2 = this.isIllegalCombiningDotLeadCharacter(n2, stringBuilder);
        }
        return -1;
    }

    boolean isIllegalCombiningDotLeadCharacterNoLookup(int n2) {
        return n2 == 105 || n2 == 106 || n2 == 305 || n2 == 567 || n2 == 108 || UCharacter.hasBinaryProperty(n2, 27);
    }

    boolean isIllegalCombiningDotLeadCharacter(int n2, StringBuilder stringBuilder) {
        if (this.isIllegalCombiningDotLeadCharacterNoLookup(n2)) {
            return true;
        }
        stringBuilder.setLength(0);
        this.fSpoofData.confusableLookup(n2, stringBuilder);
        int n3 = UCharacter.codePointBefore(stringBuilder, stringBuilder.length());
        return n3 != n2 && this.isIllegalCombiningDotLeadCharacterNoLookup(n3);
    }

    static class ScriptSet
    extends BitSet {
        private static final long serialVersionUID = 1L;

        ScriptSet() {
        }

        public void and(int n2) {
            this.clear(0, n2);
            this.clear(n2 + 1, 201);
        }

        public void setAll() {
            this.set(0, 201);
        }

        public boolean isFull() {
            return this.cardinality() == 201;
        }

        public void appendStringTo(StringBuilder stringBuilder) {
            stringBuilder.append("{ ");
            if (this.isEmpty()) {
                stringBuilder.append("- ");
            } else if (this.isFull()) {
                stringBuilder.append("* ");
            } else {
                for (int i2 = 0; i2 < 201; ++i2) {
                    if (!this.get(i2)) continue;
                    stringBuilder.append(UScript.getShortName(i2));
                    stringBuilder.append(" ");
                }
            }
            stringBuilder.append("}");
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<ScriptSet ");
            this.appendStringTo(stringBuilder);
            stringBuilder.append(">");
            return stringBuilder.toString();
        }
    }

    private static class SpoofData {
        int[] fCFUKeys;
        short[] fCFUValues;
        String fCFUStrings;
        private static final int DATA_FORMAT = 1130788128;
        private static final IsAcceptable IS_ACCEPTABLE = new IsAcceptable();

        public static SpoofData getDefault() {
            if (DefaultData.EXCEPTION != null) {
                throw new MissingResourceException("Could not load default confusables data: " + DefaultData.EXCEPTION.getMessage(), "SpoofChecker", "");
            }
            return DefaultData.INSTANCE;
        }

        private SpoofData() {
        }

        private SpoofData(ByteBuffer byteBuffer) throws IOException {
            ICUBinary.readHeader(byteBuffer, 1130788128, IS_ACCEPTABLE);
            byteBuffer.mark();
            this.readData(byteBuffer);
        }

        public boolean equals(Object object) {
            if (!(object instanceof SpoofData)) {
                return false;
            }
            SpoofData spoofData = (SpoofData)object;
            if (!Arrays.equals(this.fCFUKeys, spoofData.fCFUKeys)) {
                return false;
            }
            if (!Arrays.equals(this.fCFUValues, spoofData.fCFUValues)) {
                return false;
            }
            return Utility.sameObjects(this.fCFUStrings, spoofData.fCFUStrings) || this.fCFUStrings == null || this.fCFUStrings.equals(spoofData.fCFUStrings);
        }

        public int hashCode() {
            return Arrays.hashCode(this.fCFUKeys) ^ Arrays.hashCode(this.fCFUValues) ^ this.fCFUStrings.hashCode();
        }

        private void readData(ByteBuffer byteBuffer) throws IOException {
            int n2 = byteBuffer.getInt();
            if (n2 != 944111087) {
                throw new IllegalArgumentException("Bad Spoof Check Data.");
            }
            int n3 = byteBuffer.getInt();
            int n4 = byteBuffer.getInt();
            int n5 = byteBuffer.getInt();
            int n6 = byteBuffer.getInt();
            int n7 = byteBuffer.getInt();
            int n8 = byteBuffer.getInt();
            int n9 = byteBuffer.getInt();
            int n10 = byteBuffer.getInt();
            byteBuffer.reset();
            ICUBinary.skipBytes(byteBuffer, n5);
            this.fCFUKeys = ICUBinary.getInts(byteBuffer, n6, 0);
            byteBuffer.reset();
            ICUBinary.skipBytes(byteBuffer, n7);
            this.fCFUValues = ICUBinary.getShorts(byteBuffer, n8, 0);
            byteBuffer.reset();
            ICUBinary.skipBytes(byteBuffer, n9);
            this.fCFUStrings = ICUBinary.getString(byteBuffer, n10, 0);
        }

        public void confusableLookup(int n2, StringBuilder stringBuilder) {
            int n3 = 0;
            int n4 = this.length();
            do {
                int n5;
                if (this.codePointAt(n5 = (n3 + n4) / 2) > n2) {
                    n4 = n5;
                    continue;
                }
                if (this.codePointAt(n5) < n2) {
                    n3 = n5;
                    continue;
                }
                n3 = n5;
                break;
            } while (n4 - n3 > 1);
            if (this.codePointAt(n3) != n2) {
                stringBuilder.appendCodePoint(n2);
                return;
            }
            this.appendValueTo(n3, stringBuilder);
        }

        public int length() {
            return this.fCFUKeys.length;
        }

        public int codePointAt(int n2) {
            return ConfusableDataUtils.keyToCodePoint(this.fCFUKeys[n2]);
        }

        public void appendValueTo(int n2, StringBuilder stringBuilder) {
            int n3 = ConfusableDataUtils.keyToLength(this.fCFUKeys[n2]);
            short s2 = this.fCFUValues[n2];
            if (n3 == 1) {
                stringBuilder.append((char)s2);
            } else {
                stringBuilder.append(this.fCFUStrings, (int)s2, s2 + n3);
            }
        }

        private static final class DefaultData {
            private static SpoofData INSTANCE = null;
            private static IOException EXCEPTION = null;

            private DefaultData() {
            }

            static {
                try {
                    INSTANCE = new SpoofData(ICUBinary.getRequiredData("confusables.cfu"));
                }
                catch (IOException iOException) {
                    EXCEPTION = iOException;
                }
            }
        }

        private static final class IsAcceptable
        implements ICUBinary.Authenticate {
            private IsAcceptable() {
            }

            @Override
            public boolean isDataVersionAcceptable(byte[] byArray) {
                return byArray[0] == 2 || byArray[1] != 0 || byArray[2] != 0 || byArray[3] != 0;
            }
        }
    }

    private static final class ConfusableDataUtils {
        public static final int FORMAT_VERSION = 2;

        private ConfusableDataUtils() {
        }

        public static final int keyToCodePoint(int n2) {
            return n2 & 0xFFFFFF;
        }

        public static final int keyToLength(int n2) {
            return ((n2 & 0xFF000000) >> 24) + 1;
        }

        public static final int codePointAndLengthToKey(int n2, int n3) {
            assert ((n2 & 0xFFFFFF) == n2);
            assert (n3 <= 256);
            return n2 | n3 - 1 << 24;
        }
    }

    public static class CheckResult {
        public int checks = 0;
        @Deprecated
        public int position = 0;
        public UnicodeSet numerics;
        public RestrictionLevel restrictionLevel;

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("checks:");
            if (this.checks == 0) {
                stringBuilder.append(" none");
            } else if (this.checks == -1) {
                stringBuilder.append(" all");
            } else {
                if ((this.checks & 1) != 0) {
                    stringBuilder.append(" SINGLE_SCRIPT_CONFUSABLE");
                }
                if ((this.checks & 2) != 0) {
                    stringBuilder.append(" MIXED_SCRIPT_CONFUSABLE");
                }
                if ((this.checks & 4) != 0) {
                    stringBuilder.append(" WHOLE_SCRIPT_CONFUSABLE");
                }
                if ((this.checks & 8) != 0) {
                    stringBuilder.append(" ANY_CASE");
                }
                if ((this.checks & 0x10) != 0) {
                    stringBuilder.append(" RESTRICTION_LEVEL");
                }
                if ((this.checks & 0x20) != 0) {
                    stringBuilder.append(" INVISIBLE");
                }
                if ((this.checks & 0x40) != 0) {
                    stringBuilder.append(" CHAR_LIMIT");
                }
                if ((this.checks & 0x80) != 0) {
                    stringBuilder.append(" MIXED_NUMBERS");
                }
            }
            stringBuilder.append(", numerics: ").append(this.numerics.toPattern(false));
            stringBuilder.append(", position: ").append(this.position);
            stringBuilder.append(", restrictionLevel: ").append((Object)this.restrictionLevel);
            return stringBuilder.toString();
        }
    }

    public static class Builder {
        int fChecks;
        SpoofData fSpoofData;
        final UnicodeSet fAllowedCharsSet = new UnicodeSet(0, 0x10FFFF);
        final Set<ULocale> fAllowedLocales = new LinkedHashSet<ULocale>();
        private RestrictionLevel fRestrictionLevel;

        public Builder() {
            this.fChecks = -1;
            this.fSpoofData = null;
            this.fRestrictionLevel = RestrictionLevel.HIGHLY_RESTRICTIVE;
        }

        public Builder(SpoofChecker spoofChecker) {
            this.fChecks = spoofChecker.fChecks;
            this.fSpoofData = spoofChecker.fSpoofData;
            this.fAllowedCharsSet.set(spoofChecker.fAllowedCharsSet);
            this.fAllowedLocales.addAll(spoofChecker.fAllowedLocales);
            this.fRestrictionLevel = spoofChecker.fRestrictionLevel;
        }

        public SpoofChecker build() {
            if (this.fSpoofData == null) {
                this.fSpoofData = SpoofData.getDefault();
            }
            SpoofChecker spoofChecker = new SpoofChecker();
            spoofChecker.fChecks = this.fChecks;
            spoofChecker.fSpoofData = this.fSpoofData;
            spoofChecker.fAllowedCharsSet = (UnicodeSet)this.fAllowedCharsSet.clone();
            spoofChecker.fAllowedCharsSet.freeze();
            spoofChecker.fAllowedLocales = new HashSet<ULocale>(this.fAllowedLocales);
            spoofChecker.fRestrictionLevel = this.fRestrictionLevel;
            return spoofChecker;
        }

        public Builder setData(Reader reader) throws ParseException, IOException {
            this.fSpoofData = new SpoofData();
            ConfusabledataBuilder.buildConfusableData(reader, this.fSpoofData);
            return this;
        }

        @Deprecated
        public Builder setData(Reader reader, Reader reader2) throws ParseException, IOException {
            this.setData(reader);
            return this;
        }

        public Builder setChecks(int n2) {
            if (0 != (n2 & 0)) {
                throw new IllegalArgumentException("Bad Spoof Checks value.");
            }
            this.fChecks = n2 & 0xFFFFFFFF;
            return this;
        }

        public Builder setAllowedLocales(Set<ULocale> set) {
            this.fAllowedCharsSet.clear();
            for (ULocale uLocale : set) {
                this.addScriptChars(uLocale, this.fAllowedCharsSet);
            }
            this.fAllowedLocales.clear();
            if (set.size() == 0) {
                this.fAllowedCharsSet.add(0, 0x10FFFF);
                this.fChecks &= 0xFFFFFFBF;
                return this;
            }
            UnicodeSet unicodeSet = new UnicodeSet();
            unicodeSet.applyIntPropertyValue(4106, 0);
            this.fAllowedCharsSet.addAll(unicodeSet);
            unicodeSet.applyIntPropertyValue(4106, 1);
            this.fAllowedCharsSet.addAll(unicodeSet);
            this.fAllowedLocales.clear();
            this.fAllowedLocales.addAll(set);
            this.fChecks |= 0x40;
            return this;
        }

        public Builder setAllowedJavaLocales(Set<Locale> set) {
            HashSet<ULocale> hashSet = new HashSet<ULocale>(set.size());
            for (Locale locale : set) {
                hashSet.add(ULocale.forLocale(locale));
            }
            return this.setAllowedLocales(hashSet);
        }

        private void addScriptChars(ULocale uLocale, UnicodeSet unicodeSet) {
            int[] nArray = UScript.getCode(uLocale);
            if (nArray != null) {
                UnicodeSet unicodeSet2 = new UnicodeSet();
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    unicodeSet2.applyIntPropertyValue(4106, nArray[i2]);
                    unicodeSet.addAll(unicodeSet2);
                }
            }
        }

        public Builder setAllowedChars(UnicodeSet unicodeSet) {
            this.fAllowedCharsSet.set(unicodeSet);
            this.fAllowedLocales.clear();
            this.fChecks |= 0x40;
            return this;
        }

        public Builder setRestrictionLevel(RestrictionLevel restrictionLevel) {
            this.fRestrictionLevel = restrictionLevel;
            this.fChecks |= 0x90;
            return this;
        }

        private static class ConfusabledataBuilder {
            private Hashtable<Integer, SPUString> fTable = new Hashtable();
            private UnicodeSet fKeySet = new UnicodeSet();
            private StringBuffer fStringTable;
            private ArrayList<Integer> fKeyVec = new ArrayList();
            private ArrayList<Integer> fValueVec = new ArrayList();
            private SPUStringPool stringPool = new SPUStringPool();
            private Pattern fParseLine;
            private Pattern fParseHexNum;
            private int fLineNum;

            ConfusabledataBuilder() {
            }

            void build(Reader reader, SpoofData spoofData) throws ParseException, IOException {
                int n2;
                int n3;
                Object object;
                int n4;
                Object object2;
                StringBuffer stringBuffer = new StringBuffer();
                LineNumberReader lineNumberReader = new LineNumberReader(reader);
                while ((object2 = lineNumberReader.readLine()) != null) {
                    stringBuffer.append((String)object2);
                    stringBuffer.append('\n');
                }
                this.fParseLine = Pattern.compile("(?m)^[ \\t]*([0-9A-Fa-f]+)[ \\t]+;[ \\t]*([0-9A-Fa-f]+(?:[ \\t]+[0-9A-Fa-f]+)*)[ \\t]*;\\s*(?:(SL)|(SA)|(ML)|(MA))[ \\t]*(?:#.*?)?$|^([ \\t]*(?:#.*?)?)$|^(.*?)$");
                this.fParseHexNum = Pattern.compile("\\s*([0-9A-F]+)");
                if (stringBuffer.charAt(0) == '\ufeff') {
                    stringBuffer.setCharAt(0, ' ');
                }
                object2 = this.fParseLine.matcher(stringBuffer);
                while (((Matcher)object2).find()) {
                    ++this.fLineNum;
                    if (((Matcher)object2).start(7) >= 0) continue;
                    if (((Matcher)object2).start(8) >= 0) {
                        throw new ParseException("Confusables, line " + this.fLineNum + ": Unrecognized Line: " + ((Matcher)object2).group(8), ((Matcher)object2).start(8));
                    }
                    n4 = Integer.parseInt(((Matcher)object2).group(1), 16);
                    if (n4 > 0x10FFFF) {
                        throw new ParseException("Confusables, line " + this.fLineNum + ": Bad code point: " + ((Matcher)object2).group(1), ((Matcher)object2).start(1));
                    }
                    Matcher matcher = this.fParseHexNum.matcher(((Matcher)object2).group(2));
                    object = new StringBuilder();
                    while (matcher.find()) {
                        int n5 = Integer.parseInt(matcher.group(1), 16);
                        if (n5 > 0x10FFFF) {
                            throw new ParseException("Confusables, line " + this.fLineNum + ": Bad code point: " + Integer.toString(n5, 16), ((Matcher)object2).start(2));
                        }
                        ((StringBuilder)object).appendCodePoint(n5);
                    }
                    assert (((StringBuilder)object).length() >= 1);
                    SPUString sPUString = this.stringPool.addString(((StringBuilder)object).toString());
                    this.fTable.put(n4, sPUString);
                    this.fKeySet.add(n4);
                }
                this.stringPool.sort();
                this.fStringTable = new StringBuffer();
                n4 = this.stringPool.size();
                for (n3 = 0; n3 < n4; ++n3) {
                    object = this.stringPool.getByIndex(n3);
                    int n6 = ((SPUString)object).fStr.length();
                    n2 = this.fStringTable.length();
                    if (n6 == 1) {
                        ((SPUString)object).fCharOrStrTableIndex = ((SPUString)object).fStr.charAt(0);
                        continue;
                    }
                    ((SPUString)object).fCharOrStrTableIndex = n2;
                    this.fStringTable.append(((SPUString)object).fStr);
                }
                for (String string : this.fKeySet) {
                    n2 = string.codePointAt(0);
                    SPUString sPUString = this.fTable.get(n2);
                    assert (sPUString != null);
                    if (sPUString.fStr.length() > 256) {
                        throw new IllegalArgumentException("Confusable prototypes cannot be longer than 256 entries.");
                    }
                    int n7 = ConfusableDataUtils.codePointAndLengthToKey(n2, sPUString.fStr.length());
                    int n8 = sPUString.fCharOrStrTableIndex;
                    this.fKeyVec.add(n7);
                    this.fValueVec.add(n8);
                }
                int n9 = this.fKeyVec.size();
                spoofData.fCFUKeys = new int[n9];
                int n10 = 0;
                for (n3 = 0; n3 < n9; ++n3) {
                    n2 = this.fKeyVec.get(n3);
                    int n11 = ConfusableDataUtils.keyToCodePoint(n2);
                    assert (n11 > n10);
                    spoofData.fCFUKeys[n3] = n2;
                    n10 = n11;
                }
                n2 = this.fValueVec.size();
                assert (n9 == n2);
                spoofData.fCFUValues = new short[n2];
                n3 = 0;
                for (int n7 : this.fValueVec) {
                    assert (n7 < 65535);
                    spoofData.fCFUValues[n3++] = (short)n7;
                }
                spoofData.fCFUStrings = this.fStringTable.toString();
            }

            public static void buildConfusableData(Reader reader, SpoofData spoofData) throws IOException, ParseException {
                ConfusabledataBuilder confusabledataBuilder = new ConfusabledataBuilder();
                confusabledataBuilder.build(reader, spoofData);
            }

            private static class SPUStringPool {
                private Vector<SPUString> fVec = new Vector();
                private Hashtable<String, SPUString> fHash = new Hashtable();

                public int size() {
                    return this.fVec.size();
                }

                public SPUString getByIndex(int n2) {
                    SPUString sPUString = this.fVec.elementAt(n2);
                    return sPUString;
                }

                public SPUString addString(String string) {
                    SPUString sPUString = this.fHash.get(string);
                    if (sPUString == null) {
                        sPUString = new SPUString(string);
                        this.fHash.put(string, sPUString);
                        this.fVec.addElement(sPUString);
                    }
                    return sPUString;
                }

                public void sort() {
                    Collections.sort(this.fVec, SPUStringComparator.INSTANCE);
                }
            }

            private static class SPUStringComparator
            implements Comparator<SPUString> {
                static final SPUStringComparator INSTANCE = new SPUStringComparator();

                private SPUStringComparator() {
                }

                @Override
                public int compare(SPUString sPUString, SPUString sPUString2) {
                    int n2;
                    int n3 = sPUString.fStr.length();
                    if (n3 < (n2 = sPUString2.fStr.length())) {
                        return -1;
                    }
                    if (n3 > n2) {
                        return 1;
                    }
                    return sPUString.fStr.compareTo(sPUString2.fStr);
                }
            }

            private static class SPUString {
                String fStr;
                int fCharOrStrTableIndex;

                SPUString(String string) {
                    this.fStr = string;
                    this.fCharOrStrTableIndex = 0;
                }
            }
        }
    }

    public static enum RestrictionLevel {
        ASCII,
        SINGLE_SCRIPT_RESTRICTIVE,
        HIGHLY_RESTRICTIVE,
        MODERATELY_RESTRICTIVE,
        MINIMALLY_RESTRICTIVE,
        UNRESTRICTIVE;

    }
}

