/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.util.HashSet;
import java.util.Set;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.CharSequences;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Normalizer2;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Transform;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Transliterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

class SourceTargetUtility {
    final Transform<String, String> transform;
    final UnicodeSet sourceCache;
    final Set<String> sourceStrings;
    static final UnicodeSet NON_STARTERS = new UnicodeSet("[:^ccc=0:]").freeze();
    static Normalizer2 NFC = Normalizer2.getNFCInstance();

    public SourceTargetUtility(Transform<String, String> transform) {
        this(transform, null);
    }

    public SourceTargetUtility(Transform<String, String> transform, Normalizer2 normalizer2) {
        this.transform = transform;
        this.sourceCache = normalizer2 != null ? new UnicodeSet("[:^ccc=0:]") : new UnicodeSet();
        this.sourceStrings = new HashSet<String>();
        for (int i2 = 0; i2 <= 0x10FFFF; ++i2) {
            String string;
            String string2 = transform.transform(UTF16.valueOf(i2));
            boolean bl2 = false;
            if (!CharSequences.equals(i2, string2)) {
                this.sourceCache.add(i2);
                bl2 = true;
            }
            if (normalizer2 == null || (string = NFC.getDecomposition(i2)) == null) continue;
            string2 = transform.transform(string);
            if (!string.equals(string2)) {
                this.sourceStrings.add(string);
            }
            if (bl2 || normalizer2.isInert(i2)) continue;
            this.sourceCache.add(i2);
        }
        this.sourceCache.freeze();
    }

    public void addSourceTargetSet(Transliterator transliterator, UnicodeSet unicodeSet, UnicodeSet unicodeSet2, UnicodeSet unicodeSet3) {
        UnicodeSet unicodeSet4 = transliterator.getFilterAsUnicodeSet(unicodeSet);
        UnicodeSet unicodeSet5 = new UnicodeSet(this.sourceCache).retainAll(unicodeSet4);
        unicodeSet2.addAll(unicodeSet5);
        for (String string : unicodeSet5) {
            unicodeSet3.addAll(this.transform.transform(string));
        }
        for (String string : this.sourceStrings) {
            String string2;
            if (!unicodeSet4.containsAll(string) || string.equals(string2 = this.transform.transform(string))) continue;
            unicodeSet3.addAll(string2);
            unicodeSet2.addAll(string);
        }
    }
}

