/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.PersonName;

public class SimplePersonName
implements PersonName {
    private final Locale nameLocale;
    private final PersonName.PreferredOrder preferredOrder;
    private final Map<String, String> fieldValues;

    public static Builder builder() {
        return new Builder();
    }

    private SimplePersonName(Locale locale, PersonName.PreferredOrder preferredOrder, Map<String, String> map) {
        this.nameLocale = locale;
        this.preferredOrder = preferredOrder;
        this.fieldValues = new HashMap<String, String>(map);
    }

    @Override
    public Locale getNameLocale() {
        return this.nameLocale;
    }

    @Override
    public PersonName.PreferredOrder getPreferredOrder() {
        return this.preferredOrder;
    }

    @Override
    public String getFieldValue(PersonName.NameField nameField, Set<PersonName.FieldModifier> set) {
        String string = nameField.toString();
        String string2 = this.fieldValues.get(SimplePersonName.makeModifiedFieldName(nameField, set));
        if (string2 != null) {
            set.clear();
            return string2;
        }
        string2 = this.fieldValues.get(string);
        if (string2 == null) {
            return null;
        }
        if (set.size() == 1) {
            return string2;
        }
        String string3 = string;
        int n2 = 0;
        for (String string4 : this.fieldValues.keySet()) {
            Set<PersonName.FieldModifier> set2;
            if (!string4.startsWith(string) || !set.containsAll(set2 = SimplePersonName.makeModifiersFromName(string4)) || set2.size() <= n2 && (set2.size() != n2 || string4.compareTo(string3) >= 0)) continue;
            string3 = string4;
            n2 = set2.size();
        }
        string2 = this.fieldValues.get(string3);
        set.removeAll(SimplePersonName.makeModifiersFromName(string3));
        return string2;
    }

    @Deprecated
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.fieldValues.keySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(string + "=" + this.fieldValues.get(string));
        }
        stringBuilder.append(",locale=" + this.nameLocale);
        return stringBuilder.toString();
    }

    private static String makeModifiedFieldName(PersonName.NameField nameField, Collection<PersonName.FieldModifier> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((Object)nameField);
        TreeSet<String> treeSet = new TreeSet<String>();
        for (PersonName.FieldModifier object : collection) {
            treeSet.add(object.toString());
        }
        for (String string : treeSet) {
            stringBuilder.append("-");
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static Set<PersonName.FieldModifier> makeModifiersFromName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
        HashSet<PersonName.FieldModifier> hashSet = new HashSet<PersonName.FieldModifier>();
        String string2 = stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(PersonName.FieldModifier.forString(stringTokenizer.nextToken()));
        }
        return hashSet;
    }

    public static class Builder {
        private Locale locale = null;
        private PersonName.PreferredOrder preferredOrder = PersonName.PreferredOrder.DEFAULT;
        private Map<String, String> fieldValues = new HashMap<String, String>();

        public Builder setLocale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder setPreferredOrder(PersonName.PreferredOrder preferredOrder) {
            this.preferredOrder = preferredOrder;
            return this;
        }

        public Builder addField(PersonName.NameField nameField, Collection<PersonName.FieldModifier> collection, String string) {
            TreeSet<String> treeSet = new TreeSet<String>();
            if (collection != null) {
                for (PersonName.FieldModifier object : collection) {
                    treeSet.add(object.toString());
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(nameField.toString());
            for (String string2 : treeSet) {
                stringBuilder.append("-");
                stringBuilder.append(string2);
            }
            this.fieldValues.put(stringBuilder.toString(), string);
            return this;
        }

        public SimplePersonName build() {
            if (this.fieldValues.get("surname") == null) {
                String string = this.fieldValues.get("surname-prefix");
                String string2 = this.fieldValues.get("surname-core");
                if (string != null && string2 != null) {
                    this.fieldValues.put("surname", string + " " + string2);
                } else if (string != null) {
                    this.fieldValues.put("surname", string);
                } else if (string2 != null) {
                    this.fieldValues.put("surname", string2);
                }
            }
            return new SimplePersonName(this.locale, this.preferredOrder, this.fieldValues);
        }

        private Builder() {
        }
    }
}

