/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.CharacterIterator;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ClassLoaderUtil;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Normalizer2Impl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.BOCSU;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationCompare;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationData;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationFastLatin;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationKeys;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationLoader;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationRoot;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationSettings;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationTailoring;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.ContractionsAndExpansions;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.FCDUTF16CollationIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.SharedObject;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.TailoredSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.UTF16CollationIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.CollationElementIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.CollationKey;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Collator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.RawCollationKey;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UCharacterIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSetIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.VersionInfo;

public final class RuleBasedCollator
extends Collator {
    private Lock frozenLock;
    private CollationBuffer collationBuffer;
    CollationData data;
    SharedObject.Reference<CollationSettings> settings;
    CollationTailoring tailoring;
    private ULocale validLocale;
    private boolean actualLocaleIsSameAsValid;

    public RuleBasedCollator(String string) throws Exception {
        if (string == null) {
            throw new IllegalArgumentException("Collation rules can not be null");
        }
        this.validLocale = ULocale.ROOT;
        this.internalBuildTailoring(string);
    }

    private final void internalBuildTailoring(String string) throws Exception {
        CollationTailoring collationTailoring;
        CollationTailoring collationTailoring2 = CollationRoot.getRoot();
        ClassLoader classLoader = ClassLoaderUtil.getClassLoader(this.getClass());
        try {
            Class<?> clazz = classLoader.loadClass("macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationBuilder");
            Object obj = clazz.getConstructor(CollationTailoring.class).newInstance(collationTailoring2);
            Method method = clazz.getMethod("parseAndBuild", String.class);
            collationTailoring = (CollationTailoring)method.invoke(obj, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw (Exception)invocationTargetException.getTargetException();
        }
        collationTailoring.actualLocale = null;
        this.adoptTailoring(collationTailoring);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (this.isFrozen()) {
            return this;
        }
        return this.cloneAsThawed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void initMaxExpansions() {
        CollationTailoring collationTailoring = this.tailoring;
        synchronized (collationTailoring) {
            if (this.tailoring.maxExpansions == null) {
                this.tailoring.maxExpansions = CollationElementIterator.computeMaxExpansions(this.tailoring.data);
            }
        }
    }

    public CollationElementIterator getCollationElementIterator(String string) {
        this.initMaxExpansions();
        return new CollationElementIterator(string, this);
    }

    public CollationElementIterator getCollationElementIterator(CharacterIterator characterIterator) {
        this.initMaxExpansions();
        CharacterIterator characterIterator2 = (CharacterIterator)characterIterator.clone();
        return new CollationElementIterator(characterIterator2, this);
    }

    public CollationElementIterator getCollationElementIterator(UCharacterIterator uCharacterIterator) {
        this.initMaxExpansions();
        return new CollationElementIterator(uCharacterIterator, this);
    }

    @Override
    public boolean isFrozen() {
        return this.frozenLock != null;
    }

    @Override
    public Collator freeze() {
        if (!this.isFrozen()) {
            this.frozenLock = new ReentrantLock();
            if (this.collationBuffer == null) {
                this.collationBuffer = new CollationBuffer(this.data);
            }
        }
        return this;
    }

    @Override
    public RuleBasedCollator cloneAsThawed() {
        try {
            RuleBasedCollator ruleBasedCollator = (RuleBasedCollator)super.clone();
            ruleBasedCollator.settings = this.settings.clone();
            ruleBasedCollator.collationBuffer = null;
            ruleBasedCollator.frozenLock = null;
            return ruleBasedCollator;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private void checkNotFrozen() {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify frozen RuleBasedCollator");
        }
    }

    private final CollationSettings getOwnedSettings() {
        return this.settings.copyOnWrite();
    }

    private final CollationSettings getDefaultSettings() {
        return this.tailoring.settings.readOnly();
    }

    @Deprecated
    public void setHiraganaQuaternary(boolean bl2) {
        this.checkNotFrozen();
    }

    @Deprecated
    public void setHiraganaQuaternaryDefault() {
        this.checkNotFrozen();
    }

    public void setUpperCaseFirst(boolean bl2) {
        this.checkNotFrozen();
        if (bl2 == this.isUpperCaseFirst()) {
            return;
        }
        CollationSettings collationSettings = this.getOwnedSettings();
        collationSettings.setCaseFirst(bl2 ? 768 : 0);
        this.setFastLatinOptions(collationSettings);
    }

    public void setLowerCaseFirst(boolean bl2) {
        this.checkNotFrozen();
        if (bl2 == this.isLowerCaseFirst()) {
            return;
        }
        CollationSettings collationSettings = this.getOwnedSettings();
        collationSettings.setCaseFirst(bl2 ? 512 : 0);
        this.setFastLatinOptions(collationSettings);
    }

    public final void setCaseFirstDefault() {
        this.checkNotFrozen();
        CollationSettings collationSettings = this.getDefaultSettings();
        if (this.settings.readOnly() == collationSettings) {
            return;
        }
        CollationSettings collationSettings2 = this.getOwnedSettings();
        collationSettings2.setCaseFirstDefault(collationSettings.options);
        this.setFastLatinOptions(collationSettings2);
    }

    public void setAlternateHandlingDefault() {
        this.checkNotFrozen();
        CollationSettings collationSettings = this.getDefaultSettings();
        if (this.settings.readOnly() == collationSettings) {
            return;
        }
        CollationSettings collationSettings2 = this.getOwnedSettings();
        collationSettings2.setAlternateHandlingDefault(collationSettings.options);
        this.setFastLatinOptions(collationSettings2);
    }

    public void setCaseLevelDefault() {
        this.checkNotFrozen();
        CollationSettings collationSettings = this.getDefaultSettings();
        if (this.settings.readOnly() == collationSettings) {
            return;
        }
        CollationSettings collationSettings2 = this.getOwnedSettings();
        collationSettings2.setFlagDefault(1024, collationSettings.options);
        this.setFastLatinOptions(collationSettings2);
    }

    public void setDecompositionDefault() {
        this.checkNotFrozen();
        CollationSettings collationSettings = this.getDefaultSettings();
        if (this.settings.readOnly() == collationSettings) {
            return;
        }
        CollationSettings collationSettings2 = this.getOwnedSettings();
        collationSettings2.setFlagDefault(1, collationSettings.options);
        this.setFastLatinOptions(collationSettings2);
    }

    public void setFrenchCollationDefault() {
        this.checkNotFrozen();
        CollationSettings collationSettings = this.getDefaultSettings();
        if (this.settings.readOnly() == collationSettings) {
            return;
        }
        CollationSettings collationSettings2 = this.getOwnedSettings();
        collationSettings2.setFlagDefault(2048, collationSettings.options);
        this.setFastLatinOptions(collationSettings2);
    }

    public void setStrengthDefault() {
        this.checkNotFrozen();
        CollationSettings collationSettings = this.getDefaultSettings();
        if (this.settings.readOnly() == collationSettings) {
            return;
        }
        CollationSettings collationSettings2 = this.getOwnedSettings();
        collationSettings2.setStrengthDefault(collationSettings.options);
        this.setFastLatinOptions(collationSettings2);
    }

    public void setNumericCollationDefault() {
        this.checkNotFrozen();
        CollationSettings collationSettings = this.getDefaultSettings();
        if (this.settings.readOnly() == collationSettings) {
            return;
        }
        CollationSettings collationSettings2 = this.getOwnedSettings();
        collationSettings2.setFlagDefault(2, collationSettings.options);
        this.setFastLatinOptions(collationSettings2);
    }

    public void setFrenchCollation(boolean bl2) {
        this.checkNotFrozen();
        if (bl2 == this.isFrenchCollation()) {
            return;
        }
        CollationSettings collationSettings = this.getOwnedSettings();
        collationSettings.setFlag(2048, bl2);
        this.setFastLatinOptions(collationSettings);
    }

    public void setAlternateHandlingShifted(boolean bl2) {
        this.checkNotFrozen();
        if (bl2 == this.isAlternateHandlingShifted()) {
            return;
        }
        CollationSettings collationSettings = this.getOwnedSettings();
        collationSettings.setAlternateHandlingShifted(bl2);
        this.setFastLatinOptions(collationSettings);
    }

    public void setCaseLevel(boolean bl2) {
        this.checkNotFrozen();
        if (bl2 == this.isCaseLevel()) {
            return;
        }
        CollationSettings collationSettings = this.getOwnedSettings();
        collationSettings.setFlag(1024, bl2);
        this.setFastLatinOptions(collationSettings);
    }

    @Override
    public void setDecomposition(int n2) {
        boolean bl2;
        this.checkNotFrozen();
        switch (n2) {
            case 16: {
                bl2 = false;
                break;
            }
            case 17: {
                bl2 = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong decomposition mode.");
            }
        }
        if (bl2 == this.settings.readOnly().getFlag(1)) {
            return;
        }
        CollationSettings collationSettings = this.getOwnedSettings();
        collationSettings.setFlag(1, bl2);
        this.setFastLatinOptions(collationSettings);
    }

    @Override
    public void setStrength(int n2) {
        this.checkNotFrozen();
        if (n2 == this.getStrength()) {
            return;
        }
        CollationSettings collationSettings = this.getOwnedSettings();
        collationSettings.setStrength(n2);
        this.setFastLatinOptions(collationSettings);
    }

    @Override
    public RuleBasedCollator setMaxVariable(int n2) {
        int n3;
        if (n2 == -1) {
            n3 = -1;
        } else if (4096 <= n2 && n2 <= 4099) {
            n3 = n2 - 4096;
        } else {
            throw new IllegalArgumentException("illegal max variable group " + n2);
        }
        int n4 = this.settings.readOnly().getMaxVariable();
        if (n3 == n4) {
            return this;
        }
        CollationSettings collationSettings = this.getDefaultSettings();
        if (this.settings.readOnly() == collationSettings && n3 < 0) {
            return this;
        }
        CollationSettings collationSettings2 = this.getOwnedSettings();
        if (n2 == -1) {
            n2 = 4096 + collationSettings.getMaxVariable();
        }
        long l2 = this.data.getLastPrimaryForGroup(n2);
        assert (l2 != 0L);
        collationSettings2.setMaxVariable(n3, collationSettings.options);
        collationSettings2.variableTop = l2;
        this.setFastLatinOptions(collationSettings2);
        return this;
    }

    @Override
    public int getMaxVariable() {
        return 4096 + this.settings.readOnly().getMaxVariable();
    }

    @Override
    @Deprecated
    public int setVariableTop(String string) {
        long l2;
        long l3;
        this.checkNotFrozen();
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Variable top argument string can not be null or zero in length.");
        }
        boolean bl2 = this.settings.readOnly().isNumeric();
        if (this.settings.readOnly().dontCheckFCD()) {
            UTF16CollationIterator uTF16CollationIterator = new UTF16CollationIterator(this.data, bl2, string, 0);
            l3 = uTF16CollationIterator.nextCE();
            l2 = uTF16CollationIterator.nextCE();
        } else {
            FCDUTF16CollationIterator fCDUTF16CollationIterator = new FCDUTF16CollationIterator(this.data, bl2, string, 0);
            l3 = fCDUTF16CollationIterator.nextCE();
            l2 = fCDUTF16CollationIterator.nextCE();
        }
        if (l3 == 0x101000100L || l2 != 0x101000100L) {
            throw new IllegalArgumentException("Variable top argument string must map to exactly one collation element");
        }
        this.internalSetVariableTop(l3 >>> 32);
        return (int)this.settings.readOnly().variableTop;
    }

    @Override
    @Deprecated
    public void setVariableTop(int n2) {
        this.checkNotFrozen();
        this.internalSetVariableTop((long)n2 & 0xFFFFFFFFL);
    }

    private void internalSetVariableTop(long l2) {
        if (l2 != this.settings.readOnly().variableTop) {
            int n2 = this.data.getGroupForPrimary(l2);
            if (n2 < 4096 || 4099 < n2) {
                throw new IllegalArgumentException("The variable top must be a primary weight in the space/punctuation/symbols/currency symbols range");
            }
            long l3 = this.data.getLastPrimaryForGroup(n2);
            assert (l3 != 0L && l3 >= l2);
            l2 = l3;
            if (l2 != this.settings.readOnly().variableTop) {
                CollationSettings collationSettings = this.getOwnedSettings();
                collationSettings.setMaxVariable(n2 - 4096, this.getDefaultSettings().options);
                collationSettings.variableTop = l2;
                this.setFastLatinOptions(collationSettings);
            }
        }
    }

    public void setNumericCollation(boolean bl2) {
        this.checkNotFrozen();
        if (bl2 == this.getNumericCollation()) {
            return;
        }
        CollationSettings collationSettings = this.getOwnedSettings();
        collationSettings.setFlag(2, bl2);
        this.setFastLatinOptions(collationSettings);
    }

    @Override
    public void setReorderCodes(int ... nArray) {
        int n2;
        this.checkNotFrozen();
        int n3 = n2 = nArray != null ? nArray.length : 0;
        if (n2 == 1 && nArray[0] == 103) {
            n2 = 0;
        }
        if (n2 == 0 ? this.settings.readOnly().reorderCodes.length == 0 : Arrays.equals(nArray, this.settings.readOnly().reorderCodes)) {
            return;
        }
        CollationSettings collationSettings = this.getDefaultSettings();
        if (n2 == 1 && nArray[0] == -1) {
            if (this.settings.readOnly() != collationSettings) {
                CollationSettings collationSettings2 = this.getOwnedSettings();
                collationSettings2.copyReorderingFrom(collationSettings);
                this.setFastLatinOptions(collationSettings2);
            }
            return;
        }
        CollationSettings collationSettings3 = this.getOwnedSettings();
        if (n2 == 0) {
            collationSettings3.resetReordering();
        } else {
            collationSettings3.setReordering(this.data, (int[])nArray.clone());
        }
        this.setFastLatinOptions(collationSettings3);
    }

    private void setFastLatinOptions(CollationSettings collationSettings) {
        collationSettings.fastLatinOptions = CollationFastLatin.getOptions(this.data, collationSettings, collationSettings.fastLatinPrimaries);
    }

    public String getRules() {
        return this.tailoring.getRules();
    }

    public String getRules(boolean bl2) {
        if (!bl2) {
            return this.tailoring.getRules();
        }
        return CollationLoader.getRootRules() + this.tailoring.getRules();
    }

    @Override
    public UnicodeSet getTailoredSet() {
        UnicodeSet unicodeSet = new UnicodeSet();
        if (this.data.base != null) {
            new TailoredSet(unicodeSet).forData(this.data);
        }
        return unicodeSet;
    }

    public void getContractionsAndExpansions(UnicodeSet unicodeSet, UnicodeSet unicodeSet2, boolean bl2) throws Exception {
        if (unicodeSet != null) {
            unicodeSet.clear();
        }
        if (unicodeSet2 != null) {
            unicodeSet2.clear();
        }
        new ContractionsAndExpansions(unicodeSet, unicodeSet2, null, bl2).forData(this.data);
    }

    @Deprecated
    void internalAddContractions(int n2, UnicodeSet unicodeSet) {
        new ContractionsAndExpansions(unicodeSet, null, null, false).forCodePoint(this.data, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CollationKey getCollationKey(String string) {
        if (string == null) {
            return null;
        }
        CollationBuffer collationBuffer = null;
        try {
            collationBuffer = this.getCollationBuffer();
            CollationKey collationKey = this.getCollationKey(string, collationBuffer);
            return collationKey;
        }
        finally {
            this.releaseCollationBuffer(collationBuffer);
        }
    }

    private CollationKey getCollationKey(String string, CollationBuffer collationBuffer) {
        collationBuffer.rawCollationKey = this.getRawCollationKey(string, collationBuffer.rawCollationKey, collationBuffer);
        return new CollationKey(string, collationBuffer.rawCollationKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RawCollationKey getRawCollationKey(String string, RawCollationKey rawCollationKey) {
        if (string == null) {
            return null;
        }
        CollationBuffer collationBuffer = null;
        try {
            collationBuffer = this.getCollationBuffer();
            RawCollationKey rawCollationKey2 = this.getRawCollationKey(string, rawCollationKey, collationBuffer);
            return rawCollationKey2;
        }
        finally {
            this.releaseCollationBuffer(collationBuffer);
        }
    }

    private RawCollationKey getRawCollationKey(CharSequence charSequence, RawCollationKey rawCollationKey, CollationBuffer collationBuffer) {
        if (rawCollationKey == null) {
            rawCollationKey = new RawCollationKey(this.simpleKeyLengthEstimate(charSequence));
        } else if (rawCollationKey.bytes == null) {
            rawCollationKey.bytes = new byte[this.simpleKeyLengthEstimate(charSequence)];
        }
        CollationKeyByteSink collationKeyByteSink = new CollationKeyByteSink(rawCollationKey);
        this.writeSortKey(charSequence, collationKeyByteSink, collationBuffer);
        rawCollationKey.size = collationKeyByteSink.NumberOfBytesAppended();
        return rawCollationKey;
    }

    private int simpleKeyLengthEstimate(CharSequence charSequence) {
        return 2 * charSequence.length() + 10;
    }

    private void writeSortKey(CharSequence charSequence, CollationKeyByteSink collationKeyByteSink, CollationBuffer collationBuffer) {
        boolean bl2 = this.settings.readOnly().isNumeric();
        if (this.settings.readOnly().dontCheckFCD()) {
            collationBuffer.leftUTF16CollIter.setText(bl2, charSequence, 0);
            CollationKeys.writeSortKeyUpToQuaternary(collationBuffer.leftUTF16CollIter, this.data.compressibleBytes, this.settings.readOnly(), collationKeyByteSink, 1, CollationKeys.SIMPLE_LEVEL_FALLBACK, true);
        } else {
            collationBuffer.leftFCDUTF16Iter.setText(bl2, charSequence, 0);
            CollationKeys.writeSortKeyUpToQuaternary(collationBuffer.leftFCDUTF16Iter, this.data.compressibleBytes, this.settings.readOnly(), collationKeyByteSink, 1, CollationKeys.SIMPLE_LEVEL_FALLBACK, true);
        }
        if (this.settings.readOnly().getStrength() == 15) {
            this.writeIdenticalLevel(charSequence, collationKeyByteSink);
        }
        collationKeyByteSink.Append(0);
    }

    private void writeIdenticalLevel(CharSequence charSequence, CollationKeyByteSink collationKeyByteSink) {
        int n2 = this.data.nfcImpl.decompose(charSequence, 0, charSequence.length(), null);
        collationKeyByteSink.Append(1);
        ((CollationKeyByteSink)collationKeyByteSink).key_.size = collationKeyByteSink.NumberOfBytesAppended();
        int n3 = 0;
        if (n2 != 0) {
            n3 = BOCSU.writeIdenticalLevelRun(n3, charSequence, 0, n2, collationKeyByteSink.key_);
        }
        if (n2 < charSequence.length()) {
            int n4 = charSequence.length() - n2;
            StringBuilder stringBuilder = new StringBuilder();
            this.data.nfcImpl.decompose(charSequence, n2, charSequence.length(), stringBuilder, n4);
            BOCSU.writeIdenticalLevelRun(n3, stringBuilder, 0, stringBuilder.length(), collationKeyByteSink.key_);
        }
        collationKeyByteSink.setBufferAndAppended(((CollationKeyByteSink)collationKeyByteSink).key_.bytes, ((CollationKeyByteSink)collationKeyByteSink).key_.size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public long[] internalGetCEs(CharSequence charSequence) {
        CollationBuffer collationBuffer = null;
        try {
            UTF16CollationIterator uTF16CollationIterator;
            collationBuffer = this.getCollationBuffer();
            boolean bl2 = this.settings.readOnly().isNumeric();
            if (this.settings.readOnly().dontCheckFCD()) {
                collationBuffer.leftUTF16CollIter.setText(bl2, charSequence, 0);
                uTF16CollationIterator = collationBuffer.leftUTF16CollIter;
            } else {
                collationBuffer.leftFCDUTF16Iter.setText(bl2, charSequence, 0);
                uTF16CollationIterator = collationBuffer.leftFCDUTF16Iter;
            }
            int n2 = uTF16CollationIterator.fetchCEs() - 1;
            assert (n2 >= 0 && uTF16CollationIterator.getCE(n2) == 0x101000100L);
            long[] lArray = new long[n2];
            System.arraycopy(uTF16CollationIterator.getCEs(), 0, lArray, 0, n2);
            long[] lArray2 = lArray;
            return lArray2;
        }
        finally {
            this.releaseCollationBuffer(collationBuffer);
        }
    }

    @Override
    public int getStrength() {
        return this.settings.readOnly().getStrength();
    }

    @Override
    public int getDecomposition() {
        return (this.settings.readOnly().options & 1) != 0 ? 17 : 16;
    }

    public boolean isUpperCaseFirst() {
        return this.settings.readOnly().getCaseFirst() == 768;
    }

    public boolean isLowerCaseFirst() {
        return this.settings.readOnly().getCaseFirst() == 512;
    }

    public boolean isAlternateHandlingShifted() {
        return this.settings.readOnly().getAlternateHandling();
    }

    public boolean isCaseLevel() {
        return (this.settings.readOnly().options & 0x400) != 0;
    }

    public boolean isFrenchCollation() {
        return (this.settings.readOnly().options & 0x800) != 0;
    }

    @Deprecated
    public boolean isHiraganaQuaternary() {
        return false;
    }

    @Override
    public int getVariableTop() {
        return (int)this.settings.readOnly().variableTop;
    }

    public boolean getNumericCollation() {
        return (this.settings.readOnly().options & 2) != 0;
    }

    @Override
    public int[] getReorderCodes() {
        return (int[])this.settings.readOnly().reorderCodes.clone();
    }

    @Override
    public boolean equals(Object object) {
        UnicodeSet unicodeSet;
        boolean bl2;
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        RuleBasedCollator ruleBasedCollator = (RuleBasedCollator)object;
        if (!this.settings.readOnly().equals(ruleBasedCollator.settings.readOnly())) {
            return false;
        }
        if (this.data == ruleBasedCollator.data) {
            return true;
        }
        boolean bl3 = this.data.base == null;
        boolean bl4 = bl2 = ruleBasedCollator.data.base == null;
        assert (!bl3 || !bl2);
        if (bl3 != bl2) {
            return false;
        }
        String string = this.tailoring.getRules();
        String string2 = ruleBasedCollator.tailoring.getRules();
        if ((bl3 || string.length() != 0) && (bl2 || string2.length() != 0) && string.equals(string2)) {
            return true;
        }
        UnicodeSet unicodeSet2 = this.getTailoredSet();
        return unicodeSet2.equals(unicodeSet = ruleBasedCollator.getTailoredSet());
    }

    @Override
    public int hashCode() {
        int n2 = this.settings.readOnly().hashCode();
        if (this.data.base == null) {
            return n2;
        }
        UnicodeSet unicodeSet = this.getTailoredSet();
        UnicodeSetIterator unicodeSetIterator = new UnicodeSetIterator(unicodeSet);
        while (unicodeSetIterator.next() && unicodeSetIterator.codepoint != -1) {
            n2 ^= this.data.getCE32(unicodeSetIterator.codepoint);
        }
        return n2;
    }

    @Override
    public int compare(String string, String string2) {
        return this.doCompare(string, string2);
    }

    private static final int compareNFDIter(Normalizer2Impl normalizer2Impl, NFDIterator nFDIterator, NFDIterator nFDIterator2) {
        block3: {
            while (true) {
                int n2;
                int n3;
                if ((n3 = nFDIterator.nextCodePoint()) == (n2 = nFDIterator2.nextCodePoint())) {
                    if (n3 >= 0) continue;
                    break block3;
                }
                if ((n3 = n3 < 0 ? -2 : (n3 == 65534 ? -1 : nFDIterator.nextDecomposedCodePoint(normalizer2Impl, n3))) < (n2 = n2 < 0 ? -2 : (n2 == 65534 ? -1 : nFDIterator2.nextDecomposedCodePoint(normalizer2Impl, n2)))) {
                    return -1;
                }
                if (n3 > n2) break;
            }
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    protected int doCompare(CharSequence charSequence, CharSequence charSequence2) {
        CollationBuffer collationBuffer;
        int n2;
        int n3;
        if (charSequence == charSequence2) {
            return 0;
        }
        int n4 = 0;
        while (true) {
            if (n4 == charSequence.length()) {
                if (n4 != charSequence2.length()) break;
                return 0;
            }
            if (n4 == charSequence2.length() || charSequence.charAt(n4) != charSequence2.charAt(n4)) break;
            ++n4;
        }
        CollationSettings collationSettings = this.settings.readOnly();
        boolean bl2 = collationSettings.isNumeric();
        if (n4 > 0 && (n4 != charSequence.length() && this.data.isUnsafeBackward(charSequence.charAt(n4), bl2) || n4 != charSequence2.length() && this.data.isUnsafeBackward(charSequence2.charAt(n4), bl2))) {
            while (--n4 > 0 && this.data.isUnsafeBackward(charSequence.charAt(n4), bl2)) {
            }
        }
        if ((n3 = !((n2 = collationSettings.fastLatinOptions) < 0 || n4 != charSequence.length() && charSequence.charAt(n4) > '\u017f' || n4 != charSequence2.length() && charSequence2.charAt(n4) > '\u017f') ? CollationFastLatin.compareUTF16(this.data.fastLatinTable, collationSettings.fastLatinPrimaries, n2, charSequence, charSequence2, n4) : -2) == -2) {
            collationBuffer = null;
            try {
                collationBuffer = this.getCollationBuffer();
                if (collationSettings.dontCheckFCD()) {
                    collationBuffer.leftUTF16CollIter.setText(bl2, charSequence, n4);
                    collationBuffer.rightUTF16CollIter.setText(bl2, charSequence2, n4);
                    n3 = CollationCompare.compareUpToQuaternary(collationBuffer.leftUTF16CollIter, collationBuffer.rightUTF16CollIter, collationSettings);
                } else {
                    collationBuffer.leftFCDUTF16Iter.setText(bl2, charSequence, n4);
                    collationBuffer.rightFCDUTF16Iter.setText(bl2, charSequence2, n4);
                    n3 = CollationCompare.compareUpToQuaternary(collationBuffer.leftFCDUTF16Iter, collationBuffer.rightFCDUTF16Iter, collationSettings);
                }
            }
            finally {
                this.releaseCollationBuffer(collationBuffer);
            }
        }
        if (n3 != 0 || collationSettings.getStrength() < 15) {
            return n3;
        }
        collationBuffer = null;
        try {
            collationBuffer = this.getCollationBuffer();
            Normalizer2Impl normalizer2Impl = this.data.nfcImpl;
            if (collationSettings.dontCheckFCD()) {
                collationBuffer.leftUTF16NFDIter.setText(charSequence, n4);
                collationBuffer.rightUTF16NFDIter.setText(charSequence2, n4);
                int n5 = RuleBasedCollator.compareNFDIter(normalizer2Impl, collationBuffer.leftUTF16NFDIter, collationBuffer.rightUTF16NFDIter);
                return n5;
            }
            collationBuffer.leftFCDUTF16NFDIter.setText(normalizer2Impl, charSequence, n4);
            collationBuffer.rightFCDUTF16NFDIter.setText(normalizer2Impl, charSequence2, n4);
            int n6 = RuleBasedCollator.compareNFDIter(normalizer2Impl, collationBuffer.leftFCDUTF16NFDIter, collationBuffer.rightFCDUTF16NFDIter);
            return n6;
        }
        finally {
            this.releaseCollationBuffer(collationBuffer);
        }
    }

    RuleBasedCollator(CollationTailoring collationTailoring, ULocale uLocale) {
        this.data = collationTailoring.data;
        this.settings = collationTailoring.settings.clone();
        this.tailoring = collationTailoring;
        this.validLocale = uLocale;
        this.actualLocaleIsSameAsValid = false;
    }

    private void adoptTailoring(CollationTailoring collationTailoring) {
        assert (this.settings == null && this.data == null && this.tailoring == null);
        this.data = collationTailoring.data;
        this.settings = collationTailoring.settings.clone();
        this.tailoring = collationTailoring;
        this.validLocale = collationTailoring.actualLocale;
        this.actualLocaleIsSameAsValid = false;
    }

    final boolean isUnsafe(int n2) {
        return this.data.isUnsafeBackward(n2, this.settings.readOnly().isNumeric());
    }

    @Override
    public VersionInfo getVersion() {
        int n2 = this.tailoring.version;
        int n3 = VersionInfo.UCOL_RUNTIME_VERSION.getMajor();
        return VersionInfo.getInstance((n2 >>> 24) + (n3 << 4) + (n3 >> 4), n2 >> 16 & 0xFF, n2 >> 8 & 0xFF, n2 & 0xFF);
    }

    @Override
    public VersionInfo getUCAVersion() {
        VersionInfo versionInfo = this.getVersion();
        return VersionInfo.getInstance(versionInfo.getMinor() >> 3, versionInfo.getMinor() & 7, versionInfo.getMilli() >> 6, 0);
    }

    private final CollationBuffer getCollationBuffer() {
        if (this.isFrozen()) {
            this.frozenLock.lock();
        } else if (this.collationBuffer == null) {
            this.collationBuffer = new CollationBuffer(this.data);
        }
        return this.collationBuffer;
    }

    private final void releaseCollationBuffer(CollationBuffer collationBuffer) {
        if (this.isFrozen()) {
            this.frozenLock.unlock();
        }
    }

    @Override
    public ULocale getLocale(ULocale.Type type) {
        if (type == ULocale.ACTUAL_LOCALE) {
            return this.actualLocaleIsSameAsValid ? this.validLocale : this.tailoring.actualLocale;
        }
        if (type == ULocale.VALID_LOCALE) {
            return this.validLocale;
        }
        throw new IllegalArgumentException("unknown ULocale.Type " + type);
    }

    @Override
    void setLocale(ULocale uLocale, ULocale uLocale2) {
        assert (uLocale == null == (uLocale2 == null));
        if (Objects.equals(uLocale2, this.tailoring.actualLocale)) {
            this.actualLocaleIsSameAsValid = false;
        } else {
            assert (Objects.equals(uLocale2, uLocale));
            this.actualLocaleIsSameAsValid = true;
        }
        this.validLocale = uLocale;
    }

    private static final class CollationBuffer {
        UTF16CollationIterator leftUTF16CollIter;
        UTF16CollationIterator rightUTF16CollIter;
        FCDUTF16CollationIterator leftFCDUTF16Iter;
        FCDUTF16CollationIterator rightFCDUTF16Iter;
        UTF16NFDIterator leftUTF16NFDIter;
        UTF16NFDIterator rightUTF16NFDIter;
        FCDUTF16NFDIterator leftFCDUTF16NFDIter;
        FCDUTF16NFDIterator rightFCDUTF16NFDIter;
        RawCollationKey rawCollationKey;

        private CollationBuffer(CollationData collationData) {
            this.leftUTF16CollIter = new UTF16CollationIterator(collationData);
            this.rightUTF16CollIter = new UTF16CollationIterator(collationData);
            this.leftFCDUTF16Iter = new FCDUTF16CollationIterator(collationData);
            this.rightFCDUTF16Iter = new FCDUTF16CollationIterator(collationData);
            this.leftUTF16NFDIter = new UTF16NFDIterator();
            this.rightUTF16NFDIter = new UTF16NFDIterator();
            this.leftFCDUTF16NFDIter = new FCDUTF16NFDIterator();
            this.rightFCDUTF16NFDIter = new FCDUTF16NFDIterator();
        }
    }

    private static final class FCDUTF16NFDIterator
    extends UTF16NFDIterator {
        private StringBuilder str;

        FCDUTF16NFDIterator() {
        }

        void setText(Normalizer2Impl normalizer2Impl, CharSequence charSequence, int n2) {
            this.reset();
            int n3 = normalizer2Impl.makeFCD(charSequence, n2, charSequence.length(), null);
            if (n3 == charSequence.length()) {
                this.s = charSequence;
                this.pos = n2;
            } else {
                if (this.str == null) {
                    this.str = new StringBuilder();
                } else {
                    this.str.setLength(0);
                }
                this.str.append(charSequence, n2, n3);
                Normalizer2Impl.ReorderingBuffer reorderingBuffer = new Normalizer2Impl.ReorderingBuffer(normalizer2Impl, this.str, charSequence.length() - n2);
                normalizer2Impl.makeFCD(charSequence, n3, charSequence.length(), reorderingBuffer);
                this.s = this.str;
                this.pos = 0;
            }
        }
    }

    private static class UTF16NFDIterator
    extends NFDIterator {
        protected CharSequence s;
        protected int pos;

        UTF16NFDIterator() {
        }

        void setText(CharSequence charSequence, int n2) {
            this.reset();
            this.s = charSequence;
            this.pos = n2;
        }

        @Override
        protected int nextRawCodePoint() {
            if (this.pos == this.s.length()) {
                return -1;
            }
            int n2 = Character.codePointAt(this.s, this.pos);
            this.pos += Character.charCount(n2);
            return n2;
        }
    }

    private static abstract class NFDIterator {
        private String decomp;
        private int index;

        NFDIterator() {
        }

        final void reset() {
            this.index = -1;
        }

        final int nextCodePoint() {
            if (this.index >= 0) {
                if (this.index == this.decomp.length()) {
                    this.index = -1;
                } else {
                    int n2 = Character.codePointAt(this.decomp, this.index);
                    this.index += Character.charCount(n2);
                    return n2;
                }
            }
            return this.nextRawCodePoint();
        }

        final int nextDecomposedCodePoint(Normalizer2Impl normalizer2Impl, int n2) {
            if (this.index >= 0) {
                return n2;
            }
            this.decomp = normalizer2Impl.getDecomposition(n2);
            if (this.decomp == null) {
                return n2;
            }
            n2 = Character.codePointAt(this.decomp, 0);
            this.index = Character.charCount(n2);
            return n2;
        }

        protected abstract int nextRawCodePoint();
    }

    private static final class CollationKeyByteSink
    extends CollationKeys.SortKeyByteSink {
        private RawCollationKey key_;

        CollationKeyByteSink(RawCollationKey rawCollationKey) {
            super(rawCollationKey.bytes);
            this.key_ = rawCollationKey;
        }

        @Override
        protected void AppendBeyondCapacity(byte[] byArray, int n2, int n3, int n4) {
            if (this.Resize(n3, n4)) {
                System.arraycopy(byArray, n2, this.buffer_, n4, n3);
            }
        }

        @Override
        protected boolean Resize(int n2, int n3) {
            int n4 = 2 * this.buffer_.length;
            int n5 = n3 + 2 * n2;
            if (n4 < n5) {
                n4 = n5;
            }
            if (n4 < 200) {
                n4 = 200;
            }
            byte[] byArray = new byte[n4];
            System.arraycopy(this.buffer_, 0, byArray, 0, n3);
            this.key_.bytes = byArray;
            this.buffer_ = byArray;
            return true;
        }
    }
}

