/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.MissingResourceException;
import java.util.concurrent.ConcurrentLinkedQueue;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.CharacterIteration;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUBinary;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUDebug;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.RBBIDataWrapper;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.breakiter.BurmeseBreakEngine;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.breakiter.CjkBreakEngine;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.breakiter.DictionaryBreakEngine;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.breakiter.KhmerBreakEngine;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.breakiter.LSTMBreakEngine;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.breakiter.LanguageBreakEngine;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.breakiter.LaoBreakEngine;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.breakiter.ThaiBreakEngine;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.breakiter.UnhandledBreakEngine;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.BreakIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.RBBIRuleBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.CodePointTrie;

public class RuleBasedBreakIterator
extends BreakIterator {
    private static final int START_STATE = 1;
    private static final int STOP_STATE = 0;
    private static final int RBBI_START = 0;
    private static final int RBBI_RUN = 1;
    private static final int RBBI_END = 2;
    private CharacterIterator fText = new StringCharacterIterator("");
    @Deprecated
    public RBBIDataWrapper fRData;
    private int fPosition;
    private int fRuleStatusIndex;
    private boolean fDone;
    private int[] fLookAheadMatches;
    private BreakCache fBreakCache = new BreakCache();
    private boolean fPhraseBreaking = false;
    private int fDictionaryCharCount = 0;
    private DictionaryCache fDictionaryCache = new DictionaryCache();
    private static final String RBBI_DEBUG_ARG = "rbbi";
    private static final boolean TRACE = ICUDebug.enabled("rbbi") && ICUDebug.value("rbbi").indexOf("trace") >= 0;
    private static final UnhandledBreakEngine gUnhandledBreakEngine = new UnhandledBreakEngine();
    private static final ConcurrentLinkedQueue<LanguageBreakEngine> gAllBreakEngines = new ConcurrentLinkedQueue();
    @Deprecated
    public static final String fDebugEnv;

    private RuleBasedBreakIterator() {
    }

    public static RuleBasedBreakIterator getInstanceFromCompiledRules(InputStream inputStream) throws IOException {
        RuleBasedBreakIterator ruleBasedBreakIterator = new RuleBasedBreakIterator();
        ruleBasedBreakIterator.fRData = RBBIDataWrapper.get(ICUBinary.getByteBufferFromInputStreamAndCloseStream(inputStream));
        ruleBasedBreakIterator.fLookAheadMatches = new int[ruleBasedBreakIterator.fRData.fFTable.fLookAheadResultsSize];
        return ruleBasedBreakIterator;
    }

    static RuleBasedBreakIterator getInstanceFromCompiledRules(ByteBuffer byteBuffer, boolean bl2) throws IOException {
        RuleBasedBreakIterator ruleBasedBreakIterator = RuleBasedBreakIterator.getInstanceFromCompiledRules(byteBuffer);
        ruleBasedBreakIterator.fPhraseBreaking = bl2;
        return ruleBasedBreakIterator;
    }

    @Deprecated
    public static RuleBasedBreakIterator getInstanceFromCompiledRules(ByteBuffer byteBuffer) throws IOException {
        RuleBasedBreakIterator ruleBasedBreakIterator = new RuleBasedBreakIterator();
        ruleBasedBreakIterator.fRData = RBBIDataWrapper.get(byteBuffer);
        ruleBasedBreakIterator.fLookAheadMatches = new int[ruleBasedBreakIterator.fRData.fFTable.fLookAheadResultsSize];
        return ruleBasedBreakIterator;
    }

    public RuleBasedBreakIterator(String string) {
        this();
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            RuleBasedBreakIterator.compileRules(string, byteArrayOutputStream);
            this.fRData = RBBIDataWrapper.get(ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
            this.fLookAheadMatches = new int[this.fRData.fFTable.fLookAheadResultsSize];
        }
        catch (IOException iOException) {
            RuntimeException runtimeException = new RuntimeException("RuleBasedBreakIterator rule compilation internal error: " + iOException.getMessage());
            throw runtimeException;
        }
    }

    @Override
    public Object clone() {
        RuleBasedBreakIterator ruleBasedBreakIterator = (RuleBasedBreakIterator)super.clone();
        if (this.fText != null) {
            ruleBasedBreakIterator.fText = (CharacterIterator)this.fText.clone();
        }
        ruleBasedBreakIterator.fLookAheadMatches = new int[this.fRData.fFTable.fLookAheadResultsSize];
        RuleBasedBreakIterator ruleBasedBreakIterator2 = ruleBasedBreakIterator;
        ruleBasedBreakIterator2.getClass();
        ruleBasedBreakIterator.fBreakCache = ruleBasedBreakIterator2.new BreakCache(this.fBreakCache);
        RuleBasedBreakIterator ruleBasedBreakIterator3 = ruleBasedBreakIterator;
        ruleBasedBreakIterator3.getClass();
        ruleBasedBreakIterator.fDictionaryCache = ruleBasedBreakIterator3.new DictionaryCache(this.fDictionaryCache);
        return ruleBasedBreakIterator;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        try {
            RuleBasedBreakIterator ruleBasedBreakIterator = (RuleBasedBreakIterator)object;
            if (this.fRData != ruleBasedBreakIterator.fRData && (this.fRData == null || ruleBasedBreakIterator.fRData == null)) {
                return false;
            }
            if (this.fRData != null && ruleBasedBreakIterator.fRData != null && !this.fRData.fRuleSource.equals(ruleBasedBreakIterator.fRData.fRuleSource)) {
                return false;
            }
            if (this.fText == null && ruleBasedBreakIterator.fText == null) {
                return true;
            }
            if (this.fText == null || ruleBasedBreakIterator.fText == null || !this.fText.equals(ruleBasedBreakIterator.fText)) {
                return false;
            }
            return this.fPosition == ruleBasedBreakIterator.fPosition;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public String toString() {
        String string = "";
        if (this.fRData != null) {
            string = this.fRData.fRuleSource;
        }
        return string;
    }

    public int hashCode() {
        return this.fRData.fRuleSource.hashCode();
    }

    @Deprecated
    public void dump(PrintStream printStream) {
        if (printStream == null) {
            printStream = System.out;
        }
        this.fRData.dump(printStream);
    }

    public static void compileRules(String string, OutputStream outputStream) throws IOException {
        RBBIRuleBuilder.compileRules(string, outputStream);
    }

    @Override
    public int first() {
        if (this.fText == null) {
            return -1;
        }
        this.fText.first();
        int n2 = this.fText.getIndex();
        if (!this.fBreakCache.seek(n2)) {
            this.fBreakCache.populateNear(n2);
        }
        this.fBreakCache.current();
        assert (this.fPosition == n2);
        return this.fPosition;
    }

    @Override
    public int last() {
        if (this.fText == null) {
            return -1;
        }
        int n2 = this.fText.getEndIndex();
        boolean bl2 = this.isBoundary(n2);
        assert (bl2);
        if (this.fPosition != n2) assert (this.fPosition == n2);
        return n2;
    }

    @Override
    public int next(int n2) {
        int n3 = 0;
        if (n2 > 0) {
            while (n2 > 0 && n3 != -1) {
                n3 = this.next();
                --n2;
            }
        } else if (n2 < 0) {
            while (n2 < 0 && n3 != -1) {
                n3 = this.previous();
                ++n2;
            }
        } else {
            n3 = this.current();
        }
        return n3;
    }

    @Override
    public int next() {
        this.fBreakCache.next();
        return this.fDone ? -1 : this.fPosition;
    }

    @Override
    public int previous() {
        this.fBreakCache.previous();
        return this.fDone ? -1 : this.fPosition;
    }

    @Override
    public int following(int n2) {
        if (n2 < this.fText.getBeginIndex()) {
            return this.first();
        }
        n2 = RuleBasedBreakIterator.CISetIndex32(this.fText, n2);
        this.fBreakCache.following(n2);
        return this.fDone ? -1 : this.fPosition;
    }

    @Override
    public int preceding(int n2) {
        if (this.fText == null || n2 > this.fText.getEndIndex()) {
            return this.last();
        }
        if (n2 < this.fText.getBeginIndex()) {
            return this.first();
        }
        int n3 = n2;
        this.fBreakCache.preceding(n3);
        return this.fDone ? -1 : this.fPosition;
    }

    protected static final void checkOffset(int n2, CharacterIterator characterIterator) {
        if (n2 < characterIterator.getBeginIndex() || n2 > characterIterator.getEndIndex()) {
            throw new IllegalArgumentException("offset out of bounds");
        }
    }

    @Override
    public boolean isBoundary(int n2) {
        RuleBasedBreakIterator.checkOffset(n2, this.fText);
        int n3 = RuleBasedBreakIterator.CISetIndex32(this.fText, n2);
        boolean bl2 = false;
        if (this.fBreakCache.seek(n3) || this.fBreakCache.populateNear(n3)) {
            boolean bl3 = bl2 = this.fBreakCache.current() == n2;
        }
        if (!bl2) {
            this.next();
        }
        return bl2;
    }

    @Override
    public int current() {
        return this.fText != null ? this.fPosition : -1;
    }

    @Override
    public int getRuleStatus() {
        int n2 = this.fRuleStatusIndex + this.fRData.fStatusTable[this.fRuleStatusIndex];
        int n3 = this.fRData.fStatusTable[n2];
        return n3;
    }

    @Override
    public int getRuleStatusVec(int[] nArray) {
        int n2 = this.fRData.fStatusTable[this.fRuleStatusIndex];
        if (nArray != null) {
            int n3 = Math.min(n2, nArray.length);
            for (int i2 = 0; i2 < n3; ++i2) {
                nArray[i2] = this.fRData.fStatusTable[this.fRuleStatusIndex + i2 + 1];
            }
        }
        return n2;
    }

    @Override
    public CharacterIterator getText() {
        return this.fText;
    }

    @Override
    public void setText(CharacterIterator characterIterator) {
        if (characterIterator != null) {
            this.fBreakCache.reset(characterIterator.getBeginIndex(), 0);
        } else {
            this.fBreakCache.reset();
        }
        this.fDictionaryCache.reset();
        this.fText = characterIterator;
        this.first();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LanguageBreakEngine getLanguageBreakEngine(int n2) {
        for (LanguageBreakEngine object : gAllBreakEngines) {
            if (!object.handles(n2)) continue;
            return object;
        }
        ConcurrentLinkedQueue<LanguageBreakEngine> concurrentLinkedQueue = gAllBreakEngines;
        synchronized (concurrentLinkedQueue) {
            int n3;
            LanguageBreakEngine languageBreakEngine2;
            for (LanguageBreakEngine languageBreakEngine2 : gAllBreakEngines) {
                if (!languageBreakEngine2.handles(n2)) continue;
                return languageBreakEngine2;
            }
            int n4 = UCharacter.getIntPropertyValue(n2, 4106);
            if (n4 == 22 || n4 == 20) {
                n3 = 17;
            }
            try {
                switch (n3) {
                    case 38: {
                        try {
                            languageBreakEngine2 = LSTMBreakEngine.create(n3, LSTMBreakEngine.createData(n3));
                        }
                        catch (MissingResourceException iOException) {
                            languageBreakEngine2 = new ThaiBreakEngine();
                        }
                        break;
                    }
                    case 24: {
                        languageBreakEngine2 = new LaoBreakEngine();
                        break;
                    }
                    case 28: {
                        try {
                            languageBreakEngine2 = LSTMBreakEngine.create(n3, LSTMBreakEngine.createData(n3));
                        }
                        catch (MissingResourceException missingResourceException) {
                            languageBreakEngine2 = new BurmeseBreakEngine();
                        }
                        break;
                    }
                    case 23: {
                        languageBreakEngine2 = new KhmerBreakEngine();
                        break;
                    }
                    case 17: {
                        languageBreakEngine2 = new CjkBreakEngine(false);
                        break;
                    }
                    case 18: {
                        languageBreakEngine2 = new CjkBreakEngine(true);
                        break;
                    }
                    default: {
                        gUnhandledBreakEngine.handleChar(n2);
                        languageBreakEngine2 = gUnhandledBreakEngine;
                        break;
                    }
                }
            }
            catch (IOException iOException) {
                languageBreakEngine2 = null;
            }
            if (languageBreakEngine2 != null && languageBreakEngine2 != gUnhandledBreakEngine) {
                gAllBreakEngines.add(languageBreakEngine2);
            }
            return languageBreakEngine2;
        }
    }

    private int handleNext() {
        if (TRACE) {
            System.out.println("Handle Next   pos      char  state category");
        }
        this.fRuleStatusIndex = 0;
        this.fDictionaryCharCount = 0;
        CharacterIterator characterIterator = this.fText;
        CodePointTrie codePointTrie = this.fRData.fTrie;
        char[] cArray = this.fRData.fFTable.fTable;
        int n2 = this.fPosition;
        characterIterator.setIndex(n2);
        int n3 = n2;
        int n4 = characterIterator.current();
        if (n4 >= 55296 && (n4 = CharacterIteration.nextTrail32(characterIterator, n4)) == Integer.MAX_VALUE) {
            this.fDone = true;
            return -1;
        }
        int n5 = 1;
        int n6 = this.fRData.getRowIndex(n5);
        int n7 = 3;
        int n8 = this.fRData.fFTable.fFlags;
        int n9 = this.fRData.fFTable.fDictCategoriesStart;
        int n10 = 1;
        if ((n8 & 2) != 0) {
            n7 = 2;
            n10 = 0;
            if (TRACE) {
                System.out.print("            " + RBBIDataWrapper.intToString(characterIterator.getIndex(), 5));
                System.out.print(RBBIDataWrapper.intToHexString(n4, 10));
                System.out.println(RBBIDataWrapper.intToString(n5, 7) + RBBIDataWrapper.intToString(n7, 6));
            }
        }
        while (n5 != 0) {
            int n11;
            if (n4 == Integer.MAX_VALUE) {
                if (n10 == 2) break;
                n10 = 2;
                n7 = 1;
            } else if (n10 == 1) {
                n7 = (short)codePointTrie.get(n4);
                if (n7 >= n9) {
                    ++this.fDictionaryCharCount;
                }
                if (TRACE) {
                    System.out.print("            " + RBBIDataWrapper.intToString(characterIterator.getIndex(), 5));
                    System.out.print(RBBIDataWrapper.intToHexString(n4, 10));
                    System.out.println(RBBIDataWrapper.intToString(n5, 7) + RBBIDataWrapper.intToString(n7, 6));
                }
                if ((n4 = (int)characterIterator.next()) >= 55296) {
                    n4 = CharacterIteration.nextTrail32(characterIterator, n4);
                }
            } else {
                n10 = 1;
            }
            n5 = cArray[n6 + 3 + n7];
            n6 = this.fRData.getRowIndex(n5);
            char c2 = cArray[n6 + 0];
            if (c2 == '\u0001') {
                n3 = characterIterator.getIndex();
                if (n4 >= 65536 && n4 <= 0x10FFFF) {
                    --n3;
                }
                this.fRuleStatusIndex = cArray[n6 + 2];
            } else if (c2 > '\u0001' && (n11 = this.fLookAheadMatches[c2]) >= 0) {
                this.fRuleStatusIndex = cArray[n6 + 2];
                this.fPosition = n11;
                return n11;
            }
            if ((n11 = cArray[n6 + 1]) == 0) continue;
            int n12 = characterIterator.getIndex();
            if (n4 < 65536 || n4 <= 0x10FFFF) {
                // empty if block
            }
            this.fLookAheadMatches[n11] = --n12;
        }
        if (n3 == n2) {
            if (TRACE) {
                System.out.println("Iterator did not move. Advancing by 1.");
            }
            characterIterator.setIndex(n2);
            CharacterIteration.next32(characterIterator);
            n3 = characterIterator.getIndex();
            this.fRuleStatusIndex = 0;
        }
        this.fPosition = n3;
        if (TRACE) {
            System.out.println("result = " + n3);
        }
        return n3;
    }

    private int handleSafePrevious(int n2) {
        short s2 = 0;
        int n3 = 0;
        CharacterIterator characterIterator = this.fText;
        CodePointTrie codePointTrie = this.fRData.fTrie;
        char[] cArray = this.fRData.fRTable.fTable;
        RuleBasedBreakIterator.CISetIndex32(characterIterator, n2);
        if (TRACE) {
            System.out.print("Handle Previous   pos   char  state category");
        }
        if (characterIterator.getIndex() == characterIterator.getBeginIndex()) {
            return -1;
        }
        int n4 = CharacterIteration.previous32(characterIterator);
        int n5 = 1;
        int n6 = this.fRData.getRowIndex(n5);
        while (n4 != Integer.MAX_VALUE) {
            s2 = (short)codePointTrie.get(n4);
            if (TRACE) {
                System.out.print("            " + RBBIDataWrapper.intToString(characterIterator.getIndex(), 5));
                System.out.print(RBBIDataWrapper.intToHexString(n4, 10));
                System.out.println(RBBIDataWrapper.intToString(n5, 7) + RBBIDataWrapper.intToString(s2, 6));
            }
            assert (s2 < this.fRData.fHeader.fCatCount);
            n5 = cArray[n6 + 3 + s2];
            n6 = this.fRData.getRowIndex(n5);
            if (n5 == 0) break;
            n4 = CharacterIteration.previous32(characterIterator);
        }
        n3 = characterIterator.getIndex();
        if (TRACE) {
            System.out.println("result = " + n3);
        }
        return n3;
    }

    private static int CISetIndex32(CharacterIterator characterIterator, int n2) {
        if (n2 <= characterIterator.getBeginIndex()) {
            characterIterator.first();
        } else if (n2 >= characterIterator.getEndIndex()) {
            characterIterator.setIndex(characterIterator.getEndIndex());
        } else if (Character.isLowSurrogate(characterIterator.setIndex(n2)) && !Character.isHighSurrogate(characterIterator.previous())) {
            characterIterator.next();
        }
        return characterIterator.getIndex();
    }

    static {
        gAllBreakEngines.add(gUnhandledBreakEngine);
        fDebugEnv = ICUDebug.enabled(RBBI_DEBUG_ARG) ? ICUDebug.value(RBBI_DEBUG_ARG) : null;
    }

    class BreakCache {
        static final boolean RetainCachePosition = false;
        static final boolean UpdateCachePosition = true;
        static final int CACHE_SIZE = 128;
        int fStartBufIdx;
        int fEndBufIdx;
        int fTextIdx;
        int fBufIdx;
        int[] fBoundaries = new int[128];
        short[] fStatuses = new short[128];
        DictionaryBreakEngine.DequeI fSideBuffer = new DictionaryBreakEngine.DequeI();

        BreakCache() {
            this.reset();
        }

        void reset(int n2, int n3) {
            this.fStartBufIdx = 0;
            this.fEndBufIdx = 0;
            this.fTextIdx = n2;
            this.fBufIdx = 0;
            this.fBoundaries[0] = n2;
            this.fStatuses[0] = (short)n3;
        }

        void reset() {
            this.reset(0, 0);
        }

        void next() {
            if (this.fBufIdx == this.fEndBufIdx) {
                RuleBasedBreakIterator.this.fDone = !this.populateFollowing();
                RuleBasedBreakIterator.this.fPosition = this.fTextIdx;
                RuleBasedBreakIterator.this.fRuleStatusIndex = this.fStatuses[this.fBufIdx];
            } else {
                this.fBufIdx = this.modChunkSize(this.fBufIdx + 1);
                this.fTextIdx = RuleBasedBreakIterator.this.fPosition = this.fBoundaries[this.fBufIdx];
                RuleBasedBreakIterator.this.fRuleStatusIndex = this.fStatuses[this.fBufIdx];
            }
        }

        void previous() {
            int n2 = this.fBufIdx;
            if (this.fBufIdx == this.fStartBufIdx) {
                this.populatePreceding();
            } else {
                this.fBufIdx = this.modChunkSize(this.fBufIdx - 1);
                this.fTextIdx = this.fBoundaries[this.fBufIdx];
            }
            RuleBasedBreakIterator.this.fDone = this.fBufIdx == n2;
            RuleBasedBreakIterator.this.fPosition = this.fTextIdx;
            RuleBasedBreakIterator.this.fRuleStatusIndex = this.fStatuses[this.fBufIdx];
        }

        void following(int n2) {
            if (n2 == this.fTextIdx || this.seek(n2) || this.populateNear(n2)) {
                RuleBasedBreakIterator.this.fDone = false;
                this.next();
            }
        }

        void preceding(int n2) {
            if (n2 == this.fTextIdx || this.seek(n2) || this.populateNear(n2)) {
                if (n2 == this.fTextIdx) {
                    this.previous();
                } else {
                    assert (n2 > this.fTextIdx);
                    this.current();
                }
            }
        }

        int current() {
            RuleBasedBreakIterator.this.fPosition = this.fTextIdx;
            RuleBasedBreakIterator.this.fRuleStatusIndex = this.fStatuses[this.fBufIdx];
            RuleBasedBreakIterator.this.fDone = false;
            return this.fTextIdx;
        }

        boolean populateNear(int n2) {
            assert (n2 < this.fBoundaries[this.fStartBufIdx] || n2 > this.fBoundaries[this.fEndBufIdx]);
            int n3 = 15;
            int n4 = RuleBasedBreakIterator.this.fText.getBeginIndex();
            int n5 = -1;
            int n6 = 0;
            boolean bl2 = false;
            if (n2 > this.fBoundaries[this.fStartBufIdx] - 15 && n2 < this.fBoundaries[this.fEndBufIdx] + 15) {
                bl2 = true;
            } else if (n2 <= n4 + 15) {
                bl2 = false;
                n5 = n4;
            } else {
                int n7 = RuleBasedBreakIterator.this.handleSafePrevious(n2);
                if (this.fBoundaries[this.fEndBufIdx] < n2 && this.fBoundaries[this.fEndBufIdx] >= n7 - 15) {
                    bl2 = true;
                } else if (n7 < n4 + 15) {
                    n5 = n4;
                    bl2 = this.fBoundaries[this.fStartBufIdx] <= n2 + 15;
                } else {
                    bl2 = false;
                    RuleBasedBreakIterator.this.fPosition = n7;
                    n5 = RuleBasedBreakIterator.this.handleNext();
                    if (n5 == n7 + 1 || n5 == n7 + 2 && Character.isHighSurrogate(RuleBasedBreakIterator.this.fText.setIndex(n7)) && Character.isLowSurrogate(RuleBasedBreakIterator.this.fText.next())) {
                        n5 = RuleBasedBreakIterator.this.handleNext();
                    }
                    if (n5 == -1) {
                        n5 = RuleBasedBreakIterator.this.fText.getEndIndex();
                    }
                    n6 = RuleBasedBreakIterator.this.fRuleStatusIndex;
                }
            }
            if (!bl2) {
                assert (n5 != -1);
                this.reset(n5, n6);
            }
            if (this.fBoundaries[this.fEndBufIdx] < n2) {
                while (this.fBoundaries[this.fEndBufIdx] < n2) {
                    if (this.populateFollowing()) continue;
                    assert (false);
                    return false;
                }
                this.fBufIdx = this.fEndBufIdx;
                this.fTextIdx = this.fBoundaries[this.fBufIdx];
                while (this.fTextIdx > n2) {
                    this.previous();
                }
                return true;
            }
            if (this.fBoundaries[this.fStartBufIdx] > n2) {
                while (this.fBoundaries[this.fStartBufIdx] > n2) {
                    this.populatePreceding();
                }
                this.fBufIdx = this.fStartBufIdx;
                this.fTextIdx = this.fBoundaries[this.fBufIdx];
                while (this.fTextIdx < n2) {
                    this.next();
                }
                if (this.fTextIdx > n2) {
                    this.previous();
                }
                return true;
            }
            assert (this.fTextIdx == n2);
            return true;
        }

        boolean populateFollowing() {
            int n2 = this.fBoundaries[this.fEndBufIdx];
            short s2 = this.fStatuses[this.fEndBufIdx];
            int n3 = 0;
            int n4 = 0;
            if (RuleBasedBreakIterator.this.fDictionaryCache.following(n2)) {
                this.addFollowing(((RuleBasedBreakIterator)RuleBasedBreakIterator.this).fDictionaryCache.fBoundary, ((RuleBasedBreakIterator)RuleBasedBreakIterator.this).fDictionaryCache.fStatusIndex, true);
                return true;
            }
            RuleBasedBreakIterator.this.fPosition = n2;
            n3 = RuleBasedBreakIterator.this.handleNext();
            if (n3 == -1) {
                return false;
            }
            n4 = RuleBasedBreakIterator.this.fRuleStatusIndex;
            if (RuleBasedBreakIterator.this.fDictionaryCharCount > 0) {
                RuleBasedBreakIterator.this.fDictionaryCache.populateDictionary(n2, n3, s2, n4);
                if (RuleBasedBreakIterator.this.fDictionaryCache.following(n2)) {
                    this.addFollowing(((RuleBasedBreakIterator)RuleBasedBreakIterator.this).fDictionaryCache.fBoundary, ((RuleBasedBreakIterator)RuleBasedBreakIterator.this).fDictionaryCache.fStatusIndex, true);
                    return true;
                }
            }
            this.addFollowing(n3, n4, true);
            for (int i2 = 0; i2 < 6 && (n3 = RuleBasedBreakIterator.this.handleNext()) != -1 && RuleBasedBreakIterator.this.fDictionaryCharCount <= 0; ++i2) {
                this.addFollowing(n3, RuleBasedBreakIterator.this.fRuleStatusIndex, false);
            }
            return true;
        }

        boolean populatePreceding() {
            int n2;
            int n3 = this.fBoundaries[this.fStartBufIdx];
            int n4 = RuleBasedBreakIterator.this.fText.getBeginIndex();
            if (n3 == n4) {
                return false;
            }
            int n5 = n4;
            int n6 = 0;
            if (RuleBasedBreakIterator.this.fDictionaryCache.preceding(n3)) {
                this.addPreceding(((RuleBasedBreakIterator)RuleBasedBreakIterator.this).fDictionaryCache.fBoundary, ((RuleBasedBreakIterator)RuleBasedBreakIterator.this).fDictionaryCache.fStatusIndex, true);
                return true;
            }
            int n7 = n3;
            do {
                if ((n7 = (n7 -= 30) <= n4 ? n4 : RuleBasedBreakIterator.this.handleSafePrevious(n7)) == -1 || n7 == n4) {
                    n5 = n4;
                    n6 = 0;
                    continue;
                }
                RuleBasedBreakIterator.this.fPosition = n7;
                n5 = RuleBasedBreakIterator.this.handleNext();
                if (n5 == n7 + 1 || n5 == n7 + 2 && Character.isHighSurrogate(RuleBasedBreakIterator.this.fText.setIndex(n7)) && Character.isLowSurrogate(RuleBasedBreakIterator.this.fText.next())) {
                    n5 = RuleBasedBreakIterator.this.handleNext();
                }
                n6 = RuleBasedBreakIterator.this.fRuleStatusIndex;
            } while (n5 >= n3);
            this.fSideBuffer.removeAllElements();
            this.fSideBuffer.push(n5);
            this.fSideBuffer.push(n6);
            do {
                n2 = RuleBasedBreakIterator.this.fPosition = n5;
                int n8 = n6;
                n5 = RuleBasedBreakIterator.this.handleNext();
                n6 = RuleBasedBreakIterator.this.fRuleStatusIndex;
                if (n5 == -1) break;
                boolean bl2 = false;
                if (RuleBasedBreakIterator.this.fDictionaryCharCount != 0) {
                    int n9 = n5;
                    RuleBasedBreakIterator.this.fDictionaryCache.populateDictionary(n2, n9, n8, n6);
                    while (RuleBasedBreakIterator.this.fDictionaryCache.following(n2)) {
                        n5 = ((RuleBasedBreakIterator)RuleBasedBreakIterator.this).fDictionaryCache.fBoundary;
                        n6 = ((RuleBasedBreakIterator)RuleBasedBreakIterator.this).fDictionaryCache.fStatusIndex;
                        bl2 = true;
                        assert (n5 > n2);
                        if (n5 >= n3) break;
                        assert (n5 <= n9);
                        this.fSideBuffer.push(n5);
                        this.fSideBuffer.push(n6);
                        n2 = n5;
                    }
                    assert (n5 == n9 || n5 >= n3);
                }
                if (bl2 || n5 >= n3) continue;
                this.fSideBuffer.push(n5);
                this.fSideBuffer.push(n6);
            } while (n5 < n3);
            n2 = 0;
            if (!this.fSideBuffer.isEmpty()) {
                n6 = this.fSideBuffer.pop();
                n5 = this.fSideBuffer.pop();
                this.addPreceding(n5, n6, true);
                n2 = 1;
            }
            while (!this.fSideBuffer.isEmpty()) {
                n6 = this.fSideBuffer.pop();
                n5 = this.fSideBuffer.pop();
                if (this.addPreceding(n5, n6, false)) continue;
                break;
            }
            return n2 != 0;
        }

        void addFollowing(int n2, int n3, boolean bl2) {
            assert (n2 > this.fBoundaries[this.fEndBufIdx]);
            assert (n3 <= Short.MAX_VALUE);
            int n4 = this.modChunkSize(this.fEndBufIdx + 1);
            if (n4 == this.fStartBufIdx) {
                this.fStartBufIdx = this.modChunkSize(this.fStartBufIdx + 6);
            }
            this.fBoundaries[n4] = n2;
            this.fStatuses[n4] = (short)n3;
            this.fEndBufIdx = n4;
            if (bl2) {
                this.fBufIdx = n4;
                this.fTextIdx = n2;
            } else assert (n4 != this.fBufIdx);
        }

        boolean addPreceding(int n2, int n3, boolean bl2) {
            assert (n2 < this.fBoundaries[this.fStartBufIdx]);
            assert (n3 <= Short.MAX_VALUE);
            int n4 = this.modChunkSize(this.fStartBufIdx - 1);
            if (n4 == this.fEndBufIdx) {
                if (this.fBufIdx == this.fEndBufIdx && !bl2) {
                    return false;
                }
                this.fEndBufIdx = this.modChunkSize(this.fEndBufIdx - 1);
            }
            this.fBoundaries[n4] = n2;
            this.fStatuses[n4] = (short)n3;
            this.fStartBufIdx = n4;
            if (bl2) {
                this.fBufIdx = n4;
                this.fTextIdx = n2;
            }
            return true;
        }

        boolean seek(int n2) {
            if (n2 < this.fBoundaries[this.fStartBufIdx] || n2 > this.fBoundaries[this.fEndBufIdx]) {
                return false;
            }
            if (n2 == this.fBoundaries[this.fStartBufIdx]) {
                this.fBufIdx = this.fStartBufIdx;
                this.fTextIdx = this.fBoundaries[this.fBufIdx];
                return true;
            }
            if (n2 == this.fBoundaries[this.fEndBufIdx]) {
                this.fBufIdx = this.fEndBufIdx;
                this.fTextIdx = this.fBoundaries[this.fBufIdx];
                return true;
            }
            int n3 = this.fStartBufIdx;
            int n4 = this.fEndBufIdx;
            while (n3 != n4) {
                int n5 = (n3 + n4 + (n3 > n4 ? 128 : 0)) / 2;
                if (this.fBoundaries[n5 = this.modChunkSize(n5)] > n2) {
                    n4 = n5;
                    continue;
                }
                n3 = this.modChunkSize(n5 + 1);
            }
            assert (this.fBoundaries[n4] > n2);
            this.fBufIdx = this.modChunkSize(n4 - 1);
            this.fTextIdx = this.fBoundaries[this.fBufIdx];
            assert (this.fTextIdx <= n2);
            return true;
        }

        BreakCache(BreakCache breakCache) {
            this.fStartBufIdx = breakCache.fStartBufIdx;
            this.fEndBufIdx = breakCache.fEndBufIdx;
            this.fTextIdx = breakCache.fTextIdx;
            this.fBufIdx = breakCache.fBufIdx;
            this.fBoundaries = (int[])breakCache.fBoundaries.clone();
            this.fStatuses = (short[])breakCache.fStatuses.clone();
            this.fSideBuffer = new DictionaryBreakEngine.DequeI();
        }

        void dumpCache() {
            System.out.printf("fTextIdx:%d   fBufIdx:%d%n", this.fTextIdx, this.fBufIdx);
            int n2 = this.fStartBufIdx;
            while (true) {
                System.out.printf("%d  %d%n", n2, this.fBoundaries[n2]);
                if (n2 == this.fEndBufIdx) break;
                n2 = this.modChunkSize(n2 + 1);
            }
        }

        private final int modChunkSize(int n2) {
            return n2 & 0x7F;
        }
    }

    class DictionaryCache {
        DictionaryBreakEngine.DequeI fBreaks;
        int fPositionInCache;
        int fStart;
        int fLimit;
        int fFirstRuleStatusIndex;
        int fOtherRuleStatusIndex;
        int fBoundary;
        int fStatusIndex;

        void reset() {
            this.fPositionInCache = -1;
            this.fStart = 0;
            this.fLimit = 0;
            this.fFirstRuleStatusIndex = 0;
            this.fOtherRuleStatusIndex = 0;
            this.fBreaks.removeAllElements();
        }

        boolean following(int n2) {
            if (n2 >= this.fLimit || n2 < this.fStart) {
                this.fPositionInCache = -1;
                return false;
            }
            int n3 = 0;
            if (this.fPositionInCache >= 0 && this.fPositionInCache < this.fBreaks.size() && this.fBreaks.elementAt(this.fPositionInCache) == n2) {
                ++this.fPositionInCache;
                if (this.fPositionInCache >= this.fBreaks.size()) {
                    this.fPositionInCache = -1;
                    return false;
                }
                n3 = this.fBreaks.elementAt(this.fPositionInCache);
                assert (n3 > n2);
                this.fBoundary = n3;
                this.fStatusIndex = this.fOtherRuleStatusIndex;
                return true;
            }
            this.fPositionInCache = 0;
            while (this.fPositionInCache < this.fBreaks.size()) {
                n3 = this.fBreaks.elementAt(this.fPositionInCache);
                if (n3 > n2) {
                    this.fBoundary = n3;
                    this.fStatusIndex = this.fOtherRuleStatusIndex;
                    return true;
                }
                ++this.fPositionInCache;
            }
            assert (false);
            this.fPositionInCache = -1;
            return false;
        }

        boolean preceding(int n2) {
            if (n2 <= this.fStart || n2 > this.fLimit) {
                this.fPositionInCache = -1;
                return false;
            }
            if (n2 == this.fLimit) {
                this.fPositionInCache = this.fBreaks.size() - 1;
                if (this.fPositionInCache >= 0) assert (this.fBreaks.elementAt(this.fPositionInCache) == n2);
            }
            if (this.fPositionInCache > 0 && this.fPositionInCache < this.fBreaks.size() && this.fBreaks.elementAt(this.fPositionInCache) == n2) {
                --this.fPositionInCache;
                int n3 = this.fBreaks.elementAt(this.fPositionInCache);
                assert (n3 < n2);
                this.fBoundary = n3;
                this.fStatusIndex = n3 == this.fStart ? this.fFirstRuleStatusIndex : this.fOtherRuleStatusIndex;
                return true;
            }
            if (this.fPositionInCache == 0) {
                this.fPositionInCache = -1;
                return false;
            }
            this.fPositionInCache = this.fBreaks.size() - 1;
            while (this.fPositionInCache >= 0) {
                int n4 = this.fBreaks.elementAt(this.fPositionInCache);
                if (n4 < n2) {
                    this.fBoundary = n4;
                    this.fStatusIndex = n4 == this.fStart ? this.fFirstRuleStatusIndex : this.fOtherRuleStatusIndex;
                    return true;
                }
                --this.fPositionInCache;
            }
            assert (false);
            this.fPositionInCache = -1;
            return false;
        }

        void populateDictionary(int n2, int n3, int n4, int n5) {
            if (n3 - n2 <= 1) {
                return;
            }
            this.reset();
            this.fFirstRuleStatusIndex = n4;
            this.fOtherRuleStatusIndex = n5;
            int n6 = n2;
            int n7 = n3;
            int n8 = 0;
            RuleBasedBreakIterator.this.fText.setIndex(n6);
            int n9 = CharacterIteration.current32(RuleBasedBreakIterator.this.fText);
            short s2 = (short)RuleBasedBreakIterator.this.fRData.fTrie.get(n9);
            int n10 = RuleBasedBreakIterator.this.fRData.fFTable.fDictCategoriesStart;
            while (true) {
                int n11;
                if ((n11 = RuleBasedBreakIterator.this.fText.getIndex()) < n7 && s2 < n10) {
                    n9 = CharacterIteration.next32(RuleBasedBreakIterator.this.fText);
                    s2 = (short)RuleBasedBreakIterator.this.fRData.fTrie.get(n9);
                    continue;
                }
                if (n11 >= n7) break;
                LanguageBreakEngine languageBreakEngine = RuleBasedBreakIterator.this.getLanguageBreakEngine(n9);
                if (languageBreakEngine != null) {
                    n8 += languageBreakEngine.findBreaks(RuleBasedBreakIterator.this.fText, n6, n7, this.fBreaks, RuleBasedBreakIterator.this.fPhraseBreaking);
                }
                n9 = CharacterIteration.current32(RuleBasedBreakIterator.this.fText);
                s2 = (short)RuleBasedBreakIterator.this.fRData.fTrie.get(n9);
            }
            if (n8 > 0) {
                assert (n8 == this.fBreaks.size());
                if (n2 < this.fBreaks.elementAt(0)) {
                    this.fBreaks.offer(n2);
                }
                if (n3 > this.fBreaks.peek()) {
                    this.fBreaks.push(n3);
                }
                this.fPositionInCache = 0;
                this.fStart = this.fBreaks.elementAt(0);
                this.fLimit = this.fBreaks.peek();
            }
        }

        DictionaryCache() {
            this.fPositionInCache = -1;
            this.fBreaks = new DictionaryBreakEngine.DequeI();
        }

        DictionaryCache(DictionaryCache dictionaryCache) {
            try {
                this.fBreaks = (DictionaryBreakEngine.DequeI)dictionaryCache.fBreaks.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RuntimeException(cloneNotSupportedException);
            }
            this.fPositionInCache = dictionaryCache.fPositionInCache;
            this.fStart = dictionaryCache.fStart;
            this.fLimit = dictionaryCache.fLimit;
            this.fFirstRuleStatusIndex = dictionaryCache.fFirstRuleStatusIndex;
            this.fOtherRuleStatusIndex = dictionaryCache.fOtherRuleStatusIndex;
            this.fBoundary = dictionaryCache.fBoundary;
            this.fStatusIndex = dictionaryCache.fStatusIndex;
        }
    }
}

