/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Utility;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Replaceable;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

class Quantifier
implements UnicodeMatcher {
    private UnicodeMatcher matcher;
    private int minCount;
    private int maxCount;
    public static final int MAX = Integer.MAX_VALUE;

    public Quantifier(UnicodeMatcher unicodeMatcher, int n2, int n3) {
        if (unicodeMatcher == null || n2 < 0 || n3 < 0 || n2 > n3) {
            throw new IllegalArgumentException();
        }
        this.matcher = unicodeMatcher;
        this.minCount = n2;
        this.maxCount = n3;
    }

    @Override
    public int matches(Replaceable replaceable, int[] nArray, int n2, boolean bl2) {
        int n3;
        int n4 = nArray[0];
        for (n3 = 0; n3 < this.maxCount; ++n3) {
            int n5 = nArray[0];
            int n6 = this.matcher.matches(replaceable, nArray, n2, bl2);
            if (n6 == 2) {
                if (n5 != nArray[0]) continue;
                break;
            }
            if (!bl2 || n6 != 1) break;
            return 1;
        }
        if (bl2 && nArray[0] == n2) {
            return 1;
        }
        if (n3 >= this.minCount) {
            return 2;
        }
        nArray[0] = n4;
        return 0;
    }

    @Override
    public String toPattern(boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.matcher.toPattern(bl2));
        if (this.minCount == 0) {
            if (this.maxCount == 1) {
                return stringBuilder.append('?').toString();
            }
            if (this.maxCount == Integer.MAX_VALUE) {
                return stringBuilder.append('*').toString();
            }
        } else if (this.minCount == 1 && this.maxCount == Integer.MAX_VALUE) {
            return stringBuilder.append('+').toString();
        }
        stringBuilder.append('{');
        stringBuilder.append(Utility.hex(this.minCount, 1));
        stringBuilder.append(',');
        if (this.maxCount != Integer.MAX_VALUE) {
            stringBuilder.append(Utility.hex(this.maxCount, 1));
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public boolean matchesIndexValue(int n2) {
        return this.minCount == 0 || this.matcher.matchesIndexValue(n2);
    }

    @Override
    public void addMatchSetTo(UnicodeSet unicodeSet) {
        if (this.maxCount > 0) {
            this.matcher.addMatchSetTo(unicodeSet);
        }
    }
}

