/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.util.Locale;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.personname.PersonNameFormatterImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.PersonName;

public class PersonNameFormatter {
    private final PersonNameFormatterImpl impl;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        Builder builder = PersonNameFormatter.builder();
        builder.setLocale(this.impl.getLocale());
        builder.setLength(this.impl.getLength());
        builder.setUsage(this.impl.getUsage());
        builder.setFormality(this.impl.getFormality());
        builder.setDisplayOrder(this.impl.getDisplayOrder());
        builder.setSurnameAllCaps(this.impl.getSurnameAllCaps());
        return builder;
    }

    public String formatToString(PersonName personName) {
        return this.impl.formatToString(personName);
    }

    private PersonNameFormatter(Locale locale, Length length, Usage usage, Formality formality, DisplayOrder displayOrder, boolean bl2) {
        this.impl = new PersonNameFormatterImpl(locale, length, usage, formality, displayOrder, bl2);
    }

    @Deprecated
    public PersonNameFormatter(Locale locale, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4) {
        this.impl = new PersonNameFormatterImpl(locale, stringArray, stringArray2, stringArray3, stringArray4);
    }

    @Deprecated
    public String toString() {
        return this.impl.toString();
    }

    public static class Builder {
        private Locale locale = Locale.getDefault();
        private Length length = Length.DEFAULT;
        private Usage usage = Usage.REFERRING;
        private Formality formality = Formality.DEFAULT;
        private DisplayOrder displayOrder = DisplayOrder.DEFAULT;
        private boolean surnameAllCaps = false;

        public Builder setLocale(Locale locale) {
            if (locale != null) {
                this.locale = locale;
            }
            return this;
        }

        public Builder setLength(Length length) {
            this.length = length;
            return this;
        }

        public Builder setUsage(Usage usage) {
            this.usage = usage;
            return this;
        }

        public Builder setFormality(Formality formality) {
            this.formality = formality;
            return this;
        }

        public Builder setDisplayOrder(DisplayOrder displayOrder) {
            this.displayOrder = displayOrder;
            return this;
        }

        public Builder setSurnameAllCaps(boolean bl2) {
            this.surnameAllCaps = bl2;
            return this;
        }

        public PersonNameFormatter build() {
            return new PersonNameFormatter(this.locale, this.length, this.usage, this.formality, this.displayOrder, this.surnameAllCaps);
        }

        private Builder() {
        }
    }

    public static enum DisplayOrder {
        DEFAULT,
        SORTING,
        FORCE_GIVEN_FIRST,
        FORCE_SURNAME_FIRST;

    }

    public static enum Formality {
        FORMAL,
        INFORMAL,
        DEFAULT;

    }

    public static enum Usage {
        ADDRESSING,
        REFERRING,
        MONOGRAM;

    }

    public static enum Length {
        LONG,
        MEDIUM,
        SHORT,
        DEFAULT;

    }
}

