/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUBinary;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Norm2AllModes;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Normalizer;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUUncheckedIOException;

public abstract class Normalizer2 {
    public static Normalizer2 getNFCInstance() {
        return Norm2AllModes.getNFCInstance().comp;
    }

    public static Normalizer2 getNFDInstance() {
        return Norm2AllModes.getNFCInstance().decomp;
    }

    public static Normalizer2 getNFKCInstance() {
        return Norm2AllModes.getNFKCInstance().comp;
    }

    public static Normalizer2 getNFKDInstance() {
        return Norm2AllModes.getNFKCInstance().decomp;
    }

    public static Normalizer2 getNFKCCasefoldInstance() {
        return Norm2AllModes.getNFKC_CFInstance().comp;
    }

    public static Normalizer2 getNFKCSimpleCasefoldInstance() {
        return Norm2AllModes.getNFKC_SCFInstance().comp;
    }

    public static Normalizer2 getInstance(InputStream inputStream, String string, Mode mode) {
        ByteBuffer byteBuffer = null;
        if (inputStream != null) {
            try {
                byteBuffer = ICUBinary.getByteBufferFromInputStreamAndCloseStream(inputStream);
            }
            catch (IOException iOException) {
                throw new ICUUncheckedIOException(iOException);
            }
        }
        Norm2AllModes norm2AllModes = Norm2AllModes.getInstance(byteBuffer, string);
        switch (mode) {
            case COMPOSE: {
                return norm2AllModes.comp;
            }
            case DECOMPOSE: {
                return norm2AllModes.decomp;
            }
            case FCD: {
                return norm2AllModes.fcd;
            }
            case COMPOSE_CONTIGUOUS: {
                return norm2AllModes.fcc;
            }
        }
        return null;
    }

    public String normalize(CharSequence charSequence) {
        if (charSequence instanceof String) {
            int n2 = this.spanQuickCheckYes(charSequence);
            if (n2 == charSequence.length()) {
                return (String)charSequence;
            }
            if (n2 != 0) {
                StringBuilder stringBuilder = new StringBuilder(charSequence.length()).append(charSequence, 0, n2);
                return this.normalizeSecondAndAppend(stringBuilder, charSequence.subSequence(n2, charSequence.length())).toString();
            }
        }
        return this.normalize(charSequence, new StringBuilder(charSequence.length())).toString();
    }

    public abstract StringBuilder normalize(CharSequence var1, StringBuilder var2);

    public abstract Appendable normalize(CharSequence var1, Appendable var2);

    public abstract StringBuilder normalizeSecondAndAppend(StringBuilder var1, CharSequence var2);

    public abstract StringBuilder append(StringBuilder var1, CharSequence var2);

    public abstract String getDecomposition(int var1);

    public String getRawDecomposition(int n2) {
        return null;
    }

    public int composePair(int n2, int n3) {
        return -1;
    }

    public int getCombiningClass(int n2) {
        return 0;
    }

    public abstract boolean isNormalized(CharSequence var1);

    public abstract Normalizer.QuickCheckResult quickCheck(CharSequence var1);

    public abstract int spanQuickCheckYes(CharSequence var1);

    public abstract boolean hasBoundaryBefore(int var1);

    public abstract boolean hasBoundaryAfter(int var1);

    public abstract boolean isInert(int var1);

    @Deprecated
    protected Normalizer2() {
    }

    public static enum Mode {
        COMPOSE,
        DECOMPOSE,
        FCD,
        COMPOSE_CONTIGUOUS;

    }
}

