/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.PatternProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.UCharacterName;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Utility;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Replaceable;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Transliterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeFilter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

class NameUnicodeTransliterator
extends Transliterator {
    static final String _ID = "Name-Any";
    static final String OPEN_PAT = "\\N~{~";
    static final char OPEN_DELIM = '\\';
    static final char CLOSE_DELIM = '}';
    static final char SPACE = ' ';

    static void register() {
        Transliterator.registerFactory(_ID, new Transliterator.Factory(){

            @Override
            public Transliterator getInstance(String string) {
                return new NameUnicodeTransliterator(null);
            }
        });
    }

    public NameUnicodeTransliterator(UnicodeFilter unicodeFilter) {
        super(_ID, unicodeFilter);
    }

    @Override
    protected void handleTransliterate(Replaceable replaceable, Transliterator.Position position, boolean bl2) {
        int n2 = UCharacterName.INSTANCE.getMaxCharNameLength() + 1;
        StringBuffer stringBuffer = new StringBuffer(n2);
        UnicodeSet unicodeSet = new UnicodeSet();
        UCharacterName.INSTANCE.getCharNameCharacters(unicodeSet);
        int n3 = position.start;
        int n4 = position.limit;
        int n5 = 0;
        int n6 = -1;
        block4: while (n3 < n4) {
            int n7 = replaceable.char32At(n3);
            switch (n5) {
                case 0: {
                    if (n7 != 92) break;
                    n6 = n3;
                    int n8 = Utility.parsePattern(OPEN_PAT, replaceable, n3, n4);
                    if (n8 < 0 || n8 >= n4) break;
                    n5 = 1;
                    stringBuffer.setLength(0);
                    n3 = n8;
                    continue block4;
                }
                case 1: {
                    int n8;
                    if (PatternProps.isWhiteSpace(n7)) {
                        if (stringBuffer.length() <= 0 || stringBuffer.charAt(stringBuffer.length() - 1) == ' ') break;
                        stringBuffer.append(' ');
                        if (stringBuffer.length() <= n2) break;
                        n5 = 0;
                        break;
                    }
                    if (n7 == 125) {
                        n8 = stringBuffer.length();
                        if (n8 > 0 && stringBuffer.charAt(n8 - 1) == ' ') {
                            stringBuffer.setLength(--n8);
                        }
                        if ((n7 = UCharacter.getCharFromExtendedName(stringBuffer.toString())) != -1) {
                            String string = UTF16.valueOf(n7);
                            replaceable.replace(n6, ++n3, string);
                            int n9 = n3 - n6 - string.length();
                            n3 -= n9;
                            n4 -= n9;
                        }
                        n5 = 0;
                        n6 = -1;
                        continue block4;
                    }
                    if (unicodeSet.contains(n7)) {
                        UTF16.append(stringBuffer, n7);
                        if (stringBuffer.length() < n2) break;
                        n5 = 0;
                        break;
                    }
                    --n3;
                    n5 = 0;
                }
            }
            n3 += UTF16.getCharCount(n7);
        }
        position.contextLimit += n4 - position.limit;
        position.limit = n4;
        position.start = bl2 && n6 >= 0 ? n6 : n3;
    }

    @Override
    public void addSourceTargetSet(UnicodeSet unicodeSet, UnicodeSet unicodeSet2, UnicodeSet unicodeSet3) {
        UnicodeSet unicodeSet4 = this.getFilterAsUnicodeSet(unicodeSet);
        if (!unicodeSet4.containsAll("\\N{") || !unicodeSet4.contains(125)) {
            return;
        }
        UnicodeSet unicodeSet5 = new UnicodeSet().addAll(48, 57).addAll(65, 70).addAll(97, 122).add(60).add(62).add(40).add(41).add(45).add(32).addAll("\\N{").add(125);
        unicodeSet5.retainAll(unicodeSet4);
        if (unicodeSet5.size() > 0) {
            unicodeSet2.addAll(unicodeSet5);
            unicodeSet3.addAll(0, 0x10FFFF);
        }
    }
}

