/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import macromedia.jdbc.db2.externals.com.ibm.icu.text.NFRule;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NFRuleSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NFSubstitution;

class MultiplierSubstitution
extends NFSubstitution {
    long divisor;
    NFRule owningRule;

    MultiplierSubstitution(int n2, NFRule nFRule, NFRuleSet nFRuleSet, String string) {
        super(n2, nFRuleSet, string);
        this.divisor = nFRule.getDivisor();
        this.owningRule = nFRule;
        if (this.divisor == 0L) {
            throw new IllegalStateException("Substitution with divisor 0 " + string.substring(0, n2) + " | " + string.substring(n2));
        }
    }

    @Override
    public void setDivisor(int n2, short s2) {
        this.divisor = NFRule.power(n2, s2);
        if (this.divisor == 0L) {
            throw new IllegalStateException("Substitution with divisor 0");
        }
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && this.divisor == ((MultiplierSubstitution)object).divisor;
    }

    @Override
    public long transformNumber(long l2) {
        return (long)Math.floor(l2 / this.divisor);
    }

    @Override
    public double transformNumber(double d2) {
        if (this.ruleSet != null || this.owningRule.hasModulusSubstitution() || this.owningRule.formatter.getRoundingMode() == 3) {
            return Math.floor(d2 / (double)this.divisor);
        }
        return d2 / (double)this.divisor;
    }

    @Override
    public double composeRuleValue(double d2, double d3) {
        return d2 * (double)this.divisor;
    }

    @Override
    public double calcUpperBound(double d2) {
        return this.divisor;
    }

    @Override
    char tokenChar() {
        return '<';
    }
}

