/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.text.ParsePosition;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NFRule;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NFRuleSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NFSubstitution;

class ModulusSubstitution
extends NFSubstitution {
    long divisor;
    private final NFRule ruleToUse;

    ModulusSubstitution(int n2, NFRule nFRule, NFRule nFRule2, NFRuleSet nFRuleSet, String string) {
        super(n2, nFRuleSet, string);
        this.divisor = nFRule.getDivisor();
        if (this.divisor == 0L) {
            throw new IllegalStateException("Substitution with bad divisor (" + this.divisor + ") " + string.substring(0, n2) + " | " + string.substring(n2));
        }
        this.ruleToUse = string.equals(">>>") ? nFRule2 : null;
    }

    @Override
    public void setDivisor(int n2, short s2) {
        this.divisor = NFRule.power(n2, s2);
        if (this.divisor == 0L) {
            throw new IllegalStateException("Substitution with bad divisor");
        }
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            ModulusSubstitution modulusSubstitution = (ModulusSubstitution)object;
            return this.divisor == modulusSubstitution.divisor;
        }
        return false;
    }

    @Override
    public void doSubstitution(long l2, StringBuilder stringBuilder, int n2, int n3) {
        if (this.ruleToUse == null) {
            super.doSubstitution(l2, stringBuilder, n2, n3);
        } else {
            long l3 = this.transformNumber(l2);
            this.ruleToUse.doFormat(l3, stringBuilder, n2 + this.pos, n3);
        }
    }

    @Override
    public void doSubstitution(double d2, StringBuilder stringBuilder, int n2, int n3) {
        if (this.ruleToUse == null) {
            super.doSubstitution(d2, stringBuilder, n2, n3);
        } else {
            double d3 = this.transformNumber(d2);
            this.ruleToUse.doFormat(d3, stringBuilder, n2 + this.pos, n3);
        }
    }

    @Override
    public long transformNumber(long l2) {
        return l2 % this.divisor;
    }

    @Override
    public double transformNumber(double d2) {
        return d2 % (double)this.divisor;
    }

    @Override
    public Number doParse(String string, ParsePosition parsePosition, double d2, double d3, boolean bl2, int n2) {
        if (this.ruleToUse == null) {
            return super.doParse(string, parsePosition, d2, d3, bl2, n2);
        }
        Number number = this.ruleToUse.doParse(string, parsePosition, false, d3, n2);
        if (parsePosition.getIndex() != 0) {
            double d4 = number.doubleValue();
            if ((d4 = this.composeRuleValue(d4, d2)) == (double)((long)d4)) {
                return (long)d4;
            }
            return d4;
        }
        return number;
    }

    @Override
    public double composeRuleValue(double d2, double d3) {
        return d3 - d3 % (double)this.divisor + d2;
    }

    @Override
    public double calcUpperBound(double d2) {
        return this.divisor;
    }

    @Override
    public boolean isModulusSubstitution() {
        return true;
    }

    @Override
    char tokenChar() {
        return '>';
    }
}

