/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.text.ParsePosition;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalQuantity_DualStorageBCD;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NFRuleSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NFSubstitution;

class FractionalPartSubstitution
extends NFSubstitution {
    private final boolean byDigits;
    private final boolean useSpaces;

    FractionalPartSubstitution(int n2, NFRuleSet nFRuleSet, String string) {
        super(n2, nFRuleSet, string);
        if (string.equals(">>") || string.equals(">>>") || nFRuleSet == this.ruleSet) {
            this.byDigits = true;
            this.useSpaces = !string.equals(">>>");
        } else {
            this.byDigits = false;
            this.useSpaces = true;
            this.ruleSet.makeIntoFractionRuleSet();
        }
    }

    @Override
    public void doSubstitution(double d2, StringBuilder stringBuilder, int n2, int n3) {
        if (!this.byDigits) {
            super.doSubstitution(d2, stringBuilder, n2, n3);
        } else {
            DecimalQuantity_DualStorageBCD decimalQuantity_DualStorageBCD = new DecimalQuantity_DualStorageBCD(d2);
            decimalQuantity_DualStorageBCD.roundToInfinity();
            boolean bl2 = false;
            int n4 = decimalQuantity_DualStorageBCD.getLowerDisplayMagnitude();
            while (n4 < 0) {
                if (bl2 && this.useSpaces) {
                    stringBuilder.insert(n2 + this.pos, ' ');
                } else {
                    bl2 = true;
                }
                this.ruleSet.format(decimalQuantity_DualStorageBCD.getDigit(n4++), stringBuilder, n2 + this.pos, n3);
            }
        }
    }

    @Override
    public long transformNumber(long l2) {
        return 0L;
    }

    @Override
    public double transformNumber(double d2) {
        return d2 - Math.floor(d2);
    }

    @Override
    public Number doParse(String string, ParsePosition parsePosition, double d2, double d3, boolean bl2, int n2) {
        if (!this.byDigits) {
            return super.doParse(string, parsePosition, d2, 0.0, bl2, n2);
        }
        String string2 = string;
        ParsePosition parsePosition2 = new ParsePosition(1);
        DecimalQuantity_DualStorageBCD decimalQuantity_DualStorageBCD = new DecimalQuantity_DualStorageBCD();
        int n3 = 0;
        while (string2.length() > 0 && parsePosition2.getIndex() != 0) {
            Number number;
            parsePosition2.setIndex(0);
            int n4 = this.ruleSet.parse(string2, parsePosition2, 10.0, n2).intValue();
            if (bl2 && parsePosition2.getIndex() == 0 && (number = this.ruleSet.owner.getDecimalFormat().parse(string2, parsePosition2)) != null) {
                n4 = number.intValue();
            }
            if (parsePosition2.getIndex() == 0) continue;
            decimalQuantity_DualStorageBCD.appendDigit((byte)n4, 0, true);
            ++n3;
            parsePosition.setIndex(parsePosition.getIndex() + parsePosition2.getIndex());
            string2 = string2.substring(parsePosition2.getIndex());
            while (string2.length() > 0 && string2.charAt(0) == ' ') {
                string2 = string2.substring(1);
                parsePosition.setIndex(parsePosition.getIndex() + 1);
            }
        }
        decimalQuantity_DualStorageBCD.adjustMagnitude(-n3);
        double d4 = decimalQuantity_DualStorageBCD.toDouble();
        d4 = this.composeRuleValue(d4, d2);
        return d4;
    }

    @Override
    public double composeRuleValue(double d2, double d3) {
        return d2 + d3;
    }

    @Override
    public double calcUpperBound(double d2) {
        return 0.0;
    }

    @Override
    char tokenChar() {
        return '>';
    }
}

