/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.CacheBase;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.CurrencyData;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.SoftCache;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.UResource;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NumberingSystem;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Currency;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUCloneNotSupportedException;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundle;

public class DecimalFormatSymbols
implements Serializable,
Cloneable {
    public static final int CURRENCY_SPC_CURRENCY_MATCH = 0;
    public static final int CURRENCY_SPC_SURROUNDING_MATCH = 1;
    public static final int CURRENCY_SPC_INSERT = 2;
    private String[] currencySpcBeforeSym;
    private String[] currencySpcAfterSym;
    private static final String[] SYMBOL_KEYS = new String[]{"decimal", "group", "percentSign", "minusSign", "plusSign", "exponential", "perMille", "infinity", "nan", "currencyDecimal", "currencyGroup", "superscriptingExponent", "approximatelySign"};
    private static final String[] DEF_DIGIT_STRINGS_ARRAY = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private static final char[] DEF_DIGIT_CHARS_ARRAY = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final char DEF_DECIMAL_SEPARATOR = '.';
    private static final char DEF_GROUPING_SEPARATOR = ',';
    private static final char DEF_PERCENT = '%';
    private static final char DEF_MINUS_SIGN = '-';
    private static final char DEF_PLUS_SIGN = '+';
    private static final char DEF_PERMILL = '\u2030';
    private static final String[] SYMBOL_DEFAULTS = new String[]{String.valueOf('.'), String.valueOf(','), String.valueOf('%'), String.valueOf('-'), String.valueOf('+'), "E", String.valueOf('\u2030'), "\u221e", "NaN", null, null, "\u00d7", "~"};
    private static final String LATIN_NUMBERING_SYSTEM = "latn";
    private static final String NUMBER_ELEMENTS = "NumberElements";
    private static final String SYMBOLS = "symbols";
    private char zeroDigit;
    private char[] digits;
    private String[] digitStrings;
    private transient int codePointZero;
    private char groupingSeparator;
    private String groupingSeparatorString;
    private char decimalSeparator;
    private String decimalSeparatorString;
    private char perMill;
    private String perMillString;
    private char percent;
    private String percentString;
    private char digit;
    private char sigDigit;
    private char patternSeparator;
    private String infinity;
    private String NaN;
    private char minusSign;
    private String minusString;
    private char plusSign;
    private String plusString;
    private String approximatelyString;
    private String currencySymbol;
    private String intlCurrencySymbol;
    private char monetarySeparator;
    private String monetarySeparatorString;
    private char monetaryGroupingSeparator;
    private String monetaryGroupingSeparatorString;
    private char exponential;
    private String exponentSeparator;
    private char padEscape;
    private Locale requestedLocale;
    private ULocale ulocale;
    private String exponentMultiplicationSign = null;
    private static final long serialVersionUID = 5772796243397350300L;
    private static final int currentSerialVersion = 10;
    private int serialVersionOnStream = 10;
    private static final CacheBase<ULocale, CacheData, Void> cachedLocaleData = new SoftCache<ULocale, CacheData, Void>(){

        @Override
        protected CacheData createInstance(ULocale uLocale, Void void_) {
            return DecimalFormatSymbols.loadData(uLocale);
        }
    };
    private String currencyPattern = null;
    private ULocale validLocale;
    private ULocale actualLocale;
    private transient Currency currency;

    public DecimalFormatSymbols() {
        this(ULocale.getDefault(ULocale.Category.FORMAT));
    }

    public DecimalFormatSymbols(Locale locale) {
        this(ULocale.forLocale(locale));
    }

    public DecimalFormatSymbols(ULocale uLocale) {
        this.initialize(uLocale, null);
    }

    private DecimalFormatSymbols(Locale locale, NumberingSystem numberingSystem) {
        this(ULocale.forLocale(locale), numberingSystem);
    }

    private DecimalFormatSymbols(ULocale uLocale, NumberingSystem numberingSystem) {
        this.initialize(uLocale, numberingSystem);
    }

    public static DecimalFormatSymbols getInstance() {
        return new DecimalFormatSymbols();
    }

    public static DecimalFormatSymbols getInstance(Locale locale) {
        return new DecimalFormatSymbols(locale);
    }

    public static DecimalFormatSymbols getInstance(ULocale uLocale) {
        return new DecimalFormatSymbols(uLocale);
    }

    public static DecimalFormatSymbols forNumberingSystem(Locale locale, NumberingSystem numberingSystem) {
        return new DecimalFormatSymbols(locale, numberingSystem);
    }

    public static DecimalFormatSymbols forNumberingSystem(ULocale uLocale, NumberingSystem numberingSystem) {
        return new DecimalFormatSymbols(uLocale, numberingSystem);
    }

    public static Locale[] getAvailableLocales() {
        return ICUResourceBundle.getAvailableLocales();
    }

    public static ULocale[] getAvailableULocales() {
        return ICUResourceBundle.getAvailableULocales();
    }

    public char getZeroDigit() {
        return this.zeroDigit;
    }

    public char[] getDigits() {
        return (char[])this.digits.clone();
    }

    public void setZeroDigit(char c2) {
        this.zeroDigit = c2;
        this.digitStrings = (String[])this.digitStrings.clone();
        this.digits = (char[])this.digits.clone();
        this.digitStrings[0] = String.valueOf(c2);
        this.digits[0] = c2;
        for (int i2 = 1; i2 < 10; ++i2) {
            char c3 = (char)(c2 + i2);
            this.digitStrings[i2] = String.valueOf(c3);
            this.digits[i2] = c3;
        }
        this.codePointZero = c2;
    }

    public String[] getDigitStrings() {
        return (String[])this.digitStrings.clone();
    }

    @Deprecated
    public String[] getDigitStringsLocal() {
        return this.digitStrings;
    }

    @Deprecated
    public int getCodePointZero() {
        return this.codePointZero;
    }

    public void setDigitStrings(String[] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException("The input digit string array is null");
        }
        if (stringArray.length != 10) {
            throw new IllegalArgumentException("Number of digit strings is not 10");
        }
        String[] stringArray2 = new String[10];
        char[] cArray = new char[10];
        int n2 = -1;
        for (int i2 = 0; i2 < 10; ++i2) {
            int n3;
            int n4;
            String string = stringArray[i2];
            if (string == null) {
                throw new IllegalArgumentException("The input digit string array contains a null element");
            }
            stringArray2[i2] = string;
            if (string.length() == 0) {
                n4 = -1;
                n3 = 0;
            } else {
                n4 = Character.codePointAt(stringArray[i2], 0);
                n3 = Character.charCount(n4);
            }
            if (n3 == string.length()) {
                if (n3 == 1 && cArray != null) {
                    cArray[i2] = (char)n4;
                } else {
                    cArray = null;
                }
                if (i2 == 0) {
                    n2 = n4;
                    continue;
                }
                if (n4 == n2 + i2) continue;
                n2 = -1;
                continue;
            }
            n2 = -1;
            cArray = null;
        }
        this.digitStrings = stringArray2;
        this.codePointZero = n2;
        if (cArray == null) {
            this.zeroDigit = DEF_DIGIT_CHARS_ARRAY[0];
            this.digits = DEF_DIGIT_CHARS_ARRAY;
        } else {
            this.zeroDigit = cArray[0];
            this.digits = cArray;
        }
    }

    public char getSignificantDigit() {
        return this.sigDigit;
    }

    public void setSignificantDigit(char c2) {
        this.sigDigit = c2;
    }

    public char getGroupingSeparator() {
        return this.groupingSeparator;
    }

    public void setGroupingSeparator(char c2) {
        this.groupingSeparator = c2;
        this.groupingSeparatorString = String.valueOf(c2);
    }

    public String getGroupingSeparatorString() {
        return this.groupingSeparatorString;
    }

    public void setGroupingSeparatorString(String string) {
        if (string == null) {
            throw new NullPointerException("The input grouping separator is null");
        }
        this.groupingSeparatorString = string;
        this.groupingSeparator = string.length() == 1 ? string.charAt(0) : (char)44;
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public void setDecimalSeparator(char c2) {
        this.decimalSeparator = c2;
        this.decimalSeparatorString = String.valueOf(c2);
    }

    public String getDecimalSeparatorString() {
        return this.decimalSeparatorString;
    }

    public void setDecimalSeparatorString(String string) {
        if (string == null) {
            throw new NullPointerException("The input decimal separator is null");
        }
        this.decimalSeparatorString = string;
        this.decimalSeparator = string.length() == 1 ? string.charAt(0) : (char)46;
    }

    public char getPerMill() {
        return this.perMill;
    }

    public void setPerMill(char c2) {
        this.perMill = c2;
        this.perMillString = String.valueOf(c2);
    }

    public String getPerMillString() {
        return this.perMillString;
    }

    public void setPerMillString(String string) {
        if (string == null) {
            throw new NullPointerException("The input permille string is null");
        }
        this.perMillString = string;
        this.perMill = string.length() == 1 ? string.charAt(0) : (char)8240;
    }

    public char getPercent() {
        return this.percent;
    }

    public void setPercent(char c2) {
        this.percent = c2;
        this.percentString = String.valueOf(c2);
    }

    public String getPercentString() {
        return this.percentString;
    }

    public void setPercentString(String string) {
        if (string == null) {
            throw new NullPointerException("The input percent sign is null");
        }
        this.percentString = string;
        this.percent = string.length() == 1 ? string.charAt(0) : (char)37;
    }

    public char getDigit() {
        return this.digit;
    }

    public void setDigit(char c2) {
        this.digit = c2;
    }

    public char getPatternSeparator() {
        return this.patternSeparator;
    }

    public void setPatternSeparator(char c2) {
        this.patternSeparator = c2;
    }

    public String getInfinity() {
        return this.infinity;
    }

    public void setInfinity(String string) {
        this.infinity = string;
    }

    public String getNaN() {
        return this.NaN;
    }

    public void setNaN(String string) {
        this.NaN = string;
    }

    public char getMinusSign() {
        return this.minusSign;
    }

    public void setMinusSign(char c2) {
        this.minusSign = c2;
        this.minusString = String.valueOf(c2);
    }

    public String getMinusSignString() {
        return this.minusString;
    }

    public void setMinusSignString(String string) {
        if (string == null) {
            throw new NullPointerException("The input minus sign is null");
        }
        this.minusString = string;
        this.minusSign = string.length() == 1 ? string.charAt(0) : (char)45;
    }

    public char getPlusSign() {
        return this.plusSign;
    }

    public void setPlusSign(char c2) {
        this.plusSign = c2;
        this.plusString = String.valueOf(c2);
    }

    public String getPlusSignString() {
        return this.plusString;
    }

    public void setPlusSignString(String string) {
        if (string == null) {
            throw new NullPointerException("The input plus sign is null");
        }
        this.plusString = string;
        this.plusSign = string.length() == 1 ? string.charAt(0) : (char)43;
    }

    @Deprecated
    public String getApproximatelySignString() {
        return this.approximatelyString;
    }

    @Deprecated
    public void setApproximatelySignString(String string) {
        if (string == null) {
            throw new NullPointerException("The input plus sign is null");
        }
        this.approximatelyString = string;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String string) {
        this.currencySymbol = string;
    }

    public String getInternationalCurrencySymbol() {
        return this.intlCurrencySymbol;
    }

    public void setInternationalCurrencySymbol(String string) {
        this.intlCurrencySymbol = string;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        if (currency == null) {
            throw new NullPointerException();
        }
        if (currency.equals(this.currency)) {
            return;
        }
        CurrencyData.CurrencyDisplayInfo currencyDisplayInfo = CurrencyData.provider.getInstance(this.ulocale, true);
        this.setCurrencyOrNull(currency, currencyDisplayInfo);
    }

    private void setCurrencyOrNull(Currency currency, CurrencyData.CurrencyDisplayInfo currencyDisplayInfo) {
        this.currency = currency;
        if (currency == null) {
            this.intlCurrencySymbol = "XXX";
            this.currencySymbol = "\u00a4";
            this.currencyPattern = null;
            return;
        }
        this.intlCurrencySymbol = currency.getCurrencyCode();
        this.currencySymbol = currency.getSymbol(this.ulocale);
        CurrencyData.CurrencyFormatInfo currencyFormatInfo = currencyDisplayInfo.getFormatInfo(currency.getCurrencyCode());
        if (currencyFormatInfo != null) {
            this.setMonetaryDecimalSeparatorString(currencyFormatInfo.monetaryDecimalSeparator);
            this.setMonetaryGroupingSeparatorString(currencyFormatInfo.monetaryGroupingSeparator);
            this.currencyPattern = currencyFormatInfo.currencyPattern;
        }
    }

    public char getMonetaryDecimalSeparator() {
        return this.monetarySeparator;
    }

    public void setMonetaryDecimalSeparator(char c2) {
        this.monetarySeparator = c2;
        this.monetarySeparatorString = String.valueOf(c2);
    }

    public String getMonetaryDecimalSeparatorString() {
        return this.monetarySeparatorString;
    }

    public void setMonetaryDecimalSeparatorString(String string) {
        if (string == null) {
            throw new NullPointerException("The input monetary decimal separator is null");
        }
        this.monetarySeparatorString = string;
        this.monetarySeparator = string.length() == 1 ? string.charAt(0) : (char)46;
    }

    public char getMonetaryGroupingSeparator() {
        return this.monetaryGroupingSeparator;
    }

    public void setMonetaryGroupingSeparator(char c2) {
        this.monetaryGroupingSeparator = c2;
        this.monetaryGroupingSeparatorString = String.valueOf(c2);
    }

    public String getMonetaryGroupingSeparatorString() {
        return this.monetaryGroupingSeparatorString;
    }

    public void setMonetaryGroupingSeparatorString(String string) {
        if (string == null) {
            throw new NullPointerException("The input monetary grouping separator is null");
        }
        this.monetaryGroupingSeparatorString = string;
        this.monetaryGroupingSeparator = string.length() == 1 ? string.charAt(0) : (char)44;
    }

    @Deprecated
    public String getCurrencyPattern() {
        return this.currencyPattern;
    }

    public String getExponentMultiplicationSign() {
        return this.exponentMultiplicationSign;
    }

    public void setExponentMultiplicationSign(String string) {
        this.exponentMultiplicationSign = string;
    }

    public String getExponentSeparator() {
        return this.exponentSeparator;
    }

    public void setExponentSeparator(String string) {
        this.exponentSeparator = string;
    }

    public char getPadEscape() {
        return this.padEscape;
    }

    public void setPadEscape(char c2) {
        this.padEscape = c2;
    }

    public String getPatternForCurrencySpacing(int n2, boolean bl2) {
        if (n2 < 0 || n2 > 2) {
            throw new IllegalArgumentException("unknown currency spacing: " + n2);
        }
        if (bl2) {
            return this.currencySpcBeforeSym[n2];
        }
        return this.currencySpcAfterSym[n2];
    }

    public void setPatternForCurrencySpacing(int n2, boolean bl2, String string) {
        if (n2 < 0 || n2 > 2) {
            throw new IllegalArgumentException("unknown currency spacing: " + n2);
        }
        if (bl2) {
            this.currencySpcBeforeSym = (String[])this.currencySpcBeforeSym.clone();
            this.currencySpcBeforeSym[n2] = string;
        } else {
            this.currencySpcAfterSym = (String[])this.currencySpcAfterSym.clone();
            this.currencySpcAfterSym[n2] = string;
        }
    }

    public Locale getLocale() {
        return this.requestedLocale;
    }

    public ULocale getULocale() {
        return this.ulocale;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ICUCloneNotSupportedException(cloneNotSupportedException);
        }
    }

    public boolean equals(Object object) {
        int n2;
        if (!(object instanceof DecimalFormatSymbols)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        DecimalFormatSymbols decimalFormatSymbols = (DecimalFormatSymbols)object;
        for (n2 = 0; n2 <= 2; ++n2) {
            if (!this.currencySpcBeforeSym[n2].equals(decimalFormatSymbols.currencySpcBeforeSym[n2])) {
                return false;
            }
            if (this.currencySpcAfterSym[n2].equals(decimalFormatSymbols.currencySpcAfterSym[n2])) continue;
            return false;
        }
        if (decimalFormatSymbols.digits == null) {
            for (n2 = 0; n2 < 10; ++n2) {
                if (this.digits[n2] == decimalFormatSymbols.zeroDigit + n2) continue;
                return false;
            }
        } else if (!Arrays.equals(this.digits, decimalFormatSymbols.digits)) {
            return false;
        }
        return this.groupingSeparator == decimalFormatSymbols.groupingSeparator && this.decimalSeparator == decimalFormatSymbols.decimalSeparator && this.percent == decimalFormatSymbols.percent && this.perMill == decimalFormatSymbols.perMill && this.digit == decimalFormatSymbols.digit && this.minusSign == decimalFormatSymbols.minusSign && this.minusString.equals(decimalFormatSymbols.minusString) && this.patternSeparator == decimalFormatSymbols.patternSeparator && this.infinity.equals(decimalFormatSymbols.infinity) && this.NaN.equals(decimalFormatSymbols.NaN) && this.currencySymbol.equals(decimalFormatSymbols.currencySymbol) && this.intlCurrencySymbol.equals(decimalFormatSymbols.intlCurrencySymbol) && this.padEscape == decimalFormatSymbols.padEscape && this.plusSign == decimalFormatSymbols.plusSign && this.plusString.equals(decimalFormatSymbols.plusString) && this.approximatelyString.equals(decimalFormatSymbols.approximatelyString) && this.exponentSeparator.equals(decimalFormatSymbols.exponentSeparator) && this.monetarySeparator == decimalFormatSymbols.monetarySeparator && this.monetaryGroupingSeparator == decimalFormatSymbols.monetaryGroupingSeparator && this.exponentMultiplicationSign.equals(decimalFormatSymbols.exponentMultiplicationSign);
    }

    public int hashCode() {
        int n2 = this.digits[0];
        n2 = n2 * 37 + this.groupingSeparator;
        n2 = n2 * 37 + this.decimalSeparator;
        return n2;
    }

    private void initialize(ULocale uLocale, NumberingSystem numberingSystem) {
        this.requestedLocale = uLocale.toLocale();
        this.ulocale = uLocale;
        ULocale uLocale2 = numberingSystem == null ? uLocale : uLocale.setKeywordValue("numbers", numberingSystem.getName());
        CacheData cacheData = cachedLocaleData.getInstance(uLocale2, null);
        this.setLocale(cacheData.validLocale, cacheData.validLocale);
        this.setDigitStrings(cacheData.digits);
        String[] stringArray = cacheData.numberElements;
        this.setDecimalSeparatorString(stringArray[0]);
        this.setGroupingSeparatorString(stringArray[1]);
        this.patternSeparator = (char)59;
        this.setPercentString(stringArray[2]);
        this.setMinusSignString(stringArray[3]);
        this.setPlusSignString(stringArray[4]);
        this.setExponentSeparator(stringArray[5]);
        this.setPerMillString(stringArray[6]);
        this.setInfinity(stringArray[7]);
        this.setNaN(stringArray[8]);
        this.setMonetaryDecimalSeparatorString(stringArray[9]);
        this.setMonetaryGroupingSeparatorString(stringArray[10]);
        this.setExponentMultiplicationSign(stringArray[11]);
        this.setApproximatelySignString(stringArray[12]);
        this.digit = (char)35;
        this.padEscape = (char)42;
        this.sigDigit = (char)64;
        CurrencyData.CurrencyDisplayInfo currencyDisplayInfo = CurrencyData.provider.getInstance(this.ulocale, true);
        this.initSpacingInfo(currencyDisplayInfo.getSpacingInfo());
        this.setCurrencyOrNull(Currency.getInstance(this.ulocale), currencyDisplayInfo);
    }

    private static CacheData loadData(ULocale uLocale) {
        String string;
        Object object;
        NumberingSystem numberingSystem = NumberingSystem.getInstance(uLocale);
        String[] stringArray = new String[10];
        if (numberingSystem != null && numberingSystem.getRadix() == 10 && !numberingSystem.isAlgorithmic() && NumberingSystem.isValidDigitString(numberingSystem.getDescription())) {
            object = numberingSystem.getDescription();
            int n2 = 0;
            for (int i2 = 0; i2 < 10; ++i2) {
                int n3 = ((String)object).codePointAt(n2);
                int n4 = n2 + Character.charCount(n3);
                stringArray[i2] = ((String)object).substring(n2, n4);
                n2 = n4;
            }
            string = numberingSystem.getName();
        } else {
            stringArray = DEF_DIGIT_STRINGS_ARRAY;
            string = LATIN_NUMBERING_SYSTEM;
        }
        object = (ICUResourceBundle)UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", uLocale);
        ULocale uLocale2 = ((ICUResourceBundle)object).getULocale();
        String[] stringArray2 = new String[SYMBOL_KEYS.length];
        DecFmtDataSink decFmtDataSink = new DecFmtDataSink(stringArray2);
        try {
            ((ICUResourceBundle)object).getAllItemsWithFallback("NumberElements/" + string + "/" + SYMBOLS, decFmtDataSink);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        boolean bl2 = false;
        for (String string2 : stringArray2) {
            if (string2 != null) continue;
            bl2 = true;
            break;
        }
        if (bl2 && !string.equals(LATIN_NUMBERING_SYSTEM)) {
            ((ICUResourceBundle)object).getAllItemsWithFallback("NumberElements/latn/symbols", decFmtDataSink);
        }
        for (int i3 = 0; i3 < SYMBOL_KEYS.length; ++i3) {
            if (stringArray2[i3] != null) continue;
            stringArray2[i3] = SYMBOL_DEFAULTS[i3];
        }
        if (stringArray2[9] == null) {
            stringArray2[9] = stringArray2[0];
        }
        if (stringArray2[10] == null) {
            stringArray2[10] = stringArray2[1];
        }
        return new CacheData(uLocale2, stringArray, stringArray2);
    }

    private void initSpacingInfo(CurrencyData.CurrencySpacingInfo currencySpacingInfo) {
        this.currencySpcBeforeSym = currencySpacingInfo.getBeforeSymbols();
        this.currencySpcAfterSym = currencySpacingInfo.getAfterSymbols();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.monetarySeparator = this.decimalSeparator;
            this.exponential = (char)69;
        }
        if (this.serialVersionOnStream < 2) {
            this.padEscape = (char)42;
            this.plusSign = (char)43;
            this.exponentSeparator = String.valueOf(this.exponential);
        }
        if (this.serialVersionOnStream < 3) {
            this.requestedLocale = Locale.getDefault();
        }
        if (this.serialVersionOnStream < 4) {
            this.ulocale = ULocale.forLocale(this.requestedLocale);
        }
        if (this.serialVersionOnStream < 5) {
            this.monetaryGroupingSeparator = this.groupingSeparator;
        }
        if (this.serialVersionOnStream < 6) {
            if (this.currencySpcBeforeSym == null) {
                this.currencySpcBeforeSym = new String[3];
            }
            if (this.currencySpcAfterSym == null) {
                this.currencySpcAfterSym = new String[3];
            }
            this.initSpacingInfo(CurrencyData.CurrencySpacingInfo.DEFAULT);
        }
        if (this.serialVersionOnStream < 7) {
            if (this.minusString == null) {
                this.minusString = String.valueOf(this.minusSign);
            }
            if (this.plusString == null) {
                this.plusString = String.valueOf(this.plusSign);
            }
        }
        if (this.serialVersionOnStream < 8 && this.exponentMultiplicationSign == null) {
            this.exponentMultiplicationSign = "\u00d7";
        }
        if (this.serialVersionOnStream < 9) {
            if (this.digitStrings == null) {
                this.digitStrings = new String[10];
                if (this.digits != null && this.digits.length == 10) {
                    this.zeroDigit = this.digits[0];
                    for (int i2 = 0; i2 < 10; ++i2) {
                        this.digitStrings[i2] = String.valueOf(this.digits[i2]);
                    }
                } else {
                    char c2 = this.zeroDigit;
                    if (this.digits == null) {
                        this.digits = new char[10];
                    }
                    for (int i3 = 0; i3 < 10; ++i3) {
                        this.digits[i3] = c2;
                        this.digitStrings[i3] = String.valueOf(c2);
                        c2 = (char)(c2 + '\u0001');
                    }
                }
            }
            if (this.decimalSeparatorString == null) {
                this.decimalSeparatorString = String.valueOf(this.decimalSeparator);
            }
            if (this.groupingSeparatorString == null) {
                this.groupingSeparatorString = String.valueOf(this.groupingSeparator);
            }
            if (this.percentString == null) {
                this.percentString = String.valueOf(this.percent);
            }
            if (this.perMillString == null) {
                this.perMillString = String.valueOf(this.perMill);
            }
            if (this.monetarySeparatorString == null) {
                this.monetarySeparatorString = String.valueOf(this.monetarySeparator);
            }
            if (this.monetaryGroupingSeparatorString == null) {
                this.monetaryGroupingSeparatorString = String.valueOf(this.monetaryGroupingSeparator);
            }
        }
        if (this.serialVersionOnStream < 10) {
            this.approximatelyString = "~";
        }
        this.serialVersionOnStream = 10;
        this.currency = Currency.getInstance(this.intlCurrencySymbol);
        this.setDigitStrings(this.digitStrings);
    }

    public final ULocale getLocale(ULocale.Type type) {
        return type == ULocale.ACTUAL_LOCALE ? this.actualLocale : this.validLocale;
    }

    final void setLocale(ULocale uLocale, ULocale uLocale2) {
        if (uLocale == null != (uLocale2 == null)) {
            throw new IllegalArgumentException();
        }
        this.validLocale = uLocale;
        this.actualLocale = uLocale2;
    }

    private static class CacheData {
        final ULocale validLocale;
        final String[] digits;
        final String[] numberElements;

        public CacheData(ULocale uLocale, String[] stringArray, String[] stringArray2) {
            this.validLocale = uLocale;
            this.digits = stringArray;
            this.numberElements = stringArray2;
        }
    }

    private static final class DecFmtDataSink
    extends UResource.Sink {
        private String[] numberElements;

        public DecFmtDataSink(String[] stringArray) {
            this.numberElements = stringArray;
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean bl2) {
            UResource.Table table = value.getTable();
            int n2 = 0;
            while (table.getKeyAndValue(n2, key, value)) {
                for (int i2 = 0; i2 < SYMBOL_KEYS.length; ++i2) {
                    if (!key.contentEquals(SYMBOL_KEYS[i2])) continue;
                    if (this.numberElements[i2] != null) break;
                    this.numberElements[i2] = value.toString();
                    break;
                }
                ++n2;
            }
        }
    }
}

