/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUCache;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.PatternTokenizer;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.SimpleCache;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.SimpleFormatterImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.UResource;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DateFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DecimalFormatSymbols;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.SimpleDateFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Calendar;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Freezable;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUCloneNotSupportedException;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Region;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundle;

public class DateTimePatternGenerator
implements Freezable<DateTimePatternGenerator>,
Cloneable {
    private static final boolean DEBUG = false;
    private static final String[] LAST_RESORT_ALLOWED_HOUR_FORMAT = new String[]{"H"};
    static final Map<String, String[]> LOCALE_TO_ALLOWED_HOUR;
    public static final int ERA = 0;
    public static final int YEAR = 1;
    public static final int QUARTER = 2;
    public static final int MONTH = 3;
    public static final int WEEK_OF_YEAR = 4;
    public static final int WEEK_OF_MONTH = 5;
    public static final int WEEKDAY = 6;
    public static final int DAY = 7;
    public static final int DAY_OF_YEAR = 8;
    public static final int DAY_OF_WEEK_IN_MONTH = 9;
    public static final int DAYPERIOD = 10;
    public static final int HOUR = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int FRACTIONAL_SECOND = 14;
    public static final int ZONE = 15;
    @Deprecated
    public static final int TYPE_LIMIT = 16;
    private static final DisplayWidth APPENDITEM_WIDTH;
    private static final int APPENDITEM_WIDTH_INT;
    private static final DisplayWidth[] CLDR_FIELD_WIDTH;
    public static final int MATCH_NO_OPTIONS = 0;
    public static final int MATCH_HOUR_FIELD_LENGTH = 2048;
    @Deprecated
    public static final int MATCH_MINUTE_FIELD_LENGTH = 4096;
    @Deprecated
    public static final int MATCH_SECOND_FIELD_LENGTH = 8192;
    public static final int MATCH_ALL_FIELDS_LENGTH = 65535;
    private TreeMap<DateTimeMatcher, PatternWithSkeletonFlag> skeleton2pattern = new TreeMap();
    private TreeMap<String, PatternWithSkeletonFlag> basePattern_pattern = new TreeMap();
    private String decimal = "?";
    private String[] dateTimeFormats = new String[]{"{1} {0}", "{1} {0}", "{1} {0}", "{1} {0}"};
    private String[] appendItemFormats = new String[16];
    private String[][] fieldDisplayNames = new String[16][DisplayWidth.access$100()];
    private char defaultHourFormatChar = (char)72;
    private volatile boolean frozen = false;
    private transient DateTimeMatcher current = new DateTimeMatcher();
    private transient FormatParser fp = new FormatParser();
    private transient DistanceInfo _distanceInfo = new DistanceInfo();
    private String[] allowedHourFormats;
    private static final int FRACTIONAL_MASK = 16384;
    private static final int SECOND_AND_FRACTIONAL_MASK = 24576;
    private static ICUCache<String, DateTimePatternGenerator> DTPNG_CACHE;
    private static final String[] CLDR_FIELD_APPEND;
    private static final String[] CLDR_FIELD_NAME;
    private static final String[] FIELD_NAME;
    private static final String[] CANONICAL_ITEMS;
    private static final Set<String> CANONICAL_SET;
    private Set<String> cldrAvailableFormatKeys = new HashSet<String>(20);
    private static final int DATE_MASK = 1023;
    private static final int TIME_MASK = 64512;
    private static final int DELTA = 16;
    private static final int NUMERIC = 256;
    private static final int NONE = 0;
    private static final int NARROW = -257;
    private static final int SHORTER = -258;
    private static final int SHORT = -259;
    private static final int LONG = -260;
    private static final int EXTRA_FIELD = 65536;
    private static final int MISSING_FIELD = 4096;
    private static final int[][] types;

    public static DateTimePatternGenerator getEmptyInstance() {
        DateTimePatternGenerator dateTimePatternGenerator = new DateTimePatternGenerator();
        dateTimePatternGenerator.addCanonicalItems();
        dateTimePatternGenerator.fillInMissing();
        return dateTimePatternGenerator;
    }

    protected DateTimePatternGenerator() {
    }

    public static DateTimePatternGenerator getInstance() {
        return DateTimePatternGenerator.getInstance(ULocale.getDefault(ULocale.Category.FORMAT));
    }

    public static DateTimePatternGenerator getInstance(ULocale uLocale) {
        return DateTimePatternGenerator.getFrozenInstance(uLocale).cloneAsThawed();
    }

    public static DateTimePatternGenerator getInstance(Locale locale) {
        return DateTimePatternGenerator.getInstance(ULocale.forLocale(locale));
    }

    @Deprecated
    public static DateTimePatternGenerator getFrozenInstance(ULocale uLocale) {
        String string = uLocale.toString();
        DateTimePatternGenerator dateTimePatternGenerator = DTPNG_CACHE.get(string);
        if (dateTimePatternGenerator != null) {
            return dateTimePatternGenerator;
        }
        dateTimePatternGenerator = new DateTimePatternGenerator();
        dateTimePatternGenerator.initData(uLocale, false);
        dateTimePatternGenerator.freeze();
        DTPNG_CACHE.put(string, dateTimePatternGenerator);
        return dateTimePatternGenerator;
    }

    @Deprecated
    public static DateTimePatternGenerator getInstanceNoStdPat(ULocale uLocale) {
        DateTimePatternGenerator dateTimePatternGenerator = new DateTimePatternGenerator();
        dateTimePatternGenerator.initData(uLocale, true);
        return dateTimePatternGenerator;
    }

    private void initData(ULocale uLocale, boolean bl2) {
        PatternInfo patternInfo = new PatternInfo();
        this.addCanonicalItems();
        if (!bl2) {
            this.addICUPatterns(patternInfo, uLocale);
        }
        this.addCLDRData(patternInfo, uLocale);
        if (!bl2) {
            this.setDateTimeFromCalendar(uLocale);
        } else {
            this.setDateTimeFormat("{1} {0}");
        }
        this.setDecimalSymbols(uLocale);
        this.getAllowedHourFormats(uLocale);
        this.fillInMissing();
    }

    private void addICUPatterns(PatternInfo patternInfo, ULocale uLocale) {
        for (int i2 = 0; i2 <= 3; ++i2) {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateInstance(i2, uLocale);
            this.addPattern(simpleDateFormat.toPattern(), false, patternInfo);
            simpleDateFormat = (SimpleDateFormat)DateFormat.getTimeInstance(i2, uLocale);
            this.addPattern(simpleDateFormat.toPattern(), false, patternInfo);
            if (i2 != 3) continue;
            this.consumeShortTimePattern(simpleDateFormat.toPattern(), patternInfo);
        }
    }

    private String getCalendarTypeToUse(ULocale uLocale) {
        String string = uLocale.getKeywordValue("calendar");
        if (string == null) {
            String[] stringArray = Calendar.getKeywordValuesForLocale("calendar", uLocale, true);
            string = stringArray[0];
        }
        if (string == null) {
            string = "gregorian";
        }
        return string;
    }

    private void consumeShortTimePattern(String string, PatternInfo patternInfo) {
        this.hackTimes(patternInfo, string);
    }

    private void fillInMissing() {
        for (int i2 = 0; i2 < 16; ++i2) {
            if (this.getAppendItemFormat(i2) == null) {
                this.setAppendItemFormat(i2, "{0} \u251c{2}: {1}\u2524");
            }
            if (this.getFieldDisplayName(i2, DisplayWidth.WIDE) == null) {
                this.setFieldDisplayName(i2, DisplayWidth.WIDE, "F" + i2);
            }
            if (this.getFieldDisplayName(i2, DisplayWidth.ABBREVIATED) == null) {
                this.setFieldDisplayName(i2, DisplayWidth.ABBREVIATED, this.getFieldDisplayName(i2, DisplayWidth.WIDE));
            }
            if (this.getFieldDisplayName(i2, DisplayWidth.NARROW) != null) continue;
            this.setFieldDisplayName(i2, DisplayWidth.NARROW, this.getFieldDisplayName(i2, DisplayWidth.ABBREVIATED));
        }
    }

    private void addCLDRData(PatternInfo patternInfo, ULocale uLocale) {
        ICUResourceBundle iCUResourceBundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", uLocale);
        String string = this.getCalendarTypeToUse(uLocale);
        AppendItemFormatsSink appendItemFormatsSink = new AppendItemFormatsSink();
        try {
            iCUResourceBundle.getAllChildrenWithFallback("calendar/" + string + "/appendItems", appendItemFormatsSink);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        AppendItemNamesSink appendItemNamesSink = new AppendItemNamesSink();
        try {
            iCUResourceBundle.getAllChildrenWithFallback("fields", appendItemNamesSink);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        AvailableFormatsSink availableFormatsSink = new AvailableFormatsSink(patternInfo);
        try {
            iCUResourceBundle.getAllChildrenWithFallback("calendar/" + string + "/availableFormats", availableFormatsSink);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    private void setDateTimeFromCalendar(ULocale uLocale) {
        Calendar calendar = Calendar.getInstance(uLocale);
        for (int i2 = 0; i2 <= 3; ++i2) {
            String string = Calendar.getDateAtTimePattern(calendar, uLocale, i2);
            this.setDateTimeFormat(i2, string);
        }
    }

    private void setDecimalSymbols(ULocale uLocale) {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(uLocale);
        this.setDecimal(String.valueOf(decimalFormatSymbols.getDecimalSeparator()));
    }

    private String[] getAllowedHourFormatsLangCountry(String string, String string2) {
        String string3 = string + "_" + string2;
        String[] stringArray = LOCALE_TO_ALLOWED_HOUR.get(string3);
        if (stringArray == null) {
            stringArray = LOCALE_TO_ALLOWED_HOUR.get(string2);
        }
        return stringArray;
    }

    private void getAllowedHourFormats(ULocale uLocale) {
        String[] stringArray;
        String string = uLocale.getLanguage();
        String string2 = ULocale.getRegionForSupplementalData(uLocale, false);
        if (string.isEmpty() || string2.isEmpty()) {
            stringArray = ULocale.addLikelySubtags(uLocale);
            string = stringArray.getLanguage();
            string2 = stringArray.getCountry();
        }
        if (string.isEmpty()) {
            string = "und";
        }
        if (string2.isEmpty()) {
            string2 = "001";
        }
        stringArray = this.getAllowedHourFormatsLangCountry(string, string2);
        Character c2 = null;
        String string3 = uLocale.getKeywordValue("hours");
        if (string3 != null) {
            switch (string3) {
                case "h24": {
                    c2 = Character.valueOf('k');
                    break;
                }
                case "h23": {
                    c2 = Character.valueOf('H');
                    break;
                }
                case "h12": {
                    c2 = Character.valueOf('h');
                    break;
                }
                case "h11": {
                    c2 = Character.valueOf('K');
                }
            }
        }
        if (stringArray == null) {
            try {
                Object object = Region.getInstance(string2);
                string2 = ((Region)object).toString();
                stringArray = this.getAllowedHourFormatsLangCountry(string, string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (stringArray != null) {
            this.defaultHourFormatChar = c2 != null ? c2.charValue() : stringArray[0].charAt(0);
            this.allowedHourFormats = Arrays.copyOfRange(stringArray, 1, stringArray.length - 1);
        } else {
            this.allowedHourFormats = LAST_RESORT_ALLOWED_HOUR_FORMAT;
            this.defaultHourFormatChar = c2 != null ? c2.charValue() : this.allowedHourFormats[0].charAt(0);
        }
    }

    @Deprecated
    public char getDefaultHourFormatChar() {
        return this.defaultHourFormatChar;
    }

    @Deprecated
    public void setDefaultHourFormatChar(char c2) {
        this.defaultHourFormatChar = c2;
    }

    private void hackTimes(PatternInfo patternInfo, String string) {
        int n2;
        Object object;
        this.fp.set(string);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        for (int i2 = 0; i2 < this.fp.items.size(); ++i2) {
            object = this.fp.items.get(i2);
            if (object instanceof String) {
                if (!bl2) continue;
                stringBuilder.append(this.fp.quoteLiteral(object.toString()));
                continue;
            }
            n2 = object.toString().charAt(0);
            if (n2 == 109) {
                bl2 = true;
                stringBuilder.append(object);
                continue;
            }
            if (n2 == 115) {
                if (!bl2) break;
                stringBuilder.append(object);
                this.addPattern(stringBuilder.toString(), false, patternInfo);
                break;
            }
            if (bl2 || n2 == 122 || n2 == 90 || n2 == 118 || n2 == 86) break;
        }
        BitSet bitSet = new BitSet();
        object = new BitSet();
        for (n2 = 0; n2 < this.fp.items.size(); ++n2) {
            Object e2 = this.fp.items.get(n2);
            if (!(e2 instanceof VariableField)) continue;
            bitSet.set(n2);
            char c2 = e2.toString().charAt(0);
            if (c2 != 's' && c2 != 'S') continue;
            ((BitSet)object).set(n2);
            for (int i3 = n2 - 1; i3 >= 0 && !bitSet.get(i3); ++i3) {
                ((BitSet)object).set(n2);
            }
        }
        String string2 = DateTimePatternGenerator.getFilteredPattern(this.fp, (BitSet)object);
        this.addPattern(string2, false, patternInfo);
    }

    private static String getFilteredPattern(FormatParser formatParser, BitSet bitSet) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < formatParser.items.size(); ++i2) {
            if (bitSet.get(i2)) continue;
            Object e2 = formatParser.items.get(i2);
            if (e2 instanceof String) {
                stringBuilder.append(formatParser.quoteLiteral(e2.toString()));
                continue;
            }
            stringBuilder.append(e2.toString());
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public static int getAppendFormatNumber(UResource.Key key) {
        for (int i2 = 0; i2 < CLDR_FIELD_APPEND.length; ++i2) {
            if (!key.contentEquals(CLDR_FIELD_APPEND[i2])) continue;
            return i2;
        }
        return -1;
    }

    @Deprecated
    public static int getAppendFormatNumber(String string) {
        for (int i2 = 0; i2 < CLDR_FIELD_APPEND.length; ++i2) {
            if (!CLDR_FIELD_APPEND[i2].equals(string)) continue;
            return i2;
        }
        return -1;
    }

    private static int getCLDRFieldAndWidthNumber(UResource.Key key) {
        for (int i2 = 0; i2 < CLDR_FIELD_NAME.length; ++i2) {
            for (int i3 = 0; i3 < DisplayWidth.COUNT; ++i3) {
                String string = CLDR_FIELD_NAME[i2].concat(DateTimePatternGenerator.CLDR_FIELD_WIDTH[i3].cldrKey());
                if (!key.contentEquals(string)) continue;
                return i2 * DisplayWidth.COUNT + i3;
            }
        }
        return -1;
    }

    public String getBestPattern(String string) {
        return this.getBestPattern(string, null, 0);
    }

    public String getBestPattern(String string, int n2) {
        return this.getBestPattern(string, null, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBestPattern(String string, DateTimeMatcher dateTimeMatcher, int n2) {
        String string2;
        String string3;
        int n3;
        EnumSet<DTPGflags> enumSet = EnumSet.noneOf(DTPGflags.class);
        String string4 = this.mapSkeletonMetacharacters(string, enumSet);
        Object object = this;
        synchronized (object) {
            this.current.set(string4, this.fp, false);
            PatternWithMatcher patternWithMatcher = this.getBestRaw(this.current, -1, this._distanceInfo, dateTimeMatcher);
            if (this._distanceInfo.missingFieldMask == 0 && this._distanceInfo.extraFieldMask == 0) {
                return this.adjustFieldTypes(patternWithMatcher, this.current, enumSet, n2);
            }
            n3 = this.current.getFieldMask();
            string3 = this.getBestAppending(this.current, n3 & 0x3FF, this._distanceInfo, dateTimeMatcher, enumSet, n2);
            string2 = this.getBestAppending(this.current, n3 & 0xFC00, this._distanceInfo, dateTimeMatcher, enumSet, n2);
        }
        if (string3 == null) {
            return string2 == null ? "" : string2;
        }
        if (string2 == null) {
            return string3;
        }
        object = this.current.toCanonicalString();
        int n4 = 3;
        n3 = 0;
        int n5 = ((String)object).indexOf(77);
        if (n5 >= 0) {
            n3 = 1 + ((String)object).lastIndexOf(77) - n5;
        }
        if (n3 == 4) {
            n4 = ((String)object).indexOf(69) >= 0 ? 0 : 1;
        } else if (n3 == 3) {
            n4 = 2;
        }
        return SimpleFormatterImpl.formatRawPattern(this.getDateTimeFormat(n4), 2, 2, string2, string3);
    }

    private String mapSkeletonMetacharacters(String string, EnumSet<DTPGflags> enumSet) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\'') {
                bl2 = !bl2;
                continue;
            }
            if (bl2) continue;
            if (c2 == 'j' || c2 == 'C') {
                int n2 = 0;
                while (i2 + 1 < string.length() && string.charAt(i2 + 1) == c2) {
                    ++n2;
                    ++i2;
                }
                int n3 = 1 + (n2 & 1);
                int n4 = n2 < 2 ? 1 : 3 + (n2 >> 1);
                char c3 = 'h';
                char c4 = 'a';
                if (c2 == 'j') {
                    c3 = this.defaultHourFormatChar;
                } else {
                    String string2 = this.allowedHourFormats[0];
                    c3 = string2.charAt(0);
                    char c5 = string2.charAt(string2.length() - 1);
                    if (c5 == 'b' || c5 == 'B') {
                        c4 = c5;
                    }
                }
                if (c3 == 'H' || c3 == 'k') {
                    n4 = 0;
                }
                while (n4-- > 0) {
                    stringBuilder.append(c4);
                }
                while (n3-- > 0) {
                    stringBuilder.append(c3);
                }
                continue;
            }
            if (c2 == 'J') {
                stringBuilder.append('H');
                enumSet.add(DTPGflags.SKELETON_USES_CAP_J);
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public DateTimePatternGenerator addPattern(String string, boolean bl2, PatternInfo patternInfo) {
        return this.addPatternWithSkeleton(string, null, bl2, patternInfo);
    }

    @Deprecated
    public DateTimePatternGenerator addPatternWithSkeleton(String string, String string2, boolean bl2, PatternInfo patternInfo) {
        PatternWithSkeletonFlag patternWithSkeletonFlag;
        this.checkFrozen();
        DateTimeMatcher dateTimeMatcher = string2 == null ? new DateTimeMatcher().set(string, this.fp, false) : new DateTimeMatcher().set(string2, this.fp, false);
        String string3 = dateTimeMatcher.getBasePattern();
        PatternWithSkeletonFlag patternWithSkeletonFlag2 = this.basePattern_pattern.get(string3);
        if (patternWithSkeletonFlag2 != null && (!patternWithSkeletonFlag2.skeletonWasSpecified || string2 != null && !bl2)) {
            patternInfo.status = 1;
            patternInfo.conflictingPattern = patternWithSkeletonFlag2.pattern;
            if (!bl2) {
                return this;
            }
        }
        if ((patternWithSkeletonFlag = this.skeleton2pattern.get(dateTimeMatcher)) != null) {
            patternInfo.status = 2;
            patternInfo.conflictingPattern = patternWithSkeletonFlag.pattern;
            if (!bl2 || string2 != null && patternWithSkeletonFlag.skeletonWasSpecified) {
                return this;
            }
        }
        patternInfo.status = 0;
        patternInfo.conflictingPattern = "";
        PatternWithSkeletonFlag patternWithSkeletonFlag3 = new PatternWithSkeletonFlag(string, string2 != null);
        this.skeleton2pattern.put(dateTimeMatcher, patternWithSkeletonFlag3);
        this.basePattern_pattern.put(string3, patternWithSkeletonFlag3);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSkeleton(String string) {
        DateTimePatternGenerator dateTimePatternGenerator = this;
        synchronized (dateTimePatternGenerator) {
            this.current.set(string, this.fp, false);
            return this.current.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String getSkeletonAllowingDuplicates(String string) {
        DateTimePatternGenerator dateTimePatternGenerator = this;
        synchronized (dateTimePatternGenerator) {
            this.current.set(string, this.fp, true);
            return this.current.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String getCanonicalSkeletonAllowingDuplicates(String string) {
        DateTimePatternGenerator dateTimePatternGenerator = this;
        synchronized (dateTimePatternGenerator) {
            this.current.set(string, this.fp, true);
            return this.current.toCanonicalString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBaseSkeleton(String string) {
        DateTimePatternGenerator dateTimePatternGenerator = this;
        synchronized (dateTimePatternGenerator) {
            this.current.set(string, this.fp, false);
            return this.current.getBasePattern();
        }
    }

    public Map<String, String> getSkeletons(Map<String, String> map) {
        if (map == null) {
            map = new LinkedHashMap<String, String>();
        }
        for (DateTimeMatcher dateTimeMatcher : this.skeleton2pattern.keySet()) {
            PatternWithSkeletonFlag patternWithSkeletonFlag = this.skeleton2pattern.get(dateTimeMatcher);
            String string = patternWithSkeletonFlag.pattern;
            if (CANONICAL_SET.contains(string)) continue;
            map.put(dateTimeMatcher.toString(), string);
        }
        return map;
    }

    public Set<String> getBaseSkeletons(Set<String> set) {
        if (set == null) {
            set = new HashSet<String>();
        }
        set.addAll(this.basePattern_pattern.keySet());
        return set;
    }

    public String replaceFieldTypes(String string, String string2) {
        return this.replaceFieldTypes(string, string2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String replaceFieldTypes(String string, String string2, int n2) {
        DateTimePatternGenerator dateTimePatternGenerator = this;
        synchronized (dateTimePatternGenerator) {
            PatternWithMatcher patternWithMatcher = new PatternWithMatcher(string, null);
            return this.adjustFieldTypes(patternWithMatcher, this.current.set(string2, this.fp, false), EnumSet.noneOf(DTPGflags.class), n2);
        }
    }

    public void setDateTimeFormat(String string) {
        this.checkFrozen();
        for (int i2 = 0; i2 <= 3; ++i2) {
            this.setDateTimeFormat(i2, string);
        }
    }

    public String getDateTimeFormat() {
        return this.getDateTimeFormat(2);
    }

    public void setDateTimeFormat(int n2, String string) {
        if (n2 < 0 || n2 > 3) {
            throw new IllegalArgumentException("Illegal style here: " + n2);
        }
        this.checkFrozen();
        this.dateTimeFormats[n2] = string;
    }

    public String getDateTimeFormat(int n2) {
        if (n2 < 0 || n2 > 3) {
            throw new IllegalArgumentException("Illegal style here: " + n2);
        }
        return this.dateTimeFormats[n2];
    }

    public void setDecimal(String string) {
        this.checkFrozen();
        this.decimal = string;
    }

    public String getDecimal() {
        return this.decimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Collection<String> getRedundants(Collection<String> collection) {
        DateTimePatternGenerator dateTimePatternGenerator = this;
        synchronized (dateTimePatternGenerator) {
            if (collection == null) {
                collection = new LinkedHashSet<String>();
            }
            for (DateTimeMatcher dateTimeMatcher : this.skeleton2pattern.keySet()) {
                String string;
                PatternWithSkeletonFlag patternWithSkeletonFlag = this.skeleton2pattern.get(dateTimeMatcher);
                String string2 = patternWithSkeletonFlag.pattern;
                if (CANONICAL_SET.contains(string2) || !(string = this.getBestPattern(dateTimeMatcher.toString(), dateTimeMatcher, 0)).equals(string2)) continue;
                collection.add(string2);
            }
            return collection;
        }
    }

    public void setAppendItemFormat(int n2, String string) {
        this.checkFrozen();
        this.appendItemFormats[n2] = string;
    }

    public String getAppendItemFormat(int n2) {
        return this.appendItemFormats[n2];
    }

    public void setAppendItemName(int n2, String string) {
        this.setFieldDisplayName(n2, APPENDITEM_WIDTH, string);
    }

    public String getAppendItemName(int n2) {
        return this.getFieldDisplayName(n2, APPENDITEM_WIDTH);
    }

    public DateFormat.HourCycle getDefaultHourCycle() {
        switch (this.getDefaultHourFormatChar()) {
            case 'h': {
                return DateFormat.HourCycle.HOUR_CYCLE_12;
            }
            case 'H': {
                return DateFormat.HourCycle.HOUR_CYCLE_23;
            }
            case 'k': {
                return DateFormat.HourCycle.HOUR_CYCLE_24;
            }
            case 'K': {
                return DateFormat.HourCycle.HOUR_CYCLE_11;
            }
        }
        throw new AssertionError((Object)"should be unreachable");
    }

    @Deprecated
    private void setFieldDisplayName(int n2, DisplayWidth displayWidth, String string) {
        this.checkFrozen();
        if (n2 < 16 && n2 >= 0) {
            this.fieldDisplayNames[n2][displayWidth.ordinal()] = string;
        }
    }

    public String getFieldDisplayName(int n2, DisplayWidth displayWidth) {
        if (n2 >= 16 || n2 < 0) {
            return "";
        }
        return this.fieldDisplayNames[n2][displayWidth.ordinal()];
    }

    @Deprecated
    public static boolean isSingleField(String string) {
        char c2 = string.charAt(0);
        for (int i2 = 1; i2 < string.length(); ++i2) {
            if (string.charAt(i2) == c2) continue;
            return false;
        }
        return true;
    }

    private void setAvailableFormat(String string) {
        this.checkFrozen();
        this.cldrAvailableFormatKeys.add(string);
    }

    private boolean isAvailableFormatSet(String string) {
        return this.cldrAvailableFormatKeys.contains(string);
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    public DateTimePatternGenerator freeze() {
        this.frozen = true;
        return this;
    }

    @Override
    public DateTimePatternGenerator cloneAsThawed() {
        DateTimePatternGenerator dateTimePatternGenerator = (DateTimePatternGenerator)this.clone();
        this.frozen = false;
        return dateTimePatternGenerator;
    }

    public Object clone() {
        try {
            DateTimePatternGenerator dateTimePatternGenerator = (DateTimePatternGenerator)super.clone();
            dateTimePatternGenerator.skeleton2pattern = (TreeMap)this.skeleton2pattern.clone();
            dateTimePatternGenerator.basePattern_pattern = (TreeMap)this.basePattern_pattern.clone();
            dateTimePatternGenerator.dateTimeFormats = (String[])this.dateTimeFormats.clone();
            dateTimePatternGenerator.appendItemFormats = (String[])this.appendItemFormats.clone();
            dateTimePatternGenerator.fieldDisplayNames = (String[][])this.fieldDisplayNames.clone();
            dateTimePatternGenerator.current = new DateTimeMatcher();
            dateTimePatternGenerator.fp = new FormatParser();
            dateTimePatternGenerator._distanceInfo = new DistanceInfo();
            dateTimePatternGenerator.frozen = false;
            return dateTimePatternGenerator;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ICUCloneNotSupportedException("Internal Error", cloneNotSupportedException);
        }
    }

    @Deprecated
    public boolean skeletonsAreSimilar(String string, String string2) {
        if (string.equals(string2)) {
            return true;
        }
        TreeSet<String> treeSet = this.getSet(string);
        TreeSet<String> treeSet2 = this.getSet(string2);
        if (treeSet.size() != treeSet2.size()) {
            return false;
        }
        Iterator<String> iterator = treeSet2.iterator();
        for (String string3 : treeSet) {
            String string4;
            int n2;
            int n3 = DateTimePatternGenerator.getCanonicalIndex(string3, false);
            if (types[n3][1] == types[n2 = DateTimePatternGenerator.getCanonicalIndex(string4 = iterator.next(), false)][1]) continue;
            return false;
        }
        return true;
    }

    private TreeSet<String> getSet(String string) {
        List<Object> list = this.fp.set(string).getItems();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Object object : list) {
            String string2 = object.toString();
            if (string2.startsWith("G") || string2.startsWith("a")) continue;
            treeSet.add(string2);
        }
        return treeSet;
    }

    private void checkFrozen() {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify frozen object");
        }
    }

    private String getBestAppending(DateTimeMatcher dateTimeMatcher, int n2, DistanceInfo distanceInfo, DateTimeMatcher dateTimeMatcher2, EnumSet<DTPGflags> enumSet, int n3) {
        String string = null;
        if (n2 != 0) {
            PatternWithMatcher patternWithMatcher = this.getBestRaw(dateTimeMatcher, n2, distanceInfo, dateTimeMatcher2);
            string = this.adjustFieldTypes(patternWithMatcher, dateTimeMatcher, enumSet, n3);
            while (distanceInfo.missingFieldMask != 0) {
                if ((distanceInfo.missingFieldMask & 0x6000) == 16384 && (n2 & 0x6000) == 24576) {
                    patternWithMatcher.pattern = string;
                    enumSet = EnumSet.copyOf(enumSet);
                    enumSet.add(DTPGflags.FIX_FRACTIONAL_SECONDS);
                    string = this.adjustFieldTypes(patternWithMatcher, dateTimeMatcher, enumSet, n3);
                    distanceInfo.missingFieldMask &= 0xFFFFBFFF;
                    continue;
                }
                int n4 = distanceInfo.missingFieldMask;
                PatternWithMatcher patternWithMatcher2 = this.getBestRaw(dateTimeMatcher, distanceInfo.missingFieldMask, distanceInfo, dateTimeMatcher2);
                String string2 = this.adjustFieldTypes(patternWithMatcher2, dateTimeMatcher, enumSet, n3);
                int n5 = n4 & ~distanceInfo.missingFieldMask;
                int n6 = this.getTopBitNumber(n5);
                string = SimpleFormatterImpl.formatRawPattern(this.getAppendFormat(n6), 2, 3, string, string2, this.getAppendName(n6));
            }
        }
        return string;
    }

    private String getAppendName(int n2) {
        return "'" + this.fieldDisplayNames[n2][APPENDITEM_WIDTH_INT] + "'";
    }

    private String getAppendFormat(int n2) {
        return this.appendItemFormats[n2];
    }

    private int getTopBitNumber(int n2) {
        int n3 = 0;
        while (n2 != 0) {
            n2 >>>= 1;
            ++n3;
        }
        return n3 - 1;
    }

    private void addCanonicalItems() {
        PatternInfo patternInfo = new PatternInfo();
        for (int i2 = 0; i2 < CANONICAL_ITEMS.length; ++i2) {
            this.addPattern(String.valueOf(CANONICAL_ITEMS[i2]), false, patternInfo);
        }
    }

    private PatternWithMatcher getBestRaw(DateTimeMatcher dateTimeMatcher, int n2, DistanceInfo distanceInfo, DateTimeMatcher dateTimeMatcher2) {
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        PatternWithMatcher patternWithMatcher = new PatternWithMatcher("", null);
        DistanceInfo distanceInfo2 = new DistanceInfo();
        for (DateTimeMatcher dateTimeMatcher3 : this.skeleton2pattern.keySet()) {
            int n5;
            if (dateTimeMatcher3.equals(dateTimeMatcher2) || (n5 = dateTimeMatcher.getDistance(dateTimeMatcher3, n2, distanceInfo2)) >= n3 && (n5 != n3 || n4 >= distanceInfo2.missingFieldMask)) continue;
            n3 = n5;
            n4 = distanceInfo2.missingFieldMask;
            PatternWithSkeletonFlag patternWithSkeletonFlag = this.skeleton2pattern.get(dateTimeMatcher3);
            patternWithMatcher.pattern = patternWithSkeletonFlag.pattern;
            patternWithMatcher.matcherWithSkeleton = patternWithSkeletonFlag.skeletonWasSpecified ? dateTimeMatcher3 : null;
            distanceInfo.setTo(distanceInfo2);
            if (n5 != 0) continue;
            break;
        }
        return patternWithMatcher;
    }

    private String adjustFieldTypes(PatternWithMatcher patternWithMatcher, DateTimeMatcher dateTimeMatcher, EnumSet<DTPGflags> enumSet, int n2) {
        this.fp.set(patternWithMatcher.pattern);
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : this.fp.getItems()) {
            if (object instanceof String) {
                stringBuilder.append(this.fp.quoteLiteral((String)object));
                continue;
            }
            VariableField variableField = (VariableField)object;
            StringBuilder stringBuilder2 = new StringBuilder(variableField.toString());
            int n3 = variableField.getType();
            if (enumSet.contains((Object)DTPGflags.FIX_FRACTIONAL_SECONDS) && n3 == 13) {
                stringBuilder2.append(this.decimal);
                dateTimeMatcher.original.appendFieldTo(14, stringBuilder2);
            } else if (dateTimeMatcher.type[n3] != 0) {
                int n4;
                int n5;
                char c2 = dateTimeMatcher.original.getFieldChar(n3);
                int n6 = dateTimeMatcher.original.getFieldLength(n3);
                if (c2 == 'E' && n6 < 3) {
                    n6 = 3;
                }
                int n7 = n6;
                DateTimeMatcher dateTimeMatcher2 = patternWithMatcher.matcherWithSkeleton;
                if (n3 == 11 && (n2 & 0x800) == 0 || n3 == 12 && (n2 & 0x1000) == 0 || n3 == 13 && (n2 & 0x2000) == 0) {
                    n7 = stringBuilder2.length();
                } else if (dateTimeMatcher2 != null && c2 != 'c' && c2 != 'e') {
                    n5 = dateTimeMatcher2.original.getFieldLength(n3);
                    n4 = variableField.isNumeric();
                    boolean bl2 = dateTimeMatcher2.fieldIsNumeric(n3);
                    if (n5 == n6 || n4 != 0 && !bl2 || bl2 && n4 == 0) {
                        n7 = stringBuilder2.length();
                    }
                }
                int n8 = n5 = n3 != 11 && n3 != 3 && n3 != 6 && (n3 != 1 || c2 == 'Y') ? (int)c2 : stringBuilder2.charAt(0);
                if (n5 == 69 && n7 < 3) {
                    n5 = 101;
                }
                if (n3 == 11) {
                    if (enumSet.contains((Object)DTPGflags.SKELETON_USES_CAP_J) || c2 == this.defaultHourFormatChar) {
                        n5 = this.defaultHourFormatChar;
                    } else if (c2 == 'h' && this.defaultHourFormatChar == 'K') {
                        n5 = 75;
                    } else if (c2 == 'H' && this.defaultHourFormatChar == 'k') {
                        n5 = 107;
                    } else if (c2 == 'k' && this.defaultHourFormatChar == 'H') {
                        n5 = 72;
                    } else if (c2 == 'K' && this.defaultHourFormatChar == 'h') {
                        n5 = 104;
                    }
                }
                stringBuilder2 = new StringBuilder();
                for (n4 = n7; n4 > 0; --n4) {
                    stringBuilder2.append((char)n5);
                }
            }
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public String getFields(String string) {
        this.fp.set(string);
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : this.fp.getItems()) {
            if (object instanceof String) {
                stringBuilder.append(this.fp.quoteLiteral((String)object));
                continue;
            }
            stringBuilder.append("{" + DateTimePatternGenerator.getName(object.toString()) + "}");
        }
        return stringBuilder.toString();
    }

    private static String showMask(int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < 16; ++i2) {
            if ((n2 & 1 << i2) == 0) continue;
            if (stringBuilder.length() != 0) {
                stringBuilder.append(" | ");
            }
            stringBuilder.append(FIELD_NAME[i2]);
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    private static String getName(String string) {
        int n2 = DateTimePatternGenerator.getCanonicalIndex(string, true);
        String string2 = FIELD_NAME[types[n2][1]];
        string2 = types[n2][2] < 0 ? string2 + ":S" : string2 + ":N";
        return string2;
    }

    private static int getCanonicalIndex(String string, boolean bl2) {
        int n2;
        int n3 = string.length();
        if (n3 == 0) {
            return -1;
        }
        char c2 = string.charAt(0);
        for (n2 = 1; n2 < n3; ++n2) {
            if (string.charAt(n2) == c2) continue;
            return -1;
        }
        n2 = -1;
        for (int i2 = 0; i2 < types.length; ++i2) {
            int[] nArray = types[i2];
            if (nArray[0] != c2) continue;
            n2 = i2;
            if (nArray[3] > n3 || nArray[nArray.length - 1] < n3) continue;
            return i2;
        }
        return bl2 ? -1 : n2;
    }

    private static char getCanonicalChar(int n2, char c2) {
        if (c2 == 'h' || c2 == 'K') {
            return 'h';
        }
        for (int i2 = 0; i2 < types.length; ++i2) {
            int[] nArray = types[i2];
            if (nArray[1] != n2) continue;
            return (char)nArray[0];
        }
        throw new IllegalArgumentException("Could not find field " + n2);
    }

    static {
        HashMap hashMap = new HashMap();
        ICUResourceBundle iCUResourceBundle = (ICUResourceBundle)ICUResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", "supplementalData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        DayPeriodAllowedHoursSink dayPeriodAllowedHoursSink = new DayPeriodAllowedHoursSink(hashMap);
        iCUResourceBundle.getAllItemsWithFallback("timeData", dayPeriodAllowedHoursSink);
        LOCALE_TO_ALLOWED_HOUR = Collections.unmodifiableMap(hashMap);
        APPENDITEM_WIDTH = DisplayWidth.WIDE;
        APPENDITEM_WIDTH_INT = APPENDITEM_WIDTH.ordinal();
        CLDR_FIELD_WIDTH = DisplayWidth.values();
        DTPNG_CACHE = new SimpleCache<String, DateTimePatternGenerator>();
        CLDR_FIELD_APPEND = new String[]{"Era", "Year", "Quarter", "Month", "Week", "*", "Day-Of-Week", "Day", "*", "*", "*", "Hour", "Minute", "Second", "*", "Timezone"};
        CLDR_FIELD_NAME = new String[]{"era", "year", "quarter", "month", "week", "weekOfMonth", "weekday", "day", "dayOfYear", "weekdayOfMonth", "dayperiod", "hour", "minute", "second", "*", "zone"};
        FIELD_NAME = new String[]{"Era", "Year", "Quarter", "Month", "Week_in_Year", "Week_in_Month", "Weekday", "Day", "Day_Of_Year", "Day_of_Week_in_Month", "Dayperiod", "Hour", "Minute", "Second", "Fractional_Second", "Zone"};
        CANONICAL_ITEMS = new String[]{"G", "y", "Q", "M", "w", "W", "E", "d", "D", "F", "a", "H", "m", "s", "S", "v"};
        CANONICAL_SET = new HashSet<String>(Arrays.asList(CANONICAL_ITEMS));
        types = new int[][]{{71, 0, -259, 1, 3}, {71, 0, -260, 4}, {71, 0, -257, 5}, {121, 1, 256, 1, 20}, {89, 1, 272, 1, 20}, {117, 1, 288, 1, 20}, {114, 1, 304, 1, 20}, {85, 1, -259, 1, 3}, {85, 1, -260, 4}, {85, 1, -257, 5}, {81, 2, 256, 1, 2}, {81, 2, -259, 3}, {81, 2, -260, 4}, {81, 2, -257, 5}, {113, 2, 272, 1, 2}, {113, 2, -275, 3}, {113, 2, -276, 4}, {113, 2, -273, 5}, {77, 3, 256, 1, 2}, {77, 3, -259, 3}, {77, 3, -260, 4}, {77, 3, -257, 5}, {76, 3, 272, 1, 2}, {76, 3, -275, 3}, {76, 3, -276, 4}, {76, 3, -273, 5}, {108, 3, 272, 1, 1}, {119, 4, 256, 1, 2}, {87, 5, 256, 1}, {69, 6, -259, 1, 3}, {69, 6, -260, 4}, {69, 6, -257, 5}, {69, 6, -258, 6}, {99, 6, 288, 1, 2}, {99, 6, -291, 3}, {99, 6, -292, 4}, {99, 6, -289, 5}, {99, 6, -290, 6}, {101, 6, 272, 1, 2}, {101, 6, -275, 3}, {101, 6, -276, 4}, {101, 6, -273, 5}, {101, 6, -274, 6}, {100, 7, 256, 1, 2}, {103, 7, 272, 1, 20}, {68, 8, 256, 1, 3}, {70, 9, 256, 1}, {97, 10, -259, 1, 3}, {97, 10, -260, 4}, {97, 10, -257, 5}, {98, 10, -275, 1, 3}, {98, 10, -276, 4}, {98, 10, -273, 5}, {66, 10, -307, 1, 3}, {66, 10, -308, 4}, {66, 10, -305, 5}, {72, 11, 416, 1, 2}, {107, 11, 432, 1, 2}, {104, 11, 256, 1, 2}, {75, 11, 272, 1, 2}, {109, 12, 256, 1, 2}, {115, 13, 256, 1, 2}, {65, 13, 272, 1, 1000}, {83, 14, 256, 1, 1000}, {118, 15, -291, 1}, {118, 15, -292, 4}, {122, 15, -259, 1, 3}, {122, 15, -260, 4}, {90, 15, -273, 1, 3}, {90, 15, -276, 4}, {90, 15, -275, 5}, {79, 15, -275, 1}, {79, 15, -276, 4}, {86, 15, -275, 1}, {86, 15, -276, 2}, {86, 15, -277, 3}, {86, 15, -278, 4}, {88, 15, -273, 1}, {88, 15, -275, 2}, {88, 15, -276, 4}, {120, 15, -273, 1}, {120, 15, -275, 2}, {120, 15, -276, 4}};
    }

    private static class DistanceInfo {
        int missingFieldMask;
        int extraFieldMask;

        private DistanceInfo() {
        }

        void clear() {
            this.extraFieldMask = 0;
            this.missingFieldMask = 0;
        }

        void setTo(DistanceInfo distanceInfo) {
            this.missingFieldMask = distanceInfo.missingFieldMask;
            this.extraFieldMask = distanceInfo.extraFieldMask;
        }

        void addMissing(int n2) {
            this.missingFieldMask |= 1 << n2;
        }

        void addExtra(int n2) {
            this.extraFieldMask |= 1 << n2;
        }

        public String toString() {
            return "missingFieldMask: " + DateTimePatternGenerator.showMask(this.missingFieldMask) + ", extraFieldMask: " + DateTimePatternGenerator.showMask(this.extraFieldMask);
        }
    }

    private static class DateTimeMatcher
    implements Comparable<DateTimeMatcher> {
        private int[] type = new int[16];
        private SkeletonFields original = new SkeletonFields();
        private SkeletonFields baseOriginal = new SkeletonFields();
        private boolean addedDefaultDayPeriod = false;

        private DateTimeMatcher() {
        }

        public boolean fieldIsNumeric(int n2) {
            return this.type[n2] > 0;
        }

        public String toString() {
            return this.original.toString(this.addedDefaultDayPeriod);
        }

        public String toCanonicalString() {
            return this.original.toCanonicalString(this.addedDefaultDayPeriod);
        }

        String getBasePattern() {
            return this.baseOriginal.toString(this.addedDefaultDayPeriod);
        }

        DateTimeMatcher set(String string, FormatParser formatParser, boolean bl2) {
            Object object22;
            Arrays.fill(this.type, 0);
            this.original.clear();
            this.baseOriginal.clear();
            this.addedDefaultDayPeriod = false;
            formatParser.set(string);
            for (Object object22 : formatParser.getItems()) {
                int n2;
                char c2;
                if (!(object22 instanceof VariableField)) continue;
                VariableField variableField = (VariableField)object22;
                String string2 = variableField.toString();
                int n3 = variableField.getCanonicalIndex();
                int[] nArray = types[n3];
                int n4 = nArray[1];
                if (!this.original.isFieldEmpty(n4)) {
                    c2 = this.original.getFieldChar(n4);
                    n2 = string2.charAt(0);
                    if (bl2 || c2 == 'r' && (n2 == 85 || n2 == 121) || (c2 == 'U' || c2 == 'y') && n2 == 114) continue;
                    throw new IllegalArgumentException("Conflicting fields:\t" + c2 + ", " + string2 + "\t in " + string);
                }
                this.original.populate(n4, string2);
                c2 = (char)nArray[0];
                n2 = nArray[3];
                if ("GEzvQ".indexOf(c2) >= 0) {
                    n2 = 1;
                }
                this.baseOriginal.populate(n4, c2, n2);
                int n5 = nArray[2];
                if (n5 > 0) {
                    n5 += string2.length();
                }
                this.type[n4] = n5;
            }
            if (!this.original.isFieldEmpty(12) && !this.original.isFieldEmpty(14) && this.original.isFieldEmpty(13)) {
                for (int i2 = 0; i2 < types.length; ++i2) {
                    object22 = types[i2];
                    if (object22[1] != 13) continue;
                    this.original.populate(13, (char)object22[0], (int)object22[3]);
                    this.baseOriginal.populate(13, (char)object22[0], (int)object22[3]);
                    reference var6_9 = object22[2];
                    this.type[13] = (int)(var6_9 > 0 ? var6_9 + true : var6_9);
                    break;
                }
            }
            if (!this.original.isFieldEmpty(11)) {
                if (this.original.getFieldChar(11) == 'h' || this.original.getFieldChar(11) == 'K') {
                    if (this.original.isFieldEmpty(10)) {
                        for (int i3 = 0; i3 < types.length; ++i3) {
                            object22 = types[i3];
                            if (object22[1] != 10) continue;
                            this.original.populate(10, (char)object22[0], (int)object22[3]);
                            this.baseOriginal.populate(10, (char)object22[0], (int)object22[3]);
                            this.type[10] = (int)object22[2];
                            this.addedDefaultDayPeriod = true;
                            break;
                        }
                    }
                } else if (!this.original.isFieldEmpty(10)) {
                    this.original.clearField(10);
                    this.baseOriginal.clearField(10);
                    this.type[10] = 0;
                }
            }
            return this;
        }

        int getFieldMask() {
            int n2 = 0;
            for (int i2 = 0; i2 < this.type.length; ++i2) {
                if (this.type[i2] == 0) continue;
                n2 |= 1 << i2;
            }
            return n2;
        }

        void extractFrom(DateTimeMatcher dateTimeMatcher, int n2) {
            for (int i2 = 0; i2 < this.type.length; ++i2) {
                if ((n2 & 1 << i2) != 0) {
                    this.type[i2] = dateTimeMatcher.type[i2];
                    this.original.copyFieldFrom(dateTimeMatcher.original, i2);
                    continue;
                }
                this.type[i2] = 0;
                this.original.clearField(i2);
            }
        }

        int getDistance(DateTimeMatcher dateTimeMatcher, int n2, DistanceInfo distanceInfo) {
            int n3 = 0;
            distanceInfo.clear();
            for (int i2 = 0; i2 < 16; ++i2) {
                int n4;
                int n5 = (n2 & 1 << i2) == 0 ? 0 : this.type[i2];
                if (n5 == (n4 = dateTimeMatcher.type[i2])) continue;
                if (n5 == 0) {
                    n3 += 65536;
                    distanceInfo.addExtra(i2);
                    continue;
                }
                if (n4 == 0) {
                    n3 += 4096;
                    distanceInfo.addMissing(i2);
                    continue;
                }
                n3 += Math.abs(n5 - n4);
            }
            return n3;
        }

        @Override
        public int compareTo(DateTimeMatcher dateTimeMatcher) {
            int n2 = this.original.compareTo(dateTimeMatcher.original);
            return n2 > 0 ? -1 : (n2 < 0 ? 1 : 0);
        }

        public boolean equals(Object object) {
            return this == object || object != null && object instanceof DateTimeMatcher && this.original.equals(((DateTimeMatcher)object).original);
        }

        public int hashCode() {
            return this.original.hashCode();
        }
    }

    private static class SkeletonFields {
        private byte[] chars = new byte[16];
        private byte[] lengths = new byte[16];
        private static final byte DEFAULT_CHAR = 0;
        private static final byte DEFAULT_LENGTH = 0;

        private SkeletonFields() {
        }

        public void clear() {
            Arrays.fill(this.chars, (byte)0);
            Arrays.fill(this.lengths, (byte)0);
        }

        void copyFieldFrom(SkeletonFields skeletonFields, int n2) {
            this.chars[n2] = skeletonFields.chars[n2];
            this.lengths[n2] = skeletonFields.lengths[n2];
        }

        void clearField(int n2) {
            this.chars[n2] = 0;
            this.lengths[n2] = 0;
        }

        char getFieldChar(int n2) {
            return (char)this.chars[n2];
        }

        int getFieldLength(int n2) {
            return this.lengths[n2];
        }

        void populate(int n2, String string) {
            for (char c2 : string.toCharArray()) {
                assert (c2 == string.charAt(0));
            }
            this.populate(n2, string.charAt(0), string.length());
        }

        void populate(int n2, char c2, int n3) {
            assert (c2 <= '\u007f');
            assert (n3 <= 127);
            this.chars[n2] = (byte)c2;
            this.lengths[n2] = (byte)n3;
        }

        public boolean isFieldEmpty(int n2) {
            return this.lengths[n2] == 0;
        }

        public String toString() {
            return this.appendTo(new StringBuilder(), false, false).toString();
        }

        public String toString(boolean bl2) {
            return this.appendTo(new StringBuilder(), false, bl2).toString();
        }

        public String toCanonicalString() {
            return this.appendTo(new StringBuilder(), true, false).toString();
        }

        public String toCanonicalString(boolean bl2) {
            return this.appendTo(new StringBuilder(), true, bl2).toString();
        }

        public StringBuilder appendTo(StringBuilder stringBuilder) {
            return this.appendTo(stringBuilder, false, false);
        }

        private StringBuilder appendTo(StringBuilder stringBuilder, boolean bl2, boolean bl3) {
            for (int i2 = 0; i2 < 16; ++i2) {
                if (bl3 && i2 == 10) continue;
                this.appendFieldTo(i2, stringBuilder, bl2);
            }
            return stringBuilder;
        }

        public StringBuilder appendFieldTo(int n2, StringBuilder stringBuilder) {
            return this.appendFieldTo(n2, stringBuilder, false);
        }

        private StringBuilder appendFieldTo(int n2, StringBuilder stringBuilder, boolean bl2) {
            char c2 = (char)this.chars[n2];
            int n3 = this.lengths[n2];
            if (bl2) {
                c2 = DateTimePatternGenerator.getCanonicalChar(n2, c2);
            }
            for (int i2 = 0; i2 < n3; ++i2) {
                stringBuilder.append(c2);
            }
            return stringBuilder;
        }

        public int compareTo(SkeletonFields skeletonFields) {
            for (int i2 = 0; i2 < 16; ++i2) {
                int n2 = this.chars[i2] - skeletonFields.chars[i2];
                if (n2 != 0) {
                    return n2;
                }
                int n3 = this.lengths[i2] - skeletonFields.lengths[i2];
                if (n3 == 0) continue;
                return n3;
            }
            return 0;
        }

        public boolean equals(Object object) {
            return this == object || object != null && object instanceof SkeletonFields && this.compareTo((SkeletonFields)object) == 0;
        }

        public int hashCode() {
            return Arrays.hashCode(this.chars) ^ Arrays.hashCode(this.lengths);
        }
    }

    private static enum DTPGflags {
        FIX_FRACTIONAL_SECONDS,
        SKELETON_USES_CAP_J;

    }

    private static class PatternWithSkeletonFlag {
        public String pattern;
        public boolean skeletonWasSpecified;

        public PatternWithSkeletonFlag(String string, boolean bl2) {
            this.pattern = string;
            this.skeletonWasSpecified = bl2;
        }

        public String toString() {
            return this.pattern + "," + this.skeletonWasSpecified;
        }
    }

    private static class PatternWithMatcher {
        public String pattern;
        public DateTimeMatcher matcherWithSkeleton;

        public PatternWithMatcher(String string, DateTimeMatcher dateTimeMatcher) {
            this.pattern = string;
            this.matcherWithSkeleton = dateTimeMatcher;
        }
    }

    @Deprecated
    public static class FormatParser {
        private static final UnicodeSet SYNTAX_CHARS = new UnicodeSet("[a-zA-Z]").freeze();
        private static final UnicodeSet QUOTING_CHARS = new UnicodeSet("[[[:script=Latn:][:script=Cyrl:]]&[[:L:][:M:]]]").freeze();
        private transient PatternTokenizer tokenizer = new PatternTokenizer().setSyntaxCharacters(SYNTAX_CHARS).setExtraQuotingCharacters(QUOTING_CHARS).setUsingQuote(true);
        private List<Object> items = new ArrayList<Object>();

        @Deprecated
        public FormatParser() {
        }

        @Deprecated
        public final FormatParser set(String string) {
            return this.set(string, false);
        }

        @Deprecated
        public FormatParser set(String string, boolean bl2) {
            this.items.clear();
            if (string.length() == 0) {
                return this;
            }
            this.tokenizer.setPattern(string);
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            while (true) {
                stringBuffer.setLength(0);
                int n2 = this.tokenizer.next(stringBuffer);
                if (n2 == 0) break;
                if (n2 == 1) {
                    if (stringBuffer2.length() != 0 && stringBuffer.charAt(0) != stringBuffer2.charAt(0)) {
                        this.addVariable(stringBuffer2, false);
                    }
                    stringBuffer2.append(stringBuffer);
                    continue;
                }
                this.addVariable(stringBuffer2, false);
                this.items.add(stringBuffer.toString());
            }
            this.addVariable(stringBuffer2, false);
            return this;
        }

        private void addVariable(StringBuffer stringBuffer, boolean bl2) {
            if (stringBuffer.length() != 0) {
                this.items.add(new VariableField(stringBuffer.toString(), bl2));
                stringBuffer.setLength(0);
            }
        }

        @Deprecated
        public List<Object> getItems() {
            return this.items;
        }

        @Deprecated
        public String toString() {
            return this.toString(0, this.items.size());
        }

        @Deprecated
        public String toString(int n2, int n3) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = n2; i2 < n3; ++i2) {
                Object object = this.items.get(i2);
                if (object instanceof String) {
                    String string = (String)object;
                    stringBuilder.append(this.tokenizer.quoteLiteral(string));
                    continue;
                }
                stringBuilder.append(this.items.get(i2).toString());
            }
            return stringBuilder.toString();
        }

        @Deprecated
        public boolean hasDateAndTimeFields() {
            int n2 = 0;
            for (Object object : this.items) {
                if (!(object instanceof VariableField)) continue;
                int n3 = ((VariableField)object).getType();
                n2 |= 1 << n3;
            }
            boolean bl2 = (n2 & 0x3FF) != 0;
            boolean bl3 = (n2 & 0xFC00) != 0;
            return bl2 && bl3;
        }

        @Deprecated
        public Object quoteLiteral(String string) {
            return this.tokenizer.quoteLiteral(string);
        }
    }

    @Deprecated
    public static class VariableField {
        private final String string;
        private final int canonicalIndex;

        @Deprecated
        public VariableField(String string) {
            this(string, false);
        }

        @Deprecated
        public VariableField(String string, boolean bl2) {
            this.canonicalIndex = DateTimePatternGenerator.getCanonicalIndex(string, bl2);
            if (this.canonicalIndex < 0) {
                throw new IllegalArgumentException("Illegal datetime field:\t" + string);
            }
            this.string = string;
        }

        @Deprecated
        public int getType() {
            return types[this.canonicalIndex][1];
        }

        @Deprecated
        public static String getCanonicalCode(int n2) {
            try {
                return CANONICAL_ITEMS[n2];
            }
            catch (Exception exception) {
                return String.valueOf(n2);
            }
        }

        @Deprecated
        public boolean isNumeric() {
            return types[this.canonicalIndex][2] > 0;
        }

        private int getCanonicalIndex() {
            return this.canonicalIndex;
        }

        @Deprecated
        public String toString() {
            return this.string;
        }
    }

    public static enum DisplayWidth {
        WIDE(""),
        ABBREVIATED("-short"),
        NARROW("-narrow");

        @Deprecated
        private static int COUNT;
        private final String cldrKey;

        private DisplayWidth(String string2) {
            this.cldrKey = string2;
        }

        private String cldrKey() {
            return this.cldrKey;
        }

        static {
            COUNT = DisplayWidth.values().length;
        }
    }

    public static final class PatternInfo {
        public static final int OK = 0;
        public static final int BASE_CONFLICT = 1;
        public static final int CONFLICT = 2;
        public int status;
        public String conflictingPattern;
    }

    private static class DayPeriodAllowedHoursSink
    extends UResource.Sink {
        HashMap<String, String[]> tempMap;

        private DayPeriodAllowedHoursSink(HashMap<String, String[]> hashMap) {
            this.tempMap = hashMap;
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean bl2) {
            UResource.Table table = value.getTable();
            int n2 = 0;
            while (table.getKeyAndValue(n2, key, value)) {
                String string = key.toString();
                UResource.Table table2 = value.getTable();
                String[] stringArray = null;
                String string2 = null;
                int n3 = 0;
                while (table2.getKeyAndValue(n3, key, value)) {
                    if (key.contentEquals("allowed")) {
                        stringArray = value.getStringArrayOrStringAsArray();
                    } else if (key.contentEquals("preferred")) {
                        string2 = value.getString();
                    }
                    ++n3;
                }
                String[] stringArray2 = null;
                if (stringArray != null && stringArray.length > 0) {
                    stringArray2 = new String[stringArray.length + 1];
                    stringArray2[0] = string2 != null ? string2 : stringArray[0];
                    System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
                } else {
                    stringArray2 = new String[]{string2 != null ? string2 : LAST_RESORT_ALLOWED_HOUR_FORMAT[0], stringArray2[0]};
                }
                this.tempMap.put(string, stringArray2);
                ++n2;
            }
        }
    }

    private class AvailableFormatsSink
    extends UResource.Sink {
        PatternInfo returnInfo;

        public AvailableFormatsSink(PatternInfo patternInfo) {
            this.returnInfo = patternInfo;
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean bl2) {
            String string = key.toString();
            if (!DateTimePatternGenerator.this.isAvailableFormatSet(string)) {
                DateTimePatternGenerator.this.setAvailableFormat(string);
                String string2 = value.toString();
                DateTimePatternGenerator.this.addPatternWithSkeleton(string2, string, true, this.returnInfo);
            }
        }
    }

    private class AppendItemNamesSink
    extends UResource.Sink {
        private AppendItemNamesSink() {
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean bl2) {
            int n2 = DateTimePatternGenerator.getCLDRFieldAndWidthNumber(key);
            if (n2 == -1) {
                return;
            }
            int n3 = n2 / DisplayWidth.COUNT;
            DisplayWidth displayWidth = CLDR_FIELD_WIDTH[n2 % DisplayWidth.COUNT];
            UResource.Table table = value.getTable();
            if (table.findValue("dn", value) && DateTimePatternGenerator.this.getFieldDisplayName(n3, displayWidth) == null) {
                DateTimePatternGenerator.this.setFieldDisplayName(n3, displayWidth, value.toString());
            }
        }
    }

    private class AppendItemFormatsSink
    extends UResource.Sink {
        private AppendItemFormatsSink() {
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean bl2) {
            int n2 = DateTimePatternGenerator.getAppendFormatNumber(key);
            if (n2 < 0) {
                return;
            }
            if (DateTimePatternGenerator.this.getAppendItemFormat(n2) == null) {
                DateTimePatternGenerator.this.setAppendItemFormat(n2, value.toString());
            }
        }
    }
}

