/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.text.Format;
import java.util.Objects;

public class ConstrainedFieldPosition {
    private ConstraintType fConstraint;
    private Class<?> fClassConstraint;
    private Format.Field fField;
    private Object fValue;
    private int fStart;
    private int fLimit;
    private long fContext;

    public ConstrainedFieldPosition() {
        this.reset();
    }

    public void reset() {
        this.fConstraint = ConstraintType.NONE;
        this.fClassConstraint = Object.class;
        this.fField = null;
        this.fValue = null;
        this.fStart = 0;
        this.fLimit = 0;
        this.fContext = 0L;
    }

    public void constrainField(Format.Field field) {
        if (field == null) {
            throw new IllegalArgumentException("Cannot constrain on null field");
        }
        this.fConstraint = ConstraintType.FIELD;
        this.fClassConstraint = Object.class;
        this.fField = field;
        this.fValue = null;
    }

    public void constrainClass(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Cannot constrain on null field class");
        }
        this.fConstraint = ConstraintType.CLASS;
        this.fClassConstraint = clazz;
        this.fField = null;
        this.fValue = null;
    }

    @Deprecated
    public void constrainFieldAndValue(Format.Field field, Object object) {
        this.fConstraint = ConstraintType.VALUE;
        this.fClassConstraint = Object.class;
        this.fField = field;
        this.fValue = object;
    }

    public Format.Field getField() {
        return this.fField;
    }

    public int getStart() {
        return this.fStart;
    }

    public int getLimit() {
        return this.fLimit;
    }

    public Object getFieldValue() {
        return this.fValue;
    }

    public long getInt64IterationContext() {
        return this.fContext;
    }

    public void setInt64IterationContext(long l2) {
        this.fContext = l2;
    }

    public void setState(Format.Field field, Object object, int n2, int n3) {
        if (field != null) assert (this.matchesField(field, object));
        this.fField = field;
        this.fValue = object;
        this.fStart = n2;
        this.fLimit = n3;
    }

    public boolean matchesField(Format.Field field, Object object) {
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        switch (this.fConstraint) {
            case NONE: {
                return true;
            }
            case CLASS: {
                return this.fClassConstraint.isAssignableFrom(field.getClass());
            }
            case FIELD: {
                return this.fField == field;
            }
            case VALUE: {
                return this.fField == field && Objects.equals(this.fValue, object);
            }
        }
        throw new AssertionError();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CFPos[");
        stringBuilder.append(this.fStart);
        stringBuilder.append('-');
        stringBuilder.append(this.fLimit);
        stringBuilder.append(' ');
        stringBuilder.append(this.fField);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private static enum ConstraintType {
        NONE,
        CLASS,
        FIELD,
        VALUE;

    }
}

