/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.util.List;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Replaceable;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Transliterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeFilter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

class CompoundTransliterator
extends Transliterator {
    private Transliterator[] trans;
    private int numAnonymousRBTs = 0;

    CompoundTransliterator(List<Transliterator> list) {
        this(list, 0);
    }

    CompoundTransliterator(List<Transliterator> list, int n2) {
        super("", null);
        this.trans = null;
        this.init(list, 0, false);
        this.numAnonymousRBTs = n2;
    }

    CompoundTransliterator(String string, UnicodeFilter unicodeFilter, Transliterator[] transliteratorArray, int n2) {
        super(string, unicodeFilter);
        this.trans = transliteratorArray;
        this.numAnonymousRBTs = n2;
    }

    private void init(List<Transliterator> list, int n2, boolean bl2) {
        int n3;
        int n4 = list.size();
        this.trans = new Transliterator[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = n2 == 0 ? n3 : n4 - 1 - n3;
            this.trans[n3] = list.get(n5);
        }
        if (n2 == 1 && bl2) {
            StringBuilder stringBuilder = new StringBuilder();
            for (n3 = 0; n3 < n4; ++n3) {
                if (n3 > 0) {
                    stringBuilder.append(';');
                }
                stringBuilder.append(this.trans[n3].getID());
            }
            this.setID(stringBuilder.toString());
        }
        this.computeMaximumContextLength();
    }

    public int getCount() {
        return this.trans.length;
    }

    public Transliterator getTransliterator(int n2) {
        return this.trans[n2];
    }

    private static void _smartAppend(StringBuilder stringBuilder, char c2) {
        if (stringBuilder.length() != 0 && stringBuilder.charAt(stringBuilder.length() - 1) != c2) {
            stringBuilder.append(c2);
        }
    }

    @Override
    public String toRules(boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.numAnonymousRBTs >= 1 && this.getFilter() != null) {
            stringBuilder.append("::").append(this.getFilter().toPattern(bl2)).append(';');
        }
        for (int i2 = 0; i2 < this.trans.length; ++i2) {
            String string;
            if (this.trans[i2].getID().startsWith("%Pass")) {
                string = this.trans[i2].toRules(bl2);
                if (this.numAnonymousRBTs > 1 && i2 > 0 && this.trans[i2 - 1].getID().startsWith("%Pass")) {
                    string = "::Null;" + string;
                }
            } else {
                string = this.trans[i2].getID().indexOf(59) >= 0 ? this.trans[i2].toRules(bl2) : this.trans[i2].baseToRules(bl2);
            }
            CompoundTransliterator._smartAppend(stringBuilder, '\n');
            stringBuilder.append(string);
            CompoundTransliterator._smartAppend(stringBuilder, ';');
        }
        return stringBuilder.toString();
    }

    @Override
    public void addSourceTargetSet(UnicodeSet unicodeSet, UnicodeSet unicodeSet2, UnicodeSet unicodeSet3) {
        UnicodeSet unicodeSet4 = new UnicodeSet(this.getFilterAsUnicodeSet(unicodeSet));
        UnicodeSet unicodeSet5 = new UnicodeSet();
        for (int i2 = 0; i2 < this.trans.length; ++i2) {
            unicodeSet5.clear();
            this.trans[i2].addSourceTargetSet(unicodeSet4, unicodeSet2, unicodeSet5);
            unicodeSet3.addAll(unicodeSet5);
            unicodeSet4.addAll(unicodeSet5);
        }
    }

    @Override
    protected void handleTransliterate(Replaceable replaceable, Transliterator.Position position, boolean bl2) {
        if (this.trans.length < 1) {
            position.start = position.limit;
            return;
        }
        int n2 = position.limit;
        int n3 = position.start;
        int n4 = 0;
        Object var7_7 = null;
        for (int i2 = 0; i2 < this.trans.length; ++i2) {
            position.start = n3;
            int n5 = position.limit;
            if (position.start == position.limit) break;
            this.trans[i2].filteredTransliterate(replaceable, position, bl2);
            if (!bl2 && position.start != position.limit) {
                throw new RuntimeException("ERROR: Incomplete non-incremental transliteration by " + this.trans[i2].getID());
            }
            n4 += position.limit - n5;
            if (!bl2) continue;
            position.limit = position.start;
        }
        position.limit = n2 += n4;
    }

    private void computeMaximumContextLength() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.trans.length; ++i2) {
            int n3 = this.trans[i2].getMaximumContextLength();
            if (n3 <= n2) continue;
            n2 = n3;
        }
        this.setMaximumContextLength(n2);
    }

    public Transliterator safeClone() {
        UnicodeFilter unicodeFilter = this.getFilter();
        if (unicodeFilter != null && unicodeFilter instanceof UnicodeSet) {
            unicodeFilter = new UnicodeSet((UnicodeSet)unicodeFilter);
        }
        return new CompoundTransliterator(this.getID(), unicodeFilter, this.trans, this.numAnonymousRBTs);
    }
}

