/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICULocaleService;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUService;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationLoader;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationTailoring;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Collator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.RuleBasedCollator;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUCloneNotSupportedException;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Output;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

final class CollatorServiceShim
extends Collator.ServiceShim {
    private static ICULocaleService service = new CService();

    CollatorServiceShim() {
    }

    @Override
    Collator getInstance(ULocale uLocale) {
        try {
            ULocale[] uLocaleArray = new ULocale[1];
            Collator collator = (Collator)service.get(uLocale, uLocaleArray);
            if (collator == null) {
                throw new MissingResourceException("Could not locate Collator data", "", "");
            }
            return (Collator)collator.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ICUCloneNotSupportedException(cloneNotSupportedException);
        }
    }

    @Override
    Object registerInstance(Collator collator, ULocale uLocale) {
        collator.setLocale(uLocale, uLocale);
        return service.registerObject((Object)collator, uLocale);
    }

    @Override
    Object registerFactory(Collator.CollatorFactory collatorFactory) {
        class CFactory
        extends ICULocaleService.LocaleKeyFactory {
            Collator.CollatorFactory delegate;

            CFactory(Collator.CollatorFactory collatorFactory) {
                super(collatorFactory.visible());
                this.delegate = collatorFactory;
            }

            @Override
            public Object handleCreate(ULocale uLocale, int n2, ICUService iCUService) {
                Collator collator = this.delegate.createCollator(uLocale);
                return collator;
            }

            @Override
            public String getDisplayName(String string, ULocale uLocale) {
                ULocale uLocale2 = new ULocale(string);
                return this.delegate.getDisplayName(uLocale2, uLocale);
            }

            @Override
            public Set<String> getSupportedIDs() {
                return this.delegate.getSupportedLocaleIDs();
            }
        }
        return service.registerFactory(new CFactory(collatorFactory));
    }

    @Override
    boolean unregister(Object object) {
        return service.unregisterFactory((ICUService.Factory)object);
    }

    @Override
    Locale[] getAvailableLocales() {
        Locale[] localeArray = service.isDefault() ? ICUResourceBundle.getAvailableLocales("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b/coll", ICUResourceBundle.ICU_DATA_CLASS_LOADER) : service.getAvailableLocales();
        return localeArray;
    }

    @Override
    ULocale[] getAvailableULocales() {
        ULocale[] uLocaleArray = service.isDefault() ? ICUResourceBundle.getAvailableULocales("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b/coll", ICUResourceBundle.ICU_DATA_CLASS_LOADER) : service.getAvailableULocales();
        return uLocaleArray;
    }

    @Override
    String getDisplayName(ULocale uLocale, ULocale uLocale2) {
        String string = uLocale.getName();
        return service.getDisplayName(string, uLocale2);
    }

    private static final Collator makeInstance(ULocale uLocale) {
        Output<ULocale> output = new Output<ULocale>(ULocale.ROOT);
        CollationTailoring collationTailoring = CollationLoader.loadTailoring(uLocale, output);
        return new RuleBasedCollator(collationTailoring, (ULocale)output.value);
    }

    private static class CService
    extends ICULocaleService {
        CService() {
            super("Collator");
            class CollatorFactory
            extends ICULocaleService.ICUResourceBundleFactory {
                CollatorFactory() {
                    super("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b/coll");
                }

                @Override
                protected Object handleCreate(ULocale uLocale, int n2, ICUService iCUService) {
                    return CollatorServiceShim.makeInstance(uLocale);
                }
            }
            this.registerFactory(new CollatorFactory());
            this.markDefault();
        }

        @Override
        public String validateFallbackLocale() {
            return "";
        }

        @Override
        protected Object handleDefault(ICUService.Key key, String[] stringArray) {
            if (stringArray != null) {
                stringArray[0] = "root";
            }
            try {
                return CollatorServiceShim.makeInstance(ULocale.ROOT);
            }
            catch (MissingResourceException missingResourceException) {
                return null;
            }
        }
    }
}

