/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import macromedia.jdbc.db2.externals.com.ibm.icu.text.CharsetDetector;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.CharsetMatch;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.CharsetRecognizer;

abstract class CharsetRecog_Unicode
extends CharsetRecognizer {
    CharsetRecog_Unicode() {
    }

    @Override
    abstract String getName();

    @Override
    abstract CharsetMatch match(CharsetDetector var1);

    static int codeUnit16FromBytes(byte by2, byte by3) {
        return (by2 & 0xFF) << 8 | by3 & 0xFF;
    }

    static int adjustConfidence(int n2, int n3) {
        if (n2 == 0) {
            n3 -= 10;
        } else if (n2 >= 32 && n2 <= 255 || n2 == 10) {
            n3 += 10;
        }
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 > 100) {
            n3 = 100;
        }
        return n3;
    }

    static class CharsetRecog_UTF_32_LE
    extends CharsetRecog_UTF_32 {
        CharsetRecog_UTF_32_LE() {
        }

        @Override
        int getChar(byte[] byArray, int n2) {
            return (byArray[n2 + 3] & 0xFF) << 24 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 1] & 0xFF) << 8 | byArray[n2 + 0] & 0xFF;
        }

        @Override
        String getName() {
            return "UTF-32LE";
        }
    }

    static class CharsetRecog_UTF_32_BE
    extends CharsetRecog_UTF_32 {
        CharsetRecog_UTF_32_BE() {
        }

        @Override
        int getChar(byte[] byArray, int n2) {
            return (byArray[n2 + 0] & 0xFF) << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
        }

        @Override
        String getName() {
            return "UTF-32BE";
        }
    }

    static abstract class CharsetRecog_UTF_32
    extends CharsetRecog_Unicode {
        CharsetRecog_UTF_32() {
        }

        abstract int getChar(byte[] var1, int var2);

        @Override
        abstract String getName();

        @Override
        CharsetMatch match(CharsetDetector charsetDetector) {
            byte[] byArray = charsetDetector.fRawInput;
            int n2 = charsetDetector.fRawLength / 4 * 4;
            int n3 = 0;
            int n4 = 0;
            boolean bl2 = false;
            int n5 = 0;
            if (n2 == 0) {
                return null;
            }
            if (this.getChar(byArray, 0) == 65279) {
                bl2 = true;
            }
            for (int i2 = 0; i2 < n2; i2 += 4) {
                int n6 = this.getChar(byArray, i2);
                if (n6 < 0 || n6 >= 0x10FFFF || n6 >= 55296 && n6 <= 57343) {
                    ++n4;
                    continue;
                }
                ++n3;
            }
            if (bl2 && n4 == 0) {
                n5 = 100;
            } else if (bl2 && n3 > n4 * 10) {
                n5 = 80;
            } else if (n3 > 3 && n4 == 0) {
                n5 = 100;
            } else if (n3 > 0 && n4 == 0) {
                n5 = 80;
            } else if (n3 > n4 * 10) {
                n5 = 25;
            }
            return n5 == 0 ? null : new CharsetMatch(charsetDetector, this, n5);
        }
    }

    static class CharsetRecog_UTF_16_LE
    extends CharsetRecog_Unicode {
        CharsetRecog_UTF_16_LE() {
        }

        @Override
        String getName() {
            return "UTF-16LE";
        }

        @Override
        CharsetMatch match(CharsetDetector charsetDetector) {
            byte[] byArray = charsetDetector.fRawInput;
            int n2 = 10;
            int n3 = Math.min(byArray.length, 30);
            for (int i2 = 0; i2 < n3 - 1; i2 += 2) {
                int n4 = CharsetRecog_UTF_16_LE.codeUnit16FromBytes(byArray[i2 + 1], byArray[i2]);
                if (i2 == 0 && n4 == 65279) {
                    n2 = 100;
                    break;
                }
                if ((n2 = CharsetRecog_UTF_16_LE.adjustConfidence(n4, n2)) == 0 || n2 == 100) break;
            }
            if (n3 < 4 && n2 < 100) {
                n2 = 0;
            }
            if (n2 > 0) {
                return new CharsetMatch(charsetDetector, this, n2);
            }
            return null;
        }
    }

    static class CharsetRecog_UTF_16_BE
    extends CharsetRecog_Unicode {
        CharsetRecog_UTF_16_BE() {
        }

        @Override
        String getName() {
            return "UTF-16BE";
        }

        @Override
        CharsetMatch match(CharsetDetector charsetDetector) {
            byte[] byArray = charsetDetector.fRawInput;
            int n2 = 10;
            int n3 = Math.min(byArray.length, 30);
            for (int i2 = 0; i2 < n3 - 1; i2 += 2) {
                int n4 = CharsetRecog_UTF_16_BE.codeUnit16FromBytes(byArray[i2], byArray[i2 + 1]);
                if (i2 == 0 && n4 == 65279) {
                    n2 = 100;
                    break;
                }
                if ((n2 = CharsetRecog_UTF_16_BE.adjustConfidence(n4, n2)) == 0 || n2 == 100) break;
            }
            if (n3 < 4 && n2 < 100) {
                n2 = 0;
            }
            if (n2 > 0) {
                return new CharsetMatch(charsetDetector, this, n2);
            }
            return null;
        }
    }
}

