/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.CharsetDetector;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.CharsetRecognizer;

public class CharsetMatch
implements Comparable<CharsetMatch> {
    private int fConfidence;
    private byte[] fRawInput = null;
    private int fRawLength;
    private InputStream fInputStream = null;
    private String fCharsetName;
    private String fLang;

    public Reader getReader() {
        InputStream inputStream = this.fInputStream;
        if (inputStream == null) {
            inputStream = new ByteArrayInputStream(this.fRawInput, 0, this.fRawLength);
        }
        try {
            inputStream.reset();
            return new InputStreamReader(inputStream, this.getName());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getString() throws IOException {
        return this.getString(-1);
    }

    public String getString(int n2) throws IOException {
        int n3;
        String string = null;
        if (this.fInputStream != null) {
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray = new char[1024];
            Reader reader = this.getReader();
            int n4 = n2 < 0 ? Integer.MAX_VALUE : n2;
            int n5 = 0;
            while ((n5 = reader.read(cArray, 0, Math.min(n4, 1024))) >= 0) {
                stringBuilder.append(cArray, 0, n5);
                n4 -= n5;
            }
            reader.close();
            return stringBuilder.toString();
        }
        String string2 = this.getName();
        int n6 = n3 = string2.indexOf("_rtl") < 0 ? string2.indexOf("_ltr") : string2.indexOf("_rtl");
        if (n3 > 0) {
            string2 = string2.substring(0, n3);
        }
        string = new String(this.fRawInput, string2);
        return string;
    }

    public int getConfidence() {
        return this.fConfidence;
    }

    public String getName() {
        return this.fCharsetName;
    }

    public String getLanguage() {
        return this.fLang;
    }

    @Override
    public int compareTo(CharsetMatch charsetMatch) {
        int n2 = 0;
        if (this.fConfidence > charsetMatch.fConfidence) {
            n2 = 1;
        } else if (this.fConfidence < charsetMatch.fConfidence) {
            n2 = -1;
        }
        return n2;
    }

    CharsetMatch(CharsetDetector charsetDetector, CharsetRecognizer charsetRecognizer, int n2) {
        this.fConfidence = n2;
        if (charsetDetector.fInputStream == null) {
            this.fRawInput = charsetDetector.fRawInput;
            this.fRawLength = charsetDetector.fRawLength;
        }
        this.fInputStream = charsetDetector.fInputStream;
        this.fCharsetName = charsetRecognizer.getName();
        this.fLang = charsetRecognizer.getLanguage();
    }

    CharsetMatch(CharsetDetector charsetDetector, CharsetRecognizer charsetRecognizer, int n2, String string, String string2) {
        this.fConfidence = n2;
        if (charsetDetector.fInputStream == null) {
            this.fRawInput = charsetDetector.fRawInput;
            this.fRawLength = charsetDetector.fRawLength;
        }
        this.fInputStream = charsetDetector.fInputStream;
        this.fCharsetName = string;
        this.fLang = string2;
    }
}

