/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.text.CharacterIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.BreakIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Replaceable;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Transliterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeFilter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUCloneNotSupportedException;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

final class BreakTransliterator
extends Transliterator {
    private BreakIterator bi;
    private String insertion;
    private int[] boundaries = new int[50];
    private int boundaryCount = 0;
    static final int LETTER_OR_MARK_MASK = 510;

    public BreakTransliterator(String string, UnicodeFilter unicodeFilter, BreakIterator breakIterator, String string2) {
        super(string, unicodeFilter);
        this.bi = breakIterator;
        this.insertion = string2;
    }

    public BreakTransliterator(String string, UnicodeFilter unicodeFilter) {
        this(string, unicodeFilter, null, " ");
    }

    public String getInsertion() {
        return this.insertion;
    }

    public void setInsertion(String string) {
        this.insertion = string;
    }

    public BreakIterator getBreakIterator() {
        if (this.bi == null) {
            this.bi = BreakIterator.getWordInstance(new ULocale("th_TH"));
        }
        return this.bi;
    }

    public void setBreakIterator(BreakIterator breakIterator) {
        this.bi = breakIterator;
    }

    @Override
    protected synchronized void handleTransliterate(Replaceable replaceable, Transliterator.Position position, boolean bl2) {
        int n2;
        int n3;
        this.boundaryCount = 0;
        int n4 = 0;
        this.getBreakIterator();
        this.bi.setText(new ReplaceableCharacterIterator(replaceable, position.start, position.limit, position.start));
        n4 = this.bi.first();
        while (n4 != -1 && n4 < position.limit) {
            if (n4 != 0 && (1 << (n3 = UCharacter.getType(n2 = UTF16.charAt(replaceable, n4 - 1))) & 0x1FE) != 0 && (1 << (n3 = UCharacter.getType(n2 = UTF16.charAt(replaceable, n4))) & 0x1FE) != 0) {
                if (this.boundaryCount >= this.boundaries.length) {
                    int[] nArray = new int[this.boundaries.length * 2];
                    System.arraycopy(this.boundaries, 0, nArray, 0, this.boundaries.length);
                    this.boundaries = nArray;
                }
                this.boundaries[this.boundaryCount++] = n4;
            }
            n4 = this.bi.next();
        }
        n2 = 0;
        n3 = 0;
        if (this.boundaryCount != 0) {
            n2 = this.boundaryCount * this.insertion.length();
            n3 = this.boundaries[this.boundaryCount - 1];
            while (this.boundaryCount > 0) {
                n4 = this.boundaries[--this.boundaryCount];
                replaceable.replace(n4, n4, this.insertion);
            }
        }
        position.contextLimit += n2;
        position.limit += n2;
        position.start = bl2 ? n3 + n2 : position.limit;
    }

    static void register() {
        BreakTransliterator breakTransliterator = new BreakTransliterator("Any-BreakInternal", null);
        Transliterator.registerInstance(breakTransliterator, false);
    }

    @Override
    public void addSourceTargetSet(UnicodeSet unicodeSet, UnicodeSet unicodeSet2, UnicodeSet unicodeSet3) {
        UnicodeSet unicodeSet4 = this.getFilterAsUnicodeSet(unicodeSet);
        if (unicodeSet4.size() != 0) {
            unicodeSet3.addAll(this.insertion);
        }
    }

    static final class ReplaceableCharacterIterator
    implements CharacterIterator {
        private Replaceable text;
        private int begin;
        private int end;
        private int pos;

        public ReplaceableCharacterIterator(Replaceable replaceable, int n2, int n3, int n4) {
            if (replaceable == null) {
                throw new NullPointerException();
            }
            this.text = replaceable;
            if (n2 < 0 || n2 > n3 || n3 > replaceable.length()) {
                throw new IllegalArgumentException("Invalid substring range");
            }
            if (n4 < n2 || n4 > n3) {
                throw new IllegalArgumentException("Invalid position");
            }
            this.begin = n2;
            this.end = n3;
            this.pos = n4;
        }

        public void setText(Replaceable replaceable) {
            if (replaceable == null) {
                throw new NullPointerException();
            }
            this.text = replaceable;
            this.begin = 0;
            this.end = replaceable.length();
            this.pos = 0;
        }

        @Override
        public char first() {
            this.pos = this.begin;
            return this.current();
        }

        @Override
        public char last() {
            this.pos = this.end != this.begin ? this.end - 1 : this.end;
            return this.current();
        }

        @Override
        public char setIndex(int n2) {
            if (n2 < this.begin || n2 > this.end) {
                throw new IllegalArgumentException("Invalid index");
            }
            this.pos = n2;
            return this.current();
        }

        @Override
        public char current() {
            if (this.pos >= this.begin && this.pos < this.end) {
                return this.text.charAt(this.pos);
            }
            return '\uffff';
        }

        @Override
        public char next() {
            if (this.pos < this.end - 1) {
                ++this.pos;
                return this.text.charAt(this.pos);
            }
            this.pos = this.end;
            return '\uffff';
        }

        @Override
        public char previous() {
            if (this.pos > this.begin) {
                --this.pos;
                return this.text.charAt(this.pos);
            }
            return '\uffff';
        }

        @Override
        public int getBeginIndex() {
            return this.begin;
        }

        @Override
        public int getEndIndex() {
            return this.end;
        }

        @Override
        public int getIndex() {
            return this.pos;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ReplaceableCharacterIterator)) {
                return false;
            }
            ReplaceableCharacterIterator replaceableCharacterIterator = (ReplaceableCharacterIterator)object;
            if (this.hashCode() != replaceableCharacterIterator.hashCode()) {
                return false;
            }
            if (!this.text.equals(replaceableCharacterIterator.text)) {
                return false;
            }
            return this.pos == replaceableCharacterIterator.pos && this.begin == replaceableCharacterIterator.begin && this.end == replaceableCharacterIterator.end;
        }

        public int hashCode() {
            return this.text.hashCode() ^ this.pos ^ this.begin ^ this.end;
        }

        @Override
        public Object clone() {
            try {
                ReplaceableCharacterIterator replaceableCharacterIterator = (ReplaceableCharacterIterator)super.clone();
                return replaceableCharacterIterator;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new ICUCloneNotSupportedException();
            }
        }
    }
}

