/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.ArabicShaping;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.ArabicShapingException;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Bidi;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;

public class BidiTransform {
    private Bidi bidi;
    private String text;
    private int reorderingOptions;
    private int shapingOptions;

    public String transform(CharSequence charSequence, byte by2, Order order, byte by3, Order order2, Mirroring mirroring, int n2) {
        if (charSequence == null || order == null || order2 == null || mirroring == null) {
            throw new IllegalArgumentException();
        }
        this.text = charSequence.toString();
        byte[] byArray = new byte[]{by2, by3};
        this.resolveBaseDirection(byArray);
        ReorderingScheme reorderingScheme = this.findMatchingScheme(byArray[0], order, byArray[1], order2);
        if (reorderingScheme != null) {
            this.bidi = new Bidi();
            this.reorderingOptions = Mirroring.ON.equals((Object)mirroring) ? 2 : 0;
            this.shapingOptions = n2 & 0xFFFFFFFB;
            reorderingScheme.doTransform(this);
        }
        return this.text;
    }

    private void resolveBaseDirection(byte[] byArray) {
        byte by2;
        byArray[0] = Bidi.IsDefaultLevel(byArray[0]) ? ((by2 = Bidi.getBaseDirection(this.text)) != 3 ? by2 : (byArray[0] == 127 ? (byte)1 : 0)) : (byte)(byArray[0] & 1);
        byArray[1] = Bidi.IsDefaultLevel(byArray[1]) ? byArray[0] : (byte)(byArray[1] & 1);
    }

    private ReorderingScheme findMatchingScheme(byte by2, Order order, byte by3, Order order2) {
        for (ReorderingScheme reorderingScheme : ReorderingScheme.values()) {
            if (!reorderingScheme.matches(by2, order, by3, order2)) continue;
            return reorderingScheme;
        }
        return null;
    }

    private void resolve(byte by2, int n2) {
        this.bidi.setInverse((n2 & 5) != 0);
        this.bidi.setReorderingMode(n2);
        this.bidi.setPara(this.text, by2, null);
    }

    private void reorder() {
        this.text = this.bidi.writeReordered(this.reorderingOptions);
        this.reorderingOptions = 0;
    }

    private void reverse() {
        this.text = Bidi.writeReverse(this.text, 0);
    }

    private void mirror() {
        int n2;
        if ((this.reorderingOptions & 2) == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(this.text);
        byte[] byArray = this.bidi.getLevels();
        int n3 = byArray.length;
        for (int i2 = 0; i2 < n3; i2 += UTF16.getCharCount(n2)) {
            n2 = UTF16.charAt(stringBuffer, i2);
            if ((byArray[i2] & 1) == 0) continue;
            UTF16.setCharAt(stringBuffer, i2, UCharacter.getMirror(n2));
        }
        this.text = stringBuffer.toString();
        this.reorderingOptions &= 0xFFFFFFFD;
    }

    private void shapeArabic(int n2, int n3) {
        if (n2 == n3) {
            this.shapeArabic(this.shapingOptions | n2);
        } else {
            this.shapeArabic(this.shapingOptions & 0xFFFFFFE7 | n2);
            this.shapeArabic(this.shapingOptions & 0xFFFFFF1F | n3);
        }
    }

    private void shapeArabic(int n2) {
        if (n2 != 0) {
            ArabicShaping arabicShaping = new ArabicShaping(n2);
            try {
                this.text = arabicShaping.shape(this.text);
            }
            catch (ArabicShapingException arabicShapingException) {
                // empty catch block
            }
        }
    }

    private static boolean IsLTR(byte by2) {
        return (by2 & 1) == 0;
    }

    private static boolean IsRTL(byte by2) {
        return (by2 & 1) == 1;
    }

    private static boolean IsLogical(Order order) {
        return Order.LOGICAL.equals((Object)order);
    }

    private static boolean IsVisual(Order order) {
        return Order.VISUAL.equals((Object)order);
    }

    private static enum ReorderingScheme {
        LOG_LTR_TO_VIS_LTR{

            @Override
            boolean matches(byte by2, Order order, byte by3, Order order2) {
                return BidiTransform.IsLTR(by2) && BidiTransform.IsLogical(order) && BidiTransform.IsLTR(by3) && BidiTransform.IsVisual(order2);
            }

            @Override
            void doTransform(BidiTransform bidiTransform) {
                bidiTransform.shapeArabic(0, 0);
                bidiTransform.resolve((byte)0, 0);
                bidiTransform.reorder();
            }
        }
        ,
        LOG_RTL_TO_VIS_LTR{

            @Override
            boolean matches(byte by2, Order order, byte by3, Order order2) {
                return BidiTransform.IsRTL(by2) && BidiTransform.IsLogical(order) && BidiTransform.IsLTR(by3) && BidiTransform.IsVisual(order2);
            }

            @Override
            void doTransform(BidiTransform bidiTransform) {
                bidiTransform.resolve((byte)1, 0);
                bidiTransform.reorder();
                bidiTransform.shapeArabic(0, 4);
            }
        }
        ,
        LOG_LTR_TO_VIS_RTL{

            @Override
            boolean matches(byte by2, Order order, byte by3, Order order2) {
                return BidiTransform.IsLTR(by2) && BidiTransform.IsLogical(order) && BidiTransform.IsRTL(by3) && BidiTransform.IsVisual(order2);
            }

            @Override
            void doTransform(BidiTransform bidiTransform) {
                bidiTransform.shapeArabic(0, 0);
                bidiTransform.resolve((byte)0, 0);
                bidiTransform.reorder();
                bidiTransform.reverse();
            }
        }
        ,
        LOG_RTL_TO_VIS_RTL{

            @Override
            boolean matches(byte by2, Order order, byte by3, Order order2) {
                return BidiTransform.IsRTL(by2) && BidiTransform.IsLogical(order) && BidiTransform.IsRTL(by3) && BidiTransform.IsVisual(order2);
            }

            @Override
            void doTransform(BidiTransform bidiTransform) {
                bidiTransform.resolve((byte)1, 0);
                bidiTransform.reorder();
                bidiTransform.shapeArabic(0, 4);
                bidiTransform.reverse();
            }
        }
        ,
        VIS_LTR_TO_LOG_RTL{

            @Override
            boolean matches(byte by2, Order order, byte by3, Order order2) {
                return BidiTransform.IsLTR(by2) && BidiTransform.IsVisual(order) && BidiTransform.IsRTL(by3) && BidiTransform.IsLogical(order2);
            }

            @Override
            void doTransform(BidiTransform bidiTransform) {
                bidiTransform.shapeArabic(0, 4);
                bidiTransform.resolve((byte)1, 5);
                bidiTransform.reorder();
            }
        }
        ,
        VIS_RTL_TO_LOG_RTL{

            @Override
            boolean matches(byte by2, Order order, byte by3, Order order2) {
                return BidiTransform.IsRTL(by2) && BidiTransform.IsVisual(order) && BidiTransform.IsRTL(by3) && BidiTransform.IsLogical(order2);
            }

            @Override
            void doTransform(BidiTransform bidiTransform) {
                bidiTransform.reverse();
                bidiTransform.shapeArabic(0, 4);
                bidiTransform.resolve((byte)1, 5);
                bidiTransform.reorder();
            }
        }
        ,
        VIS_LTR_TO_LOG_LTR{

            @Override
            boolean matches(byte by2, Order order, byte by3, Order order2) {
                return BidiTransform.IsLTR(by2) && BidiTransform.IsVisual(order) && BidiTransform.IsLTR(by3) && BidiTransform.IsLogical(order2);
            }

            @Override
            void doTransform(BidiTransform bidiTransform) {
                bidiTransform.resolve((byte)0, 5);
                bidiTransform.reorder();
                bidiTransform.shapeArabic(0, 0);
            }
        }
        ,
        VIS_RTL_TO_LOG_LTR{

            @Override
            boolean matches(byte by2, Order order, byte by3, Order order2) {
                return BidiTransform.IsRTL(by2) && BidiTransform.IsVisual(order) && BidiTransform.IsLTR(by3) && BidiTransform.IsLogical(order2);
            }

            @Override
            void doTransform(BidiTransform bidiTransform) {
                bidiTransform.reverse();
                bidiTransform.resolve((byte)0, 5);
                bidiTransform.reorder();
                bidiTransform.shapeArabic(0, 0);
            }
        }
        ,
        LOG_LTR_TO_LOG_RTL{

            @Override
            boolean matches(byte by2, Order order, byte by3, Order order2) {
                return BidiTransform.IsLTR(by2) && BidiTransform.IsLogical(order) && BidiTransform.IsRTL(by3) && BidiTransform.IsLogical(order2);
            }

            @Override
            void doTransform(BidiTransform bidiTransform) {
                bidiTransform.shapeArabic(0, 0);
                bidiTransform.resolve((byte)0, 0);
                bidiTransform.mirror();
                bidiTransform.resolve((byte)0, 3);
                bidiTransform.reorder();
            }
        }
        ,
        LOG_RTL_TO_LOG_LTR{

            @Override
            boolean matches(byte by2, Order order, byte by3, Order order2) {
                return BidiTransform.IsRTL(by2) && BidiTransform.IsLogical(order) && BidiTransform.IsLTR(by3) && BidiTransform.IsLogical(order2);
            }

            @Override
            void doTransform(BidiTransform bidiTransform) {
                bidiTransform.resolve((byte)1, 0);
                bidiTransform.mirror();
                bidiTransform.resolve((byte)1, 3);
                bidiTransform.reorder();
                bidiTransform.shapeArabic(0, 0);
            }
        }
        ,
        VIS_LTR_TO_VIS_RTL{

            @Override
            boolean matches(byte by2, Order order, byte by3, Order order2) {
                return BidiTransform.IsLTR(by2) && BidiTransform.IsVisual(order) && BidiTransform.IsRTL(by3) && BidiTransform.IsVisual(order2);
            }

            @Override
            void doTransform(BidiTransform bidiTransform) {
                bidiTransform.resolve((byte)0, 0);
                bidiTransform.mirror();
                bidiTransform.shapeArabic(0, 4);
                bidiTransform.reverse();
            }
        }
        ,
        VIS_RTL_TO_VIS_LTR{

            @Override
            boolean matches(byte by2, Order order, byte by3, Order order2) {
                return BidiTransform.IsRTL(by2) && BidiTransform.IsVisual(order) && BidiTransform.IsLTR(by3) && BidiTransform.IsVisual(order2);
            }

            @Override
            void doTransform(BidiTransform bidiTransform) {
                bidiTransform.reverse();
                bidiTransform.resolve((byte)0, 0);
                bidiTransform.mirror();
                bidiTransform.shapeArabic(0, 4);
            }
        }
        ,
        LOG_LTR_TO_LOG_LTR{

            @Override
            boolean matches(byte by2, Order order, byte by3, Order order2) {
                return BidiTransform.IsLTR(by2) && BidiTransform.IsLogical(order) && BidiTransform.IsLTR(by3) && BidiTransform.IsLogical(order2);
            }

            @Override
            void doTransform(BidiTransform bidiTransform) {
                bidiTransform.resolve((byte)0, 0);
                bidiTransform.mirror();
                bidiTransform.shapeArabic(0, 0);
            }
        }
        ,
        LOG_RTL_TO_LOG_RTL{

            @Override
            boolean matches(byte by2, Order order, byte by3, Order order2) {
                return BidiTransform.IsRTL(by2) && BidiTransform.IsLogical(order) && BidiTransform.IsRTL(by3) && BidiTransform.IsLogical(order2);
            }

            @Override
            void doTransform(BidiTransform bidiTransform) {
                bidiTransform.resolve((byte)1, 0);
                bidiTransform.mirror();
                bidiTransform.shapeArabic(4, 0);
            }
        }
        ,
        VIS_LTR_TO_VIS_LTR{

            @Override
            boolean matches(byte by2, Order order, byte by3, Order order2) {
                return BidiTransform.IsLTR(by2) && BidiTransform.IsVisual(order) && BidiTransform.IsLTR(by3) && BidiTransform.IsVisual(order2);
            }

            @Override
            void doTransform(BidiTransform bidiTransform) {
                bidiTransform.resolve((byte)0, 0);
                bidiTransform.mirror();
                bidiTransform.shapeArabic(0, 4);
            }
        }
        ,
        VIS_RTL_TO_VIS_RTL{

            @Override
            boolean matches(byte by2, Order order, byte by3, Order order2) {
                return BidiTransform.IsRTL(by2) && BidiTransform.IsVisual(order) && BidiTransform.IsRTL(by3) && BidiTransform.IsVisual(order2);
            }

            @Override
            void doTransform(BidiTransform bidiTransform) {
                bidiTransform.reverse();
                bidiTransform.resolve((byte)0, 0);
                bidiTransform.mirror();
                bidiTransform.shapeArabic(0, 4);
                bidiTransform.reverse();
            }
        };


        abstract boolean matches(byte var1, Order var2, byte var3, Order var4);

        abstract void doTransform(BidiTransform var1);
    }

    public static enum Mirroring {
        OFF,
        ON;

    }

    public static enum Order {
        LOGICAL,
        VISUAL;

    }
}

