/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.util.Arrays;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Bidi;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.BidiRun;

final class BidiLine {
    BidiLine() {
    }

    static void setTrailingWSStart(Bidi bidi) {
        int n2;
        byte[] byArray = bidi.dirProps;
        byte[] byArray2 = bidi.levels;
        byte by2 = bidi.paraLevel;
        if (byArray[n2 - 1] == 7) {
            bidi.trailingWSStart = n2;
            return;
        }
        for (n2 = bidi.length; n2 > 0 && (Bidi.DirPropFlag(byArray[n2 - 1]) & Bidi.MASK_WS) != 0; --n2) {
        }
        while (n2 > 0 && byArray2[n2 - 1] == by2) {
            --n2;
        }
        bidi.trailingWSStart = n2;
    }

    static Bidi setLine(Bidi bidi, int n2, int n3) {
        Bidi bidi2 = new Bidi();
        bidi2.originalLength = bidi2.resultLength = n3 - n2;
        bidi2.length = bidi2.resultLength;
        int n4 = bidi2.resultLength;
        bidi2.text = new char[n4];
        System.arraycopy(bidi.text, n2, bidi2.text, 0, n4);
        bidi2.paraLevel = bidi.GetParaLevelAt(n2);
        bidi2.paraCount = bidi.paraCount;
        bidi2.runs = new BidiRun[0];
        bidi2.reorderingMode = bidi.reorderingMode;
        bidi2.reorderingOptions = bidi.reorderingOptions;
        if (bidi.controlCount > 0) {
            for (int i2 = n2; i2 < n3; ++i2) {
                if (!Bidi.IsBidiControlChar(bidi.text[i2])) continue;
                ++bidi2.controlCount;
            }
            bidi2.resultLength -= bidi2.controlCount;
        }
        bidi2.getDirPropsMemory(n4);
        bidi2.dirProps = bidi2.dirPropsMemory;
        System.arraycopy(bidi.dirProps, n2, bidi2.dirProps, 0, n4);
        bidi2.getLevelsMemory(n4);
        bidi2.levels = bidi2.levelsMemory;
        System.arraycopy(bidi.levels, n2, bidi2.levels, 0, n4);
        bidi2.runCount = -1;
        if (bidi.direction != 2) {
            bidi2.direction = bidi.direction;
            bidi2.trailingWSStart = bidi.trailingWSStart <= n2 ? 0 : (bidi.trailingWSStart < n3 ? bidi.trailingWSStart - n2 : n4);
        } else {
            byte[] byArray = bidi2.levels;
            BidiLine.setTrailingWSStart(bidi2);
            int n5 = bidi2.trailingWSStart;
            if (n5 == 0) {
                bidi2.direction = (byte)(bidi2.paraLevel & 1);
            } else {
                byte by2 = (byte)(byArray[0] & 1);
                if (n5 < n4 && (bidi2.paraLevel & 1) != by2) {
                    bidi2.direction = (byte)2;
                } else {
                    int n6 = 1;
                    while (true) {
                        if (n6 == n5) {
                            bidi2.direction = by2;
                            break;
                        }
                        if ((byArray[n6] & 1) != by2) {
                            bidi2.direction = (byte)2;
                            break;
                        }
                        ++n6;
                    }
                }
            }
            switch (bidi2.direction) {
                case 0: {
                    bidi2.paraLevel = (byte)(bidi2.paraLevel + 1 & 0xFFFFFFFE);
                    bidi2.trailingWSStart = 0;
                    break;
                }
                case 1: {
                    bidi2.paraLevel = (byte)(bidi2.paraLevel | 1);
                    bidi2.trailingWSStart = 0;
                    break;
                }
            }
        }
        bidi2.paraBidi = bidi;
        return bidi2;
    }

    static byte getLevelAt(Bidi bidi, int n2) {
        if (bidi.direction != 2 || n2 >= bidi.trailingWSStart) {
            return bidi.GetParaLevelAt(n2);
        }
        return bidi.levels[n2];
    }

    static byte[] getLevels(Bidi bidi) {
        int n2 = bidi.trailingWSStart;
        int n3 = bidi.length;
        if (n2 != n3) {
            Arrays.fill(bidi.levels, n2, n3, bidi.paraLevel);
            bidi.trailingWSStart = n3;
        }
        if (n3 < bidi.levels.length) {
            byte[] byArray = new byte[n3];
            System.arraycopy(bidi.levels, 0, byArray, 0, n3);
            return byArray;
        }
        return bidi.levels;
    }

    static BidiRun getLogicalRun(Bidi bidi, int n2) {
        BidiRun bidiRun = new BidiRun();
        BidiLine.getRuns(bidi);
        int n3 = bidi.runCount;
        int n4 = 0;
        int n5 = 0;
        BidiRun bidiRun2 = bidi.runs[0];
        for (int i2 = 0; i2 < n3; ++i2) {
            bidiRun2 = bidi.runs[i2];
            n5 = bidiRun2.start + bidiRun2.limit - n4;
            if (n2 >= bidiRun2.start && n2 < n5) break;
            n4 = bidiRun2.limit;
        }
        bidiRun.start = bidiRun2.start;
        bidiRun.limit = n5;
        bidiRun.level = bidiRun2.level;
        return bidiRun;
    }

    static BidiRun getVisualRun(Bidi bidi, int n2) {
        int n3 = bidi.runs[n2].start;
        byte by2 = bidi.runs[n2].level;
        int n4 = n2 > 0 ? n3 + bidi.runs[n2].limit - bidi.runs[n2 - 1].limit : n3 + bidi.runs[0].limit;
        return new BidiRun(n3, n4, by2);
    }

    static void getSingleRun(Bidi bidi, byte by2) {
        bidi.runs = bidi.simpleRuns;
        bidi.runCount = 1;
        bidi.runs[0] = new BidiRun(0, bidi.length, by2);
    }

    private static void reorderLine(Bidi bidi, byte by2, byte by3) {
        BidiRun bidiRun;
        int n2;
        if (by3 <= (by2 | 1)) {
            return;
        }
        by2 = (byte)(by2 + 1);
        BidiRun[] bidiRunArray = bidi.runs;
        byte[] byArray = bidi.levels;
        int n3 = bidi.runCount;
        if (bidi.trailingWSStart < bidi.length) {
            --n3;
        }
        block0: while ((by3 = (byte)(by3 - 1)) >= by2) {
            n2 = 0;
            while (true) {
                if (n2 < n3 && byArray[bidiRunArray[n2].start] < by3) {
                    ++n2;
                    continue;
                }
                if (n2 >= n3) continue block0;
                int n4 = n2;
                while (++n4 < n3 && byArray[bidiRunArray[n4].start] >= by3) {
                }
                for (int i2 = n4 - 1; n2 < i2; ++n2, --i2) {
                    bidiRun = bidiRunArray[n2];
                    bidiRunArray[n2] = bidiRunArray[i2];
                    bidiRunArray[i2] = bidiRun;
                }
                if (n4 == n3) continue block0;
                n2 = n4 + 1;
            }
        }
        if ((by2 & 1) == 0) {
            n2 = 0;
            if (bidi.trailingWSStart == bidi.length) {
                --n3;
            }
            while (n2 < n3) {
                bidiRun = bidiRunArray[n2];
                bidiRunArray[n2] = bidiRunArray[n3];
                bidiRunArray[n3] = bidiRun;
                ++n2;
                --n3;
            }
        }
    }

    static int getRunFromLogicalIndex(Bidi bidi, int n2) {
        BidiRun[] bidiRunArray = bidi.runs;
        int n3 = bidi.runCount;
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5 = bidiRunArray[i2].limit - n4;
            int n6 = bidiRunArray[i2].start;
            if (n2 >= n6 && n2 < n6 + n5) {
                return i2;
            }
            n4 += n5;
        }
        throw new IllegalStateException("Internal ICU error in getRunFromLogicalIndex");
    }

    static void getRuns(Bidi bidi) {
        int n2;
        int n3;
        if (bidi.runCount >= 0) {
            return;
        }
        if (bidi.direction != 2) {
            BidiLine.getSingleRun(bidi, bidi.paraLevel);
        } else {
            int n4;
            n3 = bidi.length;
            byte[] byArray = bidi.levels;
            byte by2 = -1;
            n2 = bidi.trailingWSStart;
            int n5 = 0;
            for (n4 = 0; n4 < n2; ++n4) {
                if (byArray[n4] == by2) continue;
                ++n5;
                by2 = byArray[n4];
            }
            if (n5 == 1 && n2 == n3) {
                BidiLine.getSingleRun(bidi, byArray[0]);
            } else {
                byte by3 = 126;
                byte by4 = 0;
                if (n2 < n3) {
                    ++n5;
                }
                bidi.getRunsMemory(n5);
                BidiRun[] bidiRunArray = bidi.runsMemory;
                int n6 = 0;
                n4 = 0;
                do {
                    int n7 = n4;
                    by2 = byArray[n4];
                    if (by2 < by3) {
                        by3 = by2;
                    }
                    if (by2 > by4) {
                        by4 = by2;
                    }
                    while (++n4 < n2 && byArray[n4] == by2) {
                    }
                    bidiRunArray[n6] = new BidiRun(n7, n4 - n7, by2);
                    ++n6;
                } while (n4 < n2);
                if (n2 < n3) {
                    bidiRunArray[n6] = new BidiRun(n2, n3 - n2, bidi.paraLevel);
                    if (bidi.paraLevel < by3) {
                        by3 = bidi.paraLevel;
                    }
                }
                bidi.runs = bidiRunArray;
                bidi.runCount = n5;
                BidiLine.reorderLine(bidi, by3, by4);
                n2 = 0;
                for (n4 = 0; n4 < n5; ++n4) {
                    bidiRunArray[n4].level = byArray[bidiRunArray[n4].start];
                    n2 = bidiRunArray[n4].limit += n2;
                }
                if (n6 < n5) {
                    int n8 = (bidi.paraLevel & 1) != 0 ? 0 : n6;
                    bidiRunArray[n8].level = bidi.paraLevel;
                }
            }
        }
        if (bidi.insertPoints.size > 0) {
            for (int i2 = 0; i2 < bidi.insertPoints.size; ++i2) {
                Bidi.Point point = bidi.insertPoints.points[i2];
                n2 = BidiLine.getRunFromLogicalIndex(bidi, point.pos);
                bidi.runs[n2].insertRemove |= point.flag;
            }
        }
        if (bidi.controlCount > 0) {
            for (n2 = 0; n2 < bidi.length; ++n2) {
                char c2 = bidi.text[n2];
                if (!Bidi.IsBidiControlChar(c2)) continue;
                n3 = BidiLine.getRunFromLogicalIndex(bidi, n2);
                --bidi.runs[n3].insertRemove;
            }
        }
    }

    static int[] prepareReorder(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (byArray == null || byArray.length <= 0) {
            return null;
        }
        byte by2 = 126;
        byte by3 = 0;
        int n2 = byArray.length;
        while (n2 > 0) {
            byte by4;
            if ((by4 = byArray[--n2]) < 0) {
                return null;
            }
            if (by4 > 126) {
                return null;
            }
            if (by4 < by2) {
                by2 = by4;
            }
            if (by4 <= by3) continue;
            by3 = by4;
        }
        byArray2[0] = by2;
        byArray3[0] = by3;
        int[] nArray = new int[byArray.length];
        n2 = byArray.length;
        while (n2 > 0) {
            nArray[--n2] = n2;
        }
        return nArray;
    }

    static int[] reorderLogical(byte[] byArray) {
        byte[] byArray2 = new byte[1];
        byte[] byArray3 = new byte[1];
        int[] nArray = BidiLine.prepareReorder(byArray, byArray2, byArray3);
        if (nArray == null) {
            return null;
        }
        byte by2 = byArray2[0];
        byte by3 = byArray3[0];
        if (by2 == by3 && (by2 & 1) == 0) {
            return nArray;
        }
        by2 = (byte)(by2 | 1);
        block0: do {
            int n2 = 0;
            while (true) {
                if (n2 < byArray.length && byArray[n2] < by3) {
                    ++n2;
                    continue;
                }
                if (n2 >= byArray.length) continue block0;
                int n3 = n2;
                while (++n3 < byArray.length && byArray[n3] >= by3) {
                }
                int n4 = n2 + n3 - 1;
                do {
                    nArray[n2] = n4 - nArray[n2];
                } while (++n2 < n3);
                if (n3 == byArray.length) continue block0;
                n2 = n3 + 1;
            }
        } while ((by3 = (byte)(by3 - 1)) >= by2);
        return nArray;
    }

    static int[] reorderVisual(byte[] byArray) {
        byte[] byArray2 = new byte[1];
        byte[] byArray3 = new byte[1];
        int[] nArray = BidiLine.prepareReorder(byArray, byArray2, byArray3);
        if (nArray == null) {
            return null;
        }
        byte by2 = byArray2[0];
        byte by3 = byArray3[0];
        if (by2 == by3 && (by2 & 1) == 0) {
            return nArray;
        }
        by2 = (byte)(by2 | 1);
        block0: do {
            int n2 = 0;
            while (true) {
                if (n2 < byArray.length && byArray[n2] < by3) {
                    ++n2;
                    continue;
                }
                if (n2 >= byArray.length) continue block0;
                int n3 = n2;
                while (++n3 < byArray.length && byArray[n3] >= by3) {
                }
                for (int i2 = n3 - 1; n2 < i2; ++n2, --i2) {
                    int n4 = nArray[n2];
                    nArray[n2] = nArray[i2];
                    nArray[i2] = n4;
                }
                if (n3 == byArray.length) continue block0;
                n2 = n3 + 1;
            }
        } while ((by3 = (byte)(by3 - 1)) >= by2);
        return nArray;
    }

    static int getVisualIndex(Bidi bidi, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        BidiRun[] bidiRunArray;
        int n7 = -1;
        switch (bidi.direction) {
            case 0: {
                n7 = n2;
                break;
            }
            case 1: {
                n7 = bidi.length - n2 - 1;
                break;
            }
            default: {
                BidiLine.getRuns(bidi);
                bidiRunArray = bidi.runs;
                n6 = 0;
                for (n5 = 0; n5 < bidi.runCount; ++n5) {
                    n4 = bidiRunArray[n5].limit - n6;
                    n3 = n2 - bidiRunArray[n5].start;
                    if (n3 >= 0 && n3 < n4) {
                        if (bidiRunArray[n5].isEvenRun()) {
                            n7 = n6 + n3;
                            break;
                        }
                        n7 = n6 + n4 - n3 - 1;
                        break;
                    }
                    n6 += n4;
                }
                if (n5 < bidi.runCount) break;
                return -1;
            }
        }
        if (bidi.insertPoints.size > 0) {
            bidiRunArray = bidi.runs;
            n4 = 0;
            int n8 = 0;
            n5 = 0;
            while (true) {
                n6 = bidiRunArray[n5].limit - n4;
                n3 = bidiRunArray[n5].insertRemove;
                if ((n3 & 5) > 0) {
                    ++n8;
                }
                if (n7 < bidiRunArray[n5].limit) {
                    return n7 + n8;
                }
                if ((n3 & 0xA) > 0) {
                    ++n8;
                }
                ++n5;
                n4 += n6;
            }
        }
        if (bidi.controlCount > 0) {
            bidiRunArray = bidi.runs;
            int n9 = 0;
            int n10 = 0;
            char c2 = bidi.text[n2];
            if (Bidi.IsBidiControlChar(c2)) {
                return -1;
            }
            n5 = 0;
            while (true) {
                int n11 = bidiRunArray[n5].limit - n9;
                int n12 = bidiRunArray[n5].insertRemove;
                if (n7 >= bidiRunArray[n5].limit) {
                    n10 -= n12;
                } else {
                    if (n12 == 0) {
                        return n7 - n10;
                    }
                    if (bidiRunArray[n5].isEvenRun()) {
                        n3 = bidiRunArray[n5].start;
                        n4 = n2;
                    } else {
                        n3 = n2 + 1;
                        n4 = bidiRunArray[n5].start + n11;
                    }
                    for (n6 = n3; n6 < n4; ++n6) {
                        c2 = bidi.text[n6];
                        if (!Bidi.IsBidiControlChar(c2)) continue;
                        ++n10;
                    }
                    return n7 - n10;
                }
                ++n5;
                n9 += n11;
            }
        }
        return n7;
    }

    static int getLogicalIndex(Bidi bidi, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        BidiRun[] bidiRunArray;
        block21: {
            int n7;
            int n8;
            bidiRunArray = bidi.runs;
            n6 = bidi.runCount;
            if (bidi.insertPoints.size > 0) {
                n5 = 0;
                n8 = 0;
                n4 = 0;
                while (true) {
                    n7 = bidiRunArray[n4].limit - n8;
                    n3 = bidiRunArray[n4].insertRemove;
                    if ((n3 & 5) > 0) {
                        if (n2 <= n8 + n5) {
                            return -1;
                        }
                        ++n5;
                    }
                    if (n2 < bidiRunArray[n4].limit + n5) {
                        n2 -= n5;
                        break block21;
                    }
                    if ((n3 & 0xA) > 0) {
                        if (n2 == n8 + n7 + n5) {
                            return -1;
                        }
                        ++n5;
                    }
                    ++n4;
                    n8 += n7;
                }
            }
            if (bidi.controlCount > 0) {
                n5 = 0;
                int n9 = 0;
                n4 = 0;
                while (true) {
                    n8 = bidiRunArray[n4].limit - n9;
                    n3 = bidiRunArray[n4].insertRemove;
                    if (n2 >= bidiRunArray[n4].limit - n5 + n3) {
                        n5 -= n3;
                    } else {
                        if (n3 == 0) {
                            n2 += n5;
                            break;
                        }
                        n7 = bidiRunArray[n4].start;
                        boolean bl2 = bidiRunArray[n4].isEvenRun();
                        int n10 = n7 + n8 - 1;
                        for (int i2 = 0; i2 < n8; ++i2) {
                            int n11 = bl2 ? n7 + i2 : n10 - i2;
                            char c2 = bidi.text[n11];
                            if (Bidi.IsBidiControlChar(c2)) {
                                ++n5;
                            }
                            if (n2 + n5 == n9 + i2) break;
                        }
                        n2 += n5;
                        break;
                    }
                    ++n4;
                    n9 += n8;
                }
            }
        }
        if (n6 <= 10) {
            n4 = 0;
            while (n2 >= bidiRunArray[n4].limit) {
                ++n4;
            }
        } else {
            n5 = 0;
            n3 = n6;
            while (true) {
                n4 = n5 + n3 >>> 1;
                if (n2 >= bidiRunArray[n4].limit) {
                    n5 = n4 + 1;
                    continue;
                }
                if (n4 == 0 || n2 >= bidiRunArray[n4 - 1].limit) break;
                n3 = n4;
            }
        }
        int n12 = bidiRunArray[n4].start;
        if (bidiRunArray[n4].isEvenRun()) {
            if (n4 > 0) {
                n2 -= bidiRunArray[n4 - 1].limit;
            }
            return n12 + n2;
        }
        return n12 + bidiRunArray[n4].limit - n2 - 1;
    }

    static int[] getLogicalMap(Bidi bidi) {
        int[] nArray;
        block18: {
            int n2;
            int n3;
            int n4;
            BidiRun[] bidiRunArray;
            block17: {
                bidiRunArray = bidi.runs;
                nArray = new int[bidi.length];
                if (bidi.length > bidi.resultLength) {
                    Arrays.fill(nArray, -1);
                }
                n4 = 0;
                for (n3 = 0; n3 < bidi.runCount; ++n3) {
                    n2 = bidiRunArray[n3].start;
                    int n5 = bidiRunArray[n3].limit;
                    if (bidiRunArray[n3].isEvenRun()) {
                        do {
                            nArray[n2++] = n4++;
                        } while (n4 < n5);
                        continue;
                    }
                    n2 += n5 - n4;
                    do {
                        nArray[--n2] = n4++;
                    } while (n4 < n5);
                }
                if (bidi.insertPoints.size <= 0) break block17;
                n3 = 0;
                int n6 = bidi.runCount;
                bidiRunArray = bidi.runs;
                n4 = 0;
                int n7 = 0;
                while (n7 < n6) {
                    int n8 = bidiRunArray[n7].limit - n4;
                    int n9 = bidiRunArray[n7].insertRemove;
                    if ((n9 & 5) > 0) {
                        ++n3;
                    }
                    if (n3 > 0) {
                        n2 = bidiRunArray[n7].start;
                        int n10 = n2 + n8;
                        int n11 = n2;
                        while (n11 < n10) {
                            int n12 = n11++;
                            nArray[n12] = nArray[n12] + n3;
                        }
                    }
                    if ((n9 & 0xA) > 0) {
                        ++n3;
                    }
                    ++n7;
                    n4 += n8;
                }
                break block18;
            }
            if (bidi.controlCount <= 0) break block18;
            n3 = 0;
            int n13 = bidi.runCount;
            bidiRunArray = bidi.runs;
            n4 = 0;
            int n14 = 0;
            while (n14 < n13) {
                int n15 = bidiRunArray[n14].limit - n4;
                int n16 = bidiRunArray[n14].insertRemove;
                if (n3 - n16 != 0) {
                    int n17;
                    n2 = bidiRunArray[n14].start;
                    boolean bl2 = bidiRunArray[n14].isEvenRun();
                    int n18 = n2 + n15;
                    if (n16 == 0) {
                        n17 = n2;
                        while (n17 < n18) {
                            int n19 = n17++;
                            nArray[n19] = nArray[n19] - n3;
                        }
                    } else {
                        for (n17 = 0; n17 < n15; ++n17) {
                            int n20 = bl2 ? n2 + n17 : n18 - n17 - 1;
                            char c2 = bidi.text[n20];
                            if (Bidi.IsBidiControlChar(c2)) {
                                ++n3;
                                nArray[n20] = -1;
                                continue;
                            }
                            int n21 = n20;
                            nArray[n21] = nArray[n21] - n3;
                        }
                    }
                }
                ++n14;
                n4 += n15;
            }
        }
        return nArray;
    }

    static int[] getVisualMap(Bidi bidi) {
        int n2;
        int n3;
        int n4;
        BidiRun[] bidiRunArray = bidi.runs;
        int n5 = bidi.length > bidi.resultLength ? bidi.length : bidi.resultLength;
        int[] nArray = new int[n5];
        int n6 = 0;
        int n7 = 0;
        for (n4 = 0; n4 < bidi.runCount; ++n4) {
            n3 = bidiRunArray[n4].start;
            n2 = bidiRunArray[n4].limit;
            if (bidiRunArray[n4].isEvenRun()) {
                do {
                    nArray[n7++] = n3++;
                } while (++n6 < n2);
                continue;
            }
            n3 += n2 - n6;
            do {
                nArray[n7++] = --n3;
            } while (++n6 < n2);
        }
        if (bidi.insertPoints.size > 0) {
            int n8;
            int n9;
            n4 = 0;
            int n10 = bidi.runCount;
            bidiRunArray = bidi.runs;
            for (n9 = 0; n9 < n10; ++n9) {
                n8 = bidiRunArray[n9].insertRemove;
                if ((n8 & 5) > 0) {
                    ++n4;
                }
                if ((n8 & 0xA) <= 0) continue;
                ++n4;
            }
            int n11 = bidi.resultLength;
            for (n9 = n10 - 1; n9 >= 0 && n4 > 0; --n9) {
                n8 = bidiRunArray[n9].insertRemove;
                if ((n8 & 0xA) > 0) {
                    nArray[--n11] = -1;
                    --n4;
                }
                n6 = n9 > 0 ? bidiRunArray[n9 - 1].limit : 0;
                for (int i2 = bidiRunArray[n9].limit - 1; i2 >= n6 && n4 > 0; --i2) {
                    nArray[--n11] = nArray[i2];
                }
                if ((n8 & 5) <= 0) continue;
                nArray[--n11] = -1;
                --n4;
            }
        } else if (bidi.controlCount > 0) {
            n4 = bidi.runCount;
            bidiRunArray = bidi.runs;
            n6 = 0;
            int n12 = 0;
            int n13 = 0;
            while (n13 < n4) {
                int n14;
                int n15 = bidiRunArray[n13].limit - n6;
                int n16 = bidiRunArray[n13].insertRemove;
                if (n16 == 0 && n12 == n6) {
                    n12 += n15;
                } else if (n16 == 0) {
                    n2 = bidiRunArray[n13].limit;
                    for (n14 = n6; n14 < n2; ++n14) {
                        nArray[n12++] = nArray[n14];
                    }
                } else {
                    n3 = bidiRunArray[n13].start;
                    boolean bl2 = bidiRunArray[n13].isEvenRun();
                    int n17 = n3 + n15 - 1;
                    for (n14 = 0; n14 < n15; ++n14) {
                        int n18 = bl2 ? n3 + n14 : n17 - n14;
                        char c2 = bidi.text[n18];
                        if (Bidi.IsBidiControlChar(c2)) continue;
                        nArray[n12++] = n18;
                    }
                }
                ++n13;
                n6 += n15;
            }
        }
        if (n5 == bidi.resultLength) {
            return nArray;
        }
        int[] nArray2 = new int[bidi.resultLength];
        System.arraycopy(nArray, 0, nArray2, 0, bidi.resultLength);
        return nArray2;
    }

    static int[] invertMap(int[] nArray) {
        int n2;
        int n3;
        int n4 = nArray.length;
        int n5 = -1;
        int n6 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = nArray[n3];
            if (n2 > n5) {
                n5 = n2;
            }
            if (n2 < 0) continue;
            ++n6;
        }
        int[] nArray2 = new int[++n5];
        if (n6 < n5) {
            Arrays.fill(nArray2, -1);
        }
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = nArray[n3];
            if (n2 < 0) continue;
            nArray2[n2] = n3;
        }
        return nArray2;
    }
}

