/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.awt.font.NumericShaper;
import java.awt.font.TextAttribute;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.text.AttributedCharacterIterator;
import java.util.Arrays;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.UBiDiProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.BidiClassifier;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.BidiLine;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.BidiRun;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.BidiWriter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;

public class Bidi {
    public static final byte LEVEL_DEFAULT_LTR = 126;
    public static final byte LEVEL_DEFAULT_RTL = 127;
    public static final byte MAX_EXPLICIT_LEVEL = 125;
    public static final byte LEVEL_OVERRIDE = -128;
    public static final int MAP_NOWHERE = -1;
    public static final byte LTR = 0;
    public static final byte RTL = 1;
    public static final byte MIXED = 2;
    public static final byte NEUTRAL = 3;
    public static final short KEEP_BASE_COMBINING = 1;
    public static final short DO_MIRRORING = 2;
    public static final short INSERT_LRM_FOR_NUMERIC = 4;
    public static final short REMOVE_BIDI_CONTROLS = 8;
    public static final short OUTPUT_REVERSE = 16;
    public static final short REORDER_DEFAULT = 0;
    public static final short REORDER_NUMBERS_SPECIAL = 1;
    public static final short REORDER_GROUP_NUMBERS_WITH_R = 2;
    public static final short REORDER_RUNS_ONLY = 3;
    public static final short REORDER_INVERSE_NUMBERS_AS_L = 4;
    public static final short REORDER_INVERSE_LIKE_DIRECT = 5;
    public static final short REORDER_INVERSE_FOR_NUMBERS_SPECIAL = 6;
    static final short REORDER_COUNT = 7;
    static final short REORDER_LAST_LOGICAL_TO_VISUAL = 1;
    public static final int OPTION_DEFAULT = 0;
    public static final int OPTION_INSERT_MARKS = 1;
    public static final int OPTION_REMOVE_CONTROLS = 2;
    public static final int OPTION_STREAMING = 4;
    static final byte L = 0;
    static final byte R = 1;
    static final byte EN = 2;
    static final byte ES = 3;
    static final byte ET = 4;
    static final byte AN = 5;
    static final byte CS = 6;
    static final byte B = 7;
    static final byte S = 8;
    static final byte WS = 9;
    static final byte ON = 10;
    static final byte LRE = 11;
    static final byte LRO = 12;
    static final byte AL = 13;
    static final byte RLE = 14;
    static final byte RLO = 15;
    static final byte PDF = 16;
    static final byte NSM = 17;
    static final byte BN = 18;
    static final byte FSI = 19;
    static final byte LRI = 20;
    static final byte RLI = 21;
    static final byte PDI = 22;
    static final byte ENL = 23;
    static final byte ENR = 24;
    @Deprecated
    public static final int CLASS_DEFAULT = 23;
    static final int SIMPLE_PARAS_COUNT = 10;
    static final int SIMPLE_OPENINGS_COUNT = 20;
    private static final char CR = '\r';
    private static final char LF = '\n';
    static final int LRM_BEFORE = 1;
    static final int LRM_AFTER = 2;
    static final int RLM_BEFORE = 4;
    static final int RLM_AFTER = 8;
    static final byte FOUND_L = (byte)Bidi.DirPropFlag((byte)0);
    static final byte FOUND_R = (byte)Bidi.DirPropFlag((byte)1);
    static final int ISOLATE = 256;
    Bidi paraBidi;
    final UBiDiProps bdp;
    char[] text;
    int originalLength;
    int length;
    int resultLength;
    boolean mayAllocateText;
    boolean mayAllocateRuns;
    byte[] dirPropsMemory = new byte[1];
    byte[] levelsMemory = new byte[1];
    byte[] dirProps;
    byte[] levels;
    boolean isInverse;
    int reorderingMode;
    int reorderingOptions;
    boolean orderParagraphsLTR;
    byte paraLevel;
    byte defaultParaLevel;
    String prologue;
    String epilogue;
    ImpTabPair impTabPair;
    byte direction;
    int flags;
    int lastArabicPos;
    int trailingWSStart;
    int paraCount;
    int[] paras_limit = new int[10];
    byte[] paras_level = new byte[10];
    int runCount;
    BidiRun[] runsMemory = new BidiRun[0];
    BidiRun[] runs;
    BidiRun[] simpleRuns = new BidiRun[]{new BidiRun()};
    Isolate[] isolates;
    int isolateCount;
    int[] logicalToVisualRunsMap;
    boolean isGoodLogicalToVisualRunsMap;
    BidiClassifier customClassifier = null;
    InsertPoints insertPoints = new InsertPoints();
    int controlCount;
    static final int DirPropFlagMultiRuns = Bidi.DirPropFlag((byte)31);
    static final int[] DirPropFlagLR = new int[]{Bidi.DirPropFlag((byte)0), Bidi.DirPropFlag((byte)1)};
    static final int[] DirPropFlagE = new int[]{Bidi.DirPropFlag((byte)11), Bidi.DirPropFlag((byte)14)};
    static final int[] DirPropFlagO = new int[]{Bidi.DirPropFlag((byte)12), Bidi.DirPropFlag((byte)15)};
    static final int MASK_LTR = Bidi.DirPropFlag((byte)0) | Bidi.DirPropFlag((byte)2) | Bidi.DirPropFlag((byte)23) | Bidi.DirPropFlag((byte)24) | Bidi.DirPropFlag((byte)5) | Bidi.DirPropFlag((byte)11) | Bidi.DirPropFlag((byte)12) | Bidi.DirPropFlag((byte)20);
    static final int MASK_RTL = Bidi.DirPropFlag((byte)1) | Bidi.DirPropFlag((byte)13) | Bidi.DirPropFlag((byte)14) | Bidi.DirPropFlag((byte)15) | Bidi.DirPropFlag((byte)21);
    static final int MASK_R_AL = Bidi.DirPropFlag((byte)1) | Bidi.DirPropFlag((byte)13);
    static final int MASK_STRONG_EN_AN = Bidi.DirPropFlag((byte)0) | Bidi.DirPropFlag((byte)1) | Bidi.DirPropFlag((byte)13) | Bidi.DirPropFlag((byte)2) | Bidi.DirPropFlag((byte)5);
    static final int MASK_EXPLICIT = Bidi.DirPropFlag((byte)11) | Bidi.DirPropFlag((byte)12) | Bidi.DirPropFlag((byte)14) | Bidi.DirPropFlag((byte)15) | Bidi.DirPropFlag((byte)16);
    static final int MASK_BN_EXPLICIT = Bidi.DirPropFlag((byte)18) | MASK_EXPLICIT;
    static final int MASK_ISO = Bidi.DirPropFlag((byte)20) | Bidi.DirPropFlag((byte)21) | Bidi.DirPropFlag((byte)19) | Bidi.DirPropFlag((byte)22);
    static final int MASK_B_S = Bidi.DirPropFlag((byte)7) | Bidi.DirPropFlag((byte)8);
    static final int MASK_WS = MASK_B_S | Bidi.DirPropFlag((byte)9) | MASK_BN_EXPLICIT | MASK_ISO;
    static final int MASK_POSSIBLE_N = Bidi.DirPropFlag((byte)10) | Bidi.DirPropFlag((byte)6) | Bidi.DirPropFlag((byte)3) | Bidi.DirPropFlag((byte)4) | MASK_WS;
    static final int MASK_EMBEDDING = Bidi.DirPropFlag((byte)17) | MASK_POSSIBLE_N;
    static final int NOT_SEEKING_STRONG = 0;
    static final int SEEKING_STRONG_FOR_PARA = 1;
    static final int SEEKING_STRONG_FOR_FSI = 2;
    static final int LOOKING_FOR_PDI = 3;
    private static final int IMPTABPROPS_COLUMNS = 16;
    private static final int IMPTABPROPS_RES = 15;
    private static final short[] groupProp = new short[]{0, 1, 2, 7, 8, 3, 9, 6, 5, 4, 4, 10, 10, 12, 10, 10, 10, 11, 10, 4, 4, 4, 4, 13, 14};
    private static final short _L = 0;
    private static final short _R = 1;
    private static final short _EN = 2;
    private static final short _AN = 3;
    private static final short _ON = 4;
    private static final short _S = 5;
    private static final short _B = 6;
    private static final short[][] impTabProps = new short[][]{{1, 2, 4, 5, 7, 15, 17, 7, 9, 7, 0, 7, 3, 18, 21, 4}, {1, 34, 36, 37, 39, 47, 49, 39, 41, 39, 1, 1, 35, 50, 53, 0}, {33, 2, 36, 37, 39, 47, 49, 39, 41, 39, 2, 2, 35, 50, 53, 1}, {33, 34, 38, 38, 40, 48, 49, 40, 40, 40, 3, 3, 3, 50, 53, 1}, {33, 34, 4, 37, 39, 47, 49, 74, 11, 74, 4, 4, 35, 18, 21, 2}, {33, 34, 36, 5, 39, 47, 49, 39, 41, 76, 5, 5, 35, 50, 53, 3}, {33, 34, 6, 6, 40, 48, 49, 40, 40, 77, 6, 6, 35, 18, 21, 3}, {33, 34, 36, 37, 7, 47, 49, 7, 78, 7, 7, 7, 35, 50, 53, 4}, {33, 34, 38, 38, 8, 48, 49, 8, 8, 8, 8, 8, 35, 50, 53, 4}, {33, 34, 4, 37, 7, 47, 49, 7, 9, 7, 9, 9, 35, 18, 21, 4}, {97, 98, 4, 101, 135, 111, 113, 135, 142, 135, 10, 135, 99, 18, 21, 2}, {33, 34, 4, 37, 39, 47, 49, 39, 11, 39, 11, 11, 35, 18, 21, 2}, {97, 98, 100, 5, 135, 111, 113, 135, 142, 135, 12, 135, 99, 114, 117, 3}, {97, 98, 6, 6, 136, 112, 113, 136, 136, 136, 13, 136, 99, 18, 21, 3}, {33, 34, 132, 37, 7, 47, 49, 7, 14, 7, 14, 14, 35, 146, 149, 4}, {33, 34, 36, 37, 39, 15, 49, 39, 41, 39, 15, 39, 35, 50, 53, 5}, {33, 34, 38, 38, 40, 16, 49, 40, 40, 40, 16, 40, 35, 50, 53, 5}, {33, 34, 36, 37, 39, 47, 17, 39, 41, 39, 17, 39, 35, 50, 53, 6}, {33, 34, 18, 37, 39, 47, 49, 83, 20, 83, 18, 18, 35, 18, 21, 0}, {97, 98, 18, 101, 135, 111, 113, 135, 142, 135, 19, 135, 99, 18, 21, 0}, {33, 34, 18, 37, 39, 47, 49, 39, 20, 39, 20, 20, 35, 18, 21, 0}, {33, 34, 21, 37, 39, 47, 49, 86, 23, 86, 21, 21, 35, 18, 21, 3}, {97, 98, 21, 101, 135, 111, 113, 135, 142, 135, 22, 135, 99, 18, 21, 3}, {33, 34, 21, 37, 39, 47, 49, 39, 23, 39, 23, 23, 35, 18, 21, 3}};
    private static final int IMPTABLEVELS_COLUMNS = 8;
    private static final int IMPTABLEVELS_RES = 7;
    private static final byte[][] impTabL_DEFAULT = new byte[][]{{0, 1, 0, 2, 0, 0, 0, 0}, {0, 1, 3, 3, 20, 20, 0, 1}, {0, 1, 0, 2, 21, 21, 0, 2}, {0, 1, 3, 3, 20, 20, 0, 2}, {0, 33, 51, 51, 4, 4, 0, 0}, {0, 33, 0, 50, 5, 5, 0, 0}};
    private static final byte[][] impTabR_DEFAULT = new byte[][]{{1, 0, 2, 2, 0, 0, 0, 0}, {1, 0, 1, 3, 20, 20, 0, 1}, {1, 0, 2, 2, 0, 0, 0, 1}, {1, 0, 1, 3, 5, 5, 0, 1}, {33, 0, 33, 3, 4, 4, 0, 0}, {1, 0, 1, 3, 5, 5, 0, 0}};
    private static final short[] impAct0 = new short[]{0, 1, 2, 3, 4};
    private static final ImpTabPair impTab_DEFAULT = new ImpTabPair(impTabL_DEFAULT, impTabR_DEFAULT, impAct0, impAct0);
    private static final byte[][] impTabL_NUMBERS_SPECIAL = new byte[][]{{0, 2, 17, 17, 0, 0, 0, 0}, {0, 66, 1, 1, 0, 0, 0, 0}, {0, 2, 4, 4, 19, 19, 0, 1}, {0, 34, 52, 52, 3, 3, 0, 0}, {0, 2, 4, 4, 19, 19, 0, 2}};
    private static final ImpTabPair impTab_NUMBERS_SPECIAL = new ImpTabPair(impTabL_NUMBERS_SPECIAL, impTabR_DEFAULT, impAct0, impAct0);
    private static final byte[][] impTabL_GROUP_NUMBERS_WITH_R = new byte[][]{{0, 3, 17, 17, 0, 0, 0, 0}, {32, 3, 1, 1, 2, 32, 32, 2}, {32, 3, 1, 1, 2, 32, 32, 1}, {0, 3, 5, 5, 20, 0, 0, 1}, {32, 3, 5, 5, 4, 32, 32, 1}, {0, 3, 5, 5, 20, 0, 0, 2}};
    private static final byte[][] impTabR_GROUP_NUMBERS_WITH_R = new byte[][]{{2, 0, 1, 1, 0, 0, 0, 0}, {2, 0, 1, 1, 0, 0, 0, 1}, {2, 0, 20, 20, 19, 0, 0, 1}, {34, 0, 4, 4, 3, 0, 0, 0}, {34, 0, 4, 4, 3, 0, 0, 1}};
    private static final ImpTabPair impTab_GROUP_NUMBERS_WITH_R = new ImpTabPair(impTabL_GROUP_NUMBERS_WITH_R, impTabR_GROUP_NUMBERS_WITH_R, impAct0, impAct0);
    private static final byte[][] impTabL_INVERSE_NUMBERS_AS_L = new byte[][]{{0, 1, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 0, 20, 20, 0, 1}, {0, 1, 0, 0, 21, 21, 0, 2}, {0, 1, 0, 0, 20, 20, 0, 2}, {32, 1, 32, 32, 4, 4, 32, 1}, {32, 1, 32, 32, 5, 5, 32, 1}};
    private static final byte[][] impTabR_INVERSE_NUMBERS_AS_L = new byte[][]{{1, 0, 1, 1, 0, 0, 0, 0}, {1, 0, 1, 1, 20, 20, 0, 1}, {1, 0, 1, 1, 0, 0, 0, 1}, {1, 0, 1, 1, 5, 5, 0, 1}, {33, 0, 33, 33, 4, 4, 0, 0}, {1, 0, 1, 1, 5, 5, 0, 0}};
    private static final ImpTabPair impTab_INVERSE_NUMBERS_AS_L = new ImpTabPair(impTabL_INVERSE_NUMBERS_AS_L, impTabR_INVERSE_NUMBERS_AS_L, impAct0, impAct0);
    private static final byte[][] impTabR_INVERSE_LIKE_DIRECT = new byte[][]{{1, 0, 2, 2, 0, 0, 0, 0}, {1, 0, 1, 2, 19, 19, 0, 1}, {1, 0, 2, 2, 0, 0, 0, 1}, {33, 48, 6, 4, 3, 3, 48, 0}, {33, 48, 6, 4, 5, 5, 48, 3}, {33, 48, 6, 4, 5, 5, 48, 2}, {33, 48, 6, 4, 3, 3, 48, 1}};
    private static final short[] impAct1 = new short[]{0, 1, 13, 14};
    private static final ImpTabPair impTab_INVERSE_LIKE_DIRECT = new ImpTabPair(impTabL_DEFAULT, impTabR_INVERSE_LIKE_DIRECT, impAct0, impAct1);
    private static final byte[][] impTabL_INVERSE_LIKE_DIRECT_WITH_MARKS = new byte[][]{{0, 99, 0, 1, 0, 0, 0, 0}, {0, 99, 0, 1, 18, 48, 0, 4}, {32, 99, 32, 1, 2, 48, 32, 3}, {0, 99, 85, 86, 20, 48, 0, 3}, {48, 67, 85, 86, 4, 48, 48, 3}, {48, 67, 5, 86, 20, 48, 48, 4}, {48, 67, 85, 6, 20, 48, 48, 4}};
    private static final byte[][] impTabR_INVERSE_LIKE_DIRECT_WITH_MARKS = new byte[][]{{19, 0, 1, 1, 0, 0, 0, 0}, {35, 0, 1, 1, 2, 64, 0, 1}, {35, 0, 1, 1, 2, 64, 0, 0}, {3, 0, 3, 54, 20, 64, 0, 1}, {83, 64, 5, 54, 4, 64, 64, 0}, {83, 64, 5, 54, 4, 64, 64, 1}, {83, 64, 6, 6, 4, 64, 64, 3}};
    private static final short[] impAct2 = new short[]{0, 1, 2, 5, 6, 7, 8};
    private static final short[] impAct3 = new short[]{0, 1, 9, 10, 11, 12};
    private static final ImpTabPair impTab_INVERSE_LIKE_DIRECT_WITH_MARKS = new ImpTabPair(impTabL_INVERSE_LIKE_DIRECT_WITH_MARKS, impTabR_INVERSE_LIKE_DIRECT_WITH_MARKS, impAct2, impAct3);
    private static final ImpTabPair impTab_INVERSE_FOR_NUMBERS_SPECIAL = new ImpTabPair(impTabL_NUMBERS_SPECIAL, impTabR_INVERSE_LIKE_DIRECT, impAct0, impAct1);
    private static final byte[][] impTabL_INVERSE_FOR_NUMBERS_SPECIAL_WITH_MARKS = new byte[][]{{0, 98, 1, 1, 0, 0, 0, 0}, {0, 98, 1, 1, 0, 48, 0, 4}, {0, 98, 84, 84, 19, 48, 0, 3}, {48, 66, 84, 84, 3, 48, 48, 3}, {48, 66, 4, 4, 19, 48, 48, 4}};
    private static final ImpTabPair impTab_INVERSE_FOR_NUMBERS_SPECIAL_WITH_MARKS = new ImpTabPair(impTabL_INVERSE_FOR_NUMBERS_SPECIAL_WITH_MARKS, impTabR_INVERSE_LIKE_DIRECT_WITH_MARKS, impAct2, impAct3);
    static final int FIRSTALLOC = 10;
    public static final int DIRECTION_LEFT_TO_RIGHT = 0;
    public static final int DIRECTION_RIGHT_TO_LEFT = 1;
    public static final int DIRECTION_DEFAULT_LEFT_TO_RIGHT = 126;
    public static final int DIRECTION_DEFAULT_RIGHT_TO_LEFT = 127;

    static int DirPropFlag(byte by2) {
        return 1 << by2;
    }

    boolean testDirPropFlagAt(int n2, int n3) {
        return (Bidi.DirPropFlag(this.dirProps[n3]) & n2) != 0;
    }

    static final int DirPropFlagLR(byte by2) {
        return DirPropFlagLR[by2 & 1];
    }

    static final int DirPropFlagE(byte by2) {
        return DirPropFlagE[by2 & 1];
    }

    static final int DirPropFlagO(byte by2) {
        return DirPropFlagO[by2 & 1];
    }

    static final byte DirFromStrong(byte by2) {
        return by2 == 0 ? (byte)0 : 1;
    }

    static final byte NoOverride(byte by2) {
        return (byte)(by2 & 0x7F);
    }

    static byte GetLRFromLevel(byte by2) {
        return (byte)(by2 & 1);
    }

    static boolean IsDefaultLevel(byte by2) {
        return (by2 & 0x7E) == 126;
    }

    static boolean IsBidiControlChar(int n2) {
        return (n2 & 0xFFFFFFFC) == 8204 || n2 >= 8234 && n2 <= 8238 || n2 >= 8294 && n2 <= 8297;
    }

    void verifyValidPara() {
        if (this != this.paraBidi) {
            throw new IllegalStateException();
        }
    }

    void verifyValidParaOrLine() {
        Bidi bidi = this.paraBidi;
        if (this == bidi) {
            return;
        }
        if (bidi == null || bidi != bidi.paraBidi) {
            throw new IllegalStateException();
        }
    }

    void verifyRange(int n2, int n3, int n4) {
        if (n2 < n3 || n2 >= n4) {
            throw new IllegalArgumentException("Value " + n2 + " is out of range " + n3 + " to " + n4);
        }
    }

    public Bidi() {
        this(0, 0);
    }

    public Bidi(int n2, int n3) {
        if (n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException();
        }
        this.bdp = UBiDiProps.INSTANCE;
        if (n2 > 0) {
            this.getInitialDirPropsMemory(n2);
            this.getInitialLevelsMemory(n2);
        } else {
            this.mayAllocateText = true;
        }
        if (n3 > 0) {
            if (n3 > 1) {
                this.getInitialRunsMemory(n3);
            }
        } else {
            this.mayAllocateRuns = true;
        }
    }

    private Object getMemory(String string, Object object, Class<?> clazz, boolean bl2, int n2) {
        int n3 = Array.getLength(object);
        if (n2 == n3) {
            return object;
        }
        if (!bl2) {
            if (n2 <= n3) {
                return object;
            }
            throw new OutOfMemoryError("Failed to allocate memory for " + string);
        }
        try {
            return Array.newInstance(clazz, n2);
        }
        catch (Exception exception) {
            throw new OutOfMemoryError("Failed to allocate memory for " + string);
        }
    }

    private void getDirPropsMemory(boolean bl2, int n2) {
        Object object = this.getMemory("DirProps", this.dirPropsMemory, Byte.TYPE, bl2, n2);
        this.dirPropsMemory = (byte[])object;
    }

    void getDirPropsMemory(int n2) {
        this.getDirPropsMemory(this.mayAllocateText, n2);
    }

    private void getLevelsMemory(boolean bl2, int n2) {
        Object object = this.getMemory("Levels", this.levelsMemory, Byte.TYPE, bl2, n2);
        this.levelsMemory = (byte[])object;
    }

    void getLevelsMemory(int n2) {
        this.getLevelsMemory(this.mayAllocateText, n2);
    }

    private void getRunsMemory(boolean bl2, int n2) {
        Object object = this.getMemory("Runs", this.runsMemory, BidiRun.class, bl2, n2);
        this.runsMemory = (BidiRun[])object;
    }

    void getRunsMemory(int n2) {
        this.getRunsMemory(this.mayAllocateRuns, n2);
    }

    private void getInitialDirPropsMemory(int n2) {
        this.getDirPropsMemory(true, n2);
    }

    private void getInitialLevelsMemory(int n2) {
        this.getLevelsMemory(true, n2);
    }

    private void getInitialRunsMemory(int n2) {
        this.getRunsMemory(true, n2);
    }

    public void setInverse(boolean bl2) {
        this.isInverse = bl2;
        this.reorderingMode = bl2 ? 4 : 0;
    }

    public boolean isInverse() {
        return this.isInverse;
    }

    public void setReorderingMode(int n2) {
        if (n2 < 0 || n2 >= 7) {
            return;
        }
        this.reorderingMode = n2;
        this.isInverse = n2 == 4;
    }

    public int getReorderingMode() {
        return this.reorderingMode;
    }

    public void setReorderingOptions(int n2) {
        this.reorderingOptions = (n2 & 2) != 0 ? n2 & 0xFFFFFFFE : n2;
    }

    public int getReorderingOptions() {
        return this.reorderingOptions;
    }

    public static byte getBaseDirection(CharSequence charSequence) {
        if (charSequence == null || charSequence.length() == 0) {
            return 3;
        }
        int n2 = charSequence.length();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = UCharacter.codePointAt(charSequence, n3);
            byte by2 = UCharacter.getDirectionality(n4);
            if (by2 == 0) {
                return 0;
            }
            if (by2 == 1 || by2 == 13) {
                return 1;
            }
            n3 = UCharacter.offsetByCodePoints(charSequence, n3, 1);
        }
        return 3;
    }

    private byte firstL_R_AL() {
        int n2;
        int n3 = 10;
        for (int i2 = 0; i2 < this.prologue.length(); i2 += Character.charCount(n2)) {
            n2 = this.prologue.codePointAt(i2);
            int n4 = this.getCustomizedClass(n2);
            if (n3 != 10) continue;
            if (n4 != 0 && n4 != 1 && n4 != 13) continue;
            n3 = n4;
        }
        return (byte)n3;
    }

    private void checkParaCount() {
        int n2 = this.paraCount;
        if (n2 <= this.paras_level.length) {
            return;
        }
        int n3 = this.paras_level.length;
        int[] nArray = this.paras_limit;
        byte[] byArray = this.paras_level;
        try {
            this.paras_limit = new int[n2 * 2];
            this.paras_level = new byte[n2 * 2];
        }
        catch (Exception exception) {
            throw new OutOfMemoryError("Failed to allocate memory for paras");
        }
        System.arraycopy(nArray, 0, this.paras_limit, 0, n3);
        System.arraycopy(byArray, 0, this.paras_level, 0, n3);
    }

    private void getDirProps() {
        int n2;
        byte by2;
        int n3 = 0;
        this.flags = 0;
        byte by3 = 0;
        boolean bl2 = Bidi.IsDefaultLevel(this.paraLevel);
        boolean bl3 = bl2 && (this.reorderingMode == 5 || this.reorderingMode == 6);
        this.lastArabicPos = -1;
        int n4 = 0;
        boolean bl4 = (this.reorderingOptions & 2) != 0;
        int n5 = 10;
        int[] nArray = new int[126];
        byte[] byArray = new byte[126];
        int n6 = -1;
        if ((this.reorderingOptions & 4) != 0) {
            this.length = 0;
        }
        by3 = (byte)(this.paraLevel & 1);
        if (bl2) {
            this.paras_level[0] = by3;
            n5 = by3;
            if (this.prologue != null && (by2 = this.firstL_R_AL()) != 10) {
                this.paras_level[0] = by2 == 0 ? (byte)0 : 1;
                n2 = 0;
            } else {
                n2 = 1;
            }
        } else {
            this.paras_level[0] = this.paraLevel;
            n2 = 0;
        }
        n3 = 0;
        while (n3 < this.originalLength) {
            int n7 = n3;
            int n8 = UTF16.charAt(this.text, 0, this.originalLength, n3);
            int n9 = (n3 += UTF16.getCharCount(n8)) - 1;
            by2 = (byte)this.getCustomizedClass(n8);
            this.flags |= Bidi.DirPropFlag(by2);
            this.dirProps[n9] = by2;
            if (n9 > n7) {
                this.flags |= Bidi.DirPropFlag((byte)18);
                do {
                    this.dirProps[--n9] = 18;
                } while (n9 > n7);
            }
            if (bl4 && Bidi.IsBidiControlChar(n8)) {
                ++n4;
            }
            if (by2 == 0) {
                if (n2 == 1) {
                    this.paras_level[this.paraCount - 1] = 0;
                    n2 = 0;
                } else if (n2 == 2) {
                    if (n6 <= 125) {
                        this.flags |= Bidi.DirPropFlag((byte)20);
                    }
                    n2 = 3;
                }
                n5 = 0;
                continue;
            }
            if (by2 == 1 || by2 == 13) {
                if (n2 == 1) {
                    this.paras_level[this.paraCount - 1] = 1;
                    n2 = 0;
                } else if (n2 == 2) {
                    if (n6 <= 125) {
                        this.dirProps[nArray[n6]] = 21;
                        this.flags |= Bidi.DirPropFlag((byte)21);
                    }
                    n2 = 3;
                }
                n5 = 1;
                if (by2 != 13) continue;
                this.lastArabicPos = n3 - 1;
                continue;
            }
            if (by2 >= 19 && by2 <= 21) {
                if (++n6 <= 125) {
                    nArray[n6] = n3 - 1;
                    byArray[n6] = n2;
                }
                if (by2 == 19) {
                    this.dirProps[n3 - 1] = 20;
                    n2 = 2;
                    continue;
                }
                n2 = 3;
                continue;
            }
            if (by2 == 22) {
                if (n2 == 2 && n6 <= 125) {
                    this.flags |= Bidi.DirPropFlag((byte)20);
                }
                if (n6 < 0) continue;
                if (n6 <= 125) {
                    n2 = byArray[n6];
                }
                --n6;
                continue;
            }
            if (by2 != 7 || n3 < this.originalLength && n8 == 13 && this.text[n3] == '\n') continue;
            this.paras_limit[this.paraCount - 1] = n3;
            if (bl3 && n5 == 1) {
                this.paras_level[this.paraCount - 1] = 1;
            }
            if ((this.reorderingOptions & 4) != 0) {
                this.length = n3;
                this.controlCount = n4;
            }
            if (n3 >= this.originalLength) continue;
            ++this.paraCount;
            this.checkParaCount();
            if (bl2) {
                this.paras_level[this.paraCount - 1] = by3;
                n2 = 1;
                n5 = by3;
            } else {
                this.paras_level[this.paraCount - 1] = this.paraLevel;
                n2 = 0;
            }
            n6 = -1;
        }
        if (n6 > 125) {
            n6 = 125;
            n2 = 2;
        }
        while (n6 >= 0) {
            if (n2 == 2) {
                this.flags |= Bidi.DirPropFlag((byte)20);
                break;
            }
            n2 = byArray[n6];
            --n6;
        }
        if ((this.reorderingOptions & 4) != 0) {
            if (this.length < this.originalLength) {
                --this.paraCount;
            }
        } else {
            this.paras_limit[this.paraCount - 1] = this.originalLength;
            this.controlCount = n4;
        }
        if (bl3 && n5 == 1) {
            this.paras_level[this.paraCount - 1] = 1;
        }
        if (bl2) {
            this.paraLevel = this.paras_level[0];
        }
        for (n3 = 0; n3 < this.paraCount; ++n3) {
            this.flags |= Bidi.DirPropFlagLR(this.paras_level[n3]);
        }
        if (this.orderParagraphsLTR && (this.flags & Bidi.DirPropFlag((byte)7)) != 0) {
            this.flags |= Bidi.DirPropFlag((byte)0);
        }
    }

    byte GetParaLevelAt(int n2) {
        int n3;
        if (this.defaultParaLevel == 0 || n2 < this.paras_limit[0]) {
            return this.paraLevel;
        }
        for (n3 = 1; n3 < this.paraCount && n2 >= this.paras_limit[n3]; ++n3) {
        }
        if (n3 >= this.paraCount) {
            n3 = this.paraCount - 1;
        }
        return this.paras_level[n3];
    }

    private void bracketInit(BracketData bracketData) {
        bracketData.isoRunLast = 0;
        bracketData.isoRuns[0] = new IsoRun();
        bracketData.isoRuns[0].start = 0;
        bracketData.isoRuns[0].limit = 0;
        bracketData.isoRuns[0].level = this.GetParaLevelAt(0);
        bracketData.isoRuns[0].lastBase = bracketData.isoRuns[0].contextDir = (byte)(this.GetParaLevelAt(0) & 1);
        bracketData.isoRuns[0].lastStrong = bracketData.isoRuns[0].contextDir;
        bracketData.isoRuns[0].contextPos = 0;
        bracketData.openings = new Opening[20];
        bracketData.isNumbersSpecial = this.reorderingMode == 1 || this.reorderingMode == 6;
    }

    private void bracketProcessB(BracketData bracketData, byte by2) {
        bracketData.isoRunLast = 0;
        bracketData.isoRuns[0].limit = 0;
        bracketData.isoRuns[0].level = by2;
        bracketData.isoRuns[0].lastBase = bracketData.isoRuns[0].contextDir = (byte)(by2 & 1);
        bracketData.isoRuns[0].lastStrong = bracketData.isoRuns[0].contextDir;
        bracketData.isoRuns[0].contextPos = 0;
    }

    private void bracketProcessBoundary(BracketData bracketData, int n2, byte by2, byte by3) {
        IsoRun isoRun = bracketData.isoRuns[bracketData.isoRunLast];
        if ((Bidi.DirPropFlag(this.dirProps[n2]) & MASK_ISO) != 0) {
            return;
        }
        if (Bidi.NoOverride(by3) > Bidi.NoOverride(by2)) {
            by2 = by3;
        }
        isoRun.limit = isoRun.start;
        isoRun.level = by3;
        isoRun.lastBase = isoRun.contextDir = (byte)(by2 & 1);
        isoRun.lastStrong = isoRun.contextDir;
        isoRun.contextPos = n2;
    }

    private void bracketProcessLRI_RLI(BracketData bracketData, byte by2) {
        IsoRun isoRun = bracketData.isoRuns[bracketData.isoRunLast];
        isoRun.lastBase = (byte)10;
        short s2 = isoRun.limit;
        ++bracketData.isoRunLast;
        isoRun = bracketData.isoRuns[bracketData.isoRunLast];
        if (isoRun == null) {
            isoRun = bracketData.isoRuns[bracketData.isoRunLast] = new IsoRun();
        }
        isoRun.start = isoRun.limit = s2;
        isoRun.level = by2;
        isoRun.lastBase = isoRun.contextDir = (byte)(by2 & 1);
        isoRun.lastStrong = isoRun.contextDir;
        isoRun.contextPos = 0;
    }

    private void bracketProcessPDI(BracketData bracketData) {
        --bracketData.isoRunLast;
        IsoRun isoRun = bracketData.isoRuns[bracketData.isoRunLast];
        isoRun.lastBase = (byte)10;
    }

    private void bracketAddOpening(BracketData bracketData, char c2, int n2) {
        Opening opening;
        IsoRun isoRun = bracketData.isoRuns[bracketData.isoRunLast];
        if (isoRun.limit >= bracketData.openings.length) {
            int n3;
            Opening[] openingArray = bracketData.openings;
            try {
                n3 = bracketData.openings.length;
                bracketData.openings = new Opening[n3 * 2];
            }
            catch (Exception exception) {
                throw new OutOfMemoryError("Failed to allocate memory for openings");
            }
            System.arraycopy(openingArray, 0, bracketData.openings, 0, n3);
        }
        if ((opening = bracketData.openings[isoRun.limit]) == null) {
            opening = bracketData.openings[isoRun.limit] = new Opening();
        }
        opening.position = n2;
        opening.match = c2;
        opening.contextDir = isoRun.contextDir;
        opening.contextPos = isoRun.contextPos;
        opening.flags = 0;
        isoRun.limit = (short)(isoRun.limit + 1);
    }

    private void fixN0c(BracketData bracketData, int n2, int n3, byte by2) {
        IsoRun isoRun = bracketData.isoRuns[bracketData.isoRunLast];
        for (int i2 = n2 + 1; i2 < isoRun.limit; ++i2) {
            Opening opening = bracketData.openings[i2];
            if (opening.match >= 0) continue;
            if (n3 < opening.contextPos) break;
            if (n3 >= opening.position) continue;
            if (by2 == opening.contextDir) break;
            int n4 = opening.position;
            this.dirProps[n4] = by2;
            int n5 = -opening.match;
            this.dirProps[n5] = by2;
            opening.match = 0;
            this.fixN0c(bracketData, i2, n4, by2);
            this.fixN0c(bracketData, i2, n5, by2);
        }
    }

    private byte bracketProcessClosing(BracketData bracketData, int n2, int n3) {
        byte by2;
        IsoRun isoRun = bracketData.isoRuns[bracketData.isoRunLast];
        Opening opening = bracketData.openings[n2];
        byte by3 = (byte)(isoRun.level & 1);
        boolean bl2 = true;
        if (by3 == 0 && (opening.flags & FOUND_L) > 0 || by3 == 1 && (opening.flags & FOUND_R) > 0) {
            by2 = by3;
        } else if ((opening.flags & (FOUND_L | FOUND_R)) != 0) {
            boolean bl3 = bl2 = n2 == isoRun.start;
            by2 = by3 != opening.contextDir ? opening.contextDir : by3;
        } else {
            isoRun.limit = (short)n2;
            return 10;
        }
        this.dirProps[opening.position] = by2;
        this.dirProps[n3] = by2;
        this.fixN0c(bracketData, n2, opening.position, by2);
        if (bl2) {
            isoRun.limit = (short)n2;
            while (isoRun.limit > isoRun.start && bracketData.openings[isoRun.limit - 1].position == opening.position) {
                isoRun.limit = (short)(isoRun.limit - 1);
            }
        } else {
            opening.match = -n3;
            int n4 = n2 - 1;
            while (n4 >= isoRun.start && bracketData.openings[n4].position == opening.position) {
                bracketData.openings[n4--].match = 0;
            }
            for (n4 = n2 + 1; n4 < isoRun.limit; ++n4) {
                Opening opening2 = bracketData.openings[n4];
                if (opening2.position < n3) {
                    if (opening2.match <= 0) continue;
                    opening2.match = 0;
                    continue;
                }
                break;
            }
        }
        return by2;
    }

    private void bracketProcessChar(BracketData bracketData, int n2) {
        byte by2;
        char c2;
        byte by3;
        int n3;
        IsoRun isoRun = bracketData.isoRuns[bracketData.isoRunLast];
        byte by4 = this.dirProps[n2];
        if (by4 == 10) {
            n3 = this.text[n2];
            for (int i2 = isoRun.limit - 1; i2 >= isoRun.start; --i2) {
                if (bracketData.openings[i2].match != n3) continue;
                by3 = this.bracketProcessClosing(bracketData, i2, n2);
                if (by3 == 10) {
                    n3 = 0;
                    break;
                }
                isoRun.lastBase = (byte)10;
                isoRun.contextDir = by3;
                isoRun.contextPos = n2;
                byte by5 = this.levels[n2];
                if ((by5 & 0xFFFFFF80) != 0) {
                    isoRun.lastStrong = by3 = (byte)(by5 & 1);
                    short s2 = (short)Bidi.DirPropFlag(by3);
                    for (int i3 = isoRun.start; i3 < i2; ++i3) {
                        bracketData.openings[i3].flags = (short)(bracketData.openings[i3].flags | s2);
                    }
                    int n4 = n2;
                    this.levels[n4] = (byte)(this.levels[n4] & 0x7F);
                }
                int n5 = bracketData.openings[i2].position;
                this.levels[n5] = (byte)(this.levels[n5] & 0x7F);
                return;
            }
            if ((c2 = n3 != 0 ? (char)UCharacter.getBidiPairedBracket(n3) : (char)'\u0000') != n3 && UCharacter.getIntPropertyValue(n3, 4117) == 1) {
                if (c2 == '\u232a') {
                    this.bracketAddOpening(bracketData, '\u3009', n2);
                } else if (c2 == '\u3009') {
                    this.bracketAddOpening(bracketData, '\u232a', n2);
                }
                this.bracketAddOpening(bracketData, c2, n2);
            }
        }
        if (((by2 = this.levels[n2]) & 0xFFFFFF80) != 0) {
            by3 = (byte)(by2 & 1);
            if (by4 != 8 && by4 != 9 && by4 != 10) {
                this.dirProps[n2] = by3;
            }
            isoRun.lastBase = by3;
            isoRun.lastStrong = by3;
            isoRun.contextDir = by3;
            isoRun.contextPos = n2;
        } else if (by4 <= 1 || by4 == 13) {
            by3 = Bidi.DirFromStrong(by4);
            isoRun.lastBase = by4;
            isoRun.lastStrong = by4;
            isoRun.contextDir = by3;
            isoRun.contextPos = n2;
        } else if (by4 == 2) {
            isoRun.lastBase = (byte)2;
            if (isoRun.lastStrong == 0) {
                by3 = 0;
                if (!bracketData.isNumbersSpecial) {
                    this.dirProps[n2] = 23;
                }
                isoRun.contextDir = 0;
                isoRun.contextPos = n2;
            } else {
                by3 = 1;
                this.dirProps[n2] = isoRun.lastStrong == 13 ? 5 : 24;
                isoRun.contextDir = 1;
                isoRun.contextPos = n2;
            }
        } else if (by4 == 5) {
            by3 = 1;
            isoRun.lastBase = (byte)5;
            isoRun.contextDir = 1;
            isoRun.contextPos = n2;
        } else if (by4 == 17) {
            by3 = isoRun.lastBase;
            if (by3 == 10) {
                this.dirProps[n2] = by3;
            }
        } else {
            by3 = by4;
            isoRun.lastBase = by4;
        }
        if (by3 <= 1 || by3 == 13) {
            c2 = (char)Bidi.DirPropFlag(Bidi.DirFromStrong(by3));
            for (n3 = isoRun.start; n3 < isoRun.limit; ++n3) {
                if (n2 <= bracketData.openings[n3].position) continue;
                bracketData.openings[n3].flags = (short)(bracketData.openings[n3].flags | c2);
            }
        }
    }

    private byte directionFromFlags() {
        if ((this.flags & MASK_RTL) == 0 && ((this.flags & Bidi.DirPropFlag((byte)5)) == 0 || (this.flags & MASK_POSSIBLE_N) == 0)) {
            return 0;
        }
        if ((this.flags & MASK_LTR) == 0) {
            return 1;
        }
        return 2;
    }

    private byte resolveExplicitLevels() {
        int n2 = 0;
        byte by2 = this.GetParaLevelAt(0);
        this.isolateCount = 0;
        byte by3 = this.directionFromFlags();
        if (by3 != 2) {
            return by3;
        }
        if (this.reorderingMode > 1) {
            for (int i2 = 0; i2 < this.paraCount; ++i2) {
                int n3 = i2 == 0 ? 0 : this.paras_limit[i2 - 1];
                int n4 = this.paras_limit[i2];
                by2 = this.paras_level[i2];
                for (n2 = n3; n2 < n4; ++n2) {
                    this.levels[n2] = by2;
                }
            }
            return by3;
        }
        if ((this.flags & (MASK_EXPLICIT | MASK_ISO)) == 0) {
            BracketData bracketData = new BracketData();
            this.bracketInit(bracketData);
            for (int i3 = 0; i3 < this.paraCount; ++i3) {
                int n5 = i3 == 0 ? 0 : this.paras_limit[i3 - 1];
                int n6 = this.paras_limit[i3];
                by2 = this.paras_level[i3];
                for (n2 = n5; n2 < n6; ++n2) {
                    this.levels[n2] = by2;
                    byte by4 = this.dirProps[n2];
                    if (by4 == 18) continue;
                    if (by4 == 7) {
                        if (n2 + 1 >= this.length || this.text[n2] == '\r' && this.text[n2 + 1] == '\n') continue;
                        this.bracketProcessB(bracketData, by2);
                        continue;
                    }
                    this.bracketProcessChar(bracketData, n2);
                }
            }
            return by3;
        }
        byte by5 = by2;
        byte by6 = by2;
        int n7 = 0;
        short[] sArray = new short[127];
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        BracketData bracketData = new BracketData();
        this.bracketInit(bracketData);
        sArray[0] = by2;
        this.flags = 0;
        block12: for (n2 = 0; n2 < this.length; ++n2) {
            byte by7 = this.dirProps[n2];
            switch (by7) {
                case 11: 
                case 12: 
                case 14: 
                case 15: {
                    this.flags |= Bidi.DirPropFlag((byte)18);
                    this.levels[n2] = by6;
                    byte by8 = by7 == 11 || by7 == 12 ? (byte)(by5 + 2 & 0x7E) : (byte)(Bidi.NoOverride(by5) + 1 | 1);
                    if (by8 <= 125 && n9 == 0 && n10 == 0) {
                        n7 = n2;
                        by5 = by8;
                        if (by7 == 12 || by7 == 15) {
                            by5 = (byte)(by5 | 0xFFFFFF80);
                        }
                        sArray[++n8] = by5;
                        continue block12;
                    }
                    if (n9 != 0) continue block12;
                    ++n10;
                    continue block12;
                }
                case 16: {
                    this.flags |= Bidi.DirPropFlag((byte)18);
                    this.levels[n2] = by6;
                    if (n9 > 0) continue block12;
                    if (n10 > 0) {
                        --n10;
                        continue block12;
                    }
                    if (n8 <= 0 || sArray[n8] >= 256) continue block12;
                    n7 = n2;
                    by5 = (byte)sArray[--n8];
                    continue block12;
                }
                case 20: 
                case 21: {
                    this.flags |= Bidi.DirPropFlag((byte)10) | Bidi.DirPropFlagLR(by5);
                    this.levels[n2] = Bidi.NoOverride(by5);
                    if (Bidi.NoOverride(by5) != Bidi.NoOverride(by6)) {
                        this.bracketProcessBoundary(bracketData, n7, by6, by5);
                        this.flags |= DirPropFlagMultiRuns;
                    }
                    by6 = by5;
                    byte by8 = by7 == 20 ? (byte)(by5 + 2 & 0x7E) : (byte)(Bidi.NoOverride(by5) + 1 | 1);
                    if (by8 <= 125 && n9 == 0 && n10 == 0) {
                        this.flags |= Bidi.DirPropFlag(by7);
                        n7 = n2;
                        if (++n11 > this.isolateCount) {
                            this.isolateCount = n11;
                        }
                        by5 = by8;
                        sArray[++n8] = (short)(by5 + 256);
                        this.bracketProcessLRI_RLI(bracketData, by5);
                        continue block12;
                    }
                    this.dirProps[n2] = 9;
                    ++n9;
                    continue block12;
                }
                case 22: {
                    if (Bidi.NoOverride(by5) != Bidi.NoOverride(by6)) {
                        this.bracketProcessBoundary(bracketData, n7, by6, by5);
                        this.flags |= DirPropFlagMultiRuns;
                    }
                    if (n9 > 0) {
                        --n9;
                        this.dirProps[n2] = 9;
                    } else if (n11 > 0) {
                        this.flags |= Bidi.DirPropFlag((byte)22);
                        n7 = n2;
                        n10 = 0;
                        while (sArray[n8] < 256) {
                            --n8;
                        }
                        --n8;
                        --n11;
                        this.bracketProcessPDI(bracketData);
                    } else {
                        this.dirProps[n2] = 9;
                    }
                    by5 = (byte)(sArray[n8] & 0xFFFFFEFF);
                    this.flags |= Bidi.DirPropFlag((byte)10) | Bidi.DirPropFlagLR(by5);
                    by6 = by5;
                    this.levels[n2] = Bidi.NoOverride(by5);
                    continue block12;
                }
                case 7: {
                    this.flags |= Bidi.DirPropFlag((byte)7);
                    this.levels[n2] = this.GetParaLevelAt(n2);
                    if (n2 + 1 >= this.length || this.text[n2] == '\r' && this.text[n2 + 1] == '\n') continue block12;
                    n9 = 0;
                    n10 = 0;
                    n11 = 0;
                    n8 = 0;
                    by6 = by5 = this.GetParaLevelAt(n2 + 1);
                    sArray[0] = by5;
                    this.bracketProcessB(bracketData, by5);
                    continue block12;
                }
                case 18: {
                    this.levels[n2] = by6;
                    this.flags |= Bidi.DirPropFlag((byte)18);
                    continue block12;
                }
                default: {
                    if (Bidi.NoOverride(by5) != Bidi.NoOverride(by6)) {
                        this.bracketProcessBoundary(bracketData, n7, by6, by5);
                        this.flags |= DirPropFlagMultiRuns;
                        this.flags = (by5 & 0xFFFFFF80) != 0 ? (this.flags |= Bidi.DirPropFlagO(by5)) : (this.flags |= Bidi.DirPropFlagE(by5));
                    }
                    by6 = by5;
                    this.levels[n2] = by5;
                    this.bracketProcessChar(bracketData, n2);
                    this.flags |= Bidi.DirPropFlag(this.dirProps[n2]);
                }
            }
        }
        if ((this.flags & MASK_EMBEDDING) != 0) {
            this.flags |= Bidi.DirPropFlagLR(this.paraLevel);
        }
        if (this.orderParagraphsLTR && (this.flags & Bidi.DirPropFlag((byte)7)) != 0) {
            this.flags |= Bidi.DirPropFlag((byte)0);
        }
        by3 = this.directionFromFlags();
        return by3;
    }

    private byte checkExplicitLevels() {
        int n2 = 0;
        this.flags = 0;
        this.isolateCount = 0;
        int n3 = 0;
        int n4 = this.paras_limit[0];
        byte by2 = this.paraLevel;
        for (int i2 = 0; i2 < this.length; ++i2) {
            byte by3 = this.levels[i2];
            byte by4 = this.dirProps[i2];
            if (by4 == 20 || by4 == 21) {
                if (++n2 > this.isolateCount) {
                    this.isolateCount = n2;
                }
            } else if (by4 == 22) {
                --n2;
            } else if (by4 == 7) {
                n2 = 0;
            }
            if (this.defaultParaLevel != 0 && i2 == n4 && n3 + 1 < this.paraCount) {
                by2 = this.paras_level[++n3];
                n4 = this.paras_limit[n3];
            }
            int n5 = by3 & 0xFFFFFF80;
            if ((by3 = (byte)(by3 & 0x7F)) < by2 || 125 < by3) {
                if (by3 == 0) {
                    if (by4 != 7) {
                        by3 = by2;
                        this.levels[i2] = (byte)(by3 | n5);
                    }
                } else {
                    throw new IllegalArgumentException("level " + by3 + " out of bounds at " + i2);
                }
            }
            if (n5 != 0) {
                this.flags |= Bidi.DirPropFlagO(by3);
                continue;
            }
            this.flags |= Bidi.DirPropFlagE(by3) | Bidi.DirPropFlag(by4);
        }
        if ((this.flags & MASK_EMBEDDING) != 0) {
            this.flags |= Bidi.DirPropFlagLR(this.paraLevel);
        }
        return this.directionFromFlags();
    }

    private static short GetStateProps(short s2) {
        return (short)(s2 & 0x1F);
    }

    private static short GetActionProps(short s2) {
        return (short)(s2 >> 5);
    }

    private static short GetState(byte by2) {
        return (short)(by2 & 0xF);
    }

    private static short GetAction(byte by2) {
        return (short)(by2 >> 4);
    }

    private void addPoint(int n2, int n3) {
        Point point = new Point();
        int n4 = this.insertPoints.points.length;
        if (n4 == 0) {
            this.insertPoints.points = new Point[10];
            n4 = 10;
        }
        if (this.insertPoints.size >= n4) {
            Point[] pointArray = this.insertPoints.points;
            this.insertPoints.points = new Point[n4 * 2];
            System.arraycopy(pointArray, 0, this.insertPoints.points, 0, n4);
        }
        point.pos = n2;
        point.flag = n3;
        this.insertPoints.points[this.insertPoints.size] = point;
        ++this.insertPoints.size;
    }

    private void setLevelsOutsideIsolates(int n2, int n3, byte by2) {
        int n4 = 0;
        for (int i2 = n2; i2 < n3; ++i2) {
            byte by3 = this.dirProps[i2];
            if (by3 == 22) {
                --n4;
            }
            if (n4 == 0) {
                this.levels[i2] = by2;
            }
            if (by3 != 20 && by3 != 21) continue;
            ++n4;
        }
    }

    private void processPropertySeq(LevState levState, short s2, int n2, int n3) {
        int n4;
        byte by2;
        byte[][] byArray = levState.impTab;
        short[] sArray = levState.impAct;
        int n5 = n2;
        short s3 = levState.state;
        byte by3 = byArray[s3][s2];
        levState.state = Bidi.GetState(by3);
        short s4 = sArray[Bidi.GetAction(by3)];
        byte by4 = byArray[levState.state][7];
        if (s4 != 0) {
            switch (s4) {
                case 1: {
                    levState.startON = n5;
                    break;
                }
                case 2: {
                    n2 = levState.startON;
                    break;
                }
                case 3: {
                    by2 = (byte)(levState.runLevel + 1);
                    this.setLevelsOutsideIsolates(levState.startON, n5, by2);
                    break;
                }
                case 4: {
                    by2 = (byte)(levState.runLevel + 2);
                    this.setLevelsOutsideIsolates(levState.startON, n5, by2);
                    break;
                }
                case 5: {
                    if (levState.startL2EN >= 0) {
                        this.addPoint(levState.startL2EN, 1);
                    }
                    levState.startL2EN = -1;
                    if (this.insertPoints.points.length == 0 || this.insertPoints.size <= this.insertPoints.confirmed) {
                        levState.lastStrongRTL = -1;
                        by2 = byArray[s3][7];
                        if ((by2 & 1) != 0 && levState.startON > 0) {
                            n2 = levState.startON;
                        }
                        if (s2 != 5) break;
                        this.addPoint(n5, 1);
                        this.insertPoints.confirmed = this.insertPoints.size;
                        break;
                    }
                    for (n4 = levState.lastStrongRTL + 1; n4 < n5; ++n4) {
                        this.levels[n4] = (byte)(this.levels[n4] - 2 & 0xFFFFFFFE);
                    }
                    this.insertPoints.confirmed = this.insertPoints.size;
                    levState.lastStrongRTL = -1;
                    if (s2 != 5) break;
                    this.addPoint(n5, 1);
                    this.insertPoints.confirmed = this.insertPoints.size;
                    break;
                }
                case 6: {
                    if (this.insertPoints.points.length > 0) {
                        this.insertPoints.size = this.insertPoints.confirmed;
                    }
                    levState.startON = -1;
                    levState.startL2EN = -1;
                    levState.lastStrongRTL = n3 - 1;
                    break;
                }
                case 7: {
                    if (s2 == 3 && this.dirProps[n5] == 5 && this.reorderingMode != 6) {
                        if (levState.startL2EN == -1) {
                            levState.lastStrongRTL = n3 - 1;
                            break;
                        }
                        if (levState.startL2EN >= 0) {
                            this.addPoint(levState.startL2EN, 1);
                            levState.startL2EN = -2;
                        }
                        this.addPoint(n5, 1);
                        break;
                    }
                    if (levState.startL2EN != -1) break;
                    levState.startL2EN = n5;
                    break;
                }
                case 8: {
                    levState.lastStrongRTL = n3 - 1;
                    levState.startON = -1;
                    break;
                }
                case 9: {
                    for (n4 = n5 - 1; n4 >= 0 && (this.levels[n4] & 1) == 0; --n4) {
                    }
                    if (n4 >= 0) {
                        this.addPoint(n4, 4);
                        this.insertPoints.confirmed = this.insertPoints.size;
                    }
                    levState.startON = n5;
                    break;
                }
                case 10: {
                    this.addPoint(n5, 1);
                    this.addPoint(n5, 2);
                    break;
                }
                case 11: {
                    this.insertPoints.size = this.insertPoints.confirmed;
                    if (s2 != 5) break;
                    this.addPoint(n5, 4);
                    this.insertPoints.confirmed = this.insertPoints.size;
                    break;
                }
                case 12: {
                    by2 = (byte)(levState.runLevel + by4);
                    for (n4 = levState.startON; n4 < n5; ++n4) {
                        if (this.levels[n4] >= by2) continue;
                        this.levels[n4] = by2;
                    }
                    this.insertPoints.confirmed = this.insertPoints.size;
                    levState.startON = n5;
                    break;
                }
                case 13: {
                    by2 = levState.runLevel;
                    for (n4 = n5 - 1; n4 >= levState.startON; --n4) {
                        if (this.levels[n4] == by2 + 3) {
                            while (this.levels[n4] == by2 + 3) {
                                int n6 = n4--;
                                this.levels[n6] = (byte)(this.levels[n6] - 2);
                            }
                            while (this.levels[n4] == by2) {
                                --n4;
                            }
                        }
                        this.levels[n4] = this.levels[n4] == by2 + 2 ? by2 : (byte)(by2 + 1);
                    }
                    break;
                }
                case 14: {
                    by2 = (byte)(levState.runLevel + 1);
                    for (n4 = n5 - 1; n4 >= levState.startON; --n4) {
                        if (this.levels[n4] <= by2) continue;
                        int n7 = n4;
                        this.levels[n7] = (byte)(this.levels[n7] - 2);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Internal ICU error in processPropertySeq");
                }
            }
        }
        if (by4 != 0 || n2 < n5) {
            by2 = (byte)(levState.runLevel + by4);
            if (n2 >= levState.runStart) {
                for (n4 = n2; n4 < n3; ++n4) {
                    this.levels[n4] = by2;
                }
            } else {
                this.setLevelsOutsideIsolates(n2, n3, by2);
            }
        }
    }

    private byte lastL_R_AL() {
        int n2;
        for (int i2 = this.prologue.length(); i2 > 0; i2 -= Character.charCount(n2)) {
            n2 = this.prologue.codePointBefore(i2);
            byte by2 = (byte)this.getCustomizedClass(n2);
            if (by2 == 0) {
                return 0;
            }
            if (by2 != 1 && by2 != 13) continue;
            return 1;
        }
        return 4;
    }

    private byte firstL_R_AL_EN_AN() {
        int n2;
        for (int i2 = 0; i2 < this.epilogue.length(); i2 += Character.charCount(n2)) {
            n2 = this.epilogue.codePointAt(i2);
            byte by2 = (byte)this.getCustomizedClass(n2);
            if (by2 == 0) {
                return 0;
            }
            if (by2 == 1 || by2 == 13) {
                return 1;
            }
            if (by2 != 2) continue;
            return 2;
        }
        return 4;
    }

    private void resolveImplicitLevels(int n2, int n3, short s2, short s3) {
        byte by2;
        int n4;
        short s4;
        int n5;
        int n6;
        LevState levState = new LevState();
        int n7 = 1;
        int n8 = -1;
        boolean bl2 = n2 < this.lastArabicPos && (this.GetParaLevelAt(n2) & 1) > 0 && (this.reorderingMode == 5 || this.reorderingMode == 6);
        levState.startL2EN = -1;
        levState.lastStrongRTL = -1;
        levState.runStart = n2;
        levState.runLevel = this.levels[n2];
        levState.impTab = this.impTabPair.imptab[levState.runLevel & 1];
        levState.impAct = this.impTabPair.impact[levState.runLevel & 1];
        if (n2 == 0 && this.prologue != null && (n6 = this.lastL_R_AL()) != 4) {
            s2 = (short)n6;
        }
        if (this.dirProps[n2] == 22) {
            levState.startON = this.isolates[this.isolateCount].startON;
            n5 = this.isolates[this.isolateCount].start1;
            s4 = this.isolates[this.isolateCount].stateImp;
            levState.state = this.isolates[this.isolateCount].state;
            --this.isolateCount;
        } else {
            levState.startON = -1;
            n5 = n2;
            s4 = this.dirProps[n2] == 17 ? (short)(1 + s2) : (short)0;
            levState.state = 0;
            this.processPropertySeq(levState, s2, n2, n2);
        }
        int n9 = n2;
        block6: for (n4 = n2; n4 <= n3; ++n4) {
            short s5;
            if (n4 >= n3) {
                for (n6 = n3 - 1; n6 > n2 && (Bidi.DirPropFlag(this.dirProps[n6]) & MASK_BN_EXPLICIT) != 0; --n6) {
                }
                by2 = this.dirProps[n6];
                if (by2 == 20 || by2 == 21) break;
                s5 = s3;
            } else {
                n6 = this.dirProps[n4];
                if (n6 == 7) {
                    this.isolateCount = -1;
                }
                if (bl2) {
                    if (n6 == 13) {
                        n6 = 1;
                    } else if (n6 == 2) {
                        if (n8 <= n4) {
                            n7 = 1;
                            n8 = n3;
                            for (int i2 = n4 + 1; i2 < n3; ++i2) {
                                byte by3 = this.dirProps[i2];
                                if (by3 != 0 && by3 != 1 && by3 != 13) continue;
                                n7 = by3;
                                n8 = i2;
                                break;
                            }
                        }
                        if (n7 == 13) {
                            n6 = 5;
                        }
                    }
                }
                s5 = groupProp[n6];
            }
            short s6 = s4;
            short s7 = impTabProps[s6][s5];
            s4 = Bidi.GetStateProps(s7);
            short s8 = Bidi.GetActionProps(s7);
            if (n4 == n3 && s8 == 0) {
                s8 = 1;
            }
            if (s8 == 0) continue;
            short s9 = impTabProps[s6][15];
            switch (s8) {
                case 1: {
                    this.processPropertySeq(levState, s9, n5, n4);
                    n5 = n4;
                    continue block6;
                }
                case 2: {
                    n9 = n4;
                    continue block6;
                }
                case 3: {
                    this.processPropertySeq(levState, s9, n5, n9);
                    this.processPropertySeq(levState, (short)4, n9, n4);
                    n5 = n4;
                    continue block6;
                }
                case 4: {
                    this.processPropertySeq(levState, s9, n5, n9);
                    n5 = n9;
                    n9 = n4;
                    continue block6;
                }
                default: {
                    throw new IllegalStateException("Internal ICU error in resolveImplicitLevels");
                }
            }
        }
        if (n3 == this.length && this.epilogue != null && (n6 = (int)this.firstL_R_AL_EN_AN()) != 4) {
            s3 = (short)n6;
        }
        for (n4 = n3 - 1; n4 > n2 && (Bidi.DirPropFlag(this.dirProps[n4]) & MASK_BN_EXPLICIT) != 0; --n4) {
        }
        by2 = this.dirProps[n4];
        if ((by2 == 20 || by2 == 21) && n3 < this.length) {
            ++this.isolateCount;
            if (this.isolates[this.isolateCount] == null) {
                this.isolates[this.isolateCount] = new Isolate();
            }
            this.isolates[this.isolateCount].stateImp = s4;
            this.isolates[this.isolateCount].state = levState.state;
            this.isolates[this.isolateCount].start1 = n5;
            this.isolates[this.isolateCount].startON = levState.startON;
        } else {
            this.processPropertySeq(levState, s3, n3, n3);
        }
    }

    private void adjustWSLevels() {
        if ((this.flags & MASK_WS) != 0) {
            int n2 = this.trailingWSStart;
            block0: while (n2 > 0) {
                int n3;
                while (n2 > 0 && ((n3 = Bidi.DirPropFlag(this.dirProps[--n2])) & MASK_WS) != 0) {
                    if (this.orderParagraphsLTR && (n3 & Bidi.DirPropFlag((byte)7)) != 0) {
                        this.levels[n2] = 0;
                        continue;
                    }
                    this.levels[n2] = this.GetParaLevelAt(n2);
                }
                while (n2 > 0) {
                    if (((n3 = Bidi.DirPropFlag(this.dirProps[--n2])) & MASK_BN_EXPLICIT) != 0) {
                        this.levels[n2] = this.levels[n2 + 1];
                        continue;
                    }
                    if (this.orderParagraphsLTR && (n3 & Bidi.DirPropFlag((byte)7)) != 0) {
                        this.levels[n2] = 0;
                        continue block0;
                    }
                    if ((n3 & MASK_B_S) == 0) continue;
                    this.levels[n2] = this.GetParaLevelAt(n2);
                    continue block0;
                }
            }
        }
    }

    public void setContext(String string, String string2) {
        this.prologue = string != null && string.length() > 0 ? string : null;
        this.epilogue = string2 != null && string2.length() > 0 ? string2 : null;
    }

    private void setParaSuccess() {
        this.prologue = null;
        this.epilogue = null;
        this.paraBidi = this;
    }

    int Bidi_Min(int n2, int n3) {
        return n2 < n3 ? n2 : n3;
    }

    int Bidi_Abs(int n2) {
        return n2 >= 0 ? n2 : -n2;
    }

    void setParaRunsOnly(char[] cArray, byte by2) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        this.reorderingMode = 0;
        int n7 = cArray.length;
        if (n7 == 0) {
            this.setPara(cArray, by2, null);
            this.reorderingMode = 3;
            return;
        }
        int n8 = this.reorderingOptions;
        if ((n8 & 1) > 0) {
            this.reorderingOptions &= 0xFFFFFFFE;
            this.reorderingOptions |= 2;
        }
        by2 = (byte)(by2 & 1);
        this.setPara(cArray, by2, null);
        byte[] byArray = new byte[this.length];
        System.arraycopy(this.getLevels(), 0, byArray, 0, this.length);
        int n9 = this.trailingWSStart;
        String string = this.writeReordered(2);
        int[] nArray = this.getVisualMap();
        this.reorderingOptions = n8;
        int n10 = this.length;
        byte by3 = this.direction;
        this.reorderingMode = 5;
        by2 = (byte)(by2 ^ 1);
        this.setPara(string, by2, null);
        BidiLine.getRuns(this);
        int n11 = 0;
        int n12 = this.runCount;
        int n13 = 0;
        int n14 = 0;
        while (n14 < n12) {
            n6 = this.runs[n14].limit - n13;
            if (n6 >= 2) {
                n5 = this.runs[n14].start;
                for (n4 = n5 + 1; n4 < n5 + n6; ++n4) {
                    n3 = nArray[n4];
                    n2 = nArray[n4 - 1];
                    if (this.Bidi_Abs(n3 - n2) == 1 && byArray[n3] == byArray[n2]) continue;
                    ++n11;
                }
            }
            ++n14;
            n13 += n6;
        }
        if (n11 > 0) {
            this.getRunsMemory(n12 + n11);
            if (this.runCount == 1) {
                this.runsMemory[0] = this.runs[0];
            } else {
                System.arraycopy(this.runs, 0, this.runsMemory, 0, this.runCount);
            }
            this.runs = this.runsMemory;
            this.runCount += n11;
            for (n14 = n12; n14 < this.runCount; ++n14) {
                if (this.runs[n14] != null) continue;
                this.runs[n14] = new BidiRun(0, 0, 0);
            }
        }
        for (n14 = n12 - 1; n14 >= 0; --n14) {
            int n15;
            int n16;
            int n17;
            int n18;
            int n19 = n14 + n11;
            n6 = n14 == 0 ? this.runs[0].limit : this.runs[n14].limit - this.runs[n14 - 1].limit;
            n5 = this.runs[n14].start;
            int n20 = this.runs[n14].level & 1;
            if (n6 < 2) {
                if (n11 > 0) {
                    this.runs[n19].copyFrom(this.runs[n14]);
                }
                this.runs[n19].start = n18 = nArray[n5];
                this.runs[n19].level = (byte)(byArray[n18] ^ n20);
                continue;
            }
            if (n20 > 0) {
                n17 = n5;
                n16 = n5 + n6 - 1;
                n15 = 1;
            } else {
                n17 = n5 + n6 - 1;
                n16 = n5;
                n15 = -1;
            }
            for (n4 = n17; n4 != n16; n4 += n15) {
                int n21;
                n3 = nArray[n4];
                n2 = nArray[n4 + n15];
                if (this.Bidi_Abs(n3 - n2) == 1 && byArray[n3] == byArray[n2]) continue;
                this.runs[n19].start = n18 = this.Bidi_Min(nArray[n17], n3);
                this.runs[n19].level = (byte)(byArray[n18] ^ n20);
                this.runs[n19].limit = this.runs[n14].limit;
                this.runs[n14].limit -= this.Bidi_Abs(n4 - n17) + 1;
                this.runs[n19].insertRemove = n21 = this.runs[n14].insertRemove & 0xA;
                this.runs[n14].insertRemove &= ~n21;
                n17 = n4 + n15;
                --n11;
                --n19;
            }
            if (n11 > 0) {
                this.runs[n19].copyFrom(this.runs[n14]);
            }
            this.runs[n19].start = n18 = this.Bidi_Min(nArray[n17], nArray[n16]);
            this.runs[n19].level = (byte)(byArray[n18] ^ n20);
        }
        this.paraLevel = (byte)(this.paraLevel ^ 1);
        this.text = cArray;
        this.length = n10;
        this.originalLength = n7;
        this.direction = by3;
        this.levels = byArray;
        this.trailingWSStart = n9;
        if (this.runCount > 1) {
            this.direction = (byte)2;
        }
        this.reorderingMode = 3;
    }

    public void setPara(String string, byte by2, byte[] byArray) {
        if (string == null) {
            this.setPara(new char[0], by2, byArray);
        } else {
            this.setPara(string.toCharArray(), by2, byArray);
        }
    }

    public void setPara(char[] cArray, byte by2, byte[] byArray) {
        short s2;
        short s3;
        short s4;
        byte by3;
        byte by4;
        short s5;
        if (by2 < 126) {
            this.verifyRange(by2, 0, 126);
        }
        if (cArray == null) {
            cArray = new char[]{};
        }
        if (this.reorderingMode == 3) {
            this.setParaRunsOnly(cArray, by2);
            return;
        }
        this.paraBidi = null;
        this.text = cArray;
        this.originalLength = this.resultLength = this.text.length;
        this.length = this.resultLength;
        this.paraLevel = by2;
        this.direction = (byte)(by2 & 1);
        this.paraCount = 1;
        this.dirProps = new byte[0];
        this.levels = new byte[0];
        this.runs = new BidiRun[0];
        this.isGoodLogicalToVisualRunsMap = false;
        this.insertPoints.size = 0;
        this.insertPoints.confirmed = 0;
        byte by5 = this.defaultParaLevel = Bidi.IsDefaultLevel(by2) ? by2 : (byte)0;
        if (this.length == 0) {
            if (Bidi.IsDefaultLevel(by2)) {
                this.paraLevel = (byte)(this.paraLevel & 1);
                this.defaultParaLevel = 0;
            }
            this.flags = Bidi.DirPropFlagLR(by2);
            this.runCount = 0;
            this.paraCount = 0;
            this.setParaSuccess();
            return;
        }
        this.runCount = -1;
        this.getDirPropsMemory(this.length);
        this.dirProps = this.dirPropsMemory;
        this.getDirProps();
        this.trailingWSStart = this.length;
        if (byArray == null) {
            this.getLevelsMemory(this.length);
            this.levels = this.levelsMemory;
            this.direction = this.resolveExplicitLevels();
        } else {
            this.levels = byArray;
            this.direction = this.checkExplicitLevels();
        }
        if (this.isolateCount > 0 && (this.isolates == null || this.isolates.length < this.isolateCount)) {
            this.isolates = new Isolate[this.isolateCount + 3];
        }
        this.isolateCount = -1;
        switch (this.direction) {
            case 0: {
                this.trailingWSStart = 0;
                break;
            }
            case 1: {
                this.trailingWSStart = 0;
                break;
            }
            default: {
                switch (this.reorderingMode) {
                    case 0: {
                        this.impTabPair = impTab_DEFAULT;
                        break;
                    }
                    case 1: {
                        this.impTabPair = impTab_NUMBERS_SPECIAL;
                        break;
                    }
                    case 2: {
                        this.impTabPair = impTab_GROUP_NUMBERS_WITH_R;
                        break;
                    }
                    case 3: {
                        throw new InternalError("Internal ICU error in setPara");
                    }
                    case 4: {
                        this.impTabPair = impTab_INVERSE_NUMBERS_AS_L;
                        break;
                    }
                    case 5: {
                        if ((this.reorderingOptions & 1) != 0) {
                            this.impTabPair = impTab_INVERSE_LIKE_DIRECT_WITH_MARKS;
                            break;
                        }
                        this.impTabPair = impTab_INVERSE_LIKE_DIRECT;
                        break;
                    }
                    case 6: {
                        this.impTabPair = (this.reorderingOptions & 1) != 0 ? impTab_INVERSE_FOR_NUMBERS_SPECIAL_WITH_MARKS : impTab_INVERSE_FOR_NUMBERS_SPECIAL;
                    }
                }
                if (byArray == null && this.paraCount <= 1 && (this.flags & DirPropFlagMultiRuns) == 0) {
                    this.resolveImplicitLevels(0, this.length, Bidi.GetLRFromLevel(this.GetParaLevelAt(0)), Bidi.GetLRFromLevel(this.GetParaLevelAt(this.length - 1)));
                } else {
                    s5 = 0;
                    by4 = this.GetParaLevelAt(0);
                    s4 = by4 < (by3 = this.levels[0]) ? (short)Bidi.GetLRFromLevel(by3) : (short)Bidi.GetLRFromLevel(by4);
                    do {
                        s3 = s5;
                        by4 = by3;
                        s2 = s3 > 0 && this.dirProps[s3 - 1] == 7 ? (short)Bidi.GetLRFromLevel(this.GetParaLevelAt(s3)) : (short)s4;
                        while (++s5 < this.length && (this.levels[s5] == by4 || (Bidi.DirPropFlag(this.dirProps[s5]) & MASK_BN_EXPLICIT) != 0)) {
                        }
                        by3 = s5 < this.length ? this.levels[s5] : this.GetParaLevelAt(this.length - 1);
                        s4 = Bidi.NoOverride(by4) < Bidi.NoOverride(by3) ? (short)Bidi.GetLRFromLevel(by3) : (short)Bidi.GetLRFromLevel(by4);
                        if ((by4 & 0xFFFFFF80) == 0) {
                            this.resolveImplicitLevels(s3, s5, s2, s4);
                            continue;
                        }
                        do {
                            short s6 = s3++;
                            this.levels[s6] = (byte)(this.levels[s6] & 0x7F);
                        } while (s3 < s5);
                    } while (s5 < this.length);
                }
                this.adjustWSLevels();
            }
        }
        if (this.defaultParaLevel > 0 && (this.reorderingOptions & 1) != 0 && (this.reorderingMode == 5 || this.reorderingMode == 6)) {
            block16: for (s2 = 0; s2 < this.paraCount; ++s2) {
                s5 = this.paras_limit[s2] - 1;
                by4 = this.paras_level[s2];
                if (by4 == 0) continue;
                s3 = s2 == 0 ? (short)0 : this.paras_limit[s2 - 1];
                for (s4 = s5; s4 >= s3; --s4) {
                    by3 = this.dirProps[s4];
                    if (by3 == 0) {
                        if (s4 < s5) {
                            while (this.dirProps[s5] == 7) {
                                --s5;
                            }
                        }
                        this.addPoint(s5, 4);
                        continue block16;
                    }
                    if ((Bidi.DirPropFlag(by3) & MASK_R_AL) != 0) continue block16;
                }
            }
        }
        this.resultLength = (this.reorderingOptions & 2) != 0 ? (this.resultLength -= this.controlCount) : (this.resultLength += this.insertPoints.size);
        this.setParaSuccess();
    }

    public void setPara(AttributedCharacterIterator attributedCharacterIterator) {
        Serializable serializable;
        Boolean bl2 = (Boolean)attributedCharacterIterator.getAttribute(TextAttribute.RUN_DIRECTION);
        byte by2 = bl2 == null ? (byte)126 : (bl2.equals(TextAttribute.RUN_DIRECTION_LTR) ? (byte)0 : 1);
        byte[] byArray = null;
        int n2 = attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex();
        byte[] byArray2 = new byte[n2];
        char[] cArray = new char[n2];
        int n3 = 0;
        char c2 = attributedCharacterIterator.first();
        while (c2 != '\uffff') {
            byte by3;
            cArray[n3] = c2;
            serializable = (Integer)attributedCharacterIterator.getAttribute(TextAttribute.BIDI_EMBEDDING);
            if (serializable != null && (by3 = ((Integer)serializable).byteValue()) != 0) {
                if (by3 < 0) {
                    byArray = byArray2;
                    byArray2[n3] = (byte)(0 - by3 | 0xFFFFFF80);
                } else {
                    byArray = byArray2;
                    byArray2[n3] = by3;
                }
            }
            c2 = attributedCharacterIterator.next();
            ++n3;
        }
        serializable = (NumericShaper)attributedCharacterIterator.getAttribute(TextAttribute.NUMERIC_SHAPING);
        if (serializable != null) {
            ((NumericShaper)serializable).shape(cArray, 0, n2);
        }
        this.setPara(cArray, by2, byArray);
    }

    public void orderParagraphsLTR(boolean bl2) {
        this.orderParagraphsLTR = bl2;
    }

    public boolean isOrderParagraphsLTR() {
        return this.orderParagraphsLTR;
    }

    public byte getDirection() {
        this.verifyValidParaOrLine();
        return this.direction;
    }

    public String getTextAsString() {
        this.verifyValidParaOrLine();
        return new String(this.text);
    }

    public char[] getText() {
        this.verifyValidParaOrLine();
        return this.text;
    }

    public int getLength() {
        this.verifyValidParaOrLine();
        return this.originalLength;
    }

    public int getProcessedLength() {
        this.verifyValidParaOrLine();
        return this.length;
    }

    public int getResultLength() {
        this.verifyValidParaOrLine();
        return this.resultLength;
    }

    public byte getParaLevel() {
        this.verifyValidParaOrLine();
        return this.paraLevel;
    }

    public int countParagraphs() {
        this.verifyValidParaOrLine();
        return this.paraCount;
    }

    public BidiRun getParagraphByIndex(int n2) {
        this.verifyValidParaOrLine();
        this.verifyRange(n2, 0, this.paraCount);
        Bidi bidi = this.paraBidi;
        int n3 = n2 == 0 ? 0 : bidi.paras_limit[n2 - 1];
        BidiRun bidiRun = new BidiRun();
        bidiRun.start = n3;
        bidiRun.limit = bidi.paras_limit[n2];
        bidiRun.level = this.GetParaLevelAt(n3);
        return bidiRun;
    }

    public BidiRun getParagraph(int n2) {
        this.verifyValidParaOrLine();
        Bidi bidi = this.paraBidi;
        this.verifyRange(n2, 0, bidi.length);
        int n3 = 0;
        while (n2 >= bidi.paras_limit[n3]) {
            ++n3;
        }
        return this.getParagraphByIndex(n3);
    }

    public int getParagraphIndex(int n2) {
        this.verifyValidParaOrLine();
        Bidi bidi = this.paraBidi;
        this.verifyRange(n2, 0, bidi.length);
        int n3 = 0;
        while (n2 >= bidi.paras_limit[n3]) {
            ++n3;
        }
        return n3;
    }

    public void setCustomClassifier(BidiClassifier bidiClassifier) {
        this.customClassifier = bidiClassifier;
    }

    public BidiClassifier getCustomClassifier() {
        return this.customClassifier;
    }

    public int getCustomizedClass(int n2) {
        int n3;
        if (this.customClassifier == null || (n3 = this.customClassifier.classify(n2)) == 23) {
            n3 = this.bdp.getClass(n2);
        }
        if (n3 >= 23) {
            n3 = 10;
        }
        return n3;
    }

    public Bidi setLine(int n2, int n3) {
        this.verifyValidPara();
        this.verifyRange(n2, 0, n3);
        this.verifyRange(n3, 0, this.length + 1);
        if (this.getParagraphIndex(n2) != this.getParagraphIndex(n3 - 1)) {
            throw new IllegalArgumentException();
        }
        return BidiLine.setLine(this, n2, n3);
    }

    public byte getLevelAt(int n2) {
        this.verifyValidParaOrLine();
        this.verifyRange(n2, 0, this.length);
        return BidiLine.getLevelAt(this, n2);
    }

    public byte[] getLevels() {
        this.verifyValidParaOrLine();
        if (this.length <= 0) {
            return new byte[0];
        }
        return BidiLine.getLevels(this);
    }

    public BidiRun getLogicalRun(int n2) {
        this.verifyValidParaOrLine();
        this.verifyRange(n2, 0, this.length);
        return BidiLine.getLogicalRun(this, n2);
    }

    public int countRuns() {
        this.verifyValidParaOrLine();
        BidiLine.getRuns(this);
        return this.runCount;
    }

    public BidiRun getVisualRun(int n2) {
        this.verifyValidParaOrLine();
        BidiLine.getRuns(this);
        this.verifyRange(n2, 0, this.runCount);
        return BidiLine.getVisualRun(this, n2);
    }

    public int getVisualIndex(int n2) {
        this.verifyValidParaOrLine();
        this.verifyRange(n2, 0, this.length);
        return BidiLine.getVisualIndex(this, n2);
    }

    public int getLogicalIndex(int n2) {
        this.verifyValidParaOrLine();
        this.verifyRange(n2, 0, this.resultLength);
        if (this.insertPoints.size == 0 && this.controlCount == 0) {
            if (this.direction == 0) {
                return n2;
            }
            if (this.direction == 1) {
                return this.length - n2 - 1;
            }
        }
        BidiLine.getRuns(this);
        return BidiLine.getLogicalIndex(this, n2);
    }

    public int[] getLogicalMap() {
        this.countRuns();
        if (this.length <= 0) {
            return new int[0];
        }
        return BidiLine.getLogicalMap(this);
    }

    public int[] getVisualMap() {
        this.countRuns();
        if (this.resultLength <= 0) {
            return new int[0];
        }
        return BidiLine.getVisualMap(this);
    }

    public static int[] reorderLogical(byte[] byArray) {
        return BidiLine.reorderLogical(byArray);
    }

    public static int[] reorderVisual(byte[] byArray) {
        return BidiLine.reorderVisual(byArray);
    }

    public static int[] invertMap(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        return BidiLine.invertMap(nArray);
    }

    public Bidi(String string, int n2) {
        this(string.toCharArray(), 0, null, 0, string.length(), n2);
    }

    public Bidi(AttributedCharacterIterator attributedCharacterIterator) {
        this();
        this.setPara(attributedCharacterIterator);
    }

    public Bidi(char[] cArray, int n2, byte[] byArray, int n3, int n4, int n5) {
        this();
        byte[] byArray2;
        byte by2;
        switch (n5) {
            default: {
                by2 = 0;
                break;
            }
            case 1: {
                by2 = 1;
                break;
            }
            case 126: {
                by2 = 126;
                break;
            }
            case 127: {
                by2 = 127;
            }
        }
        if (byArray == null) {
            byArray2 = null;
        } else {
            byArray2 = new byte[n4];
            for (int i2 = 0; i2 < n4; ++i2) {
                byte by3 = byArray[i2 + n3];
                if (by3 < 0) {
                    by3 = (byte)(-by3 | 0xFFFFFF80);
                }
                byArray2[i2] = by3;
            }
        }
        if (n2 == 0 && n4 == cArray.length) {
            this.setPara(cArray, by2, byArray2);
        } else {
            char[] cArray2 = new char[n4];
            System.arraycopy(cArray, n2, cArray2, 0, n4);
            this.setPara(cArray2, by2, byArray2);
        }
    }

    public Bidi createLineBidi(int n2, int n3) {
        return this.setLine(n2, n3);
    }

    public boolean isMixed() {
        return !this.isLeftToRight() && !this.isRightToLeft();
    }

    public boolean isLeftToRight() {
        return this.getDirection() == 0 && (this.paraLevel & 1) == 0;
    }

    public boolean isRightToLeft() {
        return this.getDirection() == 1 && (this.paraLevel & 1) == 1;
    }

    public boolean baseIsLeftToRight() {
        return this.getParaLevel() == 0;
    }

    public int getBaseLevel() {
        return this.getParaLevel();
    }

    public int getRunCount() {
        return this.countRuns();
    }

    void getLogicalToVisualRunsMap() {
        int n2;
        if (this.isGoodLogicalToVisualRunsMap) {
            return;
        }
        int n3 = this.countRuns();
        if (this.logicalToVisualRunsMap == null || this.logicalToVisualRunsMap.length < n3) {
            this.logicalToVisualRunsMap = new int[n3];
        }
        long[] lArray = new long[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            lArray[n2] = ((long)this.runs[n2].start << 32) + (long)n2;
        }
        Arrays.sort(lArray);
        for (n2 = 0; n2 < n3; ++n2) {
            this.logicalToVisualRunsMap[n2] = (int)(lArray[n2] & 0xFFFFFFFFFFFFFFFFL);
        }
        this.isGoodLogicalToVisualRunsMap = true;
    }

    public int getRunLevel(int n2) {
        this.verifyValidParaOrLine();
        BidiLine.getRuns(this);
        this.verifyRange(n2, 0, this.runCount);
        this.getLogicalToVisualRunsMap();
        return this.runs[this.logicalToVisualRunsMap[n2]].level;
    }

    public int getRunStart(int n2) {
        this.verifyValidParaOrLine();
        BidiLine.getRuns(this);
        this.verifyRange(n2, 0, this.runCount);
        this.getLogicalToVisualRunsMap();
        return this.runs[this.logicalToVisualRunsMap[n2]].start;
    }

    public int getRunLimit(int n2) {
        this.verifyValidParaOrLine();
        BidiLine.getRuns(this);
        this.verifyRange(n2, 0, this.runCount);
        this.getLogicalToVisualRunsMap();
        int n3 = this.logicalToVisualRunsMap[n2];
        int n4 = n3 == 0 ? this.runs[n3].limit : this.runs[n3].limit - this.runs[n3 - 1].limit;
        return this.runs[n3].start + n4;
    }

    public static boolean requiresBidi(char[] cArray, int n2, int n3) {
        int n4 = 57378;
        for (int i2 = n2; i2 < n3; ++i2) {
            if ((1 << UCharacter.getDirection(cArray[i2]) & 0xE022) == 0) continue;
            return true;
        }
        return false;
    }

    public static void reorderVisually(byte[] byArray, int n2, Object[] objectArray, int n3, int n4) {
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, n2, byArray2, 0, n4);
        int[] nArray = Bidi.reorderVisual(byArray2);
        Object[] objectArray2 = new Object[n4];
        System.arraycopy(objectArray, n3, objectArray2, 0, n4);
        for (int i2 = 0; i2 < n4; ++i2) {
            objectArray[n3 + i2] = objectArray2[nArray[i2]];
        }
    }

    public String writeReordered(int n2) {
        this.verifyValidParaOrLine();
        if (this.length == 0) {
            return "";
        }
        return BidiWriter.writeReordered(this, n2);
    }

    public static String writeReverse(String string, int n2) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (string.length() > 0) {
            return BidiWriter.writeReverse(string, n2);
        }
        return "";
    }

    private static class LevState {
        byte[][] impTab;
        short[] impAct;
        int startON;
        int startL2EN;
        int lastStrongRTL;
        int runStart;
        short state;
        byte runLevel;

        private LevState() {
        }
    }

    private static class ImpTabPair {
        byte[][][] imptab;
        short[][] impact;

        ImpTabPair(byte[][] byArray, byte[][] byArray2, short[] sArray, short[] sArray2) {
            this.imptab = new byte[][][]{byArray, byArray2};
            this.impact = new short[][]{sArray, sArray2};
        }
    }

    static class Isolate {
        int startON;
        int start1;
        short stateImp;
        short state;

        Isolate() {
        }
    }

    static class BracketData {
        Opening[] openings = new Opening[20];
        int isoRunLast;
        IsoRun[] isoRuns = new IsoRun[127];
        boolean isNumbersSpecial;

        BracketData() {
        }
    }

    static class IsoRun {
        int contextPos;
        short start;
        short limit;
        byte level;
        byte lastStrong;
        byte lastBase;
        byte contextDir;

        IsoRun() {
        }
    }

    static class Opening {
        int position;
        int match;
        int contextPos;
        short flags;
        byte contextDir;

        Opening() {
        }
    }

    static class InsertPoints {
        int size;
        int confirmed;
        Point[] points = new Point[0];

        InsertPoints() {
        }
    }

    static class Point {
        int pos;
        int flag;

        Point() {
        }
    }
}

