/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.number;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalQuantity;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.MultiplierProducer;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.RoundingUtils;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.CurrencyPrecision;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.FractionPrecision;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.NumberFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.PluralRules;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Currency;

public abstract class Precision {
    MathContext mathContext = RoundingUtils.DEFAULT_MATH_CONTEXT_UNLIMITED;
    NumberFormatter.TrailingZeroDisplay trailingZeroDisplay;
    @Deprecated
    public static final BogusRounder BOGUS_PRECISION = new BogusRounder();
    static final InfiniteRounderImpl NONE = new InfiniteRounderImpl();
    static final FractionRounderImpl FIXED_FRAC_0 = new FractionRounderImpl(0, 0);
    static final FractionRounderImpl FIXED_FRAC_2 = new FractionRounderImpl(2, 2);
    static final FractionRounderImpl DEFAULT_MAX_FRAC_6 = new FractionRounderImpl(0, 6);
    static final SignificantRounderImpl FIXED_SIG_2 = new SignificantRounderImpl(2, 2);
    static final SignificantRounderImpl FIXED_SIG_3 = new SignificantRounderImpl(3, 3);
    static final SignificantRounderImpl RANGE_SIG_2_3 = new SignificantRounderImpl(2, 3);
    static final FracSigRounderImpl COMPACT_STRATEGY = new FracSigRounderImpl(0, 0, 1, 2, NumberFormatter.RoundingPriority.RELAXED, false);
    static final IncrementFiveRounderImpl NICKEL = new IncrementFiveRounderImpl(new BigDecimal("0.05"), 2, 2);
    static final CurrencyRounderImpl MONETARY_STANDARD = new CurrencyRounderImpl(Currency.CurrencyUsage.STANDARD);
    static final CurrencyRounderImpl MONETARY_CASH = new CurrencyRounderImpl(Currency.CurrencyUsage.CASH);

    Precision() {
    }

    public static Precision unlimited() {
        return Precision.constructInfinite();
    }

    public static FractionPrecision integer() {
        return Precision.constructFraction(0, 0);
    }

    public static FractionPrecision fixedFraction(int n2) {
        if (n2 >= 0 && n2 <= 999) {
            return Precision.constructFraction(n2, n2);
        }
        throw new IllegalArgumentException("Fraction length must be between 0 and 999 (inclusive)");
    }

    public static FractionPrecision minFraction(int n2) {
        if (n2 >= 0 && n2 <= 999) {
            return Precision.constructFraction(n2, -1);
        }
        throw new IllegalArgumentException("Fraction length must be between 0 and 999 (inclusive)");
    }

    public static FractionPrecision maxFraction(int n2) {
        if (n2 >= 0 && n2 <= 999) {
            return Precision.constructFraction(0, n2);
        }
        throw new IllegalArgumentException("Fraction length must be between 0 and 999 (inclusive)");
    }

    public static FractionPrecision minMaxFraction(int n2, int n3) {
        if (n2 >= 0 && n3 <= 999 && n2 <= n3) {
            return Precision.constructFraction(n2, n3);
        }
        throw new IllegalArgumentException("Fraction length must be between 0 and 999 (inclusive)");
    }

    public static Precision fixedSignificantDigits(int n2) {
        if (n2 >= 1 && n2 <= 999) {
            return Precision.constructSignificant(n2, n2);
        }
        throw new IllegalArgumentException("Significant digits must be between 1 and 999 (inclusive)");
    }

    public static Precision minSignificantDigits(int n2) {
        if (n2 >= 1 && n2 <= 999) {
            return Precision.constructSignificant(n2, -1);
        }
        throw new IllegalArgumentException("Significant digits must be between 1 and 999 (inclusive)");
    }

    public static Precision maxSignificantDigits(int n2) {
        if (n2 >= 1 && n2 <= 999) {
            return Precision.constructSignificant(1, n2);
        }
        throw new IllegalArgumentException("Significant digits must be between 1 and 999 (inclusive)");
    }

    public static Precision minMaxSignificantDigits(int n2, int n3) {
        if (n2 >= 1 && n3 <= 999 && n2 <= n3) {
            return Precision.constructSignificant(n2, n3);
        }
        throw new IllegalArgumentException("Significant digits must be between 1 and 999 (inclusive)");
    }

    public static Precision increment(BigDecimal bigDecimal) {
        if (bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
            return Precision.constructIncrement(bigDecimal);
        }
        throw new IllegalArgumentException("Rounding increment must be positive and non-null");
    }

    public static CurrencyPrecision currency(Currency.CurrencyUsage currencyUsage) {
        if (currencyUsage != null) {
            return Precision.constructCurrency(currencyUsage);
        }
        throw new IllegalArgumentException("CurrencyUsage must be non-null");
    }

    public Precision trailingZeroDisplay(NumberFormatter.TrailingZeroDisplay trailingZeroDisplay) {
        Precision precision = this.createCopy();
        precision.trailingZeroDisplay = trailingZeroDisplay;
        return precision;
    }

    @Deprecated
    public Precision withMode(MathContext mathContext) {
        if (this.mathContext.equals(mathContext)) {
            return this;
        }
        Precision precision = this.createCopy();
        precision.mathContext = mathContext;
        return precision;
    }

    abstract Precision createCopy();

    void createCopyHelper(Precision precision) {
        precision.mathContext = this.mathContext;
        precision.trailingZeroDisplay = this.trailingZeroDisplay;
    }

    @Deprecated
    public abstract void apply(DecimalQuantity var1);

    static Precision constructInfinite() {
        return NONE;
    }

    static FractionPrecision constructFraction(int n2, int n3) {
        if (n2 == 0 && n3 == 0) {
            return FIXED_FRAC_0;
        }
        if (n2 == 2 && n3 == 2) {
            return FIXED_FRAC_2;
        }
        if (n2 == 0 && n3 == 6) {
            return DEFAULT_MAX_FRAC_6;
        }
        return new FractionRounderImpl(n2, n3);
    }

    static Precision constructSignificant(int n2, int n3) {
        if (n2 == 2 && n3 == 2) {
            return FIXED_SIG_2;
        }
        if (n2 == 3 && n3 == 3) {
            return FIXED_SIG_3;
        }
        if (n2 == 2 && n3 == 3) {
            return RANGE_SIG_2_3;
        }
        return new SignificantRounderImpl(n2, n3);
    }

    static Precision constructFractionSignificant(FractionPrecision fractionPrecision, int n2, int n3, NumberFormatter.RoundingPriority roundingPriority, boolean bl2) {
        assert (fractionPrecision instanceof FractionRounderImpl);
        FractionRounderImpl fractionRounderImpl = (FractionRounderImpl)fractionPrecision;
        FracSigRounderImpl fracSigRounderImpl = fractionRounderImpl.minFrac == 0 && fractionRounderImpl.maxFrac == 0 && n2 == 1 && n3 == 2 && roundingPriority == NumberFormatter.RoundingPriority.RELAXED && !bl2 ? COMPACT_STRATEGY : new FracSigRounderImpl(fractionRounderImpl.minFrac, fractionRounderImpl.maxFrac, n2, n3, roundingPriority, bl2);
        return fracSigRounderImpl.withMode(fractionRounderImpl.mathContext);
    }

    static Precision constructIncrement(BigDecimal bigDecimal) {
        if (bigDecimal.equals(Precision.NICKEL.increment)) {
            return NICKEL;
        }
        BigDecimal bigDecimal2 = bigDecimal.stripTrailingZeros();
        if (bigDecimal2.precision() == 1) {
            int n2 = bigDecimal.scale();
            int n3 = bigDecimal2.scale();
            BigInteger bigInteger = bigDecimal2.unscaledValue();
            if (bigInteger.intValue() == 1) {
                return new IncrementOneRounderImpl(bigDecimal, n2, n3);
            }
            if (bigInteger.intValue() == 5) {
                return new IncrementFiveRounderImpl(bigDecimal, n2, n3);
            }
        }
        return new IncrementRounderImpl(bigDecimal);
    }

    static CurrencyPrecision constructCurrency(Currency.CurrencyUsage currencyUsage) {
        if (currencyUsage == Currency.CurrencyUsage.STANDARD) {
            return MONETARY_STANDARD;
        }
        if (currencyUsage == Currency.CurrencyUsage.CASH) {
            return MONETARY_CASH;
        }
        throw new AssertionError();
    }

    static Precision constructFromCurrency(CurrencyPrecision currencyPrecision, Currency currency) {
        Precision precision;
        assert (currencyPrecision instanceof CurrencyRounderImpl);
        CurrencyRounderImpl currencyRounderImpl = (CurrencyRounderImpl)currencyPrecision;
        double d2 = currency.getRoundingIncrement(currencyRounderImpl.usage);
        if (d2 != 0.0) {
            BigDecimal bigDecimal = BigDecimal.valueOf(d2);
            precision = Precision.constructIncrement(bigDecimal);
        } else {
            int n2 = currency.getDefaultFractionDigits(currencyRounderImpl.usage);
            precision = Precision.constructFraction(n2, n2);
        }
        return precision.withMode(currencyRounderImpl.mathContext);
    }

    Precision withLocaleData(Currency currency) {
        if (this instanceof CurrencyPrecision) {
            return ((CurrencyPrecision)this).withCurrency(currency);
        }
        return this;
    }

    int chooseMultiplierAndApply(DecimalQuantity decimalQuantity, MultiplierProducer multiplierProducer) {
        assert (!decimalQuantity.isZeroish());
        int n2 = decimalQuantity.getMagnitude();
        int n3 = multiplierProducer.getMultiplier(n2);
        decimalQuantity.adjustMagnitude(n3);
        this.apply(decimalQuantity);
        if (decimalQuantity.isZeroish()) {
            return n3;
        }
        if (decimalQuantity.getMagnitude() == n2 + n3) {
            return n3;
        }
        int n4 = multiplierProducer.getMultiplier(n2 + 1);
        if (n3 == n4) {
            return n3;
        }
        decimalQuantity.adjustMagnitude(n4 - n3);
        this.apply(decimalQuantity);
        return n4;
    }

    private static int getRoundingMagnitudeFraction(int n2) {
        if (n2 == -1) {
            return Integer.MIN_VALUE;
        }
        return -n2;
    }

    private static int getRoundingMagnitudeSignificant(DecimalQuantity decimalQuantity, int n2) {
        if (n2 == -1) {
            return Integer.MIN_VALUE;
        }
        int n3 = decimalQuantity.isZeroish() ? 0 : decimalQuantity.getMagnitude();
        return n3 - n2 + 1;
    }

    private static int getDisplayMagnitudeFraction(int n2) {
        if (n2 == 0) {
            return Integer.MAX_VALUE;
        }
        return -n2;
    }

    void setResolvedMinFraction(DecimalQuantity decimalQuantity, int n2) {
        if (this.trailingZeroDisplay == null || this.trailingZeroDisplay == NumberFormatter.TrailingZeroDisplay.AUTO || decimalQuantity.getPluralOperand(PluralRules.Operand.t) != 0.0) {
            decimalQuantity.setMinFraction(n2);
        }
    }

    private static int getDisplayMagnitudeSignificant(DecimalQuantity decimalQuantity, int n2) {
        int n3 = decimalQuantity.isZeroish() ? 0 : decimalQuantity.getMagnitude();
        return n3 - n2 + 1;
    }

    static class CurrencyRounderImpl
    extends CurrencyPrecision {
        final Currency.CurrencyUsage usage;

        public CurrencyRounderImpl(Currency.CurrencyUsage currencyUsage) {
            this.usage = currencyUsage;
        }

        @Override
        public void apply(DecimalQuantity decimalQuantity) {
            throw new AssertionError();
        }

        @Override
        CurrencyRounderImpl createCopy() {
            CurrencyRounderImpl currencyRounderImpl = new CurrencyRounderImpl(this.usage);
            this.createCopyHelper(currencyRounderImpl);
            return currencyRounderImpl;
        }
    }

    static class IncrementFiveRounderImpl
    extends IncrementRounderImpl {
        final int minFrac;
        final int maxFrac;

        public IncrementFiveRounderImpl(BigDecimal bigDecimal, int n2, int n3) {
            super(bigDecimal);
            this.minFrac = n2;
            this.maxFrac = n3;
        }

        @Override
        public void apply(DecimalQuantity decimalQuantity) {
            decimalQuantity.roundToNickel(-this.maxFrac, this.mathContext);
            this.setResolvedMinFraction(decimalQuantity, this.minFrac);
        }

        @Override
        IncrementFiveRounderImpl createCopy() {
            IncrementFiveRounderImpl incrementFiveRounderImpl = new IncrementFiveRounderImpl(this.increment, this.minFrac, this.maxFrac);
            this.createCopyHelper(incrementFiveRounderImpl);
            return incrementFiveRounderImpl;
        }
    }

    static class IncrementOneRounderImpl
    extends IncrementRounderImpl {
        final int minFrac;
        final int maxFrac;

        public IncrementOneRounderImpl(BigDecimal bigDecimal, int n2, int n3) {
            super(bigDecimal);
            this.minFrac = n2;
            this.maxFrac = n3;
        }

        @Override
        public void apply(DecimalQuantity decimalQuantity) {
            decimalQuantity.roundToMagnitude(-this.maxFrac, this.mathContext);
            this.setResolvedMinFraction(decimalQuantity, this.minFrac);
        }

        @Override
        IncrementOneRounderImpl createCopy() {
            IncrementOneRounderImpl incrementOneRounderImpl = new IncrementOneRounderImpl(this.increment, this.minFrac, this.maxFrac);
            this.createCopyHelper(incrementOneRounderImpl);
            return incrementOneRounderImpl;
        }
    }

    static class IncrementRounderImpl
    extends Precision {
        final BigDecimal increment;

        public IncrementRounderImpl(BigDecimal bigDecimal) {
            this.increment = bigDecimal;
        }

        @Override
        public void apply(DecimalQuantity decimalQuantity) {
            decimalQuantity.roundToIncrement(this.increment, this.mathContext);
            this.setResolvedMinFraction(decimalQuantity, Math.max(0, this.increment.scale()));
        }

        @Override
        IncrementRounderImpl createCopy() {
            IncrementRounderImpl incrementRounderImpl = new IncrementRounderImpl(this.increment);
            this.createCopyHelper(incrementRounderImpl);
            return incrementRounderImpl;
        }
    }

    static class FracSigRounderImpl
    extends Precision {
        final int minFrac;
        final int maxFrac;
        final int minSig;
        final int maxSig;
        final NumberFormatter.RoundingPriority priority;
        final boolean retain;

        public FracSigRounderImpl(int n2, int n3, int n4, int n5, NumberFormatter.RoundingPriority roundingPriority, boolean bl2) {
            this.minFrac = n2;
            this.maxFrac = n3;
            this.minSig = n4;
            this.maxSig = n5;
            this.priority = roundingPriority;
            this.retain = bl2;
        }

        @Override
        public void apply(DecimalQuantity decimalQuantity) {
            int n2;
            int n3;
            int n4 = Precision.getRoundingMagnitudeFraction(this.maxFrac);
            int n5 = Precision.getRoundingMagnitudeSignificant(decimalQuantity, this.maxSig);
            int n6 = this.priority == NumberFormatter.RoundingPriority.RELAXED ? Math.min(n4, n5) : Math.max(n4, n5);
            if (!decimalQuantity.isZeroish()) {
                n3 = decimalQuantity.getMagnitude();
                decimalQuantity.roundToMagnitude(n6, this.mathContext);
                if (!decimalQuantity.isZeroish() && decimalQuantity.getMagnitude() != n3 && n4 == n5) {
                    ++n5;
                }
            }
            n3 = Precision.getDisplayMagnitudeFraction(this.minFrac);
            int n7 = Precision.getDisplayMagnitudeSignificant(decimalQuantity, this.minSig);
            if (this.retain) {
                n2 = Math.min(n3, n7);
            } else if (this.priority == NumberFormatter.RoundingPriority.RELAXED) {
                n2 = n5 <= n4 ? n7 : n3;
            } else {
                assert (this.priority == NumberFormatter.RoundingPriority.STRICT);
                n2 = n5 <= n4 ? n3 : n7;
            }
            this.setResolvedMinFraction(decimalQuantity, Math.max(0, -n2));
        }

        @Override
        FracSigRounderImpl createCopy() {
            FracSigRounderImpl fracSigRounderImpl = new FracSigRounderImpl(this.minFrac, this.maxFrac, this.minSig, this.maxSig, this.priority, this.retain);
            this.createCopyHelper(fracSigRounderImpl);
            return fracSigRounderImpl;
        }
    }

    static class SignificantRounderImpl
    extends Precision {
        final int minSig;
        final int maxSig;

        public SignificantRounderImpl(int n2, int n3) {
            this.minSig = n2;
            this.maxSig = n3;
        }

        @Override
        public void apply(DecimalQuantity decimalQuantity) {
            decimalQuantity.roundToMagnitude(Precision.getRoundingMagnitudeSignificant(decimalQuantity, this.maxSig), this.mathContext);
            this.setResolvedMinFraction(decimalQuantity, Math.max(0, -Precision.getDisplayMagnitudeSignificant(decimalQuantity, this.minSig)));
            if (decimalQuantity.isZeroish() && this.minSig > 0) {
                decimalQuantity.setMinInteger(1);
            }
        }

        public void apply(DecimalQuantity decimalQuantity, int n2) {
            assert (decimalQuantity.isZeroish());
            this.setResolvedMinFraction(decimalQuantity, this.minSig - n2);
        }

        @Override
        SignificantRounderImpl createCopy() {
            SignificantRounderImpl significantRounderImpl = new SignificantRounderImpl(this.minSig, this.maxSig);
            this.createCopyHelper(significantRounderImpl);
            return significantRounderImpl;
        }
    }

    static class FractionRounderImpl
    extends FractionPrecision {
        final int minFrac;
        final int maxFrac;

        public FractionRounderImpl(int n2, int n3) {
            this.minFrac = n2;
            this.maxFrac = n3;
        }

        @Override
        public void apply(DecimalQuantity decimalQuantity) {
            decimalQuantity.roundToMagnitude(Precision.getRoundingMagnitudeFraction(this.maxFrac), this.mathContext);
            this.setResolvedMinFraction(decimalQuantity, Math.max(0, -Precision.getDisplayMagnitudeFraction(this.minFrac)));
        }

        @Override
        FractionRounderImpl createCopy() {
            FractionRounderImpl fractionRounderImpl = new FractionRounderImpl(this.minFrac, this.maxFrac);
            this.createCopyHelper(fractionRounderImpl);
            return fractionRounderImpl;
        }
    }

    static class InfiniteRounderImpl
    extends Precision {
        @Override
        public void apply(DecimalQuantity decimalQuantity) {
            decimalQuantity.roundToInfinity();
            this.setResolvedMinFraction(decimalQuantity, 0);
        }

        @Override
        InfiniteRounderImpl createCopy() {
            InfiniteRounderImpl infiniteRounderImpl = new InfiniteRounderImpl();
            this.createCopyHelper(infiniteRounderImpl);
            return infiniteRounderImpl;
        }
    }

    @Deprecated
    public static class BogusRounder
    extends Precision {
        @Deprecated
        public BogusRounder() {
        }

        @Override
        @Deprecated
        public void apply(DecimalQuantity decimalQuantity) {
            throw new AssertionError((Object)"BogusRounder must not be applied");
        }

        @Override
        BogusRounder createCopy() {
            BogusRounder bogusRounder = new BogusRounder();
            this.createCopyHelper(bogusRounder);
            return bogusRounder;
        }

        @Deprecated
        public Precision into(Precision precision) {
            Precision precision2 = precision.createCopy();
            this.createCopyHelper(precision2);
            return precision2;
        }
    }
}

