/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.number;

import java.util.MissingResourceException;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.FormattedStringBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.FormattedValueStringBuilderImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.PatternProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.SimpleFormatterImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StandardPlural;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.UResource;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalQuantity;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.MacroProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.MicroProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.Modifier;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.SimpleModifier;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.range.PrefixInfixSuffixLengthHelper;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.range.RangeMacroProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.range.StandardPluralRanges;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.FormattedNumberRange;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.LocalizedNumberFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.NumberFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.NumberFormatterImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.NumberRangeFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NumberFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundle;

class NumberRangeFormatterImpl {
    final NumberFormatterImpl formatterImpl1;
    final NumberFormatterImpl formatterImpl2;
    final boolean fSameFormatters;
    final NumberRangeFormatter.RangeCollapse fCollapse;
    final NumberRangeFormatter.RangeIdentityFallback fIdentityFallback;
    String fRangePattern;
    final NumberFormatterImpl fApproximatelyFormatter;
    final StandardPluralRanges fPluralRanges;

    int identity2d(NumberRangeFormatter.RangeIdentityFallback rangeIdentityFallback, NumberRangeFormatter.RangeIdentityResult rangeIdentityResult) {
        return rangeIdentityFallback.ordinal() | rangeIdentityResult.ordinal() << 4;
    }

    private static void getNumberRangeData(ULocale uLocale, String string, NumberRangeFormatterImpl numberRangeFormatterImpl) {
        StringBuilder stringBuilder = new StringBuilder();
        NumberRangeDataSink numberRangeDataSink = new NumberRangeDataSink(stringBuilder);
        ICUResourceBundle iCUResourceBundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", uLocale);
        stringBuilder.append("NumberElements/");
        stringBuilder.append(string);
        stringBuilder.append("/miscPatterns");
        String string2 = stringBuilder.toString();
        try {
            iCUResourceBundle.getAllItemsWithFallback(string2, numberRangeDataSink);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (!numberRangeDataSink.isComplete()) {
            iCUResourceBundle.getAllItemsWithFallback("NumberElements/latn/miscPatterns", numberRangeDataSink);
        }
        numberRangeDataSink.fillInDefaults();
        numberRangeFormatterImpl.fRangePattern = numberRangeDataSink.rangePattern;
    }

    public NumberRangeFormatterImpl(RangeMacroProps rangeMacroProps) {
        LocalizedNumberFormatter localizedNumberFormatter = rangeMacroProps.formatter1 != null ? rangeMacroProps.formatter1.locale(rangeMacroProps.loc) : NumberFormatter.withLocale(rangeMacroProps.loc);
        LocalizedNumberFormatter localizedNumberFormatter2 = rangeMacroProps.formatter2 != null ? rangeMacroProps.formatter2.locale(rangeMacroProps.loc) : NumberFormatter.withLocale(rangeMacroProps.loc);
        this.formatterImpl1 = new NumberFormatterImpl(localizedNumberFormatter.resolve());
        this.formatterImpl2 = new NumberFormatterImpl(localizedNumberFormatter2.resolve());
        this.fSameFormatters = rangeMacroProps.sameFormatters != 0;
        this.fCollapse = rangeMacroProps.collapse != null ? rangeMacroProps.collapse : NumberRangeFormatter.RangeCollapse.AUTO;
        this.fIdentityFallback = rangeMacroProps.identityFallback != null ? rangeMacroProps.identityFallback : NumberRangeFormatter.RangeIdentityFallback.APPROXIMATELY;
        String string = this.formatterImpl1.getRawMicroProps().nsName;
        if (string == null || !this.fSameFormatters && !string.equals(this.formatterImpl2.getRawMicroProps().nsName)) {
            throw new IllegalArgumentException("Both formatters must have same numbering system");
        }
        NumberRangeFormatterImpl.getNumberRangeData(rangeMacroProps.loc, string, this);
        if (this.fSameFormatters && (this.fIdentityFallback == NumberRangeFormatter.RangeIdentityFallback.APPROXIMATELY || this.fIdentityFallback == NumberRangeFormatter.RangeIdentityFallback.APPROXIMATELY_OR_SINGLE_VALUE)) {
            MacroProps macroProps = new MacroProps();
            macroProps.approximately = true;
            this.fApproximatelyFormatter = new NumberFormatterImpl(((LocalizedNumberFormatter)localizedNumberFormatter.macros(macroProps)).resolve());
        } else {
            this.fApproximatelyFormatter = null;
        }
        this.fPluralRanges = StandardPluralRanges.forLocale(rangeMacroProps.loc);
    }

    public FormattedNumberRange format(DecimalQuantity decimalQuantity, DecimalQuantity decimalQuantity2, boolean bl2) {
        FormattedStringBuilder formattedStringBuilder = new FormattedStringBuilder();
        MicroProps microProps = this.formatterImpl1.preProcess(decimalQuantity);
        MicroProps microProps2 = this.fSameFormatters ? this.formatterImpl1.preProcess(decimalQuantity2) : this.formatterImpl2.preProcess(decimalQuantity2);
        if (!(microProps.modInner.semanticallyEquivalent(microProps2.modInner) && microProps.modMiddle.semanticallyEquivalent(microProps2.modMiddle) && microProps.modOuter.semanticallyEquivalent(microProps2.modOuter))) {
            this.formatRange(decimalQuantity, decimalQuantity2, formattedStringBuilder, microProps, microProps2);
            return new FormattedNumberRange(formattedStringBuilder, decimalQuantity, decimalQuantity2, NumberRangeFormatter.RangeIdentityResult.NOT_EQUAL);
        }
        NumberRangeFormatter.RangeIdentityResult rangeIdentityResult = bl2 ? NumberRangeFormatter.RangeIdentityResult.EQUAL_BEFORE_ROUNDING : (decimalQuantity.equals(decimalQuantity2) ? NumberRangeFormatter.RangeIdentityResult.EQUAL_AFTER_ROUNDING : NumberRangeFormatter.RangeIdentityResult.NOT_EQUAL);
        switch (this.identity2d(this.fIdentityFallback, rangeIdentityResult)) {
            case 3: 
            case 19: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                this.formatRange(decimalQuantity, decimalQuantity2, formattedStringBuilder, microProps, microProps2);
                break;
            }
            case 2: 
            case 17: 
            case 18: {
                this.formatApproximately(decimalQuantity, decimalQuantity2, formattedStringBuilder, microProps, microProps2);
                break;
            }
            case 0: 
            case 1: 
            case 16: {
                this.formatSingleValue(decimalQuantity, decimalQuantity2, formattedStringBuilder, microProps, microProps2);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return new FormattedNumberRange(formattedStringBuilder, decimalQuantity, decimalQuantity2, rangeIdentityResult);
    }

    private void formatSingleValue(DecimalQuantity decimalQuantity, DecimalQuantity decimalQuantity2, FormattedStringBuilder formattedStringBuilder, MicroProps microProps, MicroProps microProps2) {
        if (this.fSameFormatters) {
            int n2 = NumberFormatterImpl.writeNumber(microProps, decimalQuantity, formattedStringBuilder, 0);
            NumberFormatterImpl.writeAffixes(microProps, formattedStringBuilder, 0, n2);
        } else {
            this.formatRange(decimalQuantity, decimalQuantity2, formattedStringBuilder, microProps, microProps2);
        }
    }

    private void formatApproximately(DecimalQuantity decimalQuantity, DecimalQuantity decimalQuantity2, FormattedStringBuilder formattedStringBuilder, MicroProps microProps, MicroProps microProps2) {
        if (this.fSameFormatters) {
            decimalQuantity.resetExponent();
            MicroProps microProps3 = this.fApproximatelyFormatter.preProcess(decimalQuantity);
            int n2 = NumberFormatterImpl.writeNumber(microProps3, decimalQuantity, formattedStringBuilder, 0);
            n2 += microProps3.modInner.apply(formattedStringBuilder, 0, n2);
            n2 += microProps3.modMiddle.apply(formattedStringBuilder, 0, n2);
            microProps3.modOuter.apply(formattedStringBuilder, 0, n2);
        } else {
            this.formatRange(decimalQuantity, decimalQuantity2, formattedStringBuilder, microProps, microProps2);
        }
    }

    private void formatRange(DecimalQuantity decimalQuantity, DecimalQuantity decimalQuantity2, FormattedStringBuilder formattedStringBuilder, MicroProps microProps, MicroProps microProps2) {
        boolean bl2;
        Object object;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        switch (this.fCollapse) {
            case ALL: 
            case AUTO: 
            case UNIT: {
                bl5 = microProps.modOuter.semanticallyEquivalent(microProps2.modOuter);
                if (!bl5) {
                    bl4 = false;
                    bl3 = false;
                    break;
                }
                bl4 = microProps.modMiddle.semanticallyEquivalent(microProps2.modMiddle);
                if (!bl4) {
                    bl3 = false;
                    break;
                }
                object = microProps.modMiddle;
                if (this.fCollapse == NumberRangeFormatter.RangeCollapse.UNIT) {
                    if (!object.containsField(NumberFormat.Field.CURRENCY) && !object.containsField(NumberFormat.Field.PERCENT)) {
                        bl4 = false;
                    }
                } else if (this.fCollapse == NumberRangeFormatter.RangeCollapse.AUTO && object.getCodePointCount() <= 1) {
                    bl4 = false;
                }
                if (!bl4 || this.fCollapse != NumberRangeFormatter.RangeCollapse.ALL) {
                    bl3 = false;
                    break;
                }
                bl3 = microProps.modInner.semanticallyEquivalent(microProps2.modInner);
                break;
            }
            default: {
                bl5 = false;
                bl4 = false;
                bl3 = false;
            }
        }
        object = new PrefixInfixSuffixLengthHelper();
        SimpleModifier.formatTwoArgPattern(this.fRangePattern, formattedStringBuilder, 0, (PrefixInfixSuffixLengthHelper)object, null);
        assert (((PrefixInfixSuffixLengthHelper)object).lengthInfix > 0);
        boolean bl6 = !bl3 && microProps.modInner.getCodePointCount() > 0;
        boolean bl7 = !bl4 && microProps.modMiddle.getCodePointCount() > 0;
        boolean bl8 = bl2 = !bl5 && microProps.modOuter.getCodePointCount() > 0;
        if (bl6 || bl7 || bl2) {
            if (!PatternProps.isWhiteSpace(formattedStringBuilder.charAt(((PrefixInfixSuffixLengthHelper)object).index1()))) {
                ((PrefixInfixSuffixLengthHelper)object).lengthInfix += formattedStringBuilder.insertCodePoint(((PrefixInfixSuffixLengthHelper)object).index1(), 32, null);
            }
            if (!PatternProps.isWhiteSpace(formattedStringBuilder.charAt(((PrefixInfixSuffixLengthHelper)object).index2() - 1))) {
                ((PrefixInfixSuffixLengthHelper)object).lengthInfix += formattedStringBuilder.insertCodePoint(((PrefixInfixSuffixLengthHelper)object).index2(), 32, null);
            }
        }
        ((PrefixInfixSuffixLengthHelper)object).length1 += NumberFormatterImpl.writeNumber(microProps, decimalQuantity, formattedStringBuilder, ((PrefixInfixSuffixLengthHelper)object).index0());
        FormattedStringBuilder formattedStringBuilder2 = new FormattedStringBuilder();
        NumberFormatterImpl.writeNumber(microProps2, decimalQuantity2, formattedStringBuilder2, 0);
        ((PrefixInfixSuffixLengthHelper)object).length2 += formattedStringBuilder.insert(((PrefixInfixSuffixLengthHelper)object).index2(), formattedStringBuilder2);
        if (bl3) {
            Modifier modifier = this.resolveModifierPlurals(microProps.modInner, microProps2.modInner);
            ((PrefixInfixSuffixLengthHelper)object).lengthSuffix += modifier.apply(formattedStringBuilder, ((PrefixInfixSuffixLengthHelper)object).index0(), ((PrefixInfixSuffixLengthHelper)object).index4());
            ((PrefixInfixSuffixLengthHelper)object).lengthPrefix += modifier.getPrefixLength();
            ((PrefixInfixSuffixLengthHelper)object).lengthSuffix -= modifier.getPrefixLength();
        } else {
            ((PrefixInfixSuffixLengthHelper)object).length1 += microProps.modInner.apply(formattedStringBuilder, ((PrefixInfixSuffixLengthHelper)object).index0(), ((PrefixInfixSuffixLengthHelper)object).index1());
            ((PrefixInfixSuffixLengthHelper)object).length2 += microProps2.modInner.apply(formattedStringBuilder, ((PrefixInfixSuffixLengthHelper)object).index2(), ((PrefixInfixSuffixLengthHelper)object).index4());
        }
        if (bl4) {
            Modifier modifier = this.resolveModifierPlurals(microProps.modMiddle, microProps2.modMiddle);
            ((PrefixInfixSuffixLengthHelper)object).lengthSuffix += modifier.apply(formattedStringBuilder, ((PrefixInfixSuffixLengthHelper)object).index0(), ((PrefixInfixSuffixLengthHelper)object).index4());
            ((PrefixInfixSuffixLengthHelper)object).lengthPrefix += modifier.getPrefixLength();
            ((PrefixInfixSuffixLengthHelper)object).lengthSuffix -= modifier.getPrefixLength();
        } else {
            ((PrefixInfixSuffixLengthHelper)object).length1 += microProps.modMiddle.apply(formattedStringBuilder, ((PrefixInfixSuffixLengthHelper)object).index0(), ((PrefixInfixSuffixLengthHelper)object).index1());
            ((PrefixInfixSuffixLengthHelper)object).length2 += microProps2.modMiddle.apply(formattedStringBuilder, ((PrefixInfixSuffixLengthHelper)object).index2(), ((PrefixInfixSuffixLengthHelper)object).index4());
        }
        if (bl5) {
            Modifier modifier = this.resolveModifierPlurals(microProps.modOuter, microProps2.modOuter);
            ((PrefixInfixSuffixLengthHelper)object).lengthSuffix += modifier.apply(formattedStringBuilder, ((PrefixInfixSuffixLengthHelper)object).index0(), ((PrefixInfixSuffixLengthHelper)object).index4());
            ((PrefixInfixSuffixLengthHelper)object).lengthPrefix += modifier.getPrefixLength();
            ((PrefixInfixSuffixLengthHelper)object).lengthSuffix -= modifier.getPrefixLength();
        } else {
            ((PrefixInfixSuffixLengthHelper)object).length1 += microProps.modOuter.apply(formattedStringBuilder, ((PrefixInfixSuffixLengthHelper)object).index0(), ((PrefixInfixSuffixLengthHelper)object).index1());
            ((PrefixInfixSuffixLengthHelper)object).length2 += microProps2.modOuter.apply(formattedStringBuilder, ((PrefixInfixSuffixLengthHelper)object).index2(), ((PrefixInfixSuffixLengthHelper)object).index4());
        }
        FormattedValueStringBuilderImpl.applySpanRange(formattedStringBuilder, NumberRangeFormatter.SpanField.NUMBER_RANGE_SPAN, 0, ((PrefixInfixSuffixLengthHelper)object).index0(), ((PrefixInfixSuffixLengthHelper)object).index1());
        FormattedValueStringBuilderImpl.applySpanRange(formattedStringBuilder, NumberRangeFormatter.SpanField.NUMBER_RANGE_SPAN, 1, ((PrefixInfixSuffixLengthHelper)object).index2(), ((PrefixInfixSuffixLengthHelper)object).index3());
    }

    Modifier resolveModifierPlurals(Modifier modifier, Modifier modifier2) {
        Modifier.Parameters parameters = modifier.getParameters();
        if (parameters == null) {
            return modifier;
        }
        Modifier.Parameters parameters2 = modifier2.getParameters();
        if (parameters2 == null) {
            return modifier;
        }
        StandardPlural standardPlural = this.fPluralRanges.resolve(parameters.plural, parameters2.plural);
        Modifier modifier3 = parameters.obj.getModifier(parameters.signum, standardPlural);
        assert (modifier3 != null);
        return modifier3;
    }

    private static final class NumberRangeDataSink
    extends UResource.Sink {
        String rangePattern;
        StringBuilder sb;

        NumberRangeDataSink(StringBuilder stringBuilder) {
            this.sb = stringBuilder;
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean bl2) {
            UResource.Table table = value.getTable();
            int n2 = 0;
            while (table.getKeyAndValue(n2, key, value)) {
                if (key.contentEquals("range") && !this.hasRangeData()) {
                    String string = value.getString();
                    this.rangePattern = SimpleFormatterImpl.compileToStringMinMaxArguments(string, this.sb, 2, 2);
                }
                ++n2;
            }
        }

        private boolean hasRangeData() {
            return this.rangePattern != null;
        }

        public boolean isComplete() {
            return this.hasRangeData();
        }

        public void fillInDefaults() {
            if (!this.hasRangeData()) {
                this.rangePattern = SimpleFormatterImpl.compileToStringMinMaxArguments("{0}\u2013{1}", this.sb, 2, 2);
            }
        }
    }
}

